/*
 * Decompiled with CFR 0.152.
 */
package widgets;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class IntegerTextField
extends JTextField {
    private final int size;
    private final ActionListener actionListener;
    private final int signBit;
    private final int maxValue;

    public IntegerTextField(int n, int n2, boolean bl) {
        this(n, n2, bl, null);
    }

    public IntegerTextField(int n, int n2, boolean bl, ActionListener actionListener) {
        super(n * 3);
        this.signBit = bl ? 1 << 8 * n - 1 : 1 << 8 * n;
        this.maxValue = this.signBit - 1;
        this.size = n;
        this.setDocument(new PlainDocument(){

            @Override
            public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
                if (this.getLength() >= IntegerTextField.this.getMaxLength()) {
                    return;
                }
                if (IntegerTextField.this.isSigned() && n == 0 && string.length() > 0 && string.charAt(0) == '-') {
                    super.insertString(n, "-" + string.substring(1).replaceAll("[^" + IntegerTextField.this.getAllowedCharClass() + "]", ""), attributeSet);
                } else {
                    super.insertString(n, string.replaceAll("[^" + IntegerTextField.this.getAllowedCharClass() + "]", ""), attributeSet);
                }
                if (this.getLength() > 0) {
                    IntegerTextField.this.actionPerformed();
                }
            }

            @Override
            public void remove(int n, int n2) throws BadLocationException {
                super.remove(n, n2);
                if (this.getLength() > 0) {
                    IntegerTextField.this.actionPerformed();
                }
            }
        });
        this.setValue(n2);
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                JTextField jTextField = (JTextField)focusEvent.getComponent();
                jTextField.setText(IntegerTextField.this.getValueString());
            }
        });
        this.actionListener = actionListener;
    }

    protected String getAllowedCharClass() {
        return "0-9";
    }

    protected int getMaxLength() {
        return this.size * 3;
    }

    protected String getValueString() {
        int n = this.getValue();
        if ((n & this.signBit) != 0) {
            return Integer.toString(-(~n & this.maxValue) - 1);
        }
        return Integer.toString(n);
    }

    protected void actionPerformed() {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, null));
        }
    }

    protected boolean isSigned() {
        return this.signBit == 1 << 8 * this.size - 1;
    }

    public void setValue(int n) {
        if ((n & this.signBit) != 0) {
            n = -((~n & this.maxValue) + 1);
        } else if (n > this.maxValue) {
            n = this.maxValue;
        }
        this.setText(Integer.toString(n));
    }

    public int getValue() {
        try {
            int n = Integer.parseInt(this.getText());
            if (n < -this.signBit) {
                return this.signBit;
            }
            if (n < 0) {
                return this.signBit | n & this.maxValue;
            }
            if (n > this.maxValue) {
                return this.maxValue;
            }
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }
}

