/*
 * Decompiled with CFR 0.152.
 */
package panels;

import changes.Change;
import changes.ChangeListener;
import data.Palette;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.util.LinkedList;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import mastersystem.Renderer;

public class TilePanel
extends JPanel {
    private BufferedImage image = new BufferedImage(8, 8, 1);
    private Color[] colors = new Color[32];
    private int[] tile;
    private Palette palette;
    private int pal;
    private int selectedPixel = -1;
    private boolean pipette;
    private final LinkedList<ActionListener> listeners = new LinkedList();
    private final ChangeListener paletteChangeListener = new ChangeListener(){

        @Override
        public void changeOccurred(Change change) {
            int n = change.getData(TilePanel.this.palette);
            if (n < 0) {
                int n2 = -n - 1;
                if (n2 == 2 || n2 == TilePanel.this.pal) {
                    int n3 = TilePanel.this.pal * 16;
                    int n4 = n3 + 16;
                    int n5 = n3;
                    while (n5 < n4) {
                        int n6 = TilePanel.this.palette.getColors()[n5];
                        int n7 = (n6 & 0x30) >> 4;
                        int n8 = (n6 & 0xC) >> 2;
                        int n9 = n6 & 3;
                        ((TilePanel)TilePanel.this).colors[n5] = new Color(n9 * 255 / 3, n8 * 255 / 3, n7 * 255 / 3);
                        ++n5;
                    }
                }
            } else if (n >= TilePanel.this.pal * 16 && n < TilePanel.this.pal * 16 + 16) {
                int n10 = TilePanel.this.palette.getColors()[n];
                int n11 = (n10 & 0x30) >> 4;
                int n12 = (n10 & 0xC) >> 2;
                int n13 = n10 & 3;
                ((TilePanel)TilePanel.this).colors[n] = new Color(n13 * 255 / 3, n12 * 255 / 3, n11 * 255 / 3);
                TilePanel.this.update();
            }
        }
    };

    public TilePanel(int[] nArray, Palette palette) {
        this.setPreferredSize(new Dimension(this.image.getWidth() * 16, this.image.getHeight() * 16));
        this.setTile(nArray, palette);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                int n = mouseEvent.getX() / 16;
                int n2 = mouseEvent.getY() / 16;
                if (SwingUtilities.isLeftMouseButton(mouseEvent) && n >= 0 && n < 8 && n2 >= 0 && n2 < 8) {
                    TilePanel.this.selectedPixel = n2 * 8 + n;
                    TilePanel.this.pipette = mouseEvent.isAltDown();
                    TilePanel.this.fireActionPerformed();
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                int n = mouseEvent.getX() / 16;
                int n2 = mouseEvent.getY() / 16;
                if (SwingUtilities.isLeftMouseButton(mouseEvent) && n >= 0 && n < 8 && n2 >= 0 && n2 < 8) {
                    TilePanel.this.selectedPixel = n2 * 8 + n;
                    TilePanel.this.pipette = mouseEvent.isAltDown();
                    TilePanel.this.fireActionPerformed();
                }
            }
        });
    }

    public void setTile(int[] nArray, Palette palette) {
        if (this.palette != null && this.palette != palette) {
            this.palette.removeChangeListener(this.paletteChangeListener);
        }
        this.tile = nArray;
        this.palette = palette;
        int n = 0;
        int[] nArray2 = palette.getColors();
        int n2 = nArray2.length;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = nArray2[n3];
            int n5 = (n4 & 0x30) >> 4;
            int n6 = (n4 & 0xC) >> 2;
            int n7 = n4 & 3;
            this.colors[n++] = new Color(n7 * 255 / 3, n6 * 255 / 3, n5 * 255 / 3);
            ++n3;
        }
        palette.addChangeListener(this.paletteChangeListener);
        this.update();
    }

    public void setTile(int[] nArray) {
        this.tile = nArray;
        this.update();
    }

    public void setPal(int n) {
        this.pal = n;
        this.update();
    }

    public int getSelectedPixel() {
        return this.selectedPixel;
    }

    public boolean isPipette() {
        return this.pipette;
    }

    private void update() {
        Graphics2D graphics2D = this.image.createGraphics();
        Renderer.renderCharacter(this.tile, this.pal << 11, 0, 0, this.colors, graphics2D);
        graphics2D.dispose();
        this.repaint();
    }

    private static float getPreferredScale() {
        return 16.0f;
    }

    @Override
    public Dimension getPreferredSize() {
        Insets insets = this.getInsets();
        return new Dimension((int)((float)this.image.getWidth() * TilePanel.getPreferredScale()) + insets.left + insets.right, (int)((float)this.image.getHeight() * TilePanel.getPreferredScale()) + insets.top + insets.bottom);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    protected final void fireActionPerformed() {
        for (ActionListener actionListener : this.listeners) {
            actionListener.actionPerformed(null);
        }
    }

    public final void addActionListener(ActionListener actionListener) {
        if (!this.listeners.contains(actionListener)) {
            this.listeners.add(actionListener);
        }
    }

    public final void removeActionListener(ActionListener actionListener) {
        this.listeners.remove(actionListener);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        graphics.drawImage(this.image, 0, 0, this.image.getWidth() * 16, this.image.getHeight() * 16, null);
    }
}

