/*
 * Decompiled with CFR 0.152.
 */
package data;

import changes.Changable;
import changes.Change;
import changes.ChangeListener;
import editor.Z80Factory;
import editors.KiddEd;
import editors.TextProvider;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import mastersystem.OutputListener;
import mastersystem.TMS9918A;
import mastersystem.Z80;
import rom.RomManager;
import transactions.TransactionManager;

public class TextData
implements Changable {
    private static final int MESSAGE_ID_JANKEN_MATCH_ALEX_NAME = 256;
    private static final int MESSAGE_ID_GAME_OVER = 257;
    private static final int MESSAGE_ID_ENDING_SEQUENCE = 258;
    private final int address;
    private int[] vram;
    private int[] characterSources;
    private boolean wasValid;
    private boolean wasDuplicate;
    private int previousPointer;
    private int verticalScroll;
    private boolean canScrollDown;
    private int maxTextScroll;
    private boolean showsTopLine;
    private int sourceEndingSequenceAddress;
    private int sourceBank;
    private int sourceBankINT;
    private int money;
    private Vector<TextHandle> textHandles;
    private final List<TextHandle> REGULAR_TEXT_HANDLES = new AbstractList<TextHandle>(){
        private int size = -1;

        @Override
        public TextHandle get(int n) {
            if (n >= this.size) {
                throw new ArrayIndexOutOfBoundsException(n);
            }
            return (TextHandle)TextData.this.textHandles.get(n);
        }

        @Override
        public int size() {
            if (this.size < 0) {
                this.size = 0;
                for (TextHandle textHandle : TextData.this.textHandles) {
                    if (textHandle.getMessageID() >= 256) continue;
                    ++this.size;
                }
            }
            return this.size;
        }
    };
    private final LinkedList<ChangeListener> listeners = new LinkedList();

    public TextData(int n) {
        this.address = n;
    }

    protected TextData(TextData textData) {
        this(textData.address);
    }

    public int[] getVRAM(TextHandle textHandle, int n) {
        if (textHandle == null) {
            textHandle = this.getTextHandles().firstElement();
        }
        this.money = textHandle instanceof MaKaiTextHandle ? 0 : 10000;
        return this.getVRAM(textHandle.messageID, n);
    }

    private int[] getVRAM(int n) {
        return this.getVRAM(n, 0);
    }

    private int[] getVRAM(int n, int n2) {
        final int[] nArray = new int[65536];
        RomManager.StaticAccess.copyFromROM(0, nArray, 0, 49152);
        nArray[65535] = 130;
        nArray[49169] = n & 0xFF;
        nArray[785] = 201;
        nArray[32319] = 201;
        final Z80 z80 = Z80Factory.create(nArray);
        final TMS9918A tMS9918A = new TMS9918A(262);
        int[] nArray2 = tMS9918A.getVRAM();
        this.wasValid = false;
        this.sourceBank = -1;
        z80.addOutputListener(new OutputListener(){

            @Override
            public void outputAvailable(int n, int n2, int n3) {
                if (n == 65535) {
                    RomManager.StaticAccess.loadBank2(nArray, n2);
                    int n4 = z80.getPC() - 3;
                    if (RomManager.StaticAccess.readByte(n4) == 50 && RomManager.StaticAccess.readByte(n4 -= 2) == 62 && RomManager.StaticAccess.readByte(n4 + 1) == z80.getA()) {
                        if (TextData.this.sourceBank < 0) {
                            TextData.this.sourceBank = n4 + 1;
                        } else {
                            TextData.this.sourceBankINT = n4 + 1;
                        }
                    }
                } else if (n == 65534) {
                    RomManager.StaticAccess.loadBank1(nArray, n2);
                } else if (n >> 6 == 2) {
                    if (n2 < 0) {
                        z80.setInput(tMS9918A.readByte(n & 1, n3));
                    } else {
                        tMS9918A.processInput(n & 1, n2, n3);
                    }
                }
            }
        });
        OutputListener outputListener = new OutputListener(){

            @Override
            public void outputAvailable(int n, int n2, int n3) {
                int n4;
                if (n == 3 && (n2 & 0x3FFF) >= 14336 && (n2 & 1) == 0 && (n4 = ((n2 & 0x3FFF) - 14336) / 2) < TextData.this.characterSources.length) {
                    ((TextData)TextData.this).characterSources[n4] = z80.getHL() >= 32768 && z80.getHL() < 49152 ? (nArray[65535] & 0x3F) * 16384 + (z80.getHL() & 0x3FFF) : (z80.getHL() < 32768 ? z80.getHL() : 0);
                }
            }
        };
        this.verticalScroll = 0;
        this.maxTextScroll = 0;
        this.canScrollDown = false;
        boolean bl = this.showsTopLine = n2 == 0;
        if (n == 258) {
            z80.setIX(50880);
            nArray[z80.getIX() | 0x1A] = 2;
            nArray[55296] = 1;
            nArray[2521] = 201;
            nArray[9876] = 201;
            nArray[40435] = 201;
            nArray[49200] = this.money / 10 % 100 / 10 * 16 + this.money / 10 % 100 % 10;
            nArray[49201] = this.money / 1000 % 100 / 10 * 16 + this.money / 1000 % 100 % 10;
            nArray[49202] = this.money / 100000 % 100 / 10 * 16 + this.money / 100000 % 100 % 10;
            OutputListener outputListener2 = new OutputListener(){

                @Override
                public void outputAvailable(int n, int n2, int n3) {
                    int n4;
                    if (n == 49300 && RomManager.StaticAccess.readByte(n4 = z80.getPC() - 3) == 34) {
                        if (RomManager.StaticAccess.readByte(n4 -= 3) == 33 && RomManager.StaticAccess.readWord(n4 + 1) == z80.getHL()) {
                            TextData.this.sourceEndingSequenceAddress = n4 + 1;
                        } else if (RomManager.StaticAccess.readByte(n4 -= 5) == 33 && RomManager.StaticAccess.readWord(n4 + 1) == z80.getHL()) {
                            TextData.this.sourceEndingSequenceAddress = n4 + 1;
                        }
                    }
                }
            };
            z80.addOutputListener(outputListener2);
            z80.execute(5941);
            z80.removeOutputListener(outputListener2);
            this.characterSources = new int[896];
            this.canScrollDown = true;
            this.maxTextScroll = Math.max(0, this.countEndingSequenceLines() - 24);
            int n3 = 0;
            while (n3 < 912 + n2 * 36) {
                if (n3 == n2 * 36) {
                    tMS9918A.addOutputListener(outputListener);
                }
                z80.execute(5798);
                if (nArray[49301] == 0) {
                    this.canScrollDown = false;
                    break;
                }
                ++n3;
            }
            this.verticalScroll = tMS9918A.getVerticalScroll();
            int[] nArray3 = new int[896];
            int n4 = 0;
            while (n4 < nArray3.length) {
                nArray3[n4] = this.characterSources[(n4 / 32 + this.verticalScroll / 8) % 28 * 32 + n4 % 32];
                ++n4;
            }
            this.characterSources = nArray3;
            this.vram = nArray2;
            return nArray2;
        }
        tMS9918A.addOutputListener(outputListener);
        if (n == 257) {
            nArray[758] = 201;
            nArray[785] = 201;
            nArray[28110] = 0;
            nArray[28111] = 0;
            nArray[28112] = 0;
            nArray[28189] = 0;
            nArray[28190] = 0;
            nArray[28191] = 0;
            nArray[28197] = 195;
            nArray[28212] = 0;
            nArray[28213] = 0;
            nArray[28214] = 0;
            nArray[28222] = 195;
            nArray[49200] = 1;
            nArray[49201] = 3;
            nArray[49202] = 5;
            this.characterSources = new int[767];
            z80.execute(28105);
            this.vram = nArray2;
            return nArray2;
        }
        if (n == 256) {
            this.characterSources = new int[768];
            z80.setBC(2048);
            z80.setDE(30984);
            z80.setHL(30371);
            z80.execute(48);
            this.vram = nArray2;
            return nArray2;
        }
        z80.execute(this.address);
        int n5 = TextData.getPointer(n);
        if (n5 < 32768 || n5 >= 49152) {
            return this.vram;
        }
        this.wasDuplicate = (nArray[49209] << 8 | nArray[49208]) == this.previousPointer;
        this.previousPointer = nArray[49209] << 8 | nArray[49208];
        this.characterSources = new int[768];
        while ((nArray[49278] & 0xE0) != 0) {
            z80.execute(32553);
            z80.execute(32212);
        }
        this.wasValid = true;
        this.vram = nArray2;
        return nArray2;
    }

    private static int getAddressOfPointers() {
        return RomManager.RESOLVE_ADDRESS(RomManager.StaticAccess.readWord(32506), TextData.getBank());
    }

    private static void setAddressOfPointers(int n) {
        RomManager.StaticAccess.writeWord(32506, n);
    }

    protected int resolvePointer(TextHandle textHandle) {
        return this.resolvePointer(textHandle.getMessageID());
    }

    private int resolvePointer(int n) {
        if (n == 258) {
            final int[] nArray = new int[65536];
            RomManager.StaticAccess.copyFromROM(0, nArray, 0, 49152);
            nArray[65535] = 130;
            nArray[49169] = n & 0xFF;
            nArray[785] = 201;
            Z80 z80 = Z80Factory.create(nArray);
            z80.addOutputListener(new OutputListener(){

                @Override
                public void outputAvailable(int n, int n2, int n3) {
                    if (n == 65535) {
                        RomManager.StaticAccess.loadBank2(nArray, n2);
                    } else if (n == 65534) {
                        RomManager.StaticAccess.loadBank1(nArray, n2);
                    }
                }
            });
            z80.setIX(50880);
            nArray[z80.getIX() | 0x1A] = 2;
            nArray[55296] = 1;
            nArray[319] = 201;
            nArray[758] = 201;
            nArray[2521] = 201;
            nArray[9876] = 201;
            nArray[40435] = 201;
            nArray[49187] = 17;
            nArray[49200] = this.money / 10 % 100 / 10 * 16 + this.money / 10 % 100 % 10;
            nArray[49201] = this.money / 1000 % 100 / 10 * 16 + this.money / 1000 % 100 % 10;
            nArray[49202] = this.money / 100000 % 100 / 10 * 16 + this.money / 100000 % 100 % 10;
            z80.execute(5941);
            return RomManager.RESOLVE_ADDRESS(nArray[49301] << 8 | nArray[49300], nArray[65535]);
        }
        return RomManager.RESOLVE_ADDRESS(TextData.getPointer(n), this.getBank(n));
    }

    private static int getPointer(int n) {
        if (n == 258) {
            throw new IllegalArgumentException("getPointer is not supported for the ending sequence text. Use resolvePointer instead.");
        }
        if (n == 256) {
            return 30371;
        }
        if (n == 257) {
            return 28299;
        }
        return RomManager.StaticAccess.readWord(TextData.getAddressOfPointers() + n * 2);
    }

    private static void setPointer(TextHandle textHandle, int n) {
        int n2 = TextData.getAddressOfPointers() + textHandle.getMessageID() * 2;
        int n3 = RomManager.StaticAccess.readWord(n2);
        int n4 = n2;
        while (RomManager.StaticAccess.readWord(n4) == n3) {
            RomManager.StaticAccess.writeWord(n4, n);
            n4 += 2;
        }
    }

    public int getEndingSequenceBank() {
        return this.resolvePointer(258) / 16384;
    }

    public static int getBank() {
        return RomManager.StaticAccess.readByte(32498) & 0x3F;
    }

    private int getBank(int n) {
        if (n == 258) {
            return this.getEndingSequenceBank();
        }
        if (n >= 256) {
            return 0;
        }
        return TextData.getBank();
    }

    private static void setBank(int n) {
        RomManager.StaticAccess.writeByte(32498, 0x80 | n);
    }

    private int getMaxSize(TextHandle textHandle) {
        if (textHandle.getMessageID() == 258) {
            return this.getMaxSizeEndingSequence();
        }
        int n = this.resolvePointer(textHandle);
        int n2 = 16384;
        boolean bl = true;
        for (TextHandle textHandle2 : this.getRegularTextHandles()) {
            int n3 = this.resolvePointer(textHandle2);
            int n4 = n3 - n;
            if (n < n3) {
                bl = false;
            }
            if (n4 <= 0 || n4 >= n2) continue;
            n2 = n4;
        }
        if (bl) {
            int n5 = n + this.getSize(textHandle);
            while (RomManager.StaticAccess.readByte(n5) == 255 && (n5 + 1 & 0x3FFF) > (n5 & 0x3FFF)) {
                ++n5;
            }
            n2 = n5 - n;
        }
        if ((n + n2 - 1 & 0x3FFF) < (n & 0x3FFF)) {
            return 0;
        }
        return n2;
    }

    private int getMaxSizeEndingSequence() {
        int n = this.getAddressOfEndingSequence();
        int n2 = n + TextData.getSizeEndingSequence(n);
        while (RomManager.StaticAccess.readByte(n2) == 255 && (n2 + 1 & 0x3FFF) > (n2 & 0x3FFF)) {
            ++n2;
        }
        return n2 - n;
    }

    private int calcPointersSize() {
        int n = 0;
        for (TextHandle textHandle : this.getRegularTextHandles()) {
            if (textHandle.getMessageID() <= n) continue;
            n = textHandle.getMessageID();
        }
        return n * 2;
    }

    private int getSize() {
        int n = 0;
        for (TextHandle textHandle : this.getRegularTextHandles()) {
            n += this.getSize(textHandle);
        }
        return this.calcPointersSize() + n;
    }

    protected int getSize(TextHandle textHandle) {
        if (textHandle.getMessageID() == 256) {
            return 8;
        }
        if (textHandle.getMessageID() == 257) {
            return 35;
        }
        int n = this.resolvePointer(textHandle);
        if (textHandle.getMessageID() == 258) {
            return TextData.getSizeEndingSequence(n);
        }
        int n2 = n / 16384;
        int n3 = n;
        while (n3 / 16384 == n2) {
            int n4;
            int n5 = RomManager.StaticAccess.readByte(n3++);
            int n6 = n5 & 0x7F;
            if ((n4 = RomManager.StaticAccess.readByte(n3++) >> 5) == 0) break;
            if ((n5 & 0x80) != 0) {
                ++n3;
                continue;
            }
            n3 += n6;
        }
        if (RomManager.StaticAccess.readByte(n3 - 1) != 0) {
            return 0;
        }
        return n3 - n;
    }

    private static int getSizeEndingSequence(int n) {
        int n2 = n / 16384;
        int n3 = n;
        while (n3 / 16384 == n2) {
            int n4 = RomManager.StaticAccess.readByte(n3++);
            switch (n4) {
                case 0: 
                case 254: {
                    break;
                }
                case 255: {
                    return n3 - n;
                }
                default: {
                    n3 += 1 + n4;
                }
            }
        }
        throw new IllegalStateException("Could not find end of ending sequence.");
    }

    public String getRawText(TextHandle textHandle) {
        if (textHandle.getMessageID() == 258) {
            return this.getRawTextEndingSequence();
        }
        if (textHandle.getMessageID() >= 256) {
            return null;
        }
        int n = this.resolvePointer(textHandle);
        int n2 = n / 16384;
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = n;
        boolean bl = false;
        while (n3 / 16384 == n2) {
            int n4;
            int n5 = RomManager.StaticAccess.readByte(n3++);
            int n6 = n5 & 0x7F;
            if ((n4 = RomManager.StaticAccess.readByte(n3++) >> 5) == 0) break;
            if ((n5 & 0x80) != 0) {
                stringBuilder.append('\\');
                switch (n4) {
                    case 1: {
                        stringBuilder.append('r');
                        break;
                    }
                    case 2: 
                    case 3: {
                        stringBuilder.append('l');
                        break;
                    }
                    case 4: 
                    case 5: {
                        stringBuilder.append('d');
                        break;
                    }
                    case 6: 
                    case 7: {
                        stringBuilder.append('u');
                    }
                }
                ++n3;
                stringBuilder.append(n6);
                bl = false;
            } else if (n4 != 1 && TextData.isSpacesOnly(n3, n6)) {
                stringBuilder.append('\\');
                switch (n4) {
                    case 1: {
                        stringBuilder.append('r');
                        break;
                    }
                    case 2: 
                    case 3: {
                        stringBuilder.append('l');
                        break;
                    }
                    case 4: 
                    case 5: {
                        stringBuilder.append('d');
                        break;
                    }
                    case 6: 
                    case 7: {
                        stringBuilder.append('u');
                    }
                }
                while (RomManager.StaticAccess.readByte(n3) == 176) {
                    ++n3;
                }
                stringBuilder.append(n6);
                bl = false;
            } else {
                int n7 = 0;
                while (n7 < n6) {
                    int n8;
                    if ((n8 = RomManager.StaticAccess.readByte(n3++)) < 176) {
                        throw new IllegalArgumentException("Illegal value encountered: " + Integer.toHexString(n8));
                    }
                    stringBuilder.append((char)(n8 - 176 + 32));
                    ++n7;
                }
            }
            if (!bl) {
                stringBuilder.append('\n');
            }
            boolean bl2 = bl = (n5 & 0x80) != 0 && n4 <= 3;
        }
        return stringBuilder.toString();
    }

    private String getRawTextEndingSequence() {
        int n = this.getAddressOfEndingSequence();
        int n2 = n / 16384;
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = n;
        block4: while (n3 / 16384 == n2) {
            int n4 = RomManager.StaticAccess.readByte(n3++);
            switch (n4) {
                case 0: 
                case 254: {
                    stringBuilder.append('\n');
                    break;
                }
                case 255: {
                    return stringBuilder.toString();
                }
                default: {
                    int n5 = RomManager.StaticAccess.readByte(n3++) / 2 - 1;
                    int n6 = 0;
                    while (n6 < n5) {
                        stringBuilder.append(' ');
                        ++n6;
                    }
                    n6 = 0;
                    while (n6 < n4) {
                        int n7;
                        if ((n7 = RomManager.StaticAccess.readByte(n3++) - 176 + 32) >= 0 && n7 < 256) {
                            stringBuilder.append((char)n7);
                        }
                        ++n6;
                    }
                    continue block4;
                }
            }
        }
        throw new IllegalStateException("Could not find end of ending sequence.");
    }

    private static boolean isSpacesOnly(int n, int n2) {
        while (n2-- > 0) {
            if (RomManager.StaticAccess.readByte(n) == 176) continue;
            return false;
        }
        return true;
    }

    public void setRawText(TextHandle textHandle, String string) {
        int n;
        int n2;
        int n3;
        int n4;
        if (textHandle.getMessageID() == 258) {
            this.setRawTextEndingSequence(string);
            return;
        }
        if (textHandle.getMessageID() >= 256) {
            throw new IllegalArgumentException("Cannot set raw text of this message.");
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n5 = 0;
        String string2 = "";
        boolean bl = false;
        while (n5 < string.length()) {
            if ((n4 = string.charAt(n5++)) == 92) {
                if (bl && !string2.isEmpty()) {
                    arrayList.add(1);
                    arrayList.add(128);
                    arrayList.add(string2.charAt(0) - 32 + 176);
                    string2 = string2.substring(1);
                }
                if (!string2.isEmpty()) {
                    arrayList.add(string2.length());
                    arrayList.add(32);
                    n3 = 0;
                    while (n3 < string2.length()) {
                        arrayList.add(string2.charAt(n3) - 32 + 176);
                        ++n3;
                    }
                    string2 = "";
                }
                if (n5 >= string.length()) {
                    throw new IllegalArgumentException("Missing direction at position " + n5 + ".");
                }
                n3 = string.charAt(n5++);
                switch (n3) {
                    case 114: {
                        n2 = 1;
                        break;
                    }
                    case 108: {
                        n2 = 2;
                        break;
                    }
                    case 100: {
                        n2 = 4;
                        break;
                    }
                    case 117: {
                        n2 = 6;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Illegal direction '" + (char)n3 + "' at position " + n5 + ".");
                    }
                }
                int n6 = 0;
                int n7 = 0;
                while (n7 < 4 && n5 < string.length()) {
                    n = string.charAt(n5);
                    if (!Character.isDigit((char)n)) break;
                    ++n5;
                    n6 *= 10;
                    if ((n6 += n - 48) > 127) {
                        throw new IllegalArgumentException("Illegal count '" + (char)n + "' at position " + n5 + ".");
                    }
                    ++n7;
                }
                if (n6 == 0) {
                    throw new IllegalArgumentException("Illegal count at position " + n5 + ".");
                }
                arrayList.add(0x80 | n6);
                arrayList.add(n2 << 5);
                arrayList.add(176);
                bl = n2 <= 3;
                continue;
            }
            if (n4 < 32) continue;
            string2 = String.valueOf(string2) + (char)n4;
        }
        if (bl && !string2.isEmpty()) {
            arrayList.add(1);
            arrayList.add(128);
            arrayList.add(string2.charAt(0) - 32 + 176);
            string2 = string2.substring(1);
        }
        if (!string2.isEmpty()) {
            arrayList.add(string2.length());
            arrayList.add(32);
            n4 = 0;
            while (n4 < string2.length()) {
                arrayList.add(string2.charAt(n4) - 32 + 176);
                ++n4;
            }
            string2 = "";
        }
        arrayList.add(0);
        arrayList.add(0);
        n3 = n4 = this.resolvePointer(textHandle);
        n2 = 0;
        for (Integer n8 : arrayList) {
            if (n8 == RomManager.StaticAccess.readByte(n3++)) continue;
            n2 = 1;
            break;
        }
        if (n2 == 0) {
            return;
        }
        if (arrayList.size() > this.getMaxSize(textHandle)) {
            this.defrag();
            TreeSet<TextHandle> treeSet = new TreeSet<TextHandle>(new Comparator<TextHandle>(){

                @Override
                public int compare(TextHandle textHandle, TextHandle textHandle2) {
                    return TextData.this.resolvePointer(textHandle) - TextData.this.resolvePointer(textHandle2);
                }
            });
            treeSet.addAll(this.getRegularTextHandles());
            TextHandle textHandle2 = treeSet.last();
            n = arrayList.size() - this.getMaxSize(textHandle);
            int n9 = this.resolvePointer(textHandle2) + this.getSize(textHandle2);
            int n10 = 0;
            while (n10 < n) {
                if ((n9 & 0x3FFF) < (n9 - 1 & 0x3FFF) || RomManager.StaticAccess.readByte(n9++) != 255) {
                    this.relocate(n);
                    break;
                }
                ++n10;
            }
            n9 = this.resolvePointer(textHandle2) + this.getSize(textHandle2);
            n10 = 0;
            while (n10 < n) {
                if ((n9 & 0x3FFF) < (n9 - 1 & 0x3FFF) || RomManager.StaticAccess.readByte(n9++) != 255) {
                    System.err.println("Not enough space.");
                    return;
                }
                ++n10;
            }
            treeSet.clear();
            treeSet.addAll(this.getRegularTextHandles());
            n10 = this.resolvePointer(textHandle);
            for (TextHandle textHandle3 : treeSet.descendingSet()) {
                int n11 = this.resolvePointer(textHandle3);
                if (n11 <= n10) break;
                this.moveText(textHandle3, n11 + n);
            }
        }
        RomManager.StaticAccess.fill(n4, n4 + this.getSize(textHandle), 255);
        n3 = this.resolvePointer(textHandle);
        for (Integer n12 : arrayList) {
            RomManager.StaticAccess.writeByte(n3++, n12);
        }
        this.defrag();
        TransactionManager.getInstance().addTransactionObject(this, -1);
    }

    private void setRawTextEndingSequence(String string) {
        int n;
        int n2;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n3 = 0;
        String string2 = "";
        int n4 = 0;
        boolean bl = true;
        while (n3 < string.length()) {
            if ((n2 = string.charAt(n3++)) == 10) {
                if (!string2.isEmpty()) {
                    arrayList.add(string2.length());
                    arrayList.add((n4 + 1) * 2);
                    n = 0;
                    while (n < string2.length()) {
                        arrayList.add(string2.charAt(n) - 32 + 176);
                        ++n;
                    }
                    string2 = "";
                } else if (n4 != 0) {
                    arrayList.add(1);
                    arrayList.add((n4 - 1 + 1) * 2);
                    arrayList.add(176);
                }
                arrayList.add(254);
                bl = true;
                n4 = 0;
                continue;
            }
            if (n2 == 32 && bl) {
                --n3;
                while (n3 + ++n4 < string.length() && string.charAt(n3 + n4) == ' ') {
                }
                n3 += n4;
            } else if (string2.length() < 255) {
                string2 = String.valueOf(string2) + (char)n2;
            } else {
                throw new IllegalArgumentException("The line starting with '" + string2.substring(0, 20) + "' is too long.");
            }
            bl = false;
        }
        if (!string2.isEmpty()) {
            arrayList.add(string2.length());
            arrayList.add(n4 * 2);
            n2 = 0;
            while (n2 < string2.length()) {
                arrayList.add(string2.charAt(n2) - 32 + 176);
                ++n2;
            }
            string2 = "";
        }
        arrayList.add(255);
        n = n2 = this.getAddressOfEndingSequence();
        boolean bl2 = false;
        for (Integer n5 : arrayList) {
            if (n5 == RomManager.StaticAccess.readByte(n++)) continue;
            bl2 = true;
            break;
        }
        if (!bl2) {
            return;
        }
        int n6 = this.getMaxSizeEndingSequence();
        RomManager.StaticAccess.fill(n2, n2 + TextData.getSizeEndingSequence(n2), 255);
        if (arrayList.size() > n6) {
            int n7 = KiddEd.findFreeBlock(arrayList.size());
            if (n7 < 0) {
                throw new IllegalStateException("Not enough space for ending sequence.");
            }
            n2 = n7;
            this.setEndingSequenceAddress(n7);
        }
        n = n2;
        for (Integer n7 : arrayList) {
            RomManager.StaticAccess.writeByte(n++, n7);
        }
        TransactionManager.getInstance().addTransactionObject(this, -1);
    }

    private void setEndingSequenceAddress(int n) {
        RomManager.StaticAccess.writeByte(this.sourceBank, 0x80 | n / 16384);
        RomManager.StaticAccess.writeByte(this.sourceBankINT, 0x80 | n / 16384);
        RomManager.StaticAccess.writeWord(this.sourceEndingSequenceAddress, 0x8000 | n & 0x3FFF);
    }

    private void defrag() {
        TreeSet<TextHandle> treeSet = new TreeSet<TextHandle>(new Comparator<TextHandle>(){

            @Override
            public int compare(TextHandle textHandle, TextHandle textHandle2) {
                return TextData.this.resolvePointer(textHandle) - TextData.this.resolvePointer(textHandle2);
            }
        });
        treeSet.addAll(this.getRegularTextHandles());
        int n = this.resolvePointer(treeSet.first());
        for (TextHandle textHandle : treeSet) {
            int n2 = this.resolvePointer(textHandle);
            int n3 = this.getSize(textHandle);
            if (n2 != n) {
                this.moveText(textHandle, n);
            }
            n += n3;
        }
    }

    public void relocateEndingSequence() {
        this.getVRAM(258);
        int n = this.getAddressOfEndingSequence();
        int n2 = TextData.getSizeEndingSequence(n);
        int n3 = KiddEd.findFreeBlock(n2);
        if (n3 < 0) {
            throw new IllegalArgumentException("Couldn't find free space.");
        }
        RomManager.StaticAccess.copyBytes(n, n3, n2);
        RomManager.StaticAccess.fill(n, n + n2, 255);
        this.setEndingSequenceAddress(n3);
    }

    private int getAddressOfEndingSequence() {
        return this.resolvePointer(258);
    }

    public int getLastByteOfEndingSequence() {
        int n = this.getAddressOfEndingSequence();
        return n + TextData.getSizeEndingSequence(n) - 1;
    }

    public void relocate() {
        this.relocate(0);
    }

    private void relocate(int n) {
        int n2 = KiddEd.findFreeBlock(2 + this.getSize() + n);
        if (n2 < 0) {
            throw new IllegalArgumentException("Couldn't find free space.");
        }
        int n3 = this.calcPointersSize();
        int n4 = n2 + 2;
        int n5 = n4 + n3;
        int n6 = 0x3FFFFFFF;
        int n7 = 0;
        for (TextHandle textHandle : this.getRegularTextHandles()) {
            int n8 = this.getSize(textHandle);
            this.moveText(textHandle, n5);
            while (++n6 < textHandle.getMessageID()) {
                RomManager.StaticAccess.writeWord(n4, 0x8000 | n7 & 0x3FFF);
                n4 += 2;
            }
            RomManager.StaticAccess.writeWord(n4, 0x8000 | n5 & 0x3FFF);
            n4 += 2;
            n6 = textHandle.getMessageID();
            n7 = n5;
            n5 += n8;
        }
        RomManager.StaticAccess.fill(TextData.getAddressOfPointers() + 2, TextData.getAddressOfPointers() + 2 + n3, 255);
        TextData.setAddressOfPointers(0x8000 | n2 & 0x3FFF);
        TextData.setBank(n2 / 16384);
    }

    public void printTexts() {
        for (TextHandle textHandle : this.getTextHandles()) {
            System.out.println("\t" + Integer.toHexString(this.resolvePointer(textHandle)) + " - " + Integer.toHexString(this.resolvePointer(textHandle) + this.getSize(textHandle)));
        }
    }

    private void moveText(TextHandle textHandle, int n) {
        int n2 = this.getSize(textHandle);
        int n3 = this.resolvePointer(textHandle);
        int[] nArray = RomManager.StaticAccess.readBytes(new int[n2], n3);
        RomManager.StaticAccess.fill(n3, n3 + n2, 255);
        RomManager.StaticAccess.writeBytes(nArray, n);
        TextData.setPointer(textHandle, 0x8000 | n & 0x3FFF);
        TransactionManager.getInstance().addTransactionObject(this, -1);
    }

    public String getText() {
        return this.getText(this.characterSources.length);
    }

    private String getText(int n) {
        String string = "";
        boolean bl = true;
        int n2 = 0;
        while (n2 < this.characterSources.length) {
            if (this.isCharacter(n2)) {
                int n3;
                if (!bl) {
                    string = String.valueOf(string) + '\n';
                }
                if ((n3 = RomManager.StaticAccess.readByte(this.characterSources[n2]) - 176 + 32) >= 0 && n3 < 256) {
                    string = String.valueOf(string) + (char)n3;
                }
                bl = true;
            } else if (!string.isEmpty() && !string.endsWith("\n")) {
                bl = false;
            }
            if (string.length() >= n) {
                string = String.valueOf(string) + "...";
                break;
            }
            ++n2;
        }
        return string;
    }

    public TextHandle getTextHandle(int n) {
        if (this.textHandles == null) {
            this.getTextHandles();
        }
        for (TextHandle textHandle : this.textHandles) {
            if (textHandle.messageID != n) continue;
            return textHandle;
        }
        return null;
    }

    public List<TextHandle> getRegularTextHandles() {
        if (this.textHandles == null) {
            this.getTextHandles();
        }
        return this.REGULAR_TEXT_HANDLES;
    }

    public Vector<TextHandle> getTextHandles() {
        if (this.textHandles != null) {
            return new Vector<TextHandle>(this.textHandles);
        }
        this.textHandles = new Vector();
        this.getVRAM(1);
        int n = 2;
        while (this.wasValid) {
            if (!this.wasDuplicate) {
                this.textHandles.add(new TextHandle(n - 1));
            }
            this.getVRAM(n);
            ++n;
        }
        this.getVRAM(256);
        this.textHandles.add(new TextHandle(256));
        this.getVRAM(257);
        this.textHandles.add(new TextHandle(257));
        this.money = 10000;
        this.getVRAM(258);
        n = this.sourceEndingSequenceAddress;
        this.textHandles.add(new TextHandle(258));
        this.money = 0;
        this.getVRAM(258);
        if (this.sourceEndingSequenceAddress != n) {
            this.textHandles.add(new MaKaiTextHandle());
        }
        return new Vector<TextHandle>(this.textHandles);
    }

    public int getVerticalScroll() {
        return this.verticalScroll;
    }

    public boolean canScrollDown() {
        return this.canScrollDown;
    }

    public int getMaxTextScroll() {
        return this.maxTextScroll;
    }

    public boolean supportsControlCodes(TextHandle textHandle) {
        return textHandle.getMessageID() < 256;
    }

    private int countEndingSequenceLines() {
        int n = 0;
        String string = this.getRawTextEndingSequence();
        boolean bl = true;
        int n2 = 0;
        while (n2 < string.length()) {
            if (string.charAt(n2) == '\n') {
                if (!bl) {
                    ++n;
                }
                ++n;
                bl = true;
            } else {
                bl = false;
            }
            ++n2;
        }
        return n;
    }

    public boolean hasBlackBackground(TextHandle textHandle) {
        return textHandle.messageID >= 257;
    }

    public boolean isCharacter(int n) {
        if (n < 0 || n >= this.characterSources.length) {
            return false;
        }
        if (n + 1 < this.characterSources.length && this.characterSources[n] == this.characterSources[n + 1]) {
            return false;
        }
        if (n - 1 >= 0 && this.characterSources[n] == this.characterSources[n - 1]) {
            return false;
        }
        if (n + 32 < this.characterSources.length && this.characterSources[n] == this.characterSources[n + 32]) {
            return false;
        }
        if (n >= 32 && this.characterSources[n] == this.characterSources[n - 32]) {
            return false;
        }
        if (this.characterSources.length == 768) {
            if (n - 1 >= 0 && this.characterSources[n - 1] == 0 && RomManager.StaticAccess.readByte(this.characterSources[n]) - 176 + 32 == 32) {
                return false;
            }
            if (n + 1 < this.characterSources.length && this.characterSources[n + 1] == 0 && RomManager.StaticAccess.readByte(this.characterSources[n]) - 176 + 32 == 32) {
                return false;
            }
            if (RomManager.StaticAccess.readByte(this.characterSources[n]) - 176 + 32 == 32 && RomManager.StaticAccess.readByte(this.characterSources[n] - 1) < 176) {
                return false;
            }
        }
        return this.characterSources[n] > 0;
    }

    public boolean setCharacter(int n, char c) {
        if (this.isCharacter(n) && (c = Character.toUpperCase(c)) >= ' ' && c <= '_') {
            TransactionManager.getInstance().addTransactionObject(this, n);
            RomManager.StaticAccess.writeByte(this.characterSources[n], Character.toUpperCase(c) - 32 + 176);
            return true;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public void setText(String var1_1, int var2_2) {
        var3_3 = "";
        var7_4 = var1_1.toCharArray();
        var6_6 = var7_4.length;
        var5_8 = 0;
        while (var5_8 < var6_6) {
            var4_9 = var7_4[var5_8];
            if ((var4_9 = Character.toUpperCase((char)var4_9)) >= 32 && var4_9 <= 95) {
                var3_3 = String.valueOf(var3_3) + (char)(var4_9 - 32 + 176);
            }
            ++var5_8;
        }
        var4_9 = Math.min(var3_3.length(), this.getText(var3_3.length() + var2_2).length());
        var5_8 = var2_2;
        var6_6 = 0;
        while (var6_6 < this.characterSources.length && var5_8 < 0) {
            if (this.isCharacter(var6_6)) {
                var5_8 = var6_6;
            }
            ++var6_6;
        }
        var6_7 = new int[var4_9];
        var7_5 = var5_8;
        var8_10 = 0;
        ** GOTO lbl29
        {
            ++var7_5;
            do {
                if (var7_5 < this.characterSources.length && !this.isCharacter(var7_5)) continue block2;
                if (var7_5 < this.characterSources.length) {
                    var6_7[var8_10] = this.characterSources[var7_5++];
                }
                ++var8_10;
lbl29:
                // 2 sources

            } while (var8_10 < var4_9 && var7_5 < this.characterSources.length);
        }
        TransactionManager.getInstance().addTransactionObject(this, var5_8);
        var8_10 = 0;
        while (var8_10 < var6_7.length) {
            if (var6_7[var8_10] > 0) {
                RomManager.StaticAccess.writeByte(var6_7[var8_10], var3_3.charAt(var8_10));
            }
            ++var8_10;
        }
    }

    @Override
    public final String getChangeName() {
        return TextProvider.get("ChangeText");
    }

    @Override
    public final void fireChangeOccurred(Change change) {
        for (ChangeListener changeListener : this.listeners) {
            changeListener.changeOccurred(change);
        }
    }

    @Override
    public final void addChangeListener(ChangeListener changeListener) {
        if (!this.listeners.contains(changeListener)) {
            this.listeners.addFirst(changeListener);
        }
    }

    @Override
    public final void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    public class MaKaiTextHandle
    extends TextHandle {
        protected MaKaiTextHandle() {
            super(258);
        }
    }

    public class TextHandle {
        private final int messageID;
        private String name;

        protected TextHandle(int n) {
            this.messageID = n;
            this.updateName();
        }

        public int getMessageID() {
            return this.messageID;
        }

        public void updateName() {
            if (TextData.this.showsTopLine) {
                String[] stringArray = TextData.this.getText(30).split("\n");
                this.name = stringArray[0].trim();
                int n = 1;
                while (n < stringArray.length) {
                    this.name = String.valueOf(this.name) + " " + stringArray[n].trim();
                    ++n;
                }
            }
            if (this.getMessageID() < 256) {
                this.name = String.format("%02X: %s", this.getMessageID(), this.name);
            }
        }

        public String toString() {
            return this.name;
        }
    }
}

