/*
 * Decompiled with CFR 0.152.
 */
package data;

import data.Level;
import rom.RomManager;
import transactions.TransactionManager;

public class BonusLevel
extends Level {
    private final Level parent;
    private final int address;
    private boolean restoring;

    public BonusLevel(Level level, int n, int n2) {
        super(n2);
        this.address = n;
        this.parent = level;
        level.setBonusLevel(this);
    }

    @Override
    protected int getAddress() {
        if (this.level == 2 && RomManager.StaticAccess.readByte(this.address) != 33) {
            return this.address + 7;
        }
        return this.address;
    }

    @Override
    public boolean isValidScreen(int n, int n2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean canConvertToScrollability(int n) {
        return false;
    }

    @Override
    public void convertToScrollability(int n, int n2, int n3) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean canRemoveScreen(int n, int n2) {
        return false;
    }

    @Override
    public boolean removeScreen(int n, int n2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isValid() {
        if (this.isMoving() || this.isMovingEntityData()) {
            return true;
        }
        try {
            int[] nArray = this.getScreenAddresses();
            int[] nArray2 = this.getEntityScreenAddresses();
            int n = this.calcEntityIndex(this.getStartHorizontalScreenNumber() - 1, this.getStartVerticalScreenNumber());
            int n2 = n + nArray.length;
            if (nArray2.length < n2) {
                throw new IllegalArgumentException("The number of entity screens (" + nArray2.length + ") is less than the number of screens (" + n2 + ").");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return super.isValid();
    }

    @Override
    public boolean canAddEntity(int n, int n2, int n3) {
        return this.parent.getScrollability() != 128 && super.canAddEntity(n, n2, n3);
    }

    @Override
    public boolean canAddScreen(int n, int n2) {
        return false;
    }

    @Override
    public boolean ensureEntityScreens(int n, int n2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addScreen(int n, int n2, int[] nArray, int[] nArray2) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int getNumberOfEntityScreens() {
        return (this.calcScreenNumber(this.getStartHorizontalScreenNumber() - 1, 0) & 0x7F) + this.calcScreenCount();
    }

    @Override
    public boolean isMoving() {
        return this.parent.isMoving();
    }

    @Override
    public boolean isMovingEntityData() {
        return this.parent.isMovingEntityData();
    }

    @Override
    public boolean moveTo(int n, int n2) {
        if (this.isInjected()) {
            boolean bl = this.parent.moveTo(n, n2);
            this.uninject();
            return bl;
        }
        return this.parent.moveTo(n, n2);
    }

    @Override
    protected boolean moveEntityData(int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean relocateEntityData() {
        return this.parent.relocateEntityData();
    }

    @Override
    public int calcRequiredSize() {
        return this.parent.calcRequiredSize();
    }

    @Override
    protected int calcScreenNumber(int n, int n2) {
        return RomManager.StaticAccess.readByte(6114) + n - this.getStartHorizontalScreenNumber() + 1;
    }

    @Override
    protected int calcPointersSize(int n, int n2, int n3) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int calcScreenCount() {
        return this.getMaxHorizontalScreenNumber() - (this.getStartHorizontalScreenNumber() - 1) + 1;
    }

    @Override
    protected int calcScreenCount(int n, int n2, int n3) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setBonusLevel(BonusLevel bonusLevel) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int[][] decompressLayout() {
        int n = this.calcScreenCount();
        int n2 = n * 195;
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n];
        int n3 = 0;
        int n4 = 0;
        int n5 = this.getStartHorizontalScreenNumber() - 1;
        while (n5 <= this.getMaxHorizontalScreenNumber()) {
            int[] nArray3;
            block5: {
                nArray2[n4++] = 0x8000 | n3 & 0x3FFF;
                nArray3 = new int[192];
                try {
                    nArray3 = this.getLayout(n5, 0);
                }
                catch (Exception exception) {
                    if (this.level != 2) break block5;
                    this.restoring = true;
                    try {
                        nArray3 = this.getLayout((new int[]{36091, 36154, 36221})[n5 - (this.getStartHorizontalScreenNumber() - 1)]);
                    }
                    catch (Exception exception2) {}
                    this.restoring = false;
                }
            }
            nArray[n3++] = 254;
            System.arraycopy(nArray3, 0, nArray, n3, 126);
            n3 += 126;
            nArray[n3++] = 0x80 | nArray3.length - 126;
            System.arraycopy(nArray3, 126, nArray, n3, nArray3.length - 126);
            n3 += nArray3.length - 126;
            nArray[n3++] = 0;
            ++n5;
        }
        return new int[][]{nArray, nArray2};
    }

    @Override
    protected int[] getScreenPointers() {
        int[] nArray = new int[this.calcScreenCount()];
        int n = 0;
        int n2 = this.getStartHorizontalScreenNumber() - 1;
        while (n2 <= this.getMaxHorizontalScreenNumber()) {
            nArray[n++] = this.getScreenPointer(n2, 0);
            ++n2;
        }
        return nArray;
    }

    public boolean isInjected() {
        return RomManager.StaticAccess.readByte(this.getAddress() + 6) == 205;
    }

    public void uninject() {
        int n = RomManager.StaticAccess.readWord(this.getAddress() + 7);
        RomManager.StaticAccess.copyBytes(n + 5, this.getAddress() + 6, 3);
        RomManager.StaticAccess.fill(n, n + 9, 255);
    }

    @Override
    protected int getEntitiesBank() {
        return this.parent.getEntitiesBank();
    }

    @Override
    public int getBankAddress() {
        if (this.isInjected()) {
            return RomManager.StaticAccess.readWord(this.getAddress() + 7) + 1;
        }
        return this.parent.getBankAddress();
    }

    @Override
    public int getBank() {
        if (this.restoring) {
            return 134;
        }
        return super.getBank();
    }

    @Override
    public int getLayoutPointer() {
        return RomManager.StaticAccess.readWord(this.getAddress() + 1);
    }

    @Override
    public int getLayoutPointer2() {
        return RomManager.StaticAccess.readWord(this.getAddress() + 4);
    }

    @Override
    public int getStartHorizontalScreenNumber() {
        if (this.isInjected()) {
            return RomManager.StaticAccess.readByte(RomManager.StaticAccess.readWord(this.getAddress() + 7) + 7);
        }
        return RomManager.StaticAccess.readByte(this.getAddress() + 8);
    }

    @Override
    public int getStartVerticalScreenNumber() {
        return 0;
    }

    @Override
    public int getMaxHorizontalScreenNumber() {
        if (this.isInjected()) {
            return RomManager.StaticAccess.readByte(RomManager.StaticAccess.readWord(this.getAddress() + 7) + 6);
        }
        if (this.level == 16) {
            return this.getStartHorizontalScreenNumber();
        }
        return RomManager.StaticAccess.readByte(this.getAddress() + 7);
    }

    @Override
    public int getMaxVerticalScreenNumber() {
        return 0;
    }

    @Override
    public int getScrollability() {
        return RomManager.StaticAccess.readByte(6078);
    }

    @Override
    public int getMetaTilesetPointerAddress() {
        return this.parent.getMetaTilesetPointerAddress();
    }

    @Override
    public int getShopEntranceHpos() {
        return this.parent.getShopEntranceHpos();
    }

    @Override
    public int getShopEntranceNameTablePos() {
        return this.parent.getShopEntranceNameTablePos();
    }

    @Override
    public int getUpdateColorsCodeAddress() {
        return this.parent.getUpdateColorsCodeAddress();
    }

    @Override
    public int getUpdateLevelTilesCodeAddress() {
        return this.parent.getUpdateLevelTilesCodeAddress();
    }

    @Override
    public int getShopDataAddress() {
        return this.parent.getShopDataAddress();
    }

    @Override
    public int getSoundControlValue() {
        return RomManager.StaticAccess.readByte(3525 + this.parent.level + 1);
    }

    @Override
    protected int getAddressStartPositionHpos() {
        if (this.level == 16) {
            return 6206;
        }
        return 6171;
    }

    @Override
    protected int getAddressStartPositionVpos() {
        if (this.level == 16) {
            return 6210;
        }
        return 6175;
    }

    @Override
    protected int getAddressStartVehicle() {
        return -1;
    }

    @Override
    public void setShopEntrancePos(int n, int n2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setJarEntrancePos(int n, int n2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setUpdateColorsCodeAddress(int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setUpdateLevelTilesCodeAddress(int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setShopDataAddresses(int n, int n2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setSoundControlValue(int n) {
        if (RomManager.StaticAccess.readByte(3525 + this.parent.level + 1) != (0x80 | n)) {
            TransactionManager.getInstance().addTransactionObject(this, -5);
            RomManager.StaticAccess.writeByte(3525 + this.parent.level + 1, 0x80 | n);
        }
    }

    @Override
    protected void setBank(int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void setLayoutPointer(int n) {
        RomManager.StaticAccess.writeByte(this.getAddress() + 1, n & 0xFF);
        RomManager.StaticAccess.writeByte(this.getAddress() + 2, n >> 8);
        RomManager.StaticAccess.writeByte(this.getAddress() + 4, n & 0xFF);
        RomManager.StaticAccess.writeByte(this.getAddress() + 5, n >> 8);
    }

    @Override
    protected void setLayoutPointer2(int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void setStartHorizontalScreenNumber(int n) {
        int n2;
        int n3 = -8 - this.getStartHorizontalScreenNumber();
        int n4 = n2 = this.isInjected() ? RomManager.StaticAccess.readWord(this.getAddress() + 7) + 7 : this.getAddress() + 8;
        if (RomManager.StaticAccess.readByte(n2) != n) {
            TransactionManager.getInstance().addTransactionObject(this, n3);
            RomManager.StaticAccess.writeByte(n2, n);
            if (this.level == 16) {
                RomManager.StaticAccess.writeByte(6048, n + 1);
            }
        }
    }

    @Override
    protected void setStartVerticalScreenNumber(int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void setMaxHorizontalScreenNumber(int n) {
        int n2 = this.isInjected() ? RomManager.StaticAccess.readWord(this.getAddress() + 7) + 6 : this.getAddress() + 7;
        RomManager.StaticAccess.writeByte(n2, n);
    }

    @Override
    protected void setMaxVerticalScreenNumber(int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void setScrollability(int n) {
        throw new UnsupportedOperationException();
    }
}

