/*
 * Decompiled with CFR 0.152.
 */
package widgets;

import changes.Change;
import changes.ChangeListener;
import data.LevelSpriteTileset;
import data.Palette;
import data.SpriteContainer;
import data.SpriteTileset;
import data.Tileset;
import editor.Z80Factory;
import editors.EntityLabelProvider;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.Comparator;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import mastersystem.OutputListener;
import mastersystem.Renderer;
import mastersystem.TMS9918A;
import mastersystem.Z80;
import panels.Scalable;
import panels.ScaleListener;
import rom.RomManager;

public class EntityList
extends JScrollPane
implements Scalable {
    private final JList<Entity> list = new JList();
    private final Color[] colors = new Color[32];
    private LevelSpriteTileset tileset;
    private Palette palette;
    private final EntityLabelProvider entityLabelProvider;
    private final int addressUpdateEntities;
    private SpriteTileset[] spriteTilesets;
    private SpriteContainer[] sprites;
    private int minWidth;
    private float scale = 1.0f;
    private float prevPreferredScale;
    private float prevPrevPreferredScale;
    private Scalable scaleParent = this;
    private final ChangeListener tilesetChangeListener = new ChangeListener(){

        @Override
        public void changeOccurred(Change change) {
            if (change.getData(EntityList.this.tileset) >= 256) {
                EntityList.this.update();
            }
        }
    };
    private final ChangeListener spriteChangeListener = new ChangeListener(){

        @Override
        public void changeOccurred(Change change) {
            EntityList.this.update();
        }
    };
    private final ChangeListener paletteChangeListener = new ChangeListener(){

        @Override
        public void changeOccurred(Change change) {
            int n = change.getData(EntityList.this.palette);
            if (n < 0) {
                int n2 = -n - 1;
                if (n2 >= 1) {
                    int n3 = 16;
                    while (n3 < 32) {
                        int n4 = EntityList.this.palette.getColors()[n3];
                        int n5 = (n4 & 0x30) >> 4;
                        int n6 = (n4 & 0xC) >> 2;
                        int n7 = n4 & 3;
                        ((EntityList)EntityList.this).colors[n3] = new Color(n7 * 255 / 3, n6 * 255 / 3, n5 * 255 / 3);
                        ++n3;
                    }
                }
            } else if (n > 16) {
                int n8 = EntityList.this.palette.getColors()[n];
                int n9 = (n8 & 0x30) >> 4;
                int n10 = (n8 & 0xC) >> 2;
                int n11 = n8 & 3;
                ((EntityList)EntityList.this).colors[n] = new Color(n11 * 255 / 3, n10 * 255 / 3, n9 * 255 / 3);
                EntityList.this.update();
            }
        }
    };

    public EntityList(LevelSpriteTileset levelSpriteTileset, Palette palette, SpriteTileset[] spriteTilesetArray, SpriteContainer[] spriteContainerArray, int n, EntityLabelProvider entityLabelProvider) {
        super(20, 31);
        this.addressUpdateEntities = n;
        this.setViewportView(this.list);
        this.entityLabelProvider = entityLabelProvider;
        this.list.setCellRenderer(new ListCellRenderer<Entity>(){

            @Override
            public Component getListCellRendererComponent(JList<? extends Entity> jList, Entity entity, int n, boolean bl, boolean bl2) {
                if (bl) {
                    entity.getComponent().setBackground(jList.getSelectionBackground());
                } else {
                    entity.getComponent().setBackground(jList.getBackground());
                }
                return entity.getComponent();
            }
        });
        this.list.setDragEnabled(true);
        this.list.setFocusable(false);
        this.list.setSelectionMode(0);
        this.setFocusable(false);
        this.setTileset(levelSpriteTileset, palette, spriteTilesetArray, spriteContainerArray);
    }

    public void setTileset(LevelSpriteTileset levelSpriteTileset, Palette palette, SpriteTileset[] spriteTilesetArray, SpriteContainer[] spriteContainerArray) {
        int n;
        int n2;
        if (this.tileset != null && this.tileset != levelSpriteTileset) {
            this.tileset.removeChangeListener(this.tilesetChangeListener);
        }
        if (this.palette != null && this.palette != palette) {
            this.palette.removeChangeListener(this.paletteChangeListener);
        }
        if (this.sprites != null) {
            SpriteContainer[] spriteContainerArray2 = this.sprites;
            n2 = this.sprites.length;
            n = 0;
            while (n < n2) {
                SpriteContainer spriteContainer = spriteContainerArray2[n];
                spriteContainer.removeChangeListener(this.spriteChangeListener);
                ++n;
            }
        }
        this.tileset = levelSpriteTileset;
        this.palette = palette;
        this.spriteTilesets = spriteTilesetArray;
        this.sprites = spriteContainerArray;
        int n3 = 0;
        Object[] objectArray = palette.getColors();
        int n4 = objectArray.length;
        n2 = 0;
        while (n2 < n4) {
            n = objectArray[n2];
            int n5 = (n & 0x30) >> 4;
            int n6 = (n & 0xC) >> 2;
            int n7 = n & 3;
            this.colors[n3++] = new Color(n7 * 255 / 3, n6 * 255 / 3, n5 * 255 / 3);
            ++n2;
        }
        levelSpriteTileset.addChangeListener(this.tilesetChangeListener);
        palette.addChangeListener(this.paletteChangeListener);
        objectArray = spriteContainerArray;
        n4 = spriteContainerArray.length;
        n2 = 0;
        while (n2 < n4) {
            int n8 = objectArray[n2];
            if (!n8.isAlexSprite()) {
                n8.addChangeListener(this.spriteChangeListener);
            }
            ++n2;
        }
        this.update();
    }

    private void update() {
        Object object;
        if (!this.isVisible()) {
            return;
        }
        this.minWidth = 0;
        TreeSet<SpriteTileset> treeSet = new TreeSet<SpriteTileset>(new Comparator<SpriteTileset>(){

            @Override
            public int compare(SpriteTileset spriteTileset, SpriteTileset spriteTileset2) {
                return spriteTileset.getDestination() - spriteTileset2.getDestination();
            }
        });
        Object object2 = this.spriteTilesets;
        int n = this.spriteTilesets.length;
        int n2 = 0;
        while (n2 < n) {
            object = object2[n2];
            if (this.tileset.isSubTileset((SpriteTileset)object)) {
                treeSet.add((SpriteTileset)object);
            }
            ++n2;
        }
        object = new Vector();
        final int[] nArray = new int[65536];
        final Z80 z80 = Z80Factory.create(nArray);
        object2 = new TMS9918A(262);
        int[] nArray2 = ((TMS9918A)object2).getVRAM();
        System.arraycopy(this.tileset.getVRAM(), 0, nArray2, 0, nArray2.length);
        z80.addOutputListener(new OutputListener((TMS9918A)object2){
            private final /* synthetic */ TMS9918A val$vdp;
            {
                this.val$vdp = tMS9918A;
            }

            @Override
            public void outputAvailable(int n, int n2, int n3) {
                if (n == 49158 && n2 != 0) {
                    System.err.println("Writing to inputData is forbidden!");
                    z80.reset();
                } else if (n == 65533) {
                    System.err.println("Bank 0 mapping is forbidden because it's unsupported by the Everdrive!");
                    z80.reset();
                } else if (n == 65534) {
                    RomManager.getInstance().loadBank1(nArray, n2);
                } else if (n == 65535) {
                    RomManager.getInstance().loadBank2(nArray, n2);
                } else if (n < 256) {
                    switch (n >> 6) {
                        case 0: 
                        case 3: {
                            if (n2 >= 0) break;
                            z80.setInput(255);
                            break;
                        }
                        case 1: {
                            if (n2 >= 0) break;
                            z80.setInput(0);
                            break;
                        }
                        case 2: {
                            if (n2 < 0) {
                                z80.setInput(this.val$vdp.readByte(n & 1, n3));
                                break;
                            }
                            this.val$vdp.processInput(n & 1, n2, n3);
                        }
                    }
                }
            }
        });
        final boolean[] blArray = new boolean[1];
        ((TMS9918A)object2).addOutputListener(new OutputListener(){

            @Override
            public void outputAvailable(int n, int n2, int n3) {
                if (n == 3 && (n2 & 0x8000) != 0) {
                    blArray[0] = true;
                }
            }
        });
        RomManager.getInstance().copyFromROM(0, nArray, 0, 49152);
        nArray[10607] = 201;
        nArray[49400] = 1;
        int n3 = 1;
        while (n3 <= 99) {
            boolean bl = false;
            int n4 = 6;
            while (!bl && n4 >= 5) {
                int n5 = 0;
                boolean bl2 = false;
                int n6 = 0;
                while (n6 < 10) {
                    block24: {
                        BufferedImage bufferedImage;
                        block26: {
                            int n7;
                            int n8;
                            int n9;
                            int n10;
                            block25: {
                                int n11;
                                if (n3 == 36 && n6 != 1) break block24;
                                int n12 = 49920 + n4 * 32;
                                nArray[49401] = n12 & 0xFF;
                                nArray[49402] = n12 >> 8;
                                Arrays.fill(nArray, 49920, 49952, 0);
                                Arrays.fill(nArray, n12, n12 + 32, 0);
                                nArray[n12] = n3;
                                nArray[n12 + 3] = n6;
                                nArray[n12 + 12] = 64;
                                nArray[n12 + 14] = 64;
                                nArray[n12 + 9] = 255;
                                nArray[50950] = 208;
                                nArray[49279] = 0;
                                nArray[31931] = 54;
                                nArray[31932] = 128;
                                nArray[31933] = 201;
                                if (blArray[0]) {
                                    System.arraycopy(this.tileset.getVRAM(), 0, nArray2, 0, nArray2.length);
                                    blArray[0] = false;
                                }
                                z80.execute(this.addressUpdateEntities);
                                int n13 = nArray[n12 + 8] << 8 | nArray[n12 + 7];
                                if (n13 == 0) break;
                                if (n13 == n5 && !bl2) break block24;
                                n5 = n13;
                                nArray[1230] = 201;
                                z80.execute(this.addressUpdateEntities);
                                nArray[n12 + 12] = 64;
                                nArray[n12 + 14] = 64;
                                nArray[n12 + 9] = 0;
                                z80.execute(this.addressUpdateEntities);
                                if ((nArray[n12 + 1] & 1) == 0 && nArray[n12 + 26] == 0 && n13 != 32993) break;
                                n10 = 256;
                                n9 = 0;
                                n8 = 256;
                                n7 = 0;
                                int n14 = 0;
                                int n15 = 6;
                                while (n15 < 64 && nArray[50944 + n15] != 208) {
                                    n11 = nArray[50944 + n15] + 1;
                                    if (n11 >= 240) {
                                        n11 -= 256;
                                    }
                                    int n16 = nArray[0xC780 | n15 << 1];
                                    if (n11 < n10) {
                                        n10 = n11;
                                    }
                                    if (n11 + 8 > n9) {
                                        n9 = n11 + 8;
                                    }
                                    if (n16 < n8) {
                                        n8 = n16;
                                    }
                                    if (n16 + 8 > n7) {
                                        n7 = n16 + 8;
                                    }
                                    ++n14;
                                    ++n15;
                                }
                                if (n7 <= n8 || n9 <= n10 || n7 - n8 > 64 || n9 - n10 > 64) break block24;
                                n15 = 1;
                                n11 = 1;
                                bufferedImage = new BufferedImage(n7 - n8, n9 - n10, 2);
                                Tileset tileset = null;
                                int n17 = 6;
                                while (n11 != 0 && n17 < 64 && nArray[50944 + n17] != 208) {
                                    int n18 = nArray[50944 + n17] + 1;
                                    if (n18 >= 240) {
                                        n18 -= 256;
                                    }
                                    int n19 = nArray[0xC780 | n17 << 1];
                                    int n20 = nArray[0xC780 | n17 << 1 | 1];
                                    if (tileset == null) {
                                        for (SpriteTileset spriteTileset : treeSet) {
                                            if ((0x2000 | n20 << 5) < spriteTileset.getDestination()) break;
                                            tileset = spriteTileset;
                                        }
                                    }
                                    if (tileset != null) {
                                        int n21 = tileset.getLength() / 32;
                                        if (n14 < n21 / 4) {
                                            n11 = 0;
                                        }
                                        if ((0x2000 | n20 << 5) >= tileset.getDestination() + tileset.getLength()) {
                                            n11 = 0;
                                        }
                                    }
                                    if (Renderer.renderSpriteCharacter(nArray2, n20, n19 - n8, n18 - n10, this.colors, bufferedImage)) {
                                        n15 = 0;
                                    }
                                    ++n17;
                                }
                                if (n11 == 0) break block24;
                                if (n15 == 0) break block25;
                                if (n7 - n8 > 8 || n9 - n10 > 8) break block24;
                                n7 = n8 + 16;
                                n9 = n10 + 14;
                                bufferedImage = new BufferedImage(n7 - n8, n9 - n10, 2);
                                Graphics2D graphics2D = bufferedImage.createGraphics();
                                graphics2D.setColor(new Color(0.5f, 0.5f, 0.5f, 0.5f));
                                graphics2D.fillRect(0, 0, 16, 12);
                                graphics2D.setColor(Color.RED);
                                graphics2D.drawString(String.format("%02X", n3), 0, 10);
                                graphics2D.dispose();
                                break block26;
                            }
                            if (n7 - n8 < 8 && n9 - n10 < 8) break block24;
                        }
                        ((Vector)object).add(new Entity(n4, n3, n6, bufferedImage));
                        bl = true;
                    }
                    ++n6;
                }
                --n4;
            }
            ++n3;
        }
        this.list.setListData((Vector<Entity>)object);
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        this.update();
    }

    @Override
    public boolean isValidateRoot() {
        return false;
    }

    @Override
    public void setScaleParent(Scalable scalable) {
        if (scalable == null) {
            throw new IllegalArgumentException("ScaleParent must not be null.");
        }
        if (scalable != this.scaleParent && this.scaleParent != null) {
            this.scaleParent.removeScaleListener(this);
        }
        this.scaleParent = scalable;
        this.prevPreferredScale = 0.0f;
        this.prevPrevPreferredScale = 0.0f;
        scalable.addScaleListener(this);
    }

    @Override
    public float getScale() {
        return this.scale;
    }

    @Override
    public Dimension getPreferredSize() {
        int n = Math.max(this.getVerticalScrollBar().getPreferredSize().width + this.minWidth, super.getPreferredSize().width);
        return new Dimension(n, 0);
    }

    @Override
    public void setBackground(Color color) {
        if (this.list != null) {
            this.list.setBackground(color);
        } else {
            super.setBackground(color);
        }
    }

    @Override
    public float getPreferredScale() {
        return this.scale;
    }

    @Override
    public boolean isIntegerScaling() {
        return false;
    }

    @Override
    public void setPreferredScale(float f) {
        float f2 = this.scale;
        if (f < this.prevPreferredScale || f != this.prevPrevPreferredScale) {
            this.scale = f;
        }
        this.prevPrevPreferredScale = this.prevPreferredScale;
        this.prevPreferredScale = f;
        if (Math.abs(this.scale - f2) > 0.01f) {
            this.minWidth = 0;
            ListModel<Entity> listModel = this.list.getModel();
            Entity[] entityArray = new Entity[listModel.getSize()];
            int n = 0;
            while (n < entityArray.length) {
                Entity entity = listModel.getElementAt(n);
                entity.updateImage();
                entityArray[n] = entity;
                ++n;
            }
            this.list.setListData((Entity[])entityArray);
        }
    }

    @Override
    public void setIntegerScaling(boolean bl) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addScaleListener(ScaleListener scaleListener) {
    }

    @Override
    public void removeScaleListener(ScaleListener scaleListener) {
    }

    private final class Entity {
        private final int slot;
        private final int type;
        private final int extra;
        private final JComponent component;
        private final JLabel label;
        private final BufferedImage image;

        public Entity(int n, int n2, int n3, BufferedImage bufferedImage) {
            this.slot = n;
            this.type = n2;
            this.extra = n3;
            this.component = new JPanel();
            this.image = bufferedImage;
            this.label = new JLabel(new ImageIcon(bufferedImage.getScaledInstance((int)((float)bufferedImage.getWidth() * EntityList.this.scale), (int)((float)bufferedImage.getHeight() * EntityList.this.scale), 0)));
            this.component.add(this.label);
            String string = EntityList.this.entityLabelProvider.getLabel(n2, n3);
            if (string != null) {
                this.component.setToolTipText(String.format("%s (%02X%s)", string, n2, n3 > 0 ? "-" + String.format("%02X", n3) : ""));
            } else {
                this.component.setToolTipText(String.format("%02X%s", n2, n3 > 0 ? "-" + String.format("%02X", n3) : ""));
            }
        }

        public JComponent getComponent() {
            return this.component;
        }

        public void updateImage() {
            this.label.setIcon(new ImageIcon(this.image.getScaledInstance((int)((float)this.image.getWidth() * EntityList.this.scale), (int)((float)this.image.getHeight() * EntityList.this.scale), 0)));
            int n = this.label.getPreferredSize().width;
            if (n > EntityList.this.minWidth) {
                EntityList.this.minWidth = n;
            }
        }

        public String toString() {
            return String.format("%X,%X,%X", this.slot, this.type, this.extra);
        }
    }
}

