/*
 * Decompiled with CFR 0.152.
 */
package vgm;

import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import vgm.VGMInputStream;
import vgm.VGMListener;

public class VGMInterpreter {
    public static final int SAMPLES_PER_SECOND = 44100;
    public static final int SAMPLES_PER_FRAME_NTSC = 735;
    public static final int SAMPLES_PER_FRAME_PAL = 882;
    private final VGMInputStream input;
    private final int samplesPerFrame;
    private int samplesToWait;
    private LinkedList<VGMListener> listenerList = new LinkedList();
    private VGMListener[] listeners = new VGMListener[0];

    public VGMInterpreter(File file) throws IOException {
        this.input = new VGMInputStream(file);
        int n = this.input.getRate();
        this.samplesPerFrame = n == 0 ? 735 : 44100 / n;
    }

    public boolean run(int n) throws IOException {
        if (n == 0) {
            n = this.samplesPerFrame;
        }
        n -= this.samplesToWait;
        while (n > 0) {
            int n2;
            if (this.input.isLoopPoint()) {
                this.fireLoopPointHit();
            }
            if (((n2 = this.input.read()) & 0xF0) == 112) {
                n -= (n2 & 0xF) + 1;
                continue;
            }
            switch (n2) {
                case 79: {
                    this.input.read();
                    break;
                }
                case 80: {
                    this.fireWritePSGport(this.input.read());
                    break;
                }
                case 97: {
                    n -= this.input.readShort();
                    break;
                }
                case 98: {
                    n -= 735;
                    break;
                }
                case 99: {
                    n -= 882;
                    break;
                }
                case 102: {
                    this.close();
                    return false;
                }
                case 144: {
                    this.input.skip(4L);
                    System.out.println("Skipped \"Setup Stream Control\"");
                    break;
                }
                case 145: {
                    this.input.skip(4L);
                    System.out.println("Skipped \"Set Stream Data\"");
                    break;
                }
                case 146: {
                    this.input.skip(5L);
                    System.out.println("Skipped \"Set Stream Frequency\"");
                    break;
                }
                default: {
                    this.close();
                    throw new IOException("Unknown VGM command encountered at " + Integer.toHexString(this.input.getPosition() - 1) + ": " + Integer.toHexString(n2));
                }
            }
        }
        if (n <= 0) {
            this.samplesToWait = -n;
        }
        return true;
    }

    public int getTotalSamples() {
        return this.input.getTotalSamples();
    }

    public void close() throws IOException {
        this.input.close();
    }

    protected final void fireWritePSGport(int n) {
        VGMListener[] vGMListenerArray = this.listeners;
        int n2 = this.listeners.length;
        int n3 = 0;
        while (n3 < n2) {
            VGMListener vGMListener = vGMListenerArray[n3];
            vGMListener.writePSGport(n);
            ++n3;
        }
    }

    protected final void fireLoopPointHit() {
        VGMListener[] vGMListenerArray = this.listeners;
        int n = this.listeners.length;
        int n2 = 0;
        while (n2 < n) {
            VGMListener vGMListener = vGMListenerArray[n2];
            vGMListener.loopPointHit();
            ++n2;
        }
    }

    public final void addVGMPortListener(VGMListener vGMListener) {
        this.listenerList.addFirst(vGMListener);
        this.listeners = this.listenerList.toArray(new VGMListener[this.listenerList.size()]);
    }

    public final void removeVGMPortListener(VGMListener vGMListener) {
        this.listenerList.remove(vGMListener);
        this.listeners = this.listenerList.toArray(new VGMListener[this.listenerList.size()]);
    }
}

