/*
 * Decompiled with CFR 0.152.
 */
package util.queue;

import java.util.Arrays;
import java.util.Iterator;

public class CyclicIntBuffer
implements Iterable<Integer> {
    final int[] elements;
    final int MASK;
    private final CyclicIntBufferIterator ITERATOR = new CyclicIntBufferIterator();
    int head;

    public CyclicIntBuffer(int n) {
        --n;
        n |= n >>> 1;
        n |= n >>> 2;
        n |= n >>> 4;
        n |= n >>> 8;
        n |= n >>> 16;
        if (++n < 0) {
            n >>>= 1;
        }
        this.elements = new int[n];
        this.MASK = this.elements.length - 1;
    }

    public void fill(int n) {
        Arrays.fill(this.elements, n);
    }

    public void add(int n) {
        this.head = this.head - 1 & this.MASK;
        this.elements[this.head] = n;
    }

    public int indexOf(int n, int n2) {
        int n3 = this.head + n2 & this.MASK;
        do {
            if (this.elements[n3] != n) continue;
            return n3 - this.head & this.MASK;
        } while ((n3 = n3 + 1 & this.MASK) != this.head);
        return -1;
    }

    public int indexOf(int n) {
        return this.indexOf(n, 0);
    }

    public int get(int n) {
        return this.elements[this.head + n & this.MASK];
    }

    @Override
    public Iterator<Integer> iterator() {
        return this.ITERATOR.reset();
    }

    public int size() {
        return this.elements.length;
    }

    class CyclicIntBufferIterator
    implements Iterator<Integer> {
        private int cursor;
        private boolean isFirst;

        CyclicIntBufferIterator() {
            this.cursor = CyclicIntBuffer.this.head;
            this.isFirst = true;
        }

        @Override
        public boolean hasNext() {
            return this.isFirst || this.cursor != CyclicIntBuffer.this.head;
        }

        @Override
        public Integer next() {
            Integer n = CyclicIntBuffer.this.elements[this.cursor];
            this.isFirst = false;
            this.cursor = this.cursor + 1 & CyclicIntBuffer.this.MASK;
            return n;
        }

        public Iterator<Integer> reset() {
            this.cursor = CyclicIntBuffer.this.head;
            this.isFirst = true;
            return this;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

