/*
 * Decompiled with CFR 0.152.
 */
package miracleworld;

import changes.Changable;
import changes.Change;
import changes.ChangeListener;
import data.BonusLevel;
import data.CompressedNameTable;
import data.CompressedTiles;
import data.Demo;
import data.GameSettings;
import data.JankenMatch;
import data.Level;
import data.LevelPalette;
import data.LevelSpriteTileset;
import data.LevelTileset;
import data.NameTable;
import data.Palette;
import data.PaletteCycle;
import data.Physics;
import data.Riddle;
import data.Shop;
import data.Sound;
import data.Sprite;
import data.SpriteContainer;
import data.SpriteTileset;
import data.TextData;
import data.Tiles;
import data.Tileset;
import data.TitleScreen;
import editor.Z80Factory;
import editormodels.GameDataModel;
import editors.KiddEd;
import editors.TileEditor;
import editors.TilesetEditor;
import hacks.Hack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import mastersystem.OutputListener;
import mastersystem.TMS9918A;
import mastersystem.Z80;
import miracleworld.MiracleWorldAddresses;
import miracleworld.MiracleWorldEditorModel;
import miracleworld.MiracleWorldHacks;
import miracleworld.data.MiracleWorldMetaTileset;
import patching.IPS;
import rom.RomManager;
import transactions.TransactionManager;

public class MiracleWorldDataModel
implements GameDataModel,
MiracleWorldAddresses {
    private final CompressedTiles.TileDecompressor levelTilesetsDecompressor = new CompressedTiles.TileDecompressor(){

        @Override
        public void decompress(CompressedTiles compressedTiles) {
            MiracleWorldDataModel.this.decompressLevelTilesets();
        }
    };
    private final CompressedTiles.TileDecompressor jankenMatchTilesDecompressor = new CompressedTiles.TileDecompressor(){

        @Override
        public void decompress(CompressedTiles compressedTiles) {
            MiracleWorldDataModel.this.decompressJankenMatchTiles();
        }
    };
    private final CompressedTiles.TileDecompressor shopTilesDecompressor = new CompressedTiles.TileDecompressor(){

        @Override
        public void decompress(CompressedTiles compressedTiles) {
            MiracleWorldDataModel.this.decompressShopNameTableAndTiles();
        }
    };
    protected Palette[] palettes;
    protected LevelPalette[] levelPalettes;
    protected Palette[] nameTablePalettes;
    protected Tileset[] tilesets;
    protected Tileset[] levelTilesets;
    protected CompressedTiles[] levelMainTilesets;
    protected Tiles[] levelAdditionalTilesets;
    protected CompressedTiles[] jankenMatchTiles;
    protected SpriteTileset[] spriteTilesets;
    protected Tileset[] nameTableTilesets;
    protected Tiles[] tiles;
    protected NameTable[] nameTables;
    protected NameTable[] titleScreenNameTables;
    protected MiracleWorldMetaTileset[] metaTilesets;
    protected SpriteContainer[] sprites;
    protected Level[] levels;
    protected TitleScreen titleScreen;
    protected Shop shop;
    protected JankenMatch jankenMatch;
    protected Riddle riddle;
    protected TextData textData;
    protected GameSettings initialValues;
    protected Physics physics;
    protected Sound sound;
    protected Demo demo;
    private static int[] levelNumbers = new int[19];

    static {
        int n = 0;
        while (n < 17) {
            MiracleWorldDataModel.levelNumbers[n] = n;
            ++n;
        }
        MiracleWorldDataModel.levelNumbers[17] = 2;
        MiracleWorldDataModel.levelNumbers[18] = 16;
    }

    @Override
    public Hack[] getHacks() {
        return MiracleWorldHacks.getHacks();
    }

    @Override
    public void parseData() {
        if (RomManager.StaticAccess.readWord(2909) != 26033) {
            throw new IllegalArgumentException();
        }
        MiracleWorldDataModel.avoidSlot0mapping();
        this.levelMainTilesets = this.parseLevelMainTilesets(3692, 17, 11);
        this.levelAdditionalTilesets = this.parseLevelAdditionalTilesets(3692, 17, 6);
        this.jankenMatchTiles = this.parseJankenMatchTiles();
        this.tiles = this.parseTiles(this.levelMainTilesets, this.levelAdditionalTilesets, this.jankenMatchTiles);
        this.tilesets = this.parseTilesets(this.tiles, this.levelMainTilesets, this.levelAdditionalTilesets, 17);
        this.spriteTilesets = MiracleWorldDataModel.parseSpriteTilesets(4418, this.tiles[1], this.tiles[2], 17);
        this.nameTables = this.parseNameTables();
        this.palettes = this.parsePalettes();
        this.levels = MiracleWorldDataModel.parseLevelDescriptors(RomManager.StaticAccess.readWord(2909), 17);
        this.metaTilesets = MiracleWorldDataModel.parseMetaTilesets(this.levels);
        this.sprites = MiracleWorldDataModel.parseSprites(32768);
        this.titleScreen = new TitleScreen(1909);
        this.shop = new Shop();
        this.jankenMatch = new JankenMatch(30289);
        this.riddle = new Riddle(15856);
        this.textData = new TextData(32485);
        this.initialValues = new GameSettings(2084);
        this.physics = new Physics();
        this.sound = new Sound(38991);
        this.demo = new Demo(2614, 2684, 2688, 2548);
        int n = 0;
        while (n < 17) {
            SpriteTileset[] spriteTilesetArray = this.spriteTilesets;
            int n2 = this.spriteTilesets.length;
            int n3 = 0;
            while (n3 < n2) {
                SpriteTileset spriteTileset = spriteTilesetArray[n3];
                this.levelTilesets[n * 2 + 1].addTilesetListener(spriteTileset);
                ++n3;
            }
            ++n;
        }
        this.convertUncompressedAdditionalTilesets();
        this.applyAfterOpenFixes();
    }

    private Palette[] parsePalettes() {
        this.nameTablePalettes = new Palette[4];
        this.nameTablePalettes[0] = new Palette(2002, 2);
        this.nameTablePalettes[1] = new Palette(7654, 2);
        this.nameTablePalettes[2] = new Palette(9021, 2);
        this.nameTablePalettes[2].addChangeListener(new ChangeListener(){

            @Override
            public void changeOccurred(Change change) {
                RomManager.StaticAccess.writeWord(6763, RomManager.StaticAccess.readWord(9021));
            }
        });
        this.nameTablePalettes[3] = new Palette(9703, 2){

            @Override
            protected int getAddress() {
                if (MiracleWorldDataModel.isHirottaStonePaletteRelocated()) {
                    return super.getAddress() + 5;
                }
                return super.getAddress();
            }

            @Override
            protected int getBank() {
                if (MiracleWorldDataModel.isHirottaStonePaletteRelocated()) {
                    return RomManager.StaticAccess.readByte(9703);
                }
                return super.getBank();
            }
        };
        Palette[] paletteArray = new Palette[24];
        this.levelPalettes = new LevelPalette[levelNumbers.length];
        int n = 0;
        while (n < 17) {
            this.levelPalettes[n] = new LevelPalette(n);
            paletteArray[n] = this.levelPalettes[n];
            ++n;
        }
        n = 2;
        if (RomManager.StaticAccess.readByte(5991) == 61) {
            --n;
        } else if (RomManager.StaticAccess.readByte(5991) == 60 || RomManager.StaticAccess.readByte(5998) == 60) {
            ++n;
        }
        this.levelPalettes[17] = this.levelPalettes[n];
        this.levelPalettes[18] = this.levelPalettes[16];
        int n2 = 0;
        while (n2 < this.nameTablePalettes.length) {
            paletteArray[17 + n2] = this.nameTablePalettes[n2];
            ++n2;
        }
        paletteArray[17 + this.nameTablePalettes.length] = new PaletteCycle(2137);
        paletteArray[17 + this.nameTablePalettes.length + 1] = new PaletteCycle(4262);
        paletteArray[17 + this.nameTablePalettes.length + 2] = new PaletteCycle(4300);
        return paletteArray;
    }

    private CompressedTiles[] parseLevelMainTilesets() {
        return this.parseLevelMainTilesets(3692, 17, 11);
    }

    private CompressedTiles[] parseLevelMainTilesets(final int n, final int n2, int n3) {
        Tiles tiles;
        int n4;
        int n5;
        TreeMap<Integer, Tiles> treeMap = new TreeMap<Integer, Tiles>();
        int n6 = n;
        while (RomManager.StaticAccess.readByte(n6) != 201) {
            if (RomManager.StaticAccess.readByte(n6) == 33 && RomManager.StaticAccess.readByte(n6 + 3) == 231) break;
            if (RomManager.StaticAccess.readByte(n6) == 33 || RomManager.StaticAccess.readByte(n6) == 17 || RomManager.StaticAccess.readByte(n6) == 205 || RomManager.StaticAccess.readByte(n6) == 58) {
                n6 += 2;
            }
            ++n6;
        }
        int n7 = 3;
        boolean bl = MiracleWorldDataModel.hasLevelTilesetsPerLevel();
        if (RomManager.StaticAccess.readByte(n6) == 33 && RomManager.StaticAccess.readByte(n6 + 3) == 231) {
            int n8 = RomManager.StaticAccess.readWord(n6 + 1) + 2;
            int n9 = 0;
            while (n9 < n2) {
                n6 = RomManager.StaticAccess.readWord(n8 + n9 * 2);
                while (RomManager.StaticAccess.readByte(n6) != 201 && RomManager.StaticAccess.readByte(n6) != 195) {
                    if (bl && RomManager.StaticAccess.readByte(n6) == 17 && RomManager.StaticAccess.readByte(n6 + 3) == 205 && RomManager.StaticAccess.readWord(n6 + 4) == 4199 || RomManager.StaticAccess.readByte(n6) == 33 && RomManager.StaticAccess.readByte(n6 + 3) == 215 && RomManager.StaticAccess.readByte(n6 + 4) == 17 && (RomManager.StaticAccess.readByte(n6 + 7) == 205 || RomManager.StaticAccess.readByte(n6 + 7) == 195) && RomManager.StaticAccess.readByte(n6 - 3) == 58) {
                        n5 = bl ? 4199 : RomManager.StaticAccess.readWord(n6 + 8);
                        while (RomManager.StaticAccess.readByte(n5) != 201) {
                            if (RomManager.StaticAccess.readByte(n5) == 62 && RomManager.StaticAccess.readByte(n5 + 2) == 50 && RomManager.StaticAccess.readByte(n5 + 3) == 255 && RomManager.StaticAccess.readByte(n5 + 4) == 255) {
                                n7 = RomManager.StaticAccess.readByte(n5 + 1);
                                break;
                            }
                            if (RomManager.StaticAccess.readByte(n5) == 33 || RomManager.StaticAccess.readByte(n5) == 17 || RomManager.StaticAccess.readByte(n5) == 1 || RomManager.StaticAccess.readByte(n5) == 205 || RomManager.StaticAccess.readByte(n5) == 58) {
                                n5 += 2;
                            }
                            if (RomManager.StaticAccess.readByte(n5) == 46 || RomManager.StaticAccess.readByte(n5) == 62) {
                                ++n5;
                            }
                            ++n5;
                        }
                        n8 = bl ? RomManager.StaticAccess.readWord(4203) : RomManager.StaticAccess.readWord(n6 + 1);
                        n5 = 0;
                        while (n5 < n2) {
                            n4 = RomManager.RESOLVE_ADDRESS(RomManager.StaticAccess.READ_WORD(n8 + (n5 + 1) * 2, 3), n7);
                            if (!treeMap.containsKey(n4)) {
                                tiles = new CompressedTiles(659, n4, bl ? RomManager.StaticAccess.readWord(n6 + 1) : RomManager.StaticAccess.readWord(n6 + 5), false, this.levelTilesetsDecompressor);
                                if (tiles.isValid()) {
                                    treeMap.put(n4, tiles);
                                } else {
                                    System.err.println("Level Main Tileset at " + Integer.toHexString(tiles.getSource()) + " is invalid. Used in level " + Integer.toHexString(n5 + 1));
                                }
                            }
                            ++n5;
                        }
                        break;
                    }
                    if (RomManager.StaticAccess.readByte(n6) == 33 || RomManager.StaticAccess.readByte(n6) == 17 || RomManager.StaticAccess.readByte(n6) == 1 || RomManager.StaticAccess.readByte(n6) == 205 || RomManager.StaticAccess.readByte(n6) == 58) {
                        n6 += 2;
                    }
                    if (RomManager.StaticAccess.readByte(n6) == 46 || RomManager.StaticAccess.readByte(n6) == 62) {
                        ++n6;
                    }
                    ++n6;
                }
                ++n9;
            }
        }
        if (treeMap.size() < n3) {
            final Tiles[][] tilesArray = new Tiles[1][];
            KiddEd.runWithOriginalROM(new Runnable(){

                @Override
                public void run() {
                    tilesArray[0] = MiracleWorldDataModel.this.parseLevelMainTilesets(n, n2, 0);
                }
            });
            Tiles[] tilesArray2 = tilesArray[0];
            n5 = 0;
            n6 = n7 * 16384;
            n4 = n6 + 16384;
            while (n6 < n4 && n5 < tilesArray2.length) {
                tiles = (Tiles)treeMap.get(n6);
                while (tiles != null) {
                    ++n5;
                    tiles = (Tiles)treeMap.get(n6 += tiles.getSize());
                }
                if (n5 >= tilesArray2.length) continue;
                tiles = new CompressedTiles(659, n6, 0x4000 | tilesArray2[n5].getDestination(), false, this.levelTilesetsDecompressor);
                if (n7 == (RomManager.StaticAccess.READ_BYTE(6929, 0) & 0x3F) && (0x8000 | n6 & 0x3FFF) == RomManager.StaticAccess.readWord(6934)) {
                    n6 += tiles.getSize();
                    continue;
                }
                if (!((CompressedTiles)tiles).isValid()) {
                    Integer n10 = treeMap.higherKey(n6);
                    if (n10 == null) {
                        n10 = n4;
                    }
                    while (n6 < n10 && n5 < tilesArray2.length) {
                        int n11 = KiddEd.findRLEpattern(n6, n10);
                        if (n11 < 0) {
                            n6 = n10;
                            continue;
                        }
                        n6 = n11;
                        tiles = new CompressedTiles(659, n6, 0x4000 | tilesArray2[n5].getDestination(), false, this.levelTilesetsDecompressor);
                        if (((CompressedTiles)tiles).isValid()) {
                            treeMap.put(n6, tiles);
                            ++n5;
                            n6 += tiles.getSize();
                            continue;
                        }
                        ++n6;
                    }
                    continue;
                }
                treeMap.put(n6, tiles);
                ++n5;
                n6 += tiles.getSize();
            }
        }
        return treeMap.values().toArray(new CompressedTiles[treeMap.size()]);
    }

    private Tiles[] parseLevelAdditionalTilesets() {
        return this.parseLevelAdditionalTilesets(3692, 17, 6);
    }

    private Tiles[] parseLevelAdditionalTilesets(final int n, final int n2, int n3) {
        int n4;
        TreeMap<Integer, Tiles> treeMap = new TreeMap<Integer, Tiles>();
        int n5 = n;
        while (RomManager.StaticAccess.readByte(n5) != 201) {
            if (RomManager.StaticAccess.readByte(n5) == 33 && RomManager.StaticAccess.readByte(n5 + 3) == 231) break;
            if (RomManager.StaticAccess.readByte(n5) == 33 || RomManager.StaticAccess.readByte(n5) == 17 || RomManager.StaticAccess.readByte(n5) == 205 || RomManager.StaticAccess.readByte(n5) == 58) {
                n5 += 2;
            }
            ++n5;
        }
        int n6 = 0;
        if (RomManager.StaticAccess.readByte(n5) == 33 && RomManager.StaticAccess.readByte(n5 + 3) == 231) {
            int n7 = RomManager.StaticAccess.readWord(n5 + 1) + 2;
            int n8 = 0;
            while (n8 < n2) {
                n5 = RomManager.StaticAccess.readWord(n7 + n8 * 2);
                while (RomManager.StaticAccess.readByte(n5) != 201 && RomManager.StaticAccess.readByte(n5) != 195) {
                    if (RomManager.StaticAccess.readByte(n5) == 33 && RomManager.StaticAccess.readByte(n5 + 3) == 17 && !treeMap.containsKey(n4 = RomManager.StaticAccess.READ_WORD(n5 + 1, 3))) {
                        if ((RomManager.StaticAccess.readByte(n5 + 6) == 205 || RomManager.StaticAccess.readByte(n5 + 6) == 195) && RomManager.StaticAccess.readWord(n5 + 7) == 659) {
                            if (n6 == 0) {
                                n6 = RomManager.StaticAccess.READ_WORD(n5 + 7, 3);
                            }
                            treeMap.put(n4, new CompressedTiles(RomManager.StaticAccess.READ_WORD(n5 + 7, 3), RomManager.RESOLVE_ADDRESS(n4, 3), RomManager.StaticAccess.READ_WORD(n5 + 4, 3), false, this.levelTilesetsDecompressor));
                        } else if (RomManager.StaticAccess.readByte(n5 + 8) == 247) {
                            treeMap.put(n4, new Tiles(48, RomManager.RESOLVE_ADDRESS(n4, 3), RomManager.StaticAccess.READ_WORD(n5 + 4, 3), RomManager.StaticAccess.readByte(n5 + 7), false));
                        }
                    }
                    if (RomManager.StaticAccess.readByte(n5) == 33 || RomManager.StaticAccess.readByte(n5) == 17 || RomManager.StaticAccess.readByte(n5) == 1 || RomManager.StaticAccess.readByte(n5) == 205 || RomManager.StaticAccess.readByte(n5) == 58) {
                        n5 += 2;
                    }
                    if (RomManager.StaticAccess.readByte(n5) == 46 || RomManager.StaticAccess.readByte(n5) == 62) {
                        ++n5;
                    }
                    ++n5;
                }
                ++n8;
            }
        }
        if (treeMap.size() < n3) {
            final Tiles[][] tilesArray = new Tiles[1][];
            KiddEd.runWithOriginalROM(new Runnable(){

                @Override
                public void run() {
                    tilesArray[0] = MiracleWorldDataModel.this.parseLevelAdditionalTilesets(n, n2, 0);
                }
            });
            Tiles[] tilesArray2 = tilesArray[0];
            n5 = (Integer)treeMap.firstKey();
            n4 = 0;
            while (n5 < 49152 && n4 < tilesArray2.length && (RomManager.StaticAccess.READ_BYTE(n5, 3) & 0x80) != 0) {
                int n9 = 0;
                Tiles tiles = (Tiles)treeMap.get(n5);
                while (tiles != null) {
                    n9 = n5;
                    ++n4;
                    tiles = (Tiles)treeMap.get(n5 += tiles.getSize());
                }
                if (n4 >= tilesArray2.length) continue;
                tiles = new CompressedTiles(n6, RomManager.RESOLVE_ADDRESS(n5, 3), 0x4000 | tilesArray2[n4].getDestination(), false, this.levelTilesetsDecompressor);
                if ((RomManager.StaticAccess.READ_BYTE(6929, 0) & 0x3F) == 3 && n5 == RomManager.StaticAccess.readWord(6934)) {
                    n5 += tiles.getSize();
                    continue;
                }
                if (!((CompressedTiles)tiles).isValid()) {
                    Integer n10 = treeMap.higherKey(n9);
                    if (n10 == null) {
                        n10 = 49152;
                    }
                    while (n5 < n10 && RomManager.StaticAccess.READ_BYTE(n5, 3) == 255 && (RomManager.StaticAccess.READ_BYTE(n5 + 1, 3) & 0x80) != 0) {
                        ++n5;
                    }
                    tiles = new CompressedTiles(n6, RomManager.RESOLVE_ADDRESS(n5, 3), 0x4000 | tilesArray2[n4].getDestination(), false, this.levelTilesetsDecompressor);
                    if (((CompressedTiles)tiles).isValid()) {
                        treeMap.put(n5, tiles);
                        ++n4;
                        n5 += tiles.getSize();
                        continue;
                    }
                    n5 = n10;
                    continue;
                }
                treeMap.put(n5, tiles);
                ++n4;
                n5 += tiles.getSize();
            }
        }
        return treeMap.values().toArray(new Tiles[treeMap.size()]);
    }

    private Tileset[] parseTilesets(Tiles[] tilesArray, Tiles[] tilesArray2, Tiles[] tilesArray3, int n) {
        this.nameTableTilesets = new Tileset[4];
        this.nameTableTilesets[0] = new Tileset(tilesArray[7 + tilesArray2.length + tilesArray3.length + 7]);
        Tiles tiles = tilesArray[2];
        final Tiles tiles2 = tilesArray[5];
        final Tiles tiles3 = tilesArray[7 + tilesArray2.length + tilesArray3.length + 3];
        final Tiles tiles4 = tilesArray[7 + tilesArray2.length + tilesArray3.length + 4];
        this.nameTableTilesets[1] = new Tileset(7563, 0, 0){

            @Override
            public boolean canSetTilesDestination(Tiles tiles) {
                return tiles == tiles2 || tiles == tiles3 || tiles == tiles4;
            }

            @Override
            public void setTilesDestination(Tiles tiles, int n) {
                if (n < 0) {
                    n = 0;
                }
                if (n + tiles.getLength() > 8192) {
                    n = 8192 - tiles.getLength();
                }
                if (tiles == tiles2) {
                    TransactionManager.getInstance().addTransactionObject(this, 0);
                    RomManager.StaticAccess.writeWord(7569, 0x4000 | n);
                    this.memory[7569] = RomManager.StaticAccess.readByte(7569);
                    this.memory[7570] = RomManager.StaticAccess.readByte(7570);
                    this.memoryDirty = true;
                } else if (tiles == tiles3) {
                    TransactionManager.getInstance().addTransactionObject(this, 0);
                    RomManager.StaticAccess.writeWord(7591, 0x4000 | n);
                    this.memory[7591] = RomManager.StaticAccess.readByte(7591);
                    this.memory[7592] = RomManager.StaticAccess.readByte(7592);
                    this.memoryDirty = true;
                } else if (tiles == tiles4) {
                    TransactionManager.getInstance().addTransactionObject(this, 0);
                    RomManager.StaticAccess.writeWord(7600, 0x4000 | n);
                    this.memory[7600] = RomManager.StaticAccess.readByte(7600);
                    this.memory[7601] = RomManager.StaticAccess.readByte(7601);
                    this.memoryDirty = true;
                } else {
                    super.setTilesDestination(tiles, n);
                }
            }

            @Override
            public int getTilesDestination(Tiles tiles) {
                if (tiles == tiles2) {
                    return RomManager.StaticAccess.readWord(7569) & 0x3FFF;
                }
                if (tiles == tiles3) {
                    return RomManager.StaticAccess.readWord(7591) & 0x3FFF;
                }
                if (tiles == tiles4) {
                    return RomManager.StaticAccess.readWord(7600) & 0x3FFF;
                }
                return -1;
            }

            @Override
            public Tiles getTilesAt(int n) {
                if (n >= this.getTilesDestination(tiles2) && n < this.getTilesDestination(tiles2) + tiles2.getLength()) {
                    return tiles2;
                }
                if (n >= this.getTilesDestination(tiles3) && n < this.getTilesDestination(tiles3) + tiles3.getLength()) {
                    return tiles3;
                }
                if (n >= this.getTilesDestination(tiles4) && n < this.getTilesDestination(tiles4) + tiles4.getLength()) {
                    return tiles4;
                }
                return null;
            }
        };
        this.nameTableTilesets[1].addTilesListener(tiles3);
        this.nameTableTilesets[1].addTilesListener(tiles4);
        this.nameTableTilesets[1].addTilesListener(tiles);
        this.nameTableTilesets[1].addTilesListener(tiles2);
        this.nameTableTilesets[2] = new Tileset(tilesArray[7 + tilesArray2.length + tilesArray3.length + 5]);
        this.nameTableTilesets[3] = new Tileset(tilesArray[7 + tilesArray2.length + tilesArray3.length + 2]);
        Tileset[] tilesetArray = new Tileset[n * 2 + 1];
        this.levelTilesets = new Tileset[levelNumbers.length * 2];
        int n2 = 0;
        while (n2 < n) {
            LevelTileset levelTileset = new LevelTileset(n2 + 1, tilesArray2, tilesArray3);
            levelTileset.addTiles(tilesArray[7 + tilesArray2.length + tilesArray3.length + 6]);
            levelTileset.addTiles(tilesArray[3]);
            levelTileset.addTilesListener(tilesArray[3]);
            levelTileset.addTilesListener(tilesArray[6]);
            levelTileset.addTilesListener(tilesArray[7 + tilesArray2.length + tilesArray3.length + 6]);
            int n3 = 0;
            while (n3 < tilesArray2.length) {
                if (levelTileset.getMainTilesetAddress() == (0x8000 | tilesArray2[n3].getSource() & 0x3FFF)) {
                    levelTileset.setMainTileset(tilesArray2[n3]);
                }
                ++n3;
            }
            tilesetArray[n2 * 2] = levelTileset;
            tilesetArray[n2 * 2 + 1] = new LevelSpriteTileset(n2 + 1);
            tilesetArray[n2 * 2 + 1].addTilesListener(tilesArray[0]);
            tilesetArray[n2 * 2 + 1].addTilesListener(tilesArray[2]);
            this.levelTilesets[n2 * 2] = tilesetArray[n2 * 2];
            this.levelTilesets[n2 * 2 + 1] = tilesetArray[n2 * 2 + 1];
            ++n2;
        }
        n2 = 2;
        if (RomManager.StaticAccess.readByte(5991) == 61) {
            --n2;
        } else if (RomManager.StaticAccess.readByte(5991) == 60 || RomManager.StaticAccess.readByte(5998) == 60) {
            ++n2;
        }
        this.levelTilesets[n * 2] = tilesetArray[n2 * 2];
        this.levelTilesets[n * 2 + 1] = tilesetArray[n2 * 2 + 1];
        this.levelTilesets[n * 2 + 2] = tilesetArray[32];
        this.levelTilesets[n * 2 + 3] = tilesetArray[33];
        tilesetArray[n * 2] = this.nameTableTilesets[1];
        return tilesetArray;
    }

    private NameTable[] parseNameTables() {
        this.titleScreenNameTables = new NameTable[2 + RomManager.StaticAccess.readByte(2124)];
        this.titleScreenNameTables[0] = new NameTable(1977, 1964, 403);
        this.titleScreenNameTables[1] = new NameTable(1989, 1964, 403);
        int n = 0;
        while (n < RomManager.StaticAccess.readByte(2124)) {
            this.titleScreenNameTables[2 + n] = new NameTable(RomManager.StaticAccess.readWord(2278 + n * 2), 2155, 403);
            ++n;
        }
        NameTable[] nameTableArray = new NameTable[this.titleScreenNameTables.length + 4];
        int n2 = 0;
        while (n2 < this.titleScreenNameTables.length) {
            nameTableArray[n2] = this.titleScreenNameTables[n2];
            ++n2;
        }
        nameTableArray[this.titleScreenNameTables.length] = new CompressedNameTable(7477, 3649, new CompressedNameTable.NameTableDecompressor(){

            @Override
            public void decompress(CompressedNameTable compressedNameTable) {
                MiracleWorldDataModel.this.decompressShopNameTableAndTiles();
            }
        });
        nameTableArray[this.titleScreenNameTables.length + 1] = new NameTable(7605, 7583, 403);
        nameTableArray[this.titleScreenNameTables.length + 2] = new NameTable(8663, 403);
        nameTableArray[this.titleScreenNameTables.length + 3] = new NameTable(9702, 403);
        return nameTableArray;
    }

    private static MiracleWorldMetaTileset[] parseMetaTilesets(Level[] levelArray) {
        MiracleWorldMetaTileset[] miracleWorldMetaTilesetArray = new MiracleWorldMetaTileset[17];
        int n = 0;
        while (n < miracleWorldMetaTilesetArray.length) {
            miracleWorldMetaTilesetArray[n] = new MiracleWorldMetaTileset(levelArray[n].getMetaTilesetPointerAddress(), levelArray[n].getBankAddress());
            ++n;
        }
        return miracleWorldMetaTilesetArray;
    }

    private static boolean isHirottaStonePaletteRelocated() {
        return RomManager.StaticAccess.readByte(9702) == 62 && RomManager.StaticAccess.readByte(9704) == 50 && RomManager.StaticAccess.readWord(9705) == 65535;
    }

    protected Palette[] getPalettes() {
        return this.palettes;
    }

    protected Tileset[] getTilesets() {
        return this.tilesets;
    }

    protected Tileset[] getLevelTilesets() {
        return this.levelTilesets;
    }

    protected CompressedTiles[] getLevelMainTilesets() {
        return this.levelMainTilesets;
    }

    protected Tiles[] getLevelAdditionalTilesets() {
        return this.levelAdditionalTilesets;
    }

    protected CompressedTiles[] getJankenMatchTiles() {
        return this.jankenMatchTiles;
    }

    protected SpriteTileset[] getSpriteTilesets() {
        return this.spriteTilesets;
    }

    protected Tileset[] getNameTableTilesets() {
        return this.nameTableTilesets;
    }

    @Override
    public Tiles[] getTiles() {
        return this.tiles;
    }

    protected MiracleWorldMetaTileset[] getMetaTilesets() {
        return this.metaTilesets;
    }

    protected SpriteContainer[] getSprites() {
        return this.sprites;
    }

    protected Level[] getLevels() {
        return this.levels;
    }

    protected TitleScreen getTitleScreen() {
        return this.titleScreen;
    }

    protected Shop getShop() {
        return this.shop;
    }

    protected JankenMatch getJankenMatch() {
        return this.jankenMatch;
    }

    protected Riddle getRiddle() {
        return this.riddle;
    }

    @Override
    public TextData getTextData() {
        return this.textData;
    }

    protected GameSettings getInitialValues() {
        return this.initialValues;
    }

    protected Physics getPhysics() {
        return this.physics;
    }

    protected Sound getSound() {
        return this.sound;
    }

    protected Demo getDemo() {
        return this.demo;
    }

    protected LevelPalette[] getLevelPalettes() {
        return this.levelPalettes;
    }

    protected Palette[] getNameTablePalettes() {
        return this.nameTablePalettes;
    }

    protected NameTable[] getNameTables() {
        return this.nameTables;
    }

    protected NameTable[] getTitleScreenNameTables() {
        return this.titleScreenNameTables;
    }

    private static Level[] parseLevelDescriptors(int n, int n2) {
        Level[] levelArray = new Level[levelNumbers.length];
        int n3 = n;
        while (RomManager.StaticAccess.readByte(n3) != 201 && RomManager.StaticAccess.readByte(n3) != 195) {
            if (RomManager.StaticAccess.readByte(n3 - 1) == 192 && RomManager.StaticAccess.readByte(n3 - 2) == 35 && RomManager.StaticAccess.readByte(n3 - 3) == 58 && RomManager.StaticAccess.readByte(n3) == 33 && RomManager.StaticAccess.readByte(n3 + 3) == 215) {
                int n4 = RomManager.StaticAccess.READ_WORD(n3 + 1, n / 16384) + 2;
                if (n4 != 26326) {
                    System.err.println("Address in loadLevel does not match the address of the level descriptors.");
                }
                int n5 = 0;
                while (n5 < n2) {
                    levelArray[n5] = new Level(n5);
                    ++n5;
                }
                break;
            }
            if (RomManager.StaticAccess.readByte(n3) == 33 || RomManager.StaticAccess.readByte(n3) == 17 || RomManager.StaticAccess.readByte(n3) == 1 || RomManager.StaticAccess.readByte(n3) == 205 || RomManager.StaticAccess.readByte(n3) == 58) {
                n3 += 2;
            }
            if (RomManager.StaticAccess.readByte(n3) == 46 || RomManager.StaticAccess.readByte(n3) == 62) {
                ++n3;
            }
            ++n3;
        }
        levelArray[n2] = new BonusLevel(levelArray[2], 6013, 2);
        levelArray[n2 + 1] = new BonusLevel(levelArray[n2 - 1], 6031, n2 - 1);
        return levelArray;
    }

    private static SpriteContainer[] parseSprites(int n) {
        ArrayList<SpriteContainer> arrayList = new ArrayList<SpriteContainer>();
        HashMap<Integer, Sprite> hashMap = new HashMap<Integer, Sprite>();
        while (n < 38877) {
            if (n == 37328) {
                n = 37576;
            }
            while (RomManager.StaticAccess.readByte(n) == 0) {
                ++n;
            }
            Sprite sprite = (Sprite)hashMap.get(n);
            if (sprite != null) {
                n += sprite.getLength();
                continue;
            }
            SpriteContainer spriteContainer = new SpriteContainer(n, hashMap);
            arrayList.add(spriteContainer);
            n += spriteContainer.getLength();
        }
        return arrayList.toArray(new SpriteContainer[arrayList.size()]);
    }

    /*
     * Unable to fully structure code
     */
    private static SpriteTileset[] parseSpriteTilesets(int var0, Tiles var1_1, Tiles var2_2, int var3_3) {
        block16: {
            var4_4 = new TreeMap<Integer, Object>();
            var5_5 = 0;
            while (var5_5 < var3_3) {
                var6_7 = 0;
                var7_8 = RomManager.StaticAccess.readWord(var0 + var5_5 * 2);
                while (var6_7 == 0) {
                    block15: {
                        block14: {
                            block13: {
                                if (RomManager.StaticAccess.readByte(var7_8) != 195) break block13;
                                var6_7 = 1;
                                break block14;
                            }
                            if (RomManager.StaticAccess.readByte(var7_8) != 0) {
                                if (RomManager.StaticAccess.readByte(var7_8) != 205) break;
                            }
                            break block15;
                        }
                        var8_12 = RomManager.StaticAccess.readWord(var7_8 + 1);
                        if (!var4_4.containsKey(var8_12)) {
                            var9_14 = new SpriteTileset(var8_12);
                            var9_14.addTilesListener(var1_1);
                            var9_14.addTilesListener(var2_2);
                            var4_4.put(var8_12, var9_14);
                        }
                    }
                    var7_8 += 3;
                }
                ++var5_5;
            }
            if (var4_4.size() >= 34) break block16;
            var5_5 = (Integer)var4_4.firstKey();
            var6_7 = 0;
            while (var5_5 < 49152 && var6_7 < 34 && (RomManager.StaticAccess.readByte(var5_5) == 33 || RomManager.StaticAccess.readByte(var5_5) == 62 && RomManager.StaticAccess.readByte(var5_5 + 2) == 50 && RomManager.StaticAccess.readByte(var5_5 + 5) == 33)) {
                var7_10 = (Tileset)var4_4.get(var5_5);
                ** GOTO lbl40
                {
                    var5_5 = RomManager.StaticAccess.readByte(var5_5) == 62 ? (var5_5 += 2) : (var5_5 += 3);
                    do {
                        if (RomManager.StaticAccess.readByte(var5_5) != 195 && RomManager.StaticAccess.readByte(var5_5) != 201) continue block3;
                        if (RomManager.StaticAccess.readByte(var5_5) == 195) {
                            var5_5 += 2;
                        }
                        ++var6_7;
                        var7_10 = (Tileset)var4_4.get(++var5_5);
lbl40:
                        // 2 sources

                    } while (var7_10 != null);
                }
                if (RomManager.StaticAccess.readByte(var5_5) == 205 && RomManager.StaticAccess.readWord(var5_5 + 1) == 325) {
                    while (RomManager.StaticAccess.readByte(var5_5) != 195) {
                        var5_5 += 3;
                    }
                    var5_5 += 3;
                    ++var6_7;
                    continue;
                }
                if (RomManager.StaticAccess.readByte(var5_5) == 33 || RomManager.StaticAccess.readByte(var5_5) == 62 && RomManager.StaticAccess.readByte(var5_5 + 2) == 50 && RomManager.StaticAccess.readByte(var5_5 + 5) == 33) {
                    var7_10 = new SpriteTileset(var5_5);
                    if (var7_10.getDestination() >= 8192) {
                        var7_10.addTilesListener(var1_1);
                        var4_4.put(var5_5, var7_10);
                        continue;
                    }
                    var8_13 = var4_4.higherKey(var5_5);
                    if (var8_13 == null) continue;
                    var5_5 = var8_13;
                    continue;
                }
                var7_10 = var4_4.higherKey(var5_5);
                if (var7_10 == null) continue;
                var5_5 = var7_10.intValue();
            }
        }
        var5_6 = new SpriteTileset(6877){

            @Override
            public void updateMemory() {
                super.updateMemory();
                this.memory[6917] = 201;
            }

            @Override
            protected void writeByte(int n, int n2) {
                super.writeByte(n, n2);
                if (RomManager.StaticAccess.readByte(6877) == RomManager.StaticAccess.readByte(8758) && RomManager.StaticAccess.readByte(6878) == RomManager.StaticAccess.readByte(8759) && RomManager.StaticAccess.readByte(6879) == RomManager.StaticAccess.readByte(8760) && RomManager.StaticAccess.readWord(6880) == RomManager.StaticAccess.readWord(8761)) {
                    super.writeByte(n - 6877 + 8758, n2);
                }
            }

            @Override
            protected void writeWord(int n, int n2) {
                super.writeWord(n, n2);
                if (RomManager.StaticAccess.readByte(6877) == RomManager.StaticAccess.readByte(8758) && RomManager.StaticAccess.readByte(6878) == RomManager.StaticAccess.readByte(8759) && RomManager.StaticAccess.readByte(6879) == RomManager.StaticAccess.readByte(8760) && RomManager.StaticAccess.readWord(6880) == RomManager.StaticAccess.readWord(8761)) {
                    super.writeWord(n - 6877 + 8758, n2);
                }
            }
        };
        var5_6.addTilesListener(var1_1);
        var4_4.put(6877, var5_6);
        var5_6 = new SpriteTileset(7353){

            @Override
            public void updateMemory() {
                super.updateMemory();
                this.memory[7382] = 201;
            }

            @Override
            protected void writeByte(int n, int n2) {
                super.writeByte(n, n2);
                if (RomManager.StaticAccess.readByte(7358) == RomManager.StaticAccess.readByte(2850) && RomManager.StaticAccess.readByte(7361) == RomManager.StaticAccess.readByte(2853) && RomManager.StaticAccess.readByte(7364) == RomManager.StaticAccess.readByte(2856) && RomManager.StaticAccess.readWord(7368) == RomManager.StaticAccess.readWord(2860)) {
                    super.writeByte(n - 7358 + 2850, n2);
                }
            }

            @Override
            protected void writeWord(int n, int n2) {
                super.writeWord(n, n2);
                if (RomManager.StaticAccess.readByte(7358) == RomManager.StaticAccess.readByte(2850) && RomManager.StaticAccess.readByte(7361) == RomManager.StaticAccess.readByte(2853) && RomManager.StaticAccess.readByte(7364) == RomManager.StaticAccess.readByte(2856) && RomManager.StaticAccess.readWord(7368) == RomManager.StaticAccess.readWord(2860)) {
                    super.writeWord(n - 7358 + 2850, n2);
                }
            }
        };
        var5_6.addTilesListener(var1_1);
        var4_4.put(7353, var5_6);
        var6_7 = 0;
        while (var6_7 < 3) {
            var7_11 = var6_7 + 3;
            var5_6 = new SpriteTileset(8283){

                @Override
                public void updateMemory() {
                    super.updateMemory();
                    this.memory[49236] = var7_11;
                    this.memory[8395] = 201;
                }
            };
            var5_6.addTilesListener(var1_1);
            var5_6.addTilesListener(var2_2);
            var4_4.put(8283 + var6_7, var5_6);
            ++var6_7;
        }
        var5_6 = new SpriteTileset(2793){

            @Override
            public void updateMemory() {
                super.updateMemory();
                this.memory[4409] = 201;
                this.memory[2817] = 201;
            }
        };
        var5_6.addTilesListener(var1_1);
        var5_6.addTilesListener(var2_2);
        var4_4.put(2793, var5_6);
        var5_6 = new SpriteTileset(3246){

            @Override
            public void updateMemory() {
                super.updateMemory();
                this.memory[3272] = 201;
            }
        };
        var5_6.addTilesListener(var1_1);
        var4_4.put(3246, var5_6);
        var5_6 = new SpriteTileset(3272){

            @Override
            public void updateMemory() {
                super.updateMemory();
                this.memory[3335] = 201;
            }
        };
        var5_6.addTilesListener(var2_2);
        var4_4.put(3272, var5_6);
        return var4_4.values().toArray(new SpriteTileset[var4_4.size()]);
    }

    private CompressedTiles[] parseJankenMatchTiles() {
        CompressedTiles[] compressedTilesArray = new CompressedTiles[5];
        compressedTilesArray[0] = new CompressedTiles(659, RomManager.RESOLVE_ADDRESS(RomManager.StaticAccess.READ_WORD(31032, 1), RomManager.StaticAccess.READ_BYTE(31027, 1)), 28672, true, this.jankenMatchTilesDecompressor);
        int n = 0;
        while (n < 4) {
            compressedTilesArray[1 + n] = new CompressedTiles(659, RomManager.RESOLVE_ADDRESS(RomManager.StaticAccess.READ_WORD(30289 + n * 16 + 2, 1), RomManager.StaticAccess.READ_BYTE(31027, 1)), 25600, true, this.jankenMatchTilesDecompressor);
            ++n;
        }
        return compressedTilesArray;
    }

    private Tiles[] parseTiles(Tiles[] tilesArray, Tiles[] tilesArray2, Tiles[] tilesArray3) {
        int n;
        Tiles[] tilesArray4 = new Tiles[7 + tilesArray.length + tilesArray2.length + 8 + tilesArray3.length + 1];
        tilesArray4[0] = new Tiles(0, 66369, 16384, 7392, true);
        tilesArray4[1] = new Tiles(325, 114793, 16384, 12448, true);
        tilesArray4[2] = new Tiles(325, 93969, 16384, 928, true);
        tilesArray4[3] = new Tiles(325, 49152, 16416, 1152, false);
        tilesArray4[4] = new Tiles(325, RomManager.RESOLVE_ADDRESS(RomManager.StaticAccess.readWord(5664), 5), 16384, 1664, false);
        tilesArray4[5] = new Tiles(470, 45957, 22528, 80, 1, false);
        tilesArray4[6] = new CompressedTiles(659, 50338, 17568, false, this.levelTilesetsDecompressor);
        int n2 = 0;
        while (n2 < tilesArray.length) {
            tilesArray4[7 + n2] = tilesArray[n2];
            ++n2;
        }
        n2 = 0;
        while (n2 < tilesArray2.length) {
            tilesArray4[7 + tilesArray.length + n2] = tilesArray2[n2];
            ++n2;
        }
        tilesArray4[7 + tilesArray.length + tilesArray2.length] = new CompressedTiles(659, RomManager.RESOLVE_ADDRESS(RomManager.StaticAccess.readWord(6934), RomManager.StaticAccess.READ_BYTE(6929, 0)), 27648, true, new StandardTileDecompressor(6934, 6929));
        tilesArray4[7 + tilesArray.length + tilesArray2.length + 1] = new CompressedTiles(659, 114688, 24448, 3, false, new CompressedTiles.TileDecompressor(){

            @Override
            public void decompress(CompressedTiles compressedTiles) {
                MiracleWorldDataModel.decompressTiles(compressedTiles);
            }
        });
        tilesArray4[7 + tilesArray.length + tilesArray2.length + 2] = new CompressedTiles(659, RomManager.RESOLVE_ADDRESS(RomManager.StaticAccess.readWord(9732), RomManager.StaticAccess.readByte(RomManager.StaticAccess.readByte(9714) == 62 ? 9715 : 9703)), 16384, false, new CompressedTiles.TileDecompressor(){

            @Override
            public void decompress(CompressedTiles compressedTiles) {
                MiracleWorldDataModel.this.decompressHirottaStoneTiles();
            }
        });
        tilesArray4[7 + tilesArray.length + tilesArray2.length + 3] = new CompressedTiles(659, RomManager.RESOLVE_ADDRESS(RomManager.StaticAccess.readWord(7588), 5), RomManager.StaticAccess.readWord(7591), false, this.shopTilesDecompressor);
        tilesArray4[7 + tilesArray.length + tilesArray2.length + 4] = new CompressedTiles(659, RomManager.RESOLVE_ADDRESS(RomManager.StaticAccess.readWord(7597), 5), RomManager.StaticAccess.readWord(7600), false, this.shopTilesDecompressor);
        n2 = RomManager.StaticAccess.readWord(8902);
        int n3 = 5;
        if (RomManager.StaticAccess.readByte(8896) == 205) {
            n = RomManager.StaticAccess.readWord(8897);
            n2 = RomManager.StaticAccess.readWord(n + 6);
            n3 = RomManager.StaticAccess.readByte(n + 1);
        }
        tilesArray4[7 + tilesArray.length + tilesArray2.length + 5] = new CompressedTiles(659, RomManager.RESOLVE_ADDRESS(n2, n3), 16384, false, new CompressedTiles.TileDecompressor(){

            @Override
            public void decompress(CompressedTiles compressedTiles) {
                MiracleWorldDataModel.this.decompressMapTiles();
            }
        });
        tilesArray4[7 + tilesArray.length + tilesArray2.length + 6] = new CompressedTiles(659, 94897, 22016, 3, false, new CompressedTiles.TileDecompressor(){

            @Override
            public void decompress(CompressedTiles compressedTiles) {
                MiracleWorldDataModel.this.decompressFont();
            }
        });
        tilesArray4[7 + tilesArray.length + tilesArray2.length + 7] = new CompressedTiles(659, RomManager.RESOLVE_ADDRESS(RomManager.StaticAccess.readWord(1969), RomManager.StaticAccess.READ_BYTE(1964, 0)), 16416, false, new CompressedTiles.TileDecompressor(){

            @Override
            public void decompress(CompressedTiles compressedTiles) {
                MiracleWorldDataModel.this.decompressTitleScreenTiles();
            }
        });
        n = 0;
        while (n < tilesArray3.length) {
            tilesArray4[7 + tilesArray.length + tilesArray2.length + 8 + n] = tilesArray3[n];
            ++n;
        }
        tilesArray4[tilesArray4.length - 1] = MiracleWorldDataModel.createPetrifiedJankenTiles(true);
        return tilesArray4;
    }

    private void decompressFont() {
        CompressedTiles compressedTiles = (CompressedTiles)this.tiles[7 + this.levelMainTilesets.length + this.levelAdditionalTilesets.length + 6];
        if (!compressedTiles.isCompressed()) {
            return;
        }
        int n = compressedTiles.getLength() * 3 / 4 + 5 * ((compressedTiles.getLength() - 1) / 4 / 127 + 1 + 1) - 1;
        int n2 = compressedTiles.getSource() + n - this.tiles[4].getSource();
        this.tiles[4].moveTo(this.tiles[4].getSource() + n2);
        int n3 = 5664;
        while (n3 < 5712) {
            RomManager.StaticAccess.writeWord(n3, RomManager.StaticAccess.readWord(n3) + n2);
            n3 += 2;
        }
        MiracleWorldDataModel.decompressTiles(compressedTiles);
    }

    protected void decompressHirottaStoneTiles() {
        CompressedTiles compressedTiles = (CompressedTiles)this.tiles[7 + this.levelMainTilesets.length + this.levelAdditionalTilesets.length + 2];
        NameTable nameTable = this.nameTables[this.titleScreenNameTables.length + 3];
        int n = compressedTiles.calcDecompressedSize();
        n += nameTable.getLength();
        int n2 = KiddEd.findFreeBlock(n += 32);
        if (n2 > 0) {
            if (!MiracleWorldDataModel.isHirottaStonePaletteRelocated()) {
                nameTable.moveTo(n2 + 32);
                this.relocateHirottaStonePalette();
                this.nameTablePalettes[3].moveTo(n2, true);
            } else {
                this.nameTablePalettes[3].moveTo(n2, true);
                nameTable.moveTo(n2 + 32);
            }
            int n3 = n2 + 32 + nameTable.getLength();
            MiracleWorldDataModel.decompressTiles(compressedTiles, n3);
            RomManager.StaticAccess.writeWord(9732, 0x8000 | n3 & 0x3FFF);
            compressedTiles.setSource(n3);
        }
    }

    private void relocateHirottaStoneTiles() {
        this.decompressHirottaStoneTiles();
    }

    private void relocateHirottaStoneNametable() {
        this.relocateHirottaStoneTiles();
    }

    private void relocateHirottaStonePalette() {
        int n = KiddEd.findFreeBlock(32, this.nameTables[this.titleScreenNameTables.length + 3].getBank());
        if (n < 0) {
            this.relocateHirottaStoneTiles();
            return;
        }
        this.nameTablePalettes[3].moveTo(n, true);
        if (!MiracleWorldDataModel.isHirottaStonePaletteRelocated()) {
            int[] nArray = RomManager.StaticAccess.readBytes(new int[5], 9714);
            RomManager.StaticAccess.copyBytes(9702, 9702 + nArray.length, 12);
            RomManager.StaticAccess.writeBytes(nArray, 9702);
            this.nameTables[this.titleScreenNameTables.length + 3].update();
            this.writeCodeToReloadColorAfterInvincibility();
        }
    }

    private void writeCodeToReloadColorAfterInvincibility() {
        int n = RomManager.StaticAccess.readByte(RomManager.StaticAccess.readWord(9858) != 65535 ? 9839 : 9849);
        if (!MiracleWorldDataModel.isHirottaStonePaletteRelocated()) {
            this.relocateHirottaStonePalette();
        }
        int n2 = 9836;
        RomManager.StaticAccess.writeByte(n2++, 58);
        RomManager.StaticAccess.writeWord(n2++, 65535);
        int n3 = ++n2;
        RomManager.StaticAccess.writeByte(n3, 245);
        int n4 = ++n2;
        RomManager.StaticAccess.writeByte(n4, 62);
        int n5 = ++n2;
        RomManager.StaticAccess.writeByte(n5, 135);
        int n6 = ++n2;
        RomManager.StaticAccess.writeByte(n6, 50);
        int n7 = ++n2;
        ++n2;
        RomManager.StaticAccess.writeWord(n7, 65535);
        int n8 = ++n2;
        RomManager.StaticAccess.writeByte(n8, 58);
        int n9 = ++n2;
        ++n2;
        RomManager.StaticAccess.writeWord(n9, 49187);
        int n10 = ++n2;
        RomManager.StaticAccess.writeByte(n10, 33);
        int n11 = ++n2;
        ++n2;
        RomManager.StaticAccess.writeWord(n11, 4368);
        int n12 = ++n2;
        RomManager.StaticAccess.writeByte(n12, 215);
        int n13 = ++n2;
        RomManager.StaticAccess.writeByte(n13, 17);
        int n14 = ++n2;
        ++n2;
        RomManager.StaticAccess.writeWord(n14, n);
        int n15 = ++n2;
        RomManager.StaticAccess.writeByte(n15, 25);
        int n16 = ++n2;
        RomManager.StaticAccess.writeByte(n16, 126);
        int n17 = ++n2;
        RomManager.StaticAccess.writeByte(n17, 87);
        int n18 = ++n2;
        RomManager.StaticAccess.writeByte(n18, 241);
        int n19 = ++n2;
        RomManager.StaticAccess.writeByte(n19, 50);
        int n20 = ++n2;
        ++n2;
        RomManager.StaticAccess.writeWord(n20, 65535);
        int n21 = ++n2;
        RomManager.StaticAccess.writeByte(n21, 122);
        int n22 = ++n2;
        RomManager.StaticAccess.writeByte(n22, 22);
        int n23 = ++n2;
        RomManager.StaticAccess.writeByte(n23, 192);
        int n24 = ++n2;
        RomManager.StaticAccess.writeByte(n24, 195);
        int n25 = ++n2;
        ++n2;
        RomManager.StaticAccess.writeWord(n25, 319);
    }

    protected void decompressMapTiles() {
        CompressedTiles compressedTiles = (CompressedTiles)this.tiles[7 + this.levelMainTilesets.length + this.levelAdditionalTilesets.length + 5];
        if (!compressedTiles.isCompressed()) {
            return;
        }
        int n = compressedTiles.calcDecompressedSize();
        int n2 = KiddEd.findFreeBlock(n);
        if (n2 > 0) {
            RomManager.StaticAccess.copyBytes(6790, 6789, 35);
            int n3 = 6824;
            RomManager.StaticAccess.writeByte(6784, 62);
            RomManager.StaticAccess.writeByte(6785, 0x80 | compressedTiles.getSource() / 16384);
            RomManager.StaticAccess.writeByte(6786, 50);
            RomManager.StaticAccess.writeWord(6787, 65535);
            RomManager.StaticAccess.writeByte(n3++, 24);
            RomManager.StaticAccess.writeByte(n3++, 6872 - n3);
            int n4 = n3;
            RomManager.StaticAccess.writeByte(n4, 62);
            RomManager.StaticAccess.writeByte(n4 + 1, 0x80 | n2 / 16384);
            RomManager.StaticAccess.writeByte(n4 + 2, 50);
            RomManager.StaticAccess.writeWord(n4 + 3, 65535);
            RomManager.StaticAccess.writeByte(n4 + 5, 33);
            RomManager.StaticAccess.writeWord(n4 + 6, 0x8000 | n2 & 0x3FFF);
            RomManager.StaticAccess.writeByte(n4 + 8, 17);
            RomManager.StaticAccess.writeWord(n4 + 9, 16384);
            RomManager.StaticAccess.writeByte(n4 + 11, 195);
            RomManager.StaticAccess.writeWord(n4 + 12, 659);
            RomManager.StaticAccess.writeByte(6781, 205);
            RomManager.StaticAccess.writeWord(6782, n4);
            RomManager.StaticAccess.copyBytes(8896, 8905, 5);
            RomManager.StaticAccess.writeByte(8896, 205);
            RomManager.StaticAccess.writeWord(8897, n4);
            RomManager.StaticAccess.fill(8899, 8905, 0);
            MiracleWorldDataModel.decompressTiles(compressedTiles, n2);
            RomManager.StaticAccess.writeWord(n4 + 6, 0x8000 | n2 & 0x3FFF);
            compressedTiles.setSource(n2);
        }
    }

    protected void decompressTitleScreenTiles() {
        CompressedTiles compressedTiles = (CompressedTiles)this.tiles[7 + this.levelMainTilesets.length + this.levelAdditionalTilesets.length + 7];
        if (!compressedTiles.isCompressed()) {
            return;
        }
        int n = compressedTiles.calcDecompressedSize();
        int n2 = KiddEd.findFreeBlock(n += this.titleScreenNameTables[0].getLength() + this.titleScreenNameTables[1].getLength());
        if (n2 > 0) {
            RomManager.StaticAccess.copyBytes(this.titleScreenNameTables[0].getSource(), n2, this.titleScreenNameTables[0].getLength());
            RomManager.StaticAccess.fill(this.titleScreenNameTables[0].getSource(), this.titleScreenNameTables[0].getSource() + this.titleScreenNameTables[0].getLength(), 255);
            this.titleScreenNameTables[1].moveTo(n2 + this.titleScreenNameTables[0].getLength());
            this.titleScreenNameTables[0].setSource(n2);
            int n3 = n2 + this.titleScreenNameTables[0].getLength() + this.titleScreenNameTables[1].getLength();
            MiracleWorldDataModel.decompressTiles(compressedTiles, n3);
            RomManager.StaticAccess.writeWord(1969, 0x8000 | n3 & 0x3FFF);
            compressedTiles.setSource(n3);
        }
    }

    protected void decompressLevelTilesets() {
        if (!this.levelMainTilesets[0].isCompressed()) {
            return;
        }
        this.decompressLevelMainTilesets();
        this.decompressLevelAdditionalTilesets();
        int n = 0;
        while (n < 17) {
            this.tilesets[n * 2].updateMemory();
            ++n;
        }
        KiddEd.clearChanges();
    }

    private void decompressLevelMainTilesets() {
        if (!this.levelMainTilesets[0].isCompressed()) {
            return;
        }
        int n = 0;
        CompressedTiles[] compressedTilesArray = this.levelMainTilesets;
        int n2 = this.levelMainTilesets.length;
        int n3 = 0;
        while (n3 < n2) {
            CompressedTiles compressedTiles = compressedTilesArray[n3];
            n += compressedTiles.calcDecompressedSize();
            ++n3;
        }
        int n4 = KiddEd.findFreeBlock(n);
        if (n4 > 0) {
            this.enableLevelTilesetsPerLevel();
            n3 = 4199;
            while (n3 < 4223 && RomManager.StaticAccess.readByte(n3) != 201) {
                if (RomManager.StaticAccess.readByte(n3) == 62 && RomManager.StaticAccess.readByte(n3 + 2) == 50 && RomManager.StaticAccess.readByte(n3 + 3) == 255 && RomManager.StaticAccess.readByte(n3 + 4) == 255) {
                    RomManager.StaticAccess.writeByte(n3 + 1, n4 / 16384);
                    break;
                }
                if (RomManager.StaticAccess.readByte(n3) == 33 || RomManager.StaticAccess.readByte(n3) == 17 || RomManager.StaticAccess.readByte(n3) == 1 || RomManager.StaticAccess.readByte(n3) == 205 || RomManager.StaticAccess.readByte(n3) == 58) {
                    n3 += 2;
                }
                if (RomManager.StaticAccess.readByte(n3) == 46 || RomManager.StaticAccess.readByte(n3) == 62) {
                    ++n3;
                }
                ++n3;
            }
            n3 = n4;
            CompressedTiles[] compressedTilesArray2 = this.levelMainTilesets;
            int n5 = this.levelMainTilesets.length;
            int n6 = 0;
            while (n6 < n5) {
                CompressedTiles compressedTiles = compressedTilesArray2[n6];
                int n7 = n3;
                n3 = MiracleWorldDataModel.decompressTiles(compressedTiles, n7);
                int n8 = 0;
                while (n8 < 17) {
                    int n9 = RomManager.StaticAccess.READ_WORD(33920 + n8 * 2, 3);
                    if (n9 == (0x8000 | compressedTiles.getSource() & 0x3FFF)) {
                        RomManager.StaticAccess.writeWord(RomManager.RESOLVE_ADDRESS(33920, 3) + n8 * 2, 0x8000 | n7 & 0x3FFF);
                    }
                    ++n8;
                }
                MiracleWorldDataModel.updateLevelAdditionalTilesetAddress(compressedTiles, n7);
                compressedTiles.setSource(n7);
                ++n6;
            }
        }
    }

    public static boolean hasLevelTilesetsPerLevel() {
        return RomManager.StaticAccess.readByte(4206) == 62 && RomManager.StaticAccess.readByte(4208) == 50 && RomManager.StaticAccess.readWord(4209) == 65535 && RomManager.StaticAccess.readByte(4211) == 205 && RomManager.StaticAccess.readWord(4212) == 659;
    }

    /*
     * Unable to fully structure code
     */
    protected void enableLevelTilesetsPerLevel() {
        if (MiracleWorldDataModel.hasLevelTilesetsPerLevel()) {
            return;
        }
        var1_1 = 3692;
        while (RomManager.StaticAccess.readByte(var1_1) != 201) {
            if (RomManager.StaticAccess.readByte(var1_1) == 33 && RomManager.StaticAccess.readByte(var1_1 + 3) == 231) break;
            if (RomManager.StaticAccess.readByte(var1_1) == 33 || RomManager.StaticAccess.readByte(var1_1) == 17 || RomManager.StaticAccess.readByte(var1_1) == 205 || RomManager.StaticAccess.readByte(var1_1) == 58) {
                var1_1 += 2;
            }
            ++var1_1;
        }
        var1_1 = RomManager.StaticAccess.readWord(var1_1 + 1);
        var2_2 = new ArrayList[17];
        var3_3 = -1;
        var4_4 = 0;
        while (var4_4 < var2_2.length) {
            var2_2[var4_4] = new ArrayList<E>();
            var5_5 = var1_1 + (var4_4 + 1) * 2;
            var6_8 = 0;
            var7_9 = 0;
            var8_13 = RomManager.StaticAccess.readWord(var5_5);
            while (var8_13 < 4219 && var6_8 == 0) {
                switch (RomManager.StaticAccess.readByte(var8_13)) {
                    case 215: {
                        ++var7_9;
                        break;
                    }
                    case 0: 
                    case 247: {
                        break;
                    }
                    case 195: {
                        var6_8 = 1;
                    }
                    case 1: 
                    case 17: 
                    case 33: 
                    case 58: 
                    case 205: {
                        var8_13 += 2;
                        break;
                    }
                    case 6: 
                    case 46: 
                    case 62: {
                        ++var8_13;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown instruction: " + Integer.toHexString(RomManager.StaticAccess.readByte(var8_13)) + " at " + Integer.toHexString(var8_13));
                    }
                }
                ++var8_13;
            }
            var9_15 = 0;
            var10_18 = 0;
            var11_19 = 0;
            var12_20 = -1;
            var13_21 = -1;
            var6_8 = 0;
            var8_13 = RomManager.StaticAccess.readWord(var5_5);
            while (var8_13 < 4219 && var6_8 == 0) {
                switch (RomManager.StaticAccess.readByte(var8_13)) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        var8_13 += 2;
                        break;
                    }
                    case 6: {
                        ++var8_13;
                        break;
                    }
                    case 17: {
                        var9_15 = RomManager.StaticAccess.readWord(var8_13 + 1);
                        var8_13 += 2;
                        break;
                    }
                    case 33: {
                        var10_18 = RomManager.StaticAccess.readWord(var8_13 + 1);
                        var8_13 += 2;
                        break;
                    }
                    case 46: {
                        var10_18 = RomManager.StaticAccess.readByte(++var8_13);
                        break;
                    }
                    case 58: {
                        var11_19 = -1;
                        var8_13 += 2;
                        break;
                    }
                    case 62: {
                        var11_19 = RomManager.StaticAccess.readByte(++var8_13);
                        break;
                    }
                    case 195: {
                        var6_8 = 1;
                    }
                    case 205: {
                        if (var9_15 == var12_20 && var10_18 == var13_21) ** GOTO lbl153
                        var14_22 = RomManager.StaticAccess.readWord(var8_13 + 1);
                        if (var14_22 != 388) ** GOTO lbl87
                        var2_2[var4_4].add(205);
                        var2_2[var4_4].add(92);
                        var2_2[var4_4].add(16);
                        ** GOTO lbl153
lbl87:
                        // 1 sources

                        var15_23 = RomManager.StaticAccess.readWord(var8_13 + 1);
                        if (var14_22 != 659 && (RomManager.StaticAccess.readByte(var15_23) != 58 || RomManager.StaticAccess.readWord(var15_23 + 1) != 65535 || RomManager.StaticAccess.readByte(var15_23 + 3) != 245 || RomManager.StaticAccess.readByte(var15_23 + 16) != 201)) ** GOTO lbl133
                        if (var14_22 != 659) {
                            var3_3 = var15_23;
                        }
                        if (var10_18 >= 0) {
                            var16_24 = 0;
                            while (var16_24 < 9) {
                                var2_2[var4_4].add(RomManager.StaticAccess.readByte(var8_13 - 6 + var16_24));
                                ++var16_24;
                            }
                        } else if (var11_19 >= 0 && var7_9 > 1) {
                            var2_2[var4_4].add(33);
                            var15_23 = RomManager.StaticAccess.READ_WORD(33918 + var11_19 * 2, 3);
                            var2_2[var4_4].add(var15_23 & 255);
                            var2_2[var4_4].add(var15_23 >> 8);
                            var2_2[var4_4].add(17);
                            var2_2[var4_4].add(var9_15 & 255);
                            var2_2[var4_4].add(var9_15 >> 8);
                            var2_2[var4_4].add(RomManager.StaticAccess.readByte(var8_13));
                            var2_2[var4_4].add(110);
                            var2_2[var4_4].add(16);
                        } else {
                            var2_2[var4_4].add(17);
                            var2_2[var4_4].add(var9_15 & 255);
                            var2_2[var4_4].add(var9_15 >> 8);
                            var2_2[var4_4].add(RomManager.StaticAccess.readByte(var8_13));
                            var2_2[var4_4].add(103);
                            var2_2[var4_4].add(16);
                        }
                        ** GOTO lbl153
lbl133:
                        // 1 sources

                        if (var14_22 == 659) ** GOTO lbl153
                        var16_24 = 1;
                        while (var16_24 <= 17) {
                            if (RomManager.StaticAccess.readWord(var1_1 + var16_24 * 2) != var15_23) ** GOTO lbl151
                            var2_2[var4_4].addAll(var2_2[var16_24 - 1]);
                            var2_2[var4_4].set(var2_2[var4_4].size() - 3, 205);
                            var16_24 = var2_2[var4_4].size() - 6;
                            while (var16_24 >= 0 && (var9_15 == 0 || var10_18 == 0)) {
                                if ((Integer)var2_2[var4_4].get(var16_24) == 17) {
                                    var9_15 = (Integer)var2_2[var4_4].get(var16_24 + 2) << 8 | (Integer)var2_2[var4_4].get(var16_24 + 1);
                                } else if ((Integer)var2_2[var4_4].get(var16_24) == 33) {
                                    var10_18 = (Integer)var2_2[var4_4].get(var16_24 + 2) << 8 | (Integer)var2_2[var4_4].get(var16_24 + 1);
                                }
                                var16_24 -= 3;
                            }
                            break;
lbl151:
                            // 1 sources

                            ++var16_24;
                        }
lbl153:
                        // 8 sources

                        var12_20 = var9_15;
                        var13_21 = var10_18;
                        var9_15 = 0;
                        var10_18 = 0;
                        var8_13 += 2;
                        break;
                    }
                    case 215: {
                        var10_18 = -1;
                        break;
                    }
                    case 247: {
                        var14_22 = 0;
                        while (var14_22 < 9) {
                            var2_2[var4_4].add(RomManager.StaticAccess.readByte(var8_13 - 8 + var14_22));
                            ++var14_22;
                        }
                        var9_15 = 0;
                        var10_18 = 0;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown instruction: " + Integer.toHexString(RomManager.StaticAccess.readByte(var8_13)) + " at " + Integer.toHexString(var8_13));
                    }
                }
                ++var8_13;
            }
            if ((Integer)var2_2[var4_4].get(var2_2[var4_4].size() - 3) == 205) {
                var2_2[var4_4].set(var2_2[var4_4].size() - 3, 195);
            }
            ++var4_4;
        }
        var4_4 = 0;
        while (var4_4 < 17) {
            var5_6 = var2_2[var4_4];
            var6_8 = -1;
            var7_9 = 0;
            while (var7_9 + 5 < var5_6.size()) {
                if ((Integer)var5_6.get(var7_9) == 17 && (Integer)var5_6.get(var7_9 + 4) == 103 && (Integer)var5_6.get(var7_9 + 5) == 16) {
                    if (var6_8 >= 0) {
                        var5_6.subList(var6_8, var6_8 + 6).clear();
                        break;
                    }
                    var6_8 = var7_9;
                }
                ++var7_9;
            }
            ++var4_4;
        }
        var4_4 = RomManager.StaticAccess.readWord(var1_1 + 2);
        var5_5 = 0;
        while (var5_5 < 17) {
            RomManager.StaticAccess.writeWord(var1_1 + (var5_5 + 1) * 2, var4_4);
            var7_11 = var2_2[var5_5].iterator();
            while (var7_11.hasNext()) {
                var6_8 = (Integer)var7_11.next();
                RomManager.StaticAccess.writeByte(var4_4++, var6_8);
            }
            ++var5_5;
        }
        RomManager.StaticAccess.fill(var4_4, 4188, 0);
        var4_4 = 4188;
        RomManager.StaticAccess.writeByte(var4_4++, 17);
        RomManager.StaticAccess.writeWord(var4_4, 18080);
        var4_4 += 2;
        RomManager.StaticAccess.writeByte(var4_4++, 1);
        RomManager.StaticAccess.writeWord(var4_4, 512);
        var4_4 += 2;
        RomManager.StaticAccess.writeByte(var4_4++, 46);
        RomManager.StaticAccess.writeByte(var4_4++, 0);
        RomManager.StaticAccess.writeByte(var4_4++, 195);
        RomManager.StaticAccess.writeWord(var4_4, 388);
        var4_4 = 4199;
        RomManager.StaticAccess.writeByte(var4_4++, 58);
        RomManager.StaticAccess.writeWord(var4_4, 49187);
        var4_4 += 2;
        RomManager.StaticAccess.writeByte(var4_4++, 33);
        RomManager.StaticAccess.writeWord(var4_4, 33918);
        var4_4 += 2;
        RomManager.StaticAccess.writeByte(var4_4++, 215);
        RomManager.StaticAccess.writeByte(var4_4++, 62);
        RomManager.StaticAccess.writeByte(var4_4++, this.levelMainTilesets[0].getSource() / 16384);
        RomManager.StaticAccess.writeByte(var4_4++, 50);
        RomManager.StaticAccess.writeWord(var4_4, 65535);
        var4_4 += 2;
        RomManager.StaticAccess.writeByte(var4_4++, 205);
        RomManager.StaticAccess.writeWord(var4_4, 659);
        var4_4 += 2;
        RomManager.StaticAccess.writeByte(var4_4++, 62);
        RomManager.StaticAccess.writeByte(var4_4++, 3);
        RomManager.StaticAccess.writeByte(var4_4++, 50);
        RomManager.StaticAccess.writeWord(var4_4, 65535);
        var4_4 += 2;
        RomManager.StaticAccess.writeByte(var4_4++, 201);
        if (var3_3 >= 0) {
            RomManager.StaticAccess.fill(var3_3, var3_3 + 17, 255);
        }
        var8_14 = this.levelTilesets;
        var7_12 = this.levelTilesets.length;
        var6_8 = 0;
        while (var6_8 < var7_12) {
            var5_7 = var8_14[var6_8];
            if (var5_7 instanceof LevelTileset) {
                var9_17 = (LevelTileset)var5_7;
                var9_17.updateAdditionalTilesets(this.levelMainTilesets, this.levelAdditionalTilesets);
                var9_17.updateMemory();
            }
            ++var6_8;
        }
        KiddEd.clearChanges();
    }

    static void updateLevelAdditionalTilesetAddress(CompressedTiles compressedTiles, int n) {
        int n2 = 3692;
        while (RomManager.StaticAccess.readByte(n2) != 201) {
            if (RomManager.StaticAccess.readByte(n2) == 33 && RomManager.StaticAccess.readByte(n2 + 3) == 231) break;
            if (RomManager.StaticAccess.readByte(n2) == 33 || RomManager.StaticAccess.readByte(n2) == 17 || RomManager.StaticAccess.readByte(n2) == 205 || RomManager.StaticAccess.readByte(n2) == 58) {
                n2 += 2;
            }
            ++n2;
        }
        if (RomManager.StaticAccess.readByte(n2) == 33 && RomManager.StaticAccess.readByte(n2 + 3) == 231) {
            int n3 = RomManager.StaticAccess.readWord(n2 + 1) + 2;
            int n4 = 0;
            while (n4 < 17) {
                n2 = RomManager.StaticAccess.readWord(n3 + n4 * 2);
                while (RomManager.StaticAccess.readByte(n2) != 201 && RomManager.StaticAccess.readByte(n2) != 195) {
                    if ((RomManager.StaticAccess.readByte(n2) == 33 && RomManager.StaticAccess.readByte(n2 + 3) == 17 && (RomManager.StaticAccess.readByte(n2 + 6) == 205 || RomManager.StaticAccess.readByte(n2 + 6) == 195) || RomManager.StaticAccess.readByte(n2 + 8) == 247) && RomManager.StaticAccess.READ_WORD(n2 + 1, 3) == (0x8000 | compressedTiles.getSource() & 0x3FFF)) {
                        RomManager.StaticAccess.writeWord(n2 + 1, 0x8000 | n & 0x3FFF);
                        if (RomManager.StaticAccess.readByte(n2 + 8) == 247) {
                            RomManager.StaticAccess.writeByte(n2 + 6, 205);
                            RomManager.StaticAccess.writeWord(n2 + 7, 659);
                        }
                    }
                    if (RomManager.StaticAccess.readByte(n2) == 33 || RomManager.StaticAccess.readByte(n2) == 17 || RomManager.StaticAccess.readByte(n2) == 1 || RomManager.StaticAccess.readByte(n2) == 205 || RomManager.StaticAccess.readByte(n2) == 58) {
                        n2 += 2;
                    }
                    if (RomManager.StaticAccess.readByte(n2) == 46 || RomManager.StaticAccess.readByte(n2) == 62) {
                        ++n2;
                    }
                    ++n2;
                }
                ++n4;
            }
        }
    }

    private void decompressLevelAdditionalTilesets() {
        Object object;
        int n;
        CompressedTiles compressedTiles = (CompressedTiles)this.tiles[6];
        if (this.levelMainTilesets[0].isCompressed() || !compressedTiles.isCompressed()) {
            return;
        }
        int n2 = compressedTiles.getSource();
        int[][] nArrayArray = new int[1 + this.levelAdditionalTilesets.length][];
        nArrayArray[0] = compressedTiles.getVRAM();
        int n3 = 0;
        while (n3 < this.levelAdditionalTilesets.length) {
            nArrayArray[1 + n3] = this.levelAdditionalTilesets[n3].getVRAM();
            ++n3;
        }
        RomManager.StaticAccess.fill(n2, 63850, 255);
        n3 = 0;
        while (n3 < 4) {
            int n4 = 0;
            n = n3;
            while (n < compressedTiles.getLength()) {
                if (n4 % 127 == 0) {
                    RomManager.StaticAccess.writeByte(n2++, 0x80 | Math.min(127, compressedTiles.getLength() / 4 - n4));
                }
                RomManager.StaticAccess.writeByte(n2++, nArrayArray[0][compressedTiles.getDestination() + n]);
                ++n4;
                n += 4;
            }
            RomManager.StaticAccess.writeByte(n2++, 0);
            ++n3;
        }
        n3 = 0;
        while (n3 < this.levelAdditionalTilesets.length) {
            Tiles tiles = this.levelAdditionalTilesets[n3];
            n = n2;
            int n5 = 0;
            while (n5 < 4) {
                int n6 = 0;
                int n7 = n5;
                while (n7 < tiles.getLength()) {
                    if (n6 % 127 == 0) {
                        RomManager.StaticAccess.writeByte(n2++, 0x80 | Math.min(127, tiles.getLength() / 4 - n6));
                    }
                    RomManager.StaticAccess.writeByte(n2++, nArrayArray[1 + n3][tiles.getDestination() + n7]);
                    ++n6;
                    n7 += 4;
                }
                RomManager.StaticAccess.writeByte(n2++, 0);
                ++n5;
            }
            if (!(this.levelAdditionalTilesets[n3] instanceof CompressedTiles)) {
                n5 = 0;
                while (n5 < this.tiles.length) {
                    if (this.tiles[n5] == this.levelAdditionalTilesets[n3]) {
                        this.tiles[n5] = this.tiles[n5].toCompressedTiles(659);
                        this.levelAdditionalTilesets[n3] = this.tiles[n5];
                        tiles = this.levelAdditionalTilesets[n3];
                        break;
                    }
                    ++n5;
                }
            }
            object = (CompressedTiles)tiles;
            MiracleWorldDataModel.updateLevelAdditionalTilesetAddress((CompressedTiles)object, n);
            ((CompressedTiles)object).setSource(n);
            ++n3;
        }
        object = this.levelTilesets;
        n = this.levelTilesets.length;
        int n8 = 0;
        while (n8 < n) {
            Tileset tileset = object[n8];
            if (tileset instanceof LevelTileset) {
                LevelTileset levelTileset = (LevelTileset)tileset;
                levelTileset.updateAdditionalTilesets(this.levelMainTilesets, this.levelAdditionalTilesets);
                levelTileset.updateMemory();
            }
            ++n8;
        }
    }

    static CompressedTiles createPetrifiedJankenTiles(final boolean bl) {
        return new CompressedTiles(bl ? 17277 : 659, bl ? 76542 : RomManager.RESOLVE_ADDRESS(RomManager.StaticAccess.READ_WORD(30291, 1), RomManager.StaticAccess.READ_BYTE(31027, 1)), bl ? 16384 : 25600, true, null){
            private final int[] pixelSources;
            {
                super(n, n2, n3, bl3, tileDecompressor);
                this.pixelSources = new int[4096];
            }

            @Override
            public int[] getVRAM() {
                if (bl) {
                    return this.getVRAM(new TMS9918A(262));
                }
                return super.getVRAM();
            }

            @Override
            protected int[] getVRAM(final TMS9918A tMS9918A) {
                final int[] nArray = new int[65536];
                RomManager.StaticAccess.copyFromROM(0, nArray, 0, 32768);
                RomManager.StaticAccess.loadBank2(nArray, this.getSource() / 16384);
                final Z80 z80 = Z80Factory.create(nArray);
                int[] nArray2 = bl ? tMS9918A.getVRAM() : super.getVRAM(tMS9918A);
                Arrays.fill(this.pixelSources, -1);
                z80.addOutputListener(new OutputListener(){

                    @Override
                    public void outputAvailable(int n, int n2, int n3) {
                        if (n == 65535) {
                            RomManager.StaticAccess.loadBank2(nArray, n2);
                        } else if (n >> 6 == 2) {
                            if (n2 < 0) {
                                z80.setInput(tMS9918A.readByte(n & 1, n3));
                            } else {
                                tMS9918A.processInput(n & 1, n2, n3);
                            }
                        }
                    }
                });
                tMS9918A.addOutputListener(new OutputListener(){

                    @Override
                    public void outputAvailable(int n, int n2, int n3) {
                        if (n == 3) {
                            int n4 = (n2 & 0x3FFF) / 4;
                            int n5 = (nArray[65535] & 0x3F) * 16384 | z80.getHL() & 0x3FFF;
                            if (pixelSources[n4] < 0) {
                                (this).pixelSources[n4] = n5;
                            }
                            if (n5 + 1 > end) {
                                end = n5 + 1;
                            }
                        }
                    }
                });
                z80.execute(29788);
                while (nArray[49666] == 136) {
                    nArray[49666] = 0;
                    z80.execute(17277);
                }
                this.length = 0;
                if (bl) {
                    int n = 0;
                    int n2 = 0;
                    while (n < this.pixelSources.length) {
                        int n3 = this.pixelSources[n];
                        if (n3 >= 0) {
                            System.arraycopy(nArray2, n * 4, nArray2, n2 * 32, 32);
                            Arrays.fill(nArray2, n * 4, n * 4 + 32, 0);
                            System.arraycopy(this.pixelSources, n, this.pixelSources, n2++ * 8, 8);
                            Arrays.fill(this.pixelSources, n, n + 8, -1);
                            this.length += 32;
                        }
                        n += 8;
                    }
                }
                return nArray2;
            }

            @Override
            public boolean isValid() {
                return true;
            }

            @Override
            public boolean isCompressed() {
                return false;
            }

            @Override
            protected int[] getAddresses(int[][] nArray) {
                int n;
                int n2 = 0;
                int n3 = 0;
                while (n3 < nArray.length) {
                    n = 0;
                    while (n < nArray[n3].length) {
                        if (nArray[n3][n] >= 0) {
                            ++n2;
                        }
                        ++n;
                    }
                    ++n3;
                }
                int[] nArray2 = new int[n2 * 8 * this.bpp];
                n = 0;
                while (n < nArray.length) {
                    int n4 = 0;
                    while (n4 < nArray[n].length) {
                        if (nArray[n][n4] >= 0) {
                            int n5 = 0;
                            while (n5 < this.bpp) {
                                int n6 = 0;
                                while (n6 < 8) {
                                    nArray2[(n * nArray[n].length + n4) * 8 * this.bpp + n5 * 8 + n6] = this.pixelSources[nArray[n][n4] * 8 + n6] + n5;
                                    ++n6;
                                }
                                ++n5;
                            }
                        }
                        ++n4;
                    }
                    ++n;
                }
                return nArray2;
            }

            @Override
            public void setPixels(int[][] nArray) {
                int n;
                int n2;
                int n3;
                int n4 = 8 * this.bpp;
                int n5 = this.getLength() * this.bpp / 4;
                int[] nArray2 = new int[nArray.length * nArray[0].length / 8 * this.bpp];
                int n6 = 0;
                while (n6 < nArray.length) {
                    n3 = 0;
                    while (n3 < nArray[n6].length) {
                        n2 = n6 / 8 * nArray[n6].length / 8 + n3 / 8;
                        if (n2 >= n5 / n4) break;
                        n = 0;
                        while (n < this.bpp) {
                            nArray2[n2 * n4 + n6 % 8 * this.bpp + n] = this.pixelSources[n2 * 8 + n6 % 8] + n;
                            ++n;
                        }
                        n3 += 8;
                    }
                    ++n6;
                }
                TransactionManager.getInstance().addTransactionObject(this, -1);
                n6 = 0;
                while (n6 < nArray.length) {
                    n3 = 0;
                    while (n3 < nArray[n6].length) {
                        n2 = n6 / 8 * nArray[n6].length / 8 + n3 / 8;
                        if (n2 >= n5 / n4) break;
                        n = 7 - (n3 & 7);
                        int n7 = ~(1 << n);
                        int n8 = 0;
                        while (n8 < this.bpp) {
                            this.writeByte(nArray2[n2 * n4 + n6 % 8 * this.bpp + n8], RomManager.StaticAccess.readByte(nArray2[n2 * n4 + n6 % 8 * this.bpp + n8]) & n7 | (nArray[n6][n3] >> n8 & 1) << n);
                            ++n8;
                        }
                        ++n3;
                    }
                    ++n6;
                }
            }

            @Override
            public boolean rewrite(int n, int n2) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void setSource(int n) {
                throw new UnsupportedOperationException();
            }

            @Override
            public int calcDecompressedSize() {
                throw new UnsupportedOperationException();
            }
        };
    }

    boolean isBonusLevelCompressed() {
        return this.levels[17].isCompressed();
    }

    boolean relocateBonusLevel() {
        return this.levels[17].relocate();
    }

    void relocateAssetsInBank(final int n) {
        KiddEd.runWithBlockedBank(n, new Runnable(){

            @Override
            public void run() {
                MiracleWorldDataModel.this.sound.relocateSoundsInBank(n);
                if (MiracleWorldDataModel.this.nameTables[MiracleWorldDataModel.this.titleScreenNameTables.length].getBank() == n) {
                    MiracleWorldDataModel.this.relocateShopNameTable();
                }
                if (MiracleWorldDataModel.this.titleScreenNameTables[0].getBank() == n) {
                    MiracleWorldDataModel.this.relocateTitleScreenAssets();
                }
                if (TextData.getBank() == n) {
                    MiracleWorldDataModel.this.textData.relocate();
                }
                if (MiracleWorldDataModel.this.textData.getEndingSequenceBank() == n) {
                    MiracleWorldDataModel.this.textData.relocateEndingSequence();
                }
                if (MiracleWorldDataModel.this.isBankOfHirottaStoneNameTable(n)) {
                    MiracleWorldDataModel.this.relocateHirottaStoneNametable();
                }
                if (MiracleWorldDataModel.this.isBankOfMapTiles(n)) {
                    MiracleWorldDataModel.this.relocateMapTiles();
                }
                if (MiracleWorldDataModel.this.isBankOfAlexEating(n)) {
                    MiracleWorldDataModel.this.relocateAlexEating();
                }
                if (MiracleWorldDataModel.this.isBankOfJankenMatchTiles(n)) {
                    MiracleWorldDataModel.this.relocateJankenMatchTiles();
                }
                int n2 = 0;
                while (n2 < MiracleWorldDataModel.this.levels.length) {
                    if (MiracleWorldDataModel.this.levels[n2].getBank() == n) {
                        MiracleWorldDataModel.this.levels[n2].relocate();
                    }
                    ++n2;
                }
                if (n == 2 && !MiracleWorldDataModel.hasEntitiesInLevelBank()) {
                    MiracleWorldDataModel.this.moveEntityData();
                }
            }
        });
    }

    private void relocateSoundsInBank(final int n) {
        KiddEd.runWithBlockedBank(n, new Runnable(){

            @Override
            public void run() {
                MiracleWorldDataModel.this.sound.relocateSoundsInBank(n);
            }
        });
    }

    void combineSpriteTilesets() {
        block13: {
            int n;
            int n2;
            int n3;
            if (RomManager.StaticAccess.isChanged(4953) && RomManager.StaticAccess.isChanged(5019) && RomManager.StaticAccess.isChanged(5190) && RomManager.StaticAccess.isChanged(5295)) break block13;
            RomManager.StaticAccess.writeByte(4953, 205);
            RomManager.StaticAccess.writeByte(5019, 205);
            RomManager.StaticAccess.writeByte(5190, 205);
            if (!RomManager.StaticAccess.isChanged(5295)) {
                RomManager.StaticAccess.writeByte(5295, 205);
                n3 = RomManager.StaticAccess.readWord(5287);
                RomManager.StaticAccess.writeWord(5287, RomManager.StaticAccess.readWord(5299));
                RomManager.StaticAccess.writeWord(5299, n3);
                n3 = RomManager.StaticAccess.readWord(5290);
                RomManager.StaticAccess.writeWord(5290, RomManager.StaticAccess.readWord(5302));
                RomManager.StaticAccess.writeWord(5302, n3);
                RomManager.StaticAccess.copyBytes(5286, 5289, 15);
                RomManager.StaticAccess.writeByte(5286, 205);
                RomManager.StaticAccess.writeWord(5287, 325);
                RomManager.StaticAccess.incByte(5308);
                RomManager.StaticAccess.writeWord(5320, 5286);
                RomManager.StaticAccess.writeWord(5332, 5286);
                RomManager.StaticAccess.writeWord(5344, 5286);
            }
            n3 = 0;
            while (n3 < 17) {
                n2 = 0;
                n = 0;
                boolean bl = false;
                int n4 = RomManager.StaticAccess.readWord(4418 + n3 * 2);
                while (n2 == 0) {
                    block16: {
                        block15: {
                            block14: {
                                if (RomManager.StaticAccess.readByte(n4) != 195) break block14;
                                n2 = 1;
                                break block15;
                            }
                            if (RomManager.StaticAccess.readByte(n4) != 0) {
                                if (RomManager.StaticAccess.readByte(n4) != 205) break;
                            }
                            break block16;
                        }
                        int n5 = RomManager.StaticAccess.readWord(n4 + 1);
                        if (n5 == 5310 || n5 == 5322 || n5 == 5334) {
                            bl = true;
                        }
                        if (n5 == 4956 || n5 == 5022 || n5 == 5193 || n5 == 5286 || n5 == 5298) {
                            if (n5 == 5286 || n5 == 5298) {
                                n = n4;
                            }
                            RomManager.StaticAccess.writeByte(n4, n2 != 0 ? 201 : 0);
                            RomManager.StaticAccess.writeByte(n4 + 1, 0);
                            RomManager.StaticAccess.writeByte(n4 + 2, 0);
                        }
                    }
                    n4 += 3;
                }
                if (!bl && n > 0) {
                    RomManager.StaticAccess.writeByte(n, 205);
                    RomManager.StaticAccess.writeWord(n + 1, 5310);
                }
                ++n3;
            }
            SpriteTileset[] spriteTilesetArray = this.spriteTilesets;
            n = this.spriteTilesets.length;
            n2 = 0;
            while (n2 < n) {
                SpriteTileset spriteTileset = spriteTilesetArray[n2];
                spriteTileset.removeTilesListener(this.tiles[1]);
                spriteTileset.removeTilesListener(this.tiles[2]);
                ++n2;
            }
            this.spriteTilesets = MiracleWorldDataModel.parseSpriteTilesets(4418, this.tiles[1], this.tiles[2], 17);
            int n6 = 0;
            while (n6 < 17) {
                SpriteTileset[] spriteTilesetArray2 = this.spriteTilesets;
                int n7 = this.spriteTilesets.length;
                n = 0;
                while (n < n7) {
                    SpriteTileset spriteTileset = spriteTilesetArray2[n];
                    this.levelTilesets[n6 * 2 + 1].addTilesetListener(spriteTileset);
                    ++n;
                }
                ++n6;
            }
            MiracleWorldEditorModel.getInstance().updateEntityList();
            Tileset[] tilesetArray = this.tilesets;
            n = this.tilesets.length;
            int n8 = 0;
            while (n8 < n) {
                Tileset tileset = tilesetArray[n8];
                if (tileset instanceof LevelSpriteTileset) {
                    tileset.updateMemory();
                }
                ++n8;
            }
        }
    }

    private void decompressShopNameTableAndTiles() {
        CompressedNameTable compressedNameTable = (CompressedNameTable)this.nameTables[this.titleScreenNameTables.length];
        if (!compressedNameTable.isValid()) {
            throw new IllegalStateException("The nametable of the shop is invalid.");
        }
        if (!compressedNameTable.isCompressed()) {
            return;
        }
        int n = compressedNameTable.getSource();
        int n2 = compressedNameTable.getLength() + 2 * (compressedNameTable.getLength() / 2 / 127 + (compressedNameTable.getLength() / 2 % 127 > 0 ? 1 : 0) + 1);
        int n3 = KiddEd.findFreeBlock(n2);
        if (n3 > 0) {
            int n4 = n3;
            int[] nArray = compressedNameTable.getVRAM();
            int n5 = 0;
            while (n5 < 2) {
                int n6 = 0;
                int n7 = n5;
                while (n7 < compressedNameTable.getLength()) {
                    if (n6 % 127 == 0) {
                        RomManager.StaticAccess.writeByte(n4++, 0x80 | Math.min(127, compressedNameTable.getLength() / 2 - n6));
                    }
                    RomManager.StaticAccess.writeByte(n4++, nArray[compressedNameTable.getDestination() + n7]);
                    ++n6;
                    n7 += 2;
                }
                RomManager.StaticAccess.writeByte(n4++, 0);
                ++n5;
            }
            compressedNameTable.setSource(n3);
            CompressedTiles compressedTiles = (CompressedTiles)this.tiles[7 + this.levelMainTilesets.length + this.levelAdditionalTilesets.length + 3];
            n4 = MiracleWorldDataModel.decompressTiles(compressedTiles, n);
            RomManager.StaticAccess.writeWord(7588, 0x8000 | n & 0x3FFF);
            compressedTiles.setSource(n);
            this.nameTables[this.titleScreenNameTables.length + 1].moveTo(n4);
            n = n4 + this.nameTables[this.titleScreenNameTables.length + 1].getLength();
            compressedTiles = (CompressedTiles)this.tiles[7 + this.levelMainTilesets.length + this.levelAdditionalTilesets.length + 4];
            MiracleWorldDataModel.decompressTiles(compressedTiles, n);
            RomManager.StaticAccess.writeWord(7597, 0x8000 | n & 0x3FFF);
            compressedTiles.setSource(n);
        }
    }

    private void decompressJankenMatchTiles() {
        if (!this.jankenMatchTiles[0].isCompressed()) {
            return;
        }
        int n = 0;
        CompressedTiles[] compressedTilesArray = this.jankenMatchTiles;
        int n2 = this.jankenMatchTiles.length;
        int n3 = 0;
        while (n3 < n2) {
            CompressedTiles compressedTiles = compressedTilesArray[n3];
            n += compressedTiles.calcDecompressedSize();
            ++n3;
        }
        int n4 = KiddEd.findFreeBlock(n += 9);
        if (n4 > 0) {
            n3 = n4;
            RomManager.StaticAccess.copyBytes(2331, n4, 9);
            RomManager.StaticAccess.writeByte(n4 + 6, 195);
            n4 += 9;
            RomManager.StaticAccess.writeByte(2331, 0);
            RomManager.StaticAccess.writeByte(2332, 62);
            RomManager.StaticAccess.writeByte(2333, n3 / 16384);
            RomManager.StaticAccess.writeByte(2334, 50);
            RomManager.StaticAccess.writeWord(2335, 65535);
            RomManager.StaticAccess.writeWord(2338, 0x8000 | n3 & 0x3FFF);
            RomManager.StaticAccess.writeByte(31027, 0x80 | n4 / 16384);
            n2 = MiracleWorldDataModel.decompressTiles(this.jankenMatchTiles[0], n4);
            RomManager.StaticAccess.writeWord(31032, 0x8000 | n4 & 0x3FFF);
            this.jankenMatchTiles[0].setSource(n4);
            int n5 = 1;
            while (n5 < this.jankenMatchTiles.length) {
                int n6 = n2;
                n2 = MiracleWorldDataModel.decompressTiles(this.jankenMatchTiles[n5], n6);
                RomManager.StaticAccess.writeWord(30289 + (n5 - 1) * 16 + 2, 0x8000 | n6 & 0x3FFF);
                this.jankenMatchTiles[n5].setSource(n6);
                ++n5;
            }
            RomManager.StaticAccess.writeWord(n3 + 1, RomManager.StaticAccess.readWord(30291));
        }
    }

    private static int decompressTiles(CompressedTiles compressedTiles) {
        return MiracleWorldDataModel.decompressTiles(compressedTiles, compressedTiles.getSource());
    }

    private static int decompressTiles(CompressedTiles compressedTiles, int n) {
        int n2;
        TransactionManager.getInstance().addTransactionObject(compressedTiles, -1);
        int[] nArray = compressedTiles.getVRAM();
        RomManager.StaticAccess.fill(compressedTiles.getSource(), compressedTiles.getSource() + compressedTiles.getSize(), 255);
        int n3 = 0;
        while (n3 < compressedTiles.getBPP()) {
            n2 = 0;
            int n4 = n3;
            while (n4 < compressedTiles.getLength()) {
                if (n2 % 127 == 0) {
                    RomManager.StaticAccess.writeByte(n++, 0x80 | Math.min(127, compressedTiles.getLength() / 4 - n2));
                }
                RomManager.StaticAccess.writeByte(n++, nArray[compressedTiles.getDestination() + n4]);
                ++n2;
                n4 += 4;
            }
            RomManager.StaticAccess.writeByte(n++, 0);
            ++n3;
        }
        n3 = compressedTiles.getBPP();
        while (n3 < 4) {
            n2 = 0;
            while (n2 < compressedTiles.getLength()) {
                RomManager.StaticAccess.writeByte(n++, Math.min(127, (compressedTiles.getLength() - n2) / 4));
                RomManager.StaticAccess.writeByte(n++, 0);
                n2 += 508;
            }
            RomManager.StaticAccess.writeByte(n++, 0);
            ++n3;
        }
        return n;
    }

    @Override
    public boolean canAddTileToTileset(Tiles tiles) {
        Tiles tiles2;
        if (!(tiles instanceof CompressedTiles)) {
            return false;
        }
        if (tiles == this.tiles[6]) {
            return true;
        }
        if (tiles == this.tiles[7 + this.levelMainTilesets.length + this.levelAdditionalTilesets.length + 7]) {
            return true;
        }
        if (tiles == this.tiles[7 + this.levelMainTilesets.length + this.levelAdditionalTilesets.length + 5]) {
            return true;
        }
        if (tiles == this.tiles[7 + this.levelMainTilesets.length + this.levelAdditionalTilesets.length + 2]) {
            return true;
        }
        Tiles[] tilesArray = this.levelMainTilesets;
        int n = this.levelMainTilesets.length;
        int n2 = 0;
        while (n2 < n) {
            tiles2 = tilesArray[n2];
            if (tiles == tiles2) {
                return true;
            }
            ++n2;
        }
        tilesArray = this.levelAdditionalTilesets;
        n = this.levelAdditionalTilesets.length;
        n2 = 0;
        while (n2 < n) {
            tiles2 = tilesArray[n2];
            if (tiles == tiles2) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public void addTileToTileset(Tiles tiles) {
        Tiles tiles2;
        int n;
        int n2;
        Tiles[] tilesArray;
        boolean bl;
        TreeSet<CompressedTiles> treeSet = new TreeSet<CompressedTiles>(new Comparator<CompressedTiles>(){

            @Override
            public int compare(CompressedTiles compressedTiles, CompressedTiles compressedTiles2) {
                return compressedTiles.getSource() - compressedTiles2.getSource();
            }
        });
        Tiles[] tilesArray2 = null;
        boolean bl2 = tiles == this.tiles[7 + this.levelMainTilesets.length + this.levelAdditionalTilesets.length + 7];
        boolean bl3 = tiles == this.tiles[7 + this.levelMainTilesets.length + this.levelAdditionalTilesets.length + 5];
        boolean bl4 = bl = tiles == this.tiles[7 + this.levelMainTilesets.length + this.levelAdditionalTilesets.length + 2];
        if (bl2 || bl3 || bl) {
            tilesArray2 = new Tiles[]{tiles};
        }
        if (tiles == this.tiles[6]) {
            tilesArray2 = this.levelAdditionalTilesets;
        }
        if (tilesArray2 == null) {
            tilesArray = this.levelMainTilesets;
            n2 = this.levelMainTilesets.length;
            n = 0;
            while (n < n2) {
                tiles2 = tilesArray[n];
                if (tiles == tiles2) {
                    tilesArray2 = this.levelMainTilesets;
                    break;
                }
                ++n;
            }
        }
        if (tilesArray2 == null) {
            tilesArray = this.levelAdditionalTilesets;
            n2 = this.levelAdditionalTilesets.length;
            n = 0;
            while (n < n2) {
                tiles2 = tilesArray[n];
                if (tiles == tiles2) {
                    tilesArray2 = this.levelAdditionalTilesets;
                    break;
                }
                ++n;
            }
        }
        if (tilesArray2 == null) {
            return;
        }
        if (!(tiles instanceof CompressedTiles)) {
            throw new IllegalArgumentException("Tiles can only be added to instances of CompressedTiles.");
        }
        tiles2 = (CompressedTiles)tiles;
        Tiles[] tilesArray3 = tilesArray2;
        int n3 = tilesArray2.length;
        n2 = 0;
        while (n2 < n3) {
            Tiles tiles3 = tilesArray3[n2];
            if (!tiles3.isValid()) {
                throw new IllegalStateException("Cannot add tiles because Level " + (tilesArray2 == this.levelMainTilesets ? "Main" : "Additional") + " Tileset at " + Integer.toHexString(tiles3.getSource()) + " is invalid.");
            }
            ++n2;
        }
        if (!(bl2 || bl3 || bl)) {
            this.relocateAssetsInBank(((CompressedTiles)tiles2).getSource() / 16384);
        }
        int n4 = 32;
        if ((((CompressedTiles)tiles2).getLength() - 1 + 32) / 4 / 127 > (((CompressedTiles)tiles2).getLength() - 1) / 4 / 127) {
            n4 += 4;
        }
        if (tilesArray2 == this.levelMainTilesets) {
            this.defragLevelMainTilesets();
        } else if (tilesArray2 == this.levelAdditionalTilesets) {
            this.defragLevelAdditionalTilesets();
        }
        Tiles[] tilesArray4 = tilesArray2;
        int n5 = tilesArray2.length;
        n3 = 0;
        while (n3 < n5) {
            Tiles tiles4 = tilesArray4[n3];
            if (tiles4.getSource() > ((CompressedTiles)tiles2).getSource() && tiles4 instanceof CompressedTiles) {
                treeSet.add((CompressedTiles)tiles4);
            }
            ++n3;
        }
        Tiles tiles5 = treeSet.isEmpty() ? tiles2 : treeSet.last();
        n3 = 0;
        while (n3 < 3) {
            n5 = tiles5.getSource() + tiles5.getSize();
            int n6 = 0;
            while (n6 < n4) {
                if ((n5 & 0x3FFF) < (n5 - 1 & 0x3FFF) || RomManager.StaticAccess.readByte(n5++) != 255) {
                    if (n3 == 2) {
                        System.err.println("Not enough space. " + Integer.toHexString(n5 - 1));
                        return;
                    }
                    if (bl2) {
                        TransactionManager.getInstance().addTransactionObject(tiles2, -1);
                        this.relocateTitleScreenAssets();
                        break;
                    }
                    if (bl3) {
                        TransactionManager.getInstance().addTransactionObject(tiles2, -1);
                        this.relocateMapTiles();
                        break;
                    }
                    if (bl) {
                        TransactionManager.getInstance().addTransactionObject(tiles2, -1);
                        this.relocateHirottaStoneTiles();
                        break;
                    }
                    if ((n5 & 0x3FFF) != 0) {
                        System.err.println("Not enough space. " + Integer.toHexString(n5 - 1));
                    }
                    return;
                }
                ++n6;
            }
            ++n3;
        }
        if (tilesArray2 == this.levelMainTilesets) {
            for (CompressedTiles compressedTiles : treeSet.descendingSet()) {
                this.rewriteLevelMainTileset(compressedTiles, compressedTiles.getSource() + n4, compressedTiles.getLength());
            }
            this.rewriteLevelMainTileset((CompressedTiles)tiles2, ((CompressedTiles)tiles2).getSource(), ((CompressedTiles)tiles2).getLength() + 32);
        } else if (tilesArray2 == this.levelAdditionalTilesets) {
            for (CompressedTiles compressedTiles : treeSet.descendingSet()) {
                this.rewriteLevelAdditionalTileset(compressedTiles, compressedTiles.getSource() + n4, compressedTiles.getLength());
            }
            this.rewriteLevelAdditionalTileset((CompressedTiles)tiles2, ((CompressedTiles)tiles2).getSource(), ((CompressedTiles)tiles2).getLength() + 32);
        } else if (bl2 || bl3 || bl) {
            ((CompressedTiles)tiles2).rewrite(((CompressedTiles)tiles2).getSource(), ((CompressedTiles)tiles2).getLength() + 32);
        }
    }

    @Override
    public void removeTileFromTileset(Tiles tiles) {
        Tiles tiles2;
        if (!(tiles instanceof CompressedTiles)) {
            throw new IllegalArgumentException("Only tiles from instances of CompressedTiles can be removed.");
        }
        CompressedTiles compressedTiles = (CompressedTiles)tiles;
        if (compressedTiles.isCompressed()) {
            System.err.println("Tiles must not be compressed.");
            return;
        }
        if (compressedTiles.getLength() <= 32) {
            return;
        }
        if (tiles == this.tiles[6] || tiles == this.tiles[7 + this.levelMainTilesets.length + this.levelAdditionalTilesets.length + 7] || tiles == this.tiles[7 + this.levelMainTilesets.length + this.levelAdditionalTilesets.length + 5] || tiles == this.tiles[7 + this.levelMainTilesets.length + this.levelAdditionalTilesets.length + 2]) {
            tiles.rewrite(tiles.getSource(), tiles.getLength() - 32);
            return;
        }
        Tiles[] tilesArray = this.levelMainTilesets;
        int n = this.levelMainTilesets.length;
        int n2 = 0;
        while (n2 < n) {
            tiles2 = tilesArray[n2];
            if (tiles == tiles2) {
                CompressedTiles[] compressedTilesArray = this.levelMainTilesets;
                int n3 = this.levelMainTilesets.length;
                int n4 = 0;
                while (n4 < n3) {
                    CompressedTiles compressedTiles2 = compressedTilesArray[n4];
                    if (!((Tiles)compressedTiles2).isValid()) {
                        throw new IllegalStateException("Cannot remove tiles because Level Main Tileset at " + Integer.toHexString(((Tiles)compressedTiles2).getSource()) + " is invalid.");
                    }
                    ++n4;
                }
                this.rewriteLevelMainTileset(compressedTiles, compressedTiles.getSource(), compressedTiles.getLength() - 32);
                return;
            }
            ++n2;
        }
        tilesArray = this.levelAdditionalTilesets;
        n = this.levelAdditionalTilesets.length;
        n2 = 0;
        while (n2 < n) {
            tiles2 = tilesArray[n2];
            if (tiles == tiles2) {
                Tiles[] tilesArray2 = this.levelAdditionalTilesets;
                int n5 = this.levelAdditionalTilesets.length;
                int n6 = 0;
                while (n6 < n5) {
                    Tiles tiles3 = tilesArray2[n6];
                    if (!tiles3.isValid()) {
                        throw new IllegalStateException("Cannot remove tiles because Level Additional Tileset at " + Integer.toHexString(tiles3.getSource()) + " is invalid.");
                    }
                    ++n6;
                }
                this.rewriteLevelAdditionalTileset(compressedTiles, compressedTiles.getSource(), compressedTiles.getLength() - 32);
                return;
            }
            ++n2;
        }
    }

    private void rewriteLevelMainTileset(CompressedTiles compressedTiles, int n, int n2) {
        int n3 = compressedTiles.getSource();
        if (n != n3) {
            MiracleWorldDataModel.updateLevelAdditionalTilesetAddress(compressedTiles, n);
        }
        if (compressedTiles.rewrite(n, n2)) {
            int n4;
            if (n != n3) {
                int n5 = 0;
                while (n5 < 17) {
                    n4 = RomManager.StaticAccess.READ_WORD(33920 + n5 * 2, 3);
                    if (n4 == (0x8000 | n3 & 0x3FFF)) {
                        RomManager.StaticAccess.writeWord(RomManager.RESOLVE_ADDRESS(33920 + n5 * 2, 3), 0x8000 | n & 0x3FFF);
                    }
                    ++n5;
                }
            }
            CompressedTiles[] compressedTilesArray = this.levelMainTilesets;
            int n6 = this.levelMainTilesets.length;
            n4 = 0;
            while (n4 < n6) {
                CompressedTiles compressedTiles2 = compressedTilesArray[n4];
                if (!((Tiles)compressedTiles2).isValid()) {
                    throw new IllegalStateException("Level Main Tileset at " + Integer.toHexString(((Tiles)compressedTiles2).getSource()) + " is invalid.");
                }
                ++n4;
            }
        }
    }

    private void rewriteLevelAdditionalTileset(CompressedTiles compressedTiles, int n, int n2) {
        if (n != compressedTiles.getSource()) {
            MiracleWorldDataModel.updateLevelAdditionalTilesetAddress(compressedTiles, n);
        }
        if (compressedTiles.rewrite(n, n2)) {
            Tiles[] tilesArray = this.levelAdditionalTilesets;
            int n3 = this.levelAdditionalTilesets.length;
            int n4 = 0;
            while (n4 < n3) {
                Tiles tiles = tilesArray[n4];
                if (!tiles.isValid()) {
                    throw new IllegalStateException("Level Additional Tileset at " + Integer.toHexString(tiles.getSource()) + " is invalid.");
                }
                ++n4;
            }
        }
    }

    @Override
    public void updateTilesSource(CompressedTiles compressedTiles) {
        Tiles tiles;
        if (compressedTiles == this.tiles[7 + this.levelMainTilesets.length + this.levelAdditionalTilesets.length + 7]) {
            compressedTiles.setSource(RomManager.RESOLVE_ADDRESS(RomManager.StaticAccess.readWord(1969), this.titleScreenNameTables[0].getBank()));
            return;
        }
        if (compressedTiles == this.tiles[7 + this.levelMainTilesets.length + this.levelAdditionalTilesets.length + 5]) {
            int n = RomManager.StaticAccess.readWord(8902);
            int n2 = 5;
            if (RomManager.StaticAccess.readByte(8896) == 205) {
                int n3 = RomManager.StaticAccess.readWord(8897);
                n = RomManager.StaticAccess.readWord(n3 + 6);
                n2 = RomManager.StaticAccess.readByte(n3 + 1) & 0x3F;
            }
            compressedTiles.setSource(RomManager.RESOLVE_ADDRESS(n, n2));
            return;
        }
        if (compressedTiles == this.tiles[7 + this.levelMainTilesets.length + this.levelAdditionalTilesets.length + 2]) {
            this.nameTables[this.titleScreenNameTables.length + 3].update();
            compressedTiles.setSource(RomManager.RESOLVE_ADDRESS(RomManager.StaticAccess.readWord(9732), this.nameTables[this.titleScreenNameTables.length + 3].getBank()));
            return;
        }
        if (compressedTiles == this.tiles[7 + this.levelMainTilesets.length + this.levelAdditionalTilesets.length]) {
            compressedTiles.setSource(RomManager.RESOLVE_ADDRESS(RomManager.StaticAccess.readWord(6934), RomManager.StaticAccess.readByte(6929)));
            return;
        }
        int n = 0;
        while (n < this.jankenMatchTiles.length) {
            if (compressedTiles == this.jankenMatchTiles[n]) {
                int n4 = n == 0 ? RomManager.StaticAccess.readWord(31032) : RomManager.StaticAccess.readWord(30289 + (n - 1) * 16 + 2);
                compressedTiles.setSource(RomManager.RESOLVE_ADDRESS(n4, RomManager.StaticAccess.readByte(31027)));
                return;
            }
            ++n;
        }
        n = 1;
        int n5 = 0;
        while (n5 < this.tiles.length && n != 0) {
            if (compressedTiles != this.tiles[n5] && compressedTiles.getSource() == this.tiles[n5].getSource()) {
                n = 0;
            }
            ++n5;
        }
        if (n != 0 && compressedTiles.isValid()) {
            return;
        }
        n5 = 0;
        while (n5 < this.levelMainTilesets.length) {
            tiles = this.levelMainTilesets[n5];
            if (compressedTiles == tiles) {
                HashSet<Integer> hashSet = new HashSet<Integer>();
                CompressedTiles[] compressedTilesArray = this.levelMainTilesets;
                int n6 = this.levelMainTilesets.length;
                int n7 = 0;
                while (n7 < n6) {
                    CompressedTiles compressedTiles2 = compressedTilesArray[n7];
                    hashSet.add(0x8000 | ((Tiles)compressedTiles2).getSource() & 0x3FFF);
                    ++n7;
                }
                if ((RomManager.StaticAccess.readByte(6929) & 0x3F) == this.levelMainTilesets[0].getSource() / 16384) {
                    hashSet.add(RomManager.StaticAccess.readWord(6934));
                }
                int n8 = 0;
                n7 = Integer.MAX_VALUE;
                n6 = 0;
                while (n6 < 17) {
                    int n9;
                    int n10 = RomManager.StaticAccess.READ_WORD(33920 + n6 * 2, 3);
                    if (!hashSet.contains(n10) && (n9 = Math.abs(n10 - (0x8000 | compressedTiles.getSource() & 0x3FFF))) < n7) {
                        n8 = n10;
                        n7 = n9;
                    }
                    ++n6;
                }
                if (n7 > 64) {
                    n8 = compressedTiles.getSource() - 32;
                }
                compressedTiles.setSource(compressedTiles.getSource() & 0xFFFFC000 | n8 & 0x3FFF);
                if (!compressedTiles.isValid()) {
                    CompressedTiles[] compressedTilesArray2 = this.parseLevelMainTilesets();
                    int n11 = 0;
                    while (n11 < this.levelMainTilesets.length && n11 < compressedTilesArray2.length) {
                        this.levelMainTilesets[n11].setSource(((Tiles)compressedTilesArray2[n11]).getSource());
                        ++n11;
                    }
                }
                return;
            }
            ++n5;
        }
        n5 = 0;
        while (n5 < this.levelAdditionalTilesets.length) {
            tiles = this.levelAdditionalTilesets[n5];
            if (compressedTiles == tiles) {
                HashSet<Integer> hashSet = new HashSet<Integer>();
                Tiles[] tilesArray = this.levelAdditionalTilesets;
                int n12 = this.levelAdditionalTilesets.length;
                int n13 = 0;
                while (n13 < n12) {
                    Tiles tiles2 = tilesArray[n13];
                    hashSet.add(0x8000 | tiles2.getSource() & 0x3FFF);
                    ++n13;
                }
                int n14 = 3692;
                while (RomManager.StaticAccess.readByte(n14) != 201) {
                    if (RomManager.StaticAccess.readByte(n14) == 33 && RomManager.StaticAccess.readByte(n14 + 3) == 231) break;
                    if (RomManager.StaticAccess.readByte(n14) == 33 || RomManager.StaticAccess.readByte(n14) == 17 || RomManager.StaticAccess.readByte(n14) == 205 || RomManager.StaticAccess.readByte(n14) == 58) {
                        n14 += 2;
                    }
                    ++n14;
                }
                if (RomManager.StaticAccess.readByte(n14) == 33 && RomManager.StaticAccess.readByte(n14 + 3) == 231) {
                    n13 = 0;
                    n12 = Integer.MAX_VALUE;
                    int n15 = RomManager.StaticAccess.readWord(n14 + 1) + 2;
                    int n16 = 0;
                    while (n16 < 17) {
                        n14 = RomManager.StaticAccess.readWord(n15 + n16 * 2);
                        while (RomManager.StaticAccess.readByte(n14) != 201 && RomManager.StaticAccess.readByte(n14) != 195) {
                            int n17;
                            int n18;
                            if (!(RomManager.StaticAccess.readByte(n14) != 33 || RomManager.StaticAccess.readByte(n14 + 3) != 17 || RomManager.StaticAccess.readByte(n14 + 6) != 205 && RomManager.StaticAccess.readByte(n14 + 6) != 195 || RomManager.StaticAccess.readWord(n14 + 7) != 659 || hashSet.contains(n18 = RomManager.StaticAccess.READ_WORD(n14 + 1, 3)) || (n17 = Math.abs(n18 - (0x8000 | compressedTiles.getSource() & 0x3FFF))) >= n12)) {
                                n13 = n18;
                                n12 = n17;
                            }
                            if (RomManager.StaticAccess.readByte(n14) == 33 || RomManager.StaticAccess.readByte(n14) == 17 || RomManager.StaticAccess.readByte(n14) == 1 || RomManager.StaticAccess.readByte(n14) == 205 || RomManager.StaticAccess.readByte(n14) == 58) {
                                n14 += 2;
                            }
                            if (RomManager.StaticAccess.readByte(n14) == 46 || RomManager.StaticAccess.readByte(n14) == 62) {
                                ++n14;
                            }
                            ++n14;
                        }
                        ++n16;
                    }
                    if (n12 > 64) {
                        n13 = compressedTiles.getSource() - 32;
                    }
                    compressedTiles.setSource(compressedTiles.getSource() & 0xFFFFC000 | n13 & 0x3FFF);
                }
                if (!compressedTiles.isValid()) {
                    Tiles[] tilesArray2 = this.parseLevelAdditionalTilesets();
                    n12 = 0;
                    while (n12 < this.levelAdditionalTilesets.length && n12 < tilesArray2.length) {
                        ((CompressedTiles)this.levelAdditionalTilesets[n12]).setSource(tilesArray2[n12].getSource());
                        ++n12;
                    }
                }
                return;
            }
            ++n5;
        }
    }

    private void defragLevelMainTilesets() {
        this.decompressLevelTilesets();
        int n = this.levelMainTilesets[0].getSource();
        while ((n & 0x3FFF) > 0 && RomManager.StaticAccess.readByte(n - 1) == 255) {
            --n;
        }
        CompressedTiles[] compressedTilesArray = this.levelMainTilesets;
        int n2 = this.levelMainTilesets.length;
        int n3 = 0;
        while (n3 < n2) {
            CompressedTiles compressedTiles = compressedTilesArray[n3];
            this.rewriteLevelMainTileset(compressedTiles, n, compressedTiles.getLength());
            n += compressedTiles.getSize();
            ++n3;
        }
    }

    private void defragLevelAdditionalTilesets() {
        this.decompressLevelTilesets();
        int n = this.levelAdditionalTilesets[0].getSource();
        while ((n & 0x3FFF) > 0 && RomManager.StaticAccess.readByte(n - 1) == 255) {
            --n;
        }
        Tiles[] tilesArray = this.levelAdditionalTilesets;
        int n2 = this.levelAdditionalTilesets.length;
        int n3 = 0;
        while (n3 < n2) {
            Tiles tiles = tilesArray[n3];
            if (tiles instanceof CompressedTiles) {
                this.rewriteLevelAdditionalTileset((CompressedTiles)tiles, n, tiles.getLength());
                n += tiles.getSize();
            }
            ++n3;
        }
    }

    private static int findLevelTilesetCodePointerTable() {
        int n = 3692;
        while (RomManager.StaticAccess.readByte(n) != 201) {
            if (RomManager.StaticAccess.readByte(n) == 33 && RomManager.StaticAccess.readByte(n + 3) == 231) break;
            if (RomManager.StaticAccess.readByte(n) == 33 || RomManager.StaticAccess.readByte(n) == 17 || RomManager.StaticAccess.readByte(n) == 205 || RomManager.StaticAccess.readByte(n) == 58) {
                n += 2;
            }
            ++n;
        }
        return RomManager.StaticAccess.readWord(n + 1);
    }

    private int findEndOfLevelTilesetCode(int n) {
        if (n < 0 || n >= 17) {
            throw new IllegalArgumentException();
        }
        return ((LevelTileset)this.tilesets[n * 2]).findEndOfCode();
    }

    void addAdditionalTileset() {
        int n = -1;
        int n2 = -1;
        int n3 = 0;
        while (n3 < this.tiles.length && (n < 0 || n2 < 0)) {
            if (this.tiles[n3] == this.levelAdditionalTilesets[0]) {
                n = n3;
            } else if (this.tiles[n3] == this.levelAdditionalTilesets[this.levelAdditionalTilesets.length - 1]) {
                n2 = n3;
            }
            ++n3;
        }
        if (n < 0 || n2 < 0) {
            return;
        }
        n3 = 0;
        Tiles[] tilesArray = this.levelAdditionalTilesets;
        int n4 = this.levelAdditionalTilesets.length;
        int n5 = 0;
        while (n5 < n4) {
            Tiles tiles = tilesArray[n5];
            int n6 = tiles.getSource() + tiles.getSize();
            if (n6 > n3) {
                n3 = n6;
            }
            ++n5;
        }
        int n7 = 0;
        while (n7 < 40) {
            if (RomManager.StaticAccess.readByte(n3 + n7) != 255 || (n3 + n7 & 0x3FFF) < (n3 & 0x3FFF)) {
                return;
            }
            ++n7;
        }
        n7 = n3;
        n5 = 0;
        while (n5 < 4) {
            RomManager.StaticAccess.writeByte(n7++, 136);
            RomManager.StaticAccess.fill(n7++, n7 + 8, 0);
            n7 += 8;
            ++n5;
        }
        Tiles[] tilesArray2 = new Tiles[this.levelAdditionalTilesets.length + 1];
        System.arraycopy(this.levelAdditionalTilesets, 0, tilesArray2, 0, this.levelAdditionalTilesets.length);
        tilesArray2[tilesArray2.length - 1] = new CompressedTiles(tilesArray2[0].getAddress(), n3, 0x4000 | tilesArray2[0].getDestination(), false, this.levelTilesetsDecompressor);
        Tiles[] tilesArray3 = new Tiles[this.tiles.length + 1];
        System.arraycopy(this.tiles, 0, tilesArray3, 0, n);
        System.arraycopy(tilesArray2, 0, tilesArray3, n, tilesArray2.length);
        System.arraycopy(this.tiles, n2 + 1, tilesArray3, n + tilesArray2.length, this.tiles.length - (n2 + 1));
        this.levelAdditionalTilesets = tilesArray2;
        this.tiles = tilesArray3;
        TileEditor.close();
        TilesetEditor.close();
    }

    boolean canAddAdditionalTileset() {
        return this.findEndOfLevelTilesetCode(16) + 9 < 4188;
    }

    void addAdditionalTileset(LevelTileset levelTileset) {
        int n;
        if (!MiracleWorldDataModel.hasLevelTilesetsPerLevel()) {
            this.enableLevelTilesetsPerLevel();
        }
        if (!this.canAddAdditionalTileset()) {
            return;
        }
        int n2 = MiracleWorldDataModel.findLevelTilesetCodePointerTable();
        int n3 = 0;
        while (n3 * 2 < this.tilesets.length && this.tilesets[n3 * 2] != levelTileset) {
            ++n3;
        }
        if (n3 * 2 >= this.tilesets.length || this.tilesets[n3 * 2] != levelTileset) {
            return;
        }
        int n4 = n2 + (n3 + 1) * 2;
        int n5 = RomManager.StaticAccess.readWord(n4);
        TreeMap treeMap = new TreeMap(Collections.reverseOrder());
        int n6 = 0;
        while (n6 * 2 < this.tilesets.length) {
            if (this.tilesets[n6 * 2] instanceof LevelTileset) {
                LevelTileset levelTileset2 = (LevelTileset)this.tilesets[n6 * 2];
                n = n2 + (n6 + 1) * 2;
                int n7 = RomManager.StaticAccess.readWord(n);
                if (n7 > n5) {
                    treeMap.put(n7, levelTileset2);
                }
            }
            ++n6;
        }
        for (Map.Entry entry : treeMap.entrySet()) {
            n = (Integer)entry.getKey();
            LevelTileset levelTileset3 = (LevelTileset)entry.getValue();
            levelTileset3.moveCodeTo(n + 9);
            levelTileset3.updateAdditionalTilesets(this.levelMainTilesets, this.levelAdditionalTilesets);
        }
        TransactionManager.getInstance().addTransactionObject(levelTileset, -1);
        int n8 = this.findEndOfLevelTilesetCode(n3);
        RomManager.StaticAccess.writeByte(n8 - 3, 205);
        RomManager.StaticAccess.writeByte(n8++, 33);
        RomManager.StaticAccess.writeWord(n8, 0x8000 | this.levelAdditionalTilesets[0].getSource() & 0x3FFF);
        n8 += 2;
        RomManager.StaticAccess.writeByte(n8++, 17);
        RomManager.StaticAccess.writeWord(n8, 0x4000 | this.levelAdditionalTilesets[0].getDestination());
        n8 += 2;
        RomManager.StaticAccess.writeByte(n8++, 195);
        RomManager.StaticAccess.writeWord(n8, 659);
        levelTileset.updateAdditionalTilesets(this.levelMainTilesets, this.levelAdditionalTilesets);
    }

    void removeAdditionalTileset(LevelTileset levelTileset, int n) {
        if (!MiracleWorldDataModel.hasLevelTilesetsPerLevel()) {
            this.enableLevelTilesetsPerLevel();
        }
        int n2 = MiracleWorldDataModel.findLevelTilesetCodePointerTable();
        int n3 = 0;
        while (n3 * 2 < this.tilesets.length && this.tilesets[n3 * 2] != levelTileset) {
            ++n3;
        }
        if (n3 * 2 >= this.tilesets.length || this.tilesets[n3 * 2] != levelTileset) {
            return;
        }
        int n4 = n2 + (n3 + 1) * 2;
        boolean bl = false;
        int n5 = RomManager.StaticAccess.readWord(n4);
        while (n5 < 4188 && !bl) {
            int n6 = RomManager.StaticAccess.readByte(n5);
            switch (n6) {
                case 0: 
                case 215: {
                    break;
                }
                case 195: {
                    bl = true;
                }
                case 247: {
                    if (!bl) {
                        n5 -= 2;
                    }
                }
                case 205: {
                    if ((n6 == 247 || RomManager.StaticAccess.readWord(n5 + 1) == 659 || RomManager.StaticAccess.readWord(n5 + 1) == 4206) && RomManager.StaticAccess.readByte(n5 - 3) == 17 && RomManager.StaticAccess.readByte(n5 - 6) == 33 && n-- <= 0) {
                        int n7;
                        if (bl && RomManager.StaticAccess.readByte(n5 - 9) != 205) {
                            return;
                        }
                        if (bl) {
                            RomManager.StaticAccess.writeByte(n5 - 9, 195);
                        } else {
                            RomManager.StaticAccess.copyBytes(n5 + 3, n5 - 6, this.findEndOfLevelTilesetCode(n3) - (n5 + 3));
                        }
                        levelTileset.updateMemory();
                        TransactionManager.getInstance().addTransactionObject(levelTileset, -1);
                        TreeMap<Integer, LevelTileset> treeMap = new TreeMap<Integer, LevelTileset>();
                        n3 = 0;
                        while (n3 * 2 < this.tilesets.length) {
                            if (this.tilesets[n3 * 2] instanceof LevelTileset) {
                                LevelTileset object = (LevelTileset)this.tilesets[n3 * 2];
                                int n8 = n2 + (n3 + 1) * 2;
                                n7 = RomManager.StaticAccess.readWord(n8);
                                if (n7 > n5) {
                                    treeMap.put(n7, object);
                                }
                            }
                            ++n3;
                        }
                        for (Map.Entry entry : treeMap.entrySet()) {
                            n7 = (Integer)entry.getKey();
                            LevelTileset levelTileset2 = (LevelTileset)entry.getValue();
                            levelTileset2.moveCodeTo(n7 - 9);
                            levelTileset2.updateAdditionalTilesets(this.levelMainTilesets, this.levelAdditionalTilesets);
                        }
                        return;
                    }
                }
                case 1: 
                case 17: 
                case 33: 
                case 58: {
                    n5 += 2;
                    break;
                }
                case 6: 
                case 46: 
                case 62: {
                    ++n5;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown instruction: " + Integer.toHexString(RomManager.StaticAccess.readByte(n5)) + " at " + Integer.toHexString(n5));
                }
            }
            ++n5;
        }
    }

    boolean canAddMainTileset() {
        return this.findEndOfLevelTilesetCode(16) + 6 < 4188;
    }

    void addMainTileset(LevelTileset levelTileset) {
        int n;
        if (!MiracleWorldDataModel.hasLevelTilesetsPerLevel()) {
            this.enableLevelTilesetsPerLevel();
        }
        if (!this.canAddMainTileset() || levelTileset.hasMainTileset()) {
            return;
        }
        int n2 = MiracleWorldDataModel.findLevelTilesetCodePointerTable();
        int n3 = 0;
        while (n3 * 2 < this.tilesets.length && this.tilesets[n3 * 2] != levelTileset) {
            ++n3;
        }
        if (n3 * 2 >= this.tilesets.length || this.tilesets[n3 * 2] != levelTileset) {
            return;
        }
        int n4 = n2 + (n3 + 1) * 2;
        int n5 = RomManager.StaticAccess.readWord(n4);
        TreeMap treeMap = new TreeMap(Collections.reverseOrder());
        int n6 = 0;
        while (n6 * 2 < this.tilesets.length) {
            if (this.tilesets[n6 * 2] instanceof LevelTileset) {
                LevelTileset levelTileset2 = (LevelTileset)this.tilesets[n6 * 2];
                n = n2 + (n6 + 1) * 2;
                int n7 = RomManager.StaticAccess.readWord(n);
                if (n7 > n5) {
                    treeMap.put(n7, levelTileset2);
                }
            }
            ++n6;
        }
        for (Map.Entry entry : treeMap.entrySet()) {
            n = (Integer)entry.getKey();
            LevelTileset levelTileset3 = (LevelTileset)entry.getValue();
            levelTileset3.moveCodeTo(n + 6);
            levelTileset3.updateAdditionalTilesets(this.levelMainTilesets, this.levelAdditionalTilesets);
        }
        TransactionManager.getInstance().addTransactionObject(levelTileset, -1);
        int n8 = RomManager.StaticAccess.readWord(n4);
        int n9 = this.findEndOfLevelTilesetCode(n3);
        RomManager.StaticAccess.copyBytes(n8, n8 + 6, n9 - n8);
        n = 205;
        if (RomManager.StaticAccess.readByte(n8) == 205) {
            n8 += 3;
        } else if (RomManager.StaticAccess.readByte(n8) == 195) {
            RomManager.StaticAccess.writeByte(n8, 205);
            n8 += 3;
            n = 195;
        }
        RomManager.StaticAccess.writeByte(n8++, 17);
        RomManager.StaticAccess.writeWord(n8, 0x4000 | this.levelMainTilesets[0].getDestination());
        n8 += 2;
        RomManager.StaticAccess.writeByte(n8++, n);
        RomManager.StaticAccess.writeWord(n8, 4199);
    }

    void removeMainTileset(LevelTileset levelTileset) {
        if (!MiracleWorldDataModel.hasLevelTilesetsPerLevel()) {
            this.enableLevelTilesetsPerLevel();
        }
        int n = MiracleWorldDataModel.findLevelTilesetCodePointerTable();
        int n2 = 0;
        while (n2 * 2 < this.tilesets.length && this.tilesets[n2 * 2] != levelTileset) {
            ++n2;
        }
        if (n2 * 2 >= this.tilesets.length || this.tilesets[n2 * 2] != levelTileset) {
            return;
        }
        int n3 = n + (n2 + 1) * 2;
        boolean bl = false;
        int n4 = RomManager.StaticAccess.readWord(n3);
        while (n4 < 4188 && !bl) {
            int n5 = RomManager.StaticAccess.readByte(n4);
            switch (n5) {
                case 0: 
                case 215: 
                case 247: {
                    break;
                }
                case 195: {
                    bl = true;
                }
                case 205: {
                    if (RomManager.StaticAccess.readWord(n4 + 1) == 4199 && RomManager.StaticAccess.readByte(n4 - 3) == 17) {
                        int n6;
                        if (bl && RomManager.StaticAccess.readByte(n4 - 6) != 205) {
                            return;
                        }
                        if (bl) {
                            RomManager.StaticAccess.writeByte(n4 - 6, 195);
                        } else {
                            RomManager.StaticAccess.copyBytes(n4 + 3, n4 - 3, this.findEndOfLevelTilesetCode(n2) - (n4 + 3));
                        }
                        levelTileset.updateMemory();
                        TransactionManager.getInstance().addTransactionObject(levelTileset, -1);
                        TreeMap<Integer, LevelTileset> treeMap = new TreeMap<Integer, LevelTileset>();
                        n2 = 0;
                        while (n2 * 2 < this.tilesets.length) {
                            if (this.tilesets[n2 * 2] instanceof LevelTileset) {
                                LevelTileset object = (LevelTileset)this.tilesets[n2 * 2];
                                int n7 = n + (n2 + 1) * 2;
                                n6 = RomManager.StaticAccess.readWord(n7);
                                if (n6 > n4) {
                                    treeMap.put(n6, object);
                                }
                            }
                            ++n2;
                        }
                        for (Map.Entry entry : treeMap.entrySet()) {
                            n6 = (Integer)entry.getKey();
                            LevelTileset levelTileset2 = (LevelTileset)entry.getValue();
                            levelTileset2.moveCodeTo(n6 - 6);
                            levelTileset2.updateAdditionalTilesets(this.levelMainTilesets, this.levelAdditionalTilesets);
                        }
                        return;
                    }
                }
                case 1: 
                case 17: 
                case 33: 
                case 58: {
                    n4 += 2;
                    break;
                }
                case 6: 
                case 46: 
                case 62: {
                    ++n4;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown instruction: " + Integer.toHexString(RomManager.StaticAccess.readByte(n4)) + " at " + Integer.toHexString(n4));
                }
            }
            ++n4;
        }
    }

    boolean canAddClearTiles() {
        return this.findEndOfLevelTilesetCode(16) + 3 < 4188;
    }

    void addClearTiles(LevelTileset levelTileset) {
        int n;
        if (!MiracleWorldDataModel.hasLevelTilesetsPerLevel()) {
            this.enableLevelTilesetsPerLevel();
        }
        if (!this.canAddClearTiles() || levelTileset.hasClearTiles()) {
            return;
        }
        int n2 = MiracleWorldDataModel.findLevelTilesetCodePointerTable();
        int n3 = 0;
        while (n3 * 2 < this.tilesets.length && this.tilesets[n3 * 2] != levelTileset) {
            ++n3;
        }
        if (n3 * 2 >= this.tilesets.length || this.tilesets[n3 * 2] != levelTileset) {
            return;
        }
        int n4 = n2 + (n3 + 1) * 2;
        int n5 = RomManager.StaticAccess.readWord(n4);
        TreeMap treeMap = new TreeMap(Collections.reverseOrder());
        int n6 = 0;
        while (n6 * 2 < this.tilesets.length) {
            if (this.tilesets[n6 * 2] instanceof LevelTileset) {
                LevelTileset levelTileset2 = (LevelTileset)this.tilesets[n6 * 2];
                n = n2 + (n6 + 1) * 2;
                int n7 = RomManager.StaticAccess.readWord(n);
                if (n7 > n5) {
                    treeMap.put(n7, levelTileset2);
                }
            }
            ++n6;
        }
        for (Map.Entry entry : treeMap.entrySet()) {
            n = (Integer)entry.getKey();
            LevelTileset levelTileset3 = (LevelTileset)entry.getValue();
            levelTileset3.moveCodeTo(n + 3);
            levelTileset3.updateAdditionalTilesets(this.levelMainTilesets, this.levelAdditionalTilesets);
        }
        TransactionManager.getInstance().addTransactionObject(levelTileset, -1);
        int n8 = RomManager.StaticAccess.readWord(n4);
        int n9 = this.findEndOfLevelTilesetCode(n3);
        RomManager.StaticAccess.copyBytes(n8, n8 + 3, n9 - n8);
        RomManager.StaticAccess.writeByte(n8, 205);
        RomManager.StaticAccess.writeWord(n8 + 1, 4188);
    }

    void removeClearTiles(LevelTileset levelTileset) {
        if (!MiracleWorldDataModel.hasLevelTilesetsPerLevel()) {
            this.enableLevelTilesetsPerLevel();
        }
        int n = MiracleWorldDataModel.findLevelTilesetCodePointerTable();
        int n2 = 0;
        while (n2 * 2 < this.tilesets.length && this.tilesets[n2 * 2] != levelTileset) {
            ++n2;
        }
        if (n2 * 2 >= this.tilesets.length || this.tilesets[n2 * 2] != levelTileset) {
            return;
        }
        int n3 = n + (n2 + 1) * 2;
        boolean bl = false;
        int n4 = RomManager.StaticAccess.readWord(n3);
        while (n4 < 4188 && !bl) {
            int n5 = RomManager.StaticAccess.readByte(n4);
            switch (n5) {
                case 0: 
                case 215: 
                case 247: {
                    break;
                }
                case 195: {
                    bl = true;
                }
                case 205: {
                    if (RomManager.StaticAccess.readWord(n4 + 1) == 4188) {
                        int n6;
                        if (bl && RomManager.StaticAccess.readByte(n4 - 3) != 205) {
                            return;
                        }
                        if (bl) {
                            RomManager.StaticAccess.writeByte(n4 - 3, 195);
                        } else {
                            RomManager.StaticAccess.copyBytes(n4 + 3, n4, this.findEndOfLevelTilesetCode(n2) - (n4 + 3));
                        }
                        levelTileset.updateMemory();
                        TransactionManager.getInstance().addTransactionObject(levelTileset, -1);
                        TreeMap<Integer, LevelTileset> treeMap = new TreeMap<Integer, LevelTileset>();
                        n2 = 0;
                        while (n2 * 2 < this.tilesets.length) {
                            if (this.tilesets[n2 * 2] instanceof LevelTileset) {
                                LevelTileset object = (LevelTileset)this.tilesets[n2 * 2];
                                int n7 = n + (n2 + 1) * 2;
                                n6 = RomManager.StaticAccess.readWord(n7);
                                if (n6 > n4) {
                                    treeMap.put(n6, object);
                                }
                            }
                            ++n2;
                        }
                        for (Map.Entry entry : treeMap.entrySet()) {
                            n6 = (Integer)entry.getKey();
                            LevelTileset levelTileset2 = (LevelTileset)entry.getValue();
                            levelTileset2.moveCodeTo(n6 - 3);
                            levelTileset2.updateAdditionalTilesets(this.levelMainTilesets, this.levelAdditionalTilesets);
                        }
                        return;
                    }
                }
                case 1: 
                case 17: 
                case 33: 
                case 58: {
                    n4 += 2;
                    break;
                }
                case 6: 
                case 46: 
                case 62: {
                    ++n4;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown instruction: " + Integer.toHexString(RomManager.StaticAccess.readByte(n4)) + " at " + Integer.toHexString(n4));
                }
            }
            ++n4;
        }
    }

    public static boolean hasMetaTilesetsPerLevel() {
        return RomManager.StaticAccess.readByte(25182) == 33 && RomManager.StaticAccess.readByte(25183) == 108 && RomManager.StaticAccess.readByte(25184) == 98;
    }

    boolean moveMetaTilesets() {
        int n = 25182;
        if (!MiracleWorldDataModel.hasMetaTilesetsPerLevel()) {
            boolean bl = KiddEd.stopAnimationUpdater();
            int[] nArray = new int[]{RomManager.StaticAccess.readByte(25182), RomManager.StaticAccess.readByte(25183), RomManager.StaticAccess.readByte(25184)};
            RomManager.StaticAccess.writeByte(n++, 33);
            RomManager.StaticAccess.writeByte(n++, 108);
            RomManager.StaticAccess.writeByte(n++, 98);
            int n2 = 0;
            while (n2 < 17) {
                if (!(this.levels[n2].isMoving() || this.metaTilesets[n2].isLevelBank() || this.levels[n2].relocateMetaTileset() || this.levels[n2].relocate())) {
                    int n3 = 0;
                    while (n3 < nArray.length) {
                        RomManager.StaticAccess.writeByte(25182 + n3, nArray[n3]);
                        ++n3;
                    }
                    MiracleWorldMetaTileset[] miracleWorldMetaTilesetArray = this.metaTilesets;
                    int n4 = this.metaTilesets.length;
                    int n5 = 0;
                    while (n5 < n4) {
                        MiracleWorldMetaTileset miracleWorldMetaTileset = miracleWorldMetaTilesetArray[n5];
                        miracleWorldMetaTileset.updateBank();
                        ++n5;
                    }
                    throw new IllegalStateException("Failed to relocate metatileset for level " + Integer.toHexString(n2 + 1));
                }
                ++n2;
            }
            n = 25182;
            RomManager.StaticAccess.writeByte(n++, 33);
            RomManager.StaticAccess.writeByte(n++, 108);
            RomManager.StaticAccess.writeByte(n++, 98);
            RomManager.StaticAccess.writeByte(n++, 229);
            RomManager.StaticAccess.writeByte(n++, 42);
            RomManager.StaticAccess.writeByte(n++, 135);
            RomManager.StaticAccess.writeByte(n++, 192);
            RomManager.StaticAccess.writeByte(n++, 6);
            RomManager.StaticAccess.writeByte(n++, 0);
            RomManager.StaticAccess.writeByte(n++, 9);
            RomManager.StaticAccess.writeByte(n++, 195);
            RomManager.StaticAccess.writeByte(n++, 154);
            RomManager.StaticAccess.writeByte(n++, 106);
            RomManager.StaticAccess.writeByte(n++, 0);
            n = 26743;
            RomManager.StaticAccess.writeByte(n++, 229);
            RomManager.StaticAccess.writeByte(n++, 78);
            RomManager.StaticAccess.writeByte(n++, 33);
            RomManager.StaticAccess.writeByte(n++, 135);
            RomManager.StaticAccess.writeByte(n++, 104);
            RomManager.StaticAccess.writeByte(n++, 229);
            RomManager.StaticAccess.writeByte(n++, 195);
            RomManager.StaticAccess.writeByte(n++, 98);
            RomManager.StaticAccess.writeByte(n++, 98);
            RomManager.StaticAccess.writeByte(n++, 9);
            RomManager.StaticAccess.writeByte(n++, 126);
            RomManager.StaticAccess.writeByte(n++, 35);
            RomManager.StaticAccess.writeByte(n++, 102);
            RomManager.StaticAccess.writeByte(n++, 111);
            RomManager.StaticAccess.writeByte(n++, 201);
            RomManager.StaticAccess.writeByte(n++, 0);
            RomManager.StaticAccess.writeByte(26789, 119);
            n = 27280;
            RomManager.StaticAccess.writeByte(n++, 229);
            RomManager.StaticAccess.writeByte(n++, 126);
            RomManager.StaticAccess.writeByte(n++, 79);
            RomManager.StaticAccess.writeByte(n++, 33);
            RomManager.StaticAccess.writeByte(n++, 163);
            RomManager.StaticAccess.writeByte(n++, 106);
            RomManager.StaticAccess.writeByte(n++, 229);
            RomManager.StaticAccess.writeByte(n++, 195);
            RomManager.StaticAccess.writeByte(n++, 98);
            RomManager.StaticAccess.writeByte(n++, 98);
            RomManager.StaticAccess.writeByte(n++, 58);
            RomManager.StaticAccess.writeByte(n++, 129);
            RomManager.StaticAccess.writeByte(n++, 192);
            RomManager.StaticAccess.writeByte(n++, 50);
            RomManager.StaticAccess.writeByte(n++, 255);
            RomManager.StaticAccess.writeByte(n++, 255);
            RomManager.StaticAccess.writeByte(n++, 195);
            RomManager.StaticAccess.writeByte(n++, 128);
            RomManager.StaticAccess.writeByte(n++, 104);
            RomManager.StaticAccess.writeByte(27325, 144);
            n = 16971;
            RomManager.StaticAccess.writeByte(n++, 0);
            RomManager.StaticAccess.writeByte(n++, 0);
            RomManager.StaticAccess.writeByte(n++, 205);
            RomManager.StaticAccess.writeByte(n++, 154);
            RomManager.StaticAccess.writeByte(n++, 106);
            n = 17859;
            RomManager.StaticAccess.writeByte(n++, 14);
            RomManager.StaticAccess.writeByte(n++, 32);
            RomManager.StaticAccess.writeByte(n++, 32);
            RomManager.StaticAccess.writeByte(n++, 1);
            RomManager.StaticAccess.writeByte(n++, 12);
            RomManager.StaticAccess.writeByte(n++, 205);
            RomManager.StaticAccess.writeByte(n++, 98);
            RomManager.StaticAccess.writeByte(n++, 98);
            RomManager.StaticAccess.writeByte(n++, 62);
            RomManager.StaticAccess.writeByte(n++, 130);
            RomManager.StaticAccess.writeByte(n++, 50);
            RomManager.StaticAccess.writeByte(n++, 255);
            RomManager.StaticAccess.writeByte(n++, 255);
            n = 29881;
            RomManager.StaticAccess.writeByte(n++, 78);
            RomManager.StaticAccess.writeByte(n++, 35);
            RomManager.StaticAccess.writeByte(n++, 126);
            RomManager.StaticAccess.writeByte(n++, 35);
            RomManager.StaticAccess.writeByte(n++, 102);
            RomManager.StaticAccess.writeByte(n++, 111);
            RomManager.StaticAccess.writeByte(n++, 34);
            RomManager.StaticAccess.writeWord(n, 49668);
            n += 2;
            RomManager.StaticAccess.writeByte(n++, 195);
            RomManager.StaticAccess.writeWord(n, 17864);
            n += 2;
            while (n < 29895) {
                RomManager.StaticAccess.writeByte(n++, 0);
            }
            n = 30582;
            while (n < 30614) {
                n2 = RomManager.StaticAccess.readWord(n);
                int n6 = RomManager.StaticAccess.readWord(n + 2);
                int n7 = n6 == 35677 ? 80 : (n6 == 35701 ? 82 : (n6 == 35429 ? 225 : 0));
                RomManager.StaticAccess.writeByte(n, n7);
                RomManager.StaticAccess.writeWord(n + 1, n2);
                RomManager.StaticAccess.writeByte(n + 3, 0);
                n += 4;
            }
            n = 24684;
            RomManager.StaticAccess.writeByte(n++, 14);
            RomManager.StaticAccess.writeByte(n++, 80);
            RomManager.StaticAccess.writeByte(n++, 205);
            RomManager.StaticAccess.writeWord(n, 17864);
            RomManager.StaticAccess.fill(n += 2, 24700, 0);
            n = 16149;
            RomManager.StaticAccess.writeByte(n++, 14);
            RomManager.StaticAccess.writeByte(n++, 32);
            RomManager.StaticAccess.writeByte(n++, 205);
            RomManager.StaticAccess.writeWord(n, 17864);
            n += 2;
            RomManager.StaticAccess.writeByte(n++, 0);
            KiddEd.clearChanges();
            if (bl) {
                KiddEd.startAnimationUpdater();
            }
        }
        return true;
    }

    boolean canSwapLevels(int n, int n2) {
        return n != n2 && n != 16 && n2 != 16 && n != 2 && n2 != 2;
    }

    void swapLevels(int n, int n2) {
        if (this.canSwapLevels(n, n2)) {
            this.enableLevelTilesetsPerLevel();
            RomManager.StaticAccess.swapTableEntries(3338, n, n2, 2);
            RomManager.StaticAccess.swapTableEntries(3372, n, n2, 2);
            RomManager.StaticAccess.swapTableEntries(3406, n, n2, 2);
            RomManager.StaticAccess.swapTableEntries(3440, n, n2, 3);
            RomManager.StaticAccess.swapTableEntries(3491, n, n2, 2);
            RomManager.StaticAccess.swapTableEntries(3525, n, n2, 1);
            RomManager.StaticAccess.swapTableEntries(3615, n, n2, 1);
            RomManager.StaticAccess.swapTableEntries(3632, n, n2, 1);
            RomManager.StaticAccess.swapTableEntries(3709, n, n2, 2);
            RomManager.StaticAccess.swapTableEntries(4370, n, n2, 2);
            RomManager.StaticAccess.swapTableEntries(4418, n, n2, 2);
            RomManager.StaticAccess.swapTableEntries(5485, n, n2, 2);
            RomManager.StaticAccess.swapTableEntries(8073, n, n2, 2);
            RomManager.StaticAccess.swapTableEntries(8107, n, n2, 2);
            RomManager.StaticAccess.swapTableEntries(16186, n, n2, 2);
            RomManager.StaticAccess.swapTableEntries(26326, n, n2, 2);
            RomManager.StaticAccess.swapTableEntries(46341, n, n2, 2);
            RomManager.StaticAccess.swapTableEntries(50304, n, n2, 2);
            RomManager.StaticAccess.swapTableEntries(14596, n, n2, 1);
            this.levels[n].updateValidScreens();
            this.levels[n2].updateValidScreens();
            MiracleWorldMetaTileset miracleWorldMetaTileset = this.metaTilesets[n];
            this.metaTilesets[n] = this.metaTilesets[n2];
            this.metaTilesets[n2] = miracleWorldMetaTileset;
            this.levelTilesets[n * 2].updateMemory();
            this.levelTilesets[n2 * 2].updateMemory();
            ((LevelTileset)this.levelTilesets[n * 2]).updateAdditionalTilesets(this.levelMainTilesets, this.levelAdditionalTilesets);
            ((LevelTileset)this.levelTilesets[n2 * 2]).updateAdditionalTilesets(this.levelMainTilesets, this.levelAdditionalTilesets);
            this.levelPalettes[n].clearDirty();
        }
    }

    boolean moveMetaTileset(int n, int n2) {
        return this.metaTilesets[n].moveTo(n2);
    }

    private void relocateShopNameTable() {
        final CompressedNameTable compressedNameTable = (CompressedNameTable)this.nameTables[this.titleScreenNameTables.length];
        if (!compressedNameTable.isValid()) {
            throw new IllegalStateException("The nametable of the shop is invalid.");
        }
        final int n = compressedNameTable.getLength() + 2 * (compressedNameTable.getLength() / 2 / 127 + (compressedNameTable.getLength() / 2 % 127 > 0 ? 1 : 0) + 1);
        int n2 = compressedNameTable.getBank();
        KiddEd.runWithBlockedBank(n2, new Runnable(){

            @Override
            public void run() {
                int n3 = KiddEd.findFreeBlock(n);
                if (n3 > 0) {
                    int n2 = compressedNameTable.getSource();
                    RomManager.StaticAccess.copyBytes(n2, n3, n);
                    compressedNameTable.setSource(n3);
                    RomManager.StaticAccess.fill(n2, n2 + n, 255);
                }
            }
        });
    }

    private void relocateTitleScreenAssets() {
        this.relocateTitleScreenAssets(0);
    }

    private void relocateTitleScreenAssets(final int n) {
        final CompressedTiles compressedTiles = (CompressedTiles)this.tiles[7 + this.levelMainTilesets.length + this.levelAdditionalTilesets.length + 7];
        final int n2 = this.titleScreenNameTables[0].getLength() + this.titleScreenNameTables[1].getLength() + compressedTiles.calcDecompressedSize();
        int n3 = this.titleScreenNameTables[0].getBank();
        KiddEd.runWithBlockedBank(n3, new Runnable(){

            @Override
            public void run() {
                if (compressedTiles.isCompressed()) {
                    MiracleWorldDataModel.this.decompressTitleScreenTiles();
                    return;
                }
                int n3 = KiddEd.findFreeBlock(n2 + n);
                if (n3 > 0) {
                    RomManager.StaticAccess.copyBytes(MiracleWorldDataModel.this.titleScreenNameTables[0].getSource(), n3, n2);
                    RomManager.StaticAccess.fill(MiracleWorldDataModel.this.titleScreenNameTables[0].getSource(), MiracleWorldDataModel.this.titleScreenNameTables[0].getSource() + n2, 255);
                    MiracleWorldDataModel.this.titleScreenNameTables[0].setSource(n3);
                    MiracleWorldDataModel.this.titleScreenNameTables[1].setSource(n3 + MiracleWorldDataModel.this.titleScreenNameTables[0].getLength());
                    int n22 = n3 + MiracleWorldDataModel.this.titleScreenNameTables[0].getLength() + MiracleWorldDataModel.this.titleScreenNameTables[1].getLength();
                    RomManager.StaticAccess.writeWord(1969, 0x8000 | n22 & 0x3FFF);
                    compressedTiles.setSource(n22);
                }
            }
        });
    }

    void resizeTitleScreenNameTable(int n, int n2, int n3) {
        NameTable nameTable;
        block11: {
            int n4;
            int n5;
            block9: {
                CompressedTiles compressedTiles;
                block10: {
                    if (n < 0 || n > 8) {
                        throw new IllegalArgumentException("index must be between 0 and 8");
                    }
                    n5 = n3 * n2 * 2;
                    nameTable = this.titleScreenNameTables[n];
                    int n6 = nameTable.getLength();
                    n4 = n5 - n6;
                    if (n4 == 0) {
                        return;
                    }
                    if (n >= 2) break block9;
                    if (n4 > 0) {
                        this.relocateTitleScreenAssets(n4);
                    }
                    compressedTiles = (CompressedTiles)this.tiles[7 + this.levelMainTilesets.length + this.levelAdditionalTilesets.length + 7];
                    if (n4 >= 0) break block10;
                    if (n < 1) {
                        this.titleScreenNameTables[1].moveTo(this.titleScreenNameTables[1].getSource() + n4);
                    }
                    int n7 = compressedTiles.getSource() + n4;
                    int[] nArray = RomManager.StaticAccess.readBytes(new int[compressedTiles.calcDecompressedSize()], compressedTiles.getSource());
                    RomManager.StaticAccess.fill(compressedTiles.getSource(), compressedTiles.getSource() + compressedTiles.calcDecompressedSize(), 255);
                    RomManager.StaticAccess.writeBytes(nArray, n7);
                    RomManager.StaticAccess.writeWord(1969, 0x8000 | n7 & 0x3FFF);
                    compressedTiles.setSource(n7);
                    break block11;
                }
                int n8 = compressedTiles.getSource() + n4;
                int[] nArray = RomManager.StaticAccess.readBytes(new int[compressedTiles.calcDecompressedSize()], compressedTiles.getSource());
                RomManager.StaticAccess.fill(compressedTiles.getSource(), compressedTiles.getSource() + compressedTiles.calcDecompressedSize(), 255);
                RomManager.StaticAccess.writeBytes(nArray, n8);
                RomManager.StaticAccess.writeWord(1969, 0x8000 | n8 & 0x3FFF);
                compressedTiles.setSource(n8);
                if (n >= 1) break block11;
                this.titleScreenNameTables[1].moveTo(this.titleScreenNameTables[1].getSource() + n4);
                break block11;
            }
            if (n4 > 0) {
                int[] nArray = new int[this.titleScreenNameTables.length - 2];
                int[][] nArrayArray = new int[nArray.length][];
                int n9 = 0;
                int n10 = 0;
                while (n10 < nArrayArray.length) {
                    n9 += this.titleScreenNameTables[2 + n10].getLength();
                    ++n10;
                }
                n10 = KiddEd.findFreeBlock(n9 += n4);
                if (n10 > 0) {
                    int n11;
                    int n12;
                    int n13 = 0;
                    while (n13 < nArrayArray.length) {
                        n12 = this.titleScreenNameTables[2 + n13].getSource();
                        n11 = this.titleScreenNameTables[2 + n13].getLength();
                        nArray[n13] = n12;
                        nArrayArray[n13] = RomManager.StaticAccess.readBytes(new int[n11], n12);
                        ++n13;
                    }
                    n13 = n10;
                    n12 = 0;
                    while (n12 < nArrayArray.length) {
                        n11 = nArray[n12];
                        int n14 = nArrayArray[n12].length;
                        RomManager.StaticAccess.fill(n11, n11 + n14, 255);
                        RomManager.StaticAccess.writeBytes(nArrayArray[n12], n13);
                        this.titleScreenNameTables[2 + n12].setSource(n13);
                        n13 += 2 + n12 == n ? n5 : n14;
                        ++n12;
                    }
                }
            }
        }
        MiracleWorldDataModel.resizeNameTable(nameTable, n2, n3);
    }

    private static void resizeNameTable(NameTable nameTable, int n, int n2) {
        if (nameTable.getWidth() != n) {
            int n3 = nameTable.getSource();
            int[][] nArrayArray = new int[Math.min(nameTable.getHeight(), n2)][];
            int n4 = 0;
            while (n4 < nArrayArray.length) {
                nArrayArray[n4] = RomManager.StaticAccess.readBytes(new int[nameTable.getWidth() * 2], n3 + n4 * nameTable.getWidth() * 2);
                ++n4;
            }
            n4 = 0;
            while (n4 < nArrayArray.length) {
                RomManager.StaticAccess.writeBytes(nArrayArray[n4], n3 + n4 * n * 2);
                if (n > nameTable.getWidth()) {
                    RomManager.StaticAccess.fill(n3 + n4 * n * 2 + nameTable.getWidth() * 2, n3 + (n4 + 1) * n * 2, 0);
                }
                ++n4;
            }
            n4 = nArrayArray.length;
            while (n4 < n2) {
                RomManager.StaticAccess.fill(n3 + n4 * n * 2, n3 + (n4 + 1) * n * 2, 0);
                ++n4;
            }
        }
        nameTable.setWidth(n);
        nameTable.setHeight(n2);
    }

    void relocateMapTiles() {
        final CompressedTiles compressedTiles = (CompressedTiles)this.tiles[7 + this.levelMainTilesets.length + this.levelAdditionalTilesets.length + 5];
        int n = compressedTiles.getSource() / 16384;
        final int n2 = compressedTiles.calcDecompressedSize();
        KiddEd.runWithBlockedBank(n, new Runnable(){

            @Override
            public void run() {
                if (compressedTiles.isCompressed()) {
                    MiracleWorldDataModel.this.decompressMapTiles();
                    return;
                }
                int n = KiddEd.findFreeBlock(n2);
                if (n > 0) {
                    if (RomManager.StaticAccess.readByte(6781) == 33 && RomManager.StaticAccess.readByte(6784) == 17 && RomManager.StaticAccess.readWord(6785) == 16384 && RomManager.StaticAccess.readByte(6787) == 205 && RomManager.StaticAccess.readWord(6788) == 659) {
                        RomManager.StaticAccess.copyBytes(6790, 6784, 40);
                        int n22 = 6824;
                        RomManager.StaticAccess.writeByte(n22++, 24);
                        RomManager.StaticAccess.writeByte(n22++, 6872 - n22);
                        RomManager.StaticAccess.writeByte(6826, 62);
                        RomManager.StaticAccess.writeByte(6827, 0x80 | n / 16384);
                        RomManager.StaticAccess.writeByte(6828, 50);
                        RomManager.StaticAccess.writeWord(6829, 65535);
                        RomManager.StaticAccess.writeByte(6831, 33);
                        RomManager.StaticAccess.writeWord(6832, 0x8000 | n & 0x3FFF);
                        RomManager.StaticAccess.writeByte(6834, 17);
                        RomManager.StaticAccess.writeWord(6835, 16384);
                        RomManager.StaticAccess.writeByte(6837, 195);
                        RomManager.StaticAccess.writeWord(6838, 659);
                        RomManager.StaticAccess.writeByte(6781, 205);
                        RomManager.StaticAccess.writeWord(6782, 6826);
                        RomManager.StaticAccess.copyBytes(8896, 8905, 5);
                        RomManager.StaticAccess.writeByte(8896, 205);
                        RomManager.StaticAccess.writeWord(8897, 6826);
                        RomManager.StaticAccess.fill(8899, 8905, 0);
                    }
                    if (RomManager.StaticAccess.readWord(6782) == 6826 && RomManager.StaticAccess.readWord(8897) == 6826 && RomManager.StaticAccess.readWord(6838) == 659) {
                        MiracleWorldDataModel.decompressTiles(compressedTiles, n);
                        RomManager.StaticAccess.writeByte(6827, 0x80 | n / 16384);
                        RomManager.StaticAccess.writeWord(6832, 0x8000 | n & 0x3FFF);
                        compressedTiles.setSource(n);
                    }
                }
            }
        });
    }

    private void relocateJankenMatchTiles() {
        boolean bl;
        if (this.jankenMatchTiles[0].isCompressed()) {
            this.decompressJankenMatchTiles();
            return;
        }
        int n = 0;
        CompressedTiles[] compressedTilesArray = this.jankenMatchTiles;
        int n2 = this.jankenMatchTiles.length;
        int n3 = 0;
        while (n3 < n2) {
            CompressedTiles compressedTiles = compressedTilesArray[n3];
            n += compressedTiles.calcDecompressedSize();
            ++n3;
        }
        boolean bl2 = bl = RomManager.StaticAccess.readByte(2337) == 205 && RomManager.StaticAccess.readByte(RomManager.StaticAccess.readWord(2338)) == 62 && RomManager.StaticAccess.readByte(RomManager.StaticAccess.readWord(2338) + 2) == 50 && RomManager.StaticAccess.readWord(RomManager.StaticAccess.readWord(2338) + 3) == 65535 || RomManager.StaticAccess.readByte(2332) == 62 && (RomManager.StaticAccess.readByte(2333) & 0x7F) == (RomManager.StaticAccess.readByte(31027) & 0x7F) && RomManager.StaticAccess.readByte(2334) == 50 && RomManager.StaticAccess.readWord(2335) == 65535 && RomManager.StaticAccess.readByte(2337) == 205;
        if (bl) {
            n += 9;
        }
        if ((n3 = KiddEd.findFreeBlock(n)) > 0) {
            n2 = n3;
            if (RomManager.StaticAccess.readByte(2337) == 205 && RomManager.StaticAccess.readByte(RomManager.StaticAccess.readWord(2338)) == 62 && RomManager.StaticAccess.readByte(RomManager.StaticAccess.readWord(2338) + 2) == 50 && RomManager.StaticAccess.readWord(RomManager.StaticAccess.readWord(2338) + 3) == 65535) {
                int n4 = RomManager.StaticAccess.readWord(2338);
                RomManager.StaticAccess.fill(n4, n4 + 9, 255);
            }
            if (bl) {
                RomManager.StaticAccess.restoreBytes(2331, 9);
                RomManager.StaticAccess.copyBytes(2331, n3, 9);
                RomManager.StaticAccess.writeByte(n3 + 6, 195);
                n3 += 9;
                RomManager.StaticAccess.writeByte(2331, 0);
                RomManager.StaticAccess.writeByte(2332, 62);
                RomManager.StaticAccess.writeByte(2333, 0x80 | n2 / 16384);
                RomManager.StaticAccess.writeByte(2334, 50);
                RomManager.StaticAccess.writeWord(2335, 65535);
                RomManager.StaticAccess.writeWord(2338, 0x8000 | n2 & 0x3FFF);
            }
            RomManager.StaticAccess.writeByte(31027, 0x80 | n3 / 16384);
            int n5 = MiracleWorldDataModel.decompressTiles(this.jankenMatchTiles[0], n3);
            RomManager.StaticAccess.writeWord(31032, 0x8000 | n3 & 0x3FFF);
            this.jankenMatchTiles[0].setSource(n3);
            int n6 = 1;
            while (n6 < this.jankenMatchTiles.length) {
                int n7 = n5;
                n5 = MiracleWorldDataModel.decompressTiles(this.jankenMatchTiles[n6], n7);
                RomManager.StaticAccess.writeWord(30289 + (n6 - 1) * 16 + 2, 0x8000 | n7 & 0x3FFF);
                this.jankenMatchTiles[n6].setSource(n7);
                ++n6;
            }
            RomManager.StaticAccess.writeWord(n2 + 1, RomManager.StaticAccess.readWord(30291));
        }
    }

    private int relocateAlexEating() {
        int n = this.tiles[7 + this.levelMainTilesets.length + this.levelAdditionalTilesets.length].getSource();
        KiddEd.runWithBlockedBank(n / 16384, new Runnable(){

            @Override
            public void run() {
                new StandardTileDecompressor(6934, 6929).decompress((CompressedTiles)MiracleWorldDataModel.this.tiles[7 + MiracleWorldDataModel.this.levelMainTilesets.length + MiracleWorldDataModel.this.levelAdditionalTilesets.length]);
            }
        });
        return n;
    }

    private boolean isBankOfHirottaStoneNameTable(int n) {
        return n == this.nameTables[this.titleScreenNameTables.length + 3].getBank();
    }

    private boolean isBankOfMapTiles(int n) {
        return n == this.tiles[7 + this.levelMainTilesets.length + this.levelAdditionalTilesets.length + 5].getSource() / 16384;
    }

    private boolean isBankOfAlexEating(int n) {
        return n == this.tiles[7 + this.levelMainTilesets.length + this.levelAdditionalTilesets.length].getSource() / 16384;
    }

    private boolean isBankOfJankenMatchTiles(int n) {
        return n == this.jankenMatchTiles[0].getSource() / 16384;
    }

    boolean isLevelMainTileset(Tiles tiles) {
        CompressedTiles[] compressedTilesArray = this.levelMainTilesets;
        int n = this.levelMainTilesets.length;
        int n2 = 0;
        while (n2 < n) {
            CompressedTiles compressedTiles = compressedTilesArray[n2];
            if (compressedTiles == tiles) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public int makeSpace(int n, int n2) {
        if (this.isBankOfAlexEating(n2) && this.tiles[7 + this.levelMainTilesets.length + this.levelAdditionalTilesets.length].getSize() >= n) {
            return this.relocateAlexEating();
        }
        return this.sound.makeSpace(n, n2);
    }

    void relocateDataInRange(int n, int n2, HashSet<Integer> hashSet) {
        int n3 = n / 16384;
        this.relocateSoundsInBank(n3);
        Level[] levelArray = this.levels;
        int n4 = this.levels.length;
        int n5 = 0;
        while (n5 < n4) {
            Level level = levelArray[n5];
            if (level.isValid() && level.getBank() == n3) {
                level.relocateDataInRange(n, n2, hashSet);
            }
            ++n5;
        }
    }

    private void convertUncompressedAdditionalTilesets() {
        if (this.levelAdditionalTilesets.length > 0 && !this.levelAdditionalTilesets[0].isCompressed()) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    int n = 0;
                    while (n < MiracleWorldDataModel.this.levelAdditionalTilesets.length) {
                        Tiles tiles = MiracleWorldDataModel.this.levelAdditionalTilesets[n];
                        if (!(tiles instanceof CompressedTiles)) {
                            int[] nArray = tiles.getVRAM();
                            int n2 = tiles.getLength();
                            int n3 = tiles.getSource();
                            int n4 = tiles.getDestination();
                            int n5 = 4 * (n2 / 4 + ((n2 - 1) / 4 / 127 + 1 + 1));
                            RomManager.StaticAccess.fill(tiles.getSource(), n3 + tiles.getSize(), 255);
                            int n6 = KiddEd.findFreeBlock(n5, n3 / 16384);
                            if (n6 < 0) {
                                TransactionManager.getInstance().rollBack(new RuntimeException());
                                return;
                            }
                            int n7 = n6;
                            int n8 = 0;
                            while (n8 < 4) {
                                int n9 = 0;
                                int n10 = n8;
                                while (n10 < n2) {
                                    if (n9 % 127 == 0) {
                                        RomManager.StaticAccess.writeByte(n7++, 0x80 | Math.min(127, n2 / 4 - n9));
                                    }
                                    RomManager.StaticAccess.writeByte(n7++, nArray[n4 + n10]);
                                    ++n9;
                                    n10 += 4;
                                }
                                RomManager.StaticAccess.writeByte(n7++, 0);
                                ++n8;
                            }
                            n8 = 0;
                            while (n8 < MiracleWorldDataModel.this.tiles.length) {
                                if (MiracleWorldDataModel.this.tiles[n8] == MiracleWorldDataModel.this.levelAdditionalTilesets[n]) {
                                    MiracleWorldDataModel.this.tiles[n8] = MiracleWorldDataModel.this.tiles[n8].toCompressedTiles(659);
                                    MiracleWorldDataModel.this.levelAdditionalTilesets[n] = MiracleWorldDataModel.this.tiles[n8];
                                    tiles = MiracleWorldDataModel.this.levelAdditionalTilesets[n];
                                    break;
                                }
                                ++n8;
                            }
                            CompressedTiles compressedTiles = (CompressedTiles)tiles;
                            MiracleWorldDataModel.updateLevelAdditionalTilesetAddress(compressedTiles, n6);
                            compressedTiles.setSource(n6);
                            KiddEd.clearChanges();
                        }
                        ++n;
                    }
                }
            };
            TransactionManager.getInstance().runTransaction(runnable);
        }
    }

    private void fixBrokenBonusLevel() {
        if (!this.levels[17].isValid()) {
            TransactionManager.getInstance().runTransaction(new Runnable(){

                @Override
                public void run() {
                    MiracleWorldDataModel.this.relocateBonusLevel();
                    KiddEd.clearChanges();
                }
            });
        }
    }

    void fixBonusLevelEntities() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                int n = Math.max(MiracleWorldDataModel.this.levels[2].calcScreenCount(), MiracleWorldDataModel.this.levels[16].calcScreenCount());
                int n2 = Math.max(MiracleWorldDataModel.this.levels[17].getStartHorizontalScreenNumber(), MiracleWorldDataModel.this.levels[18].getStartHorizontalScreenNumber()) - 1;
                if (MiracleWorldDataModel.this.levels[2].ensureEntityScreens(n) || MiracleWorldDataModel.this.levels[16].ensureEntityScreens(n) || n == n2 && (RomManager.StaticAccess.readByte(6114) & 0x7F) != n) {
                    RomManager.StaticAccess.writeByte(6114, 0x80 | n);
                }
            }
        };
        if (TransactionManager.getInstance().isTransactionRunning()) {
            runnable.run();
        } else {
            TransactionManager.getInstance().runTransaction(runnable);
        }
    }

    private static void fixLaddersWithScroll() {
        if (!RomManager.StaticAccess.isChanged(12848, 12886)) {
            int n = 12855;
            RomManager.StaticAccess.writeByte(n++, 79);
            RomManager.StaticAccess.writeByte(n++, 58);
            RomManager.StaticAccess.writeByte(n++, 176);
            RomManager.StaticAccess.writeByte(n++, 192);
            RomManager.StaticAccess.writeByte(n++, 129);
            RomManager.StaticAccess.writeByte(n++, 33);
            RomManager.StaticAccess.writeByte(n++, 12);
            RomManager.StaticAccess.writeByte(n++, 195);
            RomManager.StaticAccess.writeByte(n++, 119);
            RomManager.StaticAccess.writeByte(n++, 46);
            RomManager.StaticAccess.writeByte(n++, 20);
            RomManager.StaticAccess.writeByte(n++, 126);
            RomManager.StaticAccess.writeByte(n++, 230);
            RomManager.StaticAccess.writeByte(n++, 43);
            RomManager.StaticAccess.writeByte(n++, 119);
            RomManager.StaticAccess.writeByte(n++, 221);
            RomManager.StaticAccess.writeByte(n++, 54);
            RomManager.StaticAccess.writeByte(n++, 6);
            RomManager.StaticAccess.writeByte(n++, 4);
            RomManager.StaticAccess.writeByte(n++, 221);
            RomManager.StaticAccess.writeByte(n++, 54);
            RomManager.StaticAccess.writeByte(n++, 26);
            RomManager.StaticAccess.writeByte(n++, 10);
            RomManager.StaticAccess.writeByte(n++, 62);
            RomManager.StaticAccess.writeByte(n++, 177);
            RomManager.StaticAccess.writeByte(n++, 50);
            RomManager.StaticAccess.writeByte(n++, 16);
            RomManager.StaticAccess.writeByte(n++, 193);
            RomManager.StaticAccess.writeByte(n++, 195);
            RomManager.StaticAccess.writeByte(n++, 86);
            RomManager.StaticAccess.writeByte(n++, 59);
            System.out.println("Fixed ladders with scroll");
        }
    }

    private static void fixContinueModeIssues() {
        if (!RomManager.StaticAccess.isChanged(27942, 27958) || RomManager.StaticAccess.readByte(27951) == 0 && RomManager.StaticAccess.readByte(27952) == 0 && RomManager.StaticAccess.readByte(27953) == 0 && RomManager.StaticAccess.readByte(27954) == 175) {
            RomManager.StaticAccess.fill(27942, 27951, 0);
            int n = 27951;
            RomManager.StaticAccess.writeByte(n++, 175);
            RomManager.StaticAccess.writeByte(n++, 33);
            RomManager.StaticAccess.writeByte(n++, 145);
            RomManager.StaticAccess.writeByte(n++, 192);
            RomManager.StaticAccess.writeByte(n++, 119);
            RomManager.StaticAccess.writeByte(n++, 35);
            RomManager.StaticAccess.writeByte(n++, 119);
            RomManager.StaticAccess.fill(28293, 28296, 0);
            RomManager.StaticAccess.writeByte(28296, 195);
            RomManager.StaticAccess.writeWord(28297, 27942);
            System.out.println("Fixed continue mode issues");
        }
    }

    private static void fixLeaveLadderBug() {
        if (!RomManager.StaticAccess.isChanged(11429) || !RomManager.StaticAccess.isChanged(13054, 13057)) {
            RomManager.StaticAccess.writeByte(11429, 183);
            RomManager.StaticAccess.writeWord(13055, 11425);
            System.out.println("Fixed leave ladder bug");
        }
    }

    private static void fixCastleLayoutCrash() {
        if (!RomManager.StaticAccess.isChanged(13162, 13166)) {
            RomManager.StaticAccess.fill(13162, 13166, 0);
            System.out.println("Fixed castle layout crash");
        } else if (RomManager.StaticAccess.readByte(13162) == 0 && RomManager.StaticAccess.readWord(13163) == 45293 && RomManager.StaticAccess.readByte(13165) == 194) {
            RomManager.StaticAccess.writeByte(13165, 0);
            System.out.println("Fixed castle layout crash");
        }
    }

    private static void fixCastleScrollCrash() {
        if (!RomManager.StaticAccess.isChanged(16445, 16478)) {
            RomManager.StaticAccess.fill(16452, 16473, 0);
            int n = 16473;
            RomManager.StaticAccess.writeByte(n++, 254);
            RomManager.StaticAccess.writeByte(n++, 176);
            RomManager.StaticAccess.writeByte(n++, 210);
            System.out.println("Fixed castle scroll crash");
        }
    }

    private static void fixJankenNameTableChanges() {
        if (MiracleWorldDataModel.hasMetaTilesetsPerLevel()) {
            int n;
            if (!RomManager.StaticAccess.isChanged(29881, 29895)) {
                if (RomManager.StaticAccess.isChanged(30582, 30614)) {
                    RomManager.StaticAccess.restoreBytes(30582, 32);
                }
                n = 29881;
                RomManager.StaticAccess.writeByte(n++, 78);
                RomManager.StaticAccess.writeByte(n++, 35);
                RomManager.StaticAccess.writeByte(n++, 126);
                RomManager.StaticAccess.writeByte(n++, 35);
                RomManager.StaticAccess.writeByte(n++, 102);
                RomManager.StaticAccess.writeByte(n++, 111);
                RomManager.StaticAccess.writeByte(n++, 34);
                RomManager.StaticAccess.writeWord(n, 49668);
                n += 2;
                RomManager.StaticAccess.writeByte(n++, 195);
                RomManager.StaticAccess.writeWord(n, 17864);
                n += 2;
                while (n < 29895) {
                    RomManager.StaticAccess.writeByte(n++, 0);
                }
                n = 30582;
                while (n < 30614) {
                    int n2 = RomManager.StaticAccess.readWord(n);
                    int n3 = RomManager.StaticAccess.readWord(n + 2);
                    int n4 = n3 == 35677 ? 80 : (n3 == 35701 ? 82 : (n3 == 35429 ? 225 : 0));
                    RomManager.StaticAccess.writeByte(n, n4);
                    RomManager.StaticAccess.writeWord(n + 1, n2);
                    RomManager.StaticAccess.writeByte(n + 3, 0);
                    n += 4;
                }
                System.out.println("Fixed Janken nametable change requests");
            }
            if (!RomManager.StaticAccess.isChanged(24684, 24700)) {
                n = 24684;
                RomManager.StaticAccess.writeByte(n++, 14);
                RomManager.StaticAccess.writeByte(n++, 80);
                RomManager.StaticAccess.writeByte(n++, 205);
                RomManager.StaticAccess.writeWord(n, 17864);
                RomManager.StaticAccess.fill(n += 2, 24700, 0);
                n = 16149;
                RomManager.StaticAccess.writeByte(n++, 14);
                RomManager.StaticAccess.writeByte(n++, 32);
                RomManager.StaticAccess.writeByte(n++, 205);
                RomManager.StaticAccess.writeWord(n, 17864);
                n += 2;
                RomManager.StaticAccess.writeByte(n++, 0);
                System.out.println("Fixed Princess Lora nametable change request");
            }
        }
    }

    private void fixColorAfterInvincibility() {
        if (RomManager.StaticAccess.readByte(9836) == 62 && RomManager.StaticAccess.readByte(9838) == 17 && RomManager.StaticAccess.readWord(9839) >= 49152 && !RomManager.StaticAccess.isChanged(9841, 9844)) {
            int n = RomManager.StaticAccess.readByte(9839);
            boolean bl = false;
            int n2 = this.levelPalettes[0].getColors()[n];
            LevelPalette[] levelPaletteArray = this.levelPalettes;
            int n3 = this.levelPalettes.length;
            int n4 = 0;
            while (n4 < n3) {
                LevelPalette levelPalette = levelPaletteArray[n4];
                if (((Palette)levelPalette).getColors()[n] != n2) {
                    bl = true;
                    break;
                }
                ++n4;
            }
            if (!bl) {
                RomManager.StaticAccess.writeByte(9837, n2);
            } else {
                this.writeCodeToReloadColorAfterInvincibility();
            }
        } else if (RomManager.StaticAccess.readWord(9858) == 65535) {
            this.writeCodeToReloadColorAfterInvincibility();
        }
    }

    private static void avoidSlot0mapping() {
        int n = 46375;
        if (RomManager.StaticAccess.readWord(2706) == n) {
            int[] nArray = new int[31];
            nArray[0] = 62;
            nArray[1] = 2;
            nArray[2] = 50;
            nArray[3] = 253;
            nArray[4] = 255;
            nArray[5] = 195;
            nArray[8] = 58;
            nArray[9] = 129;
            nArray[10] = 192;
            nArray[11] = 50;
            nArray[12] = 255;
            nArray[13] = 255;
            nArray[14] = 205;
            nArray[17] = 62;
            nArray[18] = 2;
            nArray[19] = 50;
            nArray[20] = 255;
            nArray[21] = 255;
            nArray[22] = 195;
            nArray[25] = 62;
            nArray[27] = 50;
            nArray[28] = 253;
            nArray[29] = 255;
            nArray[30] = 201;
            int[] nArray2 = nArray;
            n = RomManager.StaticAccess.readWord(2706);
            int n2 = 0;
            while (n2 < nArray2.length) {
                if ((RomManager.StaticAccess.readByte(n + n2) & nArray2[n2]) != nArray2[n2]) {
                    return;
                }
                ++n2;
            }
            System.out.println("Avoid slot 0 mapping");
            n2 = RomManager.StaticAccess.readWord(n + 15);
            RomManager.StaticAccess.fill(n, n + nArray2.length, 255);
            n = 727;
            RomManager.StaticAccess.writeWord(2706, n);
            RomManager.StaticAccess.writeByte(n++, 58);
            RomManager.StaticAccess.writeWord(n, 49281);
            n += 2;
            RomManager.StaticAccess.writeByte(n++, 50);
            RomManager.StaticAccess.writeWord(n, 65535);
            n += 2;
            RomManager.StaticAccess.writeByte(n++, 205);
            RomManager.StaticAccess.writeWord(n, n2);
            n += 2;
            RomManager.StaticAccess.writeByte(n++, 62);
            RomManager.StaticAccess.writeByte(n++, 2);
            RomManager.StaticAccess.writeByte(n++, 50);
            RomManager.StaticAccess.writeWord(n, 65535);
            n += 2;
            RomManager.StaticAccess.writeByte(n++, 201);
        }
    }

    private void fixCastleBreakables() {
        if (RomManager.StaticAccess.isChanged(2989, 2992) || RomManager.StaticAccess.isChanged(3069, 3072)) {
            return;
        }
        if (this.levels[10].getBank() == 6 && this.levels[15].getBank() == 6) {
            return;
        }
        try {
            IPS iPS = new IPS(Thread.currentThread().getContextClassLoader().getResourceAsStream("patches/castleBreakables.ips"));
            KiddEd.applyPatch(iPS);
            if (!RomManager.StaticAccess.isChanged(38877, 38991)) {
                RomManager.StaticAccess.fill(38877, 38991, 255);
            }
            System.out.println("Fixed castle breakables");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    boolean isAlexWalkingToShopInGround() {
        SpriteContainer spriteContainer;
        ArrayList<SpriteContainer> arrayList = new ArrayList<SpriteContainer>();
        SpriteContainer[] spriteContainerArray = this.sprites;
        int n = this.sprites.length;
        int n2 = 0;
        while (n2 < n) {
            spriteContainer = spriteContainerArray[n2];
            if (spriteContainer.isAlexSprite()) {
                arrayList.add(spriteContainer);
            }
            ++n2;
        }
        spriteContainer = (SpriteContainer)arrayList.get(1);
        n2 = Integer.MIN_VALUE;
        Sprite[] spriteArray = spriteContainer.getSprites();
        int n3 = spriteArray.length;
        int n4 = 0;
        while (n4 < n3) {
            Sprite sprite = spriteArray[n4];
            int n5 = 0;
            while (n5 < sprite.getSpriteCount()) {
                if (sprite.getSpriteY(n5) > n2) {
                    n2 = sprite.getSpriteY(n5);
                }
                ++n5;
            }
            ++n4;
        }
        return n2 + 8 >= 24;
    }

    public static boolean isCastleBreakablesDisabled() {
        return RomManager.StaticAccess.readByte(2978) == 195 && RomManager.StaticAccess.readByte(17014) == 0 && RomManager.StaticAccess.readByte(17015) == 0 && RomManager.StaticAccess.readByte(17016) == 0;
    }

    public static boolean isMovingEntityData() {
        return RomManager.StaticAccess.readWord(2706) == 727 && RomManager.StaticAccess.readByte(727) == 201;
    }

    public static boolean hasEntitiesInLevelBank() {
        return RomManager.StaticAccess.readWord(2706) == 727;
    }

    boolean moveEntityData() {
        int n = 727;
        MiracleWorldDataModel.avoidSlot0mapping();
        if (RomManager.StaticAccess.readWord(2706) != n) {
            int n2 = RomManager.StaticAccess.readWord(2706);
            int n3 = RomManager.StaticAccess.readByte(n);
            RomManager.StaticAccess.writeByte(n, 201);
            RomManager.StaticAccess.writeWord(2706, n);
            int n4 = 0;
            while (n4 < 17) {
                if (!(this.levels[n4].isMoving() || this.levels[n4].isEntitiesLevelBank() || this.levels[n4].relocateEntityData() || this.levels[n4].relocate())) {
                    RomManager.StaticAccess.writeWord(2706, n2);
                    RomManager.StaticAccess.writeByte(n, n3);
                    throw new RuntimeException("Failed to relocate entity data for level " + Integer.toHexString(n4 + 1));
                }
                ++n4;
            }
            RomManager.StaticAccess.writeByte(n, n3);
            if (!RomManager.StaticAccess.isChanged(47297, 47301)) {
                RomManager.StaticAccess.fill(47297, 47301, 255);
            }
            if (!RomManager.StaticAccess.isChanged(47593, 47597)) {
                RomManager.StaticAccess.fill(47593, 47597, 255);
            }
            if (!RomManager.StaticAccess.isChanged(47629, 47633)) {
                RomManager.StaticAccess.fill(47629, 47633, 255);
            }
            if (!RomManager.StaticAccess.isChanged(47675, 47679)) {
                RomManager.StaticAccess.fill(47675, 47679, 255);
            }
            if (!RomManager.StaticAccess.isChanged(47693, 47697)) {
                RomManager.StaticAccess.fill(47693, 47697, 255);
            }
            RomManager.StaticAccess.writeByte(n++, 58);
            RomManager.StaticAccess.writeWord(n, 49281);
            n += 2;
            RomManager.StaticAccess.writeByte(n++, 50);
            RomManager.StaticAccess.writeWord(n, 65535);
            n += 2;
            RomManager.StaticAccess.writeByte(n++, 205);
            RomManager.StaticAccess.writeWord(n, n2);
            n += 2;
            RomManager.StaticAccess.writeByte(n++, 62);
            RomManager.StaticAccess.writeByte(n++, 2);
            RomManager.StaticAccess.writeByte(n++, 50);
            RomManager.StaticAccess.writeWord(n, 65535);
            n += 2;
            RomManager.StaticAccess.writeByte(n++, 201);
            if (RomManager.StaticAccess.readByte(6221) == 205 && RomManager.StaticAccess.readWord(6222) == 28484) {
                RomManager.StaticAccess.writeWord(6222, RomManager.StaticAccess.readWord(2706));
            }
            KiddEd.clearChanges();
        }
        return true;
    }

    private void applyAfterOpenFixes() {
        this.fixBonusLevelEntities();
        this.fixBrokenBonusLevel();
        this.fixCastleBreakables();
        this.fixBrokenLevelMainTilesets();
        this.fixBrokenEntities();
        MiracleWorldDataModel.fixBrokenItemTilesInMapScreen();
        this.fixOverlappingScreenLayouts();
        this.rewriteLevelLayouts();
        MiracleWorldDataModel.makeCrownWorkInEveryLevel();
        this.makeCraggLakeEntitiesEditable();
        MiracleWorldHacks.updateHackInvincibilityFlashing();
    }

    @Override
    public void prepareSave() {
        MiracleWorldDataModel.fixLaddersWithScroll();
        MiracleWorldDataModel.fixContinueModeIssues();
        MiracleWorldDataModel.fixLeaveLadderBug();
        MiracleWorldDataModel.fixCastleLayoutCrash();
        MiracleWorldDataModel.fixCastleScrollCrash();
        this.fixCastleBreakables();
        MiracleWorldDataModel.fixJankenNameTableChanges();
        this.fixColorAfterInvincibility();
    }

    private void fixBrokenLevelMainTilesets() {
        if (this.levelMainTilesets.length >= 11) {
            return;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                int n;
                Object object;
                int n2;
                Object object2;
                TreeMap<Object, Object> treeMap = new TreeMap<Object, Object>();
                Object object3 = MiracleWorldDataModel.this.levelMainTilesets;
                int n3 = MiracleWorldDataModel.this.levelMainTilesets.length;
                int n4 = 0;
                while (n4 < n3) {
                    CompressedTiles compressedTiles = object3[n4];
                    treeMap.put(((Tiles)compressedTiles).getSource(), compressedTiles);
                    ++n4;
                }
                int n5 = MiracleWorldDataModel.this.levelMainTilesets[0].getAddress();
                n4 = MiracleWorldDataModel.this.levelMainTilesets[0].getSource() & 0xFFFFC000;
                n3 = n4 + 16384;
                object3 = new ArrayList();
                while (n4 < n3) {
                    object2 = (Tiles)treeMap.get(n4);
                    while (object2 != null) {
                        object2 = (Tiles)treeMap.get(n4 += ((Tiles)object2).getSize());
                    }
                    object2 = new CompressedTiles(n5, n4, 0x4000 | MiracleWorldDataModel.this.levelMainTilesets[0].getDestination(), false, MiracleWorldDataModel.this.levelTilesetsDecompressor);
                    if (((CompressedTiles)object2).isValid()) {
                        n4 += ((Tiles)object2).getSize();
                        continue;
                    }
                    Integer n6 = treeMap.higherKey(n4);
                    if (n6 == null) {
                        n6 = n3;
                    }
                    while (n4 < n6) {
                        int n7 = KiddEd.findRLEpattern(n4, n6);
                        if (n7 < 0) {
                            n4 = n6;
                            continue;
                        }
                        int n8 = 0;
                        while ((RomManager.StaticAccess.readByte(n7 + n8) & 0x80) != 0) {
                            n8 += (RomManager.StaticAccess.readByte(n7 + n8) & 0x7F) + 1;
                        }
                        if (n8 < 0) continue;
                        int n9 = KiddEd.getRLElength(n7);
                        n2 = 0;
                        if (n7 + ++n8 * 2 < n6 && RomManager.StaticAccess.readByte(n7 + n8 * 2 - 1) == 0 && KiddEd.getRLElength(n7 + n8) == n9) {
                            ++n2;
                            if (n7 + n8 * 3 < n6 && RomManager.StaticAccess.readByte(n7 + n8 * 3 - 1) == 0 && KiddEd.getRLElength(n7 + n8 * 2) == n9) {
                                ++n2;
                            }
                        }
                        if (n2 <= 0) {
                            n4 = n7 + 1;
                            continue;
                        }
                        object = new int[4][n8];
                        n = ((Object)object).length - 1 - n2;
                        int n10 = 0;
                        while (n10 < ((Object)object).length) {
                            RomManager.StaticAccess.readBytes((int[])object[n10], n7 + (n10 - n) * n8);
                            ++n10;
                        }
                        RomManager.StaticAccess.fill(n4, n7 + n8 * 4, 255);
                        n10 = 0;
                        while (n10 < n) {
                            int n11 = 0;
                            while (n11 < ((Object)object[n10]).length) {
                                object[n10][n11] = object[n][n11];
                                n11 += (object[n][n11] & 0x7F) + 1;
                            }
                            object[n10][((Object)object[n10]).length - 1] = false;
                            ++n10;
                        }
                        ((ArrayList)object3).add(object);
                        n4 = n7 + n8 * 4;
                    }
                }
                object2 = new int[((ArrayList)object3).size()];
                int n12 = 0;
                while (n12 < ((int[])object2).length) {
                    int[][] nArray = (int[][])((ArrayList)object3).get(n12);
                    object2[n12] = nArray.length * nArray[0].length;
                    ++n12;
                }
                Integer[] integerArray = null;
                int[] nArray = KiddEd.findFreeBlocks((int[])object2, MiracleWorldDataModel.this.levelMainTilesets[0].getSource() / 16384);
                if (nArray == null) {
                    integerArray = treeMap.keySet().toArray(new Integer[treeMap.keySet().size()]);
                    Map.Entry entry = treeMap.ceilingEntry(n3 - 16384);
                    Object object4 = entry == null ? null : treeMap.higherKey(entry.getKey());
                    while (object4 != null && entry != null) {
                        n2 = entry.getKey() + ((Tiles)entry.getValue()).getSize();
                        if ((Integer)object4 - n2 < 136) {
                            RomManager.StaticAccess.fill(n2, (Integer)object4, 255);
                        }
                        entry = treeMap.ceilingEntry(object4);
                        object4 = (Integer)treeMap.higherKey(object4);
                    }
                    MiracleWorldDataModel.this.defragLevelMainTilesets();
                    treeMap.clear();
                    CompressedTiles[] compressedTilesArray = MiracleWorldDataModel.this.levelMainTilesets;
                    int n13 = MiracleWorldDataModel.this.levelMainTilesets.length;
                    n2 = 0;
                    while (n2 < n13) {
                        object4 = compressedTilesArray[n2];
                        treeMap.put(((Tiles)object4).getSource(), object4);
                        ++n2;
                    }
                    nArray = KiddEd.findFreeBlocks((int[])object2, MiracleWorldDataModel.this.levelMainTilesets[0].getSource() / 16384);
                }
                if (nArray == null) {
                    if (integerArray != null) {
                        int n14 = 0;
                        while (n14 < integerArray.length) {
                            MiracleWorldDataModel.this.levelMainTilesets[n14].setSource(integerArray[n14]);
                            ++n14;
                        }
                    }
                    throw new IllegalStateException("Not enough space to fix all level main tilesets.");
                }
                int n15 = 0;
                while (n15 < nArray.length) {
                    int[][] nArray2 = (int[][])((ArrayList)object3).get(n15);
                    n2 = nArray[n15];
                    int n16 = 0;
                    while (n16 < nArray2.length) {
                        RomManager.StaticAccess.writeBytes(nArray2[n16], n2 + n16 * nArray2[n16].length);
                        ++n16;
                    }
                    object = new CompressedTiles(MiracleWorldDataModel.this.levelMainTilesets[0].getAddress(), n2, 0x4000 | MiracleWorldDataModel.this.levelMainTilesets[0].getDestination(), false, MiracleWorldDataModel.this.levelTilesetsDecompressor);
                    if (!((Tiles)object).isValid()) {
                        if (integerArray != null) {
                            n = 0;
                            while (n < integerArray.length) {
                                MiracleWorldDataModel.this.levelMainTilesets[n].setSource(integerArray[n]);
                                ++n;
                            }
                        }
                        throw new IllegalStateException("An invalid tileset has been created.");
                    }
                    treeMap.put(n2, object);
                    ++n15;
                }
                MiracleWorldDataModel.this.setLevelMainTilesets(treeMap.values().toArray(new CompressedTiles[treeMap.size()]));
                KiddEd.clearChanges();
            }
        };
        TransactionManager.getInstance().runTransaction(runnable);
    }

    void swapDemoButtons() {
        this.demo.swapButtons();
    }

    void makeUpdateLevelColorsCodeAddressesConsistent() {
        if (!(RomManager.StaticAccess.isChanged(4318, 4351) || RomManager.StaticAccess.isChanged(4261, 4264) || RomManager.StaticAccess.isChanged(4299, 4302))) {
            Level[] levelArray = this.levels;
            int n = this.levels.length;
            int n2 = 0;
            while (n2 < n) {
                Level level = levelArray[n2];
                if (!(level instanceof BonusLevel) && level.getUpdateColorsCodeAddress() != 4233) {
                    level.setUpdateColorsCodeAddress(4272);
                }
                ++n2;
            }
            RomManager.StaticAccess.fill(4318, 4351, 0);
            RomManager.StaticAccess.copyBytes(4310, 4343, 8);
            RomManager.StaticAccess.fill(4310, 4318, 0);
            RomManager.StaticAccess.writeWord(4262, 4343);
            RomManager.StaticAccess.writeWord(4300, 4347);
        }
    }

    private void setLevelMainTilesets(CompressedTiles[] compressedTilesArray) {
        int n = 0;
        while (n < this.tiles.length) {
            if (this.tiles[n] == this.levelMainTilesets[0]) {
                int n2 = compressedTilesArray.length - this.levelMainTilesets.length;
                Tiles[] tilesArray = new Tiles[this.tiles.length + n2];
                System.arraycopy(this.tiles, 0, tilesArray, 0, n);
                System.arraycopy(compressedTilesArray, 0, tilesArray, n, compressedTilesArray.length);
                System.arraycopy(this.tiles, n + this.levelMainTilesets.length, tilesArray, n + compressedTilesArray.length, this.tiles.length - (n + this.levelMainTilesets.length));
                this.levelMainTilesets = compressedTilesArray;
                this.tiles = tilesArray;
                break;
            }
            ++n;
        }
    }

    private void fixBrokenEntities() {
        int n = 1;
        Level[] levelArray = this.levels;
        int n2 = this.levels.length;
        int n3 = 0;
        while (n3 < n2) {
            final Level level = levelArray[n3];
            if (!level.isValid()) {
                System.out.println("Trying to fix entities of level " + n);
                TransactionManager.getInstance().runTransaction(new Runnable(){

                    @Override
                    public void run() {
                        if (!level.relocateEntityData()) {
                            level.relocate();
                        }
                        KiddEd.clearChanges();
                    }
                });
            }
            ++n;
            ++n3;
        }
    }

    private void fixOverlappingScreenLayouts() {
        Level[] levelArray = this.levels;
        int n = this.levels.length;
        int n2 = 0;
        while (n2 < n) {
            final Level level = levelArray[n2];
            TransactionManager.getInstance().runTransaction(new Runnable(){

                @Override
                public void run() {
                    level.relocateOverlappingScreenLayouts();
                }
            });
            ++n2;
        }
    }

    private static void fixBrokenItemTilesInMapScreen() {
        if (RomManager.StaticAccess.readByte(8896) == 205 && RomManager.StaticAccess.readByte(8905) == 62 && RomManager.StaticAccess.readByte(8906) == 133 && RomManager.StaticAccess.readByte(8910) == 33 && RomManager.StaticAccess.readWord(8911) == 41429) {
            TransactionManager.getInstance().runTransaction(new Runnable(){

                @Override
                public void run() {
                    RomManager.StaticAccess.writeWord(8911, 44817);
                    System.out.println("Fixed broken item tiles in map screen.");
                }
            });
        }
    }

    private void rewriteLevelLayouts() {
        Level[] levelArray = this.levels;
        int n = this.levels.length;
        int n2 = 0;
        while (n2 < n) {
            final Level level = levelArray[n2];
            TransactionManager.getInstance().runTransaction(new Runnable(){

                @Override
                public void run() {
                    level.rewriteLayout();
                }
            });
            ++n2;
        }
    }

    private static void makeCrownWorkInEveryLevel() {
        if (RomManager.StaticAccess.isChanged(6024, 6031)) {
            return;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (RomManager.StaticAccess.readByte(24944) == 205 && RomManager.StaticAccess.readWord(24947) == 0) {
                    int n = RomManager.StaticAccess.readWord(24945);
                    while (RomManager.StaticAccess.readByte(n) != 201) {
                        RomManager.StaticAccess.restoreByte(n++);
                    }
                    RomManager.StaticAccess.restoreByte(n);
                    n = 24944;
                    while (RomManager.StaticAccess.readByte(n) != 201) {
                        RomManager.StaticAccess.restoreByte(n++);
                    }
                    RomManager.StaticAccess.restoreByte(n);
                    System.out.println("Crown hack unapplied.");
                }
                int[] nArray = RomManager.StaticAccess.readBytes(new int[7], 6024);
                RomManager.StaticAccess.copyBytes(5969, 5969 + nArray.length, 55);
                RomManager.StaticAccess.writeBytes(nArray, 5969);
                RomManager.StaticAccess.writeWord(5982, RomManager.StaticAccess.readWord(5982) + nArray.length);
                RomManager.StaticAccess.writeByte(6030, RomManager.StaticAccess.readByte(6030) - nArray.length);
                System.out.println("Made crown work in every level");
            }
        };
        TransactionManager.getInstance().runTransaction(runnable);
    }

    private void makeCraggLakeEntitiesEditable() {
        if (RomManager.StaticAccess.readByte(6221) == 205) {
            return;
        }
        TransactionManager.getInstance().runTransaction(new Runnable(){

            @Override
            public void run() {
                int[][] nArrayArray = new int[3][];
                nArrayArray[0] = new int[]{(RomManager.StaticAccess.readWord(6217) - 49920) / 32, RomManager.StaticAccess.readByte(6197), RomManager.StaticAccess.readByte(6200), RomManager.StaticAccess.readByte(6199), RomManager.StaticAccess.readByte(6202)};
                int[] nArray = new int[5];
                nArray[0] = (RomManager.StaticAccess.readWord(6249) - 49920) / 32;
                nArray[1] = RomManager.StaticAccess.readByte(6232);
                nArray[2] = RomManager.StaticAccess.readByte(6235);
                nArray[3] = RomManager.StaticAccess.readByte(6234);
                nArrayArray[1] = nArray;
                int[] nArray2 = new int[5];
                nArray2[0] = (RomManager.StaticAccess.readWord(6249) - 49920) / 32;
                nArray2[1] = RomManager.StaticAccess.readByte(6243);
                nArray2[2] = RomManager.StaticAccess.readByte(6246);
                nArray2[3] = RomManager.StaticAccess.readByte(6245);
                nArrayArray[2] = nArray2;
                int[][] nArrayArray2 = nArrayArray;
                RomManager.StaticAccess.writeWord(6222, RomManager.StaticAccess.readWord(2706));
                Level[] levelArray = MiracleWorldDataModel.this.levels;
                int n = 0;
                while (n < nArrayArray2.length) {
                    levelArray[levelArray.length - 1].addEntity(levelArray[levelArray.length - 1].getStartHorizontalScreenNumber() - 1 + n / 2, 0, nArrayArray2[n][0], nArrayArray2[n][1], nArrayArray2[n][2], nArrayArray2[n][3], nArrayArray2[n][4]);
                    ++n;
                }
                RomManager.StaticAccess.writeByte(6195, 21);
                RomManager.StaticAccess.writeByte(6215, 24);
                RomManager.StaticAccess.writeByte(6216, 4);
                RomManager.StaticAccess.writeByte(6217, 33);
                RomManager.StaticAccess.writeWord(6218, 49293);
                RomManager.StaticAccess.writeByte(6220, 52);
                RomManager.StaticAccess.writeByte(6221, 205);
                RomManager.StaticAccess.writeByte(6224, 221);
                RomManager.StaticAccess.writeByte(6225, 33);
                RomManager.StaticAccess.writeWord(6226, 49952);
                RomManager.StaticAccess.writeByte(6228, 17);
                RomManager.StaticAccess.writeWord(6229, 32);
                RomManager.StaticAccess.writeByte(6231, 58);
                RomManager.StaticAccess.writeWord(6232, 49400);
                RomManager.StaticAccess.writeByte(6234, 61);
                RomManager.StaticAccess.writeByte(6235, 71);
                RomManager.StaticAccess.writeByte(6236, 221);
                RomManager.StaticAccess.writeByte(6237, 54);
                RomManager.StaticAccess.writeByte(6238, 9);
                RomManager.StaticAccess.writeByte(6239, 0);
                RomManager.StaticAccess.writeByte(6240, 221);
                RomManager.StaticAccess.writeByte(6241, 25);
                RomManager.StaticAccess.writeByte(6242, 16);
                RomManager.StaticAccess.writeByte(6243, 248);
                RomManager.StaticAccess.fill(6244, 6260, 0);
                System.out.println("Made Cragg Lake entities editable");
            }
        });
    }

    @Override
    public void printResources() {
        Changable changable;
        System.out.println("Palettes");
        Changable[] changableArray = this.palettes;
        int n = this.palettes.length;
        int n2 = 0;
        while (n2 < n) {
            changable = changableArray[n2];
            System.out.println("\t" + changable);
            ++n2;
        }
        System.out.println();
        System.out.println("Tiles");
        changableArray = this.tiles;
        n = this.tiles.length;
        n2 = 0;
        while (n2 < n) {
            changable = changableArray[n2];
            try {
                System.out.print("\t" + Integer.toHexString(((Tiles)changable).getSource()) + "-" + Integer.toHexString(((Tiles)changable).getSource() + ((Tiles)changable).getSize() - 1));
                System.out.println(String.valueOf(((Tiles)changable).isValid() ? "\tvalid" : "\tinvalid") + (changable instanceof CompressedTiles ? "\tcompressed" : "\tuncompressed"));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            ++n2;
        }
        System.out.println();
        System.out.println("Nametables");
        changableArray = this.nameTables;
        n = this.nameTables.length;
        n2 = 0;
        while (n2 < n) {
            changable = changableArray[n2];
            System.out.print("\t" + Integer.toHexString(((NameTable)changable).getSource()) + "-" + Integer.toHexString(((NameTable)changable).getSource() + ((NameTable)changable).getSize()));
            System.out.println(String.valueOf(((NameTable)changable).isValid() ? "\tvalid" : "\tinvalid") + (changable instanceof CompressedNameTable ? "\tcompressed" : "\tuncompressed"));
            ++n2;
        }
        System.out.println();
        System.out.println("Sounds");
        this.sound.printSounds();
        System.out.println();
        System.out.println("Levels");
        changableArray = this.levels;
        n = this.levels.length;
        n2 = 0;
        while (n2 < n) {
            changable = changableArray[n2];
            System.out.println("\t" + Integer.toHexString(RomManager.RESOLVE_ADDRESS(((Level)changable).getLayoutPointer(), ((Level)changable).getBank())) + (((Level)changable).isValid() ? "\tvalid" : "\tinvalid"));
            ++n2;
        }
        System.out.println();
        System.out.println("Texts");
        this.textData.printTexts();
    }

    int getLevelNumber(int n) {
        return levelNumbers[n];
    }

    @Override
    public int getSpriteAttributeTableAddress() {
        return 8192;
    }

    private static final class StandardTileDecompressor
    implements CompressedTiles.TileDecompressor {
        private int addressSource;
        private int addressBank;

        public StandardTileDecompressor(int n, int n2) {
            this.addressSource = n;
            this.addressBank = n2;
        }

        @Override
        public void decompress(CompressedTiles compressedTiles) {
            int n = compressedTiles.calcDecompressedSize();
            int n2 = KiddEd.findFreeBlock(n);
            if (n2 > 0) {
                MiracleWorldDataModel.decompressTiles(compressedTiles, n2);
                RomManager.StaticAccess.writeWord(this.addressSource, 0x8000 | n2 & 0x3FFF);
                RomManager.StaticAccess.writeByte(this.addressBank, 0x80 | n2 / 16384);
                compressedTiles.setSource(n2);
            }
        }
    }
}

