/*
 * Decompiled with CFR 0.152.
 */
package editors;

import changes.UndoRedoManager;
import common.ComponentWrapper;
import common.MenuItem;
import common.Properties;
import common.ScreenUtilities;
import data.MetaTileset;
import data.Palette;
import data.Tiles;
import data.Tileset;
import editors.TextProvider;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.KeyStroke;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import miracleworld.MiracleWorldEditorModel;
import panels.MetaTilePanel;
import panels.MetaTilesetPanel;
import panels.TilesetPanel;
import widgets.TriStateCheckBox;

public class MetaTilesetEditor
extends JDialog {
    private static MetaTilesetEditor editor;
    private MetaTileset[] metaTilesets;
    private Tileset[] tilesets;
    private Palette[] palettes;
    private final MetaTilesetPanel metaTileset;
    private final JComboBox<String> metaTilesetSelection;
    private final TilesetPanel tileset;
    private final JComboBox<String> flags;
    private final JRadioButton palette0;
    private final JRadioButton palette1;
    private final JCheckBoxMenuItem menuItemShowTileAttributes = new JCheckBoxMenuItem(TextProvider.get("SettingsShowTileAttributes"));

    private MetaTilesetEditor(final JFrame jFrame, MetaTileset[] metaTilesetArray, Tileset[] tilesetArray, Palette[] paletteArray, int n) {
        this.setTitle(TextProvider.get("TitleMetaTileset"));
        this.metaTilesets = metaTilesetArray;
        this.tilesets = tilesetArray;
        this.palettes = paletteArray;
        this.setLayout(new BorderLayout());
        String[] stringArray = new String[metaTilesetArray.length];
        int n2 = 0;
        while (n2 < stringArray.length) {
            stringArray[n2] = String.format("%s %02X %s", TextProvider.get("Level"), n2 + 1, TextProvider.get("MetaTileset"));
            ++n2;
        }
        this.metaTilesetSelection = new JComboBox<String>(stringArray);
        this.metaTileset = new MetaTilesetPanel(metaTilesetArray[n], tilesetArray[n * 2], paletteArray[n]);
        this.metaTileset.setSelectUnusableEnabled(true);
        final MetaTilePanel metaTilePanel = new MetaTilePanel(0, metaTilesetArray[n], tilesetArray[n * 2], paletteArray[n]);
        this.metaTileset.setBorder(BorderFactory.createLoweredBevelBorder());
        metaTilePanel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.tileset = new TilesetPanel(tilesetArray[n * 2], paletteArray[n]);
        this.tileset.setScaleParent(this.metaTileset);
        this.tileset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MetaTilesetEditor.this.metaTileset.setSubTile(MetaTilesetEditor.this.tileset.getSelectedTile());
            }
        });
        this.metaTilesetSelection.setSelectedIndex(n);
        this.metaTilesetSelection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MetaTilesetEditor.this.metaTileset.setTileset(MetaTilesetEditor.this.metaTilesets[MetaTilesetEditor.this.metaTilesetSelection.getSelectedIndex()], MetaTilesetEditor.this.tilesets[MetaTilesetEditor.this.metaTilesetSelection.getSelectedIndex() * 2], MetaTilesetEditor.this.palettes[MetaTilesetEditor.this.metaTilesetSelection.getSelectedIndex()]);
                metaTilePanel.setMetaTileset(MetaTilesetEditor.this.metaTilesets[MetaTilesetEditor.this.metaTilesetSelection.getSelectedIndex()], MetaTilesetEditor.this.tilesets[MetaTilesetEditor.this.metaTilesetSelection.getSelectedIndex() * 2], MetaTilesetEditor.this.palettes[MetaTilesetEditor.this.metaTilesetSelection.getSelectedIndex()]);
                MetaTilesetEditor.this.tileset.setTileset(MetaTilesetEditor.this.tilesets[MetaTilesetEditor.this.metaTilesetSelection.getSelectedIndex() * 2], MetaTilesetEditor.this.palettes[MetaTilesetEditor.this.metaTilesetSelection.getSelectedIndex()]);
            }
        });
        this.add(this.metaTilesetSelection, "North");
        this.add((Component)this.metaTileset, "Center");
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new GridLayout(4, 1));
        jPanel.add((Component)ComponentWrapper.wrapComponent(jPanel2), "Center");
        JButton jButton = new JButton(TextProvider.get("FlipH"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MetaTilesetEditor.this.metaTileset.flipH();
            }
        });
        JButton jButton2 = new JButton(TextProvider.get("FlipV"));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MetaTilesetEditor.this.metaTileset.flipV();
            }
        });
        JPanel jPanel3 = new JPanel(new FlowLayout());
        jPanel3.add(jButton);
        jPanel3.add(jButton2);
        jPanel2.add(jPanel3);
        JPanel jPanel4 = new JPanel(new GridLayout(1, 2));
        jPanel2.add(jPanel4);
        this.palette0 = new JRadioButton(String.valueOf(TextProvider.get("Palette")) + " 0");
        this.palette1 = new JRadioButton(String.valueOf(TextProvider.get("Palette")) + " 1");
        final ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.palette0);
        buttonGroup.add(this.palette1);
        jPanel4.add(this.palette0);
        jPanel4.add(this.palette1);
        this.palette0.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MetaTilesetEditor.this.metaTileset.setPalette(0);
                MetaTilesetEditor.this.updateTilesetAttributes();
            }
        });
        this.palette1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MetaTilesetEditor.this.metaTileset.setPalette(1);
                MetaTilesetEditor.this.updateTilesetAttributes();
            }
        });
        final TriStateCheckBox triStateCheckBox = new TriStateCheckBox(TextProvider.get("Foreground"));
        jPanel2.add(triStateCheckBox);
        triStateCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MetaTilesetEditor.this.metaTileset.setPriority(triStateCheckBox.isSelected());
            }
        });
        JPanel jPanel5 = new JPanel();
        String[] stringArray2 = new String[8];
        int n3 = 0;
        while (n3 < stringArray2.length) {
            stringArray2[n3] = TextProvider.get("Attribute" + n3);
            ++n3;
        }
        this.flags = new JComboBox<String>(stringArray2);
        jPanel5.add(this.flags);
        jPanel2.add(jPanel5);
        this.flags.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (MetaTilesetEditor.this.flags.getSelectedIndex() >= 0) {
                    MetaTilesetEditor.this.metaTileset.setFlags(MetaTilesetEditor.this.flags.getSelectedIndex() << 5);
                    MetaTilesetEditor.this.updateTilesetAttributes();
                }
            }
        });
        JPanel jPanel6 = new JPanel(new FlowLayout());
        jPanel.add((Component)jPanel6, "North");
        jPanel6.add((Component)metaTilePanel, "Center");
        jPanel.add((Component)this.tileset, "South");
        this.add((Component)jPanel, "East");
        this.metaTileset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = MetaTilesetEditor.this.metaTileset.getSelectedMetaTile();
                if ((nArray[1] & 8) == (nArray[3] & 8) && (nArray[3] & 8) == (nArray[5] & 8) && (nArray[5] & 8) == (nArray[7] & 8)) {
                    if ((nArray[1] & 8) != 0) {
                        MetaTilesetEditor.this.palette1.setSelected(true);
                    } else {
                        MetaTilesetEditor.this.palette0.setSelected(true);
                    }
                } else {
                    buttonGroup.clearSelection();
                }
                if ((nArray[1] & 0x10) == (nArray[3] & 0x10) && (nArray[3] & 0x10) == (nArray[5] & 0x10) && (nArray[5] & 0x10) == (nArray[7] & 0x10)) {
                    triStateCheckBox.setSelected((nArray[1] & 0x10) != 0);
                } else {
                    triStateCheckBox.setSemiChecked();
                }
                if ((nArray[1] & 0xE0) == (nArray[3] & 0xE0) && (nArray[3] & 0xE0) == (nArray[5] & 0xE0) && (nArray[5] & 0xE0) == (nArray[7] & 0xE0)) {
                    MetaTilesetEditor.this.flags.setSelectedIndex(nArray[1] >> 5);
                } else {
                    MetaTilesetEditor.this.flags.setSelectedIndex(-1);
                }
                metaTilePanel.setMetaTile(MetaTilesetEditor.this.metaTileset.getSelectedMetaTileIndex());
                MetaTilesetEditor.this.tileset.setSelectedTile(-1);
                MetaTilesetEditor.this.tileset.setSelectionEnabled(false);
                if (MetaTilesetEditor.this.metaTileset.isEditRequested()) {
                    Tiles tiles = MetaTilesetEditor.this.tilesets[MetaTilesetEditor.this.metaTilesetSelection.getSelectedIndex() * 2].getTilesAt(nArray[0] * 32);
                    Tiles tiles2 = MetaTilesetEditor.this.tilesets[MetaTilesetEditor.this.metaTilesetSelection.getSelectedIndex() * 2].getTilesAt(nArray[2] * 32);
                    Tiles tiles3 = MetaTilesetEditor.this.tilesets[MetaTilesetEditor.this.metaTilesetSelection.getSelectedIndex() * 2].getTilesAt(nArray[4] * 32);
                    Tiles tiles4 = MetaTilesetEditor.this.tilesets[MetaTilesetEditor.this.metaTilesetSelection.getSelectedIndex() * 2].getTilesAt(nArray[6] * 32);
                    if (tiles != null && tiles == tiles2 && tiles2 == tiles3 && tiles3 == tiles4) {
                        int[][] nArray2 = new int[2][2];
                        int n = 0;
                        while (n < nArray2.length) {
                            int n2 = 0;
                            while (n2 < nArray2[n].length) {
                                nArray2[n][n2] = nArray[(n * nArray2[n].length + n2) * 2] - tiles.getDestination() / 32;
                                ++n2;
                            }
                            ++n;
                        }
                        MiracleWorldEditorModel.openTileEditor(jFrame, new Tiles[]{tiles}, new Palette[]{MetaTilesetEditor.this.palettes[MetaTilesetEditor.this.metaTilesetSelection.getSelectedIndex()]}, 0, nArray2);
                    }
                }
            }
        });
        metaTilePanel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = metaTilePanel.getSelectedTile();
                int[] nArray = MetaTilesetEditor.this.metaTileset.getSelectedMetaTile();
                MetaTilesetEditor.this.metaTileset.setSelectedMetaSubTile(n);
                if (n >= 0) {
                    if ((nArray[2 * n + 1] & 8) != 0) {
                        MetaTilesetEditor.this.palette1.setSelected(true);
                    } else {
                        MetaTilesetEditor.this.palette0.setSelected(true);
                    }
                    triStateCheckBox.setSelected((nArray[2 * n + 1] & 0x10) != 0);
                    MetaTilesetEditor.this.flags.setSelectedIndex(nArray[2 * n + 1] >> 5);
                    MetaTilesetEditor.this.tileset.setSelectedTile(nArray[2 * n]);
                    MetaTilesetEditor.this.tileset.setSelectionEnabled(true);
                } else {
                    if ((nArray[1] & 8) == (nArray[3] & 8) && (nArray[3] & 8) == (nArray[5] & 8) && (nArray[5] & 8) == (nArray[7] & 8)) {
                        if ((nArray[1] & 8) != 0) {
                            MetaTilesetEditor.this.palette1.setSelected(true);
                        } else {
                            MetaTilesetEditor.this.palette0.setSelected(true);
                        }
                    } else {
                        buttonGroup.clearSelection();
                    }
                    if ((nArray[1] & 0x10) == (nArray[3] & 0x10) && (nArray[3] & 0x10) == (nArray[5] & 0x10) && (nArray[5] & 0x10) == (nArray[7] & 0x10)) {
                        triStateCheckBox.setSelected((nArray[1] & 0x10) != 0);
                    } else {
                        triStateCheckBox.setSemiChecked();
                    }
                    if ((nArray[1] & 0xE0) == (nArray[3] & 0xE0) && (nArray[3] & 0xE0) == (nArray[5] & 0xE0) && (nArray[5] & 0xE0) == (nArray[7] & 0xE0)) {
                        MetaTilesetEditor.this.flags.setSelectedIndex(nArray[1] >> 5);
                    } else {
                        MetaTilesetEditor.this.flags.setSelectedIndex(-1);
                    }
                }
            }
        });
        this.metaTileset.setSelectedMetaTile(0);
        JMenuBar jMenuBar = new JMenuBar();
        this.setJMenuBar(jMenuBar);
        jMenuBar.add(this.makeMenuEdit());
        jMenuBar.add(this.makeMenuView());
        this.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                if (mouseWheelEvent.getUnitsToScroll() < 0) {
                    if (mouseWheelEvent.isAltDown()) {
                        float f = Math.max(1, (int)(MetaTilesetEditor.this.metaTileset.getScale() + 1.5f));
                        MetaTilesetEditor.this.metaTileset.setPreferredScale(f);
                        MetaTilesetEditor.this.pack();
                    }
                } else if (mouseWheelEvent.getUnitsToScroll() > 0 && mouseWheelEvent.isAltDown()) {
                    float f = Math.max(1, (int)(MetaTilesetEditor.this.metaTileset.getScale() - 0.5f));
                    MetaTilesetEditor.this.metaTileset.setPreferredScale(f);
                    MetaTilesetEditor.this.pack();
                }
                mouseWheelEvent.consume();
            }
        });
    }

    private JMenu makeMenuEdit() {
        JMenu jMenu = new JMenu(TextProvider.get("MenuEdit"));
        jMenu.setMnemonic('e');
        final MenuItem menuItem = new MenuItem(TextProvider.get("MenuUndo"), 117);
        jMenu.add(menuItem);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UndoRedoManager.getInstance().undo(MetaTilesetEditor.this.metaTilesets[MetaTilesetEditor.this.metaTilesetSelection.getSelectedIndex()]);
            }
        });
        menuItem.setAccelerator(KeyStroke.getKeyStroke(90, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        final MenuItem menuItem2 = new MenuItem(TextProvider.get("MenuRedo"), 114);
        jMenu.add(menuItem2);
        menuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UndoRedoManager.getInstance().redo(MetaTilesetEditor.this.metaTilesets[MetaTilesetEditor.this.metaTilesetSelection.getSelectedIndex()]);
            }
        });
        menuItem2.setAccelerator(KeyStroke.getKeyStroke(89, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        jMenu.addSeparator();
        MenuItem menuItem3 = new MenuItem(TextProvider.get("CopyMetaTile"), 99);
        jMenu.add(menuItem3);
        menuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MetaTilesetEditor.this.metaTileset.copySelectedMetaTileToClipboard();
            }
        });
        menuItem3.setAccelerator(KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        menuItem3 = new MenuItem(TextProvider.get("CopyMetaTileset"), 121);
        jMenu.add(menuItem3);
        menuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MetaTilesetEditor.this.metaTileset.copyToClipboard();
            }
        });
        menuItem3.setAccelerator(KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 0x40));
        final MenuItem menuItem4 = new MenuItem(TextProvider.get("PasteMetaTile"), 112);
        jMenu.add(menuItem4);
        menuItem4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MetaTilesetEditor.this.metaTileset.pasteMetaTileFromClipboard();
            }
        });
        menuItem4.setAccelerator(KeyStroke.getKeyStroke(86, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        final MenuItem menuItem5 = new MenuItem(TextProvider.get("PasteMetaTileset"), 97);
        jMenu.add(menuItem5);
        menuItem5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MetaTilesetEditor.this.metaTileset.pasteFromClipboard();
            }
        });
        menuItem5.setAccelerator(KeyStroke.getKeyStroke(86, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 0x40));
        jMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent menuEvent) {
                menuItem.setEnabled(UndoRedoManager.getInstance().canUndo(MetaTilesetEditor.this.metaTilesets[MetaTilesetEditor.this.metaTilesetSelection.getSelectedIndex()]));
                menuItem2.setEnabled(UndoRedoManager.getInstance().canRedo(MetaTilesetEditor.this.metaTilesets[MetaTilesetEditor.this.metaTilesetSelection.getSelectedIndex()]));
                menuItem4.setEnabled(MetaTilesetEditor.this.metaTileset.canPasteMetaTileFromClipboard());
                menuItem5.setEnabled(MetaTilesetEditor.this.metaTileset.canPasteFromClipboard());
            }

            @Override
            public void menuDeselected(MenuEvent menuEvent) {
                menuItem.setEnabled(true);
                menuItem2.setEnabled(true);
                menuItem4.setEnabled(true);
                menuItem5.setEnabled(true);
            }

            @Override
            public void menuCanceled(MenuEvent menuEvent) {
            }
        });
        return jMenu;
    }

    private JMenu makeMenuView() {
        JMenu jMenu = new JMenu(TextProvider.get("MenuView"));
        jMenu.setMnemonic('v');
        this.menuItemShowTileAttributes.setMnemonic('a');
        jMenu.add(this.menuItemShowTileAttributes);
        this.menuItemShowTileAttributes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MetaTilesetEditor.this.metaTileset.setShowTileAttributes(MetaTilesetEditor.this.menuItemShowTileAttributes.isSelected());
                MetaTilesetEditor.this.updateTilesetAttributes();
            }
        });
        this.menuItemShowTileAttributes.setAccelerator(KeyStroke.getKeyStroke(65, 0));
        return jMenu;
    }

    private void updateTilesetAttributes() {
        this.tileset.setAttributes((this.metaTileset.isShowTileAttributes() && (this.flags.getSelectedIndex() == 3 || this.flags.getSelectedIndex() == 5) ? this.flags.getSelectedIndex() << 5 : 0) | (this.palette1.isSelected() ? 8 : 0));
    }

    public static void open(JFrame jFrame, MetaTileset[] metaTilesetArray, Tileset[] tilesetArray, Palette[] paletteArray, int n, Properties properties) {
        if (editor == null) {
            editor = new MetaTilesetEditor(jFrame, metaTilesetArray, tilesetArray, paletteArray, n);
            try {
                editor.setLocation(properties.getInt("Window" + editor.getClass().getSimpleName() + "X"), properties.getInt("Window" + editor.getClass().getSimpleName() + "Y"));
            }
            catch (NumberFormatException numberFormatException) {
                editor.setLocationRelativeTo(jFrame);
            }
            try {
                editor.setSize(properties.getInt("Window" + editor.getClass().getSimpleName() + "Width"), properties.getInt("Window" + editor.getClass().getSimpleName() + "Height"));
            }
            catch (NumberFormatException numberFormatException) {
                editor.pack();
            }
        } else {
            MetaTilesetEditor.editor.metaTilesets = metaTilesetArray;
            MetaTilesetEditor.editor.tilesets = tilesetArray;
            MetaTilesetEditor.editor.palettes = paletteArray;
            MetaTilesetEditor.editor.metaTilesetSelection.setSelectedIndex(n);
        }
        if (ScreenUtilities.getScreen(editor) == null) {
            editor.setLocationRelativeTo(jFrame);
        }
        MetaTilesetEditor.editor.metaTileset.setShowTileAttributes(Boolean.parseBoolean(properties.getProperty("ShowTileAttributes")));
        MetaTilesetEditor.editor.metaTileset.setIntegerScaling(Boolean.parseBoolean(properties.getProperty("IntegerScaling")));
        MetaTilesetEditor.editor.tileset.setIntegerScaling(Boolean.parseBoolean(properties.getProperty("IntegerScaling")));
        MetaTilesetEditor.editor.menuItemShowTileAttributes.setSelected(Boolean.parseBoolean(properties.getProperty("ShowTileAttributes")));
        editor.setVisible(true);
    }

    public static void close() {
        if (editor != null) {
            editor.setVisible(false);
        }
    }

    public static void destroy() {
        if (editor != null) {
            editor.dispose();
        }
        editor = null;
    }

    public static void saveState(Properties properties) {
        if (editor != null) {
            properties.setProperty("Window" + editor.getClass().getSimpleName() + "Open", "" + editor.isVisible());
            properties.setProperty("Window" + editor.getClass().getSimpleName() + "X", "" + editor.getX());
            properties.setProperty("Window" + editor.getClass().getSimpleName() + "Y", "" + editor.getY());
            if (editor.isResizable()) {
                properties.setProperty("Window" + editor.getClass().getSimpleName() + "Width", "" + editor.getWidth());
                properties.setProperty("Window" + editor.getClass().getSimpleName() + "Height", "" + editor.getHeight());
            }
        }
    }
}

