/*
 * Decompiled with CFR 0.152.
 */
package editors;

import changes.Change;
import common.Properties;
import common.ScreenUtilities;
import data.Level;
import data.Shop;
import data.Sound;
import editors.TextProvider;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.AbstractSequentialList;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import miracleworld.MiracleWorldDataModel;
import miracleworld.MiracleWorldEditorModel;
import transactions.TransactionManager;

public class LevelSettingsEditor
extends JDialog {
    private static LevelSettingsEditor editor;
    private Level[] levels;
    private Shop shop;
    private Sound sound;
    private final JComboBox<String> settingsSelection;
    private final JComboBox<String> animateLevelTilesSelection;
    private final JComboBox<String> shopSelection;
    private final JComboBox<String> swapWithLevel;
    private final JButton[] convertLayoutButtons = new JButton[7];
    private final JButton swapLevel = new JButton(String.valueOf(TextProvider.get("SwapWith")) + ":");
    private final JCheckBox updateWaterColor;
    private final JComboBox<String> music;
    private final int[] ADDRESSES_UPDATE_LEVEL_TILES = new int[]{5586, 5599, 5612, 5625, 5650, 5663};
    private final changes.ChangeListener soundChangeListener = new changes.ChangeListener(){

        @Override
        public void changeOccurred(Change change) {
            LevelSettingsEditor.this.updateMusicNames();
        }
    };
    private final changes.ChangeListener levelChangeListener = new changes.ChangeListener(){

        @Override
        public void changeOccurred(Change change) {
            LevelSettingsEditor.this.updateLayoutComponents();
        }
    };

    private LevelSettingsEditor(Level[] levelArray, Shop shop, Sound sound, int n) {
        String[] stringArray;
        Object object;
        this.setTitle(TextProvider.get("TitleLevelSettings"));
        this.levels = levelArray;
        this.shop = shop;
        this.sound = sound;
        sound.addChangeListener(this.soundChangeListener);
        this.setLayout(new BorderLayout());
        String[] stringArray2 = new String[19];
        int n2 = 0;
        while (n2 < stringArray2.length) {
            stringArray2[n2] = String.format("%s %02X %s", TextProvider.get("Level"), n2 + 1, TextProvider.get("Settings"));
            ++n2;
        }
        this.settingsSelection = new JComboBox<String>(stringArray2);
        this.settingsSelection.setSelectedIndex(n);
        levelArray[n].addChangeListener(this.levelChangeListener);
        this.settingsSelection.addActionListener(new ActionListener(){
            private int prevSelectionIndex = -1;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                int n2;
                LevelSettingsEditor.this.updateWaterColor.setEnabled(LevelSettingsEditor.this.settingsSelection.getSelectedIndex() < 17);
                if (LevelSettingsEditor.this.updateWaterColor.isEnabled()) {
                    LevelSettingsEditor.this.updateWaterColor.setSelected(LevelSettingsEditor.this.isUpdateWaterColor());
                }
                if ((n2 = (LevelSettingsEditor.this.levels[LevelSettingsEditor.this.settingsSelection.getSelectedIndex()].getSoundControlValue() & 0x7F) - 1) >= 51) {
                    n2 = n2 + 6 - 51;
                } else if (n2 > 5) {
                    n2 = 5;
                } else if (n2 < 0) {
                    n2 = 0;
                }
                LevelSettingsEditor.this.music.setSelectedIndex(n2);
                LevelSettingsEditor.this.animateLevelTilesSelection.setEnabled(LevelSettingsEditor.this.settingsSelection.getSelectedIndex() < 17);
                if (LevelSettingsEditor.this.animateLevelTilesSelection.isEnabled()) {
                    n = 0;
                    while (n < LevelSettingsEditor.this.ADDRESSES_UPDATE_LEVEL_TILES.length) {
                        if (LevelSettingsEditor.this.levels[LevelSettingsEditor.this.settingsSelection.getSelectedIndex()].getUpdateLevelTilesCodeAddress() == LevelSettingsEditor.this.ADDRESSES_UPDATE_LEVEL_TILES[n]) {
                            LevelSettingsEditor.this.animateLevelTilesSelection.setSelectedIndex(n);
                            break;
                        }
                        ++n;
                    }
                }
                n = 0;
                LevelSettingsEditor.this.shopSelection.setEnabled(LevelSettingsEditor.this.settingsSelection.getSelectedIndex() < 17);
                if (LevelSettingsEditor.this.shopSelection.isEnabled()) {
                    for (Shop.ShopHandle shopHandle : LevelSettingsEditor.this.shop.getShopHandles()) {
                        if (LevelSettingsEditor.this.levels[LevelSettingsEditor.this.settingsSelection.getSelectedIndex()].getShopDataAddress() == (0x8000 | LevelSettingsEditor.this.shop.getShopDataAddress(shopHandle) & 0x3FFF)) {
                            LevelSettingsEditor.this.shopSelection.setSelectedIndex(n);
                            break;
                        }
                        ++n;
                    }
                }
                LevelSettingsEditor.this.updateLayoutComponents();
                if (this.prevSelectionIndex >= 0) {
                    LevelSettingsEditor.this.levels[this.prevSelectionIndex].removeChangeListener(LevelSettingsEditor.this.levelChangeListener);
                }
                LevelSettingsEditor.this.levels[LevelSettingsEditor.this.settingsSelection.getSelectedIndex()].addChangeListener(LevelSettingsEditor.this.levelChangeListener);
                this.prevSelectionIndex = LevelSettingsEditor.this.settingsSelection.getSelectedIndex();
                LevelSettingsEditor.this.swapWithLevel.setEnabled(LevelSettingsEditor.this.settingsSelection.getSelectedIndex() < 17);
                if (LevelSettingsEditor.this.swapWithLevel.isEnabled()) {
                    LevelSettingsEditor.this.swapWithLevel.setSelectedIndex(LevelSettingsEditor.this.settingsSelection.getSelectedIndex());
                }
                LevelSettingsEditor.this.swapLevel.setEnabled(false);
            }
        });
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel.add((Component)jPanel2, "North");
        this.add((Component)jPanel, "Center");
        this.updateWaterColor = new JCheckBox(TextProvider.get("CheckBoxUpdateWaterColor"), this.isUpdateWaterColor());
        this.updateWaterColor.setEnabled(n < 17);
        this.updateWaterColor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LevelSettingsEditor.this.setUpdateWaterColor(LevelSettingsEditor.this.updateWaterColor.isSelected());
            }
        });
        jPanel2.add(this.updateWaterColor);
        String[] stringArray3 = new String[this.ADDRESSES_UPDATE_LEVEL_TILES.length];
        int n3 = 0;
        while (n3 < stringArray3.length) {
            stringArray3[n3] = TextProvider.get("AnimateLevelTiles@" + Integer.toHexString(this.ADDRESSES_UPDATE_LEVEL_TILES[n3]).toUpperCase());
            ++n3;
        }
        this.animateLevelTilesSelection = new JComboBox<String>(stringArray3);
        this.animateLevelTilesSelection.setEnabled(n < 17);
        if (this.animateLevelTilesSelection.isEnabled()) {
            n3 = 0;
            while (n3 < this.ADDRESSES_UPDATE_LEVEL_TILES.length) {
                if (levelArray[n].getUpdateLevelTilesCodeAddress() == this.ADDRESSES_UPDATE_LEVEL_TILES[n3]) {
                    this.animateLevelTilesSelection.setSelectedIndex(n3);
                    break;
                }
                ++n3;
            }
        }
        this.animateLevelTilesSelection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TransactionManager.getInstance().runTransaction(new Runnable(){

                    @Override
                    public void run() {
                        LevelSettingsEditor.this.levels[LevelSettingsEditor.this.settingsSelection.getSelectedIndex()].setUpdateLevelTilesCodeAddress(LevelSettingsEditor.this.ADDRESSES_UPDATE_LEVEL_TILES[LevelSettingsEditor.this.animateLevelTilesSelection.getSelectedIndex()]);
                    }
                });
            }
        });
        jPanel2.add(this.animateLevelTilesSelection);
        String[] stringArray4 = new String[6 + sound.getSoundCount() - 48];
        stringArray4[0] = "00 No Music";
        int n4 = 1;
        while (n4 <= 7) {
            object = TextProvider.get("SoundName" + n4);
            stringArray4[n4 > 5 ? 5 : n4] = String.format("%02X %s", 0x80 | n4 + 1, object);
            ++n4;
        }
        n4 = 0;
        while (n4 < sound.getSoundCount() - 48) {
            stringArray4[6 + n4] = String.format("%02X %s", 0x80 | 48 + n4 + 3 + 1, String.valueOf(TextProvider.get("AdditionalMusic")) + " " + (n4 + 1));
            ++n4;
        }
        this.music = new JComboBox<String>(stringArray4);
        n4 = (levelArray[n].getSoundControlValue() & 0x7F) - 1;
        if (n4 >= 51) {
            n4 = n4 + 6 - 51;
        } else if (n4 > 5) {
            n4 = 5;
        } else if (n4 < 0) {
            n4 = 0;
        }
        this.music.setSelectedIndex(n4);
        this.music.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TransactionManager.getInstance().runTransaction(new Runnable(){

                    @Override
                    public void run() {
                        LevelSettingsEditor.this.levels[LevelSettingsEditor.this.settingsSelection.getSelectedIndex()].setSoundControlValue(Integer.parseInt(LevelSettingsEditor.this.music.getSelectedItem().toString().substring(0, 2), 16));
                    }
                });
            }
        });
        jPanel2.add(this.music);
        object = shop.getShopHandles();
        String[] stringArray5 = new String[((LinkedList)object).size()];
        int n5 = 0;
        while (n5 < stringArray5.length) {
            stringArray5[n5] = String.valueOf(TextProvider.get("Shop")) + " " + (n5 + 1);
            ++n5;
        }
        this.shopSelection = new JComboBox<String>(stringArray5);
        this.shopSelection.setEnabled(n < 17);
        if (this.shopSelection.isEnabled()) {
            n5 = 0;
            Iterator iterator = ((AbstractSequentialList)object).iterator();
            while (iterator.hasNext()) {
                stringArray = (String[])iterator.next();
                if (levelArray[n].getShopDataAddress() == shop.getShopDataAddress((Shop.ShopHandle)stringArray)) {
                    this.shopSelection.setSelectedIndex(n5);
                    break;
                }
                ++n5;
            }
        }
        this.shopSelection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TransactionManager.getInstance().runTransaction(new Runnable(){

                    @Override
                    public void run() {
                        Shop shop = LevelSettingsEditor.this.shop;
                        Shop.ShopHandle shopHandle = shop.getShopHandles().get(LevelSettingsEditor.this.shopSelection.getSelectedIndex());
                        LevelSettingsEditor.this.levels[LevelSettingsEditor.this.settingsSelection.getSelectedIndex()].setShopDataAddresses(shop.getShopDataAddress(shopHandle), shop.getShopWindowNameTableDescAddress(shopHandle));
                    }
                });
            }
        });
        jPanel2.add(this.shopSelection);
        JPanel jPanel3 = new JPanel();
        this.swapLevel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TransactionManager.getInstance().runTransaction(new Runnable(){

                    @Override
                    public void run() {
                        MiracleWorldEditorModel.swapLevels(LevelSettingsEditor.this.settingsSelection.getSelectedIndex(), LevelSettingsEditor.this.swapWithLevel.getSelectedIndex());
                    }
                });
            }
        });
        this.swapLevel.setEnabled(false);
        jPanel3.add(this.swapLevel);
        stringArray = new String[17];
        int n6 = 0;
        while (n6 < stringArray.length) {
            stringArray[n6] = MiracleWorldEditorModel.LEVEL_NAMES[n6];
            ++n6;
        }
        this.swapWithLevel = new JComboBox<String>(stringArray);
        this.swapWithLevel.setEnabled(n < 17);
        if (this.swapWithLevel.isEnabled()) {
            this.swapWithLevel.setSelectedIndex(n);
        }
        this.swapWithLevel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LevelSettingsEditor.this.swapLevel.setEnabled(MiracleWorldEditorModel.canSwapLevels(LevelSettingsEditor.this.swapWithLevel.getSelectedIndex(), LevelSettingsEditor.this.settingsSelection.getSelectedIndex()));
            }
        });
        jPanel3.add(this.swapWithLevel);
        jPanel.add((Component)jPanel3, "Center");
        JPanel jPanel4 = new JPanel(new FlowLayout());
        JPanel jPanel5 = new JPanel(new FlowLayout());
        JPanel jPanel6 = new JPanel(new GridLayout(2, 1));
        jPanel6.add(jPanel4);
        jPanel6.add(jPanel5);
        this.add((Component)jPanel6, "South");
        this.convertLayoutButtons[0] = new JButton(TextProvider.get("ButtonConvertToVerticalLayout"));
        this.convertLayoutButtons[0].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LevelSettingsEditor.this.convertToScrollability(1);
                LevelSettingsEditor.this.updateLayoutComponents();
            }
        });
        jPanel4.add(this.convertLayoutButtons[0]);
        this.convertLayoutButtons[1] = new JButton(TextProvider.get("ButtonConvertToHorizontalLayout"));
        this.convertLayoutButtons[1].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LevelSettingsEditor.this.convertToScrollability(8);
                LevelSettingsEditor.this.updateLayoutComponents();
            }
        });
        jPanel4.add(this.convertLayoutButtons[1]);
        this.convertLayoutButtons[2] = new JButton(TextProvider.get("ButtonConvertToHorizontalReverseLayout"));
        this.convertLayoutButtons[2].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LevelSettingsEditor.this.convertToScrollability(4);
                LevelSettingsEditor.this.updateLayoutComponents();
            }
        });
        jPanel4.add(this.convertLayoutButtons[2]);
        this.convertLayoutButtons[3] = new JButton(TextProvider.get("ButtonConvertToLshapeLayout"));
        this.convertLayoutButtons[3].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LevelSettingsEditor.this.convertToScrollability(129);
                LevelSettingsEditor.this.updateLayoutComponents();
            }
        });
        jPanel5.add(this.convertLayoutButtons[3]);
        this.convertLayoutButtons[4] = new JButton(TextProvider.get("ButtonConvertToJarLayout"));
        this.convertLayoutButtons[4].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LevelSettingsEditor.this.convertToScrollability(40);
                LevelSettingsEditor.this.updateLayoutComponents();
            }
        });
        jPanel5.add(this.convertLayoutButtons[4]);
        this.convertLayoutButtons[5] = new JButton(TextProvider.get("ButtonConvertToRiverLayout"));
        this.convertLayoutButtons[5].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LevelSettingsEditor.this.convertToScrollability(72);
                LevelSettingsEditor.this.updateLayoutComponents();
            }
        });
        jPanel5.add(this.convertLayoutButtons[5]);
        this.convertLayoutButtons[6] = new JButton(TextProvider.get("ButtonConvertToCastleLayout"));
        this.convertLayoutButtons[6].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LevelSettingsEditor.this.convertToScrollability(128);
                LevelSettingsEditor.this.updateLayoutComponents();
            }
        });
        jPanel5.add(this.convertLayoutButtons[6]);
        this.updateLayoutComponents();
        this.setResizable(false);
    }

    private void updateLayoutComponents() {
        Level level = this.levels[this.settingsSelection.getSelectedIndex()];
        this.convertLayoutButtons[0].setEnabled(level.canConvertToScrollability(1));
        this.convertLayoutButtons[1].setEnabled(level.canConvertToScrollability(8));
        this.convertLayoutButtons[2].setEnabled(level.canConvertToScrollability(4));
        this.convertLayoutButtons[3].setEnabled(level.canConvertToScrollability(129));
        this.convertLayoutButtons[4].setEnabled(level.canConvertToScrollability(40));
        this.convertLayoutButtons[5].setEnabled(level.canConvertToScrollability(72));
        this.convertLayoutButtons[6].setEnabled(level.canConvertToScrollability(128));
    }

    private void updateMusicNames() {
        String[] stringArray = new String[6 + this.sound.getSoundCount() - 48];
        stringArray[0] = "00 No Music";
        int n = 1;
        while (n <= 7) {
            String string = TextProvider.get("SoundName" + n);
            stringArray[n > 5 ? 5 : n] = String.format("%02X %s", 0x80 | n + 1, string);
            ++n;
        }
        n = 0;
        while (n < this.sound.getSoundCount() - 48) {
            stringArray[6 + n] = String.format("%02X %s", 0x80 | 48 + n + 3 + 1, String.valueOf(TextProvider.get("AdditionalMusic")) + " " + (n + 1));
            ++n;
        }
        n = this.music.getSelectedIndex();
        this.music.setModel(new JComboBox<String>(stringArray).getModel());
        this.music.setSelectedIndex(n);
    }

    private void convertToScrollability(final int n) {
        final Level level = this.levels[this.settingsSelection.getSelectedIndex()];
        if (level.canConvertToScrollability(n)) {
            int n2;
            int n3 = 0;
            int n4 = 0;
            if ((n & 0x80) != 0) {
                if (level.getScrollability() == 128) {
                    n4 = 0;
                    n3 = 1;
                    n2 = 0;
                    while (n2 < (MiracleWorldDataModel.isCastleBreakablesDisabled() ? level.getMaxVerticalScreenNumber() + 1 : 6)) {
                        int n5 = n3 - 1;
                        while (n5 < level.getMaxHorizontalScreenNumber() + 1) {
                            if (level.isValidScreen(n5, n2)) {
                                if (n2 + 1 > n4) {
                                    n4 = n2 + 1;
                                }
                                if (n5 + 1 > n3) {
                                    n3 = n5 + 1;
                                }
                            }
                            ++n5;
                        }
                        ++n2;
                    }
                } else {
                    n4 = level.getMaxVerticalScreenNumber() + 1;
                    n3 = level.getMaxHorizontalScreenNumber() + 1;
                }
                DimensionSelector dimensionSelector = (n & 1) != 0 ? new DimensionSelector(n3, n4, level.calcScreenCount(), level.calcScreenCount(), true) : new DimensionSelector(n3, n4, MiracleWorldDataModel.isCastleBreakablesDisabled() ? 16 : 8, MiracleWorldDataModel.isCastleBreakablesDisabled() ? 16 : 6, false);
                if (!dimensionSelector.isOK()) {
                    return;
                }
                n4 = dimensionSelector.getLayoutHeight();
                n3 = dimensionSelector.getLayoutWidth();
            }
            final int n6 = n4;
            n2 = n3;
            TransactionManager.getInstance().runTransaction(new Runnable(){

                @Override
                public void run() {
                    level.convertToScrollability(n, n2, n6);
                    JOptionPane.showMessageDialog(LevelSettingsEditor.this, TextProvider.get("MessageConvertLayoutSuccessful"));
                }
            });
        }
    }

    private boolean isUpdateWaterColor() {
        return this.levels[this.settingsSelection.getSelectedIndex()].getUpdateColorsCodeAddress() == 4233;
    }

    private void setUpdateWaterColor(final boolean bl) {
        TransactionManager.getInstance().runTransaction(new Runnable(){

            @Override
            public void run() {
                if (bl) {
                    LevelSettingsEditor.this.levels[LevelSettingsEditor.this.settingsSelection.getSelectedIndex()].setUpdateColorsCodeAddress(4233);
                } else {
                    LevelSettingsEditor.this.levels[LevelSettingsEditor.this.settingsSelection.getSelectedIndex()].setUpdateColorsCodeAddress(4272);
                }
            }
        });
    }

    public static void setSelectedLevel(int n) {
        if (editor != null) {
            LevelSettingsEditor.editor.settingsSelection.setSelectedIndex(n);
        }
    }

    public static void open(JFrame jFrame, Level[] levelArray, Shop shop, Sound sound, int n, Properties properties) {
        if (editor == null) {
            editor = new LevelSettingsEditor(levelArray, shop, sound, n);
            try {
                editor.setLocation(properties.getInt("Window" + editor.getClass().getSimpleName() + "X"), properties.getInt("Window" + editor.getClass().getSimpleName() + "Y"));
            }
            catch (NumberFormatException numberFormatException) {
                editor.setLocationRelativeTo(jFrame);
            }
            try {
                editor.setSize(properties.getInt("Window" + editor.getClass().getSimpleName() + "Width"), properties.getInt("Window" + editor.getClass().getSimpleName() + "Height"));
            }
            catch (NumberFormatException numberFormatException) {
                editor.pack();
            }
        } else {
            LevelSettingsEditor.editor.levels = levelArray;
            LevelSettingsEditor.editor.shop = shop;
            if (LevelSettingsEditor.editor.sound != sound) {
                LevelSettingsEditor.editor.sound.removeChangeListener(LevelSettingsEditor.editor.soundChangeListener);
            }
            LevelSettingsEditor.editor.sound = sound;
            LevelSettingsEditor.editor.sound.addChangeListener(LevelSettingsEditor.editor.soundChangeListener);
            editor.updateMusicNames();
            LevelSettingsEditor.editor.settingsSelection.setSelectedIndex(n);
        }
        if (ScreenUtilities.getScreen(editor) == null) {
            editor.setLocationRelativeTo(jFrame);
        }
        editor.setVisible(true);
    }

    public static void close() {
        LevelSettingsEditor.destroy();
    }

    public static void destroy() {
        if (editor != null) {
            editor.dispose();
        }
        editor = null;
    }

    public static void saveState(Properties properties) {
        if (editor != null) {
            properties.setProperty("Window" + editor.getClass().getSimpleName() + "Open", "" + editor.isVisible());
            properties.setProperty("Window" + editor.getClass().getSimpleName() + "X", "" + editor.getX());
            properties.setProperty("Window" + editor.getClass().getSimpleName() + "Y", "" + editor.getY());
            if (editor.isResizable()) {
                properties.setProperty("Window" + editor.getClass().getSimpleName() + "Width", "" + editor.getWidth());
                properties.setProperty("Window" + editor.getClass().getSimpleName() + "Height", "" + editor.getHeight());
            }
        }
    }

    private class DimensionSelector
    extends JDialog {
        private final JLabel widthLabel;
        private final JLabel heightLabel;
        private final JSlider sliderWidth;
        private final JSlider sliderHeight;
        private boolean result;

        public DimensionSelector(int n, int n2, final int n3, final int n4, final boolean bl) {
            super(LevelSettingsEditor.this, TextProvider.get("LevelDimensions"), true);
            this.widthLabel = new JLabel();
            this.heightLabel = new JLabel();
            if (n2 > n4) {
                n = Math.min(n3, n + n2 - n4);
                n2 = n4;
            }
            if (n > n3) {
                n2 = Math.min(n4, n2 + n - n3);
                n = n3;
            }
            this.sliderWidth = new JSlider(1, n3);
            this.sliderHeight = new JSlider(1, n4);
            this.sliderWidth.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    DimensionSelector.this.widthLabel.setText(Integer.toString(DimensionSelector.this.sliderWidth.getValue()));
                    if (bl && DimensionSelector.this.sliderWidth.getValue() + DimensionSelector.this.sliderHeight.getValue() != n3 + 1) {
                        DimensionSelector.this.sliderHeight.setValue(n3 + 1 - DimensionSelector.this.sliderWidth.getValue());
                    }
                }
            });
            this.sliderHeight.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    DimensionSelector.this.heightLabel.setText(Integer.toString(DimensionSelector.this.sliderHeight.getValue()));
                    if (bl && DimensionSelector.this.sliderHeight.getValue() + DimensionSelector.this.sliderWidth.getValue() != n4 + 1) {
                        DimensionSelector.this.sliderWidth.setValue(n4 + 1 - DimensionSelector.this.sliderHeight.getValue());
                    }
                }
            });
            JPanel jPanel = new JPanel(new GridLayout(2, 2, 4, 4));
            JPanel jPanel2 = new JPanel(new GridLayout(1, 2, 4, 4));
            this.sliderWidth.setValue(n);
            this.widthLabel.setText(Integer.toString(this.sliderWidth.getValue()));
            jPanel2.add(new JLabel(String.valueOf(TextProvider.get("Width")) + ":"));
            jPanel2.add(this.widthLabel);
            jPanel.add(jPanel2);
            jPanel.add(this.sliderWidth);
            JPanel jPanel3 = new JPanel(new GridLayout(1, 2, 4, 4));
            this.sliderHeight.setValue(n2);
            this.heightLabel.setText(Integer.toString(this.sliderHeight.getValue()));
            jPanel3.add(new JLabel(String.valueOf(TextProvider.get("Height")) + ":"));
            jPanel3.add(this.heightLabel);
            jPanel.add(jPanel3);
            jPanel.add(this.sliderHeight);
            this.add((Component)jPanel, "Center");
            JButton jButton = new JButton(TextProvider.get("ButtonOK"));
            JPanel jPanel4 = new JPanel(new FlowLayout());
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DimensionSelector.this.result = true;
                    DimensionSelector.this.dispose();
                }
            });
            JButton jButton2 = new JButton(TextProvider.get("ButtonCancel"));
            jButton2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DimensionSelector.this.result = false;
                    DimensionSelector.this.dispose();
                }
            });
            jPanel4.add(jButton);
            jPanel4.add(jButton2);
            this.add((Component)jPanel4, "South");
            this.setLocationRelativeTo(LevelSettingsEditor.this);
            this.pack();
            this.setVisible(true);
        }

        public boolean isOK() {
            return this.result;
        }

        public int getLayoutWidth() {
            return this.sliderWidth.getValue();
        }

        public int getLayoutHeight() {
            return this.sliderHeight.getValue();
        }
    }
}

