/*
 * Decompiled with CFR 0.152.
 */
package data;

import changes.Changable;
import changes.Change;
import changes.ChangeListener;
import data.AlexFrame;
import data.Sprite;
import data.Tileset;
import editors.TextProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import rom.RomManager;

public class SpriteContainer
implements Changable {
    private final int address;
    private final boolean singleSprite;
    private final HashMap<Integer, Sprite> sprites;
    private final LinkedList<ChangeListener> listeners = new LinkedList();
    private final ChangeListener spriteListener = new ChangeListener(){

        @Override
        public void changeOccurred(Change change) {
            SpriteContainer.this.fireChangeOccurred(change);
        }
    };

    public SpriteContainer(int n, HashMap<Integer, Sprite> hashMap) {
        int n2;
        this.address = n;
        this.sprites = hashMap;
        boolean bl = false;
        if ((RomManager.StaticAccess.readByte(n) & 0x80) != 0) {
            bl = true;
        }
        int n3 = 0;
        while (n3 < RomManager.StaticAccess.readByte(n) && !bl) {
            n2 = RomManager.StaticAccess.readWord(n + 1 + 2 * n3);
            if (n2 < 32768 || n2 >= 49152) {
                bl = true;
            }
            ++n3;
        }
        this.singleSprite = bl;
        if (RomManager.StaticAccess.readByte(n) > 0 && !bl) {
            n3 = 0;
            while (n3 < this.getSpriteCount()) {
                n2 = RomManager.StaticAccess.readWord(n + 1 + 2 * n3);
                Sprite sprite = hashMap.get(n2);
                if (sprite == null) {
                    sprite = new Sprite(n2);
                    hashMap.put(n2, sprite);
                }
                sprite.addChangeListener(this.spriteListener);
                ++n3;
            }
        } else if (RomManager.StaticAccess.readByte(n) > 0) {
            Sprite sprite = hashMap.get(n);
            if (sprite == null) {
                sprite = new Sprite(n);
                hashMap.put(n, sprite);
            }
            sprite.addChangeListener(this.spriteListener);
        }
    }

    public int getSpriteCount() {
        if (this.singleSprite) {
            return 1;
        }
        return RomManager.StaticAccess.readByte(this.address);
    }

    public Sprite[] getSprites() {
        if (this.singleSprite) {
            return new Sprite[]{this.sprites.get(this.address)};
        }
        Sprite[] spriteArray = new Sprite[this.getSpriteCount()];
        int n = 0;
        while (n < this.getSpriteCount()) {
            spriteArray[n] = this.sprites.get(RomManager.StaticAccess.readWord(this.address + 1 + 2 * n));
            ++n;
        }
        return spriteArray;
    }

    public boolean isAlexSprite() {
        Sprite[] spriteArray = this.getSprites();
        if (spriteArray.length <= 0) {
            return false;
        }
        return spriteArray[0].isAlexSprite();
    }

    public Tileset[] sortTilesets(Tileset[] tilesetArray) {
        Object object;
        final HashSet<Integer> hashSet = new HashSet<Integer>();
        Sprite[] spriteArray = this.getSprites();
        int n = spriteArray.length;
        int n2 = 0;
        while (n2 < n) {
            object = spriteArray[n2];
            int n3 = 0;
            while (n3 < ((Sprite)object).getSpriteCount()) {
                hashSet.add(((Sprite)object).getSpriteCharCode(n3));
                ++n3;
            }
            ++n2;
        }
        object = new ArrayList<Tileset>(Arrays.asList(tilesetArray));
        Collections.sort(object, new Comparator<Tileset>(){

            @Override
            public int compare(Tileset tileset, Tileset tileset2) {
                int n;
                int n2 = 0;
                Iterator iterator = hashSet.iterator();
                while (iterator.hasNext()) {
                    n = (Integer)iterator.next();
                    if (!tileset.contains(n)) continue;
                    ++n2;
                }
                n = 0;
                Iterator iterator2 = hashSet.iterator();
                while (iterator2.hasNext()) {
                    int n3 = (Integer)iterator2.next();
                    if (!tileset2.contains(n3)) continue;
                    ++n;
                }
                if (n2 < hashSet.size() && n < hashSet.size()) {
                    if (n2 == n) {
                        return Math.abs(tileset.getCount() - hashSet.size()) - Math.abs(tileset2.getCount() - hashSet.size());
                    }
                    return n - n2;
                }
                if (n2 < hashSet.size()) {
                    return Integer.MAX_VALUE;
                }
                if (n < hashSet.size()) {
                    return Integer.MIN_VALUE;
                }
                return Math.abs(tileset.getCount() - hashSet.size()) - Math.abs(tileset2.getCount() - hashSet.size());
            }
        });
        return ((ArrayList)object).toArray(new Tileset[((ArrayList)object).size()]);
    }

    public int[] getVRAM(int n, Tileset tileset) {
        Sprite[] spriteArray = this.getSprites();
        if (spriteArray[n].isAlexSprite()) {
            return new AlexFrame(16832, spriteArray[n].getAlexFrame()).getVRAM();
        }
        return tileset.getVRAM();
    }

    public int getHpos(int n) {
        return this.getSprites()[n].getHpos();
    }

    public int getVpos(int n) {
        return this.getSprites()[n].getVpos();
    }

    public int[] getSAT(int n) {
        return this.getSprites()[n].getSAT();
    }

    public int getHitboxX(int n) {
        return this.getSprites()[n].getHitboxX();
    }

    public int getHitboxY(int n) {
        return this.getSprites()[n].getHitboxY();
    }

    public int getHitboxWidth(int n) {
        return this.getSprites()[n].getHitboxWidth();
    }

    public int getHitboxHeight(int n) {
        return this.getSprites()[n].getHitboxHeight();
    }

    public int getWeaponHitboxX(int n) {
        return this.getSprites()[n].getWeaponHitboxX();
    }

    public int getWeaponHitboxY(int n) {
        return this.getSprites()[n].getWeaponHitboxY();
    }

    public int getWeaponHitboxWidth(int n) {
        return this.getSprites()[n].getWeaponHitboxWidth();
    }

    public int getWeaponHitboxHeight(int n) {
        return this.getSprites()[n].getWeaponHitboxHeight();
    }

    public int getLength() {
        if (this.singleSprite) {
            return this.getSprites()[0].getLength();
        }
        return 1 + this.getSpriteCount() * 2;
    }

    @Override
    public final String getChangeName() {
        return TextProvider.get("ChangeSprite");
    }

    @Override
    public final void fireChangeOccurred(Change change) {
        for (ChangeListener changeListener : this.listeners) {
            changeListener.changeOccurred(change);
        }
    }

    @Override
    public final void addChangeListener(ChangeListener changeListener) {
        if (!this.listeners.contains(changeListener)) {
            this.listeners.addFirst(changeListener);
        }
    }

    @Override
    public final void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    public String toString() {
        return "Sprite@" + Integer.toHexString(this.address).toUpperCase();
    }
}

