/*
 * Decompiled with CFR 0.152.
 */
package data;

import changes.Changable;
import changes.Change;
import changes.ChangeListener;
import editors.TextProvider;
import java.util.LinkedList;
import rom.RomManager;
import transactions.TransactionManager;

public class Palette
implements Changable {
    protected static final int SIZE_PALETTE = 32;
    private final int address;
    private final int bank;
    private final LinkedList<ChangeListener> listeners = new LinkedList();

    public Palette(int n, int n2) {
        this.address = n;
        this.bank = n2;
    }

    protected int getAddress() {
        return this.address;
    }

    protected int getBank() {
        return this.bank;
    }

    protected int getColorAddress(int n) {
        return RomManager.RESOLVE_ADDRESS(RomManager.StaticAccess.readWord(this.getAddress()) + n, this.getBank());
    }

    public void moveTo(int n, boolean bl) {
        TransactionManager.getInstance().addTransactionObject(this, -3);
        RomManager.StaticAccess.writeBytes(this.getColors(), n);
        if (bl) {
            RomManager.StaticAccess.fill(this.getColorAddress(0), this.getColorAddress(0) + this.getSize(), 255);
        }
        RomManager.StaticAccess.writeWord(this.getAddress(), 0x8000 | n & 0x3FFF);
    }

    public void setColor(int n, int n2) {
        if (RomManager.StaticAccess.readByte(this.getColorAddress(n)) != n2) {
            TransactionManager.getInstance().addTransactionObject(this, n);
            RomManager.StaticAccess.writeByte(this.getColorAddress(n), n2);
        }
    }

    public void setColors(int n, Integer[] integerArray) {
        TransactionManager.getInstance().addTransactionObject(this, -n - 1);
        int n2 = n * 16;
        if (n == 2) {
            n2 = 0;
        }
        int n3 = 0;
        while (n3 < integerArray.length) {
            RomManager.StaticAccess.writeByte(this.getColorAddress(n2 + n3), integerArray[n3]);
            ++n3;
        }
    }

    public int[] getColors() {
        int[] nArray = new int[this.getSize()];
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = RomManager.StaticAccess.readByte(this.getColorAddress(n));
            ++n;
        }
        return nArray;
    }

    public int getSize() {
        return 32;
    }

    @Override
    public final String getChangeName() {
        return TextProvider.get("ChangePalette");
    }

    @Override
    public final void fireChangeOccurred(Change change) {
        for (ChangeListener changeListener : this.listeners) {
            changeListener.changeOccurred(change);
        }
    }

    @Override
    public final void addChangeListener(ChangeListener changeListener) {
        if (!this.listeners.contains(changeListener)) {
            this.listeners.addFirst(changeListener);
        }
    }

    @Override
    public final void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    public String toString() {
        return "Palette@" + Integer.toHexString(this.getColorAddress(0)).toUpperCase() + "-" + Integer.toHexString(this.getColorAddress(this.getSize() - 1)).toUpperCase();
    }
}

