/*
 * Decompiled with CFR 0.152.
 */
package data;

import data.Tiles;
import mastersystem.OutputListener;
import mastersystem.TMS9918A;
import rom.RomManager;
import transactions.TransactionManager;

public class CompressedTiles
extends Tiles {
    private final TileDecompressor decompressor;
    protected int length;

    public CompressedTiles(int n, int n2, int n3, int n4, boolean bl, TileDecompressor tileDecompressor) {
        super(n, n2, n3, 0, 0, n4, bl);
        this.source = n2;
        this.decompressor = tileDecompressor;
    }

    public CompressedTiles(int n, int n2, int n3, boolean bl, TileDecompressor tileDecompressor) {
        super(n, n2, n3, 0, bl);
        this.source = n2;
        this.decompressor = tileDecompressor;
    }

    protected int[] getAddresses(int[][] nArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < nArray.length) {
            int n3 = 0;
            while (n3 < nArray[n2].length) {
                if (nArray[n2][n3] >= 0) {
                    ++n;
                }
                ++n3;
            }
            ++n2;
        }
        n2 = this.calcPlaneLength();
        int[] nArray2 = new int[n * 8 * this.bpp];
        int n4 = 0;
        while (n4 < nArray.length) {
            int n5 = 0;
            while (n5 < nArray[n4].length) {
                if (nArray[n4][n5] >= 0) {
                    int n6 = 0;
                    while (n6 < this.bpp) {
                        int n7 = 0;
                        while (n7 < 8) {
                            int n8 = this.source + nArray[n4][n5] * 8 + n7 + 1;
                            nArray2[(n4 * nArray[n4].length + n5) * 8 * this.bpp + n6 * 8 + n7] = (n8 += (nArray[n4][n5] * 8 + n7) / 127) + n6 * n2;
                            ++n7;
                        }
                        ++n6;
                    }
                }
                ++n5;
            }
            ++n4;
        }
        return nArray2;
    }

    private int[] getAddresses(int n) {
        return this.getAddresses(new int[][]{{n}});
    }

    @Override
    public void moveLeft(int n) {
        this.decompress();
        if (this.isCompressed()) {
            return;
        }
        int[] nArray = this.getAddresses(n);
        TransactionManager.getInstance().addTransactionObject(this, n);
        int n2 = 0;
        while (n2 < this.bpp) {
            int n3 = 0;
            while (n3 < 8) {
                this.writeByte(nArray[n2 * 8 + n3], RomManager.StaticAccess.readByte(nArray[n2 * 8 + n3]) << 1 & 0xFF);
                ++n3;
            }
            ++n2;
        }
    }

    @Override
    public void moveLeft(int[][] nArray) {
        this.decompress();
        if (this.isCompressed()) {
            return;
        }
        int[] nArray2 = this.getAddresses(nArray);
        TransactionManager.getInstance().addTransactionObject(this, nArray[0][0]);
        int n = 0;
        while (n < nArray.length) {
            int n2 = 0;
            while (n2 < nArray[n].length) {
                if (nArray[n][n2] >= 0) {
                    int n3 = 0;
                    while (n3 < this.bpp) {
                        int n4 = 0;
                        while (n4 < 8) {
                            int n5 = nArray2[(n * nArray[n].length + n2) * 8 * this.bpp + n3 * 8 + n4];
                            int n6 = 0;
                            if (n2 < nArray[n].length - 1 && nArray[n][n2 + 1] >= 0) {
                                n6 = nArray2[(n * nArray[n].length + n2 + 1) * 8 * this.bpp + n3 * 8 + n4];
                            }
                            this.writeByte(n5, RomManager.StaticAccess.readByte(n5) << 1 & 0xFF);
                            if (n6 > 0) {
                                RomManager.StaticAccess.orByteWith(n5, RomManager.StaticAccess.readByte(n6) >> 7);
                            }
                            ++n4;
                        }
                        ++n3;
                    }
                }
                ++n2;
            }
            ++n;
        }
    }

    @Override
    public void moveUp(int n) {
        this.decompress();
        if (this.isCompressed()) {
            return;
        }
        int[] nArray = this.getAddresses(n);
        TransactionManager.getInstance().addTransactionObject(this, n);
        int n2 = 0;
        while (n2 < this.bpp) {
            int n3 = 0;
            while (n3 < 8) {
                this.writeByte(nArray[n2 * 8 + n3], n3 == 7 ? 0 : RomManager.StaticAccess.readByte(nArray[n2 * 8 + n3 + 1]));
                ++n3;
            }
            ++n2;
        }
    }

    @Override
    public void moveUp(int[][] nArray) {
        this.decompress();
        if (this.isCompressed()) {
            return;
        }
        int[] nArray2 = this.getAddresses(nArray);
        TransactionManager.getInstance().addTransactionObject(this, nArray[0][0]);
        int n = 0;
        while (n < nArray.length) {
            int n2 = 0;
            while (n2 < nArray[n].length) {
                if (nArray[n][n2] >= 0) {
                    int n3 = 0;
                    while (n3 < this.bpp) {
                        int n4 = 0;
                        while (n4 < 8) {
                            int n5 = nArray2[(n * nArray[n].length + n2) * 8 * this.bpp + n3 * 8 + n4];
                            int n6 = 0;
                            if (n4 == 7) {
                                if (n < nArray.length - 1 && nArray[n + 1][n2] >= 0) {
                                    n6 = nArray2[((n + 1) * nArray[n].length + n2) * 8 * this.bpp + n3 * 8];
                                }
                            } else {
                                n6 = nArray2[(n * nArray[n].length + n2) * 8 * this.bpp + n3 * 8 + n4 + 1];
                            }
                            this.writeByte(n5, n6 > 0 ? RomManager.StaticAccess.readByte(n6) : 0);
                            ++n4;
                        }
                        ++n3;
                    }
                }
                ++n2;
            }
            ++n;
        }
    }

    @Override
    public void moveRight(int n) {
        this.decompress();
        if (this.isCompressed()) {
            return;
        }
        int[] nArray = this.getAddresses(n);
        TransactionManager.getInstance().addTransactionObject(this, n);
        int n2 = 0;
        while (n2 < this.bpp) {
            int n3 = 0;
            while (n3 < 8) {
                RomManager.StaticAccess.shiftByteRight(nArray[n2 * 8 + n3], 1);
                ++n3;
            }
            ++n2;
        }
    }

    @Override
    public void moveRight(int[][] nArray) {
        this.decompress();
        if (this.isCompressed()) {
            return;
        }
        int[] nArray2 = this.getAddresses(nArray);
        TransactionManager.getInstance().addTransactionObject(this, nArray[0][0]);
        int n = 0;
        while (n < nArray.length) {
            int n2 = nArray[n].length - 1;
            while (n2 >= 0) {
                if (nArray[n][n2] >= 0) {
                    int n3 = 0;
                    while (n3 < this.bpp) {
                        int n4 = 0;
                        while (n4 < 8) {
                            int n5 = nArray2[(n * nArray[n].length + n2) * 8 * this.bpp + n3 * 8 + n4];
                            int n6 = 0;
                            if (n2 > 0) {
                                n6 = nArray2[(n * nArray[n].length + n2 - 1) * 8 * this.bpp + n3 * 8 + n4];
                            }
                            RomManager.StaticAccess.shiftByteRight(n5, 1);
                            if (n6 > 0) {
                                RomManager.StaticAccess.orByteWith(n5, (RomManager.StaticAccess.readByte(n6) & 1) << 7);
                            }
                            ++n4;
                        }
                        ++n3;
                    }
                }
                --n2;
            }
            ++n;
        }
    }

    @Override
    public void moveDown(int n) {
        this.decompress();
        if (this.isCompressed()) {
            return;
        }
        int[] nArray = this.getAddresses(n);
        TransactionManager.getInstance().addTransactionObject(this, n);
        int n2 = 0;
        while (n2 < this.bpp) {
            int n3 = 7;
            while (n3 >= 0) {
                this.writeByte(nArray[n2 * 8 + n3], n3 == 0 ? 0 : RomManager.StaticAccess.readByte(nArray[n2 * 8 + n3 - 1]));
                --n3;
            }
            ++n2;
        }
    }

    @Override
    public void moveDown(int[][] nArray) {
        this.decompress();
        if (this.isCompressed()) {
            return;
        }
        int[] nArray2 = this.getAddresses(nArray);
        TransactionManager.getInstance().addTransactionObject(this, nArray[0][0]);
        int n = nArray.length - 1;
        while (n >= 0) {
            int n2 = 0;
            while (n2 < nArray[n].length) {
                if (nArray[n][n2] >= 0) {
                    int n3 = 0;
                    while (n3 < this.bpp) {
                        int n4 = 7;
                        while (n4 >= 0) {
                            int n5 = nArray2[(n * nArray[n].length + n2) * 8 * this.bpp + n3 * 8 + n4];
                            int n6 = 0;
                            if (n4 == 0) {
                                if (n > 0) {
                                    n6 = nArray2[((n - 1) * nArray[n].length + n2) * 8 * this.bpp + n3 * 8 + 7];
                                }
                            } else {
                                n6 = nArray2[(n * nArray[n].length + n2) * 8 * this.bpp + n3 * 8 + n4 - 1];
                            }
                            this.writeByte(n5, n6 > 0 ? RomManager.StaticAccess.readByte(n6) : 0);
                            --n4;
                        }
                        ++n3;
                    }
                }
                ++n2;
            }
            --n;
        }
    }

    @Override
    public void flipH(int n) {
        this.decompress();
        if (this.isCompressed()) {
            return;
        }
        int[] nArray = this.getAddresses(n);
        TransactionManager.getInstance().addTransactionObject(this, n);
        int n2 = 0;
        while (n2 < this.bpp) {
            int n3 = 0;
            while (n3 < 8) {
                this.writeByte(nArray[n2 * 8 + n3], MIRRORED_BITS[RomManager.StaticAccess.readByte(nArray[n2 * 8 + n3])]);
                ++n3;
            }
            ++n2;
        }
    }

    @Override
    public void flipH(int[][] nArray) {
        this.decompress();
        if (this.isCompressed()) {
            return;
        }
        int[] nArray2 = this.getAddresses(nArray);
        TransactionManager.getInstance().addTransactionObject(this, nArray[0][0]);
        int n = 0;
        while (n < nArray.length) {
            int n2 = 0;
            while (n2 < (nArray[n].length + 1) / 2) {
                if (nArray[n][n2] >= 0) {
                    int n3 = 0;
                    while (n3 < this.bpp) {
                        int n4 = 0;
                        while (n4 < 8) {
                            int n5;
                            int n6 = n5 = nArray2[(n * nArray[n].length + n2) * 8 * this.bpp + n3 * 8 + n4];
                            if (nArray[n][nArray[n].length - 1 - n2] >= 0) {
                                n6 = nArray2[(n * nArray[n].length + nArray[n].length - 1 - n2) * 8 * this.bpp + n3 * 8 + n4];
                            }
                            int n7 = MIRRORED_BITS[RomManager.StaticAccess.readByte(n5)];
                            this.writeByte(n5, MIRRORED_BITS[RomManager.StaticAccess.readByte(n6)]);
                            this.writeByte(n6, n7);
                            ++n4;
                        }
                        ++n3;
                    }
                }
                ++n2;
            }
            ++n;
        }
    }

    @Override
    public void flipV(int n) {
        this.decompress();
        if (this.isCompressed()) {
            return;
        }
        int[] nArray = this.getAddresses(n);
        TransactionManager.getInstance().addTransactionObject(this, n);
        int n2 = 0;
        while (n2 < this.bpp) {
            int n3 = 0;
            while (n3 < 4) {
                int n4 = RomManager.StaticAccess.readByte(nArray[n2 * 8 + n3]);
                this.writeByte(nArray[n2 * 8 + n3], RomManager.StaticAccess.readByte(nArray[n2 * 8 + (n3 ^ 7)]));
                this.writeByte(nArray[n2 * 8 + (n3 ^ 7)], n4);
                ++n3;
            }
            ++n2;
        }
    }

    @Override
    public void flipV(int[][] nArray) {
        this.decompress();
        if (this.isCompressed()) {
            return;
        }
        int[] nArray2 = this.getAddresses(nArray);
        TransactionManager.getInstance().addTransactionObject(this, nArray[0][0]);
        int n = 0;
        while (n < (nArray.length + 1) / 2) {
            int n2 = 0;
            while (n2 < nArray[n].length) {
                if (nArray[n][n2] >= 0) {
                    int n3 = 0;
                    while (n3 < this.bpp) {
                        int n4 = 0;
                        while (n4 < 8) {
                            int n5 = nArray2[(n * nArray[n].length + n2) * 8 * this.bpp + n3 * 8 + n4];
                            int n6 = nArray2[(n * nArray[n].length + n2) * 8 * this.bpp + n3 * 8 + (n4 ^ 7)];
                            if (nArray[nArray.length - 1 - n][n2] >= 0) {
                                n6 = nArray2[((nArray.length - 1 - n) * nArray[n].length + n2) * 8 * this.bpp + n3 * 8 + (n4 ^ 7)];
                            }
                            if (n5 > n6) break;
                            int n7 = RomManager.StaticAccess.readByte(n5);
                            this.writeByte(n5, RomManager.StaticAccess.readByte(n6));
                            this.writeByte(n6, n7);
                            ++n4;
                        }
                        ++n3;
                    }
                }
                ++n2;
            }
            ++n;
        }
    }

    @Override
    public void setPixel(int n, int n2, int n3) {
        this.decompress();
        if (this.isCompressed()) {
            return;
        }
        int n4 = n2 / 8;
        int[] nArray = this.getAddresses(n);
        int n5 = 7 - n2 % 8;
        int n6 = ~(1 << n5);
        boolean bl = false;
        int n7 = 0;
        while (n7 < this.bpp && !bl) {
            if (RomManager.StaticAccess.readByte(nArray[n7 * 8 + n4]) != (RomManager.StaticAccess.readByte(nArray[n7 * 8 + n4]) & n6 | (n3 >> n7 & 1) << n5)) {
                bl = true;
            }
            ++n7;
        }
        if (bl) {
            TransactionManager.getInstance().addTransactionObject(this, n);
            n7 = 0;
            while (n7 < this.bpp) {
                this.writeByte(nArray[n7 * 8 + n4], RomManager.StaticAccess.readByte(nArray[n7 * 8 + n4]) & n6 | (n3 >> n7 & 1) << n5);
                ++n7;
            }
        }
    }

    @Override
    public void setPixels(int[][] nArray) {
        int n;
        int n2;
        int n3;
        int n4;
        this.decompress();
        if (this.isCompressed()) {
            return;
        }
        int n5 = 8 * this.bpp;
        int n6 = this.getLength() * this.bpp / 4;
        int n7 = this.calcPlaneLength();
        int[] nArray2 = new int[nArray.length * nArray[0].length / 8 * this.bpp];
        int n8 = 0;
        while (n8 < nArray.length) {
            n4 = 0;
            while (n4 < nArray[n8].length) {
                n3 = n8 / 8 * nArray[n8].length / 8 + n4 / 8;
                if (n3 >= n6 / n5) break;
                n2 = this.source + n3 * 8 + n8 % 8 + 1;
                n2 += (n3 * 8 + n8 % 8) / 127;
                n = 0;
                while (n < this.bpp) {
                    nArray2[n3 * n5 + n8 % 8 * this.bpp + n] = n2 + n * n7;
                    ++n;
                }
                n4 += 8;
            }
            ++n8;
        }
        TransactionManager.getInstance().addTransactionObject(this, -1);
        n8 = 0;
        while (n8 < nArray.length) {
            n4 = 0;
            while (n4 < nArray[n8].length) {
                n3 = n8 / 8 * nArray[n8].length / 8 + n4 / 8;
                if (n3 >= n6 / n5) break;
                n2 = 7 - (n4 & 7);
                n = ~(1 << n2);
                int n9 = 0;
                while (n9 < this.bpp) {
                    this.writeByte(nArray2[n3 * n5 + n8 % 8 * this.bpp + n9], RomManager.StaticAccess.readByte(nArray2[n3 * n5 + n8 % 8 * this.bpp + n9]) & n | (nArray[n8][n4] >> n9 & 1) << n2);
                    ++n9;
                }
                ++n4;
            }
            ++n8;
        }
    }

    @Override
    public void setPixels(int n, int[][] nArray) {
        this.decompress();
        if (this.isCompressed()) {
            return;
        }
        TransactionManager.getInstance().addTransactionObject(this, n);
        int[] nArray2 = this.getAddresses(n);
        int n2 = Math.min(8, nArray.length);
        int n3 = 0;
        while (n3 < n2) {
            int n4 = Math.min(8, nArray[n3].length);
            int n5 = 0;
            while (n5 < n4) {
                int n6 = 7 - n5;
                int n7 = ~(1 << n6);
                int n8 = 0;
                while (n8 < this.bpp) {
                    this.writeByte(nArray2[n8 * nArray.length + n3], RomManager.StaticAccess.readByte(nArray2[n8 * nArray.length + n3]) & n7 | (nArray[n3][n5] >> n8 & 1) << n6);
                    ++n8;
                }
                ++n5;
            }
            ++n3;
        }
    }

    @Override
    public void setPixels(int[][] nArray, int[][][][] nArray2) {
        this.decompress();
        if (this.isCompressed()) {
            return;
        }
        int[] nArray3 = this.getAddresses(nArray);
        TransactionManager.getInstance().addTransactionObject(this, nArray[0][0]);
        int n = 0;
        while (n < nArray.length) {
            int n2 = 0;
            while (n2 < nArray[n].length) {
                if (nArray[n][n2] >= 0 && nArray2[n][n2] != null) {
                    int n3 = Math.min(8, nArray2[n][n2].length);
                    int n4 = 0;
                    while (n4 < n3) {
                        int n5 = Math.min(8, nArray2[n][n2][n4].length);
                        int n6 = 0;
                        while (n6 < n5) {
                            int n7 = 7 - n6;
                            int n8 = ~(1 << n7);
                            int n9 = 0;
                            while (n9 < this.bpp) {
                                this.writeByte(nArray3[(n * nArray[n].length + n2) * 8 * this.bpp + n9 * nArray2[n][n2].length + n4], RomManager.StaticAccess.readByte(nArray3[(n * nArray[n].length + n2) * 8 * this.bpp + n9 * nArray2[n][n2].length + n4]) & n8 | (nArray2[n][n2][n4][n6] >> n9 & 1) << n7);
                                ++n9;
                            }
                            ++n6;
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
            ++n;
        }
    }

    @Override
    public CompressedTiles toCompressedTiles(int n) {
        return this;
    }

    @Override
    public int[] getVRAM() {
        TMS9918A tMS9918A = new TMS9918A(262);
        final int[] nArray = new int[]{this.getDestination()};
        tMS9918A.addOutputListener(new OutputListener(){

            @Override
            public void outputAvailable(int n, int n2, int n3) {
                if (n == 3) {
                    if ((n2 & 0x3FE0) + 32 > nArray[0]) {
                        nArray[0] = (n2 & 0x3FE0) + 32;
                    }
                } else if (n == 2) {
                    throw new IllegalStateException("Tiles must not write to cram.");
                }
            }
        });
        int[] nArray2 = this.getVRAM(tMS9918A);
        this.length = nArray[0] - this.getDestination();
        return nArray2;
    }

    @Override
    public int getSource() {
        return this.source;
    }

    private void decompress() {
        if (this.decompressor != null && this.isCompressed()) {
            this.decompressor.decompress(this);
            this.end = 0;
        }
    }

    @Override
    public boolean isCompressed() {
        int n = this.source;
        int n2 = 0;
        while (n2 < this.getLength() && (RomManager.StaticAccess.readByte(n) & 0x80) != 0) {
            int n3 = RomManager.StaticAccess.readByte(n) & 0x7F;
            n2 += n3 * 4;
            n += n3 + 1;
        }
        return n2 != this.getLength();
    }

    @Override
    public boolean isValid() {
        int n;
        int n2 = this.source;
        int n3 = 0;
        while (RomManager.StaticAccess.readByte(n2) > 0) {
            n = RomManager.StaticAccess.readByte(n2) & 0x7F;
            n3 += n;
            n2 = (RomManager.StaticAccess.readByte(n2) & 0x80) != 0 ? (n2 += n) : ++n2;
            if ((++n2 & 0xFFFFC000) == (this.source & 0xFFFFC000)) continue;
            return false;
        }
        n = 1;
        while (n < this.bpp) {
            ++n2;
            int n4 = n3;
            n3 = 0;
            while (n3 <= n4 && n2 < RomManager.StaticAccess.getRomLength() && RomManager.StaticAccess.readByte(n2) > 0) {
                int n5 = RomManager.StaticAccess.readByte(n2) & 0x7F;
                n3 += n5;
                n2 = (RomManager.StaticAccess.readByte(n2) & 0x80) != 0 ? (n2 += n5) : ++n2;
                if ((++n2 & 0xFFFFC000) == (this.source & 0xFFFFC000)) continue;
                return false;
            }
            if (n3 != n4) {
                return false;
            }
            ++n;
        }
        return n3 > 0 && n3 <= 16384;
    }

    public void setSource(int n) {
        this.source = n;
        this.end = 0;
        this.length = 0;
    }

    @Override
    public void moveTo(int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean rewrite(int n, int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("The length of tiles must be positive.");
        }
        int n3 = this.getSource();
        int n4 = this.getSize();
        if (n2 == this.getLength()) {
            if (n == n3) {
                return false;
            }
            TransactionManager.getInstance().addTransactionObject(this, -1);
            int[] nArray = RomManager.StaticAccess.readBytes(new int[n4], n3);
            RomManager.StaticAccess.fill(n3, n3 + n4, 255);
            int n5 = 0;
            while (n5 < n4) {
                if (RomManager.StaticAccess.readByte(n + n5) != 255) {
                    throw new RuntimeException("rewrite: " + Integer.toHexString(n + n5) + " isn't free: " + Integer.toHexString(RomManager.StaticAccess.readByte(n + n5)) + " expected: ff");
                }
                ++n5;
            }
            RomManager.StaticAccess.writeBytes(nArray, n);
            this.source = n;
            this.end = n + n4;
        } else {
            int n6;
            TransactionManager.getInstance().addTransactionObject(this, -1);
            int[] nArray = this.getVRAM();
            int n7 = n;
            RomManager.StaticAccess.fill(n3, n3 + n4, 255);
            int n8 = 0;
            while (n8 < n4) {
                if (RomManager.StaticAccess.readByte(n + n8) != 255) {
                    throw new RuntimeException("rewrite: " + Integer.toHexString(n + n8) + " isn't free: " + Integer.toHexString(RomManager.StaticAccess.readByte(n + n8)) + " expected: ff");
                }
                ++n8;
            }
            n8 = 0;
            while (n8 < this.getBPP()) {
                n6 = 0;
                int n9 = n8;
                while (n9 < n2) {
                    if (n6 % 127 == 0) {
                        RomManager.getInstance().writeByte(n7++, 0x80 | Math.min(127, n2 / 4 - n6));
                    }
                    RomManager.getInstance().writeByte(n7++, nArray[this.getDestination() + n9]);
                    ++n6;
                    n9 += 4;
                }
                RomManager.getInstance().writeByte(n7++, 0);
                ++n8;
            }
            n8 = this.getBPP();
            while (n8 < 4) {
                n6 = 0;
                while (n6 < n2) {
                    RomManager.getInstance().writeByte(n7++, Math.min(127, (n2 - n6) / 4));
                    RomManager.getInstance().writeByte(n7++, 0);
                    n6 += 508;
                }
                RomManager.getInstance().writeByte(n7++, 0);
                ++n8;
            }
            if ((n7 - 1 & 0x3FFF) < (n & 0x3FFF)) {
                throw new IllegalArgumentException("Tiles exceeded bank boundaries.");
            }
            this.setSource(n);
        }
        return true;
    }

    @Override
    public int getLength() {
        if (this.length <= 0) {
            this.getVRAM();
        }
        return this.length;
    }

    public int calcDecompressedSize() {
        return 4 * this.calcPlaneLength();
    }

    private int calcPlaneLength() {
        return this.getLength() / 4 + ((this.getLength() - 1) / 4 / 127 + 1 + 1);
    }

    @Override
    public String toString() {
        return "#" + super.toString();
    }

    public static interface TileDecompressor {
        public void decompress(CompressedTiles var1);
    }
}

