/*
 * Decompiled with CFR 0.152.
 */
package widgets;

import changes.Change;
import changes.ChangeListener;
import data.Palette;
import data.Tiles;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import mastersystem.Renderer;
import panels.Scalable;
import panels.ScaleListener;
import transactions.TransactionObject;

public class TilesComboBox
extends JComboBox<ImageIcon>
implements Scalable {
    private BufferedImage[] images;
    private BufferedImage[] scaledImages;
    private final BitSet dirty = new BitSet();
    private List<Tiles> tiles;
    private Palette palette;
    private final Color[] colors = new Color[32];
    private float scale = 1.0f;
    private float prevPreferredScale;
    private float prevPrevPreferredScale;
    private Scalable scaleParent = this;
    private final ChangeListener paletteChangeListener = new ChangeListener(){

        @Override
        public void changeOccurred(Change change) {
            int n = change.getData(TilesComboBox.this.palette);
            if (n < 0) {
                int n2 = -n - 1;
                int n3 = n2 * 16;
                int n4 = n3 + 16;
                if (n2 == 2) {
                    n3 = 0;
                    n4 = 32;
                }
                int n5 = n3;
                while (n5 < n4) {
                    int n6 = TilesComboBox.this.palette.getColors()[n5];
                    int n7 = (n6 & 0x30) >> 4;
                    int n8 = (n6 & 0xC) >> 2;
                    int n9 = n6 & 3;
                    ((TilesComboBox)TilesComboBox.this).colors[n5] = new Color(n9 * 255 / 3, n8 * 255 / 3, n7 * 255 / 3);
                    ++n5;
                }
            } else {
                int n10 = TilesComboBox.this.palette.getColors()[n];
                int n11 = (n10 & 0x30) >> 4;
                int n12 = (n10 & 0xC) >> 2;
                int n13 = n10 & 3;
                ((TilesComboBox)TilesComboBox.this).colors[n] = new Color(n13 * 255 / 3, n12 * 255 / 3, n11 * 255 / 3);
            }
            TilesComboBox.this.update();
        }
    };
    private final ChangeListener tilesChangeListener = new ChangeListener(){

        @Override
        public void changeOccurred(Change change) {
            for (TransactionObject transactionObject : change.getTransactionObjects()) {
                if (!(transactionObject.getObject() instanceof Tiles)) continue;
                TilesComboBox.this.setDirty((Tiles)transactionObject.getObject());
            }
        }
    };

    public TilesComboBox(List<Tiles> list, Palette palette) {
        this.setTiles(list, palette);
        this.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                TilesComboBox.this.updateDirty();
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }
        });
    }

    public TilesComboBox(Tiles[] tilesArray, Palette palette) {
        this(Arrays.asList(tilesArray), palette);
    }

    public void setSelectedTiles(int n) {
        int n2 = 0;
        while (n2 < this.tiles.size()) {
            if (n == (0x8000 | this.tiles.get(n2).getSource() & 0x3FFF)) {
                this.setSelectedIndex(n2);
                return;
            }
            ++n2;
        }
        System.err.println("TilesComboBox couldn't find tiles at " + Integer.toHexString(n));
    }

    @Override
    public void setSelectedIndex(int n) {
        if (n < 0) {
            n = 0;
        }
        super.setSelectedIndex(n);
        if (this.dirty.get(n)) {
            this.renderTiles(n);
        }
    }

    @Override
    public int getSelectedIndex() {
        return Math.max(0, super.getSelectedIndex());
    }

    public Tiles getSelectedTiles() {
        return this.tiles.get(this.getSelectedIndex());
    }

    public void setTiles(Tiles[] tilesArray, Palette palette) {
        this.setTiles(Arrays.asList(tilesArray), palette);
    }

    public void setTiles(List<Tiles> list, Palette palette) {
        if (this.tiles != null) {
            for (Tiles tiles : this.tiles) {
                tiles.removeChangeListener(this.tilesChangeListener);
            }
        }
        if (this.palette != null && this.palette != palette) {
            this.palette.removeChangeListener(this.paletteChangeListener);
        }
        this.tiles = list;
        this.palette = palette;
        int n = 0;
        int[] nArray = palette.getColors();
        int n2 = nArray.length;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = nArray[n3];
            int n5 = (n4 & 0x30) >> 4;
            int n6 = (n4 & 0xC) >> 2;
            int n7 = n4 & 3;
            this.colors[n++] = new Color(n7 * 255 / 3, n6 * 255 / 3, n5 * 255 / 3);
            ++n3;
        }
        for (Tiles tiles : list) {
            tiles.addChangeListener(this.tilesChangeListener);
        }
        palette.addChangeListener(this.paletteChangeListener);
        this.updateImages();
    }

    private void updateImages() {
        int n;
        this.images = new BufferedImage[this.tiles.size()];
        this.scaledImages = new BufferedImage[this.images.length];
        int n2 = 0;
        while (n2 < this.images.length) {
            n = this.tiles.get(n2).getLength();
            this.images[n2] = new BufferedImage(Math.min(256, n / 32 * 8), ((n / 32 - 1) / 32 + 1) * 8, 2);
            this.scaledImages[n2] = new BufferedImage((int)((float)this.images[n2].getWidth() * this.scale), (int)((float)this.images[n2].getHeight() * this.scale), this.images[n2].getType());
            ++n2;
        }
        ImageIcon[] imageIconArray = new ImageIcon[this.scaledImages.length];
        n = 0;
        while (n < this.scaledImages.length) {
            imageIconArray[n] = new ImageIcon(this.scaledImages[n]);
            ++n;
        }
        if (this.getItemCount() > 0) {
            ActionListener actionListener;
            ActionListener[] actionListenerArray;
            n = this.getSelectedIndex();
            ActionListener[] actionListenerArray2 = actionListenerArray = this.getActionListeners();
            int n3 = actionListenerArray.length;
            int n4 = 0;
            while (n4 < n3) {
                actionListener = actionListenerArray2[n4];
                this.removeActionListener(actionListener);
                ++n4;
            }
            this.setModel(new JComboBox<ImageIcon>(imageIconArray).getModel());
            try {
                this.setSelectedIndex(n);
            }
            catch (Exception exception) {}
            actionListenerArray2 = actionListenerArray;
            n3 = actionListenerArray.length;
            n4 = 0;
            while (n4 < n3) {
                actionListener = actionListenerArray2[n4];
                this.addActionListener(actionListener);
                ++n4;
            }
        } else {
            this.setModel(new JComboBox<ImageIcon>(imageIconArray).getModel());
        }
        this.update();
    }

    private void setDirty(Tiles tiles) {
        int n = 0;
        while (n < this.tiles.size()) {
            if (this.tiles.get(n) == tiles) {
                if (n == this.getSelectedIndex()) {
                    this.renderTiles(n);
                    this.revalidate();
                    this.repaint();
                } else {
                    this.dirty.set(n);
                }
                return;
            }
            ++n;
        }
    }

    private void updateDirty() {
        int n = this.dirty.nextSetBit(0);
        while (n >= 0) {
            this.renderTiles(n);
            this.dirty.clear(n);
            n = this.dirty.nextSetBit(n + 1);
        }
        this.revalidate();
        this.repaint();
    }

    private void renderTiles(int n) {
        if (n >= this.tiles.size()) {
            return;
        }
        this.clearImage(n);
        int[] nArray = this.tiles.get(n).getVRAM();
        Graphics2D graphics2D = this.images[n].createGraphics();
        int n2 = 0;
        while (n2 < this.tiles.get(n).getLength() / 32) {
            Renderer.renderCharacter(nArray, this.tiles.get(n).getDestination() / 32 + n2, n2 % 32 * 8, n2 / 32 * 8, this.colors, graphics2D);
            ++n2;
        }
        graphics2D.dispose();
        Graphics2D graphics2D2 = this.scaledImages[n].createGraphics();
        graphics2D2.drawImage(this.images[n], 0, 0, this.scaledImages[n].getWidth(), this.scaledImages[n].getHeight(), null);
        graphics2D2.dispose();
    }

    private void clearImage(int n) {
        TilesComboBox.clearImage(this.images[n]);
        TilesComboBox.clearImage(this.scaledImages[n]);
    }

    private static void clearImage(BufferedImage bufferedImage) {
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setComposite(AlphaComposite.Clear);
        graphics2D.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        graphics2D.dispose();
    }

    private void update() {
        int n = 0;
        while (n < this.tiles.size()) {
            this.setDirty(this.tiles.get(n));
            ++n;
        }
    }

    @Override
    public void setScaleParent(Scalable scalable) {
        if (scalable == null) {
            throw new IllegalArgumentException("ScaleParent must not be null.");
        }
        if (scalable != this.scaleParent && this.scaleParent != null) {
            this.scaleParent.removeScaleListener(this);
        }
        this.scaleParent = scalable;
        this.prevPreferredScale = 0.0f;
        this.prevPrevPreferredScale = 0.0f;
        scalable.addScaleListener(this);
    }

    @Override
    public float getScale() {
        return this.scale;
    }

    @Override
    public void setIntegerScaling(boolean bl) {
        throw new UnsupportedOperationException();
    }

    @Override
    public float getPreferredScale() {
        return this.scale;
    }

    @Override
    public boolean isIntegerScaling() {
        return false;
    }

    @Override
    public void setPreferredScale(float f) {
        float f2 = this.scale;
        if (f < this.prevPreferredScale || f != this.prevPrevPreferredScale) {
            this.scale = f;
        }
        this.prevPrevPreferredScale = this.prevPreferredScale;
        this.prevPreferredScale = f;
        if (Math.abs(this.scale - f2) > 0.01f) {
            this.updateImages();
        }
    }

    @Override
    public void addScaleListener(ScaleListener scaleListener) {
    }

    @Override
    public void removeScaleListener(ScaleListener scaleListener) {
    }
}

