/*
 * Decompiled with CFR 0.152.
 */
package panels;

import changes.Change;
import changes.ChangeListener;
import data.NameTable;
import data.Palette;
import data.Shop;
import data.Tiles;
import data.Tileset;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import mastersystem.Renderer;
import panels.ScalablePanel;
import transactions.TransactionManager;

public class ShopPanel
extends ScalablePanel {
    private final BufferedImage shopImage = new BufferedImage(256, 192, 1);
    private final Color[] colors = new Color[32];
    private Tileset tileset;
    private Shop shop;
    private Palette palette;
    private Tiles itemTiles;
    private NameTable nameTable;
    private Shop.ShopHandle shopHandle;
    private int[] vram;
    private int selectedItem = 0;
    private int offsetX;
    private int offsetY;
    private float scale = 1.0f;
    private final ChangeListener tilesetChangeListener = new ChangeListener(){

        @Override
        public void changeOccurred(Change change) {
            if (change.getData(ShopPanel.this.tileset) < 256) {
                ShopPanel.this.update();
            }
        }
    };
    private final ChangeListener paletteChangeListener = new ChangeListener(){

        @Override
        public void changeOccurred(Change change) {
            int n = change.getData(ShopPanel.this.palette);
            if (n < 0) {
                int n2 = -n - 1;
                int n3 = n2 * 16;
                int n4 = n3 + 16;
                if (n2 == 2) {
                    n3 = 0;
                    n4 = 32;
                }
                int n5 = n3;
                while (n5 < n4) {
                    int n6 = ShopPanel.this.palette.getColors()[n5];
                    int n7 = (n6 & 0x30) >> 4;
                    int n8 = (n6 & 0xC) >> 2;
                    int n9 = n6 & 3;
                    ((ShopPanel)ShopPanel.this).colors[n5] = new Color(n9 * 255 / 3, n8 * 255 / 3, n7 * 255 / 3);
                    ++n5;
                }
            } else {
                int n10 = ShopPanel.this.palette.getColors()[n];
                int n11 = (n10 & 0x30) >> 4;
                int n12 = (n10 & 0xC) >> 2;
                int n13 = n10 & 3;
                ((ShopPanel)ShopPanel.this).colors[n] = new Color(n13 * 255 / 3, n12 * 255 / 3, n11 * 255 / 3);
            }
            ShopPanel.this.update();
        }
    };
    private final ChangeListener nameTableChangeListener = new ChangeListener(){

        @Override
        public void changeOccurred(Change change) {
            ShopPanel.this.update();
        }
    };
    private final ChangeListener shopChangeListener = new ChangeListener(){

        @Override
        public void changeOccurred(Change change) {
            ShopPanel.this.selectedItem = change.getData(ShopPanel.this.shop);
            ShopPanel.this.update();
        }
    };
    private final ChangeListener tilesChangeListener = new ChangeListener(){

        @Override
        public void changeOccurred(Change change) {
            ShopPanel.this.update();
        }
    };

    public ShopPanel(Shop shop, Tileset tileset, Palette palette, NameTable nameTable, Tiles tiles) {
        final Cursor cursor = this.getCursor();
        final Cursor cursor2 = Cursor.getPredefinedCursor(12);
        this.setShop(shop, tileset, palette, nameTable, tiles);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                int n = 0;
                while (n < 3) {
                    int n2 = ShopPanel.this.shop.getItemX(n) * 8;
                    int n3 = ShopPanel.this.shop.getItemY(n) * 8;
                    if (ShopPanel.this.toScreenX(mouseEvent.getX()) >= n2 && ShopPanel.this.toScreenX(mouseEvent.getX()) < n2 + 24 && ShopPanel.this.toScreenY(mouseEvent.getY()) >= n3 && ShopPanel.this.toScreenY(mouseEvent.getY()) < n3 + 24) {
                        ShopPanel.this.selectedItem = n;
                        break;
                    }
                    ++n;
                }
                ShopPanel.this.repaint();
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                int n = 0;
                while (n < 3) {
                    int n2 = ShopPanel.this.shop.getItemX(n) * 8;
                    int n3 = ShopPanel.this.shop.getItemY(n) * 8;
                    if (ShopPanel.this.toScreenX(mouseEvent.getX()) >= n2 && ShopPanel.this.toScreenX(mouseEvent.getX()) < n2 + 24 && ShopPanel.this.toScreenY(mouseEvent.getY()) >= n3 && ShopPanel.this.toScreenY(mouseEvent.getY()) < n3 + 24) {
                        ShopPanel.this.setCursor(cursor2);
                        return;
                    }
                    ++n;
                }
                ShopPanel.this.setCursor(cursor);
            }
        });
    }

    public void setShop(int n) {
        this.shopHandle = this.shop.getShopHandles().get(n);
        this.update();
    }

    public void setShop(Shop shop, Tileset tileset, Palette palette, NameTable nameTable, Tiles tiles) {
        if (this.tileset != null && this.tileset != tileset) {
            this.tileset.removeChangeListener(this.tilesetChangeListener);
        }
        if (this.palette != null && this.palette != palette) {
            this.palette.removeChangeListener(this.paletteChangeListener);
        }
        if (this.nameTable != null && this.nameTable != nameTable) {
            this.nameTable.removeChangeListener(this.nameTableChangeListener);
        }
        if (this.shop != null && this.shop != shop) {
            this.shop.removeChangeListener(this.shopChangeListener);
        }
        if (this.itemTiles != null && this.itemTiles != tiles) {
            this.itemTiles.removeChangeListener(this.tilesChangeListener);
        }
        this.tileset = tileset;
        this.shop = shop;
        this.palette = palette;
        this.nameTable = nameTable;
        this.itemTiles = tiles;
        int n = 0;
        int[] nArray = palette.getColors();
        int n2 = nArray.length;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = nArray[n3];
            int n5 = (n4 & 0x30) >> 4;
            int n6 = (n4 & 0xC) >> 2;
            int n7 = n4 & 3;
            this.colors[n++] = new Color(n7 * 255 / 3, n6 * 255 / 3, n5 * 255 / 3);
            ++n3;
        }
        tileset.addChangeListener(this.tilesetChangeListener);
        palette.addChangeListener(this.paletteChangeListener);
        nameTable.addChangeListener(this.nameTableChangeListener);
        shop.addChangeListener(this.shopChangeListener);
        tiles.addChangeListener(this.tilesChangeListener);
        this.setShop(0);
    }

    public void selectNextItem() {
        if (this.selectedItem < 2) {
            ++this.selectedItem;
            this.repaint();
        }
    }

    public void selectPrevItem() {
        if (this.selectedItem > 0) {
            --this.selectedItem;
            this.repaint();
        }
    }

    public void nextItem() {
        TransactionManager.getInstance().runTransaction(new Runnable(){

            @Override
            public void run() {
                ShopPanel.this.shop.nextItem(ShopPanel.this.selectedItem);
            }
        });
    }

    public void prevItem() {
        TransactionManager.getInstance().runTransaction(new Runnable(){

            @Override
            public void run() {
                ShopPanel.this.shop.prevItem(ShopPanel.this.selectedItem);
            }
        });
    }

    public int[] getVRAM() {
        return this.vram;
    }

    private void update() {
        this.vram = this.shop.getVRAM(this.shopHandle);
        Graphics2D graphics2D = this.shopImage.createGraphics();
        int n = 0;
        while (n < 24) {
            int n2 = 0;
            while (n2 < 32) {
                int n3 = 14336 + (n << 6 | n2 << 1);
                Renderer.renderCharacter(this.vram, (this.vram[n3 | 1] & 0xF) << 8 | this.vram[n3], n2 * 8, n * 8, this.colors, graphics2D);
                ++n2;
            }
            ++n;
        }
        graphics2D.dispose();
        this.repaint();
    }

    @Override
    public Dimension getPreferredSize() {
        Insets insets = this.getInsets();
        return new Dimension((int)((float)this.shopImage.getWidth() * this.getPreferredScale()) + insets.left + insets.right, (int)((float)this.shopImage.getHeight() * this.getPreferredScale()) + insets.top + insets.bottom);
    }

    private int toScreenX(int n) {
        return n >= this.offsetX ? (int)((float)(n - this.offsetX) / this.scale) : (int)((float)(n - this.offsetX) / this.scale) - 1;
    }

    private int toScreenY(int n) {
        return n >= this.offsetY ? (int)((float)(n - this.offsetY) / this.scale) : (int)((float)(n - this.offsetY) / this.scale) - 1;
    }

    @Override
    public float getScale() {
        return this.scale;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        int n;
        super.paintComponent(graphics);
        BufferedImage bufferedImage = new BufferedImage(this.shopImage.getWidth(), this.shopImage.getHeight(), this.shopImage.getType());
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage((Image)this.shopImage, 0, 0, null);
        if (this.selectedItem >= 0) {
            graphics2D.setColor(Color.WHITE);
            int n2 = this.shop.getItemX(this.selectedItem);
            n = this.shop.getItemY(this.selectedItem);
            graphics2D.drawRect(n2 * 8, n * 8, 24, 24);
        }
        Insets insets = this.getInsets();
        n = this.getWidth() - (insets.left + insets.right);
        int n3 = this.getHeight() - (insets.top + insets.bottom);
        float f = (float)n / (float)bufferedImage.getWidth();
        float f2 = (float)n3 / (float)bufferedImage.getHeight();
        float f3 = Math.min(f, f2);
        if (this.isIntegerScaling()) {
            float f4;
            if ((this.scale != (float)((int)this.scale) || f3 - this.scale < 0.0f || f3 - this.scale >= 1.0f) && this.scale != (f4 = (float)Math.max(1, (int)(this.scale + Math.max(-1.0f, Math.min(1.0f, (f3 - this.scale) * 1.0f)))))) {
                this.scale = f4;
                this.scaleUpdated();
            }
        } else if (Math.abs(f3 - this.scale) * (float)bufferedImage.getWidth() > 2.0f && Math.abs(f3 - this.scale) * (float)bufferedImage.getHeight() > 2.0f) {
            this.scale += (f3 - this.scale) * 0.5f;
            this.scaleUpdated();
        }
        this.offsetX = Math.max(0, (int)(((float)n - (float)bufferedImage.getWidth() * this.scale) / 2.0f)) + insets.left;
        this.offsetY = Math.max(0, (int)(((float)n3 - (float)bufferedImage.getHeight() * this.scale) / 2.0f)) + insets.right;
        graphics.drawImage(bufferedImage, this.offsetX, this.offsetY, (int)((float)bufferedImage.getWidth() * this.scale), (int)((float)bufferedImage.getHeight() * this.scale), null);
    }
}

