/*
 * Decompiled with CFR 0.152.
 */
package panels;

import changes.Change;
import changes.ChangeListener;
import data.NameTable;
import data.Palette;
import data.Tileset;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.LinkedList;
import javax.swing.SwingUtilities;
import mastersystem.Renderer;
import panels.ScalablePanel;
import transactions.TransactionManager;

public class NameTablePanel
extends ScalablePanel {
    private BufferedImage image;
    private final Color[] colors = new Color[32];
    private Tileset tileset;
    private NameTable nameTable;
    private Palette palette;
    private int selectedTile;
    private int offsetX;
    private int offsetY;
    private float scale = 1.0f;
    private final LinkedList<ActionListener> listeners = new LinkedList();
    private final ChangeListener tilesetChangeListener = new ChangeListener(){

        @Override
        public void changeOccurred(Change change) {
            if (change.getData(NameTablePanel.this.tileset) < 256) {
                NameTablePanel.this.update();
            }
        }
    };
    private final ChangeListener paletteChangeListener = new ChangeListener(){

        @Override
        public void changeOccurred(Change change) {
            int n = change.getData(NameTablePanel.this.palette);
            if (n < 0) {
                int n2 = -n - 1;
                int n3 = n2 * 16;
                int n4 = n3 + 16;
                if (n2 == 2) {
                    n3 = 0;
                    n4 = 32;
                }
                int n5 = n3;
                while (n5 < n4) {
                    int n6 = NameTablePanel.this.palette.getColors()[n5];
                    int n7 = (n6 & 0x30) >> 4;
                    int n8 = (n6 & 0xC) >> 2;
                    int n9 = n6 & 3;
                    ((NameTablePanel)NameTablePanel.this).colors[n5] = new Color(n9 * 255 / 3, n8 * 255 / 3, n7 * 255 / 3);
                    ++n5;
                }
            } else {
                int n10 = NameTablePanel.this.palette.getColors()[n];
                int n11 = (n10 & 0x30) >> 4;
                int n12 = (n10 & 0xC) >> 2;
                int n13 = n10 & 3;
                ((NameTablePanel)NameTablePanel.this).colors[n] = new Color(n13 * 255 / 3, n12 * 255 / 3, n11 * 255 / 3);
            }
            NameTablePanel.this.update();
        }
    };
    private final ChangeListener nameTableChangeListener = new ChangeListener(){

        @Override
        public void changeOccurred(Change change) {
            if (change.getData(NameTablePanel.this.nameTable) >= 0) {
                NameTablePanel.this.update();
            }
        }
    };

    public NameTablePanel(NameTable nameTable, Tileset tileset, Palette palette) {
        final Cursor cursor = this.getCursor();
        final Cursor cursor2 = Cursor.getPredefinedCursor(12);
        this.setNameTable(nameTable, tileset, palette);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                int n = NameTablePanel.this.toScreenX(mouseEvent.getX());
                int n2 = NameTablePanel.this.toScreenY(mouseEvent.getY());
                if (SwingUtilities.isLeftMouseButton(mouseEvent) && n >= 0 && n2 >= 0 && n < NameTablePanel.this.image.getWidth() && n2 < NameTablePanel.this.image.getHeight()) {
                    NameTablePanel.this.setSelectedTile(n2 / 8 * NameTablePanel.this.nameTable.getWidth() + n / 8);
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                int n = NameTablePanel.this.toScreenX(mouseEvent.getX());
                int n2 = NameTablePanel.this.toScreenY(mouseEvent.getY());
                if (n >= 0 && n2 >= 0 && n < NameTablePanel.this.image.getWidth() && n2 < NameTablePanel.this.image.getHeight()) {
                    NameTablePanel.this.setCursor(cursor2);
                } else {
                    NameTablePanel.this.setCursor(cursor);
                }
            }
        });
    }

    @Override
    public float getScale() {
        return this.scale;
    }

    @Override
    public Dimension getPreferredSize() {
        Insets insets = this.getInsets();
        return new Dimension((int)((float)this.image.getWidth() * this.getPreferredScale()) + insets.left + insets.right, (int)((float)this.image.getHeight() * this.getPreferredScale()) + insets.top + insets.bottom);
    }

    private int toScreenX(int n) {
        return n >= this.offsetX ? (int)((float)(n - this.offsetX) / this.scale) : (int)((float)(n - this.offsetX) / this.scale) - 1;
    }

    private int toScreenY(int n) {
        return n >= this.offsetY ? (int)((float)(n - this.offsetY) / this.scale) : (int)((float)(n - this.offsetY) / this.scale) - 1;
    }

    public void copyToClipboard() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(new Transferable(){
            private BufferedImage data;
            {
                this.data = new BufferedImage(NameTablePanel.this.image.getColorModel(), NameTablePanel.this.image.copyData(null), NameTablePanel.this.image.isAlphaPremultiplied(), null);
            }

            @Override
            public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
                return DataFlavor.imageFlavor.equals(dataFlavor);
            }

            @Override
            public DataFlavor[] getTransferDataFlavors() {
                return new DataFlavor[]{DataFlavor.imageFlavor};
            }

            @Override
            public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
                if (!this.isDataFlavorSupported(dataFlavor)) {
                    throw new UnsupportedFlavorException(dataFlavor);
                }
                return this.data;
            }
        }, null);
    }

    public boolean canPasteFromClipboard() {
        return Toolkit.getDefaultToolkit().getSystemClipboard().isDataFlavorAvailable(DataFlavor.imageFlavor);
    }

    public void pasteFromClipboard() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        try {
            if (clipboard.isDataFlavorAvailable(DataFlavor.imageFlavor)) {
                Image image = (Image)clipboard.getData(DataFlavor.imageFlavor);
                BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 1);
                Graphics2D graphics2D = bufferedImage.createGraphics();
                graphics2D.drawImage(image, 0, 0, image.getWidth(null), image.getHeight(null), null);
                graphics2D.dispose();
                this.setTiles(bufferedImage);
            }
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            unsupportedFlavorException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void setTiles(BufferedImage bufferedImage) {
        int n = Math.min(this.image.getHeight(), bufferedImage.getHeight()) / 8;
        int n2 = Math.min(this.image.getWidth(), bufferedImage.getWidth()) / 8;
        final int[][] nArray = new int[n][n2];
        int[] nArray2 = this.tileset.getVRAM();
        int[] nArray3 = this.tileset.getCharCodes();
        BufferedImage bufferedImage2 = new BufferedImage(8, 8, 1);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            int n5 = 0;
            while (n5 < n2) {
                int n6 = 0;
                double d = Double.MAX_VALUE;
                int n7 = 0;
                while (n7 < nArray3.length && d > 0.0) {
                    int n8 = 0;
                    while (n8 < 8 && d > 0.0) {
                        Renderer.renderCharacter(nArray2, n8 << 9 | nArray3[(n7 + n3) % nArray3.length], 0, 0, this.colors, graphics2D);
                        double d2 = 0.0;
                        int n9 = 0;
                        while (n9 < 8 && d2 < d) {
                            int n10 = 0;
                            while (n10 < 8 && d2 < d) {
                                Color color = new Color(bufferedImage.getRGB(n5 * 8 + n10, n4 * 8 + n9), true);
                                Color color2 = new Color(bufferedImage2.getRGB(n10, n9));
                                int n11 = color2.getRed() - color.getRed();
                                int n12 = color2.getGreen() - color.getGreen();
                                int n13 = color2.getBlue() - color.getBlue();
                                d2 += Math.sqrt(n11 * n11 + n12 * n12 + n13 * n13);
                                ++n10;
                            }
                            ++n9;
                        }
                        if (d2 < d) {
                            d = d2;
                            n6 = n8 << 9 | nArray3[(n7 + n3) % nArray3.length];
                        }
                        ++n8;
                    }
                    ++n7;
                }
                nArray[n4][n5] = n6;
                n3 = n6 & 0x1FF;
                ++n5;
            }
            ++n4;
        }
        graphics2D.dispose();
        TransactionManager.getInstance().runTransaction(new Runnable(){

            @Override
            public void run() {
                NameTablePanel.this.nameTable.setTiles(nArray);
            }
        });
    }

    public void setNameTable(NameTable nameTable, Tileset tileset, Palette palette) {
        if (this.tileset != null && this.tileset != tileset) {
            this.tileset.removeChangeListener(this.tilesetChangeListener);
        }
        if (this.palette != null && this.palette != palette) {
            this.palette.removeChangeListener(this.paletteChangeListener);
        }
        if (this.nameTable != null && this.nameTable != nameTable) {
            this.nameTable.removeChangeListener(this.nameTableChangeListener);
        }
        this.tileset = tileset;
        this.nameTable = nameTable;
        this.palette = palette;
        int n = 0;
        int[] nArray = palette.getColors();
        int n2 = nArray.length;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = nArray[n3];
            int n5 = (n4 & 0x30) >> 4;
            int n6 = (n4 & 0xC) >> 2;
            int n7 = n4 & 3;
            this.colors[n++] = new Color(n7 * 255 / 3, n6 * 255 / 3, n5 * 255 / 3);
            ++n3;
        }
        this.image = new BufferedImage(nameTable.getWidth() * 8, nameTable.getHeight() * 8, 1);
        tileset.addChangeListener(this.tilesetChangeListener);
        palette.addChangeListener(this.paletteChangeListener);
        nameTable.addChangeListener(this.nameTableChangeListener);
        this.update();
    }

    public void setSelectedTile(int n) {
        this.selectedTile = n;
        this.repaint();
        this.fireActionPerformed();
    }

    public int getSelectedTileIndex() {
        return this.selectedTile;
    }

    public int[] getSelectedTile() {
        return this.nameTable.getTile(this.selectedTile);
    }

    public void setTile(final int n) {
        TransactionManager.getInstance().runTransaction(new Runnable(){

            @Override
            public void run() {
                NameTablePanel.this.nameTable.setTile(NameTablePanel.this.selectedTile, n);
            }
        });
    }

    public void setFlags(final int n) {
        TransactionManager.getInstance().runTransaction(new Runnable(){

            @Override
            public void run() {
                NameTablePanel.this.nameTable.setFlags(NameTablePanel.this.selectedTile, n);
            }
        });
    }

    public void setPalette(final int n) {
        TransactionManager.getInstance().runTransaction(new Runnable(){

            @Override
            public void run() {
                NameTablePanel.this.nameTable.setPalette(NameTablePanel.this.selectedTile, n);
            }
        });
    }

    public void setPriority(final boolean bl) {
        TransactionManager.getInstance().runTransaction(new Runnable(){

            @Override
            public void run() {
                NameTablePanel.this.nameTable.setPriority(NameTablePanel.this.selectedTile, bl);
            }
        });
    }

    public void flipH() {
        TransactionManager.getInstance().runTransaction(new Runnable(){

            @Override
            public void run() {
                NameTablePanel.this.nameTable.flipH(NameTablePanel.this.selectedTile);
            }
        });
    }

    public void flipV() {
        TransactionManager.getInstance().runTransaction(new Runnable(){

            @Override
            public void run() {
                NameTablePanel.this.nameTable.flipV(NameTablePanel.this.selectedTile);
            }
        });
    }

    private void update() {
        int[] nArray = this.nameTable.getVRAM();
        int[] nArray2 = this.tileset.getVRAM();
        Graphics2D graphics2D = this.image.createGraphics();
        int n = 0;
        while (n < this.nameTable.getHeight()) {
            int n2 = 0;
            while (n2 < this.nameTable.getWidth()) {
                int n3 = this.nameTable.getDestination() + (n << 6 | n2 << 1);
                Renderer.renderCharacter(nArray2, nArray[n3 | 1] << 8 | nArray[n3], n2 * 8, n * 8, this.colors, graphics2D);
                ++n2;
            }
            ++n;
        }
        graphics2D.dispose();
        this.revalidate();
        this.repaint();
    }

    protected final void fireActionPerformed() {
        for (ActionListener actionListener : this.listeners) {
            actionListener.actionPerformed(null);
        }
    }

    public final void addActionListener(ActionListener actionListener) {
        if (!this.listeners.contains(actionListener)) {
            this.listeners.add(actionListener);
        }
    }

    public final void removeActionListener(ActionListener actionListener) {
        this.listeners.remove(actionListener);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        int n;
        int n2;
        super.paintComponent(graphics);
        BufferedImage bufferedImage = new BufferedImage(this.image.getWidth(), this.image.getHeight(), this.image.getType());
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage((Image)this.image, 0, 0, null);
        graphics2D.setColor(Color.RED);
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setStroke(new BasicStroke(1.5f));
        int n3 = 0;
        while (n3 < this.nameTable.getHeight()) {
            n2 = 0;
            while (n2 < this.nameTable.getWidth()) {
                n = n3 * this.nameTable.getWidth() + n2;
                int[] nArray = this.nameTable.getTile(n);
                if (!this.tileset.contains((nArray[1] & 1) << 8 | nArray[0])) {
                    graphics2D.drawLine(n2 * 8 + 1, n3 * 8 + 1, (n2 + 1) * 8 - 2, (n3 + 1) * 8 - 2);
                }
                ++n2;
            }
            ++n3;
        }
        if (this.selectedTile >= 0) {
            graphics2D.setStroke(stroke);
            graphics2D.setColor(Color.WHITE);
            graphics2D.drawRect(this.selectedTile % this.nameTable.getWidth() * 8, this.selectedTile / this.nameTable.getWidth() * 8, 8, 8);
        }
        graphics2D.dispose();
        Insets insets = this.getInsets();
        n2 = this.getWidth() - (insets.left + insets.right);
        n = this.getHeight() - (insets.top + insets.bottom);
        float f = (float)n2 / (float)bufferedImage.getWidth();
        float f2 = (float)n / (float)bufferedImage.getHeight();
        float f3 = Math.min(f, f2);
        if (this.isIntegerScaling()) {
            float f4;
            if ((this.scale != (float)((int)this.scale) || f3 - this.scale < 0.0f || f3 - this.scale >= 1.0f) && this.scale != (f4 = (float)Math.max(1, (int)(this.scale + Math.max(-1.0f, Math.min(1.0f, (f3 - this.scale) * 1.0f)))))) {
                this.scale = f4;
                this.scaleUpdated();
            }
        } else if (Math.abs(f3 - this.scale) * (float)bufferedImage.getWidth() > 2.0f && Math.abs(f3 - this.scale) * (float)bufferedImage.getHeight() > 2.0f) {
            this.scale += (f3 - this.scale) * 0.5f;
            this.scaleUpdated();
        }
        this.offsetX = Math.max(0, (int)(((float)n2 - (float)bufferedImage.getWidth() * this.scale) / 2.0f)) + insets.left;
        this.offsetY = Math.max(0, (int)(((float)n - (float)bufferedImage.getHeight() * this.scale) / 2.0f)) + insets.right;
        graphics.drawImage(bufferedImage, this.offsetX, this.offsetY, (int)((float)bufferedImage.getWidth() * this.scale), (int)((float)bufferedImage.getHeight() * this.scale), null);
    }
}

