/*
 * Decompiled with CFR 0.152.
 */
package panels;

import changes.Change;
import changes.ChangeListener;
import data.MetaTileset;
import data.Palette;
import data.Tileset;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.LinkedList;
import javax.swing.SwingUtilities;
import mastersystem.Renderer;
import panels.ScalablePanel;
import transactions.TransactionManager;

public class MetaTilesetPanel
extends ScalablePanel {
    private final Cursor DEFAULT_CURSOR = this.getCursor();
    private final Cursor HAND_CURSOR = Cursor.getPredefinedCursor(12);
    private final BufferedImage metaTiles;
    private final BufferedImage buffer;
    private final Color[] colors = new Color[32];
    private MetaTileset metaTileset;
    private Tileset tileset;
    private Palette palette;
    private int selectedMetaTile;
    private int selectedSubTile = -1;
    private boolean selectUnusableEnabled;
    private boolean showTileAttributes;
    private boolean editRequested;
    private int offsetX;
    private int offsetY;
    private float scale = 1.0f;
    private final LinkedList<ActionListener> listeners = new LinkedList();
    private final ChangeListener tilesetChangeListener = new ChangeListener(){

        @Override
        public void changeOccurred(Change change) {
            if (change.getData(MetaTilesetPanel.this.tileset) < 256) {
                MetaTilesetPanel.this.update();
            }
        }
    };
    private final ChangeListener paletteChangeListener = new ChangeListener(){

        @Override
        public void changeOccurred(Change change) {
            int n = change.getData(MetaTilesetPanel.this.palette);
            if (n < 0) {
                int n2 = -n - 1;
                int n3 = n2 * 16;
                int n4 = n3 + 16;
                if (n2 == 2) {
                    n3 = 0;
                    n4 = 32;
                }
                int n5 = n3;
                while (n5 < n4) {
                    int n6 = MetaTilesetPanel.this.palette.getColors()[n5];
                    int n7 = (n6 & 0x30) >> 4;
                    int n8 = (n6 & 0xC) >> 2;
                    int n9 = n6 & 3;
                    ((MetaTilesetPanel)MetaTilesetPanel.this).colors[n5] = new Color(n9 * 255 / 3, n8 * 255 / 3, n7 * 255 / 3);
                    ++n5;
                }
            } else {
                int n10 = MetaTilesetPanel.this.palette.getColors()[n];
                int n11 = (n10 & 0x30) >> 4;
                int n12 = (n10 & 0xC) >> 2;
                int n13 = n10 & 3;
                ((MetaTilesetPanel)MetaTilesetPanel.this).colors[n] = new Color(n13 * 255 / 3, n12 * 255 / 3, n11 * 255 / 3);
            }
            MetaTilesetPanel.this.update();
        }
    };
    private final ChangeListener metaTileChangeListener = new ChangeListener(){

        @Override
        public void changeOccurred(Change change) {
            int n = change.getData(MetaTilesetPanel.this.metaTileset);
            if (n < 0) {
                MetaTilesetPanel.this.update();
            } else {
                Graphics2D graphics2D = MetaTilesetPanel.this.metaTiles.createGraphics();
                Renderer.renderMetaTile(MetaTilesetPanel.this.tileset.getVRAM(), MetaTilesetPanel.this.metaTileset.getMetaTile(n), n % 16 * MetaTilesetPanel.this.metaTileset.getMetaTileWidth(), n / 16 * MetaTilesetPanel.this.metaTileset.getMetaTileHeight(), MetaTilesetPanel.this.showTileAttributes, MetaTilesetPanel.this.colors, graphics2D);
                graphics2D.dispose();
                MetaTilesetPanel.this.repaint();
            }
        }
    };
    private final MouseAdapter mouseAdapter = new MouseAdapter(){

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            int n = MetaTilesetPanel.this.toScreenX(mouseEvent.getX());
            int n2 = MetaTilesetPanel.this.toScreenY(mouseEvent.getY());
            MetaTilesetPanel.this.editRequested = false;
            if (n < MetaTilesetPanel.this.metaTiles.getWidth() && n2 < MetaTilesetPanel.this.metaTiles.getHeight()) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    MetaTilesetPanel.this.setSelectedMetaTile(n2 / MetaTilesetPanel.this.metaTileset.getMetaTileHeight() * 16 + n / 16);
                } else if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    MetaTilesetPanel.this.editRequested = true;
                    MetaTilesetPanel.this.setSelectedMetaTile(n2 / MetaTilesetPanel.this.metaTileset.getMetaTileHeight() * 16 + n / 16);
                }
            }
        }
    };
    private final MouseMotionAdapter mouseMotionAdapter = new MouseMotionAdapter(){

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            int n = MetaTilesetPanel.this.toScreenX(mouseEvent.getX());
            int n2 = MetaTilesetPanel.this.toScreenY(mouseEvent.getY());
            if (n >= 0 && n < MetaTilesetPanel.this.metaTiles.getWidth() && n2 >= 0 && n2 < MetaTilesetPanel.this.metaTiles.getHeight()) {
                MetaTilesetPanel.this.setCursor(MetaTilesetPanel.this.HAND_CURSOR);
            } else {
                MetaTilesetPanel.this.setCursor(MetaTilesetPanel.this.DEFAULT_CURSOR);
            }
        }
    };

    public MetaTilesetPanel(MetaTileset metaTileset, Tileset tileset, Palette palette) {
        int n = 256 / metaTileset.getMetaTileWidth();
        int n2 = metaTileset.getNumberOfMetaTiles() / n * metaTileset.getMetaTileHeight();
        this.metaTiles = new BufferedImage(256, n2, 1);
        this.buffer = new BufferedImage(this.metaTiles.getWidth(), this.metaTiles.getHeight(), this.metaTiles.getType());
        this.setTileset(metaTileset, tileset, palette);
        this.addMouseListener(this.mouseAdapter);
        this.addMouseMotionListener(this.mouseMotionAdapter);
    }

    public void copyToClipboard() {
        Object object;
        String string = "";
        int[][] nArray = this.metaTileset.getMetaTiles();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object2 = object = (Object)nArray[n2];
            int n3 = ((Object)object2).length;
            int n4 = 0;
            while (n4 < n3) {
                Object object3 = object2[n4];
                if (!string.isEmpty()) {
                    string = String.valueOf(string) + " ";
                }
                string = String.valueOf(string) + String.format("$%02X", (int)object3);
                ++n4;
            }
            ++n2;
        }
        object = string;
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(new Transferable((String)object){
            private BufferedImage data;
            private final /* synthetic */ String val$dataString;
            {
                this.val$dataString = string;
                this.data = new BufferedImage(MetaTilesetPanel.this.metaTiles.getColorModel(), MetaTilesetPanel.this.metaTiles.copyData(null), MetaTilesetPanel.this.metaTiles.isAlphaPremultiplied(), null);
            }

            @Override
            public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
                return DataFlavor.stringFlavor.equals(dataFlavor) || DataFlavor.imageFlavor.equals(dataFlavor);
            }

            @Override
            public DataFlavor[] getTransferDataFlavors() {
                return new DataFlavor[]{DataFlavor.stringFlavor, DataFlavor.imageFlavor};
            }

            @Override
            public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
                if (!this.isDataFlavorSupported(dataFlavor)) {
                    throw new UnsupportedFlavorException(dataFlavor);
                }
                if (DataFlavor.stringFlavor.equals(dataFlavor)) {
                    return this.val$dataString;
                }
                return this.data;
            }
        }, null);
    }

    public void copySelectedMetaTileToClipboard() {
        final BufferedImage bufferedImage = new BufferedImage(32, 32, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        Renderer.renderMetaTile(this.tileset.getVRAM(), this.metaTileset.getMetaTile(this.selectedMetaTile), 0, 0, false, this.colors, graphics2D);
        graphics2D.dispose();
        String string = "";
        int[] nArray = this.metaTileset.getMetaTile(this.selectedMetaTile);
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray[n2];
            if (!string.isEmpty()) {
                string = String.valueOf(string) + " ";
            }
            string = String.valueOf(string) + String.format("$%02X", n3);
            ++n2;
        }
        final String string2 = string;
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(new Transferable(){

            @Override
            public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
                return DataFlavor.stringFlavor.equals(dataFlavor) || DataFlavor.imageFlavor.equals(dataFlavor);
            }

            @Override
            public DataFlavor[] getTransferDataFlavors() {
                return new DataFlavor[]{DataFlavor.stringFlavor, DataFlavor.imageFlavor};
            }

            @Override
            public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
                if (!this.isDataFlavorSupported(dataFlavor)) {
                    throw new UnsupportedFlavorException(dataFlavor);
                }
                if (DataFlavor.stringFlavor.equals(dataFlavor)) {
                    return string2;
                }
                return bufferedImage;
            }
        }, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean canPasteFromClipboard() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        try {
            if (!clipboard.isDataFlavorAvailable(DataFlavor.stringFlavor)) return false;
            String[] stringArray = ((String)clipboard.getData(DataFlavor.stringFlavor)).split(" ");
            if (stringArray.length != this.metaTileset.getNumberOfMetaTiles() * 8) {
                return false;
            }
            int n = 0;
            while (true) {
                if (n >= stringArray.length) {
                    return true;
                }
                try {
                    Integer.parseInt(stringArray[n].substring(1), 16);
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
                ++n;
            }
        }
        catch (IllegalStateException illegalStateException) {
            return false;
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            unsupportedFlavorException.printStackTrace();
            return false;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return false;
    }

    public void pasteFromClipboard() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        try {
            if (clipboard.isDataFlavorAvailable(DataFlavor.stringFlavor)) {
                Object object = clipboard.getData(DataFlavor.stringFlavor);
                String string = (String)object;
                this.setMetaTiles(string);
            }
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            unsupportedFlavorException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void setMetaTiles(String string) {
        String[] stringArray = string.split(" ");
        if (stringArray.length != this.metaTileset.getNumberOfMetaTiles() * 8) {
            return;
        }
        final int[][] nArray = new int[this.metaTileset.getNumberOfMetaTiles()][8];
        int n = 0;
        while (n < nArray.length) {
            int n2 = 0;
            while (n2 < nArray[0].length) {
                try {
                    nArray[n][n2] = Integer.parseInt(stringArray[n * 8 + n2].substring(1), 16);
                }
                catch (NumberFormatException numberFormatException) {
                    return;
                }
                ++n2;
            }
            ++n;
        }
        TransactionManager.getInstance().runTransaction(new Runnable(){

            @Override
            public void run() {
                MetaTilesetPanel.this.metaTileset.setMetaTiles(nArray);
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean canPasteMetaTileFromClipboard() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        try {
            if (!clipboard.isDataFlavorAvailable(DataFlavor.stringFlavor)) return false;
            String[] stringArray = ((String)clipboard.getData(DataFlavor.stringFlavor)).split(" ");
            if (stringArray.length != 8) {
                return false;
            }
            int n = 0;
            while (true) {
                if (n >= stringArray.length) {
                    return true;
                }
                try {
                    Integer.parseInt(stringArray[n].substring(1), 16);
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
                ++n;
            }
        }
        catch (IllegalStateException illegalStateException) {
            return false;
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            unsupportedFlavorException.printStackTrace();
            return false;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return false;
    }

    public void pasteMetaTileFromClipboard() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        try {
            if (clipboard.isDataFlavorAvailable(DataFlavor.stringFlavor)) {
                Object object = clipboard.getData(DataFlavor.stringFlavor);
                String string = (String)object;
                this.setMetaTile(string);
            }
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            unsupportedFlavorException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void setMetaTile(String string) {
        String[] stringArray = string.split(" ");
        if (stringArray.length != 8) {
            return;
        }
        final int[] nArray = new int[8];
        int n = 0;
        while (n < nArray.length) {
            try {
                nArray[n] = Integer.parseInt(stringArray[n].substring(1), 16);
            }
            catch (NumberFormatException numberFormatException) {
                return;
            }
            ++n;
        }
        TransactionManager.getInstance().runTransaction(new Runnable(){

            @Override
            public void run() {
                MetaTilesetPanel.this.metaTileset.setMetaTile(MetaTilesetPanel.this.selectedMetaTile, nArray);
            }
        });
    }

    public void setTileset(MetaTileset metaTileset, Tileset tileset, Palette palette) {
        if (this.tileset != null && this.tileset != tileset) {
            this.tileset.removeChangeListener(this.tilesetChangeListener);
        }
        if (this.palette != null && this.palette != palette) {
            this.palette.removeChangeListener(this.paletteChangeListener);
        }
        if (this.metaTileset != null && this.metaTileset != metaTileset) {
            this.metaTileset.removeChangeListener(this.metaTileChangeListener);
        }
        this.tileset = tileset;
        this.metaTileset = metaTileset;
        this.palette = palette;
        int n = 0;
        int[] nArray = palette.getColors();
        int n2 = nArray.length;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = nArray[n3];
            int n5 = (n4 & 0x30) >> 4;
            int n6 = (n4 & 0xC) >> 2;
            int n7 = n4 & 3;
            this.colors[n++] = new Color(n7 * 255 / 3, n6 * 255 / 3, n5 * 255 / 3);
            ++n3;
        }
        tileset.addChangeListener(this.tilesetChangeListener);
        palette.addChangeListener(this.paletteChangeListener);
        metaTileset.addChangeListener(this.metaTileChangeListener);
        this.selectedSubTile = -1;
        if (!metaTileset.isValid(this.selectedMetaTile) || !this.selectUnusableEnabled && !metaTileset.isUsable(this.selectedMetaTile, tileset)) {
            n = 0;
            while (n < metaTileset.getNumberOfMetaTiles()) {
                if (metaTileset.isValid(n) && (this.selectUnusableEnabled || metaTileset.isUsable(n, tileset))) {
                    this.setSelectedMetaTile(n);
                    break;
                }
                ++n;
            }
        }
        this.update();
    }

    public void setShowTileAttributes(boolean bl) {
        this.showTileAttributes = bl;
        this.update();
    }

    public boolean isShowTileAttributes() {
        return this.showTileAttributes;
    }

    @Override
    public float getScale() {
        return this.scale;
    }

    @Override
    public Dimension getPreferredSize() {
        Insets insets = this.getInsets();
        return new Dimension((int)((float)this.metaTiles.getWidth() * this.getPreferredScale()) + insets.left + insets.right, (int)((float)this.metaTiles.getHeight() * this.getPreferredScale()) + insets.top + insets.bottom);
    }

    private int toScreenX(int n) {
        return n >= this.offsetX ? (int)((float)(n - this.offsetX) / this.scale) : (int)((float)(n - this.offsetX) / this.scale) - 1;
    }

    private int toScreenY(int n) {
        return n >= this.offsetY ? (int)((float)(n - this.offsetY) / this.scale) : (int)((float)(n - this.offsetY) / this.scale) - 1;
    }

    public void setSelectedMetaTile(int n) {
        if (this.selectUnusableEnabled || this.metaTileset.isUsable(n, this.tileset)) {
            this.selectedMetaTile = n;
            this.selectedSubTile = -1;
            this.repaint();
            this.fireActionPerformed();
        }
    }

    public boolean isSelectUnusableEnabled() {
        return this.selectUnusableEnabled;
    }

    public void setSelectUnusableEnabled(boolean bl) {
        this.selectUnusableEnabled = bl;
    }

    public void setSelectedMetaSubTile(int n) {
        this.selectedSubTile = n;
        this.repaint();
    }

    public int getSelectedMetaTileIndex() {
        return this.selectedMetaTile;
    }

    public int[] getSelectedMetaTile() {
        return this.metaTileset.getMetaTile(this.selectedMetaTile);
    }

    public void setSubTile(final int n) {
        if (this.selectedSubTile >= 0) {
            TransactionManager.getInstance().runTransaction(new Runnable(){

                @Override
                public void run() {
                    MetaTilesetPanel.this.metaTileset.setSubTile(MetaTilesetPanel.this.selectedMetaTile, MetaTilesetPanel.this.selectedSubTile, n);
                }
            });
        }
    }

    public void setPalette(final int n) {
        TransactionManager.getInstance().runTransaction(new Runnable(){

            @Override
            public void run() {
                MetaTilesetPanel.this.metaTileset.setPalette(MetaTilesetPanel.this.selectedMetaTile, MetaTilesetPanel.this.selectedSubTile, n);
            }
        });
    }

    public void setFlags(final int n) {
        TransactionManager.getInstance().runTransaction(new Runnable(){

            @Override
            public void run() {
                MetaTilesetPanel.this.metaTileset.setFlags(MetaTilesetPanel.this.selectedMetaTile, MetaTilesetPanel.this.selectedSubTile, n);
            }
        });
    }

    public void setPriority(final boolean bl) {
        TransactionManager.getInstance().runTransaction(new Runnable(){

            @Override
            public void run() {
                MetaTilesetPanel.this.metaTileset.setPriority(MetaTilesetPanel.this.selectedMetaTile, MetaTilesetPanel.this.selectedSubTile, bl);
            }
        });
    }

    public void flipH() {
        TransactionManager.getInstance().runTransaction(new Runnable(){

            @Override
            public void run() {
                MetaTilesetPanel.this.metaTileset.flipH(MetaTilesetPanel.this.selectedMetaTile, MetaTilesetPanel.this.selectedSubTile);
            }
        });
    }

    public void flipV() {
        TransactionManager.getInstance().runTransaction(new Runnable(){

            @Override
            public void run() {
                MetaTilesetPanel.this.metaTileset.flipV(MetaTilesetPanel.this.selectedMetaTile, MetaTilesetPanel.this.selectedSubTile);
            }
        });
    }

    public boolean isEditRequested() {
        return this.editRequested;
    }

    private void update() {
        int[] nArray = this.tileset.getVRAM();
        int[][] nArray2 = this.metaTileset.getMetaTiles();
        Graphics2D graphics2D = this.metaTiles.createGraphics();
        int n = 0;
        while (n < nArray2.length) {
            Renderer.renderMetaTile(nArray, nArray2[n], n % 16 * this.metaTileset.getMetaTileWidth(), n / 16 * this.metaTileset.getMetaTileHeight(), this.showTileAttributes, this.colors, graphics2D);
            ++n;
        }
        graphics2D.dispose();
        this.repaint();
    }

    protected final void fireActionPerformed() {
        for (ActionListener actionListener : this.listeners) {
            actionListener.actionPerformed(null);
        }
    }

    public final void addActionListener(ActionListener actionListener) {
        if (!this.listeners.contains(actionListener)) {
            this.listeners.add(actionListener);
        }
    }

    public final void removeActionListener(ActionListener actionListener) {
        this.listeners.remove(actionListener);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = this.buffer.createGraphics();
        graphics2D.drawImage((Image)this.metaTiles, 0, 0, null);
        if (this.selectedMetaTile >= 0) {
            if (this.selectedSubTile >= 0) {
                graphics2D.setColor(Color.WHITE);
                graphics2D.drawRect(this.selectedMetaTile % 16 * this.metaTileset.getMetaTileWidth() + this.selectedSubTile % 2 * 8, this.selectedMetaTile / 16 * this.metaTileset.getMetaTileHeight() + this.selectedSubTile / 2 * 8, 8, 8);
            } else {
                graphics2D.setColor(Color.WHITE);
                graphics2D.drawRect(this.selectedMetaTile % 16 * this.metaTileset.getMetaTileWidth(), this.selectedMetaTile / 16 * this.metaTileset.getMetaTileHeight(), 16, this.metaTileset.getMetaTileHeight());
            }
        }
        graphics2D.setColor(Color.RED);
        graphics2D.setStroke(new BasicStroke(1.5f));
        int n = 0;
        while (n < this.metaTileset.getNumberOfMetaTiles()) {
            if (!this.metaTileset.isUsable(n, this.tileset)) {
                graphics2D.drawLine(n % 16 * this.metaTileset.getMetaTileWidth() + 1, n / 16 * this.metaTileset.getMetaTileHeight() + 1, (n % 16 + 1) * this.metaTileset.getMetaTileWidth() - 2, (n / 16 + 1) * this.metaTileset.getMetaTileHeight() - 2);
            }
            if (!this.metaTileset.isValid(n)) {
                graphics2D.drawLine(n % 16 * this.metaTileset.getMetaTileWidth() + 1, (n / 16 + 1) * this.metaTileset.getMetaTileHeight() - 2, (n % 16 + 1) * this.metaTileset.getMetaTileWidth() - 2, n / 16 * this.metaTileset.getMetaTileHeight() + 1);
            }
            ++n;
        }
        graphics2D.dispose();
        Insets insets = this.getInsets();
        int n2 = this.getWidth() - (insets.left + insets.right);
        int n3 = this.getHeight() - (insets.top + insets.bottom);
        float f = (float)n2 / (float)this.buffer.getWidth();
        float f2 = (float)n3 / (float)this.buffer.getHeight();
        float f3 = Math.min(f, f2);
        if (this.isIntegerScaling()) {
            float f4;
            if ((this.scale != (float)((int)this.scale) || f3 - this.scale < 0.0f || f3 - this.scale >= 1.0f) && this.scale != (f4 = (float)Math.max(1, (int)(this.scale + Math.max(-1.0f, Math.min(1.0f, (f3 - this.scale) * 1.0f)))))) {
                this.scale = f4;
                this.scaleUpdated();
            }
        } else if (Math.abs(f3 - this.scale) * (float)this.buffer.getWidth() > 2.0f && Math.abs(f3 - this.scale) * (float)this.buffer.getHeight() > 2.0f) {
            this.scale += (f3 - this.scale) * 0.5f;
            this.scaleUpdated();
        }
        this.offsetX = Math.max(0, (int)(((float)n2 - (float)this.buffer.getWidth() * this.scale) / 2.0f)) + insets.left;
        this.offsetY = Math.max(0, (int)(((float)n3 - (float)this.buffer.getHeight() * this.scale) / 2.0f)) + insets.right;
        graphics.drawImage(this.buffer, this.offsetX, this.offsetY, (int)((float)this.buffer.getWidth() * this.scale), (int)((float)this.buffer.getHeight() * this.scale), null);
    }
}

