/*
 * Decompiled with CFR 0.152.
 */
package editors;

import changes.UndoRedoManager;
import common.MenuItem;
import common.Properties;
import common.ScreenUtilities;
import data.NameTable;
import data.Palette;
import data.SpriteContainer;
import data.Tiles;
import data.Tileset;
import data.TitleScreen;
import editors.TextProvider;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import miracleworld.MiracleWorldEditorModel;
import panels.TitleScreenPanel;
import widgets.ScalableIcon;

public class TitleScreenEditor
extends JDialog {
    private static final ScalableIcon ICON_LAYOUT_EDITING = MiracleWorldEditorModel.getIcon("ICON_LAYOUT_EDITING");
    private static final ScalableIcon ICON_ENTITY_EDITING = MiracleWorldEditorModel.getIcon("ICON_ENTITY_EDITING");
    private static final ScalableIcon ICON_ERASE = MiracleWorldEditorModel.getIcon("ICON_ERASE");
    private static TitleScreenEditor editor;
    private JToggleButton buttonLayoutEditing;
    private JToggleButton buttonEntityEditing;
    private final TitleScreenPanel titleScreenPanel;
    private TitleScreen titleScreen;
    private Tileset tileset;
    private Palette palette;
    private JButton eraseButton;
    private final KeyEventDispatcher keyEventDispatcher = new KeyEventDispatcher(){

        @Override
        public boolean dispatchKeyEvent(KeyEvent keyEvent) {
            if (!editor.isFocused()) {
                return false;
            }
            if (keyEvent.getKeyCode() == 9 && keyEvent.getID() == 401) {
                if (TitleScreenEditor.this.buttonEntityEditing.isSelected()) {
                    TitleScreenEditor.this.buttonLayoutEditing.doClick();
                } else if (TitleScreenEditor.this.buttonLayoutEditing.isSelected()) {
                    TitleScreenEditor.this.buttonEntityEditing.doClick();
                }
            }
            return false;
        }
    };

    private TitleScreenEditor(final JFrame jFrame, TitleScreen titleScreen, Tileset tileset, Palette palette, NameTable[] nameTableArray, Tiles tiles, Tiles tiles2, SpriteContainer[] spriteContainerArray) {
        this.setTitle(TextProvider.get("TitleTitleScreen"));
        this.titleScreen = titleScreen;
        this.tileset = tileset;
        this.palette = palette;
        this.setLayout(new BorderLayout());
        this.titleScreenPanel = new TitleScreenPanel(titleScreen, tileset, palette, nameTableArray, tiles, tiles2, spriteContainerArray);
        this.titleScreenPanel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NameTable nameTable = TitleScreenEditor.this.titleScreenPanel.getSelectedNameTable();
                if (nameTable != null) {
                    MiracleWorldEditorModel.openNameTableEditor(jFrame, new NameTable[]{TitleScreenEditor.this.titleScreenPanel.getSelectedNameTable()}, new Tileset[]{TitleScreenEditor.this.tileset}, new Palette[]{TitleScreenEditor.this.palette});
                }
            }
        });
        ICON_ENTITY_EDITING.setScaleParent(this.titleScreenPanel);
        ICON_LAYOUT_EDITING.setScaleParent(this.titleScreenPanel);
        ICON_ERASE.setScaleParent(this.titleScreenPanel);
        this.add((Component)this.titleScreenPanel, "Center");
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                switch (keyEvent.getKeyCode()) {
                    case 37: {
                        TitleScreenEditor.this.titleScreenPanel.decreaseScreenNumber();
                        break;
                    }
                    case 39: {
                        TitleScreenEditor.this.titleScreenPanel.increaseScreenNumber();
                        break;
                    }
                    case 8: 
                    case 127: {
                        TitleScreenEditor.this.titleScreenPanel.removeSelectedEntity();
                    }
                }
            }
        });
        this.add((Component)this.makeToolbar(), "First");
        JMenuBar jMenuBar = new JMenuBar();
        this.setJMenuBar(jMenuBar);
        jMenuBar.add(this.makeMenuEdit());
        this.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                if (mouseWheelEvent.getUnitsToScroll() < 0) {
                    if (mouseWheelEvent.isAltDown()) {
                        float f = Math.max(1, (int)(TitleScreenEditor.this.titleScreenPanel.getScale() + 1.5f));
                        TitleScreenEditor.this.titleScreenPanel.setPreferredScale(f);
                        TitleScreenEditor.this.pack();
                    } else {
                        TitleScreenEditor.this.titleScreenPanel.decreaseScreenNumber();
                    }
                } else if (mouseWheelEvent.getUnitsToScroll() > 0) {
                    if (mouseWheelEvent.isAltDown()) {
                        float f = Math.max(1, (int)(TitleScreenEditor.this.titleScreenPanel.getScale() - 0.5f));
                        TitleScreenEditor.this.titleScreenPanel.setPreferredScale(f);
                        TitleScreenEditor.this.pack();
                    } else {
                        TitleScreenEditor.this.titleScreenPanel.increaseScreenNumber();
                    }
                }
                mouseWheelEvent.consume();
            }
        });
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this.keyEventDispatcher);
    }

    @Override
    public void dispose() {
        super.dispose();
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this.keyEventDispatcher);
    }

    private JMenu makeMenuEdit() {
        JMenu jMenu = new JMenu(TextProvider.get("MenuEdit"));
        jMenu.setMnemonic('e');
        final MenuItem menuItem = new MenuItem(TextProvider.get("MenuUndo"), 117);
        jMenu.add(menuItem);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UndoRedoManager.getInstance().undo(TitleScreenEditor.this.titleScreen);
            }
        });
        menuItem.setAccelerator(KeyStroke.getKeyStroke(90, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        final MenuItem menuItem2 = new MenuItem(TextProvider.get("MenuRedo"), 114);
        jMenu.add(menuItem2);
        menuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UndoRedoManager.getInstance().redo(TitleScreenEditor.this.titleScreen);
            }
        });
        menuItem2.setAccelerator(KeyStroke.getKeyStroke(89, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        jMenu.addSeparator();
        final MenuItem menuItem3 = new MenuItem(TextProvider.get("MenuPreviousScreen"), 112);
        jMenu.add(menuItem3);
        menuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TitleScreenEditor.this.titleScreenPanel.decreaseScreenNumber();
            }
        });
        menuItem3.setAccelerator(KeyStroke.getKeyStroke(38, 0));
        final MenuItem menuItem4 = new MenuItem(TextProvider.get("MenuNextScreen"), 110);
        jMenu.add(menuItem4);
        menuItem4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TitleScreenEditor.this.titleScreenPanel.increaseScreenNumber();
            }
        });
        menuItem4.setAccelerator(KeyStroke.getKeyStroke(40, 0));
        jMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent menuEvent) {
                menuItem.setEnabled(UndoRedoManager.getInstance().canUndo(TitleScreenEditor.this.titleScreen));
                menuItem2.setEnabled(UndoRedoManager.getInstance().canRedo(TitleScreenEditor.this.titleScreen));
                menuItem3.setEnabled(TitleScreenEditor.this.titleScreenPanel.canDecreaseScreenNumber());
                menuItem4.setEnabled(TitleScreenEditor.this.titleScreenPanel.canIncreaseScreenNumber());
            }

            @Override
            public void menuDeselected(MenuEvent menuEvent) {
                menuItem.setEnabled(true);
                menuItem2.setEnabled(true);
                menuItem3.setEnabled(true);
                menuItem4.setEnabled(true);
            }

            @Override
            public void menuCanceled(MenuEvent menuEvent) {
            }
        });
        return jMenu;
    }

    private JToolBar makeToolbar() {
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.buttonEntityEditing = new JToggleButton(ICON_ENTITY_EDITING, true);
        ICON_ENTITY_EDITING.setOwner(this.buttonEntityEditing);
        this.buttonEntityEditing.setFocusable(false);
        this.buttonEntityEditing.setMargin(new Insets(0, 0, 0, 0));
        this.buttonEntityEditing.setToolTipText(TextProvider.get("ToolbarModeEntity"));
        this.buttonEntityEditing.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TitleScreenEditor.this.titleScreenPanel.setMode(0);
                TitleScreenEditor.this.eraseButton.setVisible(true);
            }
        });
        buttonGroup.add(this.buttonEntityEditing);
        jToolBar.add(this.buttonEntityEditing);
        this.buttonLayoutEditing = new JToggleButton(ICON_LAYOUT_EDITING);
        ICON_LAYOUT_EDITING.setOwner(this.buttonLayoutEditing);
        this.buttonLayoutEditing.setFocusable(false);
        this.buttonLayoutEditing.setMargin(new Insets(4, 0, 4, 0));
        this.buttonLayoutEditing.setToolTipText(TextProvider.get("ToolbarModeLayout"));
        this.buttonLayoutEditing.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TitleScreenEditor.this.titleScreenPanel.setMode(1);
                TitleScreenEditor.this.eraseButton.setVisible(false);
            }
        });
        buttonGroup.add(this.buttonLayoutEditing);
        jToolBar.add(this.buttonLayoutEditing);
        jToolBar.addSeparator();
        this.eraseButton = new JButton(ICON_ERASE);
        ICON_ERASE.setOwner(this.eraseButton);
        this.eraseButton.setFocusable(false);
        this.eraseButton.setMargin(new Insets(0, 0, 0, 0));
        this.eraseButton.setToolTipText(TextProvider.get("ToolbarDelete"));
        this.eraseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TitleScreenEditor.this.titleScreenPanel.removeSelectedEntity();
            }
        });
        jToolBar.add(this.eraseButton);
        return jToolBar;
    }

    public static void open(JFrame jFrame, TitleScreen titleScreen, Tileset tileset, Palette palette, NameTable[] nameTableArray, Tiles tiles, Tiles tiles2, SpriteContainer[] spriteContainerArray, Properties properties) {
        if (editor == null) {
            editor = new TitleScreenEditor(jFrame, titleScreen, tileset, palette, nameTableArray, tiles, tiles2, spriteContainerArray);
            try {
                editor.setLocation(properties.getInt("Window" + editor.getClass().getSimpleName() + "X"), properties.getInt("Window" + editor.getClass().getSimpleName() + "Y"));
            }
            catch (NumberFormatException numberFormatException) {
                editor.setLocationRelativeTo(jFrame);
            }
            try {
                editor.setSize(properties.getInt("Window" + editor.getClass().getSimpleName() + "Width"), properties.getInt("Window" + editor.getClass().getSimpleName() + "Height"));
            }
            catch (NumberFormatException numberFormatException) {
                editor.pack();
            }
        } else {
            TitleScreenEditor.editor.tileset = tileset;
            TitleScreenEditor.editor.palette = palette;
            TitleScreenEditor.editor.titleScreenPanel.setTitleScreen(titleScreen, tileset, palette, nameTableArray, tiles, tiles2, spriteContainerArray);
        }
        if (ScreenUtilities.getScreen(editor) == null) {
            editor.setLocationRelativeTo(jFrame);
        }
        TitleScreenEditor.editor.titleScreenPanel.setIntegerScaling(Boolean.parseBoolean(properties.getProperty("IntegerScaling")));
        editor.setVisible(true);
    }

    public static void close() {
        if (editor != null) {
            editor.setVisible(false);
        }
    }

    public static void destroy() {
        if (editor != null) {
            editor.dispose();
        }
        editor = null;
    }

    public static void saveState(Properties properties) {
        if (editor != null) {
            properties.setProperty("Window" + editor.getClass().getSimpleName() + "Open", "" + editor.isVisible());
            properties.setProperty("Window" + editor.getClass().getSimpleName() + "X", "" + editor.getX());
            properties.setProperty("Window" + editor.getClass().getSimpleName() + "Y", "" + editor.getY());
            if (editor.isResizable()) {
                properties.setProperty("Window" + editor.getClass().getSimpleName() + "Width", "" + editor.getWidth());
                properties.setProperty("Window" + editor.getClass().getSimpleName() + "Height", "" + editor.getHeight());
            }
        }
    }
}

