/*
 * Decompiled with CFR 0.152.
 */
package editors;

import changes.Change;
import changes.ChangeListener;
import changes.UndoRedoManager;
import common.ComponentWrapper;
import common.MenuItem;
import common.Properties;
import common.ScreenUtilities;
import data.CompressedTiles;
import data.LevelSpriteTileset;
import data.LevelTileset;
import data.Palette;
import data.SpriteTileset;
import data.Tiles;
import data.Tileset;
import editors.Icons;
import editors.TextProvider;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import miracleworld.MiracleWorldEditorModel;
import panels.TilesetPanel;
import transactions.TransactionManager;
import widgets.TilesComboBox;
import widgets.TilesetCheckBox;

public class TilesetEditor
extends JDialog {
    private static TilesetEditor editor;
    private Tileset[] tilesets;
    private Tiles[] levelMainTilesets;
    private Tiles[] levelAdditionalTilesets;
    private Palette[] palettes;
    private final List<Tiles>[] additionalTilesets = new List[2];
    private final TilesetPanel tileset;
    private final JComboBox<String> tilesetSelection;
    private final ChangeListener tilesetChangeListener = new ChangeListener(){

        @Override
        public void changeOccurred(Change change) {
            TilesetEditor.this.tilesetSelection.setSelectedIndex(TilesetEditor.this.tilesetSelection.getSelectedIndex());
        }
    };

    private TilesetEditor(Tileset[] tilesetArray, Tiles[] tilesArray, Tiles[] tilesArray2, SpriteTileset[] spriteTilesetArray, Palette[] paletteArray, int n) {
        int n2;
        Object object;
        this.setTitle(TextProvider.get("TitleTileset"));
        ArrayList<SpriteTileset> arrayList = new ArrayList<SpriteTileset>();
        Object object2 = spriteTilesetArray;
        int n3 = spriteTilesetArray.length;
        int n4 = 0;
        while (n4 < n3) {
            object = object2[n4];
            if (object.getClass() == SpriteTileset.class) {
                arrayList.add((SpriteTileset)object);
            }
            ++n4;
        }
        spriteTilesetArray = arrayList.toArray(new SpriteTileset[arrayList.size()]);
        this.tilesets = tilesetArray;
        this.levelMainTilesets = tilesArray;
        this.levelAdditionalTilesets = tilesArray2;
        this.palettes = paletteArray;
        this.setLayout(new BorderLayout());
        object = new JMenuBar();
        this.setJMenuBar((JMenuBar)object);
        ((JMenuBar)object).add(this.makeMenuEdit());
        String[] stringArray = new String[35];
        n3 = 0;
        while (n3 < 34) {
            stringArray[n3] = String.format("%s %02X %s", TextProvider.get("Level"), n3 / 2 + 1, TextProvider.get("LevelTileset"));
            stringArray[n3 + 1] = String.format("%s %02X %s", TextProvider.get("Level"), n3 / 2 + 1, TextProvider.get("SpriteTileset"));
            n3 += 2;
        }
        stringArray[34] = TextProvider.get("TilesetShop");
        this.tilesetSelection = new JComboBox<String>(stringArray);
        this.tilesetSelection.setSelectedIndex(n * 2);
        tilesetArray[n * 2].addChangeListener(this.tilesetChangeListener);
        this.tileset = new TilesetPanel(tilesetArray[n * 2], paletteArray[n]);
        this.tileset.setEditable(true);
        JPanel jPanel = new JPanel(new GridLayout((spriteTilesetArray.length - 1) / 3 + 1, 3));
        object2 = new JPanel(new BorderLayout());
        final TilesetCheckBox[] tilesetCheckBoxArray = new TilesetCheckBox[spriteTilesetArray.length];
        final TilesetCheckBox tilesetCheckBox = new TilesetCheckBox(((LevelTileset)tilesetArray[n * 2]).hasClearTiles(), new Tileset(4188), paletteArray[n]);
        tilesetCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TransactionManager.getInstance().runTransaction(new Runnable(){

                    @Override
                    public void run() {
                        if (tilesetCheckBox.isSelected()) {
                            MiracleWorldEditorModel.addClearTiles((LevelTileset)TilesetEditor.this.tilesets[TilesetEditor.this.tilesetSelection.getSelectedIndex()]);
                        } else {
                            MiracleWorldEditorModel.removeClearTiles((LevelTileset)TilesetEditor.this.tilesets[TilesetEditor.this.tilesetSelection.getSelectedIndex()]);
                        }
                    }
                });
            }
        });
        tilesetCheckBox.setEnabled(tilesetCheckBox.isSelected() && ((LevelTileset)tilesetArray[n * 2]).canRemoveClearTiles() || !tilesetCheckBox.isSelected() && MiracleWorldEditorModel.canAddClearTiles());
        tilesetCheckBox.setScaleParent(this.tileset);
        ((Container)object2).add((Component)ComponentWrapper.wrapComponent(tilesetCheckBox), "North");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        ((Container)object2).add((Component)jPanel2, "Center");
        jPanel2.add((Component)new JLabel(String.valueOf(TextProvider.get("LevelMainTileset")) + ":"), "North");
        final TilesComboBox tilesComboBox = new TilesComboBox(tilesArray, paletteArray[n]);
        tilesComboBox.setScaleParent(this.tileset);
        tilesComboBox.setSelectedTiles(((LevelTileset)this.tilesets[n * 2]).getMainTilesetAddress());
        tilesComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TransactionManager.getInstance().runTransaction(new Runnable(){

                    @Override
                    public void run() {
                        LevelTileset levelTileset = (LevelTileset)TilesetEditor.this.tilesets[TilesetEditor.this.tilesetSelection.getSelectedIndex()];
                        levelTileset.setMainTileset(tilesComboBox.getSelectedTiles());
                    }
                });
            }
        });
        JButton jButton = new JButton(new Icons.AddIcon(true));
        jButton.setDisabledIcon(new Icons.AddIcon(false));
        jButton.setEnabled(MiracleWorldEditorModel.canAddMainTileset());
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TransactionManager.getInstance().runTransaction(new Runnable(){

                    @Override
                    public void run() {
                        MiracleWorldEditorModel.addMainTileset((LevelTileset)TilesetEditor.this.tilesets[TilesetEditor.this.tilesetSelection.getSelectedIndex()]);
                    }
                });
            }
        });
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)tilesComboBox, "Center");
        JButton jButton2 = new JButton(new Icons.RemoveIcon(true));
        jButton2.setDisabledIcon(new Icons.RemoveIcon(false));
        jPanel3.add((Component)jButton2, "East");
        jButton2.setEnabled(((LevelTileset)tilesetArray[n * 2]).canRemoveMainTileset());
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TransactionManager.getInstance().runTransaction(new Runnable(){

                    @Override
                    public void run() {
                        MiracleWorldEditorModel.removeMainTileset((LevelTileset)TilesetEditor.this.tilesets[TilesetEditor.this.tilesetSelection.getSelectedIndex()]);
                    }
                });
            }
        });
        if (((LevelTileset)tilesetArray[n * 2]).hasMainTileset()) {
            jPanel2.add((Component)jPanel3, "South");
        } else {
            jPanel2.add((Component)jButton, "South");
        }
        boolean bl = MiracleWorldEditorModel.canAddAdditionalTileset();
        JPanel jPanel4 = new JPanel(new BorderLayout());
        int[] nArray = ((LevelTileset)tilesetArray[n * 2]).getAdditionalTilesetAddresses();
        JPanel jPanel5 = new JPanel(new GridLayout(nArray.length + (bl ? 1 : 0), 1));
        final TilesComboBox[] tilesComboBoxArray = new TilesComboBox[8];
        JPanel[] jPanelArray = new JPanel[tilesComboBoxArray.length];
        int n5 = 0;
        while (n5 < tilesComboBoxArray.length) {
            n2 = n5;
            tilesComboBoxArray[n5] = new TilesComboBox(this.getAdditionalLevelTilesets(n5 >= nArray.length - 1), paletteArray[n]);
            tilesComboBoxArray[n5].addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TransactionManager.getInstance().runTransaction(new Runnable(){

                        @Override
                        public void run() {
                            LevelTileset levelTileset = (LevelTileset)TilesetEditor.this.tilesets[TilesetEditor.this.tilesetSelection.getSelectedIndex()];
                            levelTileset.setAdditionalTileset(n2, tilesComboBoxArray[n2].getSelectedTiles());
                        }
                    });
                }
            });
            jPanelArray[n5] = new JPanel(new BorderLayout());
            jPanelArray[n5].add((Component)tilesComboBoxArray[n5], "Center");
            JButton jButton3 = new JButton(new Icons.RemoveIcon(true));
            jPanelArray[n5].add((Component)jButton3, "East");
            final int n6 = n5++;
            jButton3.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TransactionManager.getInstance().runTransaction(new Runnable(){

                        @Override
                        public void run() {
                            MiracleWorldEditorModel.removeAdditionalTileset((LevelTileset)TilesetEditor.this.tilesets[TilesetEditor.this.tilesetSelection.getSelectedIndex()], n6);
                        }
                    });
                }
            });
        }
        jPanel4.add((Component)new JLabel(String.valueOf(TextProvider.get("LevelAdditionalTilesets")) + ":"), "North");
        ((Container)object2).add((Component)jPanel4, "South");
        n5 = 0;
        while (n5 < nArray.length) {
            tilesComboBoxArray[n5].setScaleParent(this.tileset);
            tilesComboBoxArray[n5].setSelectedTiles(((LevelTileset)tilesetArray[n * 2]).getAdditionalTilesetAddresses()[n5]);
            jPanel5.add(jPanelArray[n5]);
            ++n5;
        }
        JButton jButton4 = new JButton(new Icons.AddIcon(true));
        if (bl) {
            jPanel5.add(jButton4);
        }
        jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TransactionManager.getInstance().runTransaction(new Runnable(){

                    @Override
                    public void run() {
                        MiracleWorldEditorModel.addAdditionalTileset((LevelTileset)TilesetEditor.this.tilesets[TilesetEditor.this.tilesetSelection.getSelectedIndex()]);
                    }
                });
            }
        });
        jPanel4.add((Component)jPanel5, "South");
        this.add((Component)object2, "South");
        n2 = 0;
        while (n2 < tilesetCheckBoxArray.length) {
            tilesetCheckBoxArray[n2] = new TilesetCheckBox(true, spriteTilesetArray[n2], paletteArray[n]);
            jPanel.add(tilesetCheckBoxArray[n2]);
            tilesetCheckBoxArray[n2].addMouseListener(new MouseAdapter(){

                @Override
                public void mouseExited(MouseEvent mouseEvent) {
                    TilesetEditor.this.tileset.hideSubTileset();
                }

                @Override
                public void mouseEntered(MouseEvent mouseEvent) {
                    TilesetCheckBox tilesetCheckBox = (TilesetCheckBox)mouseEvent.getSource();
                    TilesetEditor.this.tileset.showSubTileset(tilesetCheckBox.getTileset());
                }
            });
            tilesetCheckBoxArray[n2].addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(final ActionEvent actionEvent) {
                    int n = TilesetEditor.this.tilesetSelection.getSelectedIndex();
                    final LevelSpriteTileset levelSpriteTileset = (LevelSpriteTileset)TilesetEditor.this.tilesets[n];
                    TransactionManager.getInstance().runTransaction(new Runnable(){

                        @Override
                        public void run() {
                            TilesetCheckBox tilesetCheckBox = (TilesetCheckBox)actionEvent.getSource();
                            if (tilesetCheckBox.isSelected()) {
                                levelSpriteTileset.addSubTileset((SpriteTileset)tilesetCheckBox.getTileset());
                            } else {
                                levelSpriteTileset.removeSubTileset((SpriteTileset)tilesetCheckBox.getTileset());
                            }
                        }
                    });
                    boolean bl = levelSpriteTileset.canAddMoreTilesets();
                    TilesetCheckBox[] tilesetCheckBoxArray2 = tilesetCheckBoxArray;
                    int n2 = tilesetCheckBoxArray.length;
                    int n3 = 0;
                    while (n3 < n2) {
                        TilesetCheckBox tilesetCheckBox = tilesetCheckBoxArray2[n3];
                        tilesetCheckBox.setSelected(levelSpriteTileset.isSubTileset((SpriteTileset)tilesetCheckBox.getTileset()));
                        tilesetCheckBox.setPalette(TilesetEditor.this.palettes[n / 2]);
                        tilesetCheckBox.setEnabled(tilesetCheckBox.isSelected() || bl);
                        ++n3;
                    }
                }
            });
            ++n2;
        }
        this.tilesetSelection.addActionListener(new ActionListener(bl, nArray, (JPanel)object2, jPanel, tilesetCheckBoxArray, tilesetCheckBox, jPanel2, jPanel3, jButton, jButton2, tilesComboBox, jPanel5, tilesComboBoxArray, jPanelArray, jButton4){
            private int prevIndex;
            private Tileset prevSelectedTileset;
            private boolean prevHasMainTileset;
            private boolean prevCanAdd;
            private int prevNumAdditionalTilesets;
            private final /* synthetic */ JPanel val$southLevelTileset;
            private final /* synthetic */ JPanel val$southSpriteTileset;
            private final /* synthetic */ TilesetCheckBox[] val$checkBoxes;
            private final /* synthetic */ TilesetCheckBox val$clearTiles;
            private final /* synthetic */ JPanel val$mainTileset;
            private final /* synthetic */ JPanel val$mainTilesetPanel;
            private final /* synthetic */ JButton val$addMainTileset;
            private final /* synthetic */ JButton val$removeMainTileset;
            private final /* synthetic */ TilesComboBox val$mainTilesetsComboBox;
            private final /* synthetic */ JPanel val$additionalTilesetsGrid;
            private final /* synthetic */ TilesComboBox[] val$additionalTilesetsComboBoxes;
            private final /* synthetic */ JPanel[] val$additionalTilesetsPanels;
            private final /* synthetic */ JButton val$addAdditionalTileset;
            {
                this.val$southLevelTileset = jPanel;
                this.val$southSpriteTileset = jPanel2;
                this.val$checkBoxes = tilesetCheckBoxArray;
                this.val$clearTiles = tilesetCheckBox;
                this.val$mainTileset = jPanel3;
                this.val$mainTilesetPanel = jPanel4;
                this.val$addMainTileset = jButton;
                this.val$removeMainTileset = jButton2;
                this.val$mainTilesetsComboBox = tilesComboBox;
                this.val$additionalTilesetsGrid = jPanel5;
                this.val$additionalTilesetsComboBoxes = tilesComboBoxArray;
                this.val$additionalTilesetsPanels = jPanelArray;
                this.val$addAdditionalTileset = jButton3;
                this.prevIndex = TilesetEditor.this.tilesetSelection.getSelectedIndex();
                this.prevSelectedTileset = TilesetEditor.this.tilesets[this.prevIndex];
                this.prevHasMainTileset = this.prevSelectedTileset instanceof LevelTileset && ((LevelTileset)this.prevSelectedTileset).hasMainTileset();
                this.prevCanAdd = bl;
                this.prevNumAdditionalTilesets = nArray.length;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl;
                JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                int n = jComboBox.getSelectedIndex();
                Tileset tileset = TilesetEditor.this.tilesets[n];
                boolean bl2 = bl = this.prevSelectedTileset == null || tileset.getClass() != this.prevSelectedTileset.getClass();
                if (tileset != this.prevSelectedTileset) {
                    this.prevSelectedTileset.removeChangeListener(TilesetEditor.this.tilesetChangeListener);
                }
                tileset.addChangeListener(TilesetEditor.this.tilesetChangeListener);
                TilesetEditor.this.tileset.hideSubTileset();
                if (tileset instanceof LevelSpriteTileset) {
                    LevelSpriteTileset levelSpriteTileset = (LevelSpriteTileset)tileset;
                    if (bl) {
                        TilesetEditor.this.remove(this.val$southLevelTileset);
                        TilesetEditor.this.add((Component)this.val$southSpriteTileset, "South");
                    }
                    boolean bl3 = levelSpriteTileset.canAddMoreTilesets();
                    TilesetCheckBox[] tilesetCheckBoxArray = this.val$checkBoxes;
                    int n2 = this.val$checkBoxes.length;
                    int n3 = 0;
                    while (n3 < n2) {
                        TilesetCheckBox tilesetCheckBox = tilesetCheckBoxArray[n3];
                        tilesetCheckBox.setSelected(levelSpriteTileset.isSubTileset((SpriteTileset)tilesetCheckBox.getTileset()));
                        tilesetCheckBox.setPalette(TilesetEditor.this.palettes[n / 2]);
                        tilesetCheckBox.setEnabled(tilesetCheckBox.isSelected() || bl3);
                        ++n3;
                    }
                } else if (tileset instanceof LevelTileset) {
                    LevelTileset levelTileset = (LevelTileset)tileset;
                    if (bl) {
                        TilesetEditor.this.remove(this.val$southSpriteTileset);
                        TilesetEditor.this.add((Component)this.val$southLevelTileset, "South");
                    }
                    if (n != this.prevIndex) {
                        this.val$clearTiles.setPalette(TilesetEditor.this.palettes[n / 2]);
                    }
                    this.val$clearTiles.setSelected(levelTileset.hasClearTiles());
                    this.val$clearTiles.setEnabled(this.val$clearTiles.isSelected() && levelTileset.canRemoveClearTiles() || !this.val$clearTiles.isSelected() && MiracleWorldEditorModel.canAddClearTiles());
                    if (levelTileset.hasMainTileset() != this.prevHasMainTileset) {
                        this.val$mainTileset.remove(this.val$mainTilesetPanel);
                        this.val$mainTileset.remove(this.val$addMainTileset);
                        if (levelTileset.hasMainTileset()) {
                            this.val$mainTileset.add((Component)this.val$mainTilesetPanel, "South");
                        } else {
                            this.val$mainTileset.add(this.val$addMainTileset);
                        }
                        TilesetEditor.this.revalidate();
                        TilesetEditor.this.repaint();
                    }
                    this.val$addMainTileset.setEnabled(MiracleWorldEditorModel.canAddMainTileset());
                    this.val$removeMainTileset.setEnabled(levelTileset.canRemoveMainTileset());
                    this.prevHasMainTileset = levelTileset.hasMainTileset();
                    if (n != this.prevIndex) {
                        this.val$mainTilesetsComboBox.setTiles(TilesetEditor.this.levelMainTilesets, TilesetEditor.this.palettes[n / 2]);
                    }
                    if ((0x8000 | this.val$mainTilesetsComboBox.getSelectedTiles().getSource() & 0x3FFF) != levelTileset.getMainTilesetAddress()) {
                        this.val$mainTilesetsComboBox.setSelectedTiles(levelTileset.getMainTilesetAddress());
                    }
                    int[] nArray = levelTileset.getAdditionalTilesetAddresses();
                    boolean bl4 = MiracleWorldEditorModel.canAddAdditionalTileset() && nArray.length < 8;
                    int n4 = nArray.length;
                    boolean bl5 = bl4 != this.prevCanAdd || n4 != this.prevNumAdditionalTilesets;
                    this.prevCanAdd = bl4;
                    this.prevNumAdditionalTilesets = n4;
                    if (bl |= bl5) {
                        this.val$additionalTilesetsGrid.removeAll();
                        this.val$additionalTilesetsGrid.setLayout(new GridLayout(nArray.length + (bl4 ? 1 : 0), 1));
                    }
                    int n5 = 0;
                    while (n5 < nArray.length) {
                        if (n != this.prevIndex) {
                            this.val$additionalTilesetsComboBoxes[n5].setTiles(TilesetEditor.this.getAdditionalLevelTilesets(n5 >= nArray.length - 1), TilesetEditor.this.palettes[n / 2]);
                        }
                        this.val$additionalTilesetsComboBoxes[n5].setScaleParent(TilesetEditor.this.tileset);
                        if ((0x8000 | this.val$additionalTilesetsComboBoxes[n5].getSelectedTiles().getSource() & 0x3FFF) != nArray[n5]) {
                            this.val$additionalTilesetsComboBoxes[n5].setSelectedTiles(nArray[n5]);
                        }
                        if (bl) {
                            this.val$additionalTilesetsGrid.add(this.val$additionalTilesetsPanels[n5]);
                        }
                        ++n5;
                    }
                    if (bl && bl4) {
                        this.val$additionalTilesetsGrid.add(this.val$addAdditionalTileset);
                    }
                } else {
                    TilesetEditor.this.remove(this.val$southSpriteTileset);
                    TilesetEditor.this.remove(this.val$southLevelTileset);
                }
                if (n == 34) {
                    TilesetEditor.this.tileset.setTileset(TilesetEditor.this.tilesets[n], TilesetEditor.this.palettes[18]);
                } else {
                    TilesetEditor.this.tileset.setTileset(TilesetEditor.this.tilesets[n], TilesetEditor.this.palettes[n / 2]);
                }
                if (bl) {
                    TilesetEditor.this.pack();
                    TilesetEditor.this.repaint();
                }
                this.prevIndex = n;
                this.prevSelectedTileset = tileset;
            }
        });
        this.add(this.tilesetSelection, "North");
        this.add((Component)this.tileset, "Center");
        this.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                if (mouseWheelEvent.getUnitsToScroll() < 0) {
                    if (mouseWheelEvent.isAltDown()) {
                        float f = Math.max(1, (int)(TilesetEditor.this.tileset.getScale() + 1.5f));
                        TilesetEditor.this.tileset.setPreferredScale(f);
                        TilesetEditor.this.pack();
                    }
                } else if (mouseWheelEvent.getUnitsToScroll() > 0 && mouseWheelEvent.isAltDown()) {
                    float f = Math.max(1, (int)(TilesetEditor.this.tileset.getScale() - 0.5f));
                    TilesetEditor.this.tileset.setPreferredScale(f);
                    TilesetEditor.this.pack();
                }
                mouseWheelEvent.consume();
            }
        });
    }

    private JMenu makeMenuEdit() {
        JMenu jMenu = new JMenu(TextProvider.get("MenuEdit"));
        jMenu.setMnemonic('e');
        final MenuItem menuItem = new MenuItem(TextProvider.get("MenuUndo"), 117);
        jMenu.add(menuItem);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UndoRedoManager.getInstance().undo(TilesetEditor.this.tilesets[0]);
            }
        });
        menuItem.setAccelerator(KeyStroke.getKeyStroke(90, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        final MenuItem menuItem2 = new MenuItem(TextProvider.get("MenuRedo"), 114);
        jMenu.add(menuItem2);
        menuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UndoRedoManager.getInstance().redo(TilesetEditor.this.tilesets[0]);
            }
        });
        menuItem2.setAccelerator(KeyStroke.getKeyStroke(89, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        jMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent menuEvent) {
                menuItem.setEnabled(UndoRedoManager.getInstance().canUndo(TilesetEditor.this.tilesets[0]));
                menuItem2.setEnabled(UndoRedoManager.getInstance().canRedo(TilesetEditor.this.tilesets[0]));
            }

            @Override
            public void menuDeselected(MenuEvent menuEvent) {
                menuItem.setEnabled(true);
                menuItem2.setEnabled(true);
            }

            @Override
            public void menuCanceled(MenuEvent menuEvent) {
            }
        });
        return jMenu;
    }

    private List<Tiles> getAdditionalLevelTilesets(final boolean bl) {
        if (this.additionalTilesets[bl ? 1 : 0] == null) {
            this.additionalTilesets[bl ? 1 : 0] = new AbstractList<Tiles>(){

                @Override
                public Tiles get(int n) {
                    if (bl) {
                        Tiles tiles;
                        Tiles[] tilesArray = TilesetEditor.this.levelAdditionalTilesets;
                        int n2 = tilesArray.length;
                        int n3 = 0;
                        while (n3 < n2) {
                            tiles = tilesArray[n3];
                            if (tiles instanceof CompressedTiles && n-- == 0) {
                                return tiles;
                            }
                            ++n3;
                        }
                        tilesArray = TilesetEditor.this.levelMainTilesets;
                        n2 = tilesArray.length;
                        n3 = 0;
                        while (n3 < n2) {
                            tiles = tilesArray[n3];
                            if (tiles instanceof CompressedTiles && n-- == 0) {
                                return tiles;
                            }
                            ++n3;
                        }
                    }
                    return n < TilesetEditor.this.levelAdditionalTilesets.length ? TilesetEditor.this.levelAdditionalTilesets[n] : TilesetEditor.this.levelMainTilesets[n - TilesetEditor.this.levelAdditionalTilesets.length];
                }

                @Override
                public int size() {
                    if (bl) {
                        Tiles tiles;
                        int n = 0;
                        Tiles[] tilesArray = TilesetEditor.this.levelAdditionalTilesets;
                        int n2 = tilesArray.length;
                        int n3 = 0;
                        while (n3 < n2) {
                            tiles = tilesArray[n3];
                            if (tiles instanceof CompressedTiles) {
                                ++n;
                            }
                            ++n3;
                        }
                        tilesArray = TilesetEditor.this.levelMainTilesets;
                        n2 = tilesArray.length;
                        n3 = 0;
                        while (n3 < n2) {
                            tiles = tilesArray[n3];
                            if (tiles instanceof CompressedTiles) {
                                ++n;
                            }
                            ++n3;
                        }
                        return n;
                    }
                    return TilesetEditor.this.levelAdditionalTilesets.length + TilesetEditor.this.levelMainTilesets.length;
                }
            };
        }
        return this.additionalTilesets[bl ? 1 : 0];
    }

    public static void open(JFrame jFrame, Tileset[] tilesetArray, Tiles[] tilesArray, Tiles[] tilesArray2, SpriteTileset[] spriteTilesetArray, Palette[] paletteArray, int n, Properties properties) {
        if (editor == null) {
            editor = new TilesetEditor(tilesetArray, tilesArray, tilesArray2, spriteTilesetArray, paletteArray, n);
            try {
                editor.setLocation(properties.getInt("Window" + editor.getClass().getSimpleName() + "X"), properties.getInt("Window" + editor.getClass().getSimpleName() + "Y"));
            }
            catch (NumberFormatException numberFormatException) {
                editor.setLocationRelativeTo(jFrame);
            }
            try {
                editor.setSize(properties.getInt("Window" + editor.getClass().getSimpleName() + "Width"), properties.getInt("Window" + editor.getClass().getSimpleName() + "Height"));
            }
            catch (NumberFormatException numberFormatException) {
                editor.pack();
            }
        } else {
            TilesetEditor.editor.tilesets = tilesetArray;
            TilesetEditor.editor.levelMainTilesets = tilesArray;
            TilesetEditor.editor.levelAdditionalTilesets = tilesArray2;
            TilesetEditor.editor.palettes = paletteArray;
            TilesetEditor.editor.tilesetSelection.setSelectedIndex(n * 2);
        }
        if (ScreenUtilities.getScreen(editor) == null) {
            editor.setLocationRelativeTo(jFrame);
        }
        TilesetEditor.editor.tileset.setIntegerScaling(Boolean.parseBoolean(properties.getProperty("IntegerScaling")));
        editor.setVisible(true);
    }

    public static void close() {
        TilesetEditor.destroy();
    }

    public static void destroy() {
        if (editor != null) {
            editor.dispose();
        }
        editor = null;
    }

    public static void saveState(Properties properties) {
        if (editor != null) {
            properties.setProperty("Window" + editor.getClass().getSimpleName() + "Open", "" + editor.isVisible());
            properties.setProperty("Window" + editor.getClass().getSimpleName() + "X", "" + editor.getX());
            properties.setProperty("Window" + editor.getClass().getSimpleName() + "Y", "" + editor.getY());
            if (editor.isResizable()) {
                properties.setProperty("Window" + editor.getClass().getSimpleName() + "Width", "" + editor.getWidth());
                properties.setProperty("Window" + editor.getClass().getSimpleName() + "Height", "" + editor.getHeight());
            }
        }
    }
}

