/*
 * Decompiled with CFR 0.152.
 */
package editors;

import changes.Change;
import changes.ChangeListener;
import common.Properties;
import common.ScreenUtilities;
import data.MetaTileset;
import data.Palette;
import data.Riddle;
import data.Tiles;
import data.Tileset;
import editors.TextProvider;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import panels.MetaTilePanel;
import transactions.TransactionManager;

public class RiddleEditor
extends JDialog {
    private static RiddleEditor editor;
    private final MetaTilePanel[] metaTilePanels = new MetaTilePanel[10];
    private int selectedRiddlePiece;
    private int[] riddlePieces;
    private final int[] META_TILE;
    private Riddle riddle;
    private final ChangeListener riddleChangeListener;

    private RiddleEditor(Riddle riddle, Tiles tiles, MetaTileset metaTileset, Palette palette) {
        JComponent jComponent;
        JComponent jComponent2;
        int[] nArray = new int[6];
        nArray[1] = 5;
        nArray[2] = 7;
        nArray[3] = 4;
        nArray[4] = 6;
        nArray[5] = 9;
        this.META_TILE = nArray;
        this.riddleChangeListener = new ChangeListener(){

            @Override
            public void changeOccurred(Change change) {
                RiddleEditor.this.riddlePieces = RiddleEditor.this.riddle.getPieces();
                int n = 0;
                while (n < RiddleEditor.this.riddlePieces.length) {
                    RiddleEditor.this.metaTilePanels[n].setMetaTile(RiddleEditor.this.META_TILE[RiddleEditor.this.riddlePieces[n]]);
                    ++n;
                }
            }
        };
        this.setTitle(TextProvider.get("TitleRiddle"));
        this.riddle = riddle;
        riddle.addChangeListener(this.riddleChangeListener);
        Tileset tileset = new Tileset(tiles);
        this.setLayout(new BorderLayout());
        this.riddlePieces = riddle.getPieces();
        JPanel jPanel = new JPanel(new GridLayout(1, this.riddlePieces.length));
        this.add((Component)jPanel, "Center");
        int n = 0;
        while (n < this.riddlePieces.length) {
            jComponent2 = new JPanel(new BorderLayout());
            jComponent = new MetaTilePanel(this.META_TILE[this.riddlePieces[n]], metaTileset, tileset, palette);
            final int n2 = n++;
            this.metaTilePanels[n2] = jComponent;
            ((MetaTilePanel)jComponent).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    RiddleEditor.this.metaTilePanels[RiddleEditor.this.selectedRiddlePiece].setSelected(false);
                    RiddleEditor.this.selectedRiddlePiece = n2;
                    RiddleEditor.this.metaTilePanels[RiddleEditor.this.selectedRiddlePiece].setSelected(true);
                }
            });
            jComponent2.add((Component)jComponent, "Center");
            jComponent2.setBorder(BorderFactory.createEtchedBorder());
            jPanel.add(jComponent2);
        }
        this.selectedRiddlePiece = 0;
        this.metaTilePanels[this.selectedRiddlePiece].setSelected(true);
        jPanel.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ((RiddleEditor)RiddleEditor.this).riddlePieces[((RiddleEditor)RiddleEditor.this).selectedRiddlePiece] = RiddleEditor.this.riddlePieces[RiddleEditor.this.selectedRiddlePiece] % 5 + 1;
                if (RiddleEditor.this.selectedRiddlePiece > 0 && RiddleEditor.this.riddlePieces[RiddleEditor.this.selectedRiddlePiece - 1] == RiddleEditor.this.riddlePieces[RiddleEditor.this.selectedRiddlePiece] || RiddleEditor.this.selectedRiddlePiece < RiddleEditor.this.riddlePieces.length - 1 && RiddleEditor.this.riddlePieces[RiddleEditor.this.selectedRiddlePiece + 1] == RiddleEditor.this.riddlePieces[RiddleEditor.this.selectedRiddlePiece]) {
                    ((RiddleEditor)RiddleEditor.this).riddlePieces[((RiddleEditor)RiddleEditor.this).selectedRiddlePiece] = RiddleEditor.this.riddlePieces[RiddleEditor.this.selectedRiddlePiece] % 5 + 1;
                }
                RiddleEditor.this.metaTilePanels[RiddleEditor.this.selectedRiddlePiece].setMetaTile(RiddleEditor.this.META_TILE[RiddleEditor.this.riddlePieces[RiddleEditor.this.selectedRiddlePiece]]);
            }
        }, KeyStroke.getKeyStroke(38, 0), 2);
        jPanel.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ((RiddleEditor)RiddleEditor.this).riddlePieces[((RiddleEditor)RiddleEditor.this).selectedRiddlePiece] = (RiddleEditor.this.riddlePieces[RiddleEditor.this.selectedRiddlePiece] + 3) % 5 + 1;
                if (RiddleEditor.this.selectedRiddlePiece > 0 && RiddleEditor.this.riddlePieces[RiddleEditor.this.selectedRiddlePiece - 1] == RiddleEditor.this.riddlePieces[RiddleEditor.this.selectedRiddlePiece] || RiddleEditor.this.selectedRiddlePiece < RiddleEditor.this.riddlePieces.length - 1 && RiddleEditor.this.riddlePieces[RiddleEditor.this.selectedRiddlePiece + 1] == RiddleEditor.this.riddlePieces[RiddleEditor.this.selectedRiddlePiece]) {
                    ((RiddleEditor)RiddleEditor.this).riddlePieces[((RiddleEditor)RiddleEditor.this).selectedRiddlePiece] = (RiddleEditor.this.riddlePieces[RiddleEditor.this.selectedRiddlePiece] + 3) % 5 + 1;
                }
                RiddleEditor.this.metaTilePanels[RiddleEditor.this.selectedRiddlePiece].setMetaTile(RiddleEditor.this.META_TILE[RiddleEditor.this.riddlePieces[RiddleEditor.this.selectedRiddlePiece]]);
            }
        }, KeyStroke.getKeyStroke(40, 0), 2);
        jPanel.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (RiddleEditor.this.selectedRiddlePiece > 0) {
                    RiddleEditor.this.metaTilePanels[RiddleEditor.this.selectedRiddlePiece].setSelected(false);
                    RiddleEditor riddleEditor = RiddleEditor.this;
                    riddleEditor.selectedRiddlePiece = riddleEditor.selectedRiddlePiece - 1;
                    RiddleEditor.this.metaTilePanels[RiddleEditor.this.selectedRiddlePiece].setSelected(true);
                }
            }
        }, KeyStroke.getKeyStroke(37, 0), 2);
        jPanel.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (RiddleEditor.this.selectedRiddlePiece < RiddleEditor.this.metaTilePanels.length - 1) {
                    RiddleEditor.this.metaTilePanels[RiddleEditor.this.selectedRiddlePiece].setSelected(false);
                    RiddleEditor riddleEditor = RiddleEditor.this;
                    riddleEditor.selectedRiddlePiece = riddleEditor.selectedRiddlePiece + 1;
                    RiddleEditor.this.metaTilePanels[RiddleEditor.this.selectedRiddlePiece].setSelected(true);
                }
            }
        }, KeyStroke.getKeyStroke(39, 0), 2);
        this.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                if (mouseWheelEvent.getUnitsToScroll() < 0) {
                    ((RiddleEditor)RiddleEditor.this).riddlePieces[((RiddleEditor)RiddleEditor.this).selectedRiddlePiece] = RiddleEditor.this.riddlePieces[RiddleEditor.this.selectedRiddlePiece] % 5 + 1;
                    if (RiddleEditor.this.selectedRiddlePiece > 0 && RiddleEditor.this.riddlePieces[RiddleEditor.this.selectedRiddlePiece - 1] == RiddleEditor.this.riddlePieces[RiddleEditor.this.selectedRiddlePiece] || RiddleEditor.this.selectedRiddlePiece < RiddleEditor.this.riddlePieces.length - 1 && RiddleEditor.this.riddlePieces[RiddleEditor.this.selectedRiddlePiece + 1] == RiddleEditor.this.riddlePieces[RiddleEditor.this.selectedRiddlePiece]) {
                        ((RiddleEditor)RiddleEditor.this).riddlePieces[((RiddleEditor)RiddleEditor.this).selectedRiddlePiece] = RiddleEditor.this.riddlePieces[RiddleEditor.this.selectedRiddlePiece] % 5 + 1;
                    }
                    RiddleEditor.this.metaTilePanels[RiddleEditor.this.selectedRiddlePiece].setMetaTile(RiddleEditor.this.META_TILE[RiddleEditor.this.riddlePieces[RiddleEditor.this.selectedRiddlePiece]]);
                } else if (mouseWheelEvent.getUnitsToScroll() > 0) {
                    ((RiddleEditor)RiddleEditor.this).riddlePieces[((RiddleEditor)RiddleEditor.this).selectedRiddlePiece] = (RiddleEditor.this.riddlePieces[RiddleEditor.this.selectedRiddlePiece] + 3) % 5 + 1;
                    if (RiddleEditor.this.selectedRiddlePiece > 0 && RiddleEditor.this.riddlePieces[RiddleEditor.this.selectedRiddlePiece - 1] == RiddleEditor.this.riddlePieces[RiddleEditor.this.selectedRiddlePiece] || RiddleEditor.this.selectedRiddlePiece < RiddleEditor.this.riddlePieces.length - 1 && RiddleEditor.this.riddlePieces[RiddleEditor.this.selectedRiddlePiece + 1] == RiddleEditor.this.riddlePieces[RiddleEditor.this.selectedRiddlePiece]) {
                        ((RiddleEditor)RiddleEditor.this).riddlePieces[((RiddleEditor)RiddleEditor.this).selectedRiddlePiece] = (RiddleEditor.this.riddlePieces[RiddleEditor.this.selectedRiddlePiece] + 3) % 5 + 1;
                    }
                    RiddleEditor.this.metaTilePanels[RiddleEditor.this.selectedRiddlePiece].setMetaTile(RiddleEditor.this.META_TILE[RiddleEditor.this.riddlePieces[RiddleEditor.this.selectedRiddlePiece]]);
                }
                mouseWheelEvent.consume();
            }
        });
        JPanel jPanel2 = new JPanel(new FlowLayout());
        jComponent2 = new JButton(TextProvider.get("ButtonOK"));
        ((AbstractButton)jComponent2).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TransactionManager.getInstance().runTransaction(new Runnable(){

                    @Override
                    public void run() {
                        RiddleEditor.this.riddle.setPieces(RiddleEditor.this.riddlePieces);
                    }
                });
                RiddleEditor.this.setVisible(false);
            }
        });
        jComponent = new JButton(TextProvider.get("ButtonCancel"));
        ((AbstractButton)jComponent).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RiddleEditor.this.setVisible(false);
            }
        });
        jPanel2.add(jComponent2);
        jPanel2.add(jComponent);
        this.add((Component)jPanel2, "South");
        this.setResizable(false);
    }

    public static void open(JFrame jFrame, Riddle riddle, Tiles tiles, MetaTileset metaTileset, Palette palette, Properties properties) {
        if (editor == null) {
            editor = new RiddleEditor(riddle, tiles, metaTileset, palette);
            try {
                editor.setLocation(properties.getInt("Window" + editor.getClass().getSimpleName() + "X"), properties.getInt("Window" + editor.getClass().getSimpleName() + "Y"));
            }
            catch (NumberFormatException numberFormatException) {
                editor.setLocationRelativeTo(jFrame);
            }
            try {
                editor.setSize(properties.getInt("Window" + editor.getClass().getSimpleName() + "Width"), properties.getInt("Window" + editor.getClass().getSimpleName() + "Height"));
            }
            catch (NumberFormatException numberFormatException) {
                editor.pack();
            }
        } else {
            if (RiddleEditor.editor.riddle != null && RiddleEditor.editor.riddle != riddle) {
                RiddleEditor.editor.riddle.removeChangeListener(RiddleEditor.editor.riddleChangeListener);
            }
            RiddleEditor.editor.riddle = riddle;
            riddle.addChangeListener(RiddleEditor.editor.riddleChangeListener);
            RiddleEditor.editor.riddlePieces = riddle.getPieces();
            int n = 0;
            while (n < RiddleEditor.editor.riddlePieces.length) {
                RiddleEditor.editor.metaTilePanels[n].setMetaTile(RiddleEditor.editor.META_TILE[RiddleEditor.editor.riddlePieces[n]]);
                ++n;
            }
        }
        if (ScreenUtilities.getScreen(editor) == null) {
            editor.setLocationRelativeTo(jFrame);
        }
        editor.setVisible(true);
    }

    public static void close() {
        if (editor != null) {
            editor.setVisible(false);
        }
    }

    public static void destroy() {
        if (editor != null) {
            editor.dispose();
        }
        editor = null;
    }

    public static void saveState(Properties properties) {
        if (editor != null) {
            properties.setProperty("Window" + editor.getClass().getSimpleName() + "Open", "" + editor.isVisible());
            properties.setProperty("Window" + editor.getClass().getSimpleName() + "X", "" + editor.getX());
            properties.setProperty("Window" + editor.getClass().getSimpleName() + "Y", "" + editor.getY());
            if (editor.isResizable()) {
                properties.setProperty("Window" + editor.getClass().getSimpleName() + "Width", "" + editor.getWidth());
                properties.setProperty("Window" + editor.getClass().getSimpleName() + "Height", "" + editor.getHeight());
            }
        }
    }
}

