/*
 * Decompiled with CFR 0.152.
 */
package editors;

import changes.Change;
import changes.ChangeListener;
import common.ComponentWrapper;
import common.Properties;
import common.ScreenUtilities;
import data.Physics;
import editors.TextProvider;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import transactions.TransactionManager;
import widgets.IntegerTextField;

public class PhysicsEditor
extends JDialog {
    private static final NumberFormat FORMAT_FIXED_POINT = NumberFormat.getNumberInstance(Locale.US);
    private final ChangeListener changeListener = new ChangeListener(){

        @Override
        public void changeOccurred(Change change) {
            for (PhysicsTextField physicsTextField : PhysicsEditor.this.textFields) {
                physicsTextField.reloadValue();
            }
        }
    };
    private static PhysicsEditor editor;
    private static Properties properties;
    private Physics physics;
    private final List<PhysicsTextField> textFields = new ArrayList<PhysicsTextField>();

    static {
        FORMAT_FIXED_POINT.setMinimumFractionDigits(1);
        FORMAT_FIXED_POINT.setMaximumFractionDigits(8);
    }

    private PhysicsEditor(Physics physics) {
        this.setTitle(TextProvider.get("TitlePhysics"));
        this.physics = physics;
        physics.addChangeListener(this.changeListener);
        this.setLayout(new BorderLayout());
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.add(TextProvider.get("AlexKidd"), PhysicsEditor.createPhysicsTab(this.makePanelAlexKidd(this.textFields)));
        jTabbedPane.add(TextProvider.get("Vehicles"), PhysicsEditor.createPhysicsTab(this.makePanelVehicles(this.textFields)));
        jTabbedPane.add(TextProvider.get("Enemies"), PhysicsEditor.createPhysicsTab(this.makePanelEnemies(this.textFields)));
        jTabbedPane.add(TextProvider.get("Missiles"), PhysicsEditor.createPhysicsTab(this.makePanelMissiles(this.textFields)));
        this.add((Component)jTabbedPane, "Center");
        JPanel jPanel = new JPanel(new GridLayout(1, 3));
        JPanel jPanel2 = new JPanel();
        jPanel.add(new JLabel());
        jPanel.add(jPanel2);
        jPanel.add(new JLabel("256 spx = 1 px"));
        JButton jButton = new JButton(TextProvider.get("ButtonOK"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TransactionManager.getInstance().runTransaction(new Runnable(){

                    @Override
                    public void run() {
                        TransactionManager.getInstance().runTransaction(new Runnable(){

                            @Override
                            public void run() {
                                for (PhysicsTextField physicsTextField : PhysicsEditor.this.textFields) {
                                    physicsTextField.writeValue();
                                }
                            }
                        });
                        PhysicsEditor.this.setVisible(false);
                    }
                });
            }
        });
        JButton jButton2 = new JButton(TextProvider.get("ButtonCancel"));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PhysicsEditor.this.setVisible(false);
            }
        });
        jPanel2.add(jButton);
        jPanel2.add(jButton2);
        this.add((Component)jPanel, "South");
        this.getRootPane().setDefaultButton(jButton);
        JMenuBar jMenuBar = new JMenuBar();
        this.setJMenuBar(jMenuBar);
        jMenuBar.add(this.makeMenuView());
    }

    private JMenu makeMenuView() {
        JMenu jMenu = new JMenu(TextProvider.get("MenuView"));
        jMenu.setMnemonic('v');
        jMenu.add(this.makeMenuUnits());
        return jMenu;
    }

    private JMenu makeMenuUnits() {
        JMenu jMenu = new JMenu(TextProvider.get("MenuUnits"));
        jMenu.setMnemonic('u');
        final JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(String.valueOf(TextProvider.get("MenuSubpixelsPerFrame")) + " (spx)", properties.getInt("PhysicsUnit") == 0);
        jCheckBoxMenuItem.setMnemonic('s');
        jMenu.add(jCheckBoxMenuItem);
        jCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                properties.setProperty("PhysicsUnit", "0");
                PhysicsEditor.this.updateDocuments();
            }
        });
        final JCheckBoxMenuItem jCheckBoxMenuItem2 = new JCheckBoxMenuItem(String.valueOf(TextProvider.get("MenuPixelsPerFrame")) + " (px)", properties.getInt("PhysicsUnit") == 1);
        jCheckBoxMenuItem2.setMnemonic('p');
        jMenu.add(jCheckBoxMenuItem2);
        jCheckBoxMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                properties.setProperty("PhysicsUnit", "1");
                PhysicsEditor.this.updateDocuments();
            }
        });
        jMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent menuEvent) {
                jCheckBoxMenuItem.setSelected(properties.getInt("PhysicsUnit") == 0);
                jCheckBoxMenuItem2.setSelected(properties.getInt("PhysicsUnit") == 1);
            }

            @Override
            public void menuDeselected(MenuEvent menuEvent) {
            }

            @Override
            public void menuCanceled(MenuEvent menuEvent) {
            }
        });
        return jMenu;
    }

    private void updateDocuments() {
        for (PhysicsTextField physicsTextField : this.textFields) {
            physicsTextField.updateDocument();
        }
    }

    private JPanel makePanelAlexKidd(List<PhysicsTextField> list) {
        JPanel jPanel;
        JPanel jPanel2 = jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)ComponentWrapper.wrapComponent(this.makePanelAlexKiddWalking(list)), "North");
        jPanel2 = PhysicsEditor.addPanel(jPanel2, this.makePanelAlexKiddSquatting(list));
        jPanel2 = PhysicsEditor.addPanel(jPanel2, this.makePanelAlexKiddAirborne(list));
        jPanel2 = PhysicsEditor.addPanel(jPanel2, this.makePanelAlexKiddSwimming(list));
        return ComponentWrapper.wrapComponent(jPanel);
    }

    private JPanel makePanelAlexKiddWalking(List<PhysicsTextField> list) {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(TextProvider.get("Walking")));
        JPanel jPanel2 = new JPanel(new GridLayout(4, 1, 4, 4));
        jPanel.add((Component)jPanel2, "West");
        jPanel2.setBorder(BorderFactory.createTitledBorder(String.valueOf(TextProvider.get("Walking")) + " " + TextProvider.get("Left")));
        jPanel2.add(this.createPhysicsPanel(String.valueOf(TextProvider.get("Acceleration")) + ":", Physics.AlexPhysics.WALKING_LEFT_ACCELERATION, list));
        jPanel2.add(this.createPhysicsPanel(String.valueOf(TextProvider.get("MaxVelocity")) + ":", Physics.AlexPhysics.WALKING_LEFT_MAX_VELOCITY, list));
        jPanel2.add(this.createPhysicsPanel(String.valueOf(TextProvider.get("Deceleration")) + ":", Physics.AlexPhysics.WALKING_LEFT_DECELERATION, list));
        jPanel2.add(this.createPhysicsPanel(String.valueOf(TextProvider.get("OppositeAcceleration")) + ":", Physics.AlexPhysics.WALKING_LEFT_OPPOSITE_ACCELERATION, list));
        JPanel jPanel3 = new JPanel(new GridLayout(4, 1, 4, 4));
        jPanel.add((Component)jPanel3, "East");
        jPanel3.setBorder(BorderFactory.createTitledBorder(String.valueOf(TextProvider.get("Walking")) + " " + TextProvider.get("Right")));
        jPanel3.add(this.createPhysicsPanel(String.valueOf(TextProvider.get("Acceleration")) + ":", Physics.AlexPhysics.WALKING_RIGHT_ACCELERATION, list));
        jPanel3.add(this.createPhysicsPanel(String.valueOf(TextProvider.get("MaxVelocity")) + ":", Physics.AlexPhysics.WALKING_RIGHT_MAX_VELOCITY, list));
        jPanel3.add(this.createPhysicsPanel(String.valueOf(TextProvider.get("Deceleration")) + ":", Physics.AlexPhysics.WALKING_RIGHT_DECELERATION, list));
        jPanel3.add(this.createPhysicsPanel(String.valueOf(TextProvider.get("OppositeAcceleration")) + ":", Physics.AlexPhysics.WALKING_RIGHT_OPPOSITE_ACCELERATION, list));
        return jPanel;
    }

    private JPanel makePanelAlexKiddAirborne(List<PhysicsTextField> list) {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(TextProvider.get("Airborne")));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel.add((Component)ComponentWrapper.wrapComponent(jPanel2), "North");
        JPanel jPanel3 = new JPanel(new GridLayout(3, 1, 4, 4));
        jPanel2.add((Component)jPanel3, "West");
        jPanel3.setBorder(BorderFactory.createTitledBorder(String.valueOf(TextProvider.get("Airborne")) + " " + TextProvider.get("Left")));
        jPanel3.add(this.createPhysicsPanel(String.valueOf(TextProvider.get("Acceleration")) + ":", Physics.AlexPhysics.AIRBORNE_LEFT_ACCELERATION, list));
        jPanel3.add(this.createPhysicsPanel(String.valueOf(TextProvider.get("MaxVelocity")) + ":", Physics.AlexPhysics.AIRBORNE_LEFT_MAX_VELOCITY, list));
        jPanel3.add(this.createPhysicsPanel(String.valueOf(TextProvider.get("Deceleration")) + ":", Physics.AlexPhysics.AIRBORNE_LEFT_DECELERATION, list));
        JPanel jPanel4 = new JPanel(new GridLayout(3, 1, 4, 4));
        jPanel2.add((Component)jPanel4, "East");
        jPanel4.setBorder(BorderFactory.createTitledBorder(String.valueOf(TextProvider.get("Airborne")) + " " + TextProvider.get("Right")));
        jPanel4.add(this.createPhysicsPanel(String.valueOf(TextProvider.get("Acceleration")) + ":", Physics.AlexPhysics.AIRBORNE_RIGHT_ACCELERATION, list));
        jPanel4.add(this.createPhysicsPanel(String.valueOf(TextProvider.get("MaxVelocity")) + ":", Physics.AlexPhysics.AIRBORNE_RIGHT_MAX_VELOCITY, list));
        jPanel4.add(this.createPhysicsPanel(String.valueOf(TextProvider.get("Deceleration")) + ":", Physics.AlexPhysics.AIRBORNE_RIGHT_DECELERATION, list));
        JPanel jPanel5 = new JPanel(new GridLayout(1, 2, 4, 4));
        jPanel.add((Component)ComponentWrapper.wrapComponent(jPanel5), "South");
        jPanel5.add(this.createPhysicsPanel(String.valueOf(TextProvider.get("Jump")) + " " + TextProvider.get("Duration") + ":", Physics.AlexPhysics.JUMP_DURATION, list));
        jPanel5.add(this.createPhysicsPanel(String.valueOf(TextProvider.get("Gravity")) + ":", Physics.AlexPhysics.GRAVITY, list));
        return jPanel;
    }

    private JPanel makePanelAlexKiddSquatting(List<PhysicsTextField> list) {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(TextProvider.get("Squatting")));
        JPanel jPanel2 = new JPanel(new GridLayout(2, 1, 4, 4));
        jPanel.add((Component)jPanel2, "West");
        jPanel2.setBorder(BorderFactory.createTitledBorder(String.valueOf(TextProvider.get("Squatting")) + " " + TextProvider.get("Left")));
        jPanel2.add(this.createPhysicsPanel(String.valueOf(TextProvider.get("MaxVelocity")) + ":", Physics.AlexPhysics.SQUAT_LEFT_MAX_VELOCITY, list));
        jPanel2.add(this.createPhysicsPanel(String.valueOf(TextProvider.get("Deceleration")) + ":", Physics.AlexPhysics.SQUAT_LEFT_DECELERATION, list));
        JPanel jPanel3 = new JPanel(new GridLayout(2, 1, 4, 4));
        jPanel.add((Component)jPanel3, "East");
        jPanel3.setBorder(BorderFactory.createTitledBorder(String.valueOf(TextProvider.get("Squatting")) + " " + TextProvider.get("Right")));
        jPanel3.add(this.createPhysicsPanel(String.valueOf(TextProvider.get("MaxVelocity")) + ":", Physics.AlexPhysics.SQUAT_RIGHT_MAX_VELOCITY, list));
        jPanel3.add(this.createPhysicsPanel(String.valueOf(TextProvider.get("Deceleration")) + ":", Physics.AlexPhysics.SQUAT_RIGHT_DECELERATION, list));
        return jPanel;
    }

    private JPanel makePanelAlexKiddSwimming(List<PhysicsTextField> list) {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(TextProvider.get("Swimming")));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel.add((Component)ComponentWrapper.wrapComponent(jPanel2), "North");
        JPanel jPanel3 = new JPanel(new GridLayout(6, 1, 4, 4));
        jPanel2.add((Component)jPanel3, "West");
        jPanel3.setBorder(BorderFactory.createTitledBorder(String.valueOf(TextProvider.get("Swimming")) + " " + TextProvider.get("Left")));
        jPanel3.add(this.createPhysicsPanel(String.valueOf(TextProvider.get("Acceleration")) + ":", Physics.AlexPhysics.SWIMMING_LEFT_ACCELERATION, list));
        jPanel3.add(this.createPhysicsPanel(String.valueOf(TextProvider.get("MaxVelocity")) + ":", Physics.AlexPhysics.SWIMMING_LEFT_MAX_VELOCITY, list));
        jPanel3.add(this.createPhysicsPanel(String.valueOf(TextProvider.get("OppositeAcceleration")) + ":", Physics.AlexPhysics.SWIMMING_LEFT_OPPOSITE_ACCELERATION, list));
        jPanel3.add(this.createPhysicsPanel(String.valueOf(TextProvider.get("Fast")) + " " + TextProvider.get("Acceleration") + ":", Physics.AlexPhysics.SWIMMING_LEFT_FAST_ACCELERATION, list));
        jPanel3.add(this.createPhysicsPanel(String.valueOf(TextProvider.get("Fast")) + " " + TextProvider.get("MaxVelocity") + ":", Physics.AlexPhysics.SWIMMING_LEFT_FAST_MAX_VELOCITY, list));
        jPanel3.add(this.createPhysicsPanel(String.valueOf(TextProvider.get("Fast")) + " " + TextProvider.get("OppositeAcceleration") + ":", Physics.AlexPhysics.SWIMMING_LEFT_FAST_OPPOSITE_ACCELERATION, list));
        JPanel jPanel4 = new JPanel(new GridLayout(6, 1, 4, 4));
        jPanel2.add((Component)jPanel4, "East");
        jPanel4.setBorder(BorderFactory.createTitledBorder(String.valueOf(TextProvider.get("Swimming")) + " " + TextProvider.get("Right")));
        jPanel4.add(this.createPhysicsPanel(String.valueOf(TextProvider.get("Acceleration")) + ":", Physics.AlexPhysics.SWIMMING_RIGHT_ACCELERATION, list));
        jPanel4.add(this.createPhysicsPanel(String.valueOf(TextProvider.get("MaxVelocity")) + ":", Physics.AlexPhysics.SWIMMING_RIGHT_MAX_VELOCITY, list));
        jPanel4.add(new JLabel());
        jPanel4.add(this.createPhysicsPanel(String.valueOf(TextProvider.get("Fast")) + " " + TextProvider.get("Acceleration") + ":", Physics.AlexPhysics.SWIMMING_RIGHT_FAST_ACCELERATION, list));
        jPanel4.add(this.createPhysicsPanel(String.valueOf(TextProvider.get("Fast")) + " " + TextProvider.get("MaxVelocity") + ":", Physics.AlexPhysics.SWIMMING_RIGHT_FAST_MAX_VELOCITY, list));
        jPanel4.add(new JLabel());
        JPanel jPanel5 = new JPanel(new GridLayout(4, 2, 4, 4));
        jPanel.add((Component)ComponentWrapper.wrapComponent(jPanel5), "Center");
        jPanel5.add(this.createPhysicsPanel(String.valueOf(TextProvider.get("Acceleration")) + " " + TextProvider.get("Up") + ":", Physics.AlexPhysics.SWIMMING_UP_ACCELERATION, list));
        jPanel5.add(this.createPhysicsPanel(String.valueOf(TextProvider.get("MaxVelocity")) + " " + TextProvider.get("Up") + ":", Physics.AlexPhysics.SWIMMING_UP_MAX_VELOCITY, list));
        jPanel5.add(this.createPhysicsPanel(String.valueOf(TextProvider.get("Acceleration")) + " " + TextProvider.get("Down") + ":", Physics.AlexPhysics.SWIMMING_DOWN_ACCELERATION, list));
        jPanel5.add(this.createPhysicsPanel(String.valueOf(TextProvider.get("MaxVelocity")) + " " + TextProvider.get("Down") + ":", Physics.AlexPhysics.SWIMMING_DOWN_MAX_VELOCITY, list));
        jPanel5.add(this.createPhysicsPanel(String.valueOf(TextProvider.get("Buoyancy")) + ":", Physics.AlexPhysics.SWIMMING_BUOYANCY, list));
        jPanel5.add(this.createPhysicsPanel(String.valueOf(TextProvider.get("Buoyancy")) + " " + TextProvider.get("MaxVelocity") + ":", Physics.AlexPhysics.SWIMMING_BUOYANCY_MAX_VELOCITY, list));
        jPanel5.add(this.createPhysicsPanel(String.valueOf(TextProvider.get("WaterSurfaceDeceleration")) + ":", Physics.AlexPhysics.WATER_SURFACE_DECELERATION, list));
        jPanel5.add(this.createPhysicsPanel(String.valueOf(TextProvider.get("WaterSurfaceDeceleration")) + " " + TextProvider.get("Fast") + ":", Physics.AlexPhysics.WATER_SURFACE_DECELERATION_FAST, list));
        return jPanel;
    }

    private JPanel makePanelVehicles(List<PhysicsTextField> list) {
        JPanel jPanel;
        JPanel jPanel2 = jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)ComponentWrapper.wrapComponent(this.makePanelAlexKiddMotorcycle(list)), "North");
        jPanel2 = PhysicsEditor.addPanel(jPanel2, this.makePanelAlexKiddPeticopter(list));
        jPanel2 = PhysicsEditor.addPanel(jPanel2, this.makePanelAlexKiddBoat(list));
        return ComponentWrapper.wrapComponent(jPanel);
    }

    private JPanel makePanelAlexKiddMotorcycle(List<PhysicsTextField> list) {
        JPanel jPanel = new JPanel(new GridLayout(2, 2, 4, 4));
        jPanel.setBorder(BorderFactory.createTitledBorder(TextProvider.get("Motorcycle")));
        jPanel.add(this.createPhysicsPanel(String.valueOf(TextProvider.get("Acceleration")) + ":", Physics.AlexPhysics.MOTORCYCLE_ACCELERATION, list));
        jPanel.add(this.createPhysicsPanel(String.valueOf(TextProvider.get("MaxVelocity")) + ":", Physics.AlexPhysics.MOTORCYCLE_MAX_VELOCITY, list));
        jPanel.add(this.createPhysicsPanel(String.valueOf(TextProvider.get("Deceleration")) + ":", Physics.AlexPhysics.MOTORCYCLE_DECELERATION, list));
        jPanel.add(this.createPhysicsPanel(String.valueOf(TextProvider.get("MinVelocity")) + ":", Physics.AlexPhysics.MOTORCYCLE_MIN_VELOCITY, list));
        return jPanel;
    }

    private JPanel makePanelAlexKiddPeticopter(List<PhysicsTextField> list) {
        JPanel jPanel = new JPanel(new GridLayout(2, 1, 4, 4));
        jPanel.setBorder(BorderFactory.createTitledBorder(TextProvider.get("Peticopter")));
        jPanel.add(this.createPhysicsPanel(String.valueOf(TextProvider.get("Peticopter")) + " " + TextProvider.get("Up") + ":", Physics.AlexPhysics.PETICOPTER_UP, list));
        jPanel.add(this.createPhysicsPanel(String.valueOf(TextProvider.get("Peticopter")) + " " + TextProvider.get("Down") + ":", Physics.AlexPhysics.PETICOPTER_DOWN, list));
        jPanel.add(this.createPhysicsPanel(String.valueOf(TextProvider.get("Peticopter")) + " " + TextProvider.get("Left") + ":", Physics.AlexPhysics.PETICOPTER_LEFT, list));
        jPanel.add(this.createPhysicsPanel(String.valueOf(TextProvider.get("Peticopter")) + " " + TextProvider.get("Right") + ":", Physics.AlexPhysics.PETICOPTER_RIGHT, list));
        return jPanel;
    }

    private JPanel makePanelAlexKiddBoat(List<PhysicsTextField> list) {
        JPanel jPanel = new JPanel(new GridLayout(2, 2, 4, 4));
        jPanel.setBorder(BorderFactory.createTitledBorder(TextProvider.get("Boat")));
        jPanel.add(this.createPhysicsPanel(String.valueOf(TextProvider.get("Acceleration")) + ":", Physics.AlexPhysics.BOAT_ACCELERATION, list));
        jPanel.add(this.createPhysicsPanel(String.valueOf(TextProvider.get("MaxVelocity")) + ":", Physics.AlexPhysics.BOAT_MAX_VELOCITY, list));
        jPanel.add(this.createPhysicsPanel(String.valueOf(TextProvider.get("Deceleration")) + ":", Physics.AlexPhysics.BOAT_DECELERATION, list));
        jPanel.add(this.createPhysicsPanel(String.valueOf(TextProvider.get("MinVelocity")) + ":", Physics.AlexPhysics.BOAT_MIN_VELOCITY, list));
        return jPanel;
    }

    private JPanel makePanelEnemies(List<PhysicsTextField> list) {
        JPanel jPanel;
        JPanel jPanel2 = jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)ComponentWrapper.wrapComponent(this.makePanelMonsterBird(list)), "North");
        jPanel2 = PhysicsEditor.addPanel(jPanel2, this.makePanelSmallPoisonousFish(list));
        jPanel2 = PhysicsEditor.addPanel(jPanel2, this.makePanelMerman(list));
        jPanel2 = PhysicsEditor.addPanel(jPanel2, this.makePanelKillerFish(list));
        jPanel2 = PhysicsEditor.addPanel(jPanel2, this.makePanelScorpionAndFlame(list));
        jPanel2 = PhysicsEditor.addPanel(jPanel2, this.makePanelMonsterFrog(list));
        jPanel2 = PhysicsEditor.addPanel(jPanel2, this.makePanelSeahorse(list));
        jPanel2 = PhysicsEditor.addPanel(jPanel2, this.makePanelVine(list));
        jPanel2 = PhysicsEditor.addPanel(jPanel2, this.makePanelFlyingFish(list));
        jPanel2 = PhysicsEditor.addPanel(jPanel2, this.makePanelHopper(list));
        jPanel2 = PhysicsEditor.addPanel(jPanel2, this.makePanelRollingRock(list));
        jPanel2 = PhysicsEditor.addPanel(jPanel2, this.makePanelBat(list));
        jPanel2 = PhysicsEditor.addPanel(jPanel2, this.makePanelCirclingFlame(list));
        jPanel2 = PhysicsEditor.addPanel(jPanel2, this.makePanelMonkey(list));
        jPanel2 = PhysicsEditor.addPanel(jPanel2, this.makePanelLightningCloud(list));
        jPanel2 = PhysicsEditor.addPanel(jPanel2, this.makePanelOx(list));
        return ComponentWrapper.wrapComponent(jPanel);
    }

    private JPanel makePanelHopper(List<PhysicsTextField> list) {
        JPanel jPanel = new JPanel(new GridLayout(2, 2, 4, 4));
        jPanel.setBorder(BorderFactory.createTitledBorder(TextProvider.get("Hopper")));
        jPanel.add(this.createPhysicsPanel(String.valueOf(TextProvider.get("InitialJumpVelocity")) + ":", Physics.HopperPhysics.INITIAL_JUMP_VELOCITY, list));
        jPanel.add(this.createPhysicsPanel(String.valueOf(TextProvider.get("JumpVelocity")) + ":", Physics.HopperPhysics.JUMP_VELOCITY, list));
        jPanel.add(this.createPhysicsPanel(String.valueOf(TextProvider.get("HorizontalVelocity")) + ":", Physics.HopperPhysics.HORIZONTAL_VELOCITY, list));
        jPanel.add(this.createPhysicsPanel(String.valueOf(TextProvider.get("Gravity")) + ":", Physics.HopperPhysics.GRAVITY, list));
        return jPanel;
    }

    private JPanel makePanelFlyingFish(List<PhysicsTextField> list) {
        JPanel jPanel = new JPanel(new GridLayout(2, 2, 4, 4));
        jPanel.setBorder(BorderFactory.createTitledBorder(TextProvider.get("FlyingFish")));
        jPanel.add(this.createPhysicsPanel(String.valueOf(TextProvider.get("JumpVelocity")) + ":", Physics.FlyingFishPhysics.JUMP_VELOCITY, list));
        jPanel.add(this.createPhysicsPanel(String.valueOf(TextProvider.get("HorizontalVelocity")) + ":", Physics.FlyingFishPhysics.HORIZONTAL_VELOCITY, list));
        jPanel.add(this.createPhysicsPanel(String.valueOf(TextProvider.get("Gravity")) + " 1:", Physics.FlyingFishPhysics.GRAVITY1, list));
        jPanel.add(this.createPhysicsPanel(String.valueOf(TextProvider.get("Gravity")) + " 2:", Physics.FlyingFishPhysics.GRAVITY2, list));
        return jPanel;
    }

    private JPanel makePanelVine(List<PhysicsTextField> list) {
        JPanel jPanel = new JPanel(new GridLayout(1, 2, 4, 4));
        jPanel.setBorder(BorderFactory.createTitledBorder(TextProvider.get("Vine")));
        jPanel.add(this.createPhysicsPanel(String.valueOf(TextProvider.get("VerticalVelocity")) + ":", Physics.VinePhysics.VERTICAL_VELOCITY, list));
        jPanel.add(this.createPhysicsPanel(String.valueOf(TextProvider.get("Duration")) + ":", Physics.VinePhysics.DURATION, list));
        return jPanel;
    }

    private JPanel makePanelMonsterFrog(List<PhysicsTextField> list) {
        JPanel jPanel = new JPanel(new GridLayout(1, 2, 4, 4));
        jPanel.setBorder(BorderFactory.createTitledBorder(TextProvider.get("MonsterFrog")));
        jPanel.add(this.createPhysicsPanel(String.valueOf(TextProvider.get("JumpVelocity")) + ":", Physics.MonsterFrogPhysics.JUMP_VELOCITY, list));
        jPanel.add(this.createPhysicsPanel(String.valueOf(TextProvider.get("Gravity")) + ":", Physics.MonsterFrogPhysics.GRAVITY, list));
        return jPanel;
    }

    private JPanel makePanelRollingRock(List<PhysicsTextField> list) {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(TextProvider.get("RollingRock")));
        JPanel jPanel2 = new JPanel(new GridLayout(1, 2, 4, 4));
        jPanel.add((Component)ComponentWrapper.wrapComponent(jPanel2), "North");
        jPanel2.add(this.createPhysicsPanel(String.valueOf(TextProvider.get("LeftVelocity")) + ":", Physics.RollingRockPhysics.LEFT_VELOCITY, list));
        jPanel2.add(this.createPhysicsPanel(String.valueOf(TextProvider.get("RightVelocity")) + ":", Physics.RollingRockPhysics.RIGHT_VELOCITY, list));
        JPanel jPanel3 = new JPanel(new GridLayout(1, 1, 4, 4));
        jPanel.add((Component)ComponentWrapper.wrapComponent(jPanel3), "South");
        jPanel3.add(this.createPhysicsPanel(String.valueOf(TextProvider.get("Gravity")) + ":", Physics.RollingRockPhysics.GRAVITY, list));
        return jPanel;
    }

    private JPanel makePanelMonsterBird(List<PhysicsTextField> list) {
        JPanel jPanel = new JPanel(new GridLayout(1, 2, 4, 4));
        jPanel.setBorder(BorderFactory.createTitledBorder(TextProvider.get("MonsterBird")));
        jPanel.add(this.createPhysicsPanel(String.valueOf(TextProvider.get("LeftVelocity")) + ":", Physics.MonsterBirdPhysics.LEFT_VELOCITY, list));
        jPanel.add(this.createPhysicsPanel(String.valueOf(TextProvider.get("RightVelocity")) + ":", Physics.MonsterBirdPhysics.RIGHT_VELOCITY, list));
        return jPanel;
    }

    private JPanel makePanelScorpionAndFlame(List<PhysicsTextField> list) {
        JPanel jPanel = new JPanel(new GridLayout(1, 2, 4, 4));
        jPanel.setBorder(BorderFactory.createTitledBorder(String.valueOf(TextProvider.get("Scorpion")) + " / " + TextProvider.get("Flame")));
        jPanel.add(this.createPhysicsPanel(String.valueOf(TextProvider.get("LeftVelocity")) + ":", Physics.ScorpionAndFlamePhysics.LEFT_VELOCITY, list));
        jPanel.add(this.createPhysicsPanel(String.valueOf(TextProvider.get("RightVelocity")) + ":", Physics.ScorpionAndFlamePhysics.RIGHT_VELOCITY, list));
        return jPanel;
    }

    private JPanel makePanelSmallPoisonousFish(List<PhysicsTextField> list) {
        JPanel jPanel = new JPanel(new GridLayout(1, 2, 4, 4));
        jPanel.setBorder(BorderFactory.createTitledBorder(TextProvider.get("SmallPoisonousFish")));
        jPanel.add(this.createPhysicsPanel(String.valueOf(TextProvider.get("LeftVelocity")) + ":", Physics.SmallPoisonousFishPhysics.LEFT_VELOCITY, list));
        jPanel.add(this.createPhysicsPanel(String.valueOf(TextProvider.get("RightVelocity")) + ":", Physics.SmallPoisonousFishPhysics.RIGHT_VELOCITY, list));
        return jPanel;
    }

    private JPanel makePanelKillerFish(List<PhysicsTextField> list) {
        JPanel jPanel = new JPanel(new GridLayout(1, 2, 4, 4));
        jPanel.setBorder(BorderFactory.createTitledBorder(TextProvider.get("KillerFish")));
        jPanel.add(this.createPhysicsPanel(String.valueOf(TextProvider.get("LeftVelocity")) + ":", Physics.KillerFishPhysics.LEFT_VELOCITY, list));
        jPanel.add(this.createPhysicsPanel(String.valueOf(TextProvider.get("RightVelocity")) + ":", Physics.KillerFishPhysics.RIGHT_VELOCITY, list));
        return jPanel;
    }

    private JPanel makePanelBat(List<PhysicsTextField> list) {
        JPanel jPanel = new JPanel(new GridLayout(1, 2, 4, 4));
        jPanel.setBorder(BorderFactory.createTitledBorder(TextProvider.get("Bat")));
        jPanel.add(this.createPhysicsPanel(String.valueOf(TextProvider.get("LeftVelocity")) + ":", Physics.BatPhysics.LEFT_VELOCITY, list));
        jPanel.add(this.createPhysicsPanel(String.valueOf(TextProvider.get("RightVelocity")) + ":", Physics.BatPhysics.RIGHT_VELOCITY, list));
        return jPanel;
    }

    private JPanel makePanelCirclingFlame(List<PhysicsTextField> list) {
        JPanel jPanel = new JPanel(new GridLayout(1, 2, 4, 4));
        jPanel.setBorder(BorderFactory.createTitledBorder(TextProvider.get("CirclingFlame")));
        jPanel.add(this.createPhysicsPanel(String.valueOf(TextProvider.get("Radius")) + ":", Physics.CirclingFlamePhysics.RADIUS, list));
        jPanel.add(this.createPhysicsPanel(String.valueOf(TextProvider.get("Velocity")) + ":", Physics.CirclingFlamePhysics.VELOCITY, list));
        return jPanel;
    }

    private JPanel makePanelSeahorse(List<PhysicsTextField> list) {
        JPanel jPanel = new JPanel(new GridLayout(1, 2, 4, 4));
        jPanel.setBorder(BorderFactory.createTitledBorder(TextProvider.get("SeaHorse")));
        jPanel.add(this.createPhysicsPanel(String.valueOf(TextProvider.get("LeftVelocity")) + ":", Physics.SeahorsePhysics.LEFT_VELOCITY, list));
        jPanel.add(this.createPhysicsPanel(String.valueOf(TextProvider.get("RightVelocity")) + ":", Physics.SeahorsePhysics.RIGHT_VELOCITY, list));
        return jPanel;
    }

    private JPanel makePanelMerman(List<PhysicsTextField> list) {
        JPanel jPanel = new JPanel(new GridLayout(1, 2, 4, 4));
        jPanel.setBorder(BorderFactory.createTitledBorder(TextProvider.get("Merman")));
        jPanel.add(this.createPhysicsPanel(String.valueOf(TextProvider.get("VerticalVelocity")) + ":", Physics.MermanPhysics.VERTICAL_VELOCITY, list));
        jPanel.add(this.createPhysicsPanel(String.valueOf(TextProvider.get("Duration")) + ":", Physics.MermanPhysics.DURATION, list));
        return jPanel;
    }

    private JPanel makePanelMonkey(List<PhysicsTextField> list) {
        JPanel jPanel = new JPanel(new GridLayout(1, 1, 4, 4));
        jPanel.setBorder(BorderFactory.createTitledBorder(TextProvider.get("Monkey")));
        jPanel.add(this.createPhysicsPanel(String.valueOf(TextProvider.get("Duration")) + ":", Physics.MonkeyPhysics.THROW_DURATION, list));
        return jPanel;
    }

    private JPanel makePanelLightningCloud(List<PhysicsTextField> list) {
        JPanel jPanel = new JPanel(new GridLayout(1, 1, 4, 4));
        jPanel.setBorder(BorderFactory.createTitledBorder(TextProvider.get("LightningCloud")));
        jPanel.add(this.createPhysicsPanel(String.valueOf(TextProvider.get("HorizontalVelocity")) + ":", Physics.LightningCloudPhysics.HORIZONTAL_VELOCITY, list));
        return jPanel;
    }

    private JPanel makePanelOx(List<PhysicsTextField> list) {
        JPanel jPanel = new JPanel(new GridLayout(1, 1, 4, 4));
        jPanel.setBorder(BorderFactory.createTitledBorder(TextProvider.get("Ox")));
        jPanel.add(this.createPhysicsPanel(String.valueOf(TextProvider.get("HorizontalVelocity")) + ":", Physics.OxPhysics.HORIZONTAL_VELOCITY, list));
        return jPanel;
    }

    private JPanel makePanelMissiles(List<PhysicsTextField> list) {
        JPanel jPanel;
        JPanel jPanel2 = jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)ComponentWrapper.wrapComponent(this.makePanelShockingWavesOfDestruction(list)), "North");
        jPanel2 = PhysicsEditor.addPanel(jPanel2, this.makePanelVehicleMissile(list));
        return ComponentWrapper.wrapComponent(jPanel);
    }

    private JPanel makePanelShockingWavesOfDestruction(List<PhysicsTextField> list) {
        JPanel jPanel = new JPanel(new GridLayout(1, 2, 4, 4));
        jPanel.setBorder(BorderFactory.createTitledBorder(TextProvider.get("ShockingWavesOfDestruction")));
        jPanel.add(this.createPhysicsPanel(String.valueOf(TextProvider.get("LeftVelocity")) + ":", Physics.ShockingWavesOfDestructionPhysics.LEFT_VELOCITY, list));
        jPanel.add(this.createPhysicsPanel(String.valueOf(TextProvider.get("RightVelocity")) + ":", Physics.ShockingWavesOfDestructionPhysics.RIGHT_VELOCITY, list));
        return jPanel;
    }

    private JPanel makePanelVehicleMissile(List<PhysicsTextField> list) {
        JPanel jPanel = new JPanel(new GridLayout(1, 2, 4, 4));
        jPanel.setBorder(BorderFactory.createTitledBorder(TextProvider.get("VehicleMissile")));
        jPanel.add(this.createPhysicsPanel(String.valueOf(TextProvider.get("LeftVelocity")) + ":", Physics.VehicleMissilePhysics.LEFT_VELOCITY, list));
        jPanel.add(this.createPhysicsPanel(String.valueOf(TextProvider.get("RightVelocity")) + ":", Physics.VehicleMissilePhysics.RIGHT_VELOCITY, list));
        return jPanel;
    }

    private JPanel createPhysicsPanel(String string, Physics.CharacterPhysics characterPhysics, List<PhysicsTextField> list) {
        JPanel jPanel = new JPanel(new BorderLayout(4, 4));
        jPanel.add((Component)new JLabel(string), "West");
        jPanel.add((Component)this.newPhysicsTextField(characterPhysics, list), "East");
        return jPanel;
    }

    private static JScrollPane createPhysicsTab(JPanel jPanel) {
        JScrollPane jScrollPane = new JScrollPane(jPanel, 20, 31){

            @Override
            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                int n = this.getVerticalScrollBar().getWidth();
                return new Dimension((int)dimension.getWidth() + n, Math.min(800, (int)dimension.getHeight()));
            }
        };
        jScrollPane.getVerticalScrollBar().setUnitIncrement(16);
        return jScrollPane;
    }

    private PhysicsTextField newPhysicsTextField(Physics.CharacterPhysics characterPhysics, List<PhysicsTextField> list) {
        PhysicsTextField physicsTextField = new PhysicsTextField(characterPhysics);
        list.add(physicsTextField);
        return physicsTextField;
    }

    private static JPanel addPanel(JPanel jPanel, JPanel jPanel2) {
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel.add((Component)jPanel3, "South");
        jPanel3.add((Component)ComponentWrapper.wrapComponent(jPanel2), "North");
        return jPanel3;
    }

    public static void open(JFrame jFrame, Physics physics, Properties properties) {
        PhysicsEditor.properties = properties;
        if (editor == null) {
            editor = new PhysicsEditor(physics);
            try {
                editor.setLocation(properties.getInt("Window" + editor.getClass().getSimpleName() + "X"), properties.getInt("Window" + editor.getClass().getSimpleName() + "Y"));
            }
            catch (NumberFormatException numberFormatException) {
                editor.setLocationRelativeTo(jFrame);
            }
            try {
                editor.setSize(properties.getInt("Window" + editor.getClass().getSimpleName() + "Width"), properties.getInt("Window" + editor.getClass().getSimpleName() + "Height"));
            }
            catch (NumberFormatException numberFormatException) {
                editor.pack();
            }
            editor.pack();
        } else {
            for (PhysicsTextField physicsTextField : PhysicsEditor.editor.textFields) {
                physicsTextField.reloadValue();
            }
        }
        if (ScreenUtilities.getScreen(editor) == null) {
            editor.setLocationRelativeTo(jFrame);
        }
        editor.setVisible(true);
    }

    public static void close() {
        if (editor != null) {
            editor.setVisible(false);
        }
    }

    public static void destroy() {
        if (editor != null) {
            editor.dispose();
        }
        editor = null;
    }

    public static void saveState(Properties properties) {
        if (editor != null) {
            properties.setProperty("Window" + editor.getClass().getSimpleName() + "Open", "" + editor.isVisible());
            properties.setProperty("Window" + editor.getClass().getSimpleName() + "X", "" + editor.getX());
            properties.setProperty("Window" + editor.getClass().getSimpleName() + "Y", "" + editor.getY());
            if (editor.isResizable()) {
                properties.setProperty("Window" + editor.getClass().getSimpleName() + "Width", "" + editor.getWidth());
                properties.setProperty("Window" + editor.getClass().getSimpleName() + "Height", "" + editor.getHeight());
            }
        }
    }

    private class PhysicsTextField
    extends IntegerTextField {
        private final Document integerDocument;
        private final Document decimalDocument;
        private final Physics.CharacterPhysics characterPhysics;

        public PhysicsTextField(Physics.CharacterPhysics characterPhysics) {
            super(characterPhysics.getSize(), PhysicsEditor.this.physics.getValue(characterPhysics), characterPhysics.isSigned());
            this.integerDocument = this.getDocument();
            if (characterPhysics.isSigned()) {
                this.decimalDocument = new PlainDocument(){

                    @Override
                    public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
                        if (this.getLength() >= PhysicsTextField.this.getMaxLength()) {
                            return;
                        }
                        if (PhysicsTextField.this.isSigned() && n == 0 && string.length() > 0 && string.charAt(0) == '-') {
                            super.insertString(n, "-" + string.substring(1).replaceAll("[^0-9.]", ""), attributeSet);
                        } else {
                            super.insertString(n, string.replaceAll("[^0-9.]", ""), attributeSet);
                        }
                        if (this.getLength() > 0) {
                            PhysicsTextField.this.actionPerformed();
                        }
                    }

                    @Override
                    public void remove(int n, int n2) throws BadLocationException {
                        super.remove(n, n2);
                        if (this.getLength() > 0) {
                            PhysicsTextField.this.actionPerformed();
                        }
                    }
                };
                this.setColumns(8);
            } else {
                this.decimalDocument = null;
            }
            this.updateDocument();
            this.characterPhysics = characterPhysics;
            if (!PhysicsEditor.this.physics.isValid(characterPhysics)) {
                this.reloadValue();
            }
        }

        @Override
        protected int getMaxLength() {
            return 12;
        }

        @Override
        public int getValue() {
            if (this.getDocument() == this.decimalDocument) {
                try {
                    return Math.round(Float.parseFloat(this.getText()) * 256.0f) & 0xFFFF;
                }
                catch (NumberFormatException numberFormatException) {
                    return 0;
                }
            }
            return super.getValue();
        }

        @Override
        protected String getValueString() {
            if (this.getDocument() == this.decimalDocument) {
                return FORMAT_FIXED_POINT.format((float)((short)this.getValue()) / 256.0f);
            }
            return super.getValueString();
        }

        @Override
        public void setValue(int n) {
            if (this.getDocument() == this.decimalDocument) {
                this.setText(FORMAT_FIXED_POINT.format((float)((short)n) / 256.0f));
            } else {
                super.setValue(n);
            }
        }

        @Override
        public void setText(String string) {
            if (this.isEnabled() || string == null || string.isEmpty()) {
                super.setText(string);
            }
        }

        public void updateDocument() {
            int n = this.getValue();
            if (this.decimalDocument == null || properties.getInt("PhysicsUnit") == 0) {
                this.setDocument(this.integerDocument);
            } else {
                this.setDocument(this.decimalDocument);
            }
            this.setValue(n);
        }

        public void reloadValue() {
            if (!PhysicsEditor.this.physics.isValid(this.characterPhysics)) {
                this.setText("");
                this.setEnabled(false);
            } else {
                this.setValue(PhysicsEditor.this.physics.getValue(this.characterPhysics));
            }
        }

        public void writeValue() {
            if (PhysicsEditor.this.physics.isValid(this.characterPhysics)) {
                PhysicsEditor.this.physics.setValue(this.characterPhysics, this.getValue());
            }
        }
    }
}

