/*
 * Decompiled with CFR 0.152.
 */
package editors;

import data.Palette;
import data.Shop;
import data.Tileset;
import editors.TextProvider;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import panels.ItemPanel;
import transactions.TransactionManager;
import widgets.BCDTextField;

public class ItemEditor
extends JDialog {
    private static ItemEditor editor;
    private final ItemPanel[] itemPanels;
    private final BCDTextField[] textFields;

    private ItemEditor(JFrame jFrame, final Shop shop, Tileset tileset, Palette palette, int[] nArray) {
        super(jFrame, TextProvider.get("TitleItem"), false);
        LinkedList<Shop.ItemHandle> linkedList = shop.getItemHandles();
        this.itemPanels = new ItemPanel[linkedList.size()];
        this.textFields = new BCDTextField[this.itemPanels.length];
        this.setLayout(new GridLayout(this.itemPanels.length / 4, 4));
        int n = 0;
        for (final Shop.ItemHandle itemHandle : linkedList) {
            JPanel jPanel = new JPanel(new BorderLayout());
            this.itemPanels[n] = new ItemPanel(nArray, shop, itemHandle, tileset, palette);
            jPanel.add((Component)this.itemPanels[n], "Center");
            this.textFields[n] = new BCDTextField(1, shop.getItemPrice(itemHandle), true, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    final BCDTextField bCDTextField = (BCDTextField)actionEvent.getSource();
                    TransactionManager.getInstance().runTransaction(new Runnable(){

                        @Override
                        public void run() {
                            shop.setItemPrice(itemHandle, bCDTextField.getValue());
                        }
                    });
                }
            });
            jPanel.add((Component)this.textFields[n], "South");
            jPanel.setBorder(BorderFactory.createEtchedBorder());
            this.add(jPanel);
            ++n;
        }
        this.setResizable(false);
        this.pack();
        this.setLocationRelativeTo(jFrame);
    }

    public static void close() {
        if (editor != null) {
            editor.setVisible(false);
        }
    }

    public static void destroy() {
        if (editor != null) {
            editor.dispose();
        }
        editor = null;
    }

    public static void open(JFrame jFrame, Shop shop, Tileset tileset, Palette palette, int[] nArray) {
        if (editor == null) {
            editor = new ItemEditor(jFrame, shop, tileset, palette, nArray);
        } else {
            int n = 0;
            for (Shop.ItemHandle itemHandle : shop.getItemHandles()) {
                ItemEditor.editor.textFields[n++].setValue(shop.getItemPrice(itemHandle));
            }
        }
        editor.setVisible(true);
    }
}

