/*
 * Decompiled with CFR 0.152.
 */
package data;

import changes.Changable;
import changes.Change;
import changes.ChangeListener;
import editors.TextProvider;
import java.util.LinkedList;
import rom.RomManager;
import transactions.TransactionManager;

public class JankenMatch
implements Changable {
    private final int address;
    private final LinkedList<ChangeListener> listeners = new LinkedList();

    public JankenMatch(int n) {
        this.address = n;
    }

    public int getSpriteDescriptor(int n) {
        return RomManager.StaticAccess.readWord(this.address + n * 16);
    }

    public int getTiles(int n) {
        return RomManager.StaticAccess.readWord(this.address + n * 16 + 2);
    }

    public int getAnimation(int n) {
        return RomManager.StaticAccess.readWord(this.address + n * 16 + 6);
    }

    public int getCountDownAnimation(int n) {
        return RomManager.StaticAccess.readWord(this.address + n * 16 + 8);
    }

    public int getShowSpriteDescriptor(int n, int n2) {
        return RomManager.StaticAccess.readWord(RomManager.StaticAccess.readWord(this.address + n * 16 + 10) + 2 * n2);
    }

    public int[] getDecisions(int n) {
        return RomManager.StaticAccess.readBytes(new int[32], RomManager.StaticAccess.readWord(this.address + n * 16 + 12));
    }

    public int getMessage(int n) {
        return RomManager.StaticAccess.readByte(this.address + n * 16 + 14);
    }

    public void setDecisions(int n, int[] nArray) {
        int n2 = RomManager.StaticAccess.readWord(this.address + n * 16 + 12);
        boolean bl = false;
        int n3 = 0;
        while (n3 < nArray.length && !bl) {
            if (RomManager.StaticAccess.readByte(n2 + n3) != nArray[n3]) {
                bl = true;
            }
            ++n3;
        }
        if (bl) {
            TransactionManager.getInstance().addTransactionObject(this, n);
            RomManager.StaticAccess.writeBytes(nArray, n2);
        }
    }

    public void setMessage(int n, int n2) {
        if (RomManager.StaticAccess.readByte(this.address + n * 16 + 14) != (n2 & 0xFF)) {
            TransactionManager.getInstance().addTransactionObject(this, -n - 1);
            RomManager.StaticAccess.writeByte(this.address + n * 16 + 14, n2 & 0xFF);
        }
    }

    @Override
    public final String getChangeName() {
        return TextProvider.get("ChangeJankenMatch");
    }

    @Override
    public final void fireChangeOccurred(Change change) {
        for (ChangeListener changeListener : this.listeners) {
            changeListener.changeOccurred(change);
        }
    }

    @Override
    public final void addChangeListener(ChangeListener changeListener) {
        if (!this.listeners.contains(changeListener)) {
            this.listeners.addFirst(changeListener);
        }
    }

    @Override
    public final void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }
}

