/*
 * Decompiled with CFR 0.152.
 */
package vgm;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;

public class VGMInputStream
extends InputStream {
    private final InputStream input;
    private final int offsetEOF;
    private final int version;
    private final int psgClock;
    private final int fmClock;
    private final int offsetGD3;
    private final int totalSamples;
    private final int offsetLoop;
    private final int loopSamples;
    private final int rate;
    private int pos = 0;

    public VGMInputStream(File file) throws IOException {
        FilterInputStream filterInputStream;
        try {
            filterInputStream = new GZIPInputStream(new FileInputStream(file));
        }
        catch (IOException iOException) {
            filterInputStream = new BufferedInputStream(new FileInputStream(file));
        }
        this.input = filterInputStream;
        byte[] byArray = new byte[4];
        this.read(byArray);
        if (!"Vgm ".equals(new String(byArray))) {
            this.close();
            throw new IOException("Invalid vgm file. File identification missing.");
        }
        this.offsetEOF = this.pos + this.readInt();
        this.version = this.readInt();
        this.psgClock = this.readInt();
        this.fmClock = this.readInt();
        this.offsetGD3 = this.pos + this.readInt();
        this.totalSamples = this.readInt();
        this.offsetLoop = this.pos + this.readInt();
        this.loopSamples = this.readInt();
        this.rate = this.readInt();
        if (this.version >= 336) {
            this.seekTo(52);
            int n = this.readInt();
            if (n > 0) {
                this.skip(n - 4);
            } else {
                this.seekTo(64);
            }
        } else {
            this.seekTo(64);
        }
    }

    public int getOffsetEOF() {
        return this.offsetEOF;
    }

    public int getVersion() {
        return this.version;
    }

    public int getPsgClock() {
        return this.psgClock;
    }

    public int getFmClock() {
        return this.fmClock;
    }

    public int getOffsetGD3() {
        return this.offsetGD3;
    }

    public int getTotalSamples() {
        return this.totalSamples;
    }

    public int getOffsetLoop() {
        return this.offsetLoop;
    }

    public int getLoopSamples() {
        return this.loopSamples;
    }

    public int getRate() {
        return this.rate;
    }

    public void seekTo(int n) throws IOException {
        if (n < this.pos) {
            throw new IOException("Current position is beyond position to seek to.");
        }
        if (n > this.pos) {
            this.skip(n - this.pos);
        }
    }

    public boolean isLoopPoint() {
        return this.pos == this.offsetLoop;
    }

    public int getPosition() {
        return this.pos;
    }

    @Override
    public int read() throws IOException {
        ++this.pos;
        return this.input.read();
    }

    public int readShort() throws IOException {
        return this.read() | this.read() << 8;
    }

    public int readInt() throws IOException {
        return this.read() | this.read() << 8 | this.read() << 16 | this.read() << 24;
    }

    @Override
    public void close() throws IOException {
        this.input.close();
    }

    @Override
    public int available() throws IOException {
        return this.input.available();
    }

    @Override
    public synchronized void mark(int n) {
        this.input.mark(n);
    }

    @Override
    public boolean markSupported() {
        return this.input.markSupported();
    }

    @Override
    public synchronized void reset() throws IOException {
        this.input.reset();
    }
}

