/*
 * Decompiled with CFR 0.152.
 */
package util.string;

import util.string.ConcatenatedCharSequence;
import util.string.SubCharSequence;

public class StringUtilities {
    private static final String EMPTY_STRING = "";

    private StringUtilities() {
    }

    public static CharSequence concat(CharSequence charSequence, CharSequence charSequence2) {
        if (charSequence2.length() <= 0) {
            return charSequence;
        }
        if (charSequence.length() == 0) {
            return charSequence2;
        }
        if (charSequence instanceof SubCharSequence) {
            return ((SubCharSequence)charSequence).append(charSequence2);
        }
        return new ConcatenatedCharSequence(charSequence, charSequence2);
    }

    public static boolean isEmpty(CharSequence charSequence) {
        return charSequence.length() == 0;
    }

    public static CharSequence trim(CharSequence charSequence) {
        int n = charSequence.length();
        int n2 = 0;
        int n3 = n;
        while (n2 < n3 && charSequence.charAt(n2) <= ' ') {
            ++n2;
        }
        while (n3 > n2 && charSequence.charAt(n3 - 1) <= ' ') {
            --n3;
        }
        return charSequence.subSequence(n2, n3);
    }

    public static boolean equalsIgnoreCase(CharSequence charSequence, CharSequence charSequence2) {
        int n = charSequence.length();
        if (n != charSequence2.length()) {
            return false;
        }
        int n2 = n - 1;
        while (n2 >= 0) {
            if (Character.toUpperCase(charSequence.charAt(n2)) != Character.toUpperCase(charSequence2.charAt(n2))) {
                return false;
            }
            --n2;
        }
        return true;
    }

    public static boolean startsWith(CharSequence charSequence, CharSequence charSequence2) {
        return StringUtilities.startsWith(charSequence, charSequence2, 0);
    }

    public static boolean startsWith(CharSequence charSequence, CharSequence charSequence2, int n) {
        int n2 = charSequence2.length();
        if (n < 0 || n > charSequence.length() - n2) {
            return false;
        }
        int n3 = n;
        int n4 = 0;
        while (--n2 >= 0) {
            if (charSequence.charAt(n3++) == charSequence2.charAt(n4++)) continue;
            return false;
        }
        return true;
    }

    public static int indexOf(CharSequence charSequence, char c) {
        return StringUtilities.indexOf(charSequence, c, 0);
    }

    public static int indexOf(CharSequence charSequence, char c, int n) {
        int n2 = charSequence.length();
        int n3 = Math.max(0, n);
        while (n3 < n2) {
            if (charSequence.charAt(n3) == c) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    public static int indexOfIgnoreCase(CharSequence charSequence, char c) {
        return StringUtilities.indexOfIgnoreCase(charSequence, c, 0);
    }

    public static int indexOfIgnoreCase(CharSequence charSequence, char c, int n) {
        c = Character.toUpperCase(c);
        int n2 = charSequence.length();
        int n3 = Math.max(0, n);
        while (n3 < n2) {
            if (Character.toUpperCase(charSequence.charAt(n3)) == c) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    public static int lastIndexOf(CharSequence charSequence, char c) {
        return StringUtilities.lastIndexOf(charSequence, c, charSequence.length() - 1);
    }

    public static int lastIndexOf(CharSequence charSequence, char c, int n) {
        int n2 = Math.min(n, charSequence.length() - 1);
        while (n2 >= 0) {
            if (charSequence.charAt(n2) == c) {
                return n2;
            }
            --n2;
        }
        return -1;
    }

    public static int indexOf(CharSequence charSequence, CharSequence charSequence2) {
        return StringUtilities.indexOf(charSequence, charSequence2, 0);
    }

    /*
     * Unable to fully structure code
     */
    public static int indexOf(CharSequence var0, CharSequence var1_1, int var2_2) {
        if (var1_1.length() == 0) {
            return -1;
        }
        var3_3 = var1_1.charAt(0);
        var4_4 = var1_1.length();
        var5_5 = var0.length();
        var6_6 = Math.max(0, var2_2);
        ** GOTO lbl21
        {
            ++var6_6;
            do {
                if (var6_6 < var5_5 && var0.charAt(var6_6) != var3_3) continue block0;
                if (var6_6 + var4_4 > var5_5) {
                    return -1;
                }
                var7_7 = var6_6 + 1;
                var8_8 = 1;
                while (var8_8 < var4_4 && var0.charAt(var7_7++) == var1_1.charAt(var8_8)) {
                    ++var8_8;
                }
                if (var8_8 == var4_4) {
                    return var6_6;
                }
                ++var6_6;
lbl21:
                // 2 sources

            } while (var6_6 < var5_5);
        }
        return -1;
    }

    public static int indexOfIgnoreCase(CharSequence charSequence, CharSequence charSequence2) {
        return StringUtilities.indexOfIgnoreCase(charSequence, charSequence2, 0);
    }

    /*
     * Unable to fully structure code
     */
    public static int indexOfIgnoreCase(CharSequence var0, CharSequence var1_1, int var2_2) {
        if (var1_1.length() == 0) {
            return -1;
        }
        var3_3 = Character.toUpperCase(var1_1.charAt(0));
        var4_4 = var1_1.length();
        var5_5 = var0.length();
        var6_6 = Math.max(0, var2_2);
        ** GOTO lbl21
        {
            ++var6_6;
            do {
                if (var6_6 < var5_5 && Character.toUpperCase(var0.charAt(var6_6)) != var3_3) continue block0;
                if (var6_6 + var4_4 > var5_5) {
                    return -1;
                }
                var7_7 = var6_6 + 1;
                var8_8 = 1;
                while (var8_8 < var4_4 && Character.toUpperCase(var0.charAt(var7_7++)) == Character.toUpperCase(var1_1.charAt(var8_8))) {
                    ++var8_8;
                }
                if (var8_8 == var4_4) {
                    return var6_6;
                }
                ++var6_6;
lbl21:
                // 2 sources

            } while (var6_6 < var5_5);
        }
        return -1;
    }

    public static int lastIndexOf(CharSequence charSequence, CharSequence charSequence2) {
        return StringUtilities.lastIndexOf(charSequence, charSequence2, charSequence.length() - 1);
    }

    /*
     * Unable to fully structure code
     */
    public static int lastIndexOf(CharSequence var0, CharSequence var1_1, int var2_2) {
        if (var1_1.length() == 0) {
            return -1;
        }
        var3_3 = var1_1.charAt(var1_1.length() - 1);
        var4_4 = var1_1.length() - 1;
        var5_5 = Math.min(var2_2, var0.length() - 1);
        ** GOTO lbl20
        {
            --var5_5;
            do {
                if (var5_5 >= 0 && var0.charAt(var5_5) != var3_3) continue block0;
                if (var5_5 - var4_4 < 0) {
                    return -1;
                }
                var6_6 = var5_5;
                var7_7 = var4_4 - 1;
                while (var7_7 >= 0 && var0.charAt(--var6_6) == var1_1.charAt(var7_7)) {
                    --var7_7;
                }
                if (var7_7 < 0) {
                    return var6_6;
                }
                --var5_5;
lbl20:
                // 2 sources

            } while (var5_5 >= 0);
        }
        return -1;
    }

    public static int lastIndexOfIgnoreCase(CharSequence charSequence, CharSequence charSequence2) {
        return StringUtilities.lastIndexOfIgnoreCase(charSequence, charSequence2, charSequence.length() - 1);
    }

    /*
     * Unable to fully structure code
     */
    public static int lastIndexOfIgnoreCase(CharSequence var0, CharSequence var1_1, int var2_2) {
        if (var1_1.length() == 0) {
            return -1;
        }
        var3_3 = Character.toUpperCase(var1_1.charAt(var1_1.length() - 1));
        var4_4 = var1_1.length() - 1;
        var5_5 = Math.min(var2_2, var0.length() - 1);
        ** GOTO lbl20
        {
            --var5_5;
            do {
                if (var5_5 >= 0 && Character.toUpperCase(var0.charAt(var5_5)) != var3_3) continue block0;
                if (var5_5 - var4_4 < 0) {
                    return -1;
                }
                var6_6 = var5_5;
                var7_7 = var4_4 - 1;
                while (var7_7 >= 0 && Character.toUpperCase(var0.charAt(--var6_6)) == Character.toUpperCase(var1_1.charAt(var7_7))) {
                    --var7_7;
                }
                if (var7_7 < 0) {
                    return var6_6;
                }
                --var5_5;
lbl20:
                // 2 sources

            } while (var5_5 >= 0);
        }
        return -1;
    }

    public static boolean contains(CharSequence charSequence, CharSequence charSequence2) {
        return StringUtilities.indexOf(charSequence, charSequence2) >= 0;
    }

    public static boolean containsIgnoreCase(CharSequence charSequence, CharSequence charSequence2) {
        return StringUtilities.indexOfIgnoreCase(charSequence, charSequence2) >= 0;
    }

    public static int count(CharSequence charSequence, char c) {
        int n = 0;
        int n2 = charSequence.length();
        int n3 = 0;
        while (n3 < n2) {
            if (charSequence.charAt(n3) == c) {
                ++n;
            }
            ++n3;
        }
        return n;
    }

    public static int count(CharSequence charSequence, CharSequence charSequence2) {
        int n = 0;
        int n2 = charSequence.length();
        int n3 = charSequence2.length();
        int n4 = 0;
        while (n4 < n2) {
            if (charSequence.charAt(n4) == charSequence2.charAt(0)) {
                boolean bl = true;
                int n5 = 1;
                while (bl && n5 < n3) {
                    if (charSequence.charAt(n4 + n5) != charSequence2.charAt(n5)) {
                        bl = false;
                    }
                    ++n5;
                }
                if (bl) {
                    ++n;
                }
            }
            ++n4;
        }
        return n;
    }

    public static boolean startsWithIgnoreCase(CharSequence charSequence, CharSequence charSequence2) {
        return StringUtilities.startsWithIgnoreCase(charSequence, charSequence2, 0);
    }

    public static boolean startsWithIgnoreCase(CharSequence charSequence, CharSequence charSequence2, int n) {
        int n2 = charSequence2.length();
        if (n < 0 || n > charSequence.length() - n2) {
            return false;
        }
        int n3 = n;
        int n4 = 0;
        while (--n2 >= 0) {
            if (Character.toUpperCase(charSequence.charAt(n3++)) == Character.toUpperCase(charSequence2.charAt(n4++))) continue;
            return false;
        }
        return true;
    }

    public static CharSequence subSequence(CharSequence charSequence, int n) {
        return StringUtilities.subSequence(charSequence, n, charSequence.length());
    }

    public static CharSequence subSequence(CharSequence charSequence, int n, int n2) {
        if (n == n2) {
            return EMPTY_STRING;
        }
        if (n == 0 && n2 == charSequence.length()) {
            return charSequence;
        }
        if (charSequence instanceof SubCharSequence) {
            return charSequence.subSequence(n, n2);
        }
        return SubCharSequence.from(charSequence, n, n2);
    }
}

