/*
 * Decompiled with CFR 0.152.
 */
package panels;

import changes.Change;
import changes.ChangeListener;
import data.Palette;
import data.Tiles;
import data.Tileset;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Stroke;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.util.LinkedList;
import javax.swing.SwingUtilities;
import mastersystem.Renderer;
import panels.ScalablePanel;
import transactions.TransactionManager;

public class TilesetPanel
extends ScalablePanel {
    private BufferedImage tiles;
    private BufferedImage subTileset;
    private BufferedImage buffer;
    private final Color[] colors = new Color[32];
    private Tileset tileset;
    private Palette palette;
    private boolean selectionEnabled;
    private boolean editable;
    private int selectedTile = -1;
    private Tiles selectedSubTileset;
    private int dragXstart;
    private int dragYstart;
    private int dragXoffset;
    private int dragYoffset;
    private int offsetX;
    private int offsetY;
    private float scale = 1.0f;
    private int attributes;
    private boolean matchParentWidth;
    private final LinkedList<ActionListener> listeners = new LinkedList();
    private final ChangeListener tilesetChangeListener = new ChangeListener(){

        @Override
        public void changeOccurred(Change change) {
            TilesetPanel.this.update();
        }
    };
    private final ChangeListener paletteChangeListener = new ChangeListener(){

        @Override
        public void changeOccurred(Change change) {
            int n = change.getData(TilesetPanel.this.palette);
            if (n < 0) {
                int n2 = -n - 1;
                int n3 = n2 * 16;
                int n4 = n3 + 16;
                if (n2 == 2) {
                    n3 = 0;
                    n4 = 32;
                }
                int n5 = n3;
                while (n5 < n4) {
                    int n6 = TilesetPanel.this.palette.getColors()[n5];
                    int n7 = (n6 & 0x30) >> 4;
                    int n8 = (n6 & 0xC) >> 2;
                    int n9 = n6 & 3;
                    ((TilesetPanel)TilesetPanel.this).colors[n5] = new Color(n9 * 255 / 3, n8 * 255 / 3, n7 * 255 / 3);
                    ++n5;
                }
            } else {
                int n10 = TilesetPanel.this.palette.getColors()[n];
                int n11 = (n10 & 0x30) >> 4;
                int n12 = (n10 & 0xC) >> 2;
                int n13 = n10 & 3;
                ((TilesetPanel)TilesetPanel.this).colors[n] = new Color(n13 * 255 / 3, n12 * 255 / 3, n11 * 255 / 3);
            }
            TilesetPanel.this.update();
        }
    };

    public TilesetPanel(Tileset tileset, Palette palette) {
        this.setTileset(tileset, palette);
        final Cursor cursor = this.getCursor();
        final Cursor cursor2 = Cursor.getPredefinedCursor(13);
        final Cursor cursor3 = Cursor.getPredefinedCursor(12);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if ((TilesetPanel.this.selectionEnabled || TilesetPanel.this.editable) && SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    int n = TilesetPanel.this.toScreenX(mouseEvent.getX());
                    int n2 = TilesetPanel.this.toScreenY(mouseEvent.getY());
                    int n3 = n2 / 8 * 32 + n / 8;
                    if (TilesetPanel.this.tileset.contains(n3)) {
                        TilesetPanel.this.setSelectedTile(n3);
                    }
                    if (TilesetPanel.this.selectedSubTileset != null) {
                        n3 = TilesetPanel.this.tileset.getTilesDestination(TilesetPanel.this.selectedSubTileset) / 32;
                        int n4 = n3 % 32 * 8;
                        int n5 = n3 / 32 * 8;
                        TilesetPanel.this.dragXoffset = n - n4 & 0xFFFFFFF8;
                        TilesetPanel.this.dragYoffset = n2 - n5 & 0xFFFFFFF8;
                        TilesetPanel.this.dragXstart = n;
                        TilesetPanel.this.dragYstart = n2;
                    }
                }
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                if (TilesetPanel.this.editable) {
                    TilesetPanel.this.selectedSubTileset = null;
                    TilesetPanel.this.repaint();
                }
                TilesetPanel.this.setCursor(cursor);
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                int n = TilesetPanel.this.toScreenX(mouseEvent.getX());
                int n2 = TilesetPanel.this.toScreenY(mouseEvent.getY());
                int n3 = n >= 0 ? n / 8 : n / 8 - 1;
                int n4 = n2 >= 0 ? n2 / 8 : n2 / 8 - 1;
                int n5 = n4 * 32 + n3;
                if (TilesetPanel.this.editable) {
                    TilesetPanel.this.selectedSubTileset = null;
                    Tiles tiles = TilesetPanel.this.tileset.getTilesAt(n5 * 32);
                    if (tiles != null && TilesetPanel.this.tileset.canSetTilesDestination(tiles) && TilesetPanel.this.tileset.getTilesDestination(tiles) >= 0) {
                        TilesetPanel.this.selectedSubTileset = tiles;
                    }
                    TilesetPanel.this.repaint();
                }
                if (TilesetPanel.this.selectedSubTileset != null) {
                    TilesetPanel.this.setCursor(cursor2);
                } else if (TilesetPanel.this.selectionEnabled && n >= 0 && n < TilesetPanel.this.tiles.getWidth() && n2 >= 0 && n2 < TilesetPanel.this.tiles.getHeight() && TilesetPanel.this.tileset.contains(n5)) {
                    TilesetPanel.this.setCursor(cursor3);
                } else {
                    TilesetPanel.this.setCursor(cursor);
                }
            }

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                int n = TilesetPanel.this.toScreenX(mouseEvent.getX());
                int n2 = TilesetPanel.this.toScreenY(mouseEvent.getY());
                if (TilesetPanel.this.selectedSubTileset != null && SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    if (mouseEvent.isShiftDown()) {
                        if (Math.abs(n - TilesetPanel.this.dragXstart) > Math.abs(n2 - TilesetPanel.this.dragYstart)) {
                            n2 = TilesetPanel.this.dragYstart;
                        } else {
                            n = TilesetPanel.this.dragXstart;
                        }
                    }
                    final int n3 = (n2 - TilesetPanel.this.dragYoffset) / 8;
                    final int n4 = (n - TilesetPanel.this.dragXoffset) / 8;
                    TransactionManager.getInstance().runTransaction(new Runnable(){

                        @Override
                        public void run() {
                            TilesetPanel.this.tileset.setTilesDestination(TilesetPanel.this.selectedSubTileset, (n3 * 32 + n4) * 32);
                        }
                    });
                }
            }
        });
    }

    public void setTileset(Tileset tileset, Palette palette) {
        int n;
        if (tileset == this.tileset && palette == this.palette) {
            return;
        }
        if (this.tileset != null && this.tileset != tileset) {
            this.tileset.removeChangeListener(this.tilesetChangeListener);
        }
        if (this.palette != null && this.palette != palette) {
            this.palette.removeChangeListener(this.paletteChangeListener);
        }
        this.tileset = tileset;
        this.palette = palette;
        int n2 = n = tileset.getDestination() >= 8192 ? 48 : 64;
        if (this.tiles == null || this.tiles.getHeight() != n) {
            this.tiles = new BufferedImage(256, n, 2);
            this.buffer = new BufferedImage(this.tiles.getWidth(), this.tiles.getHeight(), this.tiles.getType());
        }
        int n3 = 0;
        int[] nArray = palette.getColors();
        int n4 = nArray.length;
        int n5 = 0;
        while (n5 < n4) {
            int n6 = nArray[n5];
            int n7 = (n6 & 0x30) >> 4;
            int n8 = (n6 & 0xC) >> 2;
            int n9 = n6 & 3;
            this.colors[n3++] = new Color(n9 * 255 / 3, n8 * 255 / 3, n7 * 255 / 3);
            ++n5;
        }
        tileset.addChangeListener(this.tilesetChangeListener);
        palette.addChangeListener(this.paletteChangeListener);
        this.selectedTile = -1;
        this.selectedSubTileset = null;
        this.update();
    }

    public void setAttributes(int n) {
        this.attributes = n;
        this.update();
    }

    public void setSelectionEnabled(boolean bl) {
        this.selectionEnabled = bl;
        this.repaint();
    }

    public void setEditable(boolean bl) {
        this.editable = bl;
        this.repaint();
    }

    public void setSelectedTile(int n) {
        this.selectedTile = n;
        this.repaint();
        this.fireActionPerformed();
    }

    public int getSelectedTile() {
        return this.selectedTile;
    }

    public void showSubTileset(Tileset tileset) {
        int[] nArray = tileset.getVRAM();
        int n = tileset.getDestination() + tileset.getLength();
        this.subTileset = new BufferedImage(256, 48, 2);
        if (tileset.isSprite()) {
            int n2 = tileset.getDestination() / 32;
            while (n2 < n / 32) {
                Renderer.renderSpriteCharacter(nArray, n2, n2 % 32 * 8, n2 / 32 * 8 - this.tileset.getDestination() / 32 / 32 * 8, this.colors, this.subTileset);
                ++n2;
            }
        } else {
            Graphics2D graphics2D = this.subTileset.createGraphics();
            int n3 = tileset.getDestination() / 32;
            while (n3 < n / 32) {
                Renderer.renderCharacter(nArray, 0x800 | n3, n3 % 32 * 8, n3 / 32 * 8 - this.tileset.getDestination() / 32 / 32 * 8, this.colors, graphics2D);
                ++n3;
            }
            graphics2D.dispose();
        }
        this.repaint();
    }

    public void hideSubTileset() {
        this.subTileset = null;
        this.repaint();
    }

    private void update() {
        int[] nArray = this.tileset.getVRAM();
        if (this.tileset.isSprite()) {
            Graphics2D graphics2D = this.tiles.createGraphics();
            graphics2D.setComposite(AlphaComposite.Clear);
            graphics2D.fillRect(0, 0, this.tiles.getWidth(), this.tiles.getHeight());
            graphics2D.dispose();
            int n = 0;
            while (n < 192) {
                Renderer.renderSpriteCharacter(nArray, n, n % 32 * 8, n / 32 * 8, this.colors, this.tiles);
                ++n;
            }
        } else {
            Graphics2D graphics2D = this.tiles.createGraphics();
            if (this.tileset.getDestination() >= 8192) {
                int n = 0;
                while (n < 192) {
                    Renderer.renderCharacter(nArray, (this.tileset.contains(0x100 | n) ? this.attributes : 0) << 8 | 0x100 | n, n % 32 * 8, n / 32 * 8, this.colors, graphics2D);
                    ++n;
                }
            } else {
                int n = 0;
                while (n < 256) {
                    Renderer.renderCharacter(nArray, (this.tileset.contains(n) ? this.attributes : 0) << 8 | n, n % 32 * 8, n / 32 * 8, this.colors, graphics2D);
                    ++n;
                }
            }
            graphics2D.dispose();
        }
        this.repaint();
    }

    public void setMatchParentWidth(boolean bl) {
        this.matchParentWidth = bl;
    }

    @Override
    public float getScale() {
        return this.scale;
    }

    @Override
    public Dimension getPreferredSize() {
        float f = this.getPreferredScale();
        if (this.matchParentWidth && this.getParent() != null && this.getParent().getWidth() > 0) {
            f = (float)this.getParent().getWidth() / (float)this.tiles.getWidth();
            if (this.isIntegerScaling()) {
                f = (int)f;
            }
        }
        return new Dimension((int)((float)this.tiles.getWidth() * f), (int)((float)this.tiles.getHeight() * f));
    }

    private int toScreenX(int n) {
        return n >= this.offsetX ? (int)((float)(n - this.offsetX) / this.scale) : (int)((float)(n - this.offsetX) / this.scale) - 1;
    }

    private int toScreenY(int n) {
        return n >= this.offsetY ? (int)((float)(n - this.offsetY) / this.scale) : (int)((float)(n - this.offsetY) / this.scale) - 1;
    }

    protected final void fireActionPerformed() {
        for (ActionListener actionListener : this.listeners) {
            actionListener.actionPerformed(null);
        }
    }

    public final void addActionListener(ActionListener actionListener) {
        if (!this.listeners.contains(actionListener)) {
            this.listeners.add(actionListener);
        }
    }

    public final void removeActionListener(ActionListener actionListener) {
        this.listeners.remove(actionListener);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        int n;
        int n2;
        int n3;
        super.paintComponent(graphics);
        Graphics2D graphics2D = this.buffer.createGraphics();
        Composite composite = graphics2D.getComposite();
        graphics2D.setComposite(AlphaComposite.Clear);
        graphics2D.fillRect(0, 0, this.buffer.getWidth(), this.buffer.getHeight());
        graphics2D.setComposite(composite);
        graphics2D.drawImage((Image)this.tiles, 0, 0, null);
        graphics2D.setColor(Color.RED);
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setStroke(new BasicStroke(1.5f));
        if (this.tileset.getDestination() >= 8192) {
            n3 = 0;
            while (n3 < 192) {
                if (!this.tileset.contains(n3)) {
                    graphics2D.drawLine(n3 % 32 * 8 + 1, n3 / 32 * 8 + 1, n3 % 32 * 8 + 6, n3 / 32 * 8 + 6);
                }
                ++n3;
            }
        } else {
            n3 = 0;
            while (n3 < 256) {
                if (!this.tileset.contains(n3)) {
                    graphics2D.drawLine(n3 % 32 * 8 + 1, n3 / 32 * 8 + 1, n3 % 32 * 8 + 6, n3 / 32 * 8 + 6);
                }
                ++n3;
            }
        }
        if (this.subTileset != null) {
            graphics2D.drawImage((Image)this.subTileset, 0, 0, null);
        }
        if (this.editable && this.selectedSubTileset != null) {
            int n4;
            graphics2D.setColor(this.tileset.isSprite() ? Color.MAGENTA : Color.WHITE);
            graphics2D.setStroke(stroke);
            n3 = this.tileset.getTilesDestination(this.selectedSubTileset) / 32;
            n2 = n3 % 32 * 8;
            n = n3 / 32 * 8;
            int n5 = this.selectedSubTileset.getLength() / 32 * 8;
            graphics2D.drawLine(n2, n, n2, n + 7);
            do {
                n4 = Math.min(this.tiles.getWidth() - (n2 %= this.tiles.getWidth()), n5);
                graphics2D.drawLine(n2, n, n2 + n4 - 1, n);
                graphics2D.drawLine(n2, n + 7, n2 + n4 - 1, n + 7);
                n2 += n4;
                n += 8;
            } while ((n5 -= n4) > 0);
            graphics2D.drawLine(n2 - 1, n - 7, n2 - 1, n);
        } else if (this.selectionEnabled && this.selectedTile >= 0) {
            graphics2D.setColor(this.tileset.isSprite() ? Color.MAGENTA : Color.WHITE);
            graphics2D.setStroke(stroke);
            graphics2D.drawRect(this.selectedTile % 32 * 8, this.selectedTile / 32 * 8, 7, 7);
        }
        graphics2D.dispose();
        Insets insets = this.getInsets();
        n2 = this.getWidth() - (insets.left + insets.right);
        n = this.getHeight() - (insets.top + insets.bottom);
        float f = (float)n2 / (float)this.buffer.getWidth();
        float f2 = (float)n / (float)this.buffer.getHeight();
        float f3 = Math.min(f, f2);
        if (this.isIntegerScaling()) {
            float f4;
            if ((this.scale != (float)((int)this.scale) || f3 - this.scale < 0.0f || f3 - this.scale >= 1.0f) && this.scale != (f4 = this.matchParentWidth ? (float)Math.max(1, (int)f3) : (float)Math.max(1, (int)(this.scale + Math.max(-1.0f, Math.min(1.0f, (f3 - this.scale) * 1.0f)))))) {
                this.scale = f4;
                this.scaleUpdated();
            }
        } else if (Math.abs(f3 - this.scale) * (float)this.buffer.getWidth() > 2.0f && Math.abs(f3 - this.scale) * (float)this.buffer.getHeight() > 2.0f) {
            this.scale += (f3 - this.scale) * 0.5f;
            this.scaleUpdated();
        }
        this.offsetX = Math.max(0, (int)(((float)n2 - (float)this.buffer.getWidth() * this.scale) / 2.0f)) + insets.left;
        this.offsetY = Math.max(0, (int)(((float)n - (float)this.buffer.getHeight() * this.scale) / 2.0f)) + insets.right;
        graphics.drawImage(this.buffer, this.offsetX, this.offsetY, (int)((float)this.buffer.getWidth() * this.scale), (int)((float)this.buffer.getHeight() * this.scale), null);
    }
}

