/*
 * Decompiled with CFR 0.152.
 */
package panels;

import java.util.LinkedList;
import javax.swing.JPanel;
import panels.Scalable;
import panels.ScaleListener;

public abstract class ScalablePanel
extends JPanel
implements Scalable {
    private float preferredScale;
    private float prevPreferredScale;
    private boolean integerScaling;
    private Scalable scaleParent = this;
    private final LinkedList<ScaleListener> listeners = new LinkedList();

    @Override
    public final float getPreferredScale() {
        return this.preferredScale <= 0.0f ? this.getScale() : this.preferredScale;
    }

    @Override
    public final boolean isIntegerScaling() {
        return this.integerScaling;
    }

    @Override
    public final void setScaleParent(Scalable scalable) {
        if (scalable == null) {
            throw new IllegalArgumentException("ScaleParent must not be null.");
        }
        if (scalable != this.scaleParent && this.scaleParent != null) {
            this.scaleParent.removeScaleListener(this);
        }
        this.scaleParent = scalable;
        this.prevPreferredScale = 0.0f;
        scalable.addScaleListener(this);
    }

    @Override
    public final void setPreferredScale(float f) {
        if (this.isShowing() && this.getScale() < f && this.getScale() < this.prevPreferredScale) {
            f = this.getScale();
        }
        this.prevPreferredScale = this.preferredScale;
        this.preferredScale = f;
        this.revalidate();
        this.repaint();
        this.notifyListeners(f);
    }

    @Override
    public final void setIntegerScaling(boolean bl) {
        this.integerScaling = bl;
        if (bl) {
            this.setPreferredScale((int)this.getScale());
        }
    }

    protected void scaleUpdated() {
        this.notifyListeners(this.getScale());
        this.revalidate();
        this.repaint();
    }

    private void notifyListeners(float f) {
        for (ScaleListener scaleListener : this.listeners) {
            scaleListener.setPreferredScale(f);
        }
    }

    @Override
    public final void addScaleListener(ScaleListener scaleListener) {
        if (scaleListener == this) {
            throw new IllegalArgumentException("A scalable must not listen to itself.");
        }
        if (!this.listeners.contains(scaleListener)) {
            this.listeners.add(scaleListener);
            scaleListener.setPreferredScale(this.getScale());
        }
    }

    @Override
    public final void removeScaleListener(ScaleListener scaleListener) {
        this.listeners.remove(scaleListener);
    }
}

