/*
 * Decompiled with CFR 0.152.
 */
package mastersystem;

import java.util.LinkedList;
import mastersystem.OutputListener;

public class TMS9918A {
    private static final int CYCLES_PER_LINE = 228;
    private static final int PIXELS_PER_LINE = 342;
    public static final int RENDER_LINE = 0;
    public static final int SET_MODE = 1;
    public static final int CRAM_WRITE = 2;
    public static final int VRAM_WRITE = 3;
    public static final int INTERRUPT = 191;
    private final int SCANLINES;
    private LinkedList<OutputListener> listenerList = new LinkedList();
    private OutputListener[] listeners = new OutputListener[0];
    protected int[] vram = new int[16384];
    protected int[] cram = new int[32];
    private int[] regs = new int[11];
    private int regStatus;
    private int regCode;
    private int regAddress;
    private int buffer;
    private boolean hiByteNext;
    private int height;
    private int line;
    private int hCounter;
    private int counter;
    private int spriteCollisionCycle;
    private boolean lineInterruptPending;
    private boolean lineInterruptDelayed;
    private int timer;

    public TMS9918A(int n) {
        this.SCANLINES = n;
    }

    public int[] getVRAM() {
        return this.vram;
    }

    public int[] getCRAM() {
        return this.cram;
    }

    public int getLine() {
        return this.line;
    }

    public int getHCounter() {
        return this.hCounter;
    }

    public int getVCounter(int n) {
        this.update(n);
        this.timer += n;
        switch (this.getScreenHeight()) {
            case 192: {
                return this.line > 218 ? this.line - 6 : this.line;
            }
            case 224: {
                return this.line > 234 ? this.line - 6 : this.line;
            }
            case 240: {
                return this.line & 0xFF;
            }
        }
        return 0;
    }

    public int getModeBits() {
        return (this.regs[0] & 4) << 1 | (this.regs[1] & 8) >> 1 | this.regs[0] & 2 | (this.regs[1] & 0x10) >> 4;
    }

    public void setSpriteOverflowFlag() {
        this.regStatus |= 0x40;
    }

    public void setSpriteCollisionX(int n) {
        int n2 = n * 228 / 342 + 23;
        if (n2 < this.spriteCollisionCycle) {
            this.spriteCollisionCycle = n2;
        }
    }

    public int getScreenHeight() {
        if ((this.regs[0] & 4) != 0 && (this.regs[0] & 2) != 0 && (this.regs[1] >> 3 & 3) != 3) {
            if ((this.regs[1] & 8) != 0) {
                return 240;
            }
            if ((this.regs[1] & 0x10) != 0) {
                return 224;
            }
        }
        return 192;
    }

    public boolean isVertScrollInhibited() {
        return (this.regs[0] & 0x80) != 0;
    }

    public boolean isHorizScrollInhibited() {
        return (this.regs[0] & 0x40) != 0;
    }

    public boolean isLeftColumnBlank() {
        return (this.regs[0] & 0x20) != 0;
    }

    private boolean isLineInterruptEnabled() {
        return (this.regs[0] & 0x10) != 0;
    }

    public boolean isSpriteShiftEnabled() {
        return (this.regs[0] & 8) != 0;
    }

    public boolean isDisplayOn() {
        return (this.regs[1] & 0x40) != 0;
    }

    private boolean isFrameInterruptEnabled() {
        return (this.regs[1] & 0x20) != 0;
    }

    public boolean isLargeSpritesEnabled() {
        return (this.regs[1] & 2) != 0;
    }

    public boolean isDoubledSpritesEnabled() {
        return (this.regs[1] & 1) != 0;
    }

    public int getScreenMapBaseAddress() {
        if (this.getScreenHeight() > 192) {
            return (this.regs[2] & 0xC) << 10 | 0x700;
        }
        return (this.regs[2] & 0xE) << 10;
    }

    public int getColorTableAddress() {
        if (this.getModeBits() == 2) {
            return (this.regs[3] & 0x80) << 6;
        }
        return this.regs[3] << 6;
    }

    public int getColorTableMask() {
        if (this.getModeBits() == 2) {
            return this.regs[3] << 6 | 0x7F;
        }
        return 65535;
    }

    public int getPatternGeneratorTableAddress() {
        if ((this.getModeBits() & 2) != 0) {
            return (this.regs[4] & 4) << 11;
        }
        return (this.regs[4] & 7) << 11;
    }

    public int getPatternGeneratorTableMask() {
        if ((this.getModeBits() & 2) != 0) {
            return (this.regs[4] & 7) << 11 | 0x7FF;
        }
        return 65535;
    }

    public int getSpriteAttributeTableAddress() {
        if ((this.regs[0] & 4) != 0) {
            return (this.regs[5] & 0x7E) << 7;
        }
        return (this.regs[5] & 0x7F) << 7;
    }

    public int getSpritePatternAddress() {
        if ((this.regs[0] & 4) != 0) {
            return (this.regs[6] & 4) << 11;
        }
        return (this.regs[6] & 7) << 11;
    }

    public int getBackDropColor() {
        return this.regs[7] & 0xF;
    }

    public int getTextColor() {
        return this.regs[7] >> 4;
    }

    public int getHorizontalScroll() {
        if (this.line < 16 && this.isHorizScrollInhibited()) {
            return 0;
        }
        return this.regs[8];
    }

    public int getVerticalScroll() {
        return this.regs[9];
    }

    public int readByte(int n, int n2) {
        int n3 = -1;
        this.hiByteNext = false;
        switch (n) {
            case 0: {
                n3 = this.buffer;
                this.buffer = this.vram[this.regAddress];
                if (++this.regAddress < 16384) break;
                this.regAddress = 0;
                break;
            }
            case 1: {
                this.update(n2);
                if (228 - this.timer > this.spriteCollisionCycle) {
                    this.regStatus |= 0x20;
                }
                this.timer += n2;
                n3 = this.regStatus | 0x1F;
                this.regStatus = 0;
                this.lineInterruptPending = false;
                this.fireOutputAvailable(191, -1);
            }
        }
        return n3;
    }

    private void regWrite(int n, int n2) {
        int n3 = this.regs[n] ^ n2;
        this.regs[n] = n2;
        switch (n) {
            case 0: {
                if ((n3 & 0x10) != 0) {
                    this.fireOutputAvailable(191, this.lineInterruptPending && this.isLineInterruptEnabled() ? 1 : -1);
                }
                if ((n3 & 6) == 0) break;
                this.height = this.getScreenHeight();
                this.fireOutputAvailable(1, this.getModeBits());
                break;
            }
            case 1: {
                if ((n3 & 0x20) != 0) {
                    this.fireOutputAvailable(191, (this.regStatus & 0x80) != 0 && this.isFrameInterruptEnabled() ? 1 : -1);
                }
                if ((n3 & 0x18) == 0) break;
                this.height = this.getScreenHeight();
                this.fireOutputAvailable(1, this.getModeBits());
            }
        }
    }

    protected void cramWrite(int n, int n2) {
        boolean bl = this.cram[n & 0x1F] != n2;
        this.cram[n & 0x1F] = n2;
        this.fireOutputAvailable(2, bl ? 0x20 | n & 0x1F : n & 0x1F);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void processInput(int n, int n2, int n3) {
        this.update(n3);
        this.timer += n3;
        switch (n) {
            case 0: {
                this.buffer = n2;
                if (this.regCode == 3) {
                    this.cramWrite(this.regAddress, this.buffer);
                } else {
                    boolean bl = this.vram[this.regAddress] != this.buffer;
                    this.vram[this.regAddress] = this.buffer;
                    this.fireOutputAvailable(3, bl ? 0x8000 | this.regAddress : this.regAddress);
                }
                if (++this.regAddress >= 16384) {
                    this.regAddress = 0;
                }
                this.hiByteNext = false;
                return;
            }
            case 1: {
                if (this.hiByteNext) {
                    this.regCode = n2 >> 6;
                    this.regAddress = (n2 & 0x3F) << 8 | this.regAddress & 0xFF;
                    switch (this.regCode) {
                        case 0: {
                            this.buffer = this.vram[this.regAddress++];
                            if (this.regAddress < 16384) break;
                            this.regAddress = 0;
                            break;
                        }
                        case 1: {
                            break;
                        }
                        case 2: {
                            if ((n2 & 0xF) >= this.regs.length) break;
                            this.regWrite(n2 & 0xF, this.regAddress & 0xFF);
                            break;
                        }
                    }
                } else {
                    this.regAddress = this.regAddress & 0xFF00 | n2;
                }
                this.hiByteNext = !this.hiByteNext;
                return;
            }
        }
    }

    public void reset() {
        this.timer = 228;
        this.spriteCollisionCycle = 228;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void update(int n) {
        if (this.lineInterruptDelayed) {
            this.lineInterruptDelayed = false;
            this.fireOutputAvailable(191, 1);
            this.timer = 228 - n;
            return;
        }
        this.timer -= n;
        while (this.timer <= 0) {
            block11: {
                block10: {
                    if (this.line == this.height) {
                        this.regStatus |= 0x80;
                        if (this.isFrameInterruptEnabled()) {
                            this.fireOutputAvailable(191, 1);
                        }
                    }
                    if (++this.line >= this.SCANLINES) {
                        this.line = 0;
                    }
                    if (this.line > this.height) break block10;
                    if (this.spriteCollisionCycle < 228) {
                        this.regStatus |= 0x20;
                    }
                    this.spriteCollisionCycle = 228;
                    if (this.line < this.height) {
                        this.fireOutputAvailable(0, this.line);
                    }
                    if (--this.counter < 0) {
                        this.counter = this.regs[10];
                        this.lineInterruptPending = true;
                        if (this.isLineInterruptEnabled()) {
                            if (this.timer >= 0) {
                                this.lineInterruptDelayed = true;
                                return;
                            }
                            this.fireOutputAvailable(191, 1);
                        }
                    }
                    break block11;
                }
                this.counter = this.regs[10];
            }
            this.timer += 228;
        }
    }

    public void updateHCounter(int n) {
        this.update(n);
        this.hCounter = this.timer < 16 ? (228 - this.timer) * 342 / 228 + 147 & 0x1FF : (228 - this.timer) * 342 / 228 - 23 & 0x1FF;
        this.timer += n;
    }

    public int getTimer() {
        return this.timer;
    }

    protected final void fireOutputAvailable(int n, int n2) {
        OutputListener[] outputListenerArray = this.listeners;
        int n3 = this.listeners.length;
        int n4 = 0;
        while (n4 < n3) {
            OutputListener outputListener = outputListenerArray[n4];
            outputListener.outputAvailable(n, n2, 0);
            ++n4;
        }
    }

    public final void addOutputListener(OutputListener outputListener) {
        this.listenerList.addFirst(outputListener);
        this.listeners = this.listenerList.toArray(new OutputListener[this.listenerList.size()]);
    }

    public final void removeOutputListener(OutputListener outputListener) {
        this.listenerList.remove(outputListener);
        this.listeners = this.listenerList.toArray(new OutputListener[this.listenerList.size()]);
    }
}

