/*
 * Decompiled with CFR 0.152.
 */
package mastersystem;

import java.util.Arrays;
import java.util.LinkedList;
import mastersystem.OutputListener;

public class SN76489 {
    public static final int SIGNATURE = 0x220000;
    public static final int REGISTER_WRITE = 0x220000;
    public static final int STEREO_WRITE = 0x220001;
    public static final int UPDATE = 2228351;
    private final int UPDATE_CYCLES;
    private final int CYCLES_PER_SECOND;
    private final int FRAMES_PER_SECOND;
    private final LinkedList<OutputListener> listenerList = new LinkedList();
    private OutputListener[] listeners = new OutputListener[0];
    private final int[] regVolume = new int[4];
    private final int[] regTone = new int[3];
    private int regNoise;
    private int regStereo = 255;
    private int regLinearFeedbackShift;
    private int latchedRegister;
    private int timer;

    public SN76489(int n, int n2) {
        this.CYCLES_PER_SECOND = n;
        this.FRAMES_PER_SECOND = n2;
        this.UPDATE_CYCLES = n / n2;
    }

    public int getCyclesPerSecond() {
        return this.CYCLES_PER_SECOND;
    }

    public int getFramesPerSecond() {
        return this.FRAMES_PER_SECOND;
    }

    public int calcNextLFSRNumber() {
        if ((this.regNoise & 4) != 0) {
            int n = this.regLinearFeedbackShift & 9;
            n ^= n >> 8;
            n ^= n >> 4;
            n ^= n >> 2;
            n ^= n >> 1;
            this.regLinearFeedbackShift = (n & 1) << 15 | this.regLinearFeedbackShift >> 1;
        } else {
            this.regLinearFeedbackShift = (this.regLinearFeedbackShift & 1) << 15 | this.regLinearFeedbackShift >> 1;
        }
        return this.regLinearFeedbackShift & 1;
    }

    public int getVolume(int n) {
        if (n == 3) {
            return Math.min(15, this.regVolume[n] + 1);
        }
        return this.regVolume[n];
    }

    public int getFrequency(int n) {
        if (n == 3) {
            switch (this.regNoise & 3) {
                case 0: {
                    return this.CYCLES_PER_SECOND / 256;
                }
                case 1: {
                    return this.CYCLES_PER_SECOND / 512;
                }
                case 2: {
                    return this.CYCLES_PER_SECOND / 1024;
                }
                case 3: {
                    return this.getFrequency(2);
                }
            }
        }
        return this.CYCLES_PER_SECOND / (16 * this.regTone[n]);
    }

    public void processInput(int n, int n2, int n3) {
        this.update(n3);
        this.fireOutputAvailable(2228351, this.UPDATE_CYCLES - this.timer);
        this.timer += n3;
        if (n == 6) {
            this.regStereo = n2;
            this.fireOutputAvailable(0x220001, n2);
        } else {
            if ((n2 & 0x80) != 0) {
                this.latchedRegister = (n2 & 0x70) >> 4;
                if ((this.latchedRegister & 1) != 0) {
                    this.regVolume[this.latchedRegister >> 1] = n2 & 0xF;
                } else if (this.latchedRegister >> 1 == 3) {
                    this.regNoise = n2 & 0xF;
                    this.regLinearFeedbackShift = 32768;
                } else {
                    this.regTone[this.latchedRegister >> 1] = Math.max(1, this.regTone[this.latchedRegister >> 1] & 0x3F0 | n2 & 0xF);
                }
            } else if ((this.latchedRegister & 1) != 0) {
                this.regVolume[this.latchedRegister >> 1] = n2 & 0xF;
            } else if (this.latchedRegister >> 1 == 3) {
                this.regNoise = n2 & 0xF;
            } else {
                this.regTone[this.latchedRegister >> 1] = Math.max(1, (n2 & 0x3F) << 4 | this.regTone[this.latchedRegister >> 1] & 0xF);
            }
            this.fireOutputAvailable(0x220000, this.latchedRegister);
        }
    }

    public boolean isChannelEnabled(boolean bl, int n) {
        return (this.regStereo & 1 << (bl ? n : 4 + n)) != 0;
    }

    public void reset() {
        Arrays.fill(this.regVolume, 15);
        Arrays.fill(this.regTone, 1);
        this.regNoise = 0;
    }

    public void update(int n) {
        this.timer -= n;
        while (this.timer <= 0) {
            this.timer += this.UPDATE_CYCLES;
            this.fireOutputAvailable(2228351, -1);
        }
    }

    protected void fireOutputAvailable(int n, int n2) {
        OutputListener[] outputListenerArray = this.listeners;
        int n3 = this.listeners.length;
        int n4 = 0;
        while (n4 < n3) {
            OutputListener outputListener = outputListenerArray[n4];
            outputListener.outputAvailable(n, n2, 0);
            ++n4;
        }
    }

    public void addOutputListener(OutputListener outputListener) {
        if (!this.listenerList.contains(outputListener)) {
            this.listenerList.addFirst(outputListener);
            this.listeners = this.listenerList.toArray(new OutputListener[this.listenerList.size()]);
        }
    }

    public void removeOutputListener(OutputListener outputListener) {
        if (this.listenerList.remove(outputListener)) {
            this.listeners = this.listenerList.toArray(new OutputListener[this.listenerList.size()]);
        }
    }

    public State getState() {
        return new State(){

            @Override
            public int getRegVolume(int n) {
                return SN76489.this.regVolume[n];
            }

            @Override
            public int getRegTone(int n) {
                return SN76489.this.regTone[n];
            }

            @Override
            public int getRegNoise() {
                return SN76489.this.regNoise;
            }

            @Override
            public int getRegStereo() {
                return SN76489.this.regStereo;
            }

            @Override
            public int getRegLinearFeedbackShift() {
                return SN76489.this.regLinearFeedbackShift;
            }

            @Override
            public int getLatchedRegister() {
                return SN76489.this.latchedRegister;
            }

            @Override
            public int getTimer() {
                return SN76489.this.timer;
            }
        };
    }

    public void setState(State state) {
        int n = 0;
        while (n < this.regVolume.length) {
            this.regVolume[n] = state.getRegVolume(n);
            ++n;
        }
        n = 0;
        while (n < this.regTone.length) {
            this.regTone[n] = state.getRegTone(n);
            ++n;
        }
        this.regNoise = state.getRegNoise();
        this.regStereo = state.getRegStereo();
        this.regLinearFeedbackShift = state.getRegLinearFeedbackShift();
        this.latchedRegister = state.getLatchedRegister();
        this.timer = state.getTimer();
    }

    public static interface State {
        public int getRegVolume(int var1);

        public int getRegTone(int var1);

        public int getRegNoise();

        public int getRegStereo();

        public int getRegLinearFeedbackShift();

        public int getLatchedRegister();

        public int getTimer();
    }
}

