/*
 * Decompiled with CFR 0.152.
 */
package widgets;

import changes.Change;
import changes.ChangeListener;
import data.Palette;
import data.Tileset;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import mastersystem.Renderer;
import panels.Scalable;
import panels.ScaleListener;

public class TilesetCheckBox
extends JCheckBox
implements Scalable {
    private BufferedImage image;
    private BufferedImage scaledImage;
    private ImageIcon imageIcon;
    private Tileset tileset;
    private Palette palette;
    private Color[] colors = new Color[32];
    private float scale = 1.0f;
    private float prevPreferredScale;
    private float prevPrevPreferredScale;
    private Scalable scaleParent = this;
    private final ChangeListener tilesetChangeListener = new ChangeListener(){

        @Override
        public void changeOccurred(Change change) {
            TilesetCheckBox.this.update();
        }
    };
    private final ChangeListener paletteChangeListener = new ChangeListener(){

        @Override
        public void changeOccurred(Change change) {
            int n = change.getData(TilesetCheckBox.this.palette);
            if (n < 0) {
                int n2 = -n - 1;
                int n3 = n2 * 16;
                int n4 = n3 + 16;
                if (n2 == 2) {
                    n3 = 0;
                    n4 = 32;
                }
                int n5 = n3;
                while (n5 < n4) {
                    int n6 = TilesetCheckBox.this.palette.getColors()[n5];
                    int n7 = (n6 & 0x30) >> 4;
                    int n8 = (n6 & 0xC) >> 2;
                    int n9 = n6 & 3;
                    ((TilesetCheckBox)TilesetCheckBox.this).colors[n5] = new Color(n9 * 255 / 3, n8 * 255 / 3, n7 * 255 / 3);
                    ++n5;
                }
            } else {
                int n10 = TilesetCheckBox.this.palette.getColors()[n];
                int n11 = (n10 & 0x30) >> 4;
                int n12 = (n10 & 0xC) >> 2;
                int n13 = n10 & 3;
                ((TilesetCheckBox)TilesetCheckBox.this).colors[n] = new Color(n13 * 255 / 3, n12 * 255 / 3, n11 * 255 / 3);
            }
            TilesetCheckBox.this.update();
        }
    };

    public TilesetCheckBox(boolean bl, Tileset tileset, Palette palette) {
        super("", bl);
        this.setLayout(new BorderLayout());
        int n = tileset.getLength();
        this.image = n > 0 ? new BufferedImage(Math.min(256, n / 32 * 8), ((n / 32 - 1) / 32 + 1) * 8, 2) : new BufferedImage(8, 8, 2);
        this.imageIcon = new ImageIcon();
        this.add((Component)new JLabel(this.imageIcon), "Center");
        this.setTileset(tileset, palette);
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension dimension = super.getMinimumSize();
        return new Dimension(this.scaledImage.getWidth() + 48, dimension.height);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public Tileset getTileset() {
        return this.tileset;
    }

    public void setTileset(Tileset tileset, Palette palette) {
        if (this.tileset != null && this.tileset != tileset) {
            this.tileset.removeChangeListener(this.tilesetChangeListener);
        }
        this.tileset = tileset;
        tileset.addChangeListener(this.tilesetChangeListener);
        this.setPalette(palette);
    }

    public void setPalette(Palette palette) {
        if (this.palette != null && this.palette != palette) {
            this.palette.removeChangeListener(this.paletteChangeListener);
        }
        this.palette = palette;
        int n = 0;
        int[] nArray = palette.getColors();
        int n2 = nArray.length;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = nArray[n3];
            int n5 = (n4 & 0x30) >> 4;
            int n6 = (n4 & 0xC) >> 2;
            int n7 = n4 & 3;
            this.colors[n++] = new Color(n7 * 255 / 3, n6 * 255 / 3, n5 * 255 / 3);
            ++n3;
        }
        palette.addChangeListener(this.paletteChangeListener);
        this.update();
    }

    private void update() {
        this.ensureImageDimensions();
        Graphics2D graphics2D = this.image.createGraphics();
        graphics2D.setComposite(AlphaComposite.Clear);
        graphics2D.fillRect(0, 0, this.image.getWidth(), this.image.getHeight());
        graphics2D.dispose();
        int[] nArray = this.tileset.getVRAM();
        if (this.tileset.isSprite()) {
            int n = 0;
            while (n < this.tileset.getLength()) {
                Renderer.renderSpriteCharacter(nArray, (this.tileset.getDestination() + n) / 32, n / 32 % 32 * 8, n / 32 / 32 * 8, this.colors, this.image);
                n += 32;
            }
        } else {
            Graphics2D graphics2D2 = this.image.createGraphics();
            int n = 0;
            while (n < this.tileset.getLength()) {
                Renderer.renderCharacter(nArray, (this.tileset.getDestination() + n) / 32, n / 32 % 32 * 8, n / 32 / 32 * 8, this.colors, graphics2D2);
                n += 32;
            }
            graphics2D2.dispose();
        }
        graphics2D = this.scaledImage.createGraphics();
        graphics2D.drawImage(this.image, 0, 0, this.scaledImage.getWidth(), this.scaledImage.getHeight(), null);
        graphics2D.dispose();
        this.revalidate();
        this.repaint();
    }

    private void ensureImageDimensions() {
        int n = this.tileset.getLength();
        int n2 = Math.min(256, n / 32 * 8);
        int n3 = ((n / 32 - 1) / 32 + 1) * 8;
        if (this.image.getWidth() != n2 || this.image.getHeight() != n3) {
            this.image = new BufferedImage(n2, n3, 2);
        }
        int n4 = (int)((float)this.image.getWidth() * this.scale);
        int n5 = (int)((float)this.image.getHeight() * this.scale);
        if (this.scaledImage == null || this.scaledImage.getWidth() != n4 || this.scaledImage.getHeight() != n5) {
            this.scaledImage = new BufferedImage(n4, n5, this.image.getType());
            this.imageIcon.setImage(this.scaledImage);
        }
    }

    @Override
    public void setScaleParent(Scalable scalable) {
        if (scalable == null) {
            throw new IllegalArgumentException("ScaleParent must not be null.");
        }
        if (scalable != this.scaleParent && this.scaleParent != null) {
            this.scaleParent.removeScaleListener(this);
        }
        this.scaleParent = scalable;
        this.prevPreferredScale = 0.0f;
        this.prevPrevPreferredScale = 0.0f;
        scalable.addScaleListener(this);
    }

    @Override
    public float getScale() {
        return this.scale;
    }

    @Override
    public float getPreferredScale() {
        return this.scale;
    }

    @Override
    public boolean isIntegerScaling() {
        return false;
    }

    @Override
    public void setPreferredScale(float f) {
        float f2 = this.scale;
        if (f < this.prevPreferredScale || f != this.prevPrevPreferredScale) {
            this.scale = f;
        }
        this.prevPrevPreferredScale = this.prevPreferredScale;
        this.prevPreferredScale = f;
        if (Math.abs(this.scale - f2) > 0.01f) {
            this.update();
        }
    }

    @Override
    public void setIntegerScaling(boolean bl) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addScaleListener(ScaleListener scaleListener) {
    }

    @Override
    public void removeScaleListener(ScaleListener scaleListener) {
    }
}

