/*
 * Decompiled with CFR 0.152.
 */
package panels;

import changes.Changable;
import changes.Change;
import changes.ChangeListener;
import data.NameTable;
import data.Palette;
import data.SpriteContainer;
import data.Tiles;
import data.Tileset;
import data.TitleScreen;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.util.LinkedList;
import javax.swing.SwingUtilities;
import mastersystem.Renderer;
import panels.ScalablePanel;
import transactions.TransactionManager;

public class TitleScreenPanel
extends ScalablePanel {
    public static final int MODE_ENTITY_EDITING = 0;
    public static final int MODE_NAME_TABLE_EDITING = 1;
    private final BufferedImage titleScreenImage = new BufferedImage(256, 192, 1);
    private final Color[] colors = new Color[32];
    private Tileset tileset;
    private TitleScreen titleScreen;
    private Palette palette;
    private Tiles alexTiles;
    private Tiles jankenTiles;
    private SpriteContainer[] sprites;
    private int screen;
    private int mode = 0;
    private int selectedEntity = -1;
    private NameTable selectedNameTable;
    private int dragXstart;
    private int dragYstart;
    private int dragXoffset;
    private int dragYoffset;
    private NameTable[] nameTables;
    private Entity[] entities;
    private int offsetX;
    private int offsetY;
    private float scale = 1.0f;
    private final LinkedList<ActionListener> listeners = new LinkedList();
    private final ChangeListener tilesetChangeListener = new ChangeListener(){

        @Override
        public void changeOccurred(Change change) {
            if (change.getData(TitleScreenPanel.this.tileset) < 256) {
                TitleScreenPanel.this.update();
            }
        }
    };
    private final ChangeListener spriteChangeListener = new ChangeListener(){

        @Override
        public void changeOccurred(Change change) {
            TitleScreenPanel.this.update();
        }
    };
    private final ChangeListener paletteChangeListener = new ChangeListener(){

        @Override
        public void changeOccurred(Change change) {
            int n = change.getData(TitleScreenPanel.this.palette);
            if (n < 0) {
                int n2 = -n - 1;
                int n3 = n2 * 16;
                int n4 = n3 + 16;
                if (n2 == 2) {
                    n3 = 0;
                    n4 = 32;
                }
                int n5 = n3;
                while (n5 < n4) {
                    int n6 = TitleScreenPanel.this.palette.getColors()[n5];
                    int n7 = (n6 & 0x30) >> 4;
                    int n8 = (n6 & 0xC) >> 2;
                    int n9 = n6 & 3;
                    ((TitleScreenPanel)TitleScreenPanel.this).colors[n5] = new Color(n9 * 255 / 3, n8 * 255 / 3, n7 * 255 / 3);
                    ++n5;
                }
            } else {
                int n10 = TitleScreenPanel.this.palette.getColors()[n];
                int n11 = (n10 & 0x30) >> 4;
                int n12 = (n10 & 0xC) >> 2;
                int n13 = n10 & 3;
                ((TitleScreenPanel)TitleScreenPanel.this).colors[n] = new Color(n13 * 255 / 3, n12 * 255 / 3, n11 * 255 / 3);
            }
            TitleScreenPanel.this.update();
        }
    };
    private final ChangeListener nameTableChangeListener = new ChangeListener(){

        @Override
        public void changeOccurred(Change change) {
            TitleScreenPanel.this.update();
        }
    };
    private final ChangeListener titleScreenChangeListener = new ChangeListener(){

        @Override
        public void changeOccurred(Change change) {
            TitleScreenPanel.this.update();
        }
    };
    private final ChangeListener tilesChangeListener = new ChangeListener(){

        @Override
        public void changeOccurred(Change change) {
            TitleScreenPanel.this.update();
        }
    };

    public TitleScreenPanel(TitleScreen titleScreen, Tileset tileset, Palette palette, NameTable[] nameTableArray, Tiles tiles, Tiles tiles2, SpriteContainer[] spriteContainerArray) {
        final Cursor cursor = this.getCursor();
        final Cursor cursor2 = Cursor.getPredefinedCursor(12);
        this.setTitleScreen(titleScreen, tileset, palette, nameTableArray, tiles, tiles2, spriteContainerArray);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                int n = TitleScreenPanel.this.toScreenX(mouseEvent.getX());
                int n2 = TitleScreenPanel.this.toScreenY(mouseEvent.getY());
                if (TitleScreenPanel.this.mode == 0) {
                    if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                        TitleScreenPanel.this.selectedEntity = -1;
                    }
                    int n3 = TitleScreenPanel.this.entities.length - 1;
                    while (n3 >= 0) {
                        Entity entity = TitleScreenPanel.this.entities[n3];
                        if (entity != null && entity.contains(n, n2)) {
                            if (!SwingUtilities.isLeftMouseButton(mouseEvent)) break;
                            TransactionManager.getInstance().startTransaction();
                            TitleScreenPanel.this.titleScreen.startMoving(n3);
                            TitleScreenPanel.this.selectedEntity = n3;
                            TitleScreenPanel.this.dragXoffset = n - entity.hPos;
                            TitleScreenPanel.this.dragYoffset = n2 - entity.vPos;
                            TitleScreenPanel.this.dragXstart = n;
                            TitleScreenPanel.this.dragYstart = n2;
                            break;
                        }
                        --n3;
                    }
                    TitleScreenPanel.this.repaint();
                } else if (TitleScreenPanel.this.mode == 1) {
                    TitleScreenPanel.this.selectedNameTable = TitleScreenPanel.this.getNameTableAt(n, n2);
                    if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                        if (TitleScreenPanel.this.selectedNameTable != null) {
                            int n4 = (TitleScreenPanel.this.selectedNameTable.getDestination() - 14336) / 64 * 8;
                            int n5 = (TitleScreenPanel.this.selectedNameTable.getDestination() - 14336) % 64 / 2 * 8;
                            TitleScreenPanel.this.dragXoffset = n - n5;
                            TitleScreenPanel.this.dragYoffset = n2 - n4;
                            TitleScreenPanel.this.dragXstart = n;
                            TitleScreenPanel.this.dragYstart = n2;
                            TransactionManager.getInstance().startTransaction();
                            TitleScreenPanel.this.selectedNameTable.startMoving();
                        }
                    } else if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                        TitleScreenPanel.this.selectedNameTable = TitleScreenPanel.this.getNameTableAt(n, n2);
                        TitleScreenPanel.this.fireActionPerformed();
                    }
                    TitleScreenPanel.this.repaint();
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                int n = TitleScreenPanel.this.toScreenX(mouseEvent.getX());
                int n2 = TitleScreenPanel.this.toScreenY(mouseEvent.getY());
                if (n >= 0 && n2 >= 0 && n < TitleScreenPanel.this.titleScreenImage.getWidth() && n2 < TitleScreenPanel.this.titleScreenImage.getHeight()) {
                    NameTable nameTable;
                    if (TitleScreenPanel.this.mode == 0) {
                        int n3 = TitleScreenPanel.this.entities.length - 1;
                        while (n3 >= 0) {
                            Entity entity = TitleScreenPanel.this.entities[n3];
                            if (entity != null && entity.contains(n, n2)) {
                                TitleScreenPanel.this.setCursor(cursor2);
                                return;
                            }
                            --n3;
                        }
                    } else if (TitleScreenPanel.this.mode == 1 && (nameTable = TitleScreenPanel.this.getNameTableAt(n, n2)) != null) {
                        TitleScreenPanel.this.setCursor(cursor2);
                        return;
                    }
                }
                TitleScreenPanel.this.setCursor(cursor);
            }

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                int n = TitleScreenPanel.this.toScreenX(mouseEvent.getX());
                int n2 = TitleScreenPanel.this.toScreenY(mouseEvent.getY());
                if (n < 0 || n2 < 0 || n >= 256 || n2 >= 192) {
                    return;
                }
                if (mouseEvent.isShiftDown()) {
                    if (Math.abs(n - TitleScreenPanel.this.dragXstart) > Math.abs(n2 - TitleScreenPanel.this.dragYstart)) {
                        n2 = TitleScreenPanel.this.dragYstart;
                    } else {
                        n = TitleScreenPanel.this.dragXstart;
                    }
                }
                if (TitleScreenPanel.this.mode == 0) {
                    if (TitleScreenPanel.this.selectedEntity >= 0 && SwingUtilities.isLeftMouseButton(mouseEvent)) {
                        int n3 = 255;
                        if ((mouseEvent.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) != 0) {
                            n3 = 248;
                        }
                        TitleScreenPanel.this.titleScreen.setEntityPosition(TitleScreenPanel.this.selectedEntity, n2 - TitleScreenPanel.this.dragYoffset & n3, n - TitleScreenPanel.this.dragXoffset & n3);
                        TransactionManager.getInstance().commit();
                    }
                } else if (TitleScreenPanel.this.mode == 1 && TitleScreenPanel.this.selectedNameTable != null && SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    if ((n2 = (n2 - TitleScreenPanel.this.dragYoffset) / 8) < 0) {
                        n2 = 0;
                    }
                    if (n2 + TitleScreenPanel.this.selectedNameTable.getHeight() > 24) {
                        n2 = 24 - TitleScreenPanel.this.selectedNameTable.getHeight();
                    }
                    TitleScreenPanel.this.selectedNameTable.setDestination(14336 + (n2 << 6 | (n - TitleScreenPanel.this.dragXoffset) / 8 << 1 & 0x3F));
                    TransactionManager.getInstance().commit();
                }
            }
        });
    }

    public void setTitleScreen(TitleScreen titleScreen, Tileset tileset, Palette palette, NameTable[] nameTableArray, Tiles tiles, Tiles tiles2, SpriteContainer[] spriteContainerArray) {
        Changable changable;
        int n;
        int n2;
        Changable[] changableArray;
        if (this.tileset != null && this.tileset != tileset) {
            this.tileset.removeChangeListener(this.tilesetChangeListener);
        }
        if (this.palette != null && this.palette != palette) {
            this.palette.removeChangeListener(this.paletteChangeListener);
        }
        if (this.nameTables != null) {
            changableArray = this.nameTables;
            n2 = this.nameTables.length;
            n = 0;
            while (n < n2) {
                changable = changableArray[n];
                ((NameTable)changable).removeChangeListener(this.nameTableChangeListener);
                ++n;
            }
        }
        if (this.titleScreen != null && this.titleScreen != titleScreen) {
            this.titleScreen.removeChangeListener(this.titleScreenChangeListener);
        }
        if (this.alexTiles != null && this.alexTiles != tiles) {
            this.alexTiles.removeChangeListener(this.tilesChangeListener);
        }
        if (this.jankenTiles != null && this.jankenTiles != tiles2) {
            this.jankenTiles.removeChangeListener(this.tilesChangeListener);
        }
        if (this.sprites != null) {
            changableArray = this.sprites;
            n2 = this.sprites.length;
            n = 0;
            while (n < n2) {
                changable = changableArray[n];
                ((SpriteContainer)changable).removeChangeListener(this.spriteChangeListener);
                ++n;
            }
        }
        this.tileset = tileset;
        this.titleScreen = titleScreen;
        this.palette = palette;
        this.nameTables = nameTableArray;
        this.alexTiles = tiles;
        this.jankenTiles = tiles2;
        this.sprites = spriteContainerArray;
        int n3 = 0;
        Object[] objectArray = palette.getColors();
        int n4 = objectArray.length;
        n2 = 0;
        while (n2 < n4) {
            n = objectArray[n2];
            int n5 = (n & 0x30) >> 4;
            int n6 = (n & 0xC) >> 2;
            int n7 = n & 3;
            this.colors[n3++] = new Color(n7 * 255 / 3, n6 * 255 / 3, n5 * 255 / 3);
            ++n2;
        }
        tileset.addChangeListener(this.tilesetChangeListener);
        palette.addChangeListener(this.paletteChangeListener);
        objectArray = nameTableArray;
        n4 = nameTableArray.length;
        n2 = 0;
        while (n2 < n4) {
            int n8 = objectArray[n2];
            n8.addChangeListener(this.nameTableChangeListener);
            ++n2;
        }
        titleScreen.addChangeListener(this.titleScreenChangeListener);
        tiles.addChangeListener(this.tilesChangeListener);
        tiles2.addChangeListener(this.tilesChangeListener);
        objectArray = spriteContainerArray;
        n4 = spriteContainerArray.length;
        n2 = 0;
        while (n2 < n4) {
            int n9 = objectArray[n2];
            n9.addChangeListener(this.spriteChangeListener);
            ++n2;
        }
        this.update();
    }

    public NameTable getSelectedNameTable() {
        return this.selectedNameTable;
    }

    public void removeSelectedEntity() {
        if (this.selectedEntity < 0) {
            return;
        }
        TransactionManager.getInstance().runTransaction(new Runnable(){

            @Override
            public void run() {
                TitleScreenPanel.this.titleScreen.removeEntity(TitleScreenPanel.this.selectedEntity);
            }
        });
        this.selectedEntity = -1;
    }

    public void increaseScreenNumber() {
        if (this.canIncreaseScreenNumber()) {
            ++this.screen;
            this.update();
        }
    }

    public boolean canIncreaseScreenNumber() {
        return this.screen < this.titleScreen.getNumberOfScreens();
    }

    public void decreaseScreenNumber() {
        if (this.canDecreaseScreenNumber()) {
            --this.screen;
            this.update();
        }
    }

    public boolean canDecreaseScreenNumber() {
        return this.screen > 0;
    }

    private NameTable getNameTableAt(int n, int n2) {
        int n3 = this.screen + 1;
        while (n3 >= 0) {
            int n4;
            int n5 = (this.nameTables[n3].getDestination() - 14336) / 64 * 8;
            if (n2 >= n5 && n2 - n5 < this.nameTables[n3].getHeight() * 8 && n >= (n4 = (this.nameTables[n3].getDestination() - 14336) % 64 / 2 * 8) && n - n4 < this.nameTables[n3].getWidth() * 8) {
                return this.nameTables[n3];
            }
            --n3;
        }
        return null;
    }

    public void setMode(int n) {
        this.mode = n;
        this.selectedNameTable = null;
        this.selectedEntity = -1;
        this.repaint();
    }

    private void update() {
        Object object;
        int n;
        int n2;
        int n3;
        int[] nArray = this.titleScreen.getVRAM(this.screen);
        int[] nArray2 = this.tileset.getVRAM();
        Graphics2D graphics2D = this.titleScreenImage.createGraphics();
        int n4 = 0;
        while (n4 < 24) {
            n3 = 0;
            while (n3 < 32) {
                n2 = 14336 + (n4 << 6 | n3 << 1);
                Renderer.renderCharacter(nArray2, (nArray[n2 | 1] & 0xF) << 8 | nArray[n2], n3 * 8, n4 * 8, this.colors, graphics2D);
                ++n3;
            }
            ++n4;
        }
        graphics2D.dispose();
        Renderer.blankLeftMostColumn(this.colors, this.titleScreenImage);
        this.entities = new Entity[30];
        int[] nArray3 = this.titleScreen.getSAT();
        n3 = 6;
        while (n3 < 64 && nArray3[n3] != 208) {
            if (this.entities[this.titleScreen.getEntityIndex(n3)] == null) {
                this.entities[this.titleScreen.getEntityIndex((int)n3)] = new Entity(this.titleScreen.getEntityData(this.titleScreen.getEntityIndex(n3)));
            }
            if ((n2 = nArray3[n3] + 1) >= 240) {
                n2 -= 256;
            }
            n = nArray3[0x80 | n3 << 1];
            if (n2 < this.entities[this.titleScreen.getEntityIndex((int)n3)].top) {
                this.entities[this.titleScreen.getEntityIndex((int)n3)].top = n2;
            }
            if (n2 + 8 > this.entities[this.titleScreen.getEntityIndex((int)n3)].bottom) {
                this.entities[this.titleScreen.getEntityIndex((int)n3)].bottom = n2 + 8;
            }
            if (n < this.entities[this.titleScreen.getEntityIndex((int)n3)].left) {
                this.entities[this.titleScreen.getEntityIndex((int)n3)].left = n;
            }
            if (n + 8 > this.entities[this.titleScreen.getEntityIndex((int)n3)].right) {
                this.entities[this.titleScreen.getEntityIndex((int)n3)].right = n + 8;
            }
            ++n3;
        }
        n3 = 6;
        while (n3 < 64 && nArray3[n3] != 208) {
            n2 = nArray3[n3] + 1;
            if (n2 >= 240) {
                n2 -= 256;
            }
            n = nArray3[0x80 | n3 << 1];
            int n5 = nArray3[0x80 | n3 << 1 | 1];
            object = this.entities[this.titleScreen.getEntityIndex(n3)];
            if (((Entity)object).image == null) {
                int n6 = ((Entity)object).right - ((Entity)object).left;
                int n7 = ((Entity)object).bottom - ((Entity)object).top;
                ((Entity)object).image = new BufferedImage(n6, n7, 2);
                ((Entity)object).imageEmpty = true;
            }
            if (Renderer.renderSpriteCharacter(nArray, n5, n - ((Entity)object).left, n2 - ((Entity)object).top, this.colors, ((Entity)object).image)) {
                ((Entity)object).imageEmpty = false;
            }
            ++n3;
        }
        Entity[] entityArray = this.entities;
        n = this.entities.length;
        n2 = 0;
        while (n2 < n) {
            Entity entity = entityArray[n2];
            if (entity != null && entity.imageEmpty) {
                if (entity.right - entity.left <= 16 || entity.bottom - entity.top <= 14) {
                    if (entity.right - entity.left <= 16) {
                        entity.right = entity.left + 16;
                    }
                    if (entity.bottom - entity.top <= 14) {
                        entity.bottom = entity.top + 14;
                    }
                    entity.image = new BufferedImage(entity.right - entity.left, entity.bottom - entity.top, 2);
                }
                object = entity.image.createGraphics();
                ((Graphics)object).setColor(new Color(0.5f, 0.5f, 0.5f, 0.5f));
                ((Graphics)object).fillRect(0, 0, 16, 12);
                ((Graphics)object).setColor(Color.RED);
                ((Graphics2D)object).drawString(String.format("%02X", entity.type), 0, 10);
                ((Graphics)object).dispose();
            }
            ++n2;
        }
        int n8 = this.nameTables.length - 1;
        while (n8 > this.screen + 1 && this.selectedNameTable != null) {
            if (this.selectedNameTable == this.nameTables[n8]) {
                this.selectedNameTable = null;
            }
            --n8;
        }
        this.repaint();
    }

    @Override
    public Dimension getPreferredSize() {
        Insets insets = this.getInsets();
        return new Dimension((int)((float)this.titleScreenImage.getWidth() * this.getPreferredScale()) + insets.left + insets.right, (int)((float)this.titleScreenImage.getHeight() * this.getPreferredScale()) + insets.top + insets.bottom);
    }

    private int toScreenX(int n) {
        return n >= this.offsetX ? (int)((float)(n - this.offsetX) / this.scale) : (int)((float)(n - this.offsetX) / this.scale) - 1;
    }

    private int toScreenY(int n) {
        return n >= this.offsetY ? (int)((float)(n - this.offsetY) / this.scale) : (int)((float)(n - this.offsetY) / this.scale) - 1;
    }

    @Override
    public float getScale() {
        return this.scale;
    }

    protected final void fireActionPerformed() {
        for (ActionListener actionListener : this.listeners) {
            actionListener.actionPerformed(null);
        }
    }

    public final void addActionListener(ActionListener actionListener) {
        if (!this.listeners.contains(actionListener)) {
            this.listeners.add(actionListener);
        }
    }

    public final void removeActionListener(ActionListener actionListener) {
        this.listeners.remove(actionListener);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        Object object;
        super.paintComponent(graphics);
        BufferedImage bufferedImage = new BufferedImage(this.titleScreenImage.getWidth(), this.titleScreenImage.getHeight(), this.titleScreenImage.getType());
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage((Image)this.titleScreenImage, 0, 0, null);
        Entity[] entityArray = this.entities;
        int n = this.entities.length;
        int n2 = 0;
        while (n2 < n) {
            object = entityArray[n2];
            if (object != null) {
                graphics2D.drawImage((Image)((Entity)object).image, ((Entity)object).left, ((Entity)object).top, null);
            }
            ++n2;
        }
        if (this.mode == 0) {
            if (this.selectedEntity >= 0 && this.entities[this.selectedEntity] != null) {
                int n3 = this.entities[this.selectedEntity].left;
                n2 = this.entities[this.selectedEntity].top;
                n = this.entities[this.selectedEntity].right;
                int n4 = this.entities[this.selectedEntity].bottom;
                graphics2D.setColor(Color.MAGENTA);
                graphics2D.drawRect(n3, n2, n - n3, n4 - n2);
            }
        } else if (this.mode == 1 && this.selectedNameTable != null) {
            int n5 = (this.selectedNameTable.getDestination() - 14336) % 64 / 2;
            n2 = (this.selectedNameTable.getDestination() - 14336) / 64;
            graphics2D.setColor(Color.MAGENTA);
            graphics2D.drawRect(n5 * 8, n2 * 8, this.selectedNameTable.getWidth() * 8, this.selectedNameTable.getHeight() * 8);
        }
        graphics2D.dispose();
        object = this.getInsets();
        n2 = this.getWidth() - (((Insets)object).left + ((Insets)object).right);
        n = this.getHeight() - (((Insets)object).top + ((Insets)object).bottom);
        float f = (float)n2 / (float)bufferedImage.getWidth();
        float f2 = (float)n / (float)bufferedImage.getHeight();
        float f3 = Math.min(f, f2);
        if (this.isIntegerScaling()) {
            float f4;
            if ((this.scale != (float)((int)this.scale) || f3 - this.scale < 0.0f || f3 - this.scale >= 1.0f) && this.scale != (f4 = (float)Math.max(1, (int)(this.scale + Math.max(-1.0f, Math.min(1.0f, (f3 - this.scale) * 1.0f)))))) {
                this.scale = f4;
                this.scaleUpdated();
            }
        } else if (Math.abs(f3 - this.scale) * (float)bufferedImage.getWidth() > 2.0f && Math.abs(f3 - this.scale) * (float)bufferedImage.getHeight() > 2.0f) {
            this.scale += (f3 - this.scale) * 0.5f;
            this.scaleUpdated();
        }
        this.offsetX = Math.max(0, (int)(((float)n2 - (float)bufferedImage.getWidth() * this.scale) / 2.0f)) + ((Insets)object).left;
        this.offsetY = Math.max(0, (int)(((float)n - (float)bufferedImage.getHeight() * this.scale) / 2.0f)) + ((Insets)object).right;
        graphics.drawImage(bufferedImage, this.offsetX, this.offsetY, (int)((float)bufferedImage.getWidth() * this.scale), (int)((float)bufferedImage.getHeight() * this.scale), null);
    }

    private class Entity {
        public final int type;
        public final int hPos;
        public final int vPos;
        public int top = 256;
        public int bottom;
        public int left = 256;
        public int right;
        public boolean imageEmpty;
        public BufferedImage image;

        public Entity(int[] nArray) {
            this.type = nArray[0];
            this.hPos = nArray[2];
            this.vPos = nArray[1];
        }

        public boolean contains(int n, int n2) {
            return n >= this.left && n < this.right && n2 >= this.top && n2 < this.bottom;
        }
    }
}

