/*
 * Decompiled with CFR 0.152.
 */
package mastersystem;

import java.util.Arrays;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import mastersystem.SN76489;

public class SoundPlayer {
    private float CYCLES_PER_SAMPLE;
    private SN76489 psg;
    private int channels = 1;
    private int randomNumber;
    private int[] frequencyCounter = new int[4];
    private int[] channelDirection = new int[4];
    protected boolean soundEnabled;
    private boolean soundSupported;
    protected SourceDataLine line;
    protected int sampleRate;
    protected int volumeShift;
    protected byte[] buffer;
    protected int length;
    private static final int[] VOLUMES;

    static {
        int[] nArray = new int[16];
        nArray[0] = 1784;
        nArray[1] = 1784;
        nArray[2] = 1784;
        nArray[3] = 1520;
        nArray[4] = 1246;
        nArray[5] = 994;
        nArray[6] = 808;
        nArray[7] = 646;
        nArray[8] = 514;
        nArray[9] = 396;
        nArray[10] = 318;
        nArray[11] = 246;
        nArray[12] = 192;
        nArray[13] = 150;
        nArray[14] = 120;
        VOLUMES = nArray;
    }

    public SoundPlayer(int n, int n2) {
        this.sampleRate = n;
        AudioFormat audioFormat = new AudioFormat(n, 16, 1, true, false);
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioFormat);
        this.soundSupported = false;
        if (AudioSystem.isLineSupported(info)) {
            try {
                this.line = (SourceDataLine)AudioSystem.getLine(info);
                this.line.open(audioFormat, n2 * this.channels * 2 * n / 1000);
                this.line.start();
                this.soundSupported = true;
            }
            catch (LineUnavailableException lineUnavailableException) {}
        }
        Arrays.fill(this.channelDirection, 1);
    }

    public void setPSG(SN76489 sN76489) {
        this.psg = sN76489;
        this.CYCLES_PER_SAMPLE = (float)sN76489.getCyclesPerSecond() / (float)this.sampleRate;
        this.buffer = new byte[(int)Math.ceil((double)this.sampleRate / (double)sN76489.getFramesPerSecond() * (double)this.channels * 2.0)];
    }

    public void updateBuffer(int n) {
        if (!this.soundEnabled) {
            return;
        }
        int n2 = (int)((float)n / this.CYCLES_PER_SAMPLE);
        int n3 = n2 * this.channels * 2;
        while (this.length < n3) {
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            while (n6 < 4) {
                int n7 = (int)((float)VOLUMES[this.psg.getVolume(n6)] * this.calcAmplitude(n6));
                if (this.psg.isChannelEnabled(false, n6)) {
                    n4 += n7;
                }
                if (this.psg.isChannelEnabled(true, n6)) {
                    n5 += n7;
                }
                ++n6;
            }
            this.writeSample16bit(n4);
            if (this.channels <= 1) continue;
            this.writeSample16bit(n5);
        }
    }

    private float calcAmplitude(int n) {
        int n2 = this.psg.getFrequency(n);
        int n3 = this.frequencyCounter[n] * (n == 3 ? this.randomNumber : this.channelDirection[n]);
        int n4 = n;
        this.frequencyCounter[n4] = this.frequencyCounter[n4] - n2;
        while (this.frequencyCounter[n] <= 0) {
            int n5 = n;
            this.channelDirection[n5] = this.channelDirection[n5] ^ 1;
            if (n == 3) {
                if (this.channelDirection[n] == 1) {
                    this.randomNumber = this.psg.calcNextLFSRNumber();
                }
                n3 += Math.min(-this.frequencyCounter[n], this.sampleRate) * this.randomNumber;
            } else {
                n3 += Math.min(-this.frequencyCounter[n], this.sampleRate) * this.channelDirection[n];
            }
            int n6 = n;
            this.frequencyCounter[n6] = this.frequencyCounter[n6] + this.sampleRate;
        }
        if (n3 > n2) {
            n3 = n2;
        }
        return (float)n3 / (float)n2;
    }

    public void finishFrame() {
        if (!this.soundEnabled) {
            return;
        }
        this.updateBuffer((int)(((float)(this.buffer.length / this.channels / 2) + 0.5f) * this.CYCLES_PER_SAMPLE));
        this.play();
    }

    protected void writeSample16bit(int n) {
        if (n > Short.MAX_VALUE) {
            n = Short.MAX_VALUE;
        } else if (n < Short.MIN_VALUE) {
            n = Short.MIN_VALUE;
        }
        this.buffer[this.length++] = (byte)(n & 0xFF);
        this.buffer[this.length++] = (byte)(n >> 8);
    }

    public void setSoundEnabled(boolean bl) {
        boolean bl2 = this.soundEnabled = this.soundSupported && bl;
        if (!bl && this.line != null) {
            this.line.flush();
        }
    }

    public void setVolumeShift(int n) {
        this.volumeShift = n;
    }

    public void flush() {
        if (this.line != null) {
            this.line.flush();
        }
    }

    private void play() {
        if (!this.soundEnabled || this.line == null) {
            return;
        }
        this.line.write(this.buffer, 0, this.length);
        this.length = 0;
    }
}

