/*
 * Decompiled with CFR 0.152.
 */
package data;

import changes.Changable;
import changes.Change;
import changes.ChangeListener;
import editor.Z80Factory;
import editors.KiddEd;
import editors.TextProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.zip.CRC32;
import mastersystem.OutputListener;
import mastersystem.Z80;
import miracleworld.MiracleWorldEditorModel;
import patching.IPS;
import psg.PSGTools;
import rom.RomManager;
import transactions.TransactionManager;
import util.io.IOUtilities;
import vgm.VGMInterpreter;

public class Sound
implements Changable {
    private final int addressUpdateSound;
    private int metaChannel;
    private boolean repeat;
    private final int RAM_EFFECT_PRIORITY = 49427;
    private final int RAM_BANK_PSG = 49432;
    private final int RAM_BANK_PSG_SFX = 49433;
    private HashMap<Integer, Integer> priorities;
    private HashMap<Integer, Integer> priorityAddresses;
    private final LinkedList<ChangeListener> listeners = new LinkedList();

    public Sound(int n) {
        this.addressUpdateSound = n;
    }

    private static int getAddressPointers() {
        if (RomManager.StaticAccess.readByte(39379) == 201) {
            return 39380;
        }
        return 40456;
    }

    private static int getPointerRepeat() {
        return Sound.getAddressPointers();
    }

    private static int getPointerNoRepeat() {
        return Sound.getAddressPointers() + 2;
    }

    private static int getPointerSfx() {
        return Sound.getAddressPointers() + 4;
    }

    private static int getPointerSfxLoop() {
        return Sound.getAddressPointers() + 6;
    }

    private int[] getPSGdata(int n) {
        int[] nArray;
        if (n >= 48) {
            n += 3;
        }
        int[] nArray2 = new int[16384];
        int n2 = 0;
        if (this.isNativeEngine()) {
            int n3;
            nArray = new int[]{-1};
            final int[] nArray3 = new int[8];
            int[] nArray4 = new int[8];
            final int[] nArray5 = new int[65536];
            RomManager.StaticAccess.copyFromROM(0, nArray5, 0, 32768);
            RomManager.StaticAccess.loadBank2(nArray5, Sound.getBank());
            final Z80 z80 = Z80Factory.create(nArray5);
            nArray5[40198] = 0;
            nArray5[40199] = 0;
            z80.addOutputListener(new OutputListener(){

                @Override
                public void outputAvailable(int n, int n2, int n3) {
                    if (n >= 49432 && n < 49655) {
                        if (Sound.this.metaChannel < 0 && n == z80.getDE()) {
                            Sound.this.metaChannel = (n - 49432) / 32;
                            if (!Sound.this.isSFX()) {
                                nArray5[16384] = 245;
                                nArray5[16385] = 229;
                                nArray5[16386] = 221;
                                nArray5[16387] = 229;
                                nArray5[16388] = 225;
                                nArray5[16389] = 125;
                                nArray5[16390] = 225;
                                nArray5[16391] = 15;
                                nArray5[16392] = 15;
                                nArray5[16393] = 15;
                                nArray5[16394] = 15;
                                nArray5[16395] = 15;
                                nArray5[16396] = 230;
                                nArray5[16397] = 7;
                                nArray5[16398] = 254;
                                nArray5[16399] = 3;
                                nArray5[16400] = 218;
                                nArray5[16401] = 0;
                                nArray5[16402] = 192;
                                nArray5[16403] = 241;
                                nArray5[16404] = 195;
                                nArray5[16405] = nArray5[40174];
                                nArray5[16406] = nArray5[40175];
                                nArray5[40174] = 0;
                                nArray5[40175] = 64;
                            } else {
                                nArray5[40174] = 0;
                                nArray5[40175] = 192;
                            }
                        }
                    } else if (n == 127) {
                        if ((n2 & 0x80) != 0) {
                            nArray[0] = (n2 & 0x70) >> 4;
                            nArray3[nArray[0]] = (nArray[0] & 1) != 0 ? n2 & 0xF : (nArray[0] >> 1 == 3 ? 0x400 | n2 & 0xF : nArray3[nArray[0]] & 0x3F0 | n2 & 0xF);
                        } else if (nArray[0] >= 0) {
                            nArray3[nArray[0]] = (nArray[0] & 1) != 0 ? n2 & 0xF : (nArray[0] >> 1 == 3 ? nArray3[nArray[0]] & 0x400 | n2 & 0xF : (n2 & 0x3F) << 4 | nArray3[nArray[0]] & 0xF);
                        }
                    } else if (n == 65535) {
                        RomManager.StaticAccess.loadBank2(nArray5, n2);
                    }
                }
            });
            Arrays.fill(nArray4, -1);
            System.arraycopy(nArray4, 0, nArray3, 0, nArray4.length);
            this.metaChannel = -1;
            nArray5[49424] = 0x80 | n + 1;
            boolean bl = false;
            this.repeat = false;
            do {
                if (!z80.execute(this.addressUpdateSound)) {
                    bl = true;
                    this.repeat = z80.getPC() == 49152;
                }
                n3 = 0;
                while (n3 < nArray4.length && n2 < nArray2.length) {
                    if (nArray4[n3] != nArray3[n3]) {
                        nArray2[n2++] = 0x80 | n3 << 4 | nArray3[n3] & 0xF;
                        if ((n3 & 1) == 0 && n3 >> 1 < 3 && (nArray4[n3] & 0xFFFFFFF0) != (nArray3[n3] & 0xFFFFFFF0) && n2 < nArray2.length) {
                            nArray2[n2++] = 0x40 | nArray3[n3] >> 4;
                        }
                    }
                    int n4 = n3;
                    nArray3[n4] = nArray3[n4] & 0x3FF;
                    nArray4[n3] = nArray3[n3];
                    ++n3;
                }
                n3 = 1;
                int n5 = 0;
                while (n5 < 7 && n3 != 0) {
                    if ((nArray5[49432 + 32 * n5] & 0x80) != 0 && (nArray5[49432 + 32 * n5 + 10] | nArray5[49432 + 32 * n5 + 11]) != 0) {
                        n3 = 0;
                    }
                    ++n5;
                }
                if (n2 > 0 && (nArray2[n2 - 1] & 0xF8) == 56 && (nArray2[n2 - 1] & 7) < 7) {
                    int n6 = n2 - 1;
                    nArray2[n6] = nArray2[n6] + 1;
                    continue;
                }
                if (n2 >= nArray2.length) continue;
                nArray2[n2++] = 56;
            } while (n3 == 0 && n2 < nArray2.length && !bl);
            if (n2 < nArray2.length) {
                nArray2[n2++] = 0;
            } else {
                nArray2[nArray2.length - 1] = 0;
            }
        } else {
            int n7 = Sound.READ_WORD(this.findJumpTablePlaySound() + 2 * n);
            if (Sound.READ_BYTE(n7) == 62 && Sound.READ_WORD(n7 + 6) >= 16384) {
                int n8 = Sound.RESOLVE_ADDRESS(Sound.READ_WORD(n7 + 6), Sound.READ_BYTE(n7 + 1));
                while (RomManager.StaticAccess.readByte(n8) > 0) {
                    if (RomManager.StaticAccess.readByte(n8) < 56 && RomManager.StaticAccess.readByte(n8) >= 8) {
                        nArray2[n2++] = RomManager.StaticAccess.readByte(n8++);
                        nArray2[n2++] = RomManager.StaticAccess.readByte(n8++);
                    }
                    nArray2[n2++] = RomManager.StaticAccess.readByte(n8++);
                }
                nArray2[n2++] = 0;
            }
        }
        nArray = new int[n2];
        System.arraycopy(nArray2, 0, nArray, 0, n2);
        return nArray;
    }

    public void replaceNativeEngineByPSGlib() throws IOException {
        this.replaceNativeEngineByPSGlib(null);
    }

    public void replaceNativeEngineByPSGlib(int[][] object) throws IOException {
        if (!this.isNativeEngine()) {
            return;
        }
        if (object == null) {
            object = new int[this.getSoundCount()][];
        }
        boolean[] blArray = new boolean[((int[][])object).length];
        boolean[] blArray2 = new boolean[((int[][])object).length];
        int[] nArray = new int[((int[][])object).length];
        File file = new File(new File(KiddEd.getHomeDirectory(), "PSGlib"), "PSGlibKiddEd.ips");
        CRC32 cRC32 = new CRC32();
        cRC32.update(IOUtilities.toByteArray(new FileInputStream(file)));
        if (cRC32.getValue() != 3143863770L) {
            throw new IOException(TextProvider.get("MessageErrorPSGlibWrongChecksum"));
        }
        IPS iPS = new IPS(file);
        int n = 0;
        while (n < ((int[][])object).length) {
            if (object[n] == null) {
                object[n] = this.getPSGdata(n);
            } else {
                this.getPSGdata(n);
            }
            blArray[n] = this.isSFX();
            blArray2[n] = this.repeat;
            nArray[n] = object[n].length;
            ++n;
        }
        if (!KiddEd.ensureFreeBlocks(nArray)) {
            throw new IOException(TextProvider.get("MessageErrorNotEnoughSpace"));
        }
        KiddEd.applyPatch(iPS);
        n = this.findJumpTablePlaySound();
        int n2 = 0;
        while (n2 < this.getSoundCount()) {
            int[] nArray2;
            int n3;
            if (blArray[n2]) {
                n3 = Sound.READ_WORD(Sound.getPointerSfx());
                if (blArray2[n2]) {
                    n3 = Sound.READ_WORD(Sound.getPointerSfxLoop());
                }
                int[] nArray3 = new int[13];
                nArray3[0] = 62;
                nArray3[2] = 50;
                nArray3[3] = 25;
                nArray3[4] = 193;
                nArray3[5] = 33;
                nArray3[8] = 14;
                nArray3[10] = 195;
                nArray3[11] = n3 & 0xFF;
                nArray3[12] = n3 >> 8;
                nArray2 = nArray3;
            } else {
                n3 = Sound.READ_WORD(Sound.getPointerNoRepeat());
                if (blArray2[n2]) {
                    n3 = Sound.READ_WORD(Sound.getPointerRepeat());
                }
                int[] nArray4 = new int[11];
                nArray4[0] = 62;
                nArray4[2] = 50;
                nArray4[3] = 24;
                nArray4[4] = 193;
                nArray4[5] = 33;
                nArray4[8] = 195;
                nArray4[9] = n3 & 0xFF;
                nArray4[10] = n3 >> 8;
                nArray2 = nArray4;
            }
            n3 = KiddEd.findFreeBlock(nArray2.length, 2);
            int n4 = 0;
            while (n4 < nArray2.length) {
                RomManager.StaticAccess.writeByte(n3 + n4, nArray2[n4]);
                ++n4;
            }
            RomManager.StaticAccess.writeByte(n + 2 * n2, n3 & 0xFF);
            RomManager.StaticAccess.writeByte(n + 2 * n2 + 1, n3 >> 8);
            ++n2;
        }
        while (this.getSoundCount() < ((int[][])object).length) {
            this.addSound();
        }
        n2 = 0;
        while (n2 < ((int[][])object).length) {
            this.replaceSound(n2, object[n2], true);
            ++n2;
        }
        this.priorities = null;
        this.priorityAddresses = null;
    }

    public void replacePSGlibByNativeEngine() {
        if (this.isNativeEngine()) {
            return;
        }
        int n = 0;
        while (n < this.getSoundCount()) {
            int n2 = n >= 48 ? n + 3 : n;
            this.removeSound(n2);
            int n3 = Sound.READ_WORD(this.findJumpTablePlaySound() + 2 * n2);
            int n4 = 0;
            while (n3 + n4 < 49152) {
                int n5 = RomManager.StaticAccess.readByte(n3 + n4);
                if (n5 == 62 || n5 == 14 || n5 == 201) {
                    ++n4;
                } else if (n5 == 50 || n5 == 33) {
                    n4 += 2;
                } else {
                    if (n5 == 195 && RomManager.StaticAccess.readWord(n3 + n4 + 1) >= 32768 && RomManager.StaticAccess.readWord(n3 + n4 + 1) < 49152) {
                        RomManager.StaticAccess.fill(n3, n3 + n4 + 3, 255);
                        break;
                    }
                    System.err.println("Failed to remove code because " + Integer.toHexString(n5) + " was encountered at " + Integer.toHexString(n3 + n4) + ".");
                    break;
                }
                ++n4;
            }
            ++n;
        }
        MiracleWorldEditorModel.relocateAssetsInBank(2);
        RomManager.StaticAccess.restoreBytes(38991, 6838);
        this.priorities = null;
    }

    public boolean canAdjustTempo() {
        return RomManager.StaticAccess.readByte(38994) == 205 && RomManager.StaticAccess.readWord(RomManager.StaticAccess.readWord(38995) + 1) == 49434;
    }

    public boolean canUpgradePSGlibEngine() {
        return !this.isNativeEngine() && (!this.canAddSound() || RomManager.StaticAccess.readByte(38994) != 205 || RomManager.StaticAccess.readByte(38997) != 205 || RomManager.StaticAccess.readByte(39379) == 201 || RomManager.StaticAccess.readByte(39574) == 195);
    }

    public void upgradePSGlibEngine() throws IOException {
        int n;
        if (this.isNativeEngine()) {
            return;
        }
        int[] nArray = new int[this.getSoundCount()];
        int[][] nArrayArray = new int[this.getSoundCount()][];
        int[] nArray2 = new int[this.getSoundCount()];
        boolean[] blArray = new boolean[this.getSoundCount()];
        int n2 = 0;
        while (n2 < nArrayArray.length) {
            nArrayArray[n2] = this.getPSGdata(n2);
            n = this.getSoundStoppedCodeAddress(n2);
            nArray[n2] = n >= 38991 && n < 45829 ? -1 : n;
            nArray2[n2] = this.hasPriority(n2) ? this.getPriority(n2) : -1;
            blArray[n2] = this.isRepeat(n2);
            ++n2;
        }
        this.replacePSGlibByNativeEngine();
        this.replaceNativeEngineByPSGlib(nArrayArray);
        n2 = 0;
        while (n2 < nArrayArray.length) {
            n = nArray[n2];
            if (n >= 0) {
                this.setSoundStoppedCodeAddress(n2, n);
            }
            if (nArray2[n2] >= 0) {
                this.setPriority(n2, nArray2[n2]);
            }
            this.setRepeat(n2, blArray[n2]);
            ++n2;
        }
    }

    public boolean isNativeEngine() {
        return !RomManager.StaticAccess.isChanged(38991, 38998) || !RomManager.StaticAccess.isChanged(39379);
    }

    public boolean isAdjustTempo() {
        int n = Sound.READ_WORD(38995);
        return n < 49152 && Sound.READ_BYTE(n) == 33;
    }

    public void setAdjustTempo(boolean bl) {
        RomManager.StaticAccess.writeByte(Sound.READ_WORD(38995), bl ? 33 : 201);
    }

    public int makeSpace(int n, int n2) {
        if (this.isNativeEngine()) {
            return -1;
        }
        int n3 = this.findJumpTablePlaySound();
        int n4 = this.getSoundCount();
        int n5 = 0;
        while (n5 < n4) {
            int[] nArray;
            int n6 = Sound.READ_WORD(n3 + 2 * (n5 >= 48 ? n5 + 3 : n5));
            if (Sound.READ_BYTE(n6) == 62 && Sound.READ_BYTE(n6 + 1) == n2 && (nArray = this.getPSGdata(n5)).length >= n) {
                int n7 = Sound.RESOLVE_ADDRESS(Sound.READ_WORD(n6 + 6), Sound.READ_BYTE(n6 + 1));
                this.replaceSound(n5, nArray, true);
                return n7;
            }
            ++n5;
        }
        return -1;
    }

    public void relocateSoundsInBank(int n) {
        if (this.isNativeEngine()) {
            return;
        }
        int n2 = this.findJumpTablePlaySound();
        int n3 = this.getSoundCount();
        int n4 = 0;
        while (n4 < n3) {
            int n5 = Sound.READ_WORD(n2 + 2 * (n4 >= 48 ? n4 + 3 : n4));
            if (Sound.READ_BYTE(n5) == 62 && Sound.READ_BYTE(n5 + 1) == n) {
                this.replaceSound(n4, this.getPSGdata(n4), true);
            }
            ++n4;
        }
    }

    public void relocateSoundsInRange(int n, int n2) {
        if (this.isNativeEngine()) {
            return;
        }
        int n3 = n / 16384;
        int n4 = (n2 - 1) / 16384;
        int n5 = this.findJumpTablePlaySound();
        int n6 = this.getSoundCount();
        int n7 = 0;
        while (n7 < n6) {
            int n8 = Sound.READ_WORD(n5 + 2 * (n7 >= 48 ? n7 + 3 : n7));
            int n9 = Sound.READ_BYTE(n8 + 1);
            if (Sound.READ_BYTE(n8) == 62 && (n9 == n3 || n9 == n4)) {
                int[] nArray = this.getPSGdata(n7);
                int n10 = Sound.RESOLVE_ADDRESS(RomManager.StaticAccess.readWord(n8 + 6), n9);
                if (n10 + nArray.length >= n && n10 < n2) {
                    this.replaceSound(n7, nArray, true);
                }
            }
            ++n7;
        }
    }

    public void printSounds() {
        if (this.isNativeEngine()) {
            System.out.println("Native");
            return;
        }
        int n = this.findJumpTablePlaySound();
        int n2 = 0;
        while (n2 < this.getSoundCount()) {
            int n3 = Sound.READ_WORD(n + 2 * n2);
            if (n3 > 0 && Sound.READ_BYTE(n3) == 62 && Sound.READ_WORD(n3 + 6) >= 16384) {
                int n4 = Sound.RESOLVE_ADDRESS(Sound.READ_WORD(n3 + 6), Sound.READ_BYTE(n3 + 1));
                if (!this.isSoundValid(n2)) {
                    System.out.println("\t" + String.format("%02X ", 0x80 | (n2 >= 48 ? n2 + 3 + 1 : n2 + 1)) + Integer.toHexString(n4) + " invalid");
                } else {
                    int n5 = this.getSoundSizeAt(n4);
                    System.out.println("\t" + String.format("%02X ", 0x80 | (n2 >= 48 ? n2 + 3 + 1 : n2 + 1)) + Integer.toHexString(n4) + "-" + Integer.toHexString(n4 + n5) + " (" + n5 + " Bytes)");
                }
            }
            ++n2;
        }
    }

    public int getSoundSize(int n) {
        if (this.isNativeEngine()) {
            return -1;
        }
        int n2 = this.findJumpTablePlaySound();
        int n3 = Sound.READ_WORD(n2 + 2 * n);
        if (n3 > 0 && Sound.READ_BYTE(n3) == 62 && Sound.READ_WORD(n3 + 6) >= 16384) {
            return this.getSoundSizeAt(Sound.RESOLVE_ADDRESS(Sound.READ_WORD(n3 + 6), Sound.READ_BYTE(n3 + 1)));
        }
        return -1;
    }

    private int getSoundSizeAt(int n) {
        if (this.isNativeEngine()) {
            return -1;
        }
        int n2 = n;
        while (RomManager.StaticAccess.readByte(n2) > 0) {
            if (RomManager.StaticAccess.readByte(n2) < 56 && RomManager.StaticAccess.readByte(n2) >= 8) {
                n2 += 2;
            }
            ++n2;
        }
        return ++n2 - n;
    }

    public boolean isSoundCompressed(int n) {
        if (this.isNativeEngine()) {
            return false;
        }
        int n2 = this.findJumpTablePlaySound();
        int n3 = Sound.READ_WORD(n2 + 2 * n);
        if (n3 > 0 && Sound.READ_BYTE(n3) == 62 && Sound.READ_WORD(n3 + 6) >= 16384) {
            return this.isSoundCompressedAt(Sound.RESOLVE_ADDRESS(Sound.READ_WORD(n3 + 6), Sound.READ_BYTE(n3 + 1)));
        }
        return false;
    }

    private boolean isSoundCompressedAt(int n) {
        if (this.isNativeEngine()) {
            return false;
        }
        int n2 = n;
        while (RomManager.StaticAccess.readByte(n2) > 0) {
            if (RomManager.StaticAccess.readByte(n2) < 56 && RomManager.StaticAccess.readByte(n2) >= 8) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isSoundValid(int n) {
        if (this.isNativeEngine()) {
            return true;
        }
        int n2 = Sound.READ_WORD(this.findJumpTablePlaySound() + 2 * n);
        if (n2 > 0 && Sound.READ_BYTE(n2) == 62 && Sound.READ_WORD(n2 + 6) >= 16384) {
            int n3 = Sound.RESOLVE_ADDRESS(Sound.READ_WORD(n2 + 6), Sound.READ_BYTE(n2 + 1));
            int n4 = n3 / 16384;
            int n5 = 0;
            int n6 = n3;
            while (RomManager.StaticAccess.readByte(n6) > 0) {
                if (RomManager.StaticAccess.readByte(n6) == 255) {
                    if (++n5 >= 4) {
                        return false;
                    }
                } else {
                    n5 = 0;
                }
                if (n6 / 16384 != n4) {
                    return false;
                }
                if (RomManager.StaticAccess.readByte(n6) < 56 && RomManager.StaticAccess.readByte(n6) >= 8) {
                    if ((n3 + RomManager.StaticAccess.readWord(n6 + 1)) / 16384 != n4) {
                        return false;
                    }
                    n6 += 2;
                }
                ++n6;
            }
        }
        return true;
    }

    public void removeSound(int n) {
        if (!this.isSoundValid(n)) {
            throw new IllegalArgumentException("Cannot remove sound " + Integer.toHexString(0x80 | (n >= 48 ? n + 3 : n) + 1) + " because it is invalid.");
        }
        int n2 = Sound.READ_WORD(this.findJumpTablePlaySound() + 2 * n);
        if (n2 > 0 && Sound.READ_BYTE(n2) == 62 && Sound.READ_WORD(n2 + 6) >= 16384) {
            int n3 = Sound.RESOLVE_ADDRESS(Sound.READ_WORD(n2 + 6), Sound.READ_BYTE(n2 + 1));
            while (RomManager.StaticAccess.readByte(n3) > 0) {
                if (RomManager.StaticAccess.readByte(n3) < 56 && RomManager.StaticAccess.readByte(n3) >= 8) {
                    RomManager.StaticAccess.writeByte(n3++, 255);
                    RomManager.StaticAccess.writeByte(n3++, 255);
                }
                RomManager.StaticAccess.writeByte(n3++, 255);
            }
            RomManager.StaticAccess.writeByte(n3, 255);
            RomManager.StaticAccess.writeByte(n2, 201);
        }
    }

    public boolean canAddSound() {
        if (this.isNativeEngine()) {
            return false;
        }
        int n = Sound.READ_WORD(38992);
        while (n < 45829) {
            if (Sound.READ_BYTE(n) == 254 && Sound.READ_BYTE(n + 1) == 48 && Sound.READ_BYTE(n + 2) == 48 && Sound.READ_BYTE(n + 3) == 3) {
                return false;
            }
            if (Sound.READ_BYTE(n) == 201) {
                return true;
            }
            ++n;
        }
        return true;
    }

    public void addSound() {
        if (!this.canAddSound()) {
            return;
        }
        int n = Sound.findMaxSoundNumber();
        int n2 = Sound.READ_BYTE(n) - 129;
        int n3 = n2 * 2;
        int n4 = n3 + 2;
        int n5 = Sound.READ_WORD(Sound.getPointerRepeat());
        int[] nArray = new int[11];
        nArray[0] = 62;
        nArray[2] = 50;
        nArray[3] = 24;
        nArray[4] = 193;
        nArray[5] = 33;
        nArray[8] = 195;
        nArray[9] = n5 & 0xFF;
        nArray[10] = n5 >> 8;
        int[] nArray2 = nArray;
        int[] nArray3 = KiddEd.findFreeBlocks(new int[]{n4, n4, n4, nArray2.length}, 2);
        if (nArray3 != null) {
            int[] nArray4 = new int[]{this.findJumpTablePlaySoundAddr(), this.findJumpTableHandleSoundRequestAddr(), this.findJumpTableHandleSoundStoppedAddr()};
            TransactionManager.getInstance().addTransactionObject(this, n2);
            RomManager.StaticAccess.incByte(n);
            nArray2[0] = 201;
            RomManager.StaticAccess.writeBytes(nArray2, nArray3[nArray4.length]);
            int n6 = 0;
            while (n6 < nArray4.length) {
                n5 = Sound.READ_WORD(nArray4[n6]);
                RomManager.StaticAccess.writeByte(nArray4[n6], nArray3[n6] & 0xFF);
                RomManager.StaticAccess.writeByte(nArray4[n6] + 1, 0x80 | nArray3[n6] >> 8 & 0x3F);
                RomManager.StaticAccess.copyBytes(n5, nArray3[n6], n3);
                if (n6 == 0 && n2 <= 51) {
                    RomManager.StaticAccess.fill(n5, n5 + n3 - 6, 255);
                    RomManager.StaticAccess.fill(nArray3[0] + n3 - 6, nArray3[0] + n3, 0);
                } else {
                    RomManager.StaticAccess.fill(n5, n5 + n3, 255);
                }
                ++n6;
            }
            RomManager.StaticAccess.writeByte(nArray3[0] + n3, nArray3[nArray4.length] & 0xFF);
            RomManager.StaticAccess.writeByte(nArray3[0] + n3 + 1, 0x80 | nArray3[nArray4.length] >> 8 & 0x3F);
            n5 = Sound.READ_WORD(this.findJumpTableHandleSoundRequest());
            RomManager.StaticAccess.writeByte(nArray3[1] + n3, n5 & 0xFF);
            RomManager.StaticAccess.writeByte(nArray3[1] + n3 + 1, 0x80 | n5 >> 8 & 0x3F);
            n5 = Sound.READ_WORD(this.findJumpTableHandleSoundStopped());
            RomManager.StaticAccess.writeByte(nArray3[2] + n3, n5 & 0xFF);
            RomManager.StaticAccess.writeByte(nArray3[2] + n3 + 1, 0x80 | n5 >> 8 & 0x3F);
        }
    }

    public int getSoundCount() {
        return Sound.READ_BYTE(Sound.findMaxSoundNumber()) - 129 - 3;
    }

    public boolean canRestoreSound(int n) {
        boolean bl;
        if (this.isNativeEngine()) {
            return false;
        }
        int[] nArray = new int[6838];
        RomManager.StaticAccess.readBytes(nArray, 38991);
        RomManager.StaticAccess.restoreBytes(38991, nArray.length);
        try {
            bl = n < this.getSoundCount();
        }
        finally {
            RomManager.StaticAccess.writeBytes(nArray, 38991);
        }
        return bl;
    }

    public void restoreSound(int n) {
        int[] nArray;
        if (!this.canRestoreSound(n)) {
            return;
        }
        int[] nArray2 = new int[6838];
        RomManager.StaticAccess.readBytes(nArray2, 38991);
        RomManager.StaticAccess.restoreBytes(38991, nArray2.length);
        try {
            nArray = this.getPSGdata(n);
        }
        finally {
            RomManager.StaticAccess.writeBytes(nArray2, 38991);
        }
        this.replaceSound(n, nArray, false);
    }

    public void exportSound(int n, File file) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            int[] nArray = this.getPSGdata(n);
            byte[] byArray = new byte[nArray.length];
            int n2 = 0;
            while (n2 < byArray.length) {
                byArray[n2] = (byte)nArray[n2];
                ++n2;
            }
            ((OutputStream)fileOutputStream).write(byArray);
            ((OutputStream)fileOutputStream).close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public boolean replaceSound(int n, File file) throws IOException {
        int[] nArray;
        if (this.isNativeEngine()) {
            throw new IOException(TextProvider.get("MessageErrorSoundOriginalEngine"));
        }
        if (file.getName().endsWith(".vgm") || file.getName().endsWith(".vgz")) {
            VGMInterpreter vGMInterpreter = new VGMInterpreter(file);
            nArray = PSGTools.getPSGdata(vGMInterpreter, 735);
            vGMInterpreter.close();
        } else {
            if (file.length() >= 32769L) {
                throw new IOException(TextProvider.get("MessageErrorInputDataTooLong"));
            }
            byte[] byArray = IOUtilities.toByteArray(new FileInputStream(file));
            nArray = new int[byArray.length];
            int n2 = 0;
            while (n2 < byArray.length) {
                nArray[n2] = byArray[n2] & 0xFF;
                ++n2;
            }
        }
        if (nArray.length > 16384 && KiddEd.shouldCompressPSG()) {
            nArray = PSGTools.compressPSG(nArray);
        }
        if (nArray.length <= 0) {
            throw new IOException(TextProvider.get("MessageErrorInputDataEmpty"));
        }
        if (nArray.length > 16384) {
            throw new IOException(TextProvider.get("MessageErrorInputDataTooLong"));
        }
        if (nArray[nArray.length - 1] != 0) {
            throw new IOException(TextProvider.get("MessageErrorInputDataInvalid"));
        }
        return this.replaceSound(n, nArray, false);
    }

    private boolean replaceSound(int n, int[] nArray, boolean bl) {
        if (this.isNativeEngine() || nArray.length > 16384) {
            return false;
        }
        if (nArray.length > 0 && nArray[nArray.length - 1] != 0) {
            throw new IllegalArgumentException("Sound to insert is invalid.");
        }
        if (!this.isSoundValid(n)) {
            throw new IllegalArgumentException("Cannot replace sound " + Integer.toHexString(0x80 | (n >= 48 ? n + 3 : n) + 1) + " because it is invalid.");
        }
        if (n >= 48) {
            n += 3;
        }
        int n2 = Sound.READ_WORD(this.findJumpTablePlaySound() + 2 * n);
        if (nArray.length <= 0) {
            RomManager.StaticAccess.writeByte(n2, 201);
            return true;
        }
        int n3 = KiddEd.findFreeBlock(nArray.length);
        if (n3 >= 0) {
            if (!bl) {
                TransactionManager.getInstance().addTransactionObject(this, n);
            }
            this.removeSound(n);
            RomManager.StaticAccess.writeByte(n2, 62);
            RomManager.StaticAccess.writeByte(n2 + 1, n3 / 16384);
            RomManager.StaticAccess.writeByte(n2 + 6, n3 & 0xFF);
            RomManager.StaticAccess.writeByte(n2 + 7, 0x40 | n3 >> 8 & 0x3F);
            if (this.isSFX(n)) {
                int n4 = 0;
                int n5 = -1;
                int[] nArray2 = new int[]{15, 15, 15, 15};
                int n6 = 0;
                while (n6 < nArray.length && n4 != 3) {
                    if (nArray[n6] < 56 && nArray[n6] >= 8) {
                        n6 += 3;
                    } else if ((nArray[n6] & 0xC0) != 0) {
                        if ((nArray[n6] & 0x80) != 0) {
                            n5 = (nArray[n6] & 0x70) >> 4;
                        }
                        if (n5 == 6 && (nArray[n6] & 3) == 3) {
                            n4 |= 1;
                        } else if (n5 >= 0 && (n5 & 1) != 0) {
                            nArray2[n5 >> 1] = nArray[n6] & 0xF;
                        }
                        if (n5 >= 0 && nArray2[n5 >> 1] < 15) {
                            n4 |= Math.max(0, (n5 >> 1) - 1);
                        }
                    }
                    ++n6;
                }
                RomManager.StaticAccess.writeByte(n2 + 9, n4);
                int[] nArray3 = new int[nArray.length];
                int n7 = 0;
                int n8 = -1;
                int n9 = 0;
                while (n9 < nArray.length) {
                    if (nArray[n9] < 56 && nArray[n9] >= 8) {
                        n7 = nArray.length;
                        break;
                    }
                    if (n7 > 0 && (nArray[n9] & 0xF8) == 56 && (nArray3[n7 - 1] & 0xF8) == 56) {
                        int n10 = (nArray[n9] & 7) + 1 + (nArray3[n7 - 1] & 7) + 1;
                        nArray3[n7 - 1] = 56 + Math.min(7, n10 - 1);
                        if ((n10 -= (nArray3[n7 - 1] & 7) + 1) > 0) {
                            nArray3[n7++] = 56 + n10 - 1;
                        }
                    } else {
                        if ((nArray[n9] & 0x80) != 0) {
                            n8 = (nArray[n9] & 0x70) >> 5;
                        }
                        if ((nArray[n9] & 0xC0) == 0 || (Math.max(0, n8 - 1) & n4) != 0) {
                            nArray3[n7++] = nArray[n9];
                        }
                    }
                    ++n9;
                }
                if (n7 < nArray.length) {
                    nArray = new int[n7];
                    System.arraycopy(nArray3, 0, nArray, 0, nArray.length);
                }
            }
            RomManager.StaticAccess.writeBytes(KiddEd.shouldCompressPSG() ? PSGTools.compressPSG(nArray) : nArray, n3);
            return true;
        }
        return false;
    }

    private int getSoundStoppedCodeAddress(int n) {
        if (n >= 48) {
            n += 3;
        }
        return RomManager.StaticAccess.readWord(this.findJumpTableHandleSoundStopped() + n * 2);
    }

    private void setSoundStoppedCodeAddress(int n, int n2) {
        if (n2 < 0 || n2 >= 49152) {
            throw new IllegalArgumentException("Address to call after sound stopped must be in ROM.");
        }
        if (n >= 48) {
            n += 3;
        }
        RomManager.StaticAccess.writeWord(this.findJumpTableHandleSoundStopped() + n * 2, n2);
    }

    private int findJumpTableHandleSoundRequestAddr() {
        if (this.isNativeEngine()) {
            throw new UnsupportedOperationException();
        }
        int n = Sound.READ_WORD(38992);
        while (n < 45829) {
            if (Sound.READ_BYTE(n) == 33 && Sound.READ_WORD(n + 1) >= 32768 && Sound.READ_BYTE(n + 3) == 231) {
                return n + 1;
            }
            ++n;
        }
        throw new IllegalStateException("Couldn't find jump table for handleSoundRequest");
    }

    private int findJumpTableHandleSoundRequest() {
        if (this.isNativeEngine()) {
            return 39229;
        }
        return Sound.READ_WORD(this.findJumpTableHandleSoundRequestAddr());
    }

    private int findJumpTablePlaySoundAddr() {
        if (this.isNativeEngine()) {
            throw new UnsupportedOperationException();
        }
        int n = Sound.READ_WORD(this.findJumpTableHandleSoundRequest());
        while (n < 45829) {
            if (Sound.READ_BYTE(n) == 33 && Sound.READ_WORD(n + 1) >= 32768 && Sound.READ_WORD(n + 4) == 32) {
                return n + 1;
            }
            ++n;
        }
        throw new IllegalStateException("Couldn't find jump table for playSound");
    }

    private int findJumpTablePlaySound() {
        return Sound.READ_WORD(this.findJumpTablePlaySoundAddr());
    }

    private int findJumpTableHandleSoundStoppedAddr() {
        if (this.isNativeEngine()) {
            throw new UnsupportedOperationException();
        }
        int n = 38991;
        while (n < 45829) {
            if (Sound.READ_BYTE(n) == 196 && Sound.READ_WORD(n + 1) >= 32768) {
                n = Sound.READ_WORD(n + 1);
                while (n < 45829) {
                    if (Sound.READ_BYTE(n) == 33 && Sound.READ_WORD(n + 1) >= 32768 && Sound.READ_WORD(n + 4) == 32) {
                        return n + 1;
                    }
                    ++n;
                }
            }
            ++n;
        }
        throw new IllegalStateException("Couldn't find jump table for handleSoundStopped");
    }

    private int findJumpTableHandleSoundStopped() {
        return Sound.READ_WORD(this.findJumpTableHandleSoundStoppedAddr());
    }

    private static int findMaxSoundNumber() {
        int n = Sound.READ_WORD(38992);
        while (n < 45829) {
            if (Sound.READ_BYTE(n) == 254 && Sound.READ_BYTE(n + 1) >= 128 && Sound.READ_BYTE(n + 5) == 214 && Sound.READ_BYTE(n + 6) == 129) {
                return n + 1;
            }
            ++n;
        }
        throw new IllegalStateException("Couldn't find max sound number");
    }

    private boolean isSFX() {
        if (!this.isNativeEngine()) {
            throw new UnsupportedOperationException();
        }
        return this.metaChannel > 3;
    }

    public boolean isSFX(int n) {
        if (n >= 48) {
            n += 3;
        }
        if (this.isNativeEngine()) {
            this.getPSGdata(n);
            return this.isSFX();
        }
        int n2 = Sound.READ_WORD(this.findJumpTablePlaySound() + 2 * n);
        return RomManager.StaticAccess.readByte(n2 + 8) == 14 && RomManager.StaticAccess.readByte(n2 + 3) == 25;
    }

    public boolean isRepeat(int n) {
        if (n >= 48) {
            n += 3;
        }
        int n2 = Sound.READ_WORD(this.findJumpTablePlaySound() + 2 * n);
        if (this.isSFX(n)) {
            return Sound.READ_WORD(n2 + 11) == Sound.READ_WORD(Sound.getPointerSfxLoop());
        }
        return Sound.READ_WORD(n2 + 9) == Sound.READ_WORD(Sound.getPointerRepeat());
    }

    public void setRepeat(int n, boolean bl) {
        if (n >= 48) {
            n += 3;
        }
        if (this.isNativeEngine()) {
            throw new UnsupportedOperationException();
        }
        boolean bl2 = this.isSFX(n);
        int n2 = Sound.READ_WORD(bl2 ? (bl ? Sound.getPointerSfxLoop() : Sound.getPointerSfx()) : (bl ? Sound.getPointerRepeat() : Sound.getPointerNoRepeat()));
        int n3 = Sound.READ_WORD(this.findJumpTablePlaySound() + 2 * n);
        if (bl2) {
            RomManager.StaticAccess.writeWord(n3 + 11, n2);
        } else {
            RomManager.StaticAccess.writeWord(n3 + 9, n2);
        }
    }

    public Integer[] getPriorities() {
        block7: {
            if (this.priorities != null) break block7;
            this.priorities = new HashMap();
            this.priorityAddresses = new HashMap();
            int n = 0;
            while (n < this.getSoundCount()) {
                block8: {
                    int n2;
                    int n3;
                    block10: {
                        block11: {
                            int n4;
                            block9: {
                                n3 = Sound.READ_WORD(this.findJumpTableHandleSoundRequest() + 2 * n);
                                int n5 = n3 + 1;
                                if (RomManager.StaticAccess.readByte(n5) != 24) {
                                    ++n5;
                                }
                                n4 = n3 + 2;
                                if (RomManager.StaticAccess.readByte(n5) == 24) {
                                    n4 = n5 + RomManager.StaticAccess.readByte(n5 + 1) + 2;
                                }
                                if (RomManager.StaticAccess.readByte(n3) == 187 && this.isNativeEngine()) {
                                    n4 = n3;
                                }
                                if (!(RomManager.StaticAccess.readByte(n4) == 33 && RomManager.StaticAccess.readWord(n4 + 1) == 49427 || RomManager.StaticAccess.readByte(n4) == 187 && this.isNativeEngine())) break block8;
                                n2 = 0;
                                if (RomManager.StaticAccess.readByte(n3) != 62) break block9;
                                n2 = RomManager.StaticAccess.readByte(n3 + 1);
                                break block10;
                            }
                            if ((RomManager.StaticAccess.readByte(n3) != 58 || RomManager.StaticAccess.readWord(n3 + 1) != 49427) && n4 != n3) break block11;
                            n2 = 144;
                            break block10;
                        }
                        if (RomManager.StaticAccess.readByte(n3) != 175) break block8;
                    }
                    this.priorities.put(n3, n2 >>= 4);
                    this.priorityAddresses.put(n2, n3);
                }
                ++n;
            }
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>(this.priorityAddresses.keySet());
        Collections.sort(arrayList);
        return arrayList.toArray(new Integer[arrayList.size()]);
    }

    public HashMap<Integer, Integer> getPriorityAddresses() {
        if (this.priorityAddresses == null) {
            this.getPriorities();
        }
        return this.priorityAddresses;
    }

    public boolean hasPriority(int n) {
        if (n >= 48) {
            n += 3;
        }
        this.getPriorities();
        return this.priorities.containsKey(Sound.READ_WORD(this.findJumpTableHandleSoundRequest() + 2 * n));
    }

    public int getPriority(int n) {
        if (n >= 48) {
            n += 3;
        }
        this.getPriorities();
        return this.priorities.get(Sound.READ_WORD(this.findJumpTableHandleSoundRequest() + 2 * n));
    }

    public void setPriority(int n, int n2) {
        if (n >= 48) {
            n += 3;
        }
        int n3 = this.findJumpTableHandleSoundRequest() + 2 * n;
        int n4 = this.getPriorityAddresses().get(n2);
        if (RomManager.StaticAccess.readWord(n3) != n4) {
            TransactionManager.getInstance().addTransactionObject(this, n);
            RomManager.StaticAccess.writeWord(n3, n4);
        }
    }

    private static int getBank() {
        return 2;
    }

    private static final int READ_BYTE(int n) {
        return RomManager.getInstance().READ_BYTE(n, Sound.getBank());
    }

    private static final int READ_WORD(int n) {
        return RomManager.getInstance().READ_WORD(n, Sound.getBank());
    }

    private static final int RESOLVE_ADDRESS(int n, int n2) {
        return RomManager.RESOLVE_ADDRESS1(n, n2);
    }

    @Override
    public String getChangeName() {
        return TextProvider.get("ChangeSound");
    }

    @Override
    public void fireChangeOccurred(Change change) {
        for (ChangeListener changeListener : new LinkedList<ChangeListener>(this.listeners)) {
            changeListener.changeOccurred(change);
        }
    }

    @Override
    public void addChangeListener(ChangeListener changeListener) {
        if (!this.listeners.contains(changeListener)) {
            this.listeners.addFirst(changeListener);
        }
    }

    @Override
    public void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }
}

