/*
 * Decompiled with CFR 0.152.
 */
package data;

import changes.Change;
import data.Palette;
import editors.KiddEd;
import java.util.Arrays;
import rom.RomManager;

public class LevelPalette
extends Palette {
    private final int[] colors = new int[32];

    public LevelPalette(int n) {
        super(4370 + n * 2, 7);
        Arrays.fill(this.colors, -1);
    }

    private int countReferences() {
        int n = 0;
        int n2 = 0;
        while (n2 < 17) {
            if (RomManager.StaticAccess.readWord(4370 + n2 * 2) == RomManager.StaticAccess.readWord(this.getAddress())) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    private void relocate() {
        int n = KiddEd.findFreeBlock(this.colors.length, this.getBank());
        if (n < 0) {
            throw new RuntimeException("Failed to relocate palette: " + Integer.toHexString(this.getAddress()));
        }
        this.moveTo(n, false);
    }

    public void clearDirty() {
        Arrays.fill(this.colors, -1);
        this.fireChangeOccurred(new Change(-1));
    }

    public void setDirty(int n, int n2) {
        if (this.colors[n] != n2) {
            this.colors[n] = n2;
            this.fireChangeOccurred(new Change(n));
        }
    }

    @Override
    public void setColor(int n, int n2) {
        if (this.countReferences() > 1) {
            this.relocate();
        }
        super.setColor(n, n2);
        this.colors[n] = -1;
    }

    @Override
    public void setColors(int n, Integer[] integerArray) {
        if (this.countReferences() > 1) {
            this.relocate();
        }
        super.setColors(n, integerArray);
        this.clearDirty();
    }

    @Override
    public int[] getColors() {
        int[] nArray = super.getColors();
        int n = 0;
        while (n < nArray.length) {
            if (this.colors[n] >= 0) {
                nArray[n] = this.colors[n];
            }
            ++n;
        }
        return nArray;
    }
}

