/*
 * Decompiled with CFR 0.152.
 */
package changes;

import changes.Changable;
import changes.Change;
import changes.ChangeStateListener;
import java.util.LinkedList;
import rom.RomManager;
import transactions.TransactionObject;

public class ChangeWatcher {
    private final LinkedList<Change> undoStack = new LinkedList();
    private final LinkedList<Change> redoStack = new LinkedList();
    private final int size;
    private int savedStackSize;
    private boolean hasChanges;
    private final LinkedList<ChangeStateListener> listeners = new LinkedList();

    public ChangeWatcher(int n) {
        this.size = n;
    }

    public void undo(Changable changable) {
        if (this.canUndo(changable)) {
            this.undo();
        }
    }

    public void undo() {
        if (this.canUndo()) {
            this.undoOrRedo(this.undoStack, this.redoStack);
        }
    }

    public void redo(Changable changable) {
        if (this.canRedo(changable)) {
            this.redo();
        }
    }

    public void redo() {
        if (this.canRedo()) {
            this.undoOrRedo(this.redoStack, this.undoStack);
        }
    }

    private void undoOrRedo(LinkedList<Change> linkedList, LinkedList<Change> linkedList2) {
        Change change = linkedList.pop();
        int[][] nArray = change.getOldData();
        int[] nArray2 = new int[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            nArray2[n] = nArray[n][0];
            ++n;
        }
        linkedList2.push(new Change(change.getTransactionObjects(), nArray2));
        int[][] nArray3 = nArray;
        int n2 = nArray.length;
        int n3 = 0;
        while (n3 < n2) {
            int[] nArray4 = nArray3[n3];
            RomManager.StaticAccess.writeByte(nArray4[0], nArray4[1]);
            ++n3;
        }
        for (TransactionObject transactionObject : change.getTransactionObjects()) {
            transactionObject.getObject().fireChangeOccurred(change);
        }
        int n4 = this.undoStack.size();
        if (n4 == this.savedStackSize) {
            this.setHasChanges(false);
        } else if (n4 > this.savedStackSize) {
            this.setHasChanges(true);
        }
    }

    public boolean canUndo(Changable changable) {
        if (!this.canUndo()) {
            return false;
        }
        Change change = this.undoStack.peek();
        return change.getChangableObject().getClass().equals(changable.getClass());
    }

    public boolean canRedo(Changable changable) {
        if (!this.canRedo()) {
            return false;
        }
        Change change = this.redoStack.peek();
        return change.getChangableObject().getClass().equals(changable.getClass());
    }

    public boolean canUndo() {
        return !this.undoStack.isEmpty();
    }

    public boolean canRedo() {
        return !this.redoStack.isEmpty();
    }

    public boolean hasChanges() {
        return this.hasChanges;
    }

    public String getUndoChangeName() {
        return this.undoStack.peek().getChangableObject().getChangeName();
    }

    public String getRedoChangeName() {
        return this.redoStack.peek().getChangableObject().getChangeName();
    }

    public void reset() {
        this.undoStack.clear();
        this.redoStack.clear();
        this.savedStackSize = 0;
        this.setHasChanges(false);
    }

    public void clearChangesFlag() {
        this.setHasChanges(false);
        this.savedStackSize = this.undoStack.size();
    }

    public void hideChanges() {
        this.undoStack.clear();
        this.redoStack.clear();
        this.savedStackSize = -1;
        this.setHasChanges(true);
    }

    public void addChange(Change change) {
        if (this.undoStack.size() < this.savedStackSize) {
            this.savedStackSize = -1;
        }
        this.undoStack.push(change);
        this.redoStack.clear();
        if (this.undoStack.size() > this.size) {
            this.undoStack.removeLast();
            this.savedStackSize = -1;
        }
        this.setHasChanges(true);
    }

    private void setHasChanges(boolean bl) {
        this.hasChanges = bl;
        this.fireChangeStateChanged();
    }

    public final void fireChangeStateChanged() {
        for (ChangeStateListener changeStateListener : new LinkedList<ChangeStateListener>(this.listeners)) {
            changeStateListener.changeStateChanged();
        }
    }

    public final void addChangeStateListener(ChangeStateListener changeStateListener) {
        if (!this.listeners.contains(changeStateListener)) {
            this.listeners.addFirst(changeStateListener);
        }
    }

    public final void removeChangeStateListener(ChangeStateListener changeStateListener) {
        this.listeners.remove(changeStateListener);
    }
}

