/*
 * Decompiled with CFR 0.152.
 */
package panels;

import changes.Change;
import changes.ChangeListener;
import data.Palette;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import panels.ScalablePanel;
import transactions.TransactionManager;

public class PalettePanel
extends ScalablePanel {
    private final Color[] colors = new Color[32];
    private Palette palette;
    private int selectedColor = -1;
    private int start = 0;
    private int end = this.colors.length;
    private float offsetX;
    private float offsetY;
    private float scale = 16.0f;
    private final LinkedList<ActionListener> listeners = new LinkedList();
    private final ChangeListener paletteChangeListener = new ChangeListener(){

        @Override
        public void changeOccurred(Change change) {
            int n = change.getData(PalettePanel.this.palette);
            if (n < 0) {
                int n2 = -n - 1;
                int n3 = n2 * 16;
                int n4 = n3 + 16;
                if (n2 == 2) {
                    n3 = 0;
                    n4 = 32;
                }
                int n5 = n3;
                while (n5 < n4) {
                    int n6 = PalettePanel.this.palette.getColors()[n5];
                    int n7 = (n6 & 0x30) >> 4;
                    int n8 = (n6 & 0xC) >> 2;
                    int n9 = n6 & 3;
                    ((PalettePanel)PalettePanel.this).colors[n5] = new Color(n9 * 255 / 3, n8 * 255 / 3, n7 * 255 / 3);
                    ++n5;
                }
            } else {
                int n10 = PalettePanel.this.palette.getColors()[n];
                int n11 = (n10 & 0x30) >> 4;
                int n12 = (n10 & 0xC) >> 2;
                int n13 = n10 & 3;
                ((PalettePanel)PalettePanel.this).colors[n] = new Color(n13 * 255 / 3, n12 * 255 / 3, n11 * 255 / 3);
            }
            PalettePanel.this.repaint();
        }
    };

    public PalettePanel(Palette palette) {
        this.setPalette(palette);
        final Cursor cursor = this.getCursor();
        final Cursor cursor2 = Cursor.getPredefinedCursor(12);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                PalettePanel.this.setSelectedColorIndex(PalettePanel.this.toScreenY(mouseEvent.getY()) * 16 + PalettePanel.this.toScreenX(mouseEvent.getX()));
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                int n = PalettePanel.this.toScreenX(mouseEvent.getX());
                int n2 = PalettePanel.this.toScreenY(mouseEvent.getY());
                if (n >= 0 && n2 >= 0 && n < 16 && n < PalettePanel.this.end - PalettePanel.this.start && n2 < 2) {
                    PalettePanel.this.setCursor(cursor2);
                } else {
                    PalettePanel.this.setCursor(cursor);
                }
            }
        });
    }

    public void copyToClipboard(int n) {
        final BufferedImage bufferedImage = new BufferedImage(256, n == 2 ? 32 : 16, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        int n2 = 0;
        int n3 = 0;
        int n4 = n * 16;
        int n5 = n4 + 16;
        String string = "";
        if (n == 2) {
            n4 = 0;
            n5 = 32;
        }
        int n6 = n4;
        while (n6 < n5) {
            if (n2 > 0) {
                string = String.valueOf(string) + " ";
            } else if (!string.isEmpty()) {
                string = String.valueOf(string) + '\n';
            }
            int n7 = Math.round((float)(this.colors[n6].getRed() * 3) / 255.0f);
            int n8 = Math.round((float)(this.colors[n6].getGreen() * 3) / 255.0f);
            int n9 = Math.round((float)(this.colors[n6].getBlue() * 3) / 255.0f);
            int n10 = n9 << 4 | n8 << 2 | n7;
            string = String.valueOf(string) + String.format("$%02X", n10);
            graphics2D.setColor(this.colors[n6]);
            graphics2D.fillRect(n2, n3, 16, 16);
            if ((n2 += 16) >= 256) {
                n2 = 0;
                n3 += 16;
            }
            ++n6;
        }
        final String string2 = string;
        graphics2D.dispose();
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(new Transferable(){

            @Override
            public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
                return DataFlavor.stringFlavor.equals(dataFlavor) || DataFlavor.imageFlavor.equals(dataFlavor);
            }

            @Override
            public DataFlavor[] getTransferDataFlavors() {
                return new DataFlavor[]{DataFlavor.stringFlavor, DataFlavor.imageFlavor};
            }

            @Override
            public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
                if (!this.isDataFlavorSupported(dataFlavor)) {
                    throw new UnsupportedFlavorException(dataFlavor);
                }
                if (DataFlavor.stringFlavor.equals(dataFlavor)) {
                    return string2;
                }
                return bufferedImage;
            }
        }, null);
    }

    public boolean canPasteFromClipboard() {
        return Toolkit.getDefaultToolkit().getSystemClipboard().isDataFlavorAvailable(DataFlavor.stringFlavor) || Toolkit.getDefaultToolkit().getSystemClipboard().isDataFlavorAvailable(DataFlavor.imageFlavor);
    }

    public void pasteFromClipboard(int n) {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        try {
            if (clipboard.isDataFlavorAvailable(DataFlavor.stringFlavor)) {
                Object object = clipboard.getData(DataFlavor.stringFlavor);
                String string = (String)object;
                this.setPalette(n, string);
            } else if (clipboard.isDataFlavorAvailable(DataFlavor.imageFlavor)) {
                Object object = clipboard.getData(DataFlavor.imageFlavor);
                Image image = (Image)object;
                if (!(image instanceof BufferedImage)) {
                    BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 1);
                    Graphics2D graphics2D = bufferedImage.createGraphics();
                    graphics2D.drawImage(image, 0, 0, image.getWidth(null), image.getHeight(null), null);
                    graphics2D.dispose();
                    image = bufferedImage;
                }
                this.setPalette(n, (BufferedImage)image);
            }
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            unsupportedFlavorException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void setPalette(final int n, String string) {
        String[] stringArray = string.split(" |\n");
        final ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n2 = 0;
        while (n2 < stringArray.length && (n == 2 && arrayList.size() < 32 || n < 2 && arrayList.size() < 16)) {
            try {
                arrayList.add(Integer.parseInt(stringArray[n2].substring(1), 16));
            }
            catch (NumberFormatException numberFormatException) {}
            ++n2;
        }
        TransactionManager.getInstance().runTransaction(new Runnable(){

            @Override
            public void run() {
                PalettePanel.this.palette.setColors(n, arrayList.toArray(new Integer[arrayList.size()]));
            }
        });
    }

    private void setPalette(final int n, BufferedImage bufferedImage) {
        final ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n2 = 0;
        while (n2 < bufferedImage.getHeight()) {
            int n3 = 0;
            while (n3 < bufferedImage.getWidth()) {
                Color color = new Color(bufferedImage.getRGB(n3, n2));
                int n4 = Math.round((float)(color.getRed() * 3) / 255.0f);
                int n5 = Math.round((float)(color.getGreen() * 3) / 255.0f);
                int n6 = Math.round((float)(color.getBlue() * 3) / 255.0f);
                int n7 = n6 << 4 | n5 << 2 | n4;
                if (!arrayList.contains(n7)) {
                    arrayList.add(n7);
                }
                if (n == 2 && arrayList.size() >= 32 || n < 2 && arrayList.size() >= 16) break;
                ++n3;
            }
            ++n2;
        }
        TransactionManager.getInstance().runTransaction(new Runnable(){

            @Override
            public void run() {
                PalettePanel.this.palette.setColors(n, arrayList.toArray(new Integer[arrayList.size()]));
            }
        });
    }

    public void setPalette(Palette palette) {
        if (this.palette != null && this.palette != palette) {
            this.palette.removeChangeListener(this.paletteChangeListener);
        }
        this.palette = palette;
        palette.addChangeListener(this.paletteChangeListener);
        int n = 0;
        int[] nArray = palette.getColors();
        int n2 = nArray.length;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = nArray[n3];
            int n5 = (n4 & 0x30) >> 4;
            int n6 = (n4 & 0xC) >> 2;
            int n7 = n4 & 3;
            this.colors[n++] = new Color(n7 * 255 / 3, n6 * 255 / 3, n5 * 255 / 3);
            ++n3;
        }
        this.end = palette.getSize();
        this.repaint();
    }

    public void setRange(int n, int n2) {
        this.start = n;
        this.end = n2;
        this.revalidate();
        this.repaint();
    }

    public void setColor(final int n, final int n2) {
        TransactionManager.getInstance().runTransaction(new Runnable(){

            @Override
            public void run() {
                PalettePanel.this.palette.setColor(n, n2);
            }
        });
        this.setPalette(this.palette);
    }

    public void setSelectedColorIndex(int n) {
        if (n < this.end - this.start) {
            this.selectedColor = n;
            this.repaint();
            this.fireActionPerformed();
        }
    }

    public int getSelectedColorIndex() {
        return this.selectedColor;
    }

    public int getSelectedColor() {
        return this.palette.getColors()[this.selectedColor];
    }

    protected final void fireActionPerformed() {
        for (ActionListener actionListener : this.listeners) {
            actionListener.actionPerformed(null);
        }
    }

    public final void addActionListener(ActionListener actionListener) {
        if (!this.listeners.contains(actionListener)) {
            this.listeners.add(actionListener);
        }
    }

    public final void removeActionListener(ActionListener actionListener) {
        this.listeners.remove(actionListener);
    }

    private int toScreenX(int n) {
        return (float)n >= this.offsetX ? (int)(((float)n - this.offsetX) / this.scale) : (int)(((float)n - this.offsetX) / this.scale) - 1;
    }

    private int toScreenY(int n) {
        return (float)n >= this.offsetY ? (int)(((float)n - this.offsetY) / this.scale) : (int)(((float)n - this.offsetY) / this.scale) - 1;
    }

    @Override
    public float getScale() {
        return this.scale;
    }

    @Override
    public Dimension getPreferredSize() {
        Insets insets = this.getInsets();
        int n = this.end - this.start;
        int n2 = (n - 1) / 16 + 1;
        int n3 = (n - 1) % 16 + 1;
        return new Dimension((int)((float)n3 * this.getPreferredScale()) + insets.left + insets.right, (int)((float)n2 * this.getPreferredScale()) + insets.top + insets.bottom);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        int n = this.end - this.start;
        int n2 = (n - 1) / 16 + 1;
        int n3 = (n - 1) % 16 + 1;
        Insets insets = this.getInsets();
        int n4 = this.getWidth() - (insets.left + insets.right);
        int n5 = this.getHeight() - (insets.top + insets.bottom);
        float f = (float)n4 / (float)n3;
        float f2 = (float)n5 / (float)n2;
        float f3 = Math.min(f, f2);
        if (this.isIntegerScaling()) {
            float f4;
            if ((this.scale != (float)((int)this.scale) || f3 - this.scale < 0.0f || f3 - this.scale >= 1.0f) && this.scale != (f4 = (float)Math.max(1, (int)(this.scale + Math.max(-1.0f, Math.min(1.0f, (f3 - this.scale) * 1.0f)))))) {
                this.scale = f4;
                this.scaleUpdated();
            }
        } else if (Math.abs(f3 - this.scale) * (float)n3 > 2.0f && Math.abs(f3 - this.scale) * (float)n2 > 2.0f) {
            this.scale += (f3 - this.scale) * 0.5f;
            this.scaleUpdated();
        }
        this.offsetX = Math.max(0, (int)(((float)n4 - (float)n3 * this.scale) / 2.0f)) + insets.left;
        this.offsetY = Math.max(0, (int)(((float)n5 - (float)n2 * this.scale) / 2.0f)) + insets.right;
        int n6 = 0;
        while (n6 < n) {
            graphics.setColor(this.colors[this.start + n6]);
            graphics.fillRect((int)(this.offsetX + (float)(n6 % n3) * this.scale), (int)(this.offsetY + (float)(n6 / n3) * this.scale), (int)(this.scale + 0.5f), (int)(this.scale + 0.5f));
            ++n6;
        }
        if (this.selectedColor >= 0) {
            graphics.setColor(Color.WHITE);
            graphics.drawRect((int)(this.offsetX + (float)(this.selectedColor % n3) * this.scale), (int)(this.offsetY + (float)(this.selectedColor / n3) * this.scale), (int)(this.scale + 0.5f), (int)(this.scale + 0.5f));
        }
    }
}

