/*
 * Decompiled with CFR 0.152.
 */
package panels;

import changes.Change;
import changes.ChangeListener;
import data.MetaTileset;
import data.Palette;
import data.Tileset;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.util.LinkedList;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import mastersystem.Renderer;

public class MetaTilePanel
extends JPanel {
    private final Cursor HAND_CURSOR = Cursor.getPredefinedCursor(12);
    private final float PREFERRED_SCALE = 4.0f;
    private final BufferedImage metaTileImage;
    private Color[] colors = new Color[32];
    private MetaTileset metaTileset;
    private int metaTile;
    private Tileset tileset;
    private Palette palette;
    private int selectedTile = -1;
    private boolean selected;
    private int offsetX;
    private int offsetY;
    private float scale = 4.0f;
    private final LinkedList<ActionListener> listeners = new LinkedList();
    private final ChangeListener tilesetChangeListener = new ChangeListener(){

        @Override
        public void changeOccurred(Change change) {
            if (change.getData(MetaTilePanel.this.tileset) < 256) {
                MetaTilePanel.this.update();
            }
        }
    };
    private final ChangeListener paletteChangeListener = new ChangeListener(){

        @Override
        public void changeOccurred(Change change) {
            int n = change.getData(MetaTilePanel.this.palette);
            if (n < 0) {
                int n2 = -n - 1;
                int n3 = n2 * 16;
                int n4 = n3 + 16;
                if (n2 == 2) {
                    n3 = 0;
                    n4 = 32;
                }
                int n5 = n3;
                while (n5 < n4) {
                    int n6 = MetaTilePanel.this.palette.getColors()[n5];
                    int n7 = (n6 & 0x30) >> 4;
                    int n8 = (n6 & 0xC) >> 2;
                    int n9 = n6 & 3;
                    ((MetaTilePanel)MetaTilePanel.this).colors[n5] = new Color(n9 * 255 / 3, n8 * 255 / 3, n7 * 255 / 3);
                    ++n5;
                }
            } else {
                int n10 = MetaTilePanel.this.palette.getColors()[n];
                int n11 = (n10 & 0x30) >> 4;
                int n12 = (n10 & 0xC) >> 2;
                int n13 = n10 & 3;
                ((MetaTilePanel)MetaTilePanel.this).colors[n] = new Color(n13 * 255 / 3, n12 * 255 / 3, n11 * 255 / 3);
            }
            MetaTilePanel.this.update();
        }
    };
    private final ChangeListener metaTileChangeListener = new ChangeListener(){

        @Override
        public void changeOccurred(Change change) {
            if (change.getData(MetaTilePanel.this.metaTileset) < 0 || MetaTilePanel.this.metaTile == change.getData(MetaTilePanel.this.metaTileset)) {
                MetaTilePanel.this.update();
                MetaTilePanel.this.fireActionPerformed();
            }
        }
    };

    public MetaTilePanel(int n, MetaTileset metaTileset, Tileset tileset, Palette palette) {
        this.metaTileImage = new BufferedImage(metaTileset.getMetaTileWidth(), metaTileset.getMetaTileHeight(), 1);
        this.setMetaTile(n, metaTileset, tileset, palette);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    MetaTilePanel.this.setSelectedTile(MetaTilePanel.this.toScreenY(mouseEvent.getY()) / 8 * 2 + MetaTilePanel.this.toScreenX(mouseEvent.getX()) / 8);
                } else if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    MetaTilePanel.this.setSelectedTile(-1);
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                MetaTilePanel.this.setCursor(MetaTilePanel.this.HAND_CURSOR);
            }
        });
    }

    public void setMetaTileset(MetaTileset metaTileset, Tileset tileset, Palette palette) {
        this.setMetaTile(this.metaTile, metaTileset, tileset, palette);
    }

    public void setMetaTile(int n, MetaTileset metaTileset, Tileset tileset, Palette palette) {
        if (this.metaTileset != null && this.metaTileset != metaTileset) {
            this.metaTileset.removeChangeListener(this.metaTileChangeListener);
        }
        if (this.tileset != null && this.tileset != tileset) {
            this.tileset.removeChangeListener(this.tilesetChangeListener);
        }
        if (this.palette != null && this.palette != palette) {
            this.palette.removeChangeListener(this.paletteChangeListener);
        }
        this.selectedTile = -1;
        this.metaTileset = metaTileset;
        this.tileset = tileset;
        this.metaTile = n;
        this.palette = palette;
        int n2 = 0;
        int[] nArray = palette.getColors();
        int n3 = nArray.length;
        int n4 = 0;
        while (n4 < n3) {
            int n5 = nArray[n4];
            int n6 = (n5 & 0x30) >> 4;
            int n7 = (n5 & 0xC) >> 2;
            int n8 = n5 & 3;
            this.colors[n2++] = new Color(n8 * 255 / 3, n7 * 255 / 3, n6 * 255 / 3);
            ++n4;
        }
        metaTileset.addChangeListener(this.metaTileChangeListener);
        tileset.addChangeListener(this.tilesetChangeListener);
        palette.addChangeListener(this.paletteChangeListener);
        this.update();
    }

    public void setMetaTile(int n) {
        this.selectedTile = -1;
        this.metaTile = n;
        this.update();
    }

    public void setSelected(boolean bl) {
        this.selected = bl;
        this.selectedTile = -1;
        this.repaint();
    }

    public void setSelectedTile(int n) {
        this.selectedTile = n;
        this.repaint();
        this.fireActionPerformed();
    }

    public int getSelectedTile() {
        return this.selectedTile;
    }

    private void update() {
        int[] nArray = this.metaTileset.getMetaTile(this.metaTile);
        int[] nArray2 = this.tileset.getVRAM();
        Graphics2D graphics2D = this.metaTileImage.createGraphics();
        Renderer.renderMetaTile(nArray2, nArray, 0, 0, false, this.colors, graphics2D);
        graphics2D.dispose();
        this.repaint();
    }

    @Override
    public Dimension getPreferredSize() {
        Insets insets = this.getInsets();
        return new Dimension((int)((float)this.metaTileImage.getWidth() * 4.0f) + insets.left + insets.right, (int)((float)this.metaTileImage.getHeight() * 4.0f) + insets.top + insets.bottom);
    }

    private int toScreenX(int n) {
        return n >= this.offsetX ? (int)((float)(n - this.offsetX) / this.scale) : (int)((float)(n - this.offsetX) / this.scale) - 1;
    }

    private int toScreenY(int n) {
        return n >= this.offsetY ? (int)((float)(n - this.offsetY) / this.scale) : (int)((float)(n - this.offsetY) / this.scale) - 1;
    }

    protected final void fireActionPerformed() {
        for (ActionListener actionListener : this.listeners) {
            actionListener.actionPerformed(null);
        }
    }

    public final void addActionListener(ActionListener actionListener) {
        if (!this.listeners.contains(actionListener)) {
            this.listeners.add(actionListener);
        }
    }

    public final void removeActionListener(ActionListener actionListener) {
        this.listeners.remove(actionListener);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        BufferedImage bufferedImage = new BufferedImage(this.metaTileImage.getWidth(), this.metaTileImage.getHeight(), this.metaTileImage.getType());
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage((Image)this.metaTileImage, 0, 0, null);
        if (this.selected) {
            graphics2D.setColor(Color.RED);
            graphics2D.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        } else if (this.selectedTile >= 0) {
            graphics2D.setColor(Color.WHITE);
            graphics2D.drawRect(this.selectedTile % 2 * 8, this.selectedTile / 2 * 8, 8, 8);
        } else {
            graphics2D.setColor(Color.WHITE);
            graphics2D.drawRect(0, 0, this.metaTileImage.getWidth(), this.metaTileImage.getHeight());
        }
        int[] nArray = this.metaTileset.getMetaTile(this.metaTile);
        graphics2D.setColor(Color.RED);
        graphics2D.setStroke(new BasicStroke(1.5f));
        int n = 0;
        while (n < nArray.length / 2) {
            if (!this.tileset.contains((nArray[n * 2 + 1] & 1) << 8 | nArray[n * 2])) {
                graphics2D.drawLine(n % 2 * 8 + 1, n / 2 * 8 + 1, n % 2 * 8 + 30, n / 2 * 8 + 30);
            }
            ++n;
        }
        graphics2D.dispose();
        Insets insets = this.getInsets();
        int n2 = this.getWidth() - (insets.left + insets.right);
        int n3 = this.getHeight() - (insets.top + insets.bottom);
        float f = (float)n2 / (float)bufferedImage.getWidth();
        float f2 = (float)n3 / (float)bufferedImage.getHeight();
        float f3 = Math.min(f, f2);
        if (Math.abs(f3 - this.scale) * (float)bufferedImage.getWidth() > 2.0f && Math.abs(f3 - this.scale) * (float)bufferedImage.getHeight() > 2.0f) {
            this.scale += (f3 - this.scale) * 0.5f;
        }
        this.offsetX = Math.max(0, (int)(((float)n2 - (float)bufferedImage.getWidth() * this.scale) / 2.0f)) + insets.left;
        this.offsetY = Math.max(0, (int)(((float)n3 - (float)bufferedImage.getHeight() * this.scale) / 2.0f)) + insets.right;
        graphics.drawImage(bufferedImage, this.offsetX, this.offsetY, (int)((float)bufferedImage.getWidth() * this.scale), (int)((float)bufferedImage.getHeight() * this.scale), null);
    }
}

