/*
 * Decompiled with CFR 0.152.
 */
package mastersystem;

import mastersystem.CPU;

public class Z80
extends CPU {
    protected static final int FLAG_C = 1;
    protected static final int FLAG_N = 2;
    protected static final int FLAG_PV = 4;
    protected static final int FLAG_3 = 8;
    protected static final int FLAG_H = 16;
    protected static final int FLAG_5 = 32;
    protected static final int FLAG_Z = 64;
    protected static final int FLAG_S = 128;
    protected static final int FLAG_PV_Z = 68;
    protected static final int FLAG_3_5 = 40;
    protected static final int FLAG_3_5_S = 168;
    private static final int[] PARITY_FLAG = new int[256];
    public static final int INTERRUPT_LINE_INT = 1;
    public static final int INTERRUPT_LINE_NMI = 2;
    protected static final int[] CYCLES;
    protected static final int[] CYCLES_CB;
    private static final int[] CYCLES_ED;
    protected int regAF;
    protected int regBC;
    protected int regDE;
    protected int regHL;
    private int regAFex;
    private int regBCex;
    private int regDEex;
    private int regHLex;
    private int regR;
    private int regI;
    private int regIX;
    private int regIY;
    protected boolean afterEI;
    private boolean pinINT;
    private boolean pinNMI;
    private boolean nmiPending;
    private boolean interruptFlipFlop1;
    private boolean interruptFlipFlop2;
    private int interruptMode;
    private int input;
    boolean log = false;

    static {
        int n = 0;
        while (n < PARITY_FLAG.length) {
            if ((Integer.bitCount(n) & 1) == 0) {
                Z80.PARITY_FLAG[n] = 4;
            }
            ++n;
        }
        CYCLES = new int[]{4, 10, 7, 6, 4, 4, 7, 4, 4, 11, 7, 6, 4, 4, 7, 4, 8, 10, 7, 6, 4, 4, 7, 4, 12, 11, 7, 6, 4, 4, 7, 4, 7, 10, 16, 6, 4, 4, 7, 4, 7, 11, 16, 6, 4, 4, 7, 4, 7, 10, 13, 6, 11, 11, 10, 4, 7, 11, 13, 6, 4, 4, 7, 4, 4, 4, 4, 4, 4, 4, 7, 4, 4, 4, 4, 4, 4, 4, 7, 4, 4, 4, 4, 4, 4, 4, 7, 4, 4, 4, 4, 4, 4, 4, 7, 4, 4, 4, 4, 4, 4, 4, 7, 4, 4, 4, 4, 4, 4, 4, 7, 4, 7, 7, 7, 7, 7, 7, 4, 7, 4, 4, 4, 4, 4, 4, 7, 4, 4, 4, 4, 4, 4, 4, 7, 4, 4, 4, 4, 4, 4, 4, 7, 4, 4, 4, 4, 4, 4, 4, 7, 4, 4, 4, 4, 4, 4, 4, 7, 4, 4, 4, 4, 4, 4, 4, 7, 4, 4, 4, 4, 4, 4, 4, 7, 4, 4, 4, 4, 4, 4, 4, 7, 4, 4, 4, 4, 4, 4, 4, 7, 4, 5, 10, 10, 10, 10, 11, 7, 11, 5, 10, 10, 4, 10, 17, 7, 11, 5, 10, 10, 11, 10, 11, 7, 11, 5, 4, 10, 11, 10, 4, 7, 11, 5, 10, 10, 19, 10, 11, 7, 11, 5, 4, 10, 4, 10, 4, 7, 11, 5, 10, 10, 4, 10, 11, 7, 11, 5, 6, 10, 4, 10, 4, 7, 11};
        CYCLES_CB = new int[]{4, 4, 4, 4, 4, 4, 11, 4, 4, 4, 4, 4, 4, 4, 11, 4, 4, 4, 4, 4, 4, 4, 11, 4, 4, 4, 4, 4, 4, 4, 11, 4, 4, 4, 4, 4, 4, 4, 11, 4, 4, 4, 4, 4, 4, 4, 11, 4, 4, 4, 4, 4, 4, 4, 11, 4, 4, 4, 4, 4, 4, 4, 11, 4, 4, 4, 4, 4, 4, 4, 8, 4, 4, 4, 4, 4, 4, 4, 8, 4, 4, 4, 4, 4, 4, 4, 8, 4, 4, 4, 4, 4, 4, 4, 8, 4, 4, 4, 4, 4, 4, 4, 8, 4, 4, 4, 4, 4, 4, 4, 8, 4, 4, 4, 4, 4, 4, 4, 8, 4, 4, 4, 4, 4, 4, 4, 8, 4, 4, 4, 4, 4, 4, 4, 11, 4, 4, 4, 4, 4, 4, 4, 11, 4, 4, 4, 4, 4, 4, 4, 11, 4, 4, 4, 4, 4, 4, 4, 11, 4, 4, 4, 4, 4, 4, 4, 11, 4, 4, 4, 4, 4, 4, 4, 11, 4, 4, 4, 4, 4, 4, 4, 11, 4, 4, 4, 4, 4, 4, 4, 11, 4, 4, 4, 4, 4, 4, 4, 11, 4, 4, 4, 4, 4, 4, 4, 11, 4, 4, 4, 4, 4, 4, 4, 11, 4, 4, 4, 4, 4, 4, 4, 11, 4, 4, 4, 4, 4, 4, 4, 11, 4, 4, 4, 4, 4, 4, 4, 11, 4, 4, 4, 4, 4, 4, 4, 11, 4, 4, 4, 4, 4, 4, 4, 11, 4};
        CYCLES_ED = new int[]{8, 8, 11, 16, 4, 10, 4, 5, 8, 8, 11, 16, 4, 10, 4, 5, 8, 8, 11, 16, 4, 10, 4, 5, 8, 8, 11, 16, 4, 10, 4, 5, 8, 8, 11, 16, 4, 10, 4, 14, 8, 8, 11, 16, 4, 10, 4, 14, 8, 8, 11, 16, 4, 10, 4, -1, 8, 8, 11, 16, 4, 10, 4, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 12, 12, 12, 12, -1, -1, -1, -1, 12, 12, 12, 12, -1, -1, -1, -1, 12, 12, 12, 12, -1, -1, -1, -1, 12, 12, 12, 12, -1, -1, -1, -1};
    }

    public Z80(int[] nArray) {
        super(nArray);
        this.setCycles(CYCLES);
        this.reset();
    }

    @Override
    public void reset() {
        this.regPC = 0;
        this.regSP = 65535;
        this.regAF = 65535;
        this.regR = 0;
        this.pinINT = false;
        this.pinNMI = false;
        this.nmiPending = false;
        this.setInterruptsEnabled(false);
    }

    @Override
    protected void writeByte(int n, int n2) {
        if (n >= 49152) {
            this.fireOutputAvailable(n, n2);
            super.writeByte(n, n2);
        }
    }

    public void setInput(int n) {
        this.input = n & 0xFF;
    }

    public void setBC(int n) {
        this.regBC = n;
    }

    public void setDE(int n) {
        this.regDE = n;
    }

    public void setHL(int n) {
        this.regHL = n;
    }

    public void setAF(int n) {
        this.regAF = n;
    }

    public void setIX(int n) {
        this.regIX = n;
    }

    public int getPC() {
        return this.regPC;
    }

    public int getSP() {
        return this.regSP;
    }

    public int getA() {
        return this.regAF >> 8;
    }

    public int getDE() {
        return this.regDE;
    }

    public int getHL() {
        return this.regHL;
    }

    public int getHLex() {
        return this.regHLex;
    }

    public int getIX() {
        return this.regIX;
    }

    public void ret() {
        this.RET();
    }

    public void setLog(boolean bl) {
        this.log = bl;
    }

    @Override
    protected void executeInstruction(int n) {
        if (this.log && n != 118 && (n != 237 || this.READ_BYTE(this.regPC) != 179 && this.READ_BYTE(this.regPC) != 176)) {
            System.out.println(String.valueOf(Integer.toHexString(this.regPC - 1)) + "\t" + Integer.toHexString(n).toUpperCase());
        }
        this.regR = this.regR + 1 & 0xFF;
        this.afterEI = false;
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                this.regBC = this.READ_WORD();
                break;
            }
            case 2: {
                this.WRITE_BYTE(this.regBC, this.regAF >> 8);
                break;
            }
            case 3: {
                this.regBC = Z80.INC_WORD(this.regBC);
                break;
            }
            case 4: {
                this.regBC = this.INC_HIBYTE(this.regBC);
                break;
            }
            case 5: {
                this.regBC = this.DEC_HIBYTE(this.regBC);
                break;
            }
            case 6: {
                this.regBC = this.READ_BYTE() << 8 | this.regBC & 0xFF;
                break;
            }
            case 7: {
                this.regAF = (this.regAF & 0x7F00) << 1 | (this.regAF & 0x8000) >> 7 | this.regAF >> 15 | this.regAF & 0xEC;
                break;
            }
            case 8: {
                int n2 = this.regAF;
                this.regAF = this.regAFex;
                this.regAFex = n2;
                break;
            }
            case 9: {
                this.ADD_WORD_HL(this.regBC);
                break;
            }
            case 10: {
                this.regAF = this.READ_BYTE(this.regBC) << 8 | this.regAF & 0xFF;
                break;
            }
            case 11: {
                this.regBC = Z80.DEC_WORD(this.regBC);
                break;
            }
            case 12: {
                this.regBC = this.INC_LOBYTE(this.regBC);
                break;
            }
            case 13: {
                this.regBC = this.DEC_LOBYTE(this.regBC);
                break;
            }
            case 14: {
                this.regBC = this.regBC & 0xFF00 | this.READ_BYTE();
                break;
            }
            case 15: {
                this.regAF = (this.regAF & 0x100) << 7 | (this.regAF & 0xFE00) >> 1 | this.regAF >> 8 & 1 | this.regAF & 0xEC;
                break;
            }
            case 16: {
                this.regBC = this.regBC - 256 & 0xFFFF;
                if ((this.regBC & 0xFF00) != 0) {
                    this.regPC += (byte)this.READ_BYTE();
                    this.cycleCount -= 5;
                }
                ++this.regPC;
                break;
            }
            case 17: {
                this.regDE = this.READ_WORD();
                break;
            }
            case 18: {
                this.WRITE_BYTE(this.regDE, this.regAF >> 8);
                break;
            }
            case 19: {
                this.regDE = Z80.INC_WORD(this.regDE);
                break;
            }
            case 20: {
                this.regDE = this.INC_HIBYTE(this.regDE);
                break;
            }
            case 21: {
                this.regDE = this.DEC_HIBYTE(this.regDE);
                break;
            }
            case 22: {
                this.regDE = this.READ_BYTE() << 8 | this.regDE & 0xFF;
                break;
            }
            case 23: {
                this.regAF = (this.regAF & 0x7F00) << 1 | (this.regAF & 1) << 8 | this.regAF >> 15 | this.regAF & 0xEC;
                break;
            }
            case 24: {
                this.regPC += (byte)this.READ_BYTE(this.regPC) + 1;
                break;
            }
            case 25: {
                this.ADD_WORD_HL(this.regDE);
                break;
            }
            case 26: {
                this.regAF = this.READ_BYTE(this.regDE) << 8 | this.regAF & 0xFF;
                break;
            }
            case 27: {
                this.regDE = Z80.DEC_WORD(this.regDE);
                break;
            }
            case 28: {
                this.regDE = this.INC_LOBYTE(this.regDE);
                break;
            }
            case 29: {
                this.regDE = this.DEC_LOBYTE(this.regDE);
                break;
            }
            case 30: {
                this.regDE = this.regDE & 0xFF00 | this.READ_BYTE();
                break;
            }
            case 31: {
                this.regAF = (this.regAF & 0xFE00) >> 1 | (this.regAF & 1) << 15 | this.regAF >> 8 & 1 | this.regAF & 0xEC;
                break;
            }
            case 32: {
                if ((this.regAF & 0x40) == 0) {
                    this.regPC += (byte)this.READ_BYTE(this.regPC);
                    this.cycleCount -= 12 - this.cycles[32];
                }
                ++this.regPC;
                break;
            }
            case 33: {
                this.regHL = this.READ_WORD();
                break;
            }
            case 34: {
                this.WRITE_WORD(this.READ_WORD(), this.regHL);
                break;
            }
            case 35: {
                this.regHL = Z80.INC_WORD(this.regHL);
                break;
            }
            case 36: {
                this.regHL = this.INC_HIBYTE(this.regHL);
                break;
            }
            case 37: {
                this.regHL = this.DEC_HIBYTE(this.regHL);
                break;
            }
            case 38: {
                this.regHL = this.READ_BYTE() << 8 | this.regHL & 0xFF;
                break;
            }
            case 39: {
                this.DAA();
                break;
            }
            case 40: {
                if ((this.regAF & 0x40) != 0) {
                    this.regPC += (byte)this.READ_BYTE(this.regPC);
                    this.cycleCount -= 12 - this.cycles[40];
                }
                ++this.regPC;
                break;
            }
            case 41: {
                this.ADD_WORD_HL(this.regHL);
                break;
            }
            case 42: {
                this.regHL = this.READ_WORD(this.READ_WORD());
                break;
            }
            case 43: {
                this.regHL = Z80.DEC_WORD(this.regHL);
                break;
            }
            case 44: {
                this.regHL = this.INC_LOBYTE(this.regHL);
                break;
            }
            case 45: {
                this.regHL = this.DEC_LOBYTE(this.regHL);
                break;
            }
            case 46: {
                this.regHL = this.regHL & 0xFF00 | this.READ_BYTE();
                break;
            }
            case 47: {
                this.regAF = (this.regAF ^ 0xFF00) & 0xFF00 | this.regAF & 0xD7 | 2 | 0x10 | (this.regAF ^ 0xFF00) >> 8 & 0x28;
                break;
            }
            case 48: {
                if ((this.regAF & 1) == 0) {
                    this.regPC += (byte)this.READ_BYTE(this.regPC);
                    this.cycleCount -= 12 - this.cycles[48];
                }
                ++this.regPC;
                break;
            }
            case 49: {
                this.regSP = this.READ_WORD();
                break;
            }
            case 50: {
                this.WRITE_BYTE(this.READ_WORD(), this.regAF >> 8);
                break;
            }
            case 51: {
                ++this.regSP;
                break;
            }
            case 52: {
                this.WRITE_BYTE(this.regHL, this.INC_LOBYTE(this.READ_BYTE(this.regHL)));
                break;
            }
            case 53: {
                this.WRITE_BYTE(this.regHL, this.DEC_LOBYTE(this.READ_BYTE(this.regHL)));
                break;
            }
            case 54: {
                this.WRITE_BYTE(this.regHL, this.READ_BYTE());
                break;
            }
            case 55: {
                this.regAF = this.regAF & 0xFFED | 1;
                break;
            }
            case 56: {
                if ((this.regAF & 1) != 0) {
                    this.regPC += (byte)this.READ_BYTE(this.regPC);
                    this.cycleCount -= 12 - this.cycles[56];
                }
                ++this.regPC;
                break;
            }
            case 57: {
                this.ADD_WORD_HL(this.regSP);
                break;
            }
            case 58: {
                this.regAF = this.READ_BYTE(this.READ_WORD()) << 8 | this.regAF & 0xFF;
                break;
            }
            case 59: {
                --this.regSP;
                break;
            }
            case 60: {
                this.regAF += 256;
                this.regAF = this.regAF & 0xFF01 | ((this.regAF & 0xFF00) == 0 ? 64 : ((this.regAF & 0xFF00) == 32768 ? 4 : 0) | this.regAF >> 8 & 0xA8) | ((this.regAF & 0xF00) == 0 ? 16 : 0);
                break;
            }
            case 61: {
                this.regAF -= 256;
                this.regAF = this.regAF & 0xFF01 | 2 | ((this.regAF & 0xFF00) == 0 ? 64 : ((this.regAF & 0xFF00) == 32512 ? 4 : 0) | this.regAF >> 8 & 0xA8) | ((this.regAF & 0xF00) == 3840 ? 16 : 0);
                break;
            }
            case 62: {
                this.regAF = this.READ_BYTE() << 8 | this.regAF & 0xFF;
                break;
            }
            case 63: {
                this.regAF = (this.regAF & 0xFFC5 | this.regAF >> 8 & 0x28 | (this.regAF & 1) << 4) ^ 1;
                break;
            }
            case 64: {
                break;
            }
            case 65: {
                this.regBC = (this.regBC & 0xFF) << 8 | this.regBC & 0xFF;
                break;
            }
            case 66: {
                this.regBC = this.regDE & 0xFF00 | this.regBC & 0xFF;
                break;
            }
            case 67: {
                this.regBC = (this.regDE & 0xFF) << 8 | this.regBC & 0xFF;
                break;
            }
            case 68: {
                this.regBC = this.regHL & 0xFF00 | this.regBC & 0xFF;
                break;
            }
            case 69: {
                this.regBC = (this.regHL & 0xFF) << 8 | this.regBC & 0xFF;
                break;
            }
            case 70: {
                this.regBC = this.READ_BYTE(this.regHL) << 8 | this.regBC & 0xFF;
                break;
            }
            case 71: {
                this.regBC = this.regAF & 0xFF00 | this.regBC & 0xFF;
                break;
            }
            case 72: {
                this.regBC = this.regBC & 0xFF00 | this.regBC >> 8;
                break;
            }
            case 73: {
                break;
            }
            case 74: {
                this.regBC = this.regBC & 0xFF00 | this.regDE >> 8;
                break;
            }
            case 75: {
                this.regBC = this.regBC & 0xFF00 | this.regDE & 0xFF;
                break;
            }
            case 76: {
                this.regBC = this.regBC & 0xFF00 | this.regHL >> 8;
                break;
            }
            case 77: {
                this.regBC = this.regBC & 0xFF00 | this.regHL & 0xFF;
                break;
            }
            case 78: {
                this.regBC = this.regBC & 0xFF00 | this.READ_BYTE(this.regHL);
                break;
            }
            case 79: {
                this.regBC = this.regBC & 0xFF00 | this.regAF >> 8;
                break;
            }
            case 80: {
                this.regDE = this.regBC & 0xFF00 | this.regDE & 0xFF;
                break;
            }
            case 81: {
                this.regDE = (this.regBC & 0xFF) << 8 | this.regDE & 0xFF;
                break;
            }
            case 82: {
                break;
            }
            case 83: {
                this.regDE = (this.regDE & 0xFF) << 8 | this.regDE & 0xFF;
                break;
            }
            case 84: {
                this.regDE = this.regHL & 0xFF00 | this.regDE & 0xFF;
                break;
            }
            case 85: {
                this.regDE = (this.regHL & 0xFF) << 8 | this.regDE & 0xFF;
                break;
            }
            case 86: {
                this.regDE = this.READ_BYTE(this.regHL) << 8 | this.regDE & 0xFF;
                break;
            }
            case 87: {
                this.regDE = this.regAF & 0xFF00 | this.regDE & 0xFF;
                break;
            }
            case 88: {
                this.regDE = this.regDE & 0xFF00 | this.regBC >> 8;
                break;
            }
            case 89: {
                this.regDE = this.regDE & 0xFF00 | this.regBC & 0xFF;
                break;
            }
            case 90: {
                this.regDE = this.regDE & 0xFF00 | this.regDE >> 8;
                break;
            }
            case 91: {
                break;
            }
            case 92: {
                this.regDE = this.regDE & 0xFF00 | this.regHL >> 8;
                break;
            }
            case 93: {
                this.regDE = this.regDE & 0xFF00 | this.regHL & 0xFF;
                break;
            }
            case 94: {
                this.regDE = this.regDE & 0xFF00 | this.READ_BYTE(this.regHL);
                break;
            }
            case 95: {
                this.regDE = this.regDE & 0xFF00 | this.regAF >> 8;
                break;
            }
            case 96: {
                this.regHL = this.regBC & 0xFF00 | this.regHL & 0xFF;
                break;
            }
            case 97: {
                this.regHL = (this.regBC & 0xFF) << 8 | this.regHL & 0xFF;
                break;
            }
            case 98: {
                this.regHL = this.regDE & 0xFF00 | this.regHL & 0xFF;
                break;
            }
            case 99: {
                this.regHL = (this.regDE & 0xFF) << 8 | this.regHL & 0xFF;
                break;
            }
            case 100: {
                break;
            }
            case 101: {
                this.regHL = (this.regHL & 0xFF) << 8 | this.regHL & 0xFF;
                break;
            }
            case 102: {
                this.regHL = this.READ_BYTE(this.regHL) << 8 | this.regHL & 0xFF;
                break;
            }
            case 103: {
                this.regHL = this.regAF & 0xFF00 | this.regHL & 0xFF;
                break;
            }
            case 104: {
                this.regHL = this.regHL & 0xFF00 | this.regBC >> 8;
                break;
            }
            case 105: {
                this.regHL = this.regHL & 0xFF00 | this.regBC & 0xFF;
                break;
            }
            case 106: {
                this.regHL = this.regHL & 0xFF00 | this.regDE >> 8;
                break;
            }
            case 107: {
                this.regHL = this.regHL & 0xFF00 | this.regDE & 0xFF;
                break;
            }
            case 108: {
                this.regHL = this.regHL & 0xFF00 | this.regHL >> 8;
                break;
            }
            case 109: {
                break;
            }
            case 110: {
                this.regHL = this.regHL & 0xFF00 | this.READ_BYTE(this.regHL);
                break;
            }
            case 111: {
                this.regHL = this.regHL & 0xFF00 | this.regAF >> 8;
                break;
            }
            case 112: {
                this.WRITE_BYTE(this.regHL, this.regBC >> 8);
                break;
            }
            case 113: {
                this.WRITE_BYTE(this.regHL, this.regBC & 0xFF);
                break;
            }
            case 114: {
                this.WRITE_BYTE(this.regHL, this.regDE >> 8);
                break;
            }
            case 115: {
                this.WRITE_BYTE(this.regHL, this.regDE & 0xFF);
                break;
            }
            case 116: {
                this.WRITE_BYTE(this.regHL, this.regHL >> 8);
                break;
            }
            case 117: {
                this.WRITE_BYTE(this.regHL, this.regHL & 0xFF);
                break;
            }
            case 118: {
                if (!this.pinINT && !this.nmiPending) {
                    --this.regPC;
                    if (this.cycleCount <= 0) break;
                    this.cycleCount %= 4;
                    break;
                }
                this.cycleCount += 4;
                break;
            }
            case 119: {
                this.WRITE_BYTE(this.regHL, this.regAF >> 8);
                break;
            }
            case 120: {
                this.regAF = this.regBC & 0xFF00 | this.regAF & 0xFF;
                break;
            }
            case 121: {
                this.regAF = (this.regBC & 0xFF) << 8 | this.regAF & 0xFF;
                break;
            }
            case 122: {
                this.regAF = this.regDE & 0xFF00 | this.regAF & 0xFF;
                break;
            }
            case 123: {
                this.regAF = (this.regDE & 0xFF) << 8 | this.regAF & 0xFF;
                break;
            }
            case 124: {
                this.regAF = this.regHL & 0xFF00 | this.regAF & 0xFF;
                break;
            }
            case 125: {
                this.regAF = (this.regHL & 0xFF) << 8 | this.regAF & 0xFF;
                break;
            }
            case 126: {
                this.regAF = this.READ_BYTE(this.regHL) << 8 | this.regAF & 0xFF;
                break;
            }
            case 127: {
                break;
            }
            case 128: {
                this.ADD_HIBYTE(this.regBC);
                break;
            }
            case 129: {
                this.ADD_LOBYTE(this.regBC);
                break;
            }
            case 130: {
                this.ADD_HIBYTE(this.regDE);
                break;
            }
            case 131: {
                this.ADD_LOBYTE(this.regDE);
                break;
            }
            case 132: {
                this.ADD_HIBYTE(this.regHL);
                break;
            }
            case 133: {
                this.ADD_LOBYTE(this.regHL);
                break;
            }
            case 134: {
                this.ADD_LOBYTE(this.READ_BYTE(this.regHL));
                break;
            }
            case 135: {
                this.ADD_HIBYTE(this.regAF);
                break;
            }
            case 136: {
                this.ADC_HIBYTE(this.regBC);
                break;
            }
            case 137: {
                this.ADC_LOBYTE(this.regBC);
                break;
            }
            case 138: {
                this.ADC_HIBYTE(this.regDE);
                break;
            }
            case 139: {
                this.ADC_LOBYTE(this.regDE);
                break;
            }
            case 140: {
                this.ADC_HIBYTE(this.regHL);
                break;
            }
            case 141: {
                this.ADC_LOBYTE(this.regHL);
                break;
            }
            case 142: {
                this.ADC_LOBYTE(this.READ_BYTE(this.regHL));
                break;
            }
            case 143: {
                this.ADC_HIBYTE(this.regAF);
                break;
            }
            case 144: {
                this.SUB_HIBYTE(this.regBC);
                break;
            }
            case 145: {
                this.SUB_LOBYTE(this.regBC);
                break;
            }
            case 146: {
                this.SUB_HIBYTE(this.regDE);
                break;
            }
            case 147: {
                this.SUB_LOBYTE(this.regDE);
                break;
            }
            case 148: {
                this.SUB_HIBYTE(this.regHL);
                break;
            }
            case 149: {
                this.SUB_LOBYTE(this.regHL);
                break;
            }
            case 150: {
                this.SUB_LOBYTE(this.READ_BYTE(this.regHL));
                break;
            }
            case 151: {
                this.regAF = 66;
                break;
            }
            case 152: {
                this.SBC_HIBYTE(this.regBC);
                break;
            }
            case 153: {
                this.SBC_LOBYTE(this.regBC);
                break;
            }
            case 154: {
                this.SBC_HIBYTE(this.regDE);
                break;
            }
            case 155: {
                this.SBC_LOBYTE(this.regDE);
                break;
            }
            case 156: {
                this.SBC_HIBYTE(this.regHL);
                break;
            }
            case 157: {
                this.SBC_LOBYTE(this.regHL);
                break;
            }
            case 158: {
                this.SBC_LOBYTE(this.READ_BYTE(this.regHL));
                break;
            }
            case 159: {
                this.SBC_HIBYTE(this.regAF);
                break;
            }
            case 160: {
                this.AND_HIBYTE(this.regBC);
                break;
            }
            case 161: {
                this.AND_LOBYTE(this.regBC);
                break;
            }
            case 162: {
                this.AND_HIBYTE(this.regDE);
                break;
            }
            case 163: {
                this.AND_LOBYTE(this.regDE);
                break;
            }
            case 164: {
                this.AND_HIBYTE(this.regHL);
                break;
            }
            case 165: {
                this.AND_LOBYTE(this.regHL);
                break;
            }
            case 166: {
                this.AND_LOBYTE(this.READ_BYTE(this.regHL));
                break;
            }
            case 167: {
                this.regAF = (this.regAF >> 8 == 0 ? 68 : this.regAF & 0xFF00 | this.regAF >> 8 & 0xA8 | PARITY_FLAG[this.regAF >> 8]) | 0x10;
                break;
            }
            case 168: {
                this.XOR_HIBYTE(this.regBC);
                break;
            }
            case 169: {
                this.XOR_LOBYTE(this.regBC);
                break;
            }
            case 170: {
                this.XOR_HIBYTE(this.regDE);
                break;
            }
            case 171: {
                this.XOR_LOBYTE(this.regDE);
                break;
            }
            case 172: {
                this.XOR_HIBYTE(this.regHL);
                break;
            }
            case 173: {
                this.XOR_LOBYTE(this.regHL);
                break;
            }
            case 174: {
                this.XOR_LOBYTE(this.READ_BYTE(this.regHL));
                break;
            }
            case 175: {
                this.regAF = 68;
                break;
            }
            case 176: {
                this.OR_HIBYTE(this.regBC);
                break;
            }
            case 177: {
                this.OR_LOBYTE(this.regBC);
                break;
            }
            case 178: {
                this.OR_HIBYTE(this.regDE);
                break;
            }
            case 179: {
                this.OR_LOBYTE(this.regDE);
                break;
            }
            case 180: {
                this.OR_HIBYTE(this.regHL);
                break;
            }
            case 181: {
                this.OR_LOBYTE(this.regHL);
                break;
            }
            case 182: {
                this.OR_LOBYTE(this.READ_BYTE(this.regHL));
                break;
            }
            case 183: {
                this.regAF = this.regAF >> 8 == 0 ? 68 : this.regAF & 0xFF00 | this.regAF >> 8 & 0xA8 | PARITY_FLAG[this.regAF >> 8];
                break;
            }
            case 184: {
                this.CP_HIBYTE(this.regBC);
                break;
            }
            case 185: {
                this.CP_LOBYTE(this.regBC);
                break;
            }
            case 186: {
                this.CP_HIBYTE(this.regDE);
                break;
            }
            case 187: {
                this.CP_LOBYTE(this.regDE);
                break;
            }
            case 188: {
                this.CP_HIBYTE(this.regHL);
                break;
            }
            case 189: {
                this.CP_LOBYTE(this.regHL);
                break;
            }
            case 190: {
                this.CP_LOBYTE(this.READ_BYTE(this.regHL));
                break;
            }
            case 191: {
                this.regAF = this.regAF & 0xFF00 | 0x40 | 2;
                break;
            }
            case 192: {
                if ((this.regAF & 0x40) != 0) break;
                this.RET();
                this.cycleCount -= 2 * this.cycles[192] - 4;
                break;
            }
            case 193: {
                this.regBC = this.POP();
                break;
            }
            case 194: {
                if ((this.regAF & 0x40) == 0) {
                    this.regPC = this.READ_WORD();
                    this.cycleCount -= 2 * this.cycles[194] - 20;
                    break;
                }
                this.regPC += 2;
                break;
            }
            case 195: {
                this.regPC = this.READ_WORD();
                break;
            }
            case 196: {
                if ((this.regAF & 0x40) == 0) {
                    this.CALL();
                    this.cycleCount -= this.cycles[196] * 5 / 2 - 18;
                    break;
                }
                this.regPC += 2;
                break;
            }
            case 197: {
                this.PUSH(this.regBC);
                break;
            }
            case 198: {
                this.ADD_LOBYTE(this.READ_BYTE());
                break;
            }
            case 199: {
                this.RST(0);
                break;
            }
            case 200: {
                if ((this.regAF & 0x40) == 0) break;
                this.RET();
                this.cycleCount -= 2 * this.cycles[200] - 4;
                break;
            }
            case 201: {
                this.RET();
                break;
            }
            case 202: {
                if ((this.regAF & 0x40) != 0) {
                    this.regPC = this.READ_WORD();
                    this.cycleCount -= 2 * this.cycles[202] - 20;
                    break;
                }
                this.regPC += 2;
                break;
            }
            case 203: {
                n = this.READ_BYTE();
                this.cycleCount -= CYCLES_CB[n];
                this.executeInstructionCB(n);
                break;
            }
            case 204: {
                if ((this.regAF & 0x40) != 0) {
                    this.CALL();
                    this.cycleCount -= this.cycles[204] * 5 / 2 - 18;
                    break;
                }
                this.regPC += 2;
                break;
            }
            case 205: {
                this.CALL();
                break;
            }
            case 206: {
                this.ADC_LOBYTE(this.READ_BYTE());
                break;
            }
            case 207: {
                this.RST(8);
                break;
            }
            case 208: {
                if ((this.regAF & 1) != 0) break;
                this.RET();
                this.cycleCount -= 2 * this.cycles[208] - 4;
                break;
            }
            case 209: {
                this.regDE = this.POP();
                break;
            }
            case 210: {
                if ((this.regAF & 1) == 0) {
                    this.regPC = this.READ_WORD();
                    this.cycleCount -= 2 * this.cycles[210] - 20;
                    break;
                }
                this.regPC += 2;
                break;
            }
            case 211: {
                this.fireOutputAvailable(this.READ_BYTE(), this.regAF >> 8);
                break;
            }
            case 212: {
                if ((this.regAF & 1) == 0) {
                    this.CALL();
                    this.cycleCount -= this.cycles[212] * 5 / 2 - 18;
                    break;
                }
                this.regPC += 2;
                break;
            }
            case 213: {
                this.PUSH(this.regDE);
                break;
            }
            case 214: {
                this.SUB_LOBYTE(this.READ_BYTE());
                break;
            }
            case 215: {
                this.RST(16);
                break;
            }
            case 216: {
                if ((this.regAF & 1) == 0) break;
                this.RET();
                this.cycleCount -= 2 * this.cycles[216] - 4;
                break;
            }
            case 217: {
                int n3 = this.regBC;
                this.regBC = this.regBCex;
                this.regBCex = n3;
                n3 = this.regDE;
                this.regDE = this.regDEex;
                this.regDEex = n3;
                n3 = this.regHL;
                this.regHL = this.regHLex;
                this.regHLex = n3;
                break;
            }
            case 218: {
                if ((this.regAF & 1) != 0) {
                    this.regPC = this.READ_WORD();
                    this.cycleCount -= 2 * this.cycles[218] - 20;
                    break;
                }
                this.regPC += 2;
                break;
            }
            case 219: {
                this.fireOutputAvailable(this.READ_BYTE(), -1);
                this.regAF = this.input << 8 | this.regAF & 0xFF;
                break;
            }
            case 220: {
                if ((this.regAF & 1) != 0) {
                    this.CALL();
                    this.cycleCount -= this.cycles[220] * 5 / 2 - 18;
                    break;
                }
                this.regPC += 2;
                break;
            }
            case 221: {
                this.executeInstructionDD(this.READ_BYTE());
                break;
            }
            case 222: {
                this.SBC_LOBYTE(this.READ_BYTE());
                break;
            }
            case 223: {
                this.RST(24);
                break;
            }
            case 224: {
                if ((this.regAF & 4) != 0) break;
                this.RET();
                this.cycleCount -= 6;
                break;
            }
            case 225: {
                this.regHL = this.POP();
                break;
            }
            case 226: {
                if ((this.regAF & 4) == 0) {
                    this.regPC = this.READ_WORD();
                    break;
                }
                this.regPC += 2;
                break;
            }
            case 227: {
                int n4 = this.READ_WORD(this.regSP);
                this.WRITE_WORD(this.regSP, this.regHL);
                this.regHL = n4;
                break;
            }
            case 228: {
                if ((this.regAF & 4) == 0) {
                    this.CALL();
                    this.cycleCount -= 7;
                    break;
                }
                this.regPC += 2;
                break;
            }
            case 229: {
                this.PUSH(this.regHL);
                break;
            }
            case 230: {
                this.AND_LOBYTE(this.READ_BYTE());
                break;
            }
            case 231: {
                this.RST(32);
                break;
            }
            case 232: {
                if ((this.regAF & 4) == 0) break;
                this.RET();
                this.cycleCount -= 6;
                break;
            }
            case 233: {
                this.regPC = this.regHL;
                break;
            }
            case 234: {
                if ((this.regAF & 4) != 0) {
                    this.regPC = this.READ_WORD();
                    break;
                }
                this.regPC += 2;
                break;
            }
            case 235: {
                int n5 = this.regDE;
                this.regDE = this.regHL;
                this.regHL = n5;
                break;
            }
            case 236: {
                if ((this.regAF & 4) != 0) {
                    this.CALL();
                    this.cycleCount -= 7;
                    break;
                }
                this.regPC += 2;
                break;
            }
            case 237: {
                n = this.READ_BYTE();
                this.cycleCount -= CYCLES_ED[n - 64];
                this.executeInstructionED(n);
                break;
            }
            case 238: {
                this.XOR_LOBYTE(this.READ_BYTE());
                break;
            }
            case 239: {
                this.RST(40);
                break;
            }
            case 240: {
                if ((this.regAF & 0x80) != 0) break;
                this.RET();
                this.cycleCount -= 6;
                break;
            }
            case 241: {
                this.regAF = this.POP();
                break;
            }
            case 242: {
                if ((this.regAF & 0x80) == 0) {
                    this.regPC = this.READ_WORD();
                    break;
                }
                this.regPC += 2;
                break;
            }
            case 243: {
                this.setInterruptsEnabled(false);
                break;
            }
            case 244: {
                if ((this.regAF & 0x80) == 0) {
                    this.CALL();
                    this.cycleCount -= 7;
                    break;
                }
                this.regPC += 2;
                break;
            }
            case 245: {
                this.PUSH(this.regAF);
                break;
            }
            case 246: {
                this.OR_LOBYTE(this.READ_BYTE());
                break;
            }
            case 247: {
                this.RST(48);
                break;
            }
            case 248: {
                if ((this.regAF & 0x80) == 0) break;
                this.RET();
                this.cycleCount -= 6;
                break;
            }
            case 249: {
                this.regSP = this.regHL;
                break;
            }
            case 250: {
                if ((this.regAF & 0x80) != 0) {
                    this.regPC = this.READ_WORD();
                    break;
                }
                this.regPC += 2;
                break;
            }
            case 251: {
                this.setInterruptsEnabled(true);
                this.afterEI = true;
                break;
            }
            case 252: {
                if ((this.regAF & 0x80) != 0) {
                    this.CALL();
                    this.cycleCount -= 7;
                    break;
                }
                this.regPC += 2;
                break;
            }
            case 253: {
                this.executeInstructionFD(this.READ_BYTE());
                break;
            }
            case 254: {
                this.CP_LOBYTE(this.READ_BYTE());
                break;
            }
            case 255: {
                this.RST(56);
            }
        }
    }

    protected void executeInstructionCB(int n) {
        switch (n) {
            case 0: {
                this.regBC = this.RLC_HIBYTE(this.regBC);
                break;
            }
            case 1: {
                this.regBC = this.RLC_LOBYTE(this.regBC);
                break;
            }
            case 2: {
                this.regDE = this.RLC_HIBYTE(this.regDE);
                break;
            }
            case 3: {
                this.regDE = this.RLC_LOBYTE(this.regDE);
                break;
            }
            case 4: {
                this.regHL = this.RLC_HIBYTE(this.regHL);
                break;
            }
            case 5: {
                this.regHL = this.RLC_LOBYTE(this.regHL);
                break;
            }
            case 6: {
                this.WRITE_BYTE(this.regHL, this.RLC_LOBYTE(this.READ_BYTE(this.regHL)));
                break;
            }
            case 7: {
                this.regAF = (this.regAF & 0x7F00) << 1 | (this.regAF & 0x8000) >> 7 | this.regAF >> 15 | ((this.regAF & 0xFF00) == 0 ? 68 : this.regAF >> 7 & 0xA8 | PARITY_FLAG[this.regAF >> 8]);
                break;
            }
            case 8: {
                this.regBC = this.RRC_HIBYTE(this.regBC);
                break;
            }
            case 9: {
                this.regBC = this.RRC_LOBYTE(this.regBC);
                break;
            }
            case 10: {
                this.regDE = this.RRC_HIBYTE(this.regDE);
                break;
            }
            case 11: {
                this.regDE = this.RRC_LOBYTE(this.regDE);
                break;
            }
            case 12: {
                this.regHL = this.RRC_HIBYTE(this.regHL);
                break;
            }
            case 13: {
                this.regHL = this.RRC_LOBYTE(this.regHL);
                break;
            }
            case 14: {
                this.WRITE_BYTE(this.regHL, this.RRC_LOBYTE(this.READ_BYTE(this.regHL)));
                break;
            }
            case 15: {
                this.regAF = (this.regAF & 0x100) << 7 | (this.regAF & 0xFE00) >> 1 | this.regAF >> 8 & 1 | ((this.regAF & 0xFF00) == 0 ? 68 : ((this.regAF & 0x100) >> 1 | (this.regAF & 0xFE00) >> 9) & 0xA8 | PARITY_FLAG[this.regAF >> 8]);
                break;
            }
            case 16: {
                this.regBC = this.RL_HIBYTE(this.regBC);
                break;
            }
            case 17: {
                this.regBC = this.RL_LOBYTE(this.regBC);
                break;
            }
            case 18: {
                this.regDE = this.RL_HIBYTE(this.regDE);
                break;
            }
            case 19: {
                this.regDE = this.RL_LOBYTE(this.regDE);
                break;
            }
            case 20: {
                this.regHL = this.RL_HIBYTE(this.regHL);
                break;
            }
            case 21: {
                this.regHL = this.RL_LOBYTE(this.regHL);
                break;
            }
            case 22: {
                this.WRITE_BYTE(this.regHL, this.RL_LOBYTE(this.READ_BYTE(this.regHL)));
                break;
            }
            case 23: {
                if ((this.regAF & 1) != 0) {
                    this.regAF = (this.regAF & 0x7F00) << 1 | 0x100 | this.regAF >> 15 | this.regAF >> 7 & 0xA8 | PARITY_FLAG[(this.regAF & 0x7F00) >> 7 | 1];
                    break;
                }
                this.regAF = (this.regAF & 0x7F00) << 1 | this.regAF >> 15 | ((this.regAF & 0x7F00) == 0 ? 68 : this.regAF >> 7 & 0xA8 | PARITY_FLAG[(this.regAF & 0x7F00) >> 7]);
                break;
            }
            case 24: {
                this.regBC = this.RR_HIBYTE(this.regBC);
                break;
            }
            case 25: {
                this.regBC = this.RR_LOBYTE(this.regBC);
                break;
            }
            case 26: {
                this.regDE = this.RR_HIBYTE(this.regDE);
                break;
            }
            case 27: {
                this.regDE = this.RR_LOBYTE(this.regDE);
                break;
            }
            case 28: {
                this.regHL = this.RR_HIBYTE(this.regHL);
                break;
            }
            case 29: {
                this.regHL = this.RR_LOBYTE(this.regHL);
                break;
            }
            case 30: {
                this.WRITE_BYTE(this.regHL, this.RR_LOBYTE(this.READ_BYTE(this.regHL)));
                break;
            }
            case 31: {
                if ((this.regAF & 1) != 0) {
                    this.regAF = 0x8000 | (this.regAF & 0xFE00) >> 1 | this.regAF >> 8 & 1 | this.regAF >> 9 & 0x28 | PARITY_FLAG[0x80 | this.regAF >> 9] | 0x80;
                    break;
                }
                this.regAF = (this.regAF & 0xFE00) >> 1 | this.regAF >> 8 & 1 | ((this.regAF & 0xFE00) == 0 ? 68 : this.regAF >> 9 & 0x28 | PARITY_FLAG[this.regAF >> 9]);
                break;
            }
            case 32: {
                this.regBC = this.SLA_HIBYTE(this.regBC);
                break;
            }
            case 33: {
                this.regBC = this.SLA_LOBYTE(this.regBC);
                break;
            }
            case 34: {
                this.regDE = this.SLA_HIBYTE(this.regDE);
                break;
            }
            case 35: {
                this.regDE = this.SLA_LOBYTE(this.regDE);
                break;
            }
            case 36: {
                this.regHL = this.SLA_HIBYTE(this.regHL);
                break;
            }
            case 37: {
                this.regHL = this.SLA_LOBYTE(this.regHL);
                break;
            }
            case 38: {
                this.WRITE_BYTE(this.regHL, this.SLA_LOBYTE(this.READ_BYTE(this.regHL)));
                break;
            }
            case 39: {
                this.regAF = (this.regAF & 0x7F00) << 1 | this.regAF >> 15 | ((this.regAF & 0x7F00) == 0 ? 68 : this.regAF >> 7 & 0xA8 | PARITY_FLAG[(this.regAF & 0x7F00) >> 7]);
                break;
            }
            case 40: {
                this.regBC = this.SRA_HIBYTE(this.regBC);
                break;
            }
            case 41: {
                this.regBC = this.SRA_LOBYTE(this.regBC);
                break;
            }
            case 42: {
                this.regDE = this.SRA_HIBYTE(this.regDE);
                break;
            }
            case 43: {
                this.regDE = this.SRA_LOBYTE(this.regDE);
                break;
            }
            case 44: {
                this.regHL = this.SRA_HIBYTE(this.regHL);
                break;
            }
            case 45: {
                this.regHL = this.SRA_LOBYTE(this.regHL);
                break;
            }
            case 46: {
                this.WRITE_BYTE(this.regHL, this.SRA_LOBYTE(this.READ_BYTE(this.regHL)));
                break;
            }
            case 47: {
                this.regAF = this.regAF & 0x8000 | (this.regAF & 0xFE00) >> 1 | this.regAF >> 8 & 1 | ((this.regAF & 0xFE00) == 0 ? 68 : ((this.regAF & 0x8000) >> 8 | this.regAF >> 9) & 0xA8 | PARITY_FLAG[(this.regAF & 0x8000) >> 8 | this.regAF >> 9]);
                break;
            }
            case 48: {
                this.regBC = this.SLL_HIBYTE(this.regBC);
                break;
            }
            case 49: {
                this.regBC = this.SLL_LOBYTE(this.regBC);
                break;
            }
            case 50: {
                this.regDE = this.SLL_HIBYTE(this.regDE);
                break;
            }
            case 51: {
                this.regDE = this.SLL_LOBYTE(this.regDE);
                break;
            }
            case 52: {
                this.regHL = this.SLL_HIBYTE(this.regHL);
                break;
            }
            case 53: {
                this.regHL = this.SLL_LOBYTE(this.regHL);
                break;
            }
            case 54: {
                this.WRITE_BYTE(this.regHL, this.SLL_LOBYTE(this.READ_BYTE(this.regHL)));
                break;
            }
            case 55: {
                this.regAF = (this.regAF & 0x7F00) << 1 | 0x100 | this.regAF >> 15 | this.regAF >> 7 & 0xA8 | PARITY_FLAG[(this.regAF & 0x7F00) >> 7 | 1];
                break;
            }
            case 56: {
                this.regBC = this.SRL_HIBYTE(this.regBC);
                break;
            }
            case 57: {
                this.regBC = this.SRL_LOBYTE(this.regBC);
                break;
            }
            case 58: {
                this.regDE = this.SRL_HIBYTE(this.regDE);
                break;
            }
            case 59: {
                this.regDE = this.SRL_LOBYTE(this.regDE);
                break;
            }
            case 60: {
                this.regHL = this.SRL_HIBYTE(this.regHL);
                break;
            }
            case 61: {
                this.regHL = this.SRL_LOBYTE(this.regHL);
                break;
            }
            case 62: {
                this.WRITE_BYTE(this.regHL, this.SRL_LOBYTE(this.READ_BYTE(this.regHL)));
                break;
            }
            case 63: {
                this.regAF = (this.regAF & 0xFE00) >> 1 | this.regAF >> 8 & 1 | ((this.regAF & 0xFE00) == 0 ? 68 : this.regAF >> 9 & 0xA8 | PARITY_FLAG[this.regAF >> 9]);
                break;
            }
            case 64: {
                this.BIT(0, this.regBC >> 8);
                break;
            }
            case 65: {
                this.BIT(0, this.regBC & 0xFF);
                break;
            }
            case 66: {
                this.BIT(0, this.regDE >> 8);
                break;
            }
            case 67: {
                this.BIT(0, this.regDE & 0xFF);
                break;
            }
            case 68: {
                this.BIT(0, this.regHL >> 8);
                break;
            }
            case 69: {
                this.BIT(0, this.regHL & 0xFF);
                break;
            }
            case 70: {
                this.BIT(0, this.READ_BYTE(this.regHL));
                break;
            }
            case 71: {
                this.BIT(0, this.regAF >> 8);
                break;
            }
            case 72: {
                this.BIT(1, this.regBC >> 8);
                break;
            }
            case 73: {
                this.BIT(1, this.regBC & 0xFF);
                break;
            }
            case 74: {
                this.BIT(1, this.regDE >> 8);
                break;
            }
            case 75: {
                this.BIT(1, this.regDE & 0xFF);
                break;
            }
            case 76: {
                this.BIT(1, this.regHL >> 8);
                break;
            }
            case 77: {
                this.BIT(1, this.regHL & 0xFF);
                break;
            }
            case 78: {
                this.BIT(1, this.READ_BYTE(this.regHL));
                break;
            }
            case 79: {
                this.BIT(1, this.regAF >> 8);
                break;
            }
            case 80: {
                this.BIT(2, this.regBC >> 8);
                break;
            }
            case 81: {
                this.BIT(2, this.regBC & 0xFF);
                break;
            }
            case 82: {
                this.BIT(2, this.regDE >> 8);
                break;
            }
            case 83: {
                this.BIT(2, this.regDE & 0xFF);
                break;
            }
            case 84: {
                this.BIT(2, this.regHL >> 8);
                break;
            }
            case 85: {
                this.BIT(2, this.regHL & 0xFF);
                break;
            }
            case 86: {
                this.BIT(2, this.READ_BYTE(this.regHL));
                break;
            }
            case 87: {
                this.BIT(2, this.regAF >> 8);
                break;
            }
            case 88: {
                this.BIT(3, this.regBC >> 8);
                break;
            }
            case 89: {
                this.BIT(3, this.regBC & 0xFF);
                break;
            }
            case 90: {
                this.BIT(3, this.regDE >> 8);
                break;
            }
            case 91: {
                this.BIT(3, this.regDE & 0xFF);
                break;
            }
            case 92: {
                this.BIT(3, this.regHL >> 8);
                break;
            }
            case 93: {
                this.BIT(3, this.regHL & 0xFF);
                break;
            }
            case 94: {
                this.BIT(3, this.READ_BYTE(this.regHL));
                break;
            }
            case 95: {
                this.BIT(3, this.regAF >> 8);
                break;
            }
            case 96: {
                this.BIT(4, this.regBC >> 8);
                break;
            }
            case 97: {
                this.BIT(4, this.regBC & 0xFF);
                break;
            }
            case 98: {
                this.BIT(4, this.regDE >> 8);
                break;
            }
            case 99: {
                this.BIT(4, this.regDE & 0xFF);
                break;
            }
            case 100: {
                this.BIT(4, this.regHL >> 8);
                break;
            }
            case 101: {
                this.BIT(4, this.regHL & 0xFF);
                break;
            }
            case 102: {
                this.BIT(4, this.READ_BYTE(this.regHL));
                break;
            }
            case 103: {
                this.BIT(4, this.regAF >> 8);
                break;
            }
            case 104: {
                this.BIT(5, this.regBC >> 8);
                break;
            }
            case 105: {
                this.BIT(5, this.regBC & 0xFF);
                break;
            }
            case 106: {
                this.BIT(5, this.regDE >> 8);
                break;
            }
            case 107: {
                this.BIT(5, this.regDE & 0xFF);
                break;
            }
            case 108: {
                this.BIT(5, this.regHL >> 8);
                break;
            }
            case 109: {
                this.BIT(5, this.regHL & 0xFF);
                break;
            }
            case 110: {
                this.BIT(5, this.READ_BYTE(this.regHL));
                break;
            }
            case 111: {
                this.BIT(5, this.regAF >> 8);
                break;
            }
            case 112: {
                this.BIT(6, this.regBC >> 8);
                break;
            }
            case 113: {
                this.BIT(6, this.regBC & 0xFF);
                break;
            }
            case 114: {
                this.BIT(6, this.regDE >> 8);
                break;
            }
            case 115: {
                this.BIT(6, this.regDE & 0xFF);
                break;
            }
            case 116: {
                this.BIT(6, this.regHL >> 8);
                break;
            }
            case 117: {
                this.BIT(6, this.regHL & 0xFF);
                break;
            }
            case 118: {
                this.BIT(6, this.READ_BYTE(this.regHL));
                break;
            }
            case 119: {
                this.BIT(6, this.regAF >> 8);
                break;
            }
            case 120: {
                this.BIT(7, this.regBC >> 8);
                break;
            }
            case 121: {
                this.BIT(7, this.regBC & 0xFF);
                break;
            }
            case 122: {
                this.BIT(7, this.regDE >> 8);
                break;
            }
            case 123: {
                this.BIT(7, this.regDE & 0xFF);
                break;
            }
            case 124: {
                this.BIT(7, this.regHL >> 8);
                break;
            }
            case 125: {
                this.BIT(7, this.regHL & 0xFF);
                break;
            }
            case 126: {
                this.BIT(7, this.READ_BYTE(this.regHL));
                break;
            }
            case 127: {
                this.BIT(7, this.regAF >> 8);
                break;
            }
            case 128: {
                this.regBC &= 0xFEFF;
                break;
            }
            case 129: {
                this.regBC &= 0xFFFE;
                break;
            }
            case 130: {
                this.regDE &= 0xFEFF;
                break;
            }
            case 131: {
                this.regDE &= 0xFFFE;
                break;
            }
            case 132: {
                this.regHL &= 0xFEFF;
                break;
            }
            case 133: {
                this.regHL &= 0xFFFE;
                break;
            }
            case 134: {
                this.WRITE_BYTE(this.regHL, this.READ_BYTE(this.regHL) & 0xFE);
                break;
            }
            case 135: {
                this.regAF &= 0xFEFF;
                break;
            }
            case 136: {
                this.regBC &= 0xFDFF;
                break;
            }
            case 137: {
                this.regBC &= 0xFFFD;
                break;
            }
            case 138: {
                this.regDE &= 0xFDFF;
                break;
            }
            case 139: {
                this.regDE &= 0xFFFD;
                break;
            }
            case 140: {
                this.regHL &= 0xFDFF;
                break;
            }
            case 141: {
                this.regHL &= 0xFFFD;
                break;
            }
            case 142: {
                this.WRITE_BYTE(this.regHL, this.READ_BYTE(this.regHL) & 0xFD);
                break;
            }
            case 143: {
                this.regAF &= 0xFDFF;
                break;
            }
            case 144: {
                this.regBC &= 0xFBFF;
                break;
            }
            case 145: {
                this.regBC &= 0xFFFB;
                break;
            }
            case 146: {
                this.regDE &= 0xFBFF;
                break;
            }
            case 147: {
                this.regDE &= 0xFFFB;
                break;
            }
            case 148: {
                this.regHL &= 0xFBFF;
                break;
            }
            case 149: {
                this.regHL &= 0xFFFB;
                break;
            }
            case 150: {
                this.WRITE_BYTE(this.regHL, this.READ_BYTE(this.regHL) & 0xFB);
                break;
            }
            case 151: {
                this.regAF &= 0xFBFF;
                break;
            }
            case 152: {
                this.regBC &= 0xF7FF;
                break;
            }
            case 153: {
                this.regBC &= 0xFFF7;
                break;
            }
            case 154: {
                this.regDE &= 0xF7FF;
                break;
            }
            case 155: {
                this.regDE &= 0xFFF7;
                break;
            }
            case 156: {
                this.regHL &= 0xF7FF;
                break;
            }
            case 157: {
                this.regHL &= 0xFFF7;
                break;
            }
            case 158: {
                this.WRITE_BYTE(this.regHL, this.READ_BYTE(this.regHL) & 0xF7);
                break;
            }
            case 159: {
                this.regAF &= 0xF7FF;
                break;
            }
            case 160: {
                this.regBC &= 0xEFFF;
                break;
            }
            case 161: {
                this.regBC &= 0xFFEF;
                break;
            }
            case 162: {
                this.regDE &= 0xEFFF;
                break;
            }
            case 163: {
                this.regDE &= 0xFFEF;
                break;
            }
            case 164: {
                this.regHL &= 0xEFFF;
                break;
            }
            case 165: {
                this.regHL &= 0xFFEF;
                break;
            }
            case 166: {
                this.WRITE_BYTE(this.regHL, this.READ_BYTE(this.regHL) & 0xEF);
                break;
            }
            case 167: {
                this.regAF &= 0xEFFF;
                break;
            }
            case 168: {
                this.regBC &= 0xDFFF;
                break;
            }
            case 169: {
                this.regBC &= 0xFFDF;
                break;
            }
            case 170: {
                this.regDE &= 0xDFFF;
                break;
            }
            case 171: {
                this.regDE &= 0xFFDF;
                break;
            }
            case 172: {
                this.regHL &= 0xDFFF;
                break;
            }
            case 173: {
                this.regHL &= 0xFFDF;
                break;
            }
            case 174: {
                this.WRITE_BYTE(this.regHL, this.READ_BYTE(this.regHL) & 0xDF);
                break;
            }
            case 175: {
                this.regAF &= 0xDFFF;
                break;
            }
            case 176: {
                this.regBC &= 0xBFFF;
                break;
            }
            case 177: {
                this.regBC &= 0xFFBF;
                break;
            }
            case 178: {
                this.regDE &= 0xBFFF;
                break;
            }
            case 179: {
                this.regDE &= 0xFFBF;
                break;
            }
            case 180: {
                this.regHL &= 0xBFFF;
                break;
            }
            case 181: {
                this.regHL &= 0xFFBF;
                break;
            }
            case 182: {
                this.WRITE_BYTE(this.regHL, this.READ_BYTE(this.regHL) & 0xBF);
                break;
            }
            case 183: {
                this.regAF &= 0xBFFF;
                break;
            }
            case 184: {
                this.regBC &= Short.MAX_VALUE;
                break;
            }
            case 185: {
                this.regBC &= 0xFF7F;
                break;
            }
            case 186: {
                this.regDE &= Short.MAX_VALUE;
                break;
            }
            case 187: {
                this.regDE &= 0xFF7F;
                break;
            }
            case 188: {
                this.regHL &= Short.MAX_VALUE;
                break;
            }
            case 189: {
                this.regHL &= 0xFF7F;
                break;
            }
            case 190: {
                this.WRITE_BYTE(this.regHL, this.READ_BYTE(this.regHL) & 0x7F);
                break;
            }
            case 191: {
                this.regAF &= Short.MAX_VALUE;
                break;
            }
            case 192: {
                this.regBC |= 0x100;
                break;
            }
            case 193: {
                this.regBC |= 1;
                break;
            }
            case 194: {
                this.regDE |= 0x100;
                break;
            }
            case 195: {
                this.regDE |= 1;
                break;
            }
            case 196: {
                this.regHL |= 0x100;
                break;
            }
            case 197: {
                this.regHL |= 1;
                break;
            }
            case 198: {
                this.WRITE_BYTE(this.regHL, this.READ_BYTE(this.regHL) | 1);
                break;
            }
            case 199: {
                this.regAF |= 0x100;
                break;
            }
            case 200: {
                this.regBC |= 0x200;
                break;
            }
            case 201: {
                this.regBC |= 2;
                break;
            }
            case 202: {
                this.regDE |= 0x200;
                break;
            }
            case 203: {
                this.regDE |= 2;
                break;
            }
            case 204: {
                this.regHL |= 0x200;
                break;
            }
            case 205: {
                this.regHL |= 2;
                break;
            }
            case 206: {
                this.WRITE_BYTE(this.regHL, this.READ_BYTE(this.regHL) | 2);
                break;
            }
            case 207: {
                this.regAF |= 0x200;
                break;
            }
            case 208: {
                this.regBC |= 0x400;
                break;
            }
            case 209: {
                this.regBC |= 4;
                break;
            }
            case 210: {
                this.regDE |= 0x400;
                break;
            }
            case 211: {
                this.regDE |= 4;
                break;
            }
            case 212: {
                this.regHL |= 0x400;
                break;
            }
            case 213: {
                this.regHL |= 4;
                break;
            }
            case 214: {
                this.WRITE_BYTE(this.regHL, this.READ_BYTE(this.regHL) | 4);
                break;
            }
            case 215: {
                this.regAF |= 0x400;
                break;
            }
            case 216: {
                this.regBC |= 0x800;
                break;
            }
            case 217: {
                this.regBC |= 8;
                break;
            }
            case 218: {
                this.regDE |= 0x800;
                break;
            }
            case 219: {
                this.regDE |= 8;
                break;
            }
            case 220: {
                this.regHL |= 0x800;
                break;
            }
            case 221: {
                this.regHL |= 8;
                break;
            }
            case 222: {
                this.WRITE_BYTE(this.regHL, this.READ_BYTE(this.regHL) | 8);
                break;
            }
            case 223: {
                this.regAF |= 0x800;
                break;
            }
            case 224: {
                this.regBC |= 0x1000;
                break;
            }
            case 225: {
                this.regBC |= 0x10;
                break;
            }
            case 226: {
                this.regDE |= 0x1000;
                break;
            }
            case 227: {
                this.regDE |= 0x10;
                break;
            }
            case 228: {
                this.regHL |= 0x1000;
                break;
            }
            case 229: {
                this.regHL |= 0x10;
                break;
            }
            case 230: {
                this.WRITE_BYTE(this.regHL, this.READ_BYTE(this.regHL) | 0x10);
                break;
            }
            case 231: {
                this.regAF |= 0x1000;
                break;
            }
            case 232: {
                this.regBC |= 0x2000;
                break;
            }
            case 233: {
                this.regBC |= 0x20;
                break;
            }
            case 234: {
                this.regDE |= 0x2000;
                break;
            }
            case 235: {
                this.regDE |= 0x20;
                break;
            }
            case 236: {
                this.regHL |= 0x2000;
                break;
            }
            case 237: {
                this.regHL |= 0x20;
                break;
            }
            case 238: {
                this.WRITE_BYTE(this.regHL, this.READ_BYTE(this.regHL) | 0x20);
                break;
            }
            case 239: {
                this.regAF |= 0x2000;
                break;
            }
            case 240: {
                this.regBC |= 0x4000;
                break;
            }
            case 241: {
                this.regBC |= 0x40;
                break;
            }
            case 242: {
                this.regDE |= 0x4000;
                break;
            }
            case 243: {
                this.regDE |= 0x40;
                break;
            }
            case 244: {
                this.regHL |= 0x4000;
                break;
            }
            case 245: {
                this.regHL |= 0x40;
                break;
            }
            case 246: {
                this.WRITE_BYTE(this.regHL, this.READ_BYTE(this.regHL) | 0x40);
                break;
            }
            case 247: {
                this.regAF |= 0x4000;
                break;
            }
            case 248: {
                this.regBC |= 0x8000;
                break;
            }
            case 249: {
                this.regBC |= 0x80;
                break;
            }
            case 250: {
                this.regDE |= 0x8000;
                break;
            }
            case 251: {
                this.regDE |= 0x80;
                break;
            }
            case 252: {
                this.regHL |= 0x8000;
                break;
            }
            case 253: {
                this.regHL |= 0x80;
                break;
            }
            case 254: {
                this.WRITE_BYTE(this.regHL, this.READ_BYTE(this.regHL) | 0x80);
                break;
            }
            case 255: {
                this.regAF |= 0x8000;
            }
        }
    }

    private void executeInstructionED(int n) {
        switch (n) {
            case 64: {
                this.fireOutputAvailable(this.regBC & 0xFF, -1);
                this.regBC = this.input << 8 | this.regBC & 0xFF;
                this.regAF = this.regAF & 0xFF01 | (this.input == 0 ? 68 : this.input & 0x80 | PARITY_FLAG[this.input]);
                break;
            }
            case 65: {
                this.fireOutputAvailable(this.regBC & 0xFF, this.regBC >> 8);
                break;
            }
            case 66: {
                this.SBC_WORD(this.regBC);
                break;
            }
            case 67: {
                this.WRITE_WORD(this.READ_WORD(), this.regBC);
                break;
            }
            case 68: {
                this.NEG();
                break;
            }
            case 69: {
                this.RETN();
                break;
            }
            case 71: {
                this.regI = this.regAF >> 8;
                break;
            }
            case 72: {
                this.fireOutputAvailable(this.regBC & 0xFF, -1);
                this.regBC = this.regBC & 0xFF00 | this.input;
                this.regAF = this.regAF & 0xFF01 | (this.input == 0 ? 68 : this.input & 0x80 | PARITY_FLAG[this.input]);
                break;
            }
            case 74: {
                this.ADC_WORD(this.regBC);
                break;
            }
            case 75: {
                this.regBC = this.READ_WORD(this.READ_WORD());
                break;
            }
            case 77: {
                this.RET();
                break;
            }
            case 79: {
                this.regR = this.regAF >> 8;
                break;
            }
            case 80: {
                this.fireOutputAvailable(this.regBC & 0xFF, -1);
                this.regDE = this.input << 8 | this.regDE & 0xFF;
                this.regAF = this.regAF & 0xFF01 | (this.input == 0 ? 68 : this.input & 0x80 | PARITY_FLAG[this.input]);
                break;
            }
            case 81: {
                this.fireOutputAvailable(this.regBC & 0xFF, this.regDE >> 8);
                break;
            }
            case 82: {
                this.SBC_WORD(this.regDE);
                break;
            }
            case 83: {
                this.WRITE_WORD(this.READ_WORD(), this.regDE);
                break;
            }
            case 85: {
                this.RETN();
                break;
            }
            case 86: {
                this.interruptMode = 1;
                break;
            }
            case 87: {
                this.regAF = this.regI << 8 | this.regAF & 1 | (this.regI == 0 ? 64 : this.regI & 0x80) | (this.interruptFlipFlop2 ? 4 : 0);
                break;
            }
            case 88: {
                this.fireOutputAvailable(this.regBC & 0xFF, -1);
                this.regDE = this.regDE & 0xFF00 | this.input;
                this.regAF = this.regAF & 0xFF01 | (this.input == 0 ? 68 : this.input & 0x80 | PARITY_FLAG[this.input]);
                break;
            }
            case 89: {
                this.fireOutputAvailable(this.regBC & 0xFF, this.regDE & 0xFF);
                break;
            }
            case 90: {
                this.ADC_WORD(this.regDE);
                break;
            }
            case 91: {
                this.regDE = this.READ_WORD(this.READ_WORD());
                break;
            }
            case 95: {
                this.regAF = this.regR << 8 | (this.regR == 0 ? 68 : this.regR & 0xA8) | this.regAF & 1;
                break;
            }
            case 96: {
                this.fireOutputAvailable(this.regBC & 0xFF, -1);
                this.regHL = this.input << 8 | this.regHL & 0xFF;
                this.regAF = this.regAF & 0xFF01 | (this.input == 0 ? 68 : this.input & 0x80 | PARITY_FLAG[this.input]);
                break;
            }
            case 97: {
                this.fireOutputAvailable(this.regBC & 0xFF, this.regHL >> 8);
                break;
            }
            case 98: {
                this.SBC_WORD(this.regHL);
                break;
            }
            case 99: {
                this.WRITE_WORD(this.READ_WORD(), this.regHL);
                break;
            }
            case 101: {
                this.RETN();
                break;
            }
            case 103: {
                this.RRD();
                break;
            }
            case 104: {
                this.fireOutputAvailable(this.regBC & 0xFF, -1);
                this.regHL = this.regHL & 0xFF00 | this.input;
                this.regAF = this.regAF & 0xFF01 | (this.input == 0 ? 68 : this.input & 0x80 | PARITY_FLAG[this.input]);
                break;
            }
            case 105: {
                this.fireOutputAvailable(this.regBC & 0xFF, this.regHL & 0xFF);
                break;
            }
            case 106: {
                this.ADC_WORD(this.regHL);
                break;
            }
            case 107: {
                this.regHL = this.READ_WORD(this.READ_WORD());
                break;
            }
            case 111: {
                this.RLD();
                break;
            }
            case 113: {
                this.fireOutputAvailable(this.regBC & 0xFF, 0);
                break;
            }
            case 114: {
                this.SBC_WORD(this.regSP);
                break;
            }
            case 115: {
                this.WRITE_WORD(this.READ_WORD(), this.regSP);
                break;
            }
            case 117: {
                this.RETN();
                break;
            }
            case 120: {
                this.fireOutputAvailable(this.regBC & 0xFF, -1);
                this.regAF = this.input << 8 | this.regAF & 1 | (this.input == 0 ? 68 : this.input & 0x80 | PARITY_FLAG[this.input]);
                break;
            }
            case 121: {
                this.fireOutputAvailable(this.regBC & 0xFF, this.regAF >> 8);
                break;
            }
            case 122: {
                this.ADC_WORD(this.regSP);
                break;
            }
            case 123: {
                this.regSP = this.READ_WORD(this.READ_WORD());
                break;
            }
            case 160: {
                this.WRITE_BYTE(this.regDE, this.READ_BYTE(this.regHL));
                this.regDE = Z80.INC_WORD(this.regDE);
                this.regHL = Z80.INC_WORD(this.regHL);
                this.regBC = Z80.DEC_WORD(this.regBC);
                this.regAF = this.regBC > 0 ? this.regAF & 0xFFE9 | 4 : this.regAF & 0xFFE9;
                break;
            }
            case 161: {
                this.CPI();
                break;
            }
            case 162: {
                this.fireOutputAvailable(this.regBC & 0xFF, -1);
                this.WRITE_BYTE(this.regHL, this.input);
                this.regBC = this.DEC_HIBYTE(this.regBC);
                this.regHL = Z80.INC_WORD(this.regHL);
                break;
            }
            case 163: {
                this.fireOutputAvailable(this.regBC & 0xFF, this.READ_BYTE(this.regHL));
                this.regBC = this.DEC_HIBYTE(this.regBC);
                this.regHL = Z80.INC_WORD(this.regHL);
                break;
            }
            case 168: {
                this.WRITE_BYTE(this.regDE, this.READ_BYTE(this.regHL));
                this.regDE = Z80.DEC_WORD(this.regDE);
                this.regHL = Z80.DEC_WORD(this.regHL);
                this.regBC = Z80.DEC_WORD(this.regBC);
                this.regAF = this.regBC > 0 ? this.regAF & 0xFFE9 | 4 : this.regAF & 0xFFE9;
                break;
            }
            case 169: {
                this.CPD();
                break;
            }
            case 171: {
                this.fireOutputAvailable(this.regBC & 0xFF, this.READ_BYTE(this.regHL));
                this.regHL = Z80.DEC_WORD(this.regHL);
                this.regBC = this.DEC_HIBYTE(this.regBC);
                break;
            }
            case 176: {
                this.WRITE_BYTE(this.regDE, this.READ_BYTE(this.regHL));
                this.regDE = Z80.INC_WORD(this.regDE);
                this.regHL = Z80.INC_WORD(this.regHL);
                this.regBC = Z80.DEC_WORD(this.regBC);
                if (this.regBC > 0) {
                    this.regPC -= 2;
                    this.cycleCount -= 5;
                    break;
                }
                this.regAF &= 0xFFE9;
                break;
            }
            case 177: {
                this.CPI();
                if (this.regBC <= 0 || (this.regAF & 0x40) != 0) break;
                this.regPC -= 2;
                this.cycleCount -= 5;
                break;
            }
            case 178: {
                this.fireOutputAvailable(this.regBC & 0xFF, -1);
                this.WRITE_BYTE(this.regHL, this.input);
                this.regBC = this.DEC_HIBYTE(this.regBC);
                this.regHL = Z80.INC_WORD(this.regHL);
                if ((this.regBC & 0xFF00) <= 0) break;
                this.regPC -= 2;
                this.cycleCount -= 5;
                break;
            }
            case 179: {
                this.fireOutputAvailable(this.regBC & 0xFF, this.READ_BYTE(this.regHL));
                this.regBC = this.DEC_HIBYTE(this.regBC);
                this.regHL = Z80.INC_WORD(this.regHL);
                if ((this.regBC & 0xFF00) <= 0) break;
                this.regPC -= 2;
                this.cycleCount -= 5;
                break;
            }
            case 184: {
                this.WRITE_BYTE(this.regDE, this.READ_BYTE(this.regHL));
                this.regDE = Z80.DEC_WORD(this.regDE);
                this.regHL = Z80.DEC_WORD(this.regHL);
                this.regBC = Z80.DEC_WORD(this.regBC);
                if (this.regBC > 0) {
                    this.regPC -= 2;
                    this.cycleCount -= 5;
                    break;
                }
                this.regAF &= 0xFFE9;
                break;
            }
            case 185: {
                this.CPD();
                if (this.regBC <= 0 || (this.regAF & 0x40) != 0) break;
                this.regPC -= 2;
                this.cycleCount -= 5;
                break;
            }
            case 187: {
                this.fireOutputAvailable(this.regBC & 0xFF, this.READ_BYTE(this.regHL));
                this.regHL = Z80.DEC_WORD(this.regHL);
                this.regBC = this.DEC_HIBYTE(this.regBC);
                if ((this.regBC & 0xFF00) <= 0) break;
                this.regPC -= 2;
                this.cycleCount -= 5;
                break;
            }
            default: {
                this.cycleCount = 0;
                System.out.println("Instruktion noch nicht implementiert.");
            }
        }
    }

    private void executeInstructionDD(int n) {
        switch (n) {
            case 9: {
                this.ADD_WORD_IX(this.regBC);
                this.cycleCount -= 11;
                break;
            }
            case 25: {
                this.ADD_WORD_IX(this.regDE);
                this.cycleCount -= 11;
                break;
            }
            case 33: {
                this.regIX = this.READ_WORD();
                this.cycleCount -= 10;
                break;
            }
            case 34: {
                this.WRITE_WORD(this.READ_WORD(), this.regIX);
                this.cycleCount -= 16;
                break;
            }
            case 35: {
                this.regIX = Z80.INC_WORD(this.regIX);
                this.cycleCount -= 6;
                break;
            }
            case 36: {
                this.regIX = this.INC_HIBYTE(this.regIX);
                this.cycleCount -= 4;
                break;
            }
            case 37: {
                this.regIX = this.DEC_HIBYTE(this.regIX);
                this.cycleCount -= 4;
                break;
            }
            case 38: {
                this.regIX = this.READ_BYTE() << 8 | this.regIX & 0xFF;
                this.cycleCount -= 7;
                break;
            }
            case 41: {
                this.ADD_WORD_IX(this.regIX);
                this.cycleCount -= 11;
                break;
            }
            case 42: {
                this.regIX = this.READ_WORD(this.READ_WORD());
                this.cycleCount -= 16;
                break;
            }
            case 43: {
                this.regIX = Z80.DEC_WORD(this.regIX);
                this.cycleCount -= 6;
                break;
            }
            case 44: {
                this.regIX = this.INC_LOBYTE(this.regIX);
                this.cycleCount -= 4;
                break;
            }
            case 45: {
                this.regIX = this.DEC_LOBYTE(this.regIX);
                this.cycleCount -= 4;
                break;
            }
            case 46: {
                this.regIX = this.regIX & 0xFF00 | this.READ_BYTE();
                this.cycleCount -= 7;
                break;
            }
            case 52: {
                byte by = (byte)this.READ_BYTE();
                this.WRITE_BYTE(this.regIX + by, this.READ_BYTE(this.regIX + by) + 1 & 0xFF);
                this.regAF = this.regAF & 0xFF00 | this.regAF & 1 | (this.READ_BYTE(this.regIX + by) == 128 ? 4 : 0) | ((this.READ_BYTE(this.regIX + by) & 0xF) == 0 ? 16 : 0) | (this.READ_BYTE(this.regIX + by) == 0 ? 64 : this.READ_BYTE(this.regIX + by) & 0xA8);
                this.cycleCount -= 19;
                break;
            }
            case 53: {
                byte by = (byte)this.READ_BYTE();
                this.WRITE_BYTE(this.regIX + by, this.READ_BYTE(this.regIX + by) - 1 & 0xFF);
                this.regAF = this.regAF & 0xFF00 | this.regAF & 1 | 2 | (this.READ_BYTE(this.regIX + by) == 127 ? 4 : 0) | ((this.READ_BYTE(this.regIX + by) & 0xF) == 15 ? 16 : 0) | (this.READ_BYTE(this.regIX + by) == 0 ? 64 : this.READ_BYTE(this.regIX + by) & 0xA8);
                this.cycleCount -= 19;
                break;
            }
            case 54: {
                this.WRITE_BYTE(this.regIX + (byte)this.READ_BYTE(), this.READ_BYTE());
                this.cycleCount -= 15;
                break;
            }
            case 57: {
                this.ADD_WORD_IX(this.regSP);
                this.cycleCount -= 11;
                break;
            }
            case 68: {
                this.regBC = this.regIX & 0xFF00 | this.regBC & 0xFF;
                this.cycleCount -= 4;
                break;
            }
            case 69: {
                this.regBC = (this.regIX & 0xFF) << 8 | this.regBC & 0xFF;
                this.cycleCount -= 4;
                break;
            }
            case 70: {
                this.regBC = this.READ_BYTE(this.regIX + (byte)this.READ_BYTE()) << 8 | this.regBC & 0xFF;
                this.cycleCount -= 15;
                break;
            }
            case 76: {
                this.regBC = this.regBC & 0xFF00 | this.regIX >> 8;
                this.cycleCount -= 4;
                break;
            }
            case 77: {
                this.regBC = this.regBC & 0xFF00 | this.regIX & 0xFF;
                this.cycleCount -= 4;
                break;
            }
            case 78: {
                this.regBC = this.regBC & 0xFF00 | this.READ_BYTE(this.regIX + (byte)this.READ_BYTE());
                this.cycleCount -= 15;
                break;
            }
            case 84: {
                this.regDE = this.regIX & 0xFF00 | this.regDE & 0xFF;
                this.cycleCount -= 4;
                break;
            }
            case 85: {
                this.regDE = (this.regIX & 0xFF) << 8 | this.regDE & 0xFF;
                this.cycleCount -= 4;
                break;
            }
            case 86: {
                this.regDE = this.READ_BYTE(this.regIX + (byte)this.READ_BYTE()) << 8 | this.regDE & 0xFF;
                this.cycleCount -= 15;
                break;
            }
            case 92: {
                this.regDE = this.regDE & 0xFF00 | this.regIX >> 8;
                this.cycleCount -= 4;
                break;
            }
            case 93: {
                this.regDE = this.regDE & 0xFF00 | this.regIX & 0xFF;
                this.cycleCount -= 4;
                break;
            }
            case 94: {
                this.regDE = this.regDE & 0xFF00 | this.READ_BYTE(this.regIX + (byte)this.READ_BYTE());
                this.cycleCount -= 15;
                break;
            }
            case 96: {
                this.regIX = this.regBC & 0xFF00 | this.regIX & 0xFF;
                this.cycleCount -= 4;
                break;
            }
            case 97: {
                this.regIX = (this.regBC & 0xFF) << 8 | this.regIX & 0xFF;
                this.cycleCount -= 4;
                break;
            }
            case 98: {
                this.regIX = this.regDE & 0xFF00 | this.regIX & 0xFF;
                this.cycleCount -= 4;
                break;
            }
            case 99: {
                this.regIX = (this.regDE & 0xFF) << 8 | this.regIX & 0xFF;
                this.cycleCount -= 4;
                break;
            }
            case 100: {
                this.cycleCount -= 4;
                break;
            }
            case 101: {
                this.regIX = (this.regIX & 0xFF) << 8 | this.regIX & 0xFF;
                this.cycleCount -= 4;
                break;
            }
            case 102: {
                this.regHL = this.READ_BYTE(this.regIX + (byte)this.READ_BYTE()) << 8 | this.regHL & 0xFF;
                this.cycleCount -= 15;
                break;
            }
            case 103: {
                this.regIX = this.regAF & 0xFF00 | this.regIX & 0xFF;
                this.cycleCount -= 4;
                break;
            }
            case 104: {
                this.regIX = this.regIX & 0xFF00 | this.regBC >> 8;
                this.cycleCount -= 4;
                break;
            }
            case 105: {
                this.regIX = this.regIX & 0xFF00 | this.regBC & 0xFF;
                this.cycleCount -= 4;
                break;
            }
            case 106: {
                this.regIX = this.regIX & 0xFF00 | this.regDE >> 8;
                this.cycleCount -= 4;
                break;
            }
            case 107: {
                this.regIX = this.regIX & 0xFF00 | this.regDE & 0xFF;
                this.cycleCount -= 4;
                break;
            }
            case 108: {
                this.regIX = this.regIX & 0xFF00 | this.regIX >> 8;
                this.cycleCount -= 4;
                break;
            }
            case 109: {
                this.cycleCount -= 4;
                break;
            }
            case 110: {
                this.regHL = this.regHL & 0xFF00 | this.READ_BYTE(this.regIX + (byte)this.READ_BYTE());
                this.cycleCount -= 15;
                break;
            }
            case 111: {
                this.regIX = this.regIX & 0xFF00 | this.regAF >> 8;
                this.cycleCount -= 4;
                break;
            }
            case 112: {
                this.WRITE_BYTE(this.regIX + (byte)this.READ_BYTE(), this.regBC >> 8);
                this.cycleCount -= 15;
                break;
            }
            case 113: {
                this.WRITE_BYTE(this.regIX + (byte)this.READ_BYTE(), this.regBC & 0xFF);
                this.cycleCount -= 15;
                break;
            }
            case 114: {
                this.WRITE_BYTE(this.regIX + (byte)this.READ_BYTE(), this.regDE >> 8);
                this.cycleCount -= 15;
                break;
            }
            case 115: {
                this.WRITE_BYTE(this.regIX + (byte)this.READ_BYTE(), this.regDE & 0xFF);
                this.cycleCount -= 15;
                break;
            }
            case 116: {
                this.WRITE_BYTE(this.regIX + (byte)this.READ_BYTE(), this.regHL >> 8);
                this.cycleCount -= 15;
                break;
            }
            case 117: {
                this.WRITE_BYTE(this.regIX + (byte)this.READ_BYTE(), this.regHL & 0xFF);
                this.cycleCount -= 15;
                break;
            }
            case 119: {
                this.WRITE_BYTE(this.regIX + (byte)this.READ_BYTE(), this.regAF >> 8);
                this.cycleCount -= 15;
                break;
            }
            case 124: {
                this.regAF = this.regIX & 0xFF00 | this.regAF & 0xFF;
                this.cycleCount -= 4;
                break;
            }
            case 125: {
                this.regAF = (this.regIX & 0xFF) << 8 | this.regAF & 0xFF;
                this.cycleCount -= 4;
                break;
            }
            case 126: {
                this.regAF = this.READ_BYTE(this.regIX + (byte)this.READ_BYTE()) << 8 | this.regAF & 0xFF;
                this.cycleCount -= 15;
                break;
            }
            case 132: {
                this.ADD_HIBYTE(this.regIX);
                this.cycleCount -= 4;
                break;
            }
            case 133: {
                this.ADD_LOBYTE(this.regIX);
                this.cycleCount -= 4;
                break;
            }
            case 134: {
                this.ADD_LOBYTE(this.READ_BYTE(this.regIX + (byte)this.READ_BYTE()));
                this.cycleCount -= 15;
                break;
            }
            case 140: {
                this.ADC_HIBYTE(this.regIX);
                this.cycleCount -= 4;
                break;
            }
            case 141: {
                this.ADC_LOBYTE(this.regIX);
                this.cycleCount -= 4;
                break;
            }
            case 142: {
                this.ADC_LOBYTE(this.READ_BYTE(this.regIX + (byte)this.READ_BYTE()));
                this.cycleCount -= 15;
                break;
            }
            case 148: {
                this.SUB_HIBYTE(this.regIX);
                this.cycleCount -= 4;
                break;
            }
            case 149: {
                this.SUB_LOBYTE(this.regIX);
                this.cycleCount -= 4;
                break;
            }
            case 150: {
                this.SUB_LOBYTE(this.READ_BYTE(this.regIX + (byte)this.READ_BYTE()));
                this.cycleCount -= 15;
                break;
            }
            case 156: {
                this.SBC_HIBYTE(this.regIX);
                this.cycleCount -= 4;
                break;
            }
            case 157: {
                this.SBC_LOBYTE(this.regIX);
                this.cycleCount -= 4;
                break;
            }
            case 158: {
                this.SBC_LOBYTE(this.READ_BYTE(this.regIX + (byte)this.READ_BYTE()));
                this.cycleCount -= 15;
                break;
            }
            case 164: {
                this.AND_HIBYTE(this.regIX);
                this.cycleCount -= 4;
                break;
            }
            case 165: {
                this.AND_LOBYTE(this.regIX);
                this.cycleCount -= 4;
                break;
            }
            case 166: {
                this.AND_LOBYTE(this.READ_BYTE(this.regIX + (byte)this.READ_BYTE()));
                this.cycleCount -= 15;
                break;
            }
            case 172: {
                this.XOR_HIBYTE(this.regIX);
                this.cycleCount -= 4;
                break;
            }
            case 173: {
                this.XOR_LOBYTE(this.regIX);
                this.cycleCount -= 4;
                break;
            }
            case 174: {
                this.XOR_LOBYTE(this.READ_BYTE(this.regIX + (byte)this.READ_BYTE()));
                this.cycleCount -= 15;
                break;
            }
            case 180: {
                this.OR_HIBYTE(this.regIX);
                this.cycleCount -= 4;
                break;
            }
            case 181: {
                this.OR_LOBYTE(this.regIX);
                this.cycleCount -= 4;
                break;
            }
            case 182: {
                this.OR_LOBYTE(this.READ_BYTE(this.regIX + (byte)this.READ_BYTE()));
                this.cycleCount -= 15;
                break;
            }
            case 188: {
                this.CP_HIBYTE(this.regIX);
                this.cycleCount -= 4;
                break;
            }
            case 189: {
                this.CP_LOBYTE(this.regIX);
                this.cycleCount -= 4;
                break;
            }
            case 190: {
                this.CP_LOBYTE(this.READ_BYTE(this.regIX + (byte)this.READ_BYTE()));
                this.cycleCount -= 15;
                break;
            }
            case 203: {
                this.executeInstructionDDCBorFDCB(this.regIX, (byte)this.READ_BYTE(), this.READ_BYTE());
                break;
            }
            case 225: {
                this.regIX = this.POP();
                this.cycleCount -= 10;
                break;
            }
            case 227: {
                int n2 = this.READ_WORD(this.regSP);
                this.WRITE_WORD(this.regSP, this.regIX);
                this.regIX = n2;
                break;
            }
            case 229: {
                this.PUSH(this.regIX);
                this.cycleCount -= 11;
                break;
            }
            case 233: {
                this.regPC = this.regIX;
                this.cycleCount -= 4;
                break;
            }
            case 249: {
                this.regSP = this.regIX;
                this.cycleCount -= 6;
                break;
            }
            default: {
                --this.regPC;
            }
        }
    }

    private void executeInstructionDDCBorFDCB(int n, byte by, int n2) {
        this.cycleCount -= (n2 & 0xC0) == 64 ? 16 : 19;
        switch (n2) {
            case 6: {
                this.WRITE_BYTE(n + by, this.RLC_LOBYTE(this.READ_BYTE(n + by)));
                break;
            }
            case 14: {
                this.WRITE_BYTE(n + by, this.RRC_LOBYTE(this.READ_BYTE(n + by)));
                break;
            }
            case 22: {
                this.WRITE_BYTE(n + by, this.RL_LOBYTE(this.READ_BYTE(n + by)));
                break;
            }
            case 30: {
                this.WRITE_BYTE(n + by, this.RR_LOBYTE(this.READ_BYTE(n + by)));
                break;
            }
            case 38: {
                this.WRITE_BYTE(n + by, this.SLA_LOBYTE(this.READ_BYTE(n + by)));
                break;
            }
            case 46: {
                this.WRITE_BYTE(n + by, this.SRA_LOBYTE(this.READ_BYTE(n + by)));
                break;
            }
            case 54: {
                this.WRITE_BYTE(n + by, this.SLL_LOBYTE(this.READ_BYTE(n + by)));
                break;
            }
            case 62: {
                this.WRITE_BYTE(n + by, this.SRL_LOBYTE(this.READ_BYTE(n + by)));
                break;
            }
            case 70: {
                this.BIT(0, this.READ_BYTE(n + by));
                break;
            }
            case 78: {
                this.BIT(1, this.READ_BYTE(n + by));
                break;
            }
            case 86: {
                this.BIT(2, this.READ_BYTE(n + by));
                break;
            }
            case 94: {
                this.BIT(3, this.READ_BYTE(n + by));
                break;
            }
            case 102: {
                this.BIT(4, this.READ_BYTE(n + by));
                break;
            }
            case 110: {
                this.BIT(5, this.READ_BYTE(n + by));
                break;
            }
            case 118: {
                this.BIT(6, this.READ_BYTE(n + by));
                break;
            }
            case 126: {
                this.BIT(7, this.READ_BYTE(n + by));
                break;
            }
            case 134: {
                this.WRITE_BYTE(n + by, this.READ_BYTE(n + by) & 0xFE);
                break;
            }
            case 142: {
                this.WRITE_BYTE(n + by, this.READ_BYTE(n + by) & 0xFD);
                break;
            }
            case 150: {
                this.WRITE_BYTE(n + by, this.READ_BYTE(n + by) & 0xFB);
                break;
            }
            case 158: {
                this.WRITE_BYTE(n + by, this.READ_BYTE(n + by) & 0xF7);
                break;
            }
            case 166: {
                this.WRITE_BYTE(n + by, this.READ_BYTE(n + by) & 0xEF);
                break;
            }
            case 174: {
                this.WRITE_BYTE(n + by, this.READ_BYTE(n + by) & 0xDF);
                break;
            }
            case 182: {
                this.WRITE_BYTE(n + by, this.READ_BYTE(n + by) & 0xBF);
                break;
            }
            case 190: {
                this.WRITE_BYTE(n + by, this.READ_BYTE(n + by) & 0x7F);
                break;
            }
            case 198: {
                this.WRITE_BYTE(n + by, this.READ_BYTE(n + by) | 1);
                break;
            }
            case 206: {
                this.WRITE_BYTE(n + by, this.READ_BYTE(n + by) | 2);
                break;
            }
            case 214: {
                this.WRITE_BYTE(n + by, this.READ_BYTE(n + by) | 4);
                break;
            }
            case 222: {
                this.WRITE_BYTE(n + by, this.READ_BYTE(n + by) | 8);
                break;
            }
            case 230: {
                this.WRITE_BYTE(n + by, this.READ_BYTE(n + by) | 0x10);
                break;
            }
            case 238: {
                this.WRITE_BYTE(n + by, this.READ_BYTE(n + by) | 0x20);
                break;
            }
            case 246: {
                this.WRITE_BYTE(n + by, this.READ_BYTE(n + by) | 0x40);
                break;
            }
            case 254: {
                this.WRITE_BYTE(n + by, this.READ_BYTE(n + by) | 0x80);
                break;
            }
            default: {
                this.cycleCount = 0;
                System.out.println("Instruktion noch nicht implementiert.");
            }
        }
    }

    private void executeInstructionFD(int n) {
        switch (n) {
            case 9: {
                this.ADD_WORD_IY(this.regBC);
                this.cycleCount -= 11;
                break;
            }
            case 25: {
                this.ADD_WORD_IY(this.regDE);
                this.cycleCount -= 11;
                break;
            }
            case 33: {
                this.regIY = this.READ_WORD();
                this.cycleCount -= 10;
                break;
            }
            case 34: {
                this.WRITE_WORD(this.READ_WORD(), this.regIY);
                this.cycleCount -= 16;
                break;
            }
            case 35: {
                this.regIY = Z80.INC_WORD(this.regIY);
                this.cycleCount -= 6;
                break;
            }
            case 36: {
                this.regIY = this.INC_HIBYTE(this.regIY);
                this.cycleCount -= 4;
                break;
            }
            case 37: {
                this.regIY = this.DEC_HIBYTE(this.regIY);
                this.cycleCount -= 4;
                break;
            }
            case 38: {
                this.regIY = this.READ_BYTE() << 8 | this.regIY & 0xFF;
                this.cycleCount -= 7;
                break;
            }
            case 41: {
                this.ADD_WORD_IY(this.regIY);
                this.cycleCount -= 11;
                break;
            }
            case 42: {
                this.regIY = this.READ_WORD(this.READ_WORD());
                this.cycleCount -= 16;
                break;
            }
            case 43: {
                this.regIY = Z80.DEC_WORD(this.regIY);
                this.cycleCount -= 6;
                break;
            }
            case 44: {
                this.regIY = this.INC_LOBYTE(this.regIY);
                this.cycleCount -= 4;
                break;
            }
            case 45: {
                this.regIY = this.DEC_LOBYTE(this.regIY);
                this.cycleCount -= 4;
                break;
            }
            case 46: {
                this.regIY = this.regIY & 0xFF00 | this.READ_BYTE();
                this.cycleCount -= 7;
                break;
            }
            case 52: {
                byte by = (byte)this.READ_BYTE();
                this.WRITE_BYTE(this.regIY + by, this.READ_BYTE(this.regIY + by) + 1 & 0xFF);
                this.regAF = this.regAF & 0xFF00 | this.regAF & 1 | (this.READ_BYTE(this.regIY + by) == 128 ? 4 : 0) | ((this.READ_BYTE(this.regIY + by) & 0xF) == 0 ? 16 : 0) | (this.READ_BYTE(this.regIY + by) == 0 ? 64 : this.READ_BYTE(this.regIY + by) & 0xA8);
                this.cycleCount -= 19;
                break;
            }
            case 53: {
                byte by = (byte)this.READ_BYTE();
                this.WRITE_BYTE(this.regIY + by, this.READ_BYTE(this.regIY + by) - 1 & 0xFF);
                this.regAF = this.regAF & 0xFF00 | this.regAF & 1 | 2 | (this.READ_BYTE(this.regIY + by) == 127 ? 4 : 0) | ((this.READ_BYTE(this.regIY + by) & 0xF) == 15 ? 16 : 0) | (this.READ_BYTE(this.regIY + by) == 0 ? 64 : this.READ_BYTE(this.regIY + by) & 0xA8);
                this.cycleCount -= 19;
                break;
            }
            case 54: {
                this.WRITE_BYTE(this.regIY + (byte)this.READ_BYTE(), this.READ_BYTE());
                this.cycleCount -= 15;
                break;
            }
            case 57: {
                this.ADD_WORD_IY(this.regSP);
                this.cycleCount -= 11;
                break;
            }
            case 68: {
                this.regBC = this.regIY & 0xFF00 | this.regBC & 0xFF;
                this.cycleCount -= 4;
                break;
            }
            case 69: {
                this.regBC = (this.regIY & 0xFF) << 8 | this.regBC & 0xFF;
                this.cycleCount -= 4;
                break;
            }
            case 70: {
                this.regBC = this.READ_BYTE(this.regIY + (byte)this.READ_BYTE()) << 8 | this.regBC & 0xFF;
                this.cycleCount -= 15;
                break;
            }
            case 76: {
                this.regBC = this.regBC & 0xFF00 | this.regIY >> 8;
                this.cycleCount -= 4;
                break;
            }
            case 77: {
                this.regBC = this.regBC & 0xFF00 | this.regIY & 0xFF;
                this.cycleCount -= 4;
                break;
            }
            case 78: {
                this.regBC = this.regBC & 0xFF00 | this.READ_BYTE(this.regIY + (byte)this.READ_BYTE());
                this.cycleCount -= 15;
                break;
            }
            case 84: {
                this.regDE = this.regIY & 0xFF00 | this.regDE & 0xFF;
                this.cycleCount -= 4;
                break;
            }
            case 85: {
                this.regDE = (this.regIY & 0xFF) << 8 | this.regDE & 0xFF;
                this.cycleCount -= 4;
                break;
            }
            case 86: {
                this.regDE = this.READ_BYTE(this.regIY + (byte)this.READ_BYTE()) << 8 | this.regDE & 0xFF;
                this.cycleCount -= 15;
                break;
            }
            case 92: {
                this.regDE = this.regDE & 0xFF00 | this.regIY >> 8;
                this.cycleCount -= 4;
                break;
            }
            case 93: {
                this.regDE = this.regDE & 0xFF00 | this.regIY & 0xFF;
                this.cycleCount -= 4;
                break;
            }
            case 94: {
                this.regDE = this.regDE & 0xFF00 | this.READ_BYTE(this.regIY + (byte)this.READ_BYTE());
                this.cycleCount -= 15;
                break;
            }
            case 96: {
                this.regIY = this.regBC & 0xFF00 | this.regIY & 0xFF;
                this.cycleCount -= 4;
                break;
            }
            case 97: {
                this.regIY = (this.regBC & 0xFF) << 8 | this.regIY & 0xFF;
                this.cycleCount -= 4;
                break;
            }
            case 98: {
                this.regIY = this.regDE & 0xFF00 | this.regIY & 0xFF;
                this.cycleCount -= 4;
                break;
            }
            case 99: {
                this.regIY = (this.regDE & 0xFF) << 8 | this.regIY & 0xFF;
                this.cycleCount -= 4;
                break;
            }
            case 100: {
                this.cycleCount -= 4;
                break;
            }
            case 101: {
                this.regIY = (this.regIY & 0xFF) << 8 | this.regIY & 0xFF;
                this.cycleCount -= 4;
                break;
            }
            case 102: {
                this.regHL = this.READ_BYTE(this.regIY + (byte)this.READ_BYTE()) << 8 | this.regHL & 0xFF;
                this.cycleCount -= 15;
                break;
            }
            case 103: {
                this.regIY = this.regAF & 0xFF00 | this.regIY & 0xFF;
                this.cycleCount -= 4;
                break;
            }
            case 104: {
                this.regIY = this.regIY & 0xFF00 | this.regBC >> 8;
                this.cycleCount -= 4;
                break;
            }
            case 105: {
                this.regIY = this.regIY & 0xFF00 | this.regBC & 0xFF;
                this.cycleCount -= 4;
                break;
            }
            case 106: {
                this.regIY = this.regIY & 0xFF00 | this.regDE >> 8;
                this.cycleCount -= 4;
                break;
            }
            case 107: {
                this.regIY = this.regIY & 0xFF00 | this.regDE & 0xFF;
                this.cycleCount -= 4;
                break;
            }
            case 108: {
                this.regIY = this.regIY & 0xFF00 | this.regIY >> 8;
                this.cycleCount -= 4;
                break;
            }
            case 109: {
                this.cycleCount -= 4;
                break;
            }
            case 110: {
                this.regHL = this.regHL & 0xFF00 | this.READ_BYTE(this.regIY + (byte)this.READ_BYTE());
                this.cycleCount -= 15;
                break;
            }
            case 111: {
                this.regIY = this.regIY & 0xFF00 | this.regAF >> 8;
                this.cycleCount -= 4;
                break;
            }
            case 112: {
                this.WRITE_BYTE(this.regIY + (byte)this.READ_BYTE(), this.regBC >> 8);
                this.cycleCount -= 15;
                break;
            }
            case 113: {
                this.WRITE_BYTE(this.regIY + (byte)this.READ_BYTE(), this.regBC & 0xFF);
                this.cycleCount -= 15;
                break;
            }
            case 114: {
                this.WRITE_BYTE(this.regIY + (byte)this.READ_BYTE(), this.regDE >> 8);
                this.cycleCount -= 15;
                break;
            }
            case 115: {
                this.WRITE_BYTE(this.regIY + (byte)this.READ_BYTE(), this.regDE & 0xFF);
                this.cycleCount -= 15;
                break;
            }
            case 116: {
                this.WRITE_BYTE(this.regIY + (byte)this.READ_BYTE(), this.regHL >> 8);
                this.cycleCount -= 15;
                break;
            }
            case 117: {
                this.WRITE_BYTE(this.regIY + (byte)this.READ_BYTE(), this.regHL & 0xFF);
                this.cycleCount -= 15;
                break;
            }
            case 119: {
                this.WRITE_BYTE(this.regIY + (byte)this.READ_BYTE(), this.regAF >> 8);
                this.cycleCount -= 15;
                break;
            }
            case 124: {
                this.regAF = this.regIY & 0xFF00 | this.regAF & 0xFF;
                this.cycleCount -= 4;
                break;
            }
            case 125: {
                this.regAF = (this.regIY & 0xFF) << 8 | this.regAF & 0xFF;
                this.cycleCount -= 4;
                break;
            }
            case 126: {
                this.regAF = this.READ_BYTE(this.regIY + (byte)this.READ_BYTE()) << 8 | this.regAF & 0xFF;
                this.cycleCount -= 15;
                break;
            }
            case 132: {
                this.ADD_HIBYTE(this.regIY);
                this.cycleCount -= 4;
                break;
            }
            case 133: {
                this.ADD_LOBYTE(this.regIY);
                this.cycleCount -= 4;
                break;
            }
            case 134: {
                this.ADD_LOBYTE(this.READ_BYTE(this.regIY + (byte)this.READ_BYTE()));
                this.cycleCount -= 15;
                break;
            }
            case 140: {
                this.ADC_HIBYTE(this.regIY);
                this.cycleCount -= 4;
                break;
            }
            case 141: {
                this.ADC_LOBYTE(this.regIY);
                this.cycleCount -= 4;
                break;
            }
            case 142: {
                this.ADC_LOBYTE(this.READ_BYTE(this.regIY + (byte)this.READ_BYTE()));
                this.cycleCount -= 15;
                break;
            }
            case 148: {
                this.SUB_HIBYTE(this.regIY);
                this.cycleCount -= 4;
                break;
            }
            case 149: {
                this.SUB_LOBYTE(this.regIY);
                this.cycleCount -= 4;
                break;
            }
            case 150: {
                this.SUB_LOBYTE(this.READ_BYTE(this.regIY + (byte)this.READ_BYTE()));
                this.cycleCount -= 15;
                break;
            }
            case 156: {
                this.SBC_HIBYTE(this.regIY);
                this.cycleCount -= 4;
                break;
            }
            case 157: {
                this.SBC_LOBYTE(this.regIY);
                this.cycleCount -= 4;
                break;
            }
            case 158: {
                this.SBC_LOBYTE(this.READ_BYTE(this.regIY + (byte)this.READ_BYTE()));
                this.cycleCount -= 15;
                break;
            }
            case 164: {
                this.AND_HIBYTE(this.regIY);
                this.cycleCount -= 4;
                break;
            }
            case 165: {
                this.AND_LOBYTE(this.regIY);
                this.cycleCount -= 4;
                break;
            }
            case 166: {
                this.AND_LOBYTE(this.READ_BYTE(this.regIY + (byte)this.READ_BYTE()));
                this.cycleCount -= 15;
                break;
            }
            case 172: {
                this.XOR_HIBYTE(this.regIY);
                this.cycleCount -= 4;
                break;
            }
            case 173: {
                this.XOR_LOBYTE(this.regIY);
                this.cycleCount -= 4;
                break;
            }
            case 174: {
                this.XOR_LOBYTE(this.READ_BYTE(this.regIY + (byte)this.READ_BYTE()));
                this.cycleCount -= 15;
                break;
            }
            case 180: {
                this.OR_HIBYTE(this.regIY);
                this.cycleCount -= 4;
                break;
            }
            case 181: {
                this.OR_LOBYTE(this.regIY);
                this.cycleCount -= 4;
                break;
            }
            case 182: {
                this.OR_LOBYTE(this.READ_BYTE(this.regIY + (byte)this.READ_BYTE()));
                this.cycleCount -= 15;
                break;
            }
            case 188: {
                this.CP_HIBYTE(this.regIY);
                this.cycleCount -= 4;
                break;
            }
            case 189: {
                this.CP_LOBYTE(this.regIY);
                this.cycleCount -= 4;
                break;
            }
            case 190: {
                this.CP_LOBYTE(this.READ_BYTE(this.regIY + (byte)this.READ_BYTE()));
                this.cycleCount -= 15;
                break;
            }
            case 203: {
                this.executeInstructionDDCBorFDCB(this.regIY, (byte)this.READ_BYTE(), this.READ_BYTE());
                break;
            }
            case 225: {
                this.regIY = this.POP();
                this.cycleCount -= 10;
                break;
            }
            case 227: {
                int n2 = this.READ_WORD(this.regSP);
                this.WRITE_WORD(this.regSP, this.regIY);
                this.regIY = n2;
                break;
            }
            case 229: {
                this.PUSH(this.regIY);
                this.cycleCount -= 11;
                break;
            }
            case 233: {
                this.regPC = this.regIY;
                this.cycleCount -= 4;
                break;
            }
            case 249: {
                this.regSP = this.regIY;
                this.cycleCount -= 6;
                break;
            }
            default: {
                --this.regPC;
            }
        }
    }

    protected void setInterruptsEnabled(boolean bl) {
        this.interruptFlipFlop2 = this.interruptFlipFlop1 = bl;
    }

    @Override
    public void setInterruptLine(int n, boolean bl) {
        switch (n) {
            case 1: {
                this.pinINT = bl;
                break;
            }
            case 2: {
                if (!this.pinNMI && bl) {
                    this.nmiPending = true;
                }
                this.pinNMI = bl;
            }
        }
    }

    @Override
    protected void handleInterrupts() {
        if (!this.afterEI && this.pinINT && this.interruptFlipFlop1 || this.nmiPending) {
            this.interruptFlipFlop1 = false;
            if (this.nmiPending) {
                this.nmiPending = false;
                this.cycleCount -= this.cycles[255];
                this.RST(102);
            } else if (this.pinINT) {
                this.interruptFlipFlop2 = false;
                if (this.interruptMode == 1) {
                    this.cycleCount -= this.cycles[255] + 2;
                    this.RST(56);
                }
            }
        }
    }

    protected String flagsToString(int n) {
        String string = "";
        if ((n & 1) != 0) {
            string = String.valueOf(string) + "C ";
        }
        if ((n & 2) != 0) {
            string = String.valueOf(string) + "N ";
        }
        if ((n & 4) != 0) {
            string = String.valueOf(string) + "PV ";
        }
        if ((n & 8) != 0) {
            string = String.valueOf(string) + "3 ";
        }
        if ((n & 0x10) != 0) {
            string = String.valueOf(string) + "H ";
        }
        if ((n & 0x20) != 0) {
            string = String.valueOf(string) + "5 ";
        }
        if ((n & 0x40) != 0) {
            string = String.valueOf(string) + "Z ";
        }
        if ((n & 0x80) != 0) {
            string = String.valueOf(string) + "S";
        }
        return string;
    }

    private final void DAA() {
        int n = this.regAF >> 8;
        if ((this.regAF & 2) != 0) {
            if ((this.regAF & 0x10) != 0 || (n & 0xF) > 9) {
                this.regAF = this.regAF - 1536 & 0xFFFF;
            }
            if ((this.regAF & 1) != 0 || n > 153) {
                this.regAF = this.regAF - 24576 & 0xFFFF | 1;
            }
        } else {
            if ((this.regAF & 0x10) != 0 || (n & 0xF) > 9) {
                this.regAF = this.regAF + 1536 & 0xFFFF;
            }
            if ((this.regAF & 1) != 0 || n > 153) {
                this.regAF = this.regAF + 24576 & 0xFFFF | 1;
            }
        }
        this.regAF = this.regAF & 0xFF03 | PARITY_FLAG[this.regAF >> 8] | (this.regAF >> 8 ^ n) & 0x10 | (this.regAF >> 8 == 0 ? 64 : this.regAF >> 8 & 0xA8);
    }

    private final void ADD_LOBYTE(int n) {
        int n2;
        this.regAF = n2 << 8 | ((n2 = (this.regAF >> 8) + n & 0xFF) < this.regAF >> 8 ? 1 : 0) | (((n & 0xFF ^ this.regAF >> 8 ^ 0x80) & (this.regAF >> 8 ^ n2) & 0x80) != 0 ? 4 : 0) | ((n2 & 0xF) < (this.regAF & 0xF00) >> 8 ? 16 : 0) | (n2 == 0 ? 64 : n2 & 0xA8);
    }

    private final void ADD_HIBYTE(int n) {
        this.ADD_LOBYTE(n >> 8);
    }

    private final void ADD_WORD_HL(int n) {
        this.regAF = this.regAF & 0xFFC4 | (this.regHL ^ this.regHL + n ^ n) >> 8 & 0x10 | this.regHL + n >> 16;
        this.regHL = this.regHL + n & 0xFFFF;
    }

    private final void ADD_WORD_IX(int n) {
        this.regAF = this.regAF & 0xFFC4 | (this.regIX ^ this.regIX + n ^ n) >> 8 & 0x10 | this.regIX + n >> 16;
        this.regIX = this.regIX + n & 0xFFFF;
    }

    private final void ADD_WORD_IY(int n) {
        this.regAF = this.regAF & 0xFFC4 | (this.regIY ^ this.regIY + n ^ n) >> 8 & 0x10 | this.regIY + n >> 16;
        this.regIY = this.regIY + n & 0xFFFF;
    }

    private final void ADC_WORD(int n) {
        int n2;
        this.regAF = this.regAF & 0xFF00 | n2 >> 8 & 0x80 | (((n2 = this.regHL + n + (this.regAF & 1)) & 0xFFFF) == 0 ? 64 : 0) | (this.regHL ^ n2 ^ n) >> 8 & 0x10 | ((n ^ this.regHL ^ 0x8000) & (n ^ n2) & 0x8000) >> 13 | n2 >> 16 & 1;
        this.regHL = n2 & 0xFFFF;
    }

    private final void ADC_LOBYTE(int n) {
        if ((this.regAF & 1) != 0) {
            int n2 = (this.regAF >> 8) + n + 1 & 0xFF;
            this.regAF = (n2 <= this.regAF >> 8 ? 1 : 0) | (((n & 0xFF ^ this.regAF >> 8 ^ 0x80) & (this.regAF >> 8 ^ n2) & 0x80) != 0 ? 4 : 0) | ((n2 & 0xF) <= (this.regAF & 0xF00) >> 8 ? 16 : 0) | (n2 == 0 ? 64 : n2 & 0xA8) | n2 << 8;
        } else {
            this.ADD_LOBYTE(n);
        }
    }

    private final void ADC_HIBYTE(int n) {
        this.ADC_LOBYTE(n >> 8);
    }

    private final void SUB_LOBYTE(int n) {
        int n2 = (this.regAF >> 8) - n & 0xFF;
        this.regAF = (n2 > this.regAF >> 8 ? 3 : 2) | (((n & 0xFF ^ this.regAF >> 8) & (this.regAF >> 8 ^ n2) & 0x80) != 0 ? 4 : 0) | ((n2 & 0xF) > (this.regAF & 0xF00) >> 8 ? 16 : 0) | (n2 == 0 ? 64 : n2 & 0xA8) | n2 << 8;
    }

    private final void SUB_HIBYTE(int n) {
        this.SUB_LOBYTE(n >> 8);
    }

    private final void SBC_WORD(int n) {
        int n2;
        this.regAF = this.regAF & 0xFF00 | n2 >> 8 & 0x80 | (((n2 = this.regHL - n - (this.regAF & 1)) & 0xFFFF) == 0 ? 66 : 2) | (this.regHL ^ n2 ^ n) >> 8 & 0x10 | ((n ^ this.regHL) & (this.regHL ^ n2) & 0x8000) >> 13 | n2 >> 16 & 1;
        this.regHL = n2 & 0xFFFF;
    }

    private final void SBC_LOBYTE(int n) {
        if ((this.regAF & 1) != 0) {
            int n2 = (this.regAF >> 8) - n - 1 & 0xFF;
            this.regAF = (n2 >= this.regAF >> 8 ? 3 : 2) | (((n & 0xFF ^ this.regAF >> 8) & (this.regAF >> 8 ^ n2) & 0x80) != 0 ? 4 : 0) | ((n2 & 0xF) >= (this.regAF & 0xF00) >> 8 ? 16 : 0) | (n2 == 0 ? 64 : n2 & 0xA8) | n2 << 8;
        } else {
            this.SUB_LOBYTE(n);
        }
    }

    private final void SBC_HIBYTE(int n) {
        this.SBC_LOBYTE(n >> 8);
    }

    private final void AND_LOBYTE(int n) {
        this.AND_HIBYTE(n << 8);
    }

    private final void AND_HIBYTE(int n) {
        this.regAF = this.regAF & n & 0xFF00;
        this.regAF |= (this.regAF == 0 ? 68 : this.regAF >> 8 & 0xA8 | PARITY_FLAG[this.regAF >> 8]) | 0x10;
    }

    private final void XOR_LOBYTE(int n) {
        this.XOR_HIBYTE(n << 8);
    }

    private final void XOR_HIBYTE(int n) {
        this.regAF = (this.regAF ^ n) & 0xFF00;
        this.regAF |= this.regAF == 0 ? 68 : this.regAF >> 8 & 0xA8 | PARITY_FLAG[this.regAF >> 8];
    }

    private final void OR_LOBYTE(int n) {
        this.OR_HIBYTE(n << 8);
    }

    private final void OR_HIBYTE(int n) {
        this.regAF = (this.regAF | n) & 0xFF00;
        this.regAF |= this.regAF == 0 ? 68 : this.regAF >> 8 & 0xA8 | PARITY_FLAG[this.regAF >> 8];
    }

    private final void CPI() {
        int n = (this.regAF >> 8) - this.READ_BYTE(this.regHL) & 0xFF;
        this.regHL = Z80.INC_WORD(this.regHL);
        this.regBC = Z80.DEC_WORD(this.regBC);
        this.regAF = this.regAF & 0xFF01 | (n == 0 ? 64 : n & 0x80) | ((n & 0xF) > (this.regAF & 0xF00) >> 8 ? 16 : 0) | (this.regBC > 0 ? 6 : 2);
    }

    private final void CPD() {
        int n = (this.regAF >> 8) - this.READ_BYTE(this.regHL) & 0xFF;
        this.regHL = Z80.DEC_WORD(this.regHL);
        this.regBC = Z80.DEC_WORD(this.regBC);
        this.regAF = this.regAF & 0xFF01 | (n == 0 ? 64 : n & 0x80) | ((n & 0xF) > (this.regAF & 0xF00) >> 8 ? 16 : 0) | (this.regBC > 0 ? 6 : 2);
    }

    private final void CP_LOBYTE(int n) {
        int n2 = (this.regAF >> 8) - n & 0xFF;
        this.regAF = this.regAF & 0xFF00 | (n2 > this.regAF >> 8 ? 3 : 2) | (((n & 0xFF ^ this.regAF >> 8) & (this.regAF >> 8 ^ n2) & 0x80) != 0 ? 4 : 0) | ((n2 & 0xF) > (this.regAF & 0xF00) >> 8 ? 16 : 0) | (n2 == 0 ? 64 : n2 & 0xA8);
    }

    private final void CP_HIBYTE(int n) {
        this.CP_LOBYTE(n >> 8);
    }

    private final int RLC_LOBYTE(int n) {
        this.regAF = this.regAF & 0xFF00 | n >> 7 & 1 | ((n & 0xFF) == 0 ? 68 : n << 1 & 0xA8 | PARITY_FLAG[n & 0xFF]);
        return n & 0xFF00 | (n & 0x7F) << 1 | (n & 0x80) >> 7;
    }

    private final int RLC_HIBYTE(int n) {
        this.regAF = this.regAF & 0xFF00 | n >> 15 | ((n & 0xFF00) == 0 ? 68 : n >> 7 & 0xA8 | PARITY_FLAG[n >> 8]);
        return (n & 0x7F00) << 1 | (n & 0x8000) >> 7 | n & 0xFF;
    }

    private final int RRC_LOBYTE(int n) {
        this.regAF = this.regAF & 0xFF00 | n & 1 | ((n & 0xFF) == 0 ? 68 : ((n & 1) << 7 | (n & 0xFE) >> 1) & 0xA8 | PARITY_FLAG[n & 0xFF]);
        return n & 0xFF00 | (n & 1) << 7 | (n & 0xFE) >> 1;
    }

    private final int RRC_HIBYTE(int n) {
        this.regAF = this.regAF & 0xFF00 | n >> 8 & 1 | ((n & 0xFF00) == 0 ? 68 : ((n & 0x100) >> 1 | (n & 0xFE00) >> 9) & 0xA8 | PARITY_FLAG[n >> 8]);
        return (n & 0x100) << 7 | (n & 0xFE00) >> 1 | n & 0xFF;
    }

    private final int RL_LOBYTE(int n) {
        if ((this.regAF & 1) != 0) {
            this.regAF = this.regAF & 0xFF00 | n >> 7 & 1 | n << 1 & 0xA8 | PARITY_FLAG[(n & 0x7F) << 1 | 1];
            return n & 0xFF00 | (n & 0x7F) << 1 | 1;
        }
        this.regAF = this.regAF & 0xFF00 | n >> 7 & 1 | ((n & 0x7F) == 0 ? 68 : n << 1 & 0xA8 | PARITY_FLAG[(n & 0x7F) << 1]);
        return n & 0xFF00 | (n & 0x7F) << 1;
    }

    private final int RL_HIBYTE(int n) {
        if ((this.regAF & 1) != 0) {
            this.regAF = this.regAF & 0xFF00 | n >> 15 | n >> 7 & 0xA8 | PARITY_FLAG[(n & 0x7F00) >> 7 | 1];
            return (n & 0x7F00) << 1 | 0x100 | n & 0xFF;
        }
        this.regAF = this.regAF & 0xFF00 | n >> 15 | ((n & 0x7F00) == 0 ? 68 : n >> 7 & 0xA8 | PARITY_FLAG[(n & 0x7F00) >> 7]);
        return (n & 0x7F00) << 1 | n & 0xFF;
    }

    private final int RR_LOBYTE(int n) {
        if ((this.regAF & 1) != 0) {
            this.regAF = this.regAF & 0xFF00 | n & 1 | n >> 1 & 0x28 | PARITY_FLAG[n & 0xFE | 1] | 0x80;
            return n & 0xFF00 | 0x80 | (n & 0xFF) >> 1;
        }
        this.regAF = this.regAF & 0xFF00 | n & 1 | ((n & 0xFE) == 0 ? 68 : n >> 1 & 0x28 | PARITY_FLAG[n & 0xFE]);
        return n & 0xFF00 | (n & 0xFE) >> 1;
    }

    private final int RR_HIBYTE(int n) {
        if ((this.regAF & 1) != 0) {
            this.regAF = this.regAF & 0xFF00 | n >> 8 & 1 | n >> 9 & 0x28 | PARITY_FLAG[0x80 | n >> 9] | 0x80;
            return 0x8000 | (n & 0xFE00) >> 1 | n & 0xFF;
        }
        this.regAF = this.regAF & 0xFF00 | n >> 8 & 1 | ((n & 0xFE00) == 0 ? 68 : n >> 9 & 0x28 | PARITY_FLAG[n >> 9]);
        return (n & 0xFE00) >> 1 | n & 0xFF;
    }

    private final int SLA_LOBYTE(int n) {
        this.regAF = this.regAF & 0xFF00 | n >> 7 & 1 | ((n & 0x7F) == 0 ? 68 : n << 1 & 0xA8 | PARITY_FLAG[n & 0x7F]);
        return n & 0xFF00 | (n & 0x7F) << 1;
    }

    private final int SLA_HIBYTE(int n) {
        this.regAF = this.regAF & 0xFF00 | n >> 15 | ((n & 0x7F00) == 0 ? 68 : n >> 7 & 0xA8 | PARITY_FLAG[(n & 0x7F00) >> 7]);
        return (n & 0x7F00) << 1 | n & 0xFF;
    }

    private final int SRA_LOBYTE(int n) {
        this.regAF = this.regAF & 0xFF00 | n & 1 | ((n & 0xFE) == 0 ? 68 : (n & 0x80 | (n & 0xFE) >> 1) & 0xA8 | PARITY_FLAG[n & 0x80 | (n & 0xFE) >> 1]);
        return n & 0xFF00 | n & 0x80 | (n & 0xFE) >> 1;
    }

    private final int SRA_HIBYTE(int n) {
        this.regAF = this.regAF & 0xFF00 | n >> 8 & 1 | ((n & 0xFE00) == 0 ? 68 : ((n & 0x8000) >> 8 | n >> 9) & 0xA8 | PARITY_FLAG[(n & 0x8000) >> 8 | n >> 9]);
        return n & 0x8000 | (n & 0xFE00) >> 1 | n & 0xFF;
    }

    private final int SLL_LOBYTE(int n) {
        this.regAF = this.regAF & 0xFF00 | n >> 7 & 1 | n << 1 & 0xA8 | PARITY_FLAG[n & 0x7F | 0x80];
        return n & 0xFF00 | (n & 0x7F) << 1 | 1;
    }

    private final int SLL_HIBYTE(int n) {
        this.regAF = this.regAF & 0xFF00 | n >> 15 | n >> 7 & 0xA8 | PARITY_FLAG[(n & 0x7F00) >> 7 | 1];
        return (n & 0x7F00) << 1 | 0x100 | n & 0xFF;
    }

    private final int SRL_LOBYTE(int n) {
        this.regAF = this.regAF & 0xFF00 | n & 1 | ((n & 0xFE) == 0 ? 68 : (n & 0xFE) >> 1 & 0xA8 | PARITY_FLAG[n & 0xFE]);
        return n & 0xFF00 | (n & 0xFE) >> 1;
    }

    private final int SRL_HIBYTE(int n) {
        this.regAF = this.regAF & 0xFF00 | n >> 8 & 1 | ((n & 0xFE00) == 0 ? 68 : n >> 9 & 0xA8 | PARITY_FLAG[n >> 9]);
        return (n & 0xFE00) >> 1 | n & 0xFF;
    }

    private final void BIT(int n, int n2) {
        this.regAF = this.regAF & 0xFF01 | 0x10 | ((n2 & 1 << n) == 0 ? 68 : n2 & 1 << n & 0x80);
    }

    private final int INC_LOBYTE(int n) {
        this.regAF = this.regAF & 0xFF01 | (((n = n & 0xFF00 | n + 1 & 0xFF) & 0xFF) == 0 ? 80 : ((n & 0xFF) == 128 ? 4 : 0) | n & 0xA8 | ((n & 0xF) == 0 ? 16 : 0));
        return n;
    }

    private final int INC_HIBYTE(int n) {
        this.regAF = this.regAF & 0xFF01 | (((n += 256) & 0xFF00) == 0 ? 80 : ((n & 0xFF00) == 32768 ? 4 : 0) | n >> 8 & 0xA8 | ((n & 0xF00) == 0 ? 16 : 0));
        return n & 0xFFFF;
    }

    private static final int INC_WORD(int n) {
        return n + 1 & 0xFFFF;
    }

    private final int DEC_LOBYTE(int n) {
        this.regAF = this.regAF & 0xFF01 | 2 | (((n = n & 0xFF00 | n - 1 & 0xFF) & 0xFF) == 0 ? 64 : ((n & 0xFF) == 127 ? 4 : 0) | n & 0xA8 | ((n & 0xF) == 15 ? 16 : 0));
        return n;
    }

    private final int DEC_HIBYTE(int n) {
        this.regAF = this.regAF & 0xFF01 | 2 | (((n -= 256) & 0xFF00) == 0 ? 64 : ((n & 0xFF00) == 32512 ? 4 : 0) | n >> 8 & 0xA8 | ((n & 0xF00) == 3840 ? 16 : 0));
        return n & 0xFFFF;
    }

    private static final int DEC_WORD(int n) {
        return n - 1 & 0xFFFF;
    }

    private final void NEG() {
        int n = this.regAF;
        this.regAF = 0;
        this.SUB_HIBYTE(n);
    }

    private final void RRD() {
        int n = this.READ_BYTE(this.regHL);
        this.WRITE_BYTE(this.regHL, n >> 4 | this.regAF >> 4 & 0xF0);
        this.regAF = this.regAF & 0xF001 | (n & 0xF) << 8;
        this.regAF = this.regAF & 0xFF01 | (this.regAF >> 8 == 0 ? 68 : this.regAF >> 8 & 0xA8 | PARITY_FLAG[this.regAF >> 8]);
    }

    private final void RLD() {
        int n = this.READ_BYTE(this.regHL);
        this.WRITE_BYTE(this.regHL, n << 4 & 0xF0 | this.regAF >> 8 & 0xF);
        this.regAF = this.regAF & 0xF001 | (n & 0xF0) << 4;
        this.regAF = this.regAF & 0xFF01 | (this.regAF >> 8 == 0 ? 68 : this.regAF >> 8 & 0xA8 | PARITY_FLAG[this.regAF >> 8]);
    }

    private final void CALL() {
        this.PUSH(this.regPC + 2);
        this.regPC = this.READ_WORD(this.regPC);
    }

    private final void RST(int n) {
        this.PUSH(this.regPC);
        this.regPC = n;
    }

    protected final void RET() {
        this.regPC = this.POP();
    }

    private final void RETN() {
        this.regPC = this.POP();
        this.interruptFlipFlop1 = this.interruptFlipFlop2;
    }
}

