/*
 * Decompiled with CFR 0.152.
 */
package gsengine;

import data.Level;
import data.MetaTileset;
import data.Palette;
import data.Tileset;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import transactions.TransactionManager;

public class GSEngineExporter {
    public static void export(File file, Palette palette, Tileset tileset, MetaTileset metaTileset, Level level) {
        if (file == null) {
            return;
        }
        if (file.getName().lastIndexOf(46) < 0) {
            file = new File(file.getParentFile(), String.valueOf(file.getName()) + ".inc");
        }
        String string = file.getName().substring(0, file.getName().lastIndexOf(46));
        File file2 = new File(file.getParentFile(), String.valueOf(string) + "_palette.bin");
        File file3 = new File(file.getParentFile(), String.valueOf(string) + "_tiles.bin");
        File file4 = new File(file.getParentFile(), String.valueOf(string) + "_metatiles.bin");
        File file5 = new File(file.getParentFile(), String.valueOf(string) + "_compositetiles.bin");
        File file6 = new File(file.getParentFile(), String.valueOf(string) + "_compositetiles_ram.bin");
        File file7 = new File(file.getParentFile(), String.valueOf(string) + "_scrolltable.inc");
        try {
            PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(file)));
            int[] nArray = GSEngineExporter.getLevelDimensions(level);
            printWriter.println(".define " + string.toUpperCase() + "_HEIGHT " + nArray[0] * 192);
            printWriter.println(".define " + string.toUpperCase() + "_WIDTH " + nArray[1] * 256);
            int n = 1;
            while (n < 64 && n < nArray[1]) {
                n <<= 1;
            }
            printWriter.println(".define " + string.toUpperCase() + "_SCROLLTABLE_WIDTH " + n * 4);
            printWriter.println();
            int n2 = 0;
            while (n2 < 6 && 1 << n2 < nArray[0]) {
                ++n2;
            }
            int n3 = 0;
            while (n3 < 6 && 1 << n3 < nArray[1]) {
                ++n3;
            }
            GSEngineExporter.writePaletteToFile(palette, file2);
            printWriter.println(".slot 1");
            printWriter.println(".section \"" + string + " Palette" + "\" superfree");
            printWriter.println(String.valueOf(string) + "Palette:");
            printWriter.println(".incbin \"" + file2.getName() + "\"");
            printWriter.println(String.valueOf(string) + "PaletteEnd:");
            printWriter.println(".ends");
            printWriter.println();
            GSEngineExporter.writeTilesetToFile(tileset, file3);
            printWriter.println(".slot 1");
            printWriter.println(".section \"" + string + " Tiles" + "\" superfree");
            printWriter.println(String.valueOf(string) + "Tiles:");
            printWriter.println(".incbin \"" + file3.getName() + "\"");
            printWriter.println(String.valueOf(string) + "TilesEnd:");
            printWriter.println(".ends");
            printWriter.println();
            GSEngineExporter.writeMetaTilesetToFile(metaTileset, file4);
            printWriter.println(".slot 1");
            printWriter.println(".section \"" + string + " Metatiles" + "\" align 256 superfree");
            printWriter.println(String.valueOf(string) + "Metatiles:");
            printWriter.println(".incbin \"" + file4.getName() + "\"");
            printWriter.println(String.valueOf(string) + "MetatilesEnd:");
            printWriter.println(".ends");
            printWriter.println();
            GSEngineExporter.writeCompositeTilesToFile(level, file5, false);
            printWriter.println(".slot 2");
            printWriter.println(".section \"" + string + " CompositeTilesAndScrollTable" + "\" superfree");
            printWriter.println(String.valueOf(string) + "CompositeTiles:");
            printWriter.println(".incbin \"" + file5.getName() + "\"");
            printWriter.println(String.valueOf(string) + "CompositeTilesEnd:");
            printWriter.println();
            GSEngineExporter.writeScrolltableToFile(level, file7, String.valueOf(string) + "CompositeTiles");
            printWriter.println(String.valueOf(string) + "Scrolltable:");
            printWriter.println(".include \"" + file7.getName() + "\"");
            printWriter.println(String.valueOf(string) + "ScrolltableEnd:");
            printWriter.println(".ends");
            printWriter.println();
            GSEngineExporter.writeCompositeTilesToFile(level, file6, true);
            printWriter.println(".slot 1");
            printWriter.println(".section \"" + string + " CompositeTilesRam" + "\" superfree");
            printWriter.println(String.valueOf(string) + "CompositeTilesRam:");
            printWriter.println(".incbin \"" + file6.getName() + "\"");
            printWriter.println(String.valueOf(string) + "CompositeTilesRamEnd:");
            printWriter.println(".ends");
            printWriter.println();
            String[] stringArray = new String[]{"GSE_CTx4Lookup", "GSE_CTx8Lookup", "GSE_CTx16Lookup", "GSE_CTx32Lookup", "GSE_CTx64Lookup", "GSE_CTx128Lookup", "GSE_CTx256Lookup"};
            printWriter.println(".section \"" + string + " Header" + "\" superfree");
            printWriter.println(String.valueOf(string) + "Header:");
            printWriter.println(".db :" + string + "Metatiles");
            printWriter.println(".db :" + string + "CompositeTiles");
            printWriter.println(".dw " + string + "Metatiles");
            printWriter.println(".dw " + string + "CompositeTiles");
            printWriter.println(".dw " + string + "Scrolltable");
            printWriter.println(".dw " + string.toUpperCase() + "_SCROLLTABLE_WIDTH * 2");
            printWriter.println(".dw " + string.toUpperCase() + "_SCROLLTABLE_WIDTH * 6");
            printWriter.println(".dw " + string.toUpperCase() + "_WIDTH");
            printWriter.println(".dw " + string.toUpperCase() + "_HEIGHT");
            printWriter.println(".dw " + stringArray[n3]);
            printWriter.println(".dw " + string + "Tiles");
            printWriter.println(".dw " + string + "TilesEnd - " + string + "Tiles");
            printWriter.println(".db :" + string + "Tiles");
            printWriter.println(".dw " + string + "Palette");
            printWriter.println(".dw " + string + "PaletteEnd - " + string + "Palette");
            printWriter.println(".db :" + string + "Palette");
            printWriter.println(".dw " + string + "CompositeTilesRam");
            printWriter.println(".dw " + string + "CompositeTilesRamEnd - " + string + "CompositeTilesRam");
            printWriter.println(".db :" + string + "CompositeTilesRam");
            printWriter.println(".ends");
            printWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private static void writePaletteToFile(Palette palette, File file) throws FileNotFoundException {
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        int[] nArray = palette.getColors();
        byte[] byArray = new byte[nArray.length];
        int n = 0;
        while (n < byArray.length) {
            byArray[n] = (byte)nArray[n];
            ++n;
        }
        try {
            bufferedOutputStream.write(byArray);
            bufferedOutputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private static void writeTilesetToFile(Tileset tileset, File file) throws FileNotFoundException {
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        int[] nArray = tileset.getVRAM();
        int n = tileset.getDestination() + tileset.getLength();
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < byArray.length) {
            byArray[n2] = (byte)nArray[n2];
            ++n2;
        }
        try {
            bufferedOutputStream.write(byArray);
            bufferedOutputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private static void writeMetaTilesetToFile(MetaTileset metaTileset, File file) throws FileNotFoundException {
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        int[][] nArray = metaTileset.getMetaTiles();
        byte[] byArray = new byte[nArray.length * nArray[0].length];
        int n = 0;
        while (n < byArray.length) {
            byArray[n] = (byte)nArray[n / 8][n % 8];
            ++n;
        }
        try {
            bufferedOutputStream.write(byArray);
            bufferedOutputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private static int[] getLevelDimensions(final Level level) {
        final int[] nArray = new int[2];
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                int[][][] nArray2;
                if (level.getScrollability() != 1 && level.getScrollability() != 8 && level.getScrollability() != 128) {
                    level.convertToScrollability(128, level.getMaxHorizontalScreenNumber() + 1, level.getMaxVerticalScreenNumber() + 1);
                }
                int n = level.getMaxHorizontalScreenNumber() + 1;
                int n2 = level.getMaxVerticalScreenNumber() + 1;
                if (level.getScrollability() == 128) {
                    int n3 = 0;
                    int n4 = 1;
                    int n5 = 0;
                    while (n5 < n2) {
                        int n6 = n4 - 1;
                        while (n6 < n) {
                            if (level.isValidScreen(n6, n5)) {
                                if (n5 + 1 > n3) {
                                    n3 = n5 + 1;
                                }
                                if (n6 + 1 > n4) {
                                    n4 = n6 + 1;
                                }
                            }
                            ++n6;
                        }
                        ++n5;
                    }
                    nArray2 = new int[n3][n4][];
                } else {
                    nArray2 = level.getScrollability() == 1 ? new int[n2][1][] : new int[1][n][];
                }
                nArray[0] = nArray2.length;
                nArray[1] = nArray2[0].length;
                throw new RuntimeException("Finished");
            }
        };
        TransactionManager.getInstance().runTransaction(runnable);
        return nArray;
    }

    private static void writeCompositeTilesToFile(final Level level, File file, final boolean bl) throws FileNotFoundException {
        final BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                int[][][] nArray;
                int n;
                int n2;
                int n3;
                int n4;
                if (level.getScrollability() != 1 && level.getScrollability() != 8 && level.getScrollability() != 128) {
                    level.convertToScrollability(128, level.getMaxHorizontalScreenNumber() + 1, level.getMaxVerticalScreenNumber() + 1);
                }
                int n5 = level.getMaxHorizontalScreenNumber() + 1;
                int n6 = level.getMaxVerticalScreenNumber() + 1;
                if (level.getScrollability() == 128) {
                    n4 = 0;
                    n3 = 1;
                    n2 = 0;
                    while (n2 < n6) {
                        n = n3 - 1;
                        while (n < n5) {
                            if (level.isValidScreen(n, n2)) {
                                if (n2 + 1 > n4) {
                                    n4 = n2 + 1;
                                }
                                if (n + 1 > n3) {
                                    n3 = n + 1;
                                }
                            }
                            ++n;
                        }
                        ++n2;
                    }
                    nArray = new int[n4][n3][192];
                    n2 = 0;
                    while (n2 < n4) {
                        n = 0;
                        while (n < n3) {
                            nArray[n2][n] = level.isValidScreen(n, n2) ? level.getLayout(n, n2) : new int[192];
                            ++n;
                        }
                        ++n2;
                    }
                } else if (level.getScrollability() == 1) {
                    nArray = new int[n6][1][192];
                    n4 = 0;
                    while (n4 < n6) {
                        nArray[n4][0] = level.getLayout(0, n4);
                        ++n4;
                    }
                } else {
                    nArray = new int[1][n5][192];
                    n4 = 0;
                    while (n4 < n5) {
                        nArray[0][n4] = level.getLayout(n4, 0);
                        ++n4;
                    }
                }
                ArrayList<Byte> arrayList = new ArrayList<Byte>();
                n3 = 0;
                while (n3 < nArray.length * 3) {
                    n2 = 0;
                    while (n2 < nArray[0].length * 4) {
                        if (GSEngineExporter.compositeBlockContainsChangableMetaTile(nArray, n3, n2) == bl) {
                            n = 0;
                            while (n < 4) {
                                int n7 = 0;
                                while (n7 < 4) {
                                    int n8 = nArray[n3 / 3][n2 / 4][(n3 % 3 * 4 + n) * 16 + n2 % 4 * 4 + n7];
                                    arrayList.add((byte)(n8 << 3 | n8 >> 5));
                                    ++n7;
                                }
                                ++n;
                            }
                        }
                        ++n2;
                    }
                    ++n3;
                }
                try {
                    byte[] byArray = new byte[arrayList.size()];
                    n2 = 0;
                    while (n2 < byArray.length) {
                        byArray[n2] = (Byte)arrayList.get(n2);
                        ++n2;
                    }
                    bufferedOutputStream.write(byArray);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                throw new RuntimeException("Finished");
            }
        };
        TransactionManager.getInstance().runTransaction(runnable);
        try {
            bufferedOutputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private static void writeScrolltableToFile(final Level level, File file, final String string) throws FileNotFoundException {
        final PrintStream printStream = new PrintStream(new BufferedOutputStream(new FileOutputStream(file)));
        TransactionManager.getInstance().runTransaction(new Runnable(){

            @Override
            public void run() {
                int[][][] nArray;
                int n;
                int n2;
                int n3;
                int n4;
                if (level.getScrollability() != 1 && level.getScrollability() != 8 && level.getScrollability() != 128) {
                    level.convertToScrollability(128, level.getMaxHorizontalScreenNumber() + 1, level.getMaxVerticalScreenNumber() + 1);
                }
                int n5 = level.getMaxHorizontalScreenNumber() + 1;
                int n6 = level.getMaxVerticalScreenNumber() + 1;
                if (level.getScrollability() == 128) {
                    n4 = 0;
                    n3 = 1;
                    n2 = 0;
                    while (n2 < n6) {
                        n = n3 - 1;
                        while (n < n5) {
                            if (level.isValidScreen(n, n2)) {
                                if (n2 + 1 > n4) {
                                    n4 = n2 + 1;
                                }
                                if (n + 1 > n3) {
                                    n3 = n + 1;
                                }
                            }
                            ++n;
                        }
                        ++n2;
                    }
                    nArray = new int[n4][n3][192];
                    n2 = 0;
                    while (n2 < n4) {
                        n = 0;
                        while (n < n3) {
                            nArray[n2][n] = level.isValidScreen(n, n2) ? level.getLayout(n, n2) : new int[192];
                            ++n;
                        }
                        ++n2;
                    }
                } else if (level.getScrollability() == 1) {
                    nArray = new int[n6][1][192];
                    n4 = 0;
                    while (n4 < n6) {
                        nArray[n4][0] = level.getLayout(0, n4);
                        ++n4;
                    }
                } else {
                    nArray = new int[1][n5][192];
                    n4 = 0;
                    while (n4 < n5) {
                        nArray[0][n4] = level.getLayout(n4, 0);
                        ++n4;
                    }
                }
                n4 = 1;
                while (n4 < 64 && n4 < nArray[0].length) {
                    n4 <<= 1;
                }
                n3 = 0;
                n2 = 0;
                n = 0;
                while (n < nArray.length * 3) {
                    printStream.print(".dw");
                    int n7 = 0;
                    while (n7 < nArray[0].length * 4) {
                        int n8;
                        if (n7 > 0) {
                            printStream.print(",");
                        }
                        if (GSEngineExporter.compositeBlockContainsChangableMetaTile(nArray, n, n7)) {
                            n8 = n2 >> 4 << 8 | (n2 & 0xF) << 4;
                            printStream.print(" (GSE_RAM_CT_ADDRESS + " + n8 + ")");
                            ++n2;
                        } else {
                            n8 = n3 >> 4 << 8 | (n3 & 0xF) << 4;
                            printStream.print(" (" + string + " + " + n8 + ")");
                            ++n3;
                        }
                        ++n7;
                    }
                    while (n7 < n4 * 4) {
                        printStream.print(", 0");
                        ++n7;
                    }
                    printStream.println();
                    ++n;
                }
                throw new RuntimeException("Finished");
            }
        });
        printStream.close();
    }

    private static boolean compositeBlockContainsChangableMetaTile(int[][][] nArray, int n, int n2) {
        int n3 = 0;
        while (n3 < 4) {
            int n4 = 0;
            while (n4 < 4) {
                int n5 = nArray[n / 3][n2 / 4][(n % 3 * 4 + n3) * 16 + n2 % 4 * 4 + n4];
                if (GSEngineExporter.metaTileIsChangable(n5)) {
                    return true;
                }
                ++n4;
            }
            ++n3;
        }
        return false;
    }

    private static boolean metaTileIsChangable(int n) {
        return n == 1 || n == 2 || n == 3 || n == 10;
    }
}

