/*
 * Decompiled with CFR 0.152.
 */
package data;

import editor.Z80Factory;
import mastersystem.OutputListener;
import mastersystem.TMS9918A;
import mastersystem.Z80;
import rom.RomManager;

public class AlexFrame {
    private final int[] vram;
    private final int destination;
    private final int length;

    public AlexFrame(int n, int n2) {
        final int[] nArray = new int[65536];
        RomManager.StaticAccess.copyFromROM(0, nArray, 0, 49152);
        final Z80 z80 = Z80Factory.create(nArray);
        final TMS9918A tMS9918A = new TMS9918A(262);
        this.vram = tMS9918A.getVRAM();
        z80.addOutputListener(new OutputListener(){

            @Override
            public void outputAvailable(int n, int n2, int n3) {
                if (n == 65535) {
                    RomManager.StaticAccess.loadBank2(nArray, n2);
                } else if (n >> 6 == 2) {
                    if (n2 < 0) {
                        z80.setInput(tMS9918A.readByte(n & 1, n3));
                    } else {
                        tMS9918A.processInput(n & 1, n2, n3);
                    }
                }
            }
        });
        this.destination = 8192;
        this.length = 352;
        z80.setAF(n2 << 8);
        z80.execute(n);
    }

    public int getDestination() {
        return this.destination;
    }

    public int getLength() {
        return this.length;
    }

    public int[] getVRAM() {
        return this.vram;
    }

    public boolean contains(int n) {
        int n2 = this.destination & 0x2000 | n << 5;
        return n2 >= this.destination && n2 < this.destination + this.length;
    }
}

