/*
 * Decompiled with CFR 0.152.
 */
package widgets;

import java.awt.event.ActionListener;
import widgets.HexTextField;

public class BCDTextField
extends HexTextField {
    private final boolean trailingZero;

    public BCDTextField(int n, int n2, boolean bl) {
        super(n, bl ? n2 * 16 : n2);
        this.trailingZero = bl;
        this.setText(this.getValueString());
    }

    public BCDTextField(int n, int n2, boolean bl, ActionListener actionListener) {
        super(n, bl ? n2 * 16 : n2, actionListener);
        this.trailingZero = bl;
        this.setText(this.getValueString());
    }

    @Override
    protected String getAllowedCharClass() {
        return "0-9";
    }

    @Override
    protected int getMaxLength() {
        if (this.trailingZero) {
            return super.getMaxLength() + 1;
        }
        return super.getMaxLength();
    }

    @Override
    protected String getValueString() {
        if (this.trailingZero) {
            return String.valueOf(super.getValueString().substring(1)) + "0";
        }
        return super.getValueString();
    }

    @Override
    public void setValue(int n) {
        if (this.trailingZero) {
            super.setValue(n * 16);
        } else {
            super.setValue(n);
        }
    }

    @Override
    public int getValue() {
        if (this.trailingZero) {
            return super.getValue() / 16;
        }
        return super.getValue();
    }
}

