/*
 * Decompiled with CFR 0.152.
 */
package panels;

import changes.Change;
import changes.ChangeListener;
import data.Palette;
import data.Sprite;
import data.SpriteContainer;
import data.Tileset;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.util.LinkedList;
import javax.swing.SwingUtilities;
import mastersystem.Renderer;
import panels.ScalablePanel;
import transactions.TransactionManager;

public class SpritePanel
extends ScalablePanel {
    private static final Color BRIGHTER_DARK_GRAY = Color.DARK_GRAY.brighter();
    private static final Color DARKER_LIGHT_GRAY = Color.LIGHT_GRAY.darker();
    private BufferedImage image;
    private final Color[] colors = new Color[32];
    private SpriteContainer sprite;
    private Palette palette;
    private Tileset tileset;
    private int[] sat;
    private int frame;
    private int originX;
    private int originY;
    private int selectedSprite = -1;
    private int highlightedSprite = -1;
    private int dragXstart;
    private int dragYstart;
    private int dragXoffset;
    private int dragYoffset;
    private boolean hitboxEnabled;
    private int offsetX;
    private int offsetY;
    private float scale = 1.0f;
    private final LinkedList<ActionListener> listeners = new LinkedList();
    private final ChangeListener paletteChangeListener = new ChangeListener(){

        @Override
        public void changeOccurred(Change change) {
            int n = change.getData(SpritePanel.this.palette);
            if (n < 0) {
                int n2 = -n - 1;
                if (n2 >= 1) {
                    int n3 = 16;
                    while (n3 < 32) {
                        int n4 = SpritePanel.this.palette.getColors()[n3];
                        int n5 = (n4 & 0x30) >> 4;
                        int n6 = (n4 & 0xC) >> 2;
                        int n7 = n4 & 3;
                        ((SpritePanel)SpritePanel.this).colors[n3] = new Color(n7 * 255 / 3, n6 * 255 / 3, n5 * 255 / 3);
                        ++n3;
                    }
                }
            } else if (n > 16) {
                int n8 = SpritePanel.this.palette.getColors()[n];
                int n9 = (n8 & 0x30) >> 4;
                int n10 = (n8 & 0xC) >> 2;
                int n11 = n8 & 3;
                ((SpritePanel)SpritePanel.this).colors[n] = new Color(n11 * 255 / 3, n10 * 255 / 3, n9 * 255 / 3);
                SpritePanel.this.update();
            }
        }
    };
    private final ChangeListener spriteChangeListener = new ChangeListener(){

        @Override
        public void changeOccurred(Change change) {
            SpritePanel.this.setSelectedSprite(change.getData(SpritePanel.this.sprite));
            SpritePanel.this.update();
        }
    };
    private final ChangeListener tilesetChangeListener = new ChangeListener(){

        @Override
        public void changeOccurred(Change change) {
            SpritePanel.this.update();
        }
    };

    public SpritePanel(SpriteContainer spriteContainer, Palette palette, Tileset tileset) {
        this.setSprite(spriteContainer, palette, tileset);
        final Cursor cursor = this.getCursor();
        final Cursor cursor2 = Cursor.getPredefinedCursor(12);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                SpritePanel.this.requestFocusInWindow();
                int n = SpritePanel.this.toScreenX(mouseEvent.getX()) - SpritePanel.this.originX;
                int n2 = SpritePanel.this.toScreenY(mouseEvent.getY()) - SpritePanel.this.originY;
                if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    SpritePanel.this.selectedSprite = -1;
                }
                if (n + SpritePanel.this.originX < 0 || n2 + SpritePanel.this.originY < 0 || n + SpritePanel.this.originX >= 256 || n2 + SpritePanel.this.originY >= 256) {
                    SpritePanel.this.repaint();
                    SpritePanel.this.fireActionPerformed();
                    return;
                }
                Sprite sprite = SpritePanel.this.sprite.getSprites()[SpritePanel.this.frame];
                int n3 = 0;
                while (n3 < sprite.getSpriteCount()) {
                    if (sprite.contains(n3, (byte)n, (byte)n2)) {
                        if (!SwingUtilities.isLeftMouseButton(mouseEvent)) break;
                        TransactionManager.getInstance().startTransaction();
                        sprite.startMoving(n3);
                        SpritePanel.this.selectedSprite = n3;
                        SpritePanel.this.dragXoffset = n - sprite.getSpriteX(n3);
                        SpritePanel.this.dragYoffset = n2 - sprite.getSpriteY(n3);
                        SpritePanel.this.dragXstart = n;
                        SpritePanel.this.dragYstart = n2;
                        break;
                    }
                    ++n3;
                }
                SpritePanel.this.repaint();
                SpritePanel.this.fireActionPerformed();
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                int n = SpritePanel.this.toScreenX(mouseEvent.getX()) - SpritePanel.this.originX;
                int n2 = SpritePanel.this.toScreenY(mouseEvent.getY()) - SpritePanel.this.originY;
                SpritePanel.this.highlightedSprite = -1;
                if (n + SpritePanel.this.originX < 0 || n2 + SpritePanel.this.originY < 0 || n + SpritePanel.this.originX >= 256 || n2 + SpritePanel.this.originY >= 256) {
                    SpritePanel.this.setCursor(cursor);
                    SpritePanel.this.repaint();
                    return;
                }
                Sprite sprite = SpritePanel.this.sprite.getSprites()[SpritePanel.this.frame];
                int n3 = 0;
                while (n3 < sprite.getSpriteCount()) {
                    if (sprite.contains(n3, (byte)n, (byte)n2)) {
                        SpritePanel.this.highlightedSprite = n3;
                        SpritePanel.this.setCursor(cursor2);
                        SpritePanel.this.repaint();
                        return;
                    }
                    ++n3;
                }
                SpritePanel.this.setCursor(cursor);
                SpritePanel.this.repaint();
            }

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                int n = SpritePanel.this.toScreenX(mouseEvent.getX());
                int n2 = SpritePanel.this.toScreenY(mouseEvent.getY());
                if (n < 0 || n2 < 0 || n >= 256 || n2 >= 256) {
                    return;
                }
                n -= SpritePanel.this.originX;
                n2 -= SpritePanel.this.originY;
                if (mouseEvent.isShiftDown()) {
                    if (Math.abs(n - SpritePanel.this.dragXstart) > Math.abs(n2 - SpritePanel.this.dragYstart)) {
                        n2 = SpritePanel.this.dragYstart;
                    } else {
                        n = SpritePanel.this.dragXstart;
                    }
                }
                Sprite sprite = SpritePanel.this.sprite.getSprites()[SpritePanel.this.frame];
                if (SpritePanel.this.selectedSprite >= 0 && SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    if ((mouseEvent.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) != 0) {
                        sprite.setSpritePosition(SpritePanel.this.selectedSprite, n & 0xF8, (n2 & 0xF8) - 1);
                    } else {
                        sprite.setSpritePosition(SpritePanel.this.selectedSprite, n - SpritePanel.this.dragXoffset, n2 - SpritePanel.this.dragYoffset);
                    }
                    TransactionManager.getInstance().commit();
                }
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                int n = keyEvent.isShiftDown() ? 4 : 1;
                switch (keyEvent.getKeyCode()) {
                    case 37: {
                        SpritePanel.this.moveLeft(n);
                        break;
                    }
                    case 39: {
                        SpritePanel.this.moveRight(n);
                        break;
                    }
                    case 38: {
                        SpritePanel.this.moveUp(n);
                        break;
                    }
                    case 40: {
                        SpritePanel.this.moveDown(n);
                    }
                }
            }
        });
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                SpritePanel.this.repaint();
            }

            @Override
            public void focusGained(FocusEvent focusEvent) {
                SpritePanel.this.repaint();
            }
        });
        this.setFocusable(true);
    }

    private void moveLeft(int n) {
        this.moveBy(-n, 0);
    }

    private void moveRight(int n) {
        this.moveBy(n, 0);
    }

    private void moveUp(int n) {
        this.moveBy(0, -n);
    }

    private void moveDown(int n) {
        this.moveBy(0, n);
    }

    private void moveBy(final int n, final int n2) {
        TransactionManager.getInstance().runTransaction(new Runnable(){

            @Override
            public void run() {
                Sprite sprite = SpritePanel.this.sprite.getSprites()[SpritePanel.this.frame];
                byte by = sprite.getSpriteX(SpritePanel.this.selectedSprite);
                byte by2 = sprite.getSpriteY(SpritePanel.this.selectedSprite);
                TransactionManager.getInstance().addTransactionObject(sprite, SpritePanel.this.selectedSprite);
                sprite.setSpritePosition(SpritePanel.this.selectedSprite, by + n, by2 + n2);
                SpritePanel.this.repaint();
            }
        });
    }

    public void setHitboxEnabled(boolean bl) {
        this.hitboxEnabled = bl;
        this.repaint();
    }

    public void setSprite(SpriteContainer spriteContainer, Palette palette, Tileset tileset) {
        if (this.palette != null && this.palette != palette) {
            this.palette.removeChangeListener(this.paletteChangeListener);
        }
        if (this.sprite != null && this.sprite != spriteContainer) {
            this.sprite.removeChangeListener(this.spriteChangeListener);
        }
        if (this.tileset != null && this.tileset != tileset) {
            this.tileset.removeChangeListener(this.tilesetChangeListener);
        }
        this.sprite = spriteContainer;
        this.palette = palette;
        this.tileset = tileset;
        this.frame = 0;
        this.setSelectedSprite(-1);
        int n = 0;
        int[] nArray = palette.getColors();
        int n2 = nArray.length;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = nArray[n3];
            int n5 = (n4 & 0x30) >> 4;
            int n6 = (n4 & 0xC) >> 2;
            int n7 = n4 & 3;
            this.colors[n++] = new Color(n7 * 255 / 3, n6 * 255 / 3, n5 * 255 / 3);
            ++n3;
        }
        palette.addChangeListener(this.paletteChangeListener);
        spriteContainer.addChangeListener(this.spriteChangeListener);
        tileset.addChangeListener(this.tilesetChangeListener);
        this.update();
    }

    public void setFrame(int n) {
        if (n >= 0 && n < this.sprite.getSpriteCount()) {
            this.frame = n;
            this.setSelectedSprite(-1);
            this.update();
        }
    }

    public int getSelectedSprite() {
        return this.selectedSprite;
    }

    public void setSelectedSprite(int n) {
        this.selectedSprite = n;
        this.highlightedSprite = -1;
        this.repaint();
        this.fireActionPerformed();
    }

    public void copyToClipboard() {
    }

    public boolean canPasteFromClipboard() {
        return false;
    }

    public void pasteFromClipboard() {
    }

    private void update() {
        this.image = new BufferedImage(272, 272, 2);
        this.originX = this.sprite.getHpos(this.frame);
        this.originY = this.sprite.getVpos(this.frame) + 16;
        int[] nArray = this.sprite.getVRAM(this.frame, this.tileset);
        this.sat = this.sprite.getSAT(this.frame);
        int n = 0;
        while (n < 64 && this.sat[n] != 208) {
            int n2;
            int n3;
            int n4 = this.sat[n] + 1;
            if (n4 >= 240) {
                n4 -= 256;
            }
            if (!Renderer.renderSpriteCharacter(nArray, n3 = this.sat[0x80 | n << 1 | 1], n2 = this.sat[0x80 | n << 1], n4 + 16, this.colors, this.image)) {
                Graphics2D graphics2D = this.image.createGraphics();
                graphics2D.setColor(new Color(0.5f, 0.5f, 0.5f, 0.5f));
                graphics2D.fillRect(n2, n4 + 16, 8, 8);
                if (!this.tileset.contains(n3)) {
                    graphics2D.setColor(Color.RED);
                    graphics2D.drawLine(n2 + 1, n4 + 16 + 1, n2 + 6, n4 + 16 + 6);
                }
                graphics2D.dispose();
            }
            ++n;
        }
        this.repaint();
    }

    @Override
    public Dimension getPreferredSize() {
        Insets insets = this.getInsets();
        return new Dimension((int)((float)this.image.getWidth() * this.getPreferredScale()) + insets.left + insets.right, (int)((float)this.image.getHeight() * this.getPreferredScale()) + insets.top + insets.bottom);
    }

    private int toScreenX(int n) {
        return n >= this.offsetX ? (int)((float)(n - this.offsetX) / this.scale) : (int)((float)(n - this.offsetX) / this.scale) - 1;
    }

    private int toScreenY(int n) {
        return n >= this.offsetY ? (int)((float)(n - this.offsetY) / this.scale) : (int)((float)(n - this.offsetY) / this.scale) - 1;
    }

    @Override
    public float getScale() {
        return this.scale;
    }

    protected final void fireActionPerformed() {
        for (ActionListener actionListener : this.listeners) {
            actionListener.actionPerformed(null);
        }
    }

    public final void addActionListener(ActionListener actionListener) {
        if (!this.listeners.contains(actionListener)) {
            this.listeners.add(actionListener);
        }
    }

    public final void removeActionListener(ActionListener actionListener) {
        this.listeners.remove(actionListener);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        BufferedImage bufferedImage = new BufferedImage(256, 256, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage((Image)this.image, 0, 0, null);
        graphics2D.setColor(Color.WHITE);
        graphics2D.drawLine(this.originX - 5, this.originY, this.originX + 5, this.originY);
        graphics2D.drawLine(this.originX, this.originY - 5, this.originX, this.originY + 5);
        if (this.hasFocus() && this.selectedSprite >= 0) {
            graphics2D.setColor(Color.WHITE);
            graphics2D.drawRect(this.originX + this.sprite.getSprites()[this.frame].getSpriteX(this.selectedSprite) & 0xFF, this.originY + this.sprite.getSprites()[this.frame].getSpriteY(this.selectedSprite) & 0xFF, 8, 8);
        }
        if (this.highlightedSprite >= 0 && this.highlightedSprite != this.selectedSprite) {
            graphics2D.setColor(DARKER_LIGHT_GRAY);
            graphics2D.drawRect(this.originX + this.sprite.getSprites()[this.frame].getSpriteX(this.highlightedSprite) & 0xFF, this.originY + this.sprite.getSprites()[this.frame].getSpriteY(this.highlightedSprite) & 0xFF, 8, 8);
        }
        if (this.hitboxEnabled) {
            graphics2D.setColor(Color.GREEN);
            graphics2D.drawRect(this.originX + this.sprite.getHitboxX(this.frame) & 0xFF, this.originY + this.sprite.getHitboxY(this.frame) & 0xFF, this.sprite.getHitboxWidth(this.frame), this.sprite.getHitboxHeight(this.frame));
            graphics2D.setColor(Color.RED);
            graphics2D.drawRect(this.originX + this.sprite.getWeaponHitboxX(this.frame) & 0xFF, this.originY + this.sprite.getWeaponHitboxY(this.frame) & 0xFF, this.sprite.getWeaponHitboxWidth(this.frame), this.sprite.getWeaponHitboxHeight(this.frame));
        }
        graphics2D.dispose();
        Insets insets = this.getInsets();
        int n = this.getWidth() - (insets.left + insets.right);
        int n2 = this.getHeight() - (insets.top + insets.bottom);
        float f = (float)n / (float)bufferedImage.getWidth();
        float f2 = (float)n2 / (float)bufferedImage.getHeight();
        float f3 = Math.min(f, f2);
        if (this.isIntegerScaling()) {
            float f4;
            if ((this.scale != (float)((int)this.scale) || f3 - this.scale < 0.0f || f3 - this.scale >= 1.0f) && this.scale != (f4 = (float)Math.max(1, (int)(this.scale + Math.max(-1.0f, Math.min(1.0f, (f3 - this.scale) * 1.0f)))))) {
                this.scale = f4;
                this.scrollRectToVisible(new Rectangle(n / 2 - n / 5, n2 / 2 - n2 / 5, n / 2 + n / 5, n2 / 2 + n2 / 5));
                this.scaleUpdated();
            }
        } else if (Math.abs(f3 - this.scale) * (float)bufferedImage.getWidth() > 2.0f && Math.abs(f3 - this.scale) * (float)bufferedImage.getHeight() > 2.0f) {
            this.scale += (f3 - this.scale) * 0.5f;
            this.scrollRectToVisible(new Rectangle(n / 2 - n / 5, n2 / 2 - n2 / 5, n / 2 + n / 5, n2 / 2 + n2 / 5));
            this.scaleUpdated();
        }
        this.offsetX = Math.max(0, (int)(((float)n - (float)bufferedImage.getWidth() * this.scale) / 2.0f)) + insets.left;
        this.offsetY = Math.max(0, (int)(((float)n2 - (float)bufferedImage.getHeight() * this.scale) / 2.0f)) + insets.right;
        this.drawGrid(graphics);
        graphics.drawImage(bufferedImage, this.offsetX, this.offsetY, (int)((float)bufferedImage.getWidth() * this.scale), (int)((float)bufferedImage.getHeight() * this.scale), null);
    }

    private void drawGrid(Graphics graphics) {
        int n;
        graphics.setColor(BRIGHTER_DARK_GRAY);
        int n2 = 0;
        while ((float)this.offsetY + (float)n2 * this.scale <= (float)(this.getHeight() - this.offsetY)) {
            n = this.offsetY + Math.round((float)n2 * this.scale);
            graphics.drawLine(this.offsetX, n, this.getWidth() - this.offsetX, n);
            n2 += 8;
        }
        n2 = 0;
        while ((float)this.offsetX + (float)n2 * this.scale <= (float)(this.getWidth() - this.offsetX)) {
            n = this.offsetX + Math.round((float)n2 * this.scale);
            graphics.drawLine(n, this.offsetY, n, this.getHeight() - this.offsetY);
            n2 += 8;
        }
    }
}

