/*
 * Decompiled with CFR 0.152.
 */
package panels;

import changes.Change;
import changes.ChangeListener;
import data.BonusLevel;
import data.Level;
import data.LevelPalette;
import data.LevelSpriteTileset;
import data.SpriteContainer;
import data.Tileset;
import editors.EntityLabelProvider;
import editors.KiddEd;
import editors.TextProvider;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.LinkedList;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollBar;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import mastersystem.Renderer;
import miracleworld.MiracleWorldEditorModel;
import miracleworld.data.MiracleWorldMetaTileset;
import panels.ScalablePanel;
import rom.RomManager;
import transactions.TransactionManager;

public class LevelPanel
extends ScalablePanel {
    public static final int MODE_ENTITY_EDITING = 0;
    public static final int MODE_LAYOUT_EDITING = 1;
    private final BufferedImage screen = new BufferedImage(256, 192, 1);
    private final BufferedImage hiddenTiles = new BufferedImage(256, 192, 2);
    private final BufferedImage buffer = new BufferedImage(this.screen.getWidth(), this.screen.getHeight() + 16 + 16, 2);
    private final Color[] colors = new Color[32];
    private final Color[] transparentColors = new Color[32];
    private Level level;
    private Tileset tileset;
    private LevelSpriteTileset spriteTileset;
    private MiracleWorldMetaTileset metaTileset;
    private LevelPalette palette;
    private SpriteContainer[] sprites;
    private Entity[] entities;
    private int[] layout;
    private int[] sat;
    private int[] hiddenTilesData;
    private boolean editHiddenTiles;
    private boolean addHiddenTiles;
    private boolean maskEntityPositions;
    private int horizontalScreenNumber;
    private int verticalScreenNumber;
    private int mode = 0;
    private boolean showTileAttributes;
    private int selectedEntity = -1;
    private int dragXstart;
    private int dragYstart;
    private int dragXoffset;
    private int dragYoffset;
    private int selectedMetaTile = -1;
    private int selectedTile = -1;
    private int offsetX;
    private int offsetY;
    private float scale = 1.0f;
    private TransferHandler additionalTransferHandler;
    private final EntityLabelProvider entityLabelProvider;
    private final JScrollBar verticalScrollBar = new JScrollBar(1);
    private final JScrollBar horizontalScrollBar = new JScrollBar(0);
    private final KeyEventDispatcher keyEventDispatcher = new KeyEventDispatcher(){

        @Override
        public boolean dispatchKeyEvent(KeyEvent keyEvent) {
            if (LevelPanel.this.mode == 0 && keyEvent.getKeyCode() == 17) {
                LevelPanel.this.maskEntityPositions = keyEvent.getID() == 401;
            }
            return false;
        }
    };
    private final LinkedList<ActionListener> listeners = new LinkedList();
    private final ChangeListener tilesetChangeListener = new ChangeListener(){

        @Override
        public void changeOccurred(Change change) {
            if (change.getData(LevelPanel.this.tileset) < 256) {
                LevelPanel.this.drawTiles();
                LevelPanel.this.drawHiddenTiles();
            } else {
                Entity[] entityArray = LevelPanel.this.entities;
                int n = entityArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Entity entity = entityArray[n2];
                    if (entity != null) {
                        entity.image = null;
                    }
                    ++n2;
                }
                LevelPanel.this.spriteTileset.updateMemory();
                LevelPanel.this.drawEntities();
            }
            LevelPanel.this.repaint();
        }
    };
    private final ChangeListener spriteChangeListener = new ChangeListener(){

        @Override
        public void changeOccurred(Change change) {
            Entity[] entityArray = LevelPanel.this.entities;
            int n = entityArray.length;
            int n2 = 0;
            while (n2 < n) {
                Entity entity = entityArray[n2];
                if (entity != null) {
                    entity.image = null;
                }
                ++n2;
            }
            LevelPanel.this.updateEntities();
            LevelPanel.this.repaint();
        }
    };
    private final ChangeListener paletteChangeListener = new ChangeListener(){

        @Override
        public void changeOccurred(Change change) {
            int n = change.getData(LevelPanel.this.palette);
            if (n < 0) {
                int n2 = -n - 1;
                int n3 = n2 * 16;
                int n4 = n3 + 16;
                if (n2 == 2) {
                    n3 = 0;
                    n4 = 32;
                }
                int n5 = n3;
                while (n5 < n4) {
                    int n6 = LevelPanel.this.palette.getColors()[n5];
                    int n7 = (n6 & 0x30) >> 4;
                    int n8 = (n6 & 0xC) >> 2;
                    int n9 = n6 & 3;
                    ((LevelPanel)LevelPanel.this).colors[n5] = new Color(n9 * 255 / 3, n8 * 255 / 3, n7 * 255 / 3);
                    ((LevelPanel)LevelPanel.this).transparentColors[n5] = new Color(LevelPanel.this.colors[n5].getRed(), LevelPanel.this.colors[n5].getGreen(), LevelPanel.this.colors[n5].getBlue(), 128);
                    ++n5;
                }
                LevelPanel.this.drawTiles();
                LevelPanel.this.drawHiddenTiles();
                if (n2 >= 1) {
                    LevelPanel.this.drawEntities();
                }
            } else {
                int n10 = LevelPanel.this.palette.getColors()[n];
                int n11 = (n10 & 0x30) >> 4;
                int n12 = (n10 & 0xC) >> 2;
                int n13 = n10 & 3;
                ((LevelPanel)LevelPanel.this).colors[n] = new Color(n13 * 255 / 3, n12 * 255 / 3, n11 * 255 / 3);
                ((LevelPanel)LevelPanel.this).transparentColors[n] = new Color(LevelPanel.this.colors[n].getRed(), LevelPanel.this.colors[n].getGreen(), LevelPanel.this.colors[n].getBlue(), 128);
                LevelPanel.this.drawTiles();
                if (n > 16) {
                    LevelPanel.this.drawEntities();
                }
            }
            LevelPanel.this.repaint();
        }
    };
    private final ChangeListener metaTileChangeListener = new ChangeListener(){

        @Override
        public void changeOccurred(Change change) {
            int n = change.getData(LevelPanel.this.metaTileset);
            if (n < 0) {
                LevelPanel.this.drawTiles();
            } else {
                int[] nArray = LevelPanel.this.tileset.getVRAM();
                int[][] nArray2 = LevelPanel.this.metaTileset.getMetaTiles();
                Graphics2D graphics2D = LevelPanel.this.screen.createGraphics();
                int n2 = 0;
                while (n2 < 12) {
                    int n3 = 0;
                    while (n3 < 16) {
                        if (LevelPanel.this.layout[n2 * 16 + n3] == n) {
                            int[] nArray3 = nArray2[LevelPanel.this.layout[n2 * 16 + n3]];
                            Renderer.renderMetaTile(nArray, nArray3, n3 * 16, n2 * 16, LevelPanel.this.showTileAttributes, LevelPanel.this.colors, graphics2D);
                            int n4 = LevelPanel.this.level.getShopEntranceNameTablePos() / 64;
                            n4 = LevelPanel.this.level.getScrollability() == 129 ? (n4 += ((LevelPanel.this.horizontalScreenNumber > 0 ? LevelPanel.this.level.getMaxVerticalScreenNumber() : LevelPanel.this.verticalScreenNumber) - LevelPanel.this.level.getStartVerticalScreenNumber() + 1) * 4) : (n4 += (LevelPanel.this.verticalScreenNumber - LevelPanel.this.level.getStartVerticalScreenNumber()) * 4);
                            if (n4 < 0) {
                                n4 += 28;
                            }
                            int n5 = 0;
                            while (n5 < 4) {
                                Graphics2D graphics2D2;
                                if (LevelPanel.this.showTileAttributes && nArray3[n5 * 2 + 1] >> 5 == 3 && nArray3[n5 * 2] >= RomManager.StaticAccess.readByte(15573) && n3 * 16 + n5 % 2 * 8 >= 24) {
                                    graphics2D2 = LevelPanel.this.screen.createGraphics();
                                    graphics2D2.setColor(Color.YELLOW);
                                    if (n2 * 16 + n5 / 2 * 8 >= n4 % 28 * 8 && n2 * 16 + n5 / 2 * 8 < n4 * 8 + 32) {
                                        graphics2D2.drawLine(LevelPanel.this.level.getShopEntranceHpos(), n2 * 16 + n5 / 2 * 8, LevelPanel.this.level.getShopEntranceHpos(), n2 * 16 + n5 / 2 * 8 + 8);
                                    }
                                    graphics2D2.dispose();
                                } else if (LevelPanel.this.showTileAttributes && nArray3[n5 * 2 + 1] >> 5 == 5 && nArray3[n5 * 2] > 63) {
                                    graphics2D2 = LevelPanel.this.screen.createGraphics();
                                    graphics2D2.setColor(Color.GREEN);
                                    if (n2 * 16 + n5 / 2 * 8 - 24 >= n4 * 8 && n4 % 14 * 16 + n5 / 2 * 8 - 24 < n4 * 8 + 16) {
                                        graphics2D2.drawLine(LevelPanel.this.level.getShopEntranceHpos(), n2 * 16 + n5 / 2 * 8, LevelPanel.this.level.getShopEntranceHpos(), n2 * 16 + n5 / 2 * 8 + 8);
                                    }
                                    graphics2D2.dispose();
                                }
                                ++n5;
                            }
                        }
                        ++n3;
                    }
                    ++n2;
                }
                graphics2D.dispose();
            }
            LevelPanel.this.repaint();
        }
    };
    private final ChangeListener levelChangeListener = new ChangeListener(){

        @Override
        public void changeOccurred(Change change) {
            int n = change.getData(LevelPanel.this.level);
            if (n < 0) {
                if (n == -1) {
                    if (!LevelPanel.this.canIncreaseHorizontalScreenNumber(LevelPanel.this.horizontalScreenNumber - 1) && !LevelPanel.this.canIncreaseVerticalScreenNumber(LevelPanel.this.verticalScreenNumber - 1)) {
                        LevelPanel.this.decreaseScreenNumber();
                    }
                    LevelPanel.this.update();
                }
                if (n == -2) {
                    LevelPanel.this.drawTiles();
                    LevelPanel.this.drawHiddenTiles();
                    LevelPanel.this.repaint();
                }
                if (n == -3) {
                    LevelPanel.this.resetScreenNumbers();
                }
                if (n == -4) {
                    LevelPanel.this.tileset.clearDirty();
                    LevelPanel.this.drawTiles();
                    LevelPanel.this.drawHiddenTiles();
                    LevelPanel.this.repaint();
                }
                if (n == -5) {
                    LevelPanel.this.palette.clearDirty();
                }
                if (LevelPanel.this.level instanceof BonusLevel && n <= -8) {
                    LevelPanel levelPanel = LevelPanel.this;
                    levelPanel.horizontalScreenNumber = levelPanel.horizontalScreenNumber + (LevelPanel.this.level.getStartHorizontalScreenNumber() + (n + 8));
                }
                return;
            }
            if (n >= 192) {
                LevelPanel.this.updateEntities();
                LevelPanel.this.setSelectedEntity(n - 192);
                LevelPanel.this.repaint();
                return;
            }
            boolean bl = LevelPanel.this.metaTileset.isShopEntrance(LevelPanel.this.layout[n]);
            boolean bl2 = LevelPanel.this.metaTileset.isJarEntrance(LevelPanel.this.layout[n]);
            LevelPanel.this.layout = LevelPanel.this.level.getLayout(LevelPanel.this.horizontalScreenNumber, LevelPanel.this.verticalScreenNumber);
            if (bl) {
                n -= n % 16;
                while (n + 1 < LevelPanel.this.layout.length && !LevelPanel.this.metaTileset.isShopEntrance(LevelPanel.this.layout[n])) {
                    ++n;
                }
            } else if (bl2) {
                n -= n % 16;
                while (n + 1 < LevelPanel.this.layout.length && !LevelPanel.this.metaTileset.isJarEntrance(LevelPanel.this.layout[n])) {
                    ++n;
                }
            }
            if (LevelPanel.this.metaTileset.isShopEntrance(LevelPanel.this.layout[n])) {
                int n2 = n;
                while (n2 % 16 > 0 && LevelPanel.this.metaTileset.isShopEntrance(LevelPanel.this.layout[n2 - 1])) {
                    --n2;
                }
                while (n2 + 16 < LevelPanel.this.layout.length && LevelPanel.this.metaTileset.isShopEntrance(LevelPanel.this.layout[n2 + 16])) {
                    n2 += 16;
                }
                int n3 = n2 / 16;
                n2 -= n3 * 16;
                n3 = LevelPanel.this.level.getScrollability() == 129 ? (n3 -= ((LevelPanel.this.horizontalScreenNumber > 0 ? LevelPanel.this.level.getMaxVerticalScreenNumber() : LevelPanel.this.verticalScreenNumber) - LevelPanel.this.level.getStartVerticalScreenNumber() + 1) * 2) : (n3 -= (LevelPanel.this.verticalScreenNumber - LevelPanel.this.level.getStartVerticalScreenNumber()) * 2);
                while (n3 < 0) {
                    n3 += 14;
                }
                int n4 = (n2 += n3 * 16) % 16 * 16;
                int n5 = n2 / 16 * 16 - 16;
                if (MiracleWorldEditorModel.isAlexWalkingToShopInGround()) {
                    n5 += 8;
                }
                LevelPanel.this.level.setShopEntrancePos(n5, n4);
            } else if (LevelPanel.this.metaTileset.isJarEntrance(LevelPanel.this.layout[n])) {
                int n6 = n;
                while (n6 % 16 > 0 && LevelPanel.this.metaTileset.isJarEntrance(LevelPanel.this.layout[n6 - 1])) {
                    --n6;
                }
                int n7 = n6 % 16 * 16 + 2;
                int n8 = n6 / 16 * 16 - 24;
                LevelPanel.this.level.setJarEntrancePos(n8, n7);
            }
            LevelPanel.this.drawTiles();
            LevelPanel.this.updateEntities();
            LevelPanel.this.repaint();
        }
    };

    public LevelPanel(Level level, MiracleWorldMetaTileset miracleWorldMetaTileset, Tileset tileset, LevelSpriteTileset levelSpriteTileset, LevelPalette levelPalette, SpriteContainer[] spriteContainerArray, EntityLabelProvider entityLabelProvider) {
        final Cursor cursor = this.getCursor();
        final Cursor cursor2 = Cursor.getPredefinedCursor(12);
        this.entityLabelProvider = entityLabelProvider;
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                int n = LevelPanel.this.toScreenX(mouseEvent.getX());
                int n2 = LevelPanel.this.toScreenY(mouseEvent.getY()) + 16;
                if (n < 0 || n2 < 0 || n >= LevelPanel.this.buffer.getWidth() || n2 >= LevelPanel.this.buffer.getHeight()) {
                    return;
                }
                n2 -= 16;
                if (LevelPanel.this.mode == 0) {
                    if (SwingUtilities.isLeftMouseButton(mouseEvent) || SwingUtilities.isRightMouseButton(mouseEvent)) {
                        LevelPanel.this.selectedEntity = -1;
                    }
                    int n3 = LevelPanel.this.entities.length - 1;
                    while (n3 >= 0) {
                        Entity entity = LevelPanel.this.entities[n3];
                        if (entity != null && entity.contains(n, n2) && LevelPanel.this.level.isEntityValid(n3)) {
                            LevelPanel.this.setSelectedEntity(n3);
                            if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                                TransactionManager.getInstance().startTransaction();
                                LevelPanel.this.level.startMovingEntity(n3);
                                LevelPanel.this.dragXoffset = n - entity.hPos;
                                LevelPanel.this.dragYoffset = n2 - entity.vPos;
                                LevelPanel.this.dragYstart = n2;
                                LevelPanel.this.dragXstart = n;
                                break;
                            }
                            if (!SwingUtilities.isRightMouseButton(mouseEvent)) break;
                            boolean[] blArray = new boolean[LevelPanel.this.entities.length];
                            int n4 = 1;
                            while (n4 < blArray.length) {
                                blArray[n4] = LevelPanel.this.level.isEntityValid(n4);
                                ++n4;
                            }
                            final int[] nArray = LevelPanel.this.level.getEntityData(n3);
                            final int[] nArray2 = new int[]{n3};
                            LevelPanel.this.setSelectedEntity(nArray2[0]);
                            if (nArray[0] != 36) {
                                MiracleWorldEditorModel.openModifyEntityDialog(LevelPanel.this.findOwner(), nArray, nArray2, blArray, LevelPanel.this.level.hasOctopusTentacle(), LevelPanel.this.spriteTileset, LevelPanel.this.palette);
                                final int n5 = n3;
                                TransactionManager.getInstance().runTransaction(new Runnable(){

                                    @Override
                                    public void run() {
                                        LevelPanel.this.level.setEntityData(n5, nArray);
                                        LevelPanel.this.level.setEntitySlot(LevelPanel.this.horizontalScreenNumber, LevelPanel.this.verticalScreenNumber, n5, nArray2[0]);
                                    }
                                });
                                LevelPanel.this.setSelectedEntity(nArray2[0]);
                                break;
                            }
                        }
                        --n3;
                    }
                    LevelPanel.this.repaint();
                } else if (LevelPanel.this.mode == 1 && SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    if (n >= LevelPanel.this.screen.getWidth() || n2 >= LevelPanel.this.screen.getHeight()) {
                        return;
                    }
                    LevelPanel.this.selectedTile = n2 / 16 * 16 + n / 16;
                    if (LevelPanel.this.selectedTile >= 0 && LevelPanel.this.selectedTile < 192) {
                        if (LevelPanel.this.editHiddenTiles) {
                            Runnable runnable = new Runnable(){

                                @Override
                                public void run() {
                                    int n = 0;
                                    while (n < LevelPanel.this.hiddenTilesData.length) {
                                        int n2 = LevelPanel.this.hiddenTilesData[n] / 32;
                                        n2 = LevelPanel.this.level.getScrollability() == 129 ? (n2 += ((LevelPanel.this.horizontalScreenNumber > 0 ? LevelPanel.this.level.getMaxVerticalScreenNumber() : LevelPanel.this.verticalScreenNumber) - LevelPanel.this.level.getStartVerticalScreenNumber() + 1) * 2) : (n2 += (LevelPanel.this.verticalScreenNumber - LevelPanel.this.level.getStartVerticalScreenNumber()) * 2);
                                        if (n2 < 0) {
                                            n2 += 14;
                                        }
                                        if (LevelPanel.this.selectedTile == n2 % 14 * 16 + LevelPanel.this.hiddenTilesData[n] % 16) {
                                            LevelPanel.this.level.removeHiddenTile(LevelPanel.this.horizontalScreenNumber, LevelPanel.this.verticalScreenNumber, n / 2);
                                        }
                                        n += 2;
                                    }
                                    if (LevelPanel.this.addHiddenTiles) {
                                        LevelPanel.this.level.addHiddenTile(LevelPanel.this.horizontalScreenNumber, LevelPanel.this.verticalScreenNumber, LevelPanel.this.selectedTile % 16, LevelPanel.this.selectedTile / 16, LevelPanel.this.selectedMetaTile);
                                    }
                                }
                            };
                            TransactionManager.getInstance().runTransaction(runnable);
                        } else if (mouseEvent.isAltDown()) {
                            LevelPanel.this.fireActionPerformed();
                        } else {
                            Runnable runnable = new Runnable(){

                                @Override
                                public void run() {
                                    boolean bl = LevelPanel.this.level.setMetaTile(LevelPanel.this.horizontalScreenNumber, LevelPanel.this.verticalScreenNumber, LevelPanel.this.selectedTile, LevelPanel.this.selectedMetaTile);
                                    if (!bl) {
                                        int n = LevelPanel.this.level.calcRequiredSize();
                                        int n2 = KiddEd.findFreeBlock(n, false);
                                        if (n2 < 0 && RomManager.StaticAccess.canExpand() && JOptionPane.showConfirmDialog(LevelPanel.this, TextProvider.get("MessageLevelExpand"), TextProvider.get("TitleExpand"), 0) == 0) {
                                            n2 = KiddEd.findFreeBlock(n, true);
                                        }
                                        if (n2 > 0) {
                                            LevelPanel.this.level.moveTo(n2);
                                            LevelPanel.this.level.setMetaTile(LevelPanel.this.horizontalScreenNumber, LevelPanel.this.verticalScreenNumber, LevelPanel.this.selectedTile, LevelPanel.this.selectedMetaTile);
                                        }
                                    }
                                }
                            };
                            TransactionManager.getInstance().runTransaction(runnable);
                        }
                    }
                }
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                if (LevelPanel.this.mode == 1) {
                    LevelPanel.this.selectedTile = -1;
                    LevelPanel.this.repaint();
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                int n = LevelPanel.this.toScreenX(mouseEvent.getX());
                int n2 = LevelPanel.this.toScreenY(mouseEvent.getY());
                if (n < 0 || n2 < -16 || n >= LevelPanel.this.buffer.getWidth() || n2 + 16 >= LevelPanel.this.buffer.getHeight()) {
                    return;
                }
                if (LevelPanel.this.mode == 0) {
                    if (n - LevelPanel.this.dragXoffset < 0 || n2 - LevelPanel.this.dragYoffset < -16) {
                        return;
                    }
                    if (mouseEvent.isShiftDown()) {
                        if (Math.abs(n - LevelPanel.this.dragXstart) > Math.abs(n2 - LevelPanel.this.dragYstart)) {
                            n2 = LevelPanel.this.dragYstart;
                        } else {
                            n = LevelPanel.this.dragXstart;
                        }
                    }
                    int n3 = 255;
                    if ((mouseEvent.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) != 0) {
                        n3 = 248;
                    }
                    if (LevelPanel.this.level.isEntityValid(LevelPanel.this.selectedEntity) && SwingUtilities.isLeftMouseButton(mouseEvent)) {
                        LevelPanel.this.level.setEntityPosition(LevelPanel.this.selectedEntity, n2 - LevelPanel.this.dragYoffset & n3, n - LevelPanel.this.dragXoffset & n3);
                        TransactionManager.getInstance().commit();
                    }
                } else if (LevelPanel.this.mode == 1) {
                    if (n >= LevelPanel.this.screen.getWidth() || n2 >= LevelPanel.this.screen.getHeight()) {
                        return;
                    }
                    LevelPanel.this.selectedTile = n2 / 16 * 16 + n / 16;
                    LevelPanel.this.repaint();
                    if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                        if (LevelPanel.this.editHiddenTiles) {
                            Runnable runnable = new Runnable(){

                                @Override
                                public void run() {
                                    int n = 0;
                                    while (n < LevelPanel.this.hiddenTilesData.length) {
                                        int n2 = LevelPanel.this.hiddenTilesData[n] / 32;
                                        n2 = LevelPanel.this.level.getScrollability() == 129 ? (n2 += ((LevelPanel.this.horizontalScreenNumber > 0 ? LevelPanel.this.level.getMaxVerticalScreenNumber() : LevelPanel.this.verticalScreenNumber) - LevelPanel.this.level.getStartVerticalScreenNumber() + 1) * 2) : (n2 += (LevelPanel.this.verticalScreenNumber - LevelPanel.this.level.getStartVerticalScreenNumber()) * 2);
                                        if (n2 < 0) {
                                            n2 += 14;
                                        }
                                        if (LevelPanel.this.selectedTile == n2 % 14 * 16 + LevelPanel.this.hiddenTilesData[n] % 16) {
                                            LevelPanel.this.level.removeHiddenTile(LevelPanel.this.horizontalScreenNumber, LevelPanel.this.verticalScreenNumber, n / 2);
                                        }
                                        n += 2;
                                    }
                                    if (LevelPanel.this.addHiddenTiles) {
                                        LevelPanel.this.level.addHiddenTile(LevelPanel.this.horizontalScreenNumber, LevelPanel.this.verticalScreenNumber, LevelPanel.this.selectedTile % 16, LevelPanel.this.selectedTile / 16, LevelPanel.this.selectedMetaTile);
                                    }
                                }
                            };
                            TransactionManager.getInstance().runTransaction(runnable);
                        } else if (mouseEvent.isAltDown()) {
                            LevelPanel.this.fireActionPerformed();
                        } else {
                            Runnable runnable = new Runnable(){

                                @Override
                                public void run() {
                                    boolean bl = LevelPanel.this.level.setMetaTile(LevelPanel.this.horizontalScreenNumber, LevelPanel.this.verticalScreenNumber, LevelPanel.this.selectedTile, LevelPanel.this.selectedMetaTile);
                                    if (!bl) {
                                        int n = LevelPanel.this.level.calcRequiredSize();
                                        int n2 = KiddEd.findFreeBlock(n, false);
                                        if (n2 < 0 && RomManager.StaticAccess.canExpand() && JOptionPane.showConfirmDialog(LevelPanel.this, TextProvider.get("MessageLevelExpand"), TextProvider.get("TitleExpand"), 0) == 0) {
                                            n2 = KiddEd.findFreeBlock(n, true);
                                        }
                                        if (n2 > 0) {
                                            LevelPanel.this.level.moveTo(n2);
                                            LevelPanel.this.level.setMetaTile(LevelPanel.this.horizontalScreenNumber, LevelPanel.this.verticalScreenNumber, LevelPanel.this.selectedTile, LevelPanel.this.selectedMetaTile);
                                        }
                                    }
                                }
                            };
                            TransactionManager.getInstance().runTransaction(runnable);
                        }
                    }
                }
            }

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                if (LevelPanel.this.mode == 0) {
                    int n = LevelPanel.this.toScreenX(mouseEvent.getX());
                    int n2 = LevelPanel.this.toScreenY(mouseEvent.getY());
                    int n3 = LevelPanel.this.entities.length - 1;
                    while (n3 >= 0) {
                        Entity entity = LevelPanel.this.entities[n3];
                        if (entity != null && entity.contains(n, n2) && LevelPanel.this.level.isEntityValid(n3)) {
                            LevelPanel.this.setCursor(cursor2);
                            LevelPanel.this.setToolTipText(entity.toString());
                            return;
                        }
                        --n3;
                    }
                } else if (LevelPanel.this.mode == 1) {
                    int n = LevelPanel.this.toScreenX(mouseEvent.getX());
                    int n4 = LevelPanel.this.toScreenY(mouseEvent.getY());
                    if (n < 0 || n4 < 0 || n >= LevelPanel.this.screen.getWidth() || n4 >= LevelPanel.this.screen.getHeight()) {
                        LevelPanel.this.selectedTile = -1;
                    } else {
                        LevelPanel.this.selectedTile = n4 / 16 * 16 + n / 16;
                    }
                    LevelPanel.this.repaint();
                }
                LevelPanel.this.setCursor(cursor);
                LevelPanel.this.setToolTipText(null);
            }
        });
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this.keyEventDispatcher);
        this.setTransferHandler(new TransferHandler(){

            @Override
            public boolean canImport(TransferHandler.TransferSupport transferSupport) {
                String[] stringArray;
                block14: {
                    Point point;
                    block13: {
                        block12: {
                            if (LevelPanel.this.additionalTransferHandler != null && LevelPanel.this.additionalTransferHandler.canImport(transferSupport)) {
                                return true;
                            }
                            if (!transferSupport.isDrop() || !transferSupport.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                                return false;
                            }
                            stringArray = ((String)transferSupport.getTransferable().getTransferData(DataFlavor.stringFlavor)).split(",");
                            if (stringArray.length == 3) break block12;
                            return false;
                        }
                        point = transferSupport.getDropLocation().getDropPoint();
                        point.x = LevelPanel.this.toScreenX(point.x);
                        point.y = LevelPanel.this.toScreenY(point.y);
                        if (point.x >= 0 && point.y >= -16 && point.x < LevelPanel.this.buffer.getWidth() && point.y + 16 < LevelPanel.this.buffer.getHeight()) break block13;
                        return false;
                    }
                    if (LevelPanel.this.maskEntityPositions) {
                        point.x &= 0xF8;
                        point.y &= 0xF8;
                    } else {
                        point.x = Math.max(0, point.x - 8);
                        point.y = Math.max(0, point.y - 8);
                    }
                    if (point.x < 256 && point.y < 256) break block14;
                    return false;
                }
                try {
                    try {
                        Integer.parseInt(stringArray[1], 16);
                        Integer.parseInt(stringArray[2], 16);
                        return LevelPanel.this.level.canAddEntity(LevelPanel.this.horizontalScreenNumber, LevelPanel.this.verticalScreenNumber, Integer.parseInt(stringArray[0], 16));
                    }
                    catch (NumberFormatException numberFormatException) {
                    }
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                    unsupportedFlavorException.printStackTrace();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                return false;
            }

            @Override
            public boolean importData(TransferHandler.TransferSupport transferSupport) {
                String[] stringArray;
                block10: {
                    if (LevelPanel.this.additionalTransferHandler != null && LevelPanel.this.additionalTransferHandler.canImport(transferSupport)) {
                        return LevelPanel.this.additionalTransferHandler.importData(transferSupport);
                    }
                    if (!transferSupport.isDrop() || !transferSupport.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                        return false;
                    }
                    stringArray = ((String)transferSupport.getTransferable().getTransferData(DataFlavor.stringFlavor)).split(",");
                    if (stringArray.length == 3) break block10;
                    return false;
                }
                try {
                    final int n = Integer.parseInt(stringArray[0], 16);
                    final int n2 = Integer.parseInt(stringArray[1], 16);
                    final int n3 = Integer.parseInt(stringArray[2], 16);
                    final Point point = transferSupport.getDropLocation().getDropPoint();
                    point.x = LevelPanel.this.toScreenX(point.x);
                    point.y = LevelPanel.this.toScreenY(point.y);
                    if (LevelPanel.this.maskEntityPositions) {
                        point.x &= 0xF8;
                        point.y &= 0xF8;
                    } else {
                        point.x = Math.max(0, point.x - 8);
                        point.y = Math.max(0, point.y - 8);
                    }
                    TransactionManager.getInstance().runTransaction(new Runnable(){

                        @Override
                        public void run() {
                            LevelPanel.this.level.addEntity(LevelPanel.this.horizontalScreenNumber, LevelPanel.this.verticalScreenNumber, n, n2, point.y, point.x, n3);
                        }
                    });
                    return true;
                }
                catch (NumberFormatException numberFormatException) {
                    try {
                    }
                    catch (UnsupportedFlavorException unsupportedFlavorException) {
                        unsupportedFlavorException.printStackTrace();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
                return false;
            }
        });
        this.setLayout(new BorderLayout());
        this.verticalScrollBar.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                if (LevelPanel.this.verticalScreenNumber < adjustmentEvent.getValue()) {
                    LevelPanel.this.increaseVerticalScreenNumber();
                } else if (LevelPanel.this.verticalScreenNumber > adjustmentEvent.getValue()) {
                    LevelPanel.this.decreaseVerticalScreenNumber();
                }
            }
        });
        this.add((Component)this.verticalScrollBar, "East");
        this.horizontalScrollBar.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                if (LevelPanel.this.horizontalScreenNumber < adjustmentEvent.getValue()) {
                    LevelPanel.this.increaseHorizontalScreenNumber();
                } else if (LevelPanel.this.horizontalScreenNumber > adjustmentEvent.getValue()) {
                    LevelPanel.this.decreaseHorizontalScreenNumber();
                }
            }
        });
        this.add((Component)this.horizontalScrollBar, "South");
        this.setLevel(level, miracleWorldMetaTileset, tileset, levelSpriteTileset, levelPalette, spriteContainerArray);
    }

    public void dispose() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this.keyEventDispatcher);
    }

    private JFrame findOwner() {
        Container container = this.getParent();
        while (container != null && !(container instanceof JFrame)) {
            container = container.getParent();
        }
        return (JFrame)container;
    }

    @Override
    public float getScale() {
        return this.scale;
    }

    @Override
    public Dimension getPreferredSize() {
        int n = this.horizontalScrollBar.getPreferredSize().height;
        int n2 = this.verticalScrollBar.getPreferredSize().width;
        return new Dimension((int)((float)this.buffer.getWidth() * this.getPreferredScale()) + n2, (int)((float)this.buffer.getHeight() * this.getPreferredScale()) + n);
    }

    public void setLevel(Level level, MiracleWorldMetaTileset miracleWorldMetaTileset, Tileset tileset, LevelSpriteTileset levelSpriteTileset, LevelPalette levelPalette, SpriteContainer[] spriteContainerArray) {
        int n;
        int n2;
        if (this.tileset != null && this.tileset != tileset) {
            this.tileset.removeChangeListener(this.tilesetChangeListener);
        }
        if (this.spriteTileset != null && this.spriteTileset != levelSpriteTileset) {
            this.spriteTileset.removeChangeListener(this.tilesetChangeListener);
        }
        if (this.palette != null && this.palette != levelPalette) {
            this.palette.removeChangeListener(this.paletteChangeListener);
        }
        if (this.metaTileset != null && this.metaTileset != miracleWorldMetaTileset) {
            this.metaTileset.removeChangeListener(this.metaTileChangeListener);
        }
        if (this.level != null && this.level != level) {
            this.level.removeChangeListener(this.levelChangeListener);
        }
        if (this.sprites != null) {
            SpriteContainer[] spriteContainerArray2 = this.sprites;
            n2 = this.sprites.length;
            n = 0;
            while (n < n2) {
                SpriteContainer spriteContainer = spriteContainerArray2[n];
                spriteContainer.removeChangeListener(this.spriteChangeListener);
                ++n;
            }
        }
        this.tileset = tileset;
        this.spriteTileset = levelSpriteTileset;
        this.palette = levelPalette;
        this.metaTileset = miracleWorldMetaTileset;
        this.level = level;
        this.sprites = spriteContainerArray;
        int n3 = 0;
        Object[] objectArray = levelPalette.getColors();
        int n4 = objectArray.length;
        n2 = 0;
        while (n2 < n4) {
            n = objectArray[n2];
            int n5 = (n & 0x30) >> 4;
            int n6 = (n & 0xC) >> 2;
            int n7 = n & 3;
            this.colors[n3++] = new Color(n7 * 255 / 3, n6 * 255 / 3, n5 * 255 / 3);
            ++n2;
        }
        n3 = 0;
        while (n3 < this.colors.length) {
            this.transparentColors[n3] = new Color(this.colors[n3].getRed(), this.colors[n3].getGreen(), this.colors[n3].getBlue(), 128);
            ++n3;
        }
        tileset.addChangeListener(this.tilesetChangeListener);
        levelSpriteTileset.addChangeListener(this.tilesetChangeListener);
        levelPalette.addChangeListener(this.paletteChangeListener);
        miracleWorldMetaTileset.addChangeListener(this.metaTileChangeListener);
        level.addChangeListener(this.levelChangeListener);
        objectArray = spriteContainerArray;
        n4 = spriteContainerArray.length;
        n2 = 0;
        while (n2 < n4) {
            int n8 = objectArray[n2];
            n8.addChangeListener(this.spriteChangeListener);
            ++n2;
        }
        this.horizontalScreenNumber = level.getStartHorizontalScreenNumber() - 1;
        this.verticalScreenNumber = level.getStartVerticalScreenNumber();
        if (level.getScrollability() == 129) {
            --this.verticalScreenNumber;
        }
        this.update();
    }

    public int getSelectedTileMetaTile() {
        return this.layout[this.selectedTile];
    }

    public boolean canSetStartScreen() {
        return this.level.canSetStartScreen();
    }

    public void setStartScreen() {
        TransactionManager.getInstance().runTransaction(new Runnable(){

            @Override
            public void run() {
                LevelPanel.this.level.setStartScreen(LevelPanel.this.horizontalScreenNumber, LevelPanel.this.verticalScreenNumber);
            }
        });
        this.updateEntities();
        this.updateScrollBars();
        this.repaint();
    }

    public boolean canRemoveSelectedEntity() {
        return this.level.isEntityValid(this.selectedEntity);
    }

    public void setSelectedEntity(int n) {
        if (this.level.isEntityValid(n)) {
            this.selectedEntity = n;
        }
        if (!this.level.isEntityValid(this.selectedEntity)) {
            this.selectedEntity = -1;
        }
        this.repaint();
    }

    public void removeSelectedEntity() {
        if (!this.canRemoveSelectedEntity()) {
            return;
        }
        TransactionManager.getInstance().runTransaction(new Runnable(){

            @Override
            public void run() {
                LevelPanel.this.level.removeEntity(LevelPanel.this.selectedEntity);
            }
        });
        this.selectedEntity = -1;
        this.updateEntities();
        this.repaint();
    }

    public boolean canCopySelectedEntity() {
        return this.level.isEntityValid(this.selectedEntity);
    }

    public void copySelectedEntityToClipboard() {
        String string;
        if (!this.canCopySelectedEntity()) {
            return;
        }
        int[] nArray = this.level.getEntityData(this.selectedEntity);
        final String string2 = string = String.format("%X,%X,%X,%X,%X", Math.min(6, this.selectedEntity), nArray[0], nArray[3], nArray[1], nArray[2]);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(new Transferable(){

            @Override
            public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
                return DataFlavor.stringFlavor.equals(dataFlavor);
            }

            @Override
            public DataFlavor[] getTransferDataFlavors() {
                return new DataFlavor[]{DataFlavor.stringFlavor};
            }

            @Override
            public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
                if (!this.isDataFlavorSupported(dataFlavor)) {
                    throw new UnsupportedFlavorException(dataFlavor);
                }
                return string2;
            }
        }, null);
    }

    public boolean canPasteEntityFromClipboard() {
        block7: {
            String[] stringArray;
            block8: {
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                if (!clipboard.isDataFlavorAvailable(DataFlavor.stringFlavor)) break block7;
                stringArray = ((String)clipboard.getData(DataFlavor.stringFlavor)).split(",");
                if (stringArray.length == 5) break block8;
                return false;
            }
            try {
                try {
                    Integer.parseInt(stringArray[1], 16);
                    Integer.parseInt(stringArray[2], 16);
                    Integer.parseInt(stringArray[3], 16);
                    Integer.parseInt(stringArray[4], 16);
                    return this.level.canAddEntity(this.horizontalScreenNumber, this.verticalScreenNumber, Integer.parseInt(stringArray[0], 16));
                }
                catch (NumberFormatException numberFormatException) {
                }
            }
            catch (IllegalStateException illegalStateException) {
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                unsupportedFlavorException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return false;
    }

    public void pasteEntityFromClipboard() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        try {
            if (clipboard.isDataFlavorAvailable(DataFlavor.stringFlavor)) {
                String[] stringArray = ((String)clipboard.getData(DataFlavor.stringFlavor)).split(",");
                if (stringArray.length != 5) {
                    return;
                }
                try {
                    final int n = Integer.parseInt(stringArray[0], 16);
                    final int n2 = Integer.parseInt(stringArray[1], 16);
                    final int n3 = Integer.parseInt(stringArray[2], 16);
                    final int n4 = Integer.parseInt(stringArray[3], 16);
                    final int n5 = Integer.parseInt(stringArray[4], 16);
                    TransactionManager.getInstance().runTransaction(new Runnable(){

                        @Override
                        public void run() {
                            LevelPanel.this.setSelectedEntity(LevelPanel.this.level.addEntity(LevelPanel.this.horizontalScreenNumber, LevelPanel.this.verticalScreenNumber, n, n2, n4, n5, n3));
                        }
                    });
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            unsupportedFlavorException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public boolean canCopyLayoutToClipboard() {
        return true;
    }

    public void copyLayoutToClipboard() {
        String string = Integer.toHexString(this.layout[0]).toUpperCase();
        int n = 1;
        while (n < this.layout.length) {
            string = String.valueOf(string) + String.format(",%X", this.layout[n]);
            ++n;
        }
        final String string2 = string;
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(new Transferable(){

            @Override
            public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
                return DataFlavor.stringFlavor.equals(dataFlavor);
            }

            @Override
            public DataFlavor[] getTransferDataFlavors() {
                return new DataFlavor[]{DataFlavor.stringFlavor};
            }

            @Override
            public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
                if (!this.isDataFlavorSupported(dataFlavor)) {
                    throw new UnsupportedFlavorException(dataFlavor);
                }
                return string2;
            }
        }, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canPasteLayoutFromClipboard() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        if (!clipboard.isDataFlavorAvailable(DataFlavor.stringFlavor)) return false;
        String[] stringArray = ((String)clipboard.getData(DataFlavor.stringFlavor)).split(",");
        try {
            String[] stringArray2 = stringArray;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray2[n2];
                Integer.parseInt(string, 16);
                ++n2;
            }
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            try {
                return false;
            }
            catch (IllegalStateException illegalStateException) {
                return false;
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                unsupportedFlavorException.printStackTrace();
                return false;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return false;
    }

    public void pasteLayoutFromClipboard() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        try {
            if (clipboard.isDataFlavorAvailable(DataFlavor.stringFlavor)) {
                String[] stringArray = ((String)clipboard.getData(DataFlavor.stringFlavor)).split(",");
                try {
                    final int[] nArray = new int[Math.min(192, stringArray.length)];
                    int n = 0;
                    while (n < nArray.length) {
                        nArray[n] = Integer.parseInt(stringArray[n], 16);
                        ++n;
                    }
                    TransactionManager.getInstance().runTransaction(new Runnable(){

                        @Override
                        public void run() {
                            LevelPanel.this.setLayout(nArray);
                        }
                    });
                }
                catch (NumberFormatException numberFormatException) {
                    numberFormatException.printStackTrace();
                }
            }
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            unsupportedFlavorException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void setLayout(int[] nArray) {
        boolean bl = this.level.setLayout(this.horizontalScreenNumber, this.verticalScreenNumber, nArray);
        if (!bl) {
            int n = this.level.calcRequiredSize();
            int n2 = KiddEd.findFreeBlock(n, false);
            if (n2 < 0 && RomManager.StaticAccess.canExpand() && JOptionPane.showConfirmDialog(this, TextProvider.get("MessageLevelExpand"), TextProvider.get("TitleExpand"), 0) == 0) {
                n2 = KiddEd.findFreeBlock(n, true);
            }
            if (n2 > 0) {
                this.level.moveTo(n2);
                this.level.setLayout(this.horizontalScreenNumber, this.verticalScreenNumber, nArray);
            }
        }
    }

    public boolean canCopyCurrentScreenToClipboard() {
        return true;
    }

    public void copyCurrentScreenToClipboard() {
        String string = Integer.toHexString(this.layout[0]).toUpperCase();
        int n = 1;
        while (n < this.layout.length) {
            string = String.valueOf(string) + String.format(",%X", this.layout[n]);
            ++n;
        }
        int[] nArray = this.level.getEntityScreenData(this.horizontalScreenNumber, this.verticalScreenNumber);
        int n2 = 0;
        while (n2 < nArray.length) {
            string = String.valueOf(string) + String.format(",%X", nArray[n2]);
            ++n2;
        }
        final String string2 = string;
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(new Transferable(){

            @Override
            public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
                return DataFlavor.stringFlavor.equals(dataFlavor);
            }

            @Override
            public DataFlavor[] getTransferDataFlavors() {
                return new DataFlavor[]{DataFlavor.stringFlavor};
            }

            @Override
            public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
                if (!this.isDataFlavorSupported(dataFlavor)) {
                    throw new UnsupportedFlavorException(dataFlavor);
                }
                return string2;
            }
        }, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean canPasteScreenFromClipboard() {
        if (!this.level.canAddScreen(this.horizontalScreenNumber, this.verticalScreenNumber)) {
            return false;
        }
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        try {
            if (!clipboard.isDataFlavorAvailable(DataFlavor.stringFlavor)) return false;
            String[] stringArray = ((String)clipboard.getData(DataFlavor.stringFlavor)).split(",");
            if (stringArray.length < 193) {
                return false;
            }
            try {
                String[] stringArray2 = stringArray;
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String string = stringArray2[n2];
                    Integer.parseInt(string, 16);
                    ++n2;
                }
                int n3 = 192;
                n2 = Integer.parseInt(stringArray[n3++], 16);
                n = 0;
                while ((n2 & 0x80) != 0) {
                    if ((n2 & 0xFFFFFF70) != 0) {
                        return false;
                    }
                    if ((n2 & 5) != 0) {
                        n3 += 4;
                    } else if ((n2 & 2) != 0) {
                        ++n3;
                        if ((n += 8) > 10) {
                            return false;
                        }
                    } else if (n3 < stringArray.length) {
                        n3 += Integer.parseInt(stringArray[n3], 16) + 1;
                    }
                    if (n3 >= stringArray.length) {
                        return false;
                    }
                    n2 = Integer.parseInt(stringArray[n3++], 16);
                }
                if ((n += n2) > 10) return false;
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
        catch (IllegalStateException illegalStateException) {
            return false;
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            unsupportedFlavorException.printStackTrace();
            return false;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return false;
    }

    public void pasteScreenFromClipboard() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        try {
            if (clipboard.isDataFlavorAvailable(DataFlavor.stringFlavor)) {
                String[] stringArray = ((String)clipboard.getData(DataFlavor.stringFlavor)).split(",");
                if (stringArray.length < 193) {
                    return;
                }
                try {
                    final int[] nArray = new int[192];
                    final int[] nArray2 = new int[stringArray.length - 192];
                    int n = 0;
                    while (n < nArray.length) {
                        nArray[n] = Integer.parseInt(stringArray[n], 16);
                        ++n;
                    }
                    n = 0;
                    while (n < nArray2.length) {
                        nArray2[n] = Integer.parseInt(stringArray[192 + n], 16);
                        ++n;
                    }
                    TransactionManager.getInstance().runTransaction(new Runnable(){

                        @Override
                        public void run() {
                            LevelPanel.this.level.addScreen(LevelPanel.this.horizontalScreenNumber, LevelPanel.this.verticalScreenNumber, nArray, nArray2);
                        }
                    });
                }
                catch (NumberFormatException numberFormatException) {
                    numberFormatException.printStackTrace();
                }
            }
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            unsupportedFlavorException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public boolean canAddScreen() {
        return this.level.canAddScreen(this.horizontalScreenNumber, this.verticalScreenNumber);
    }

    public void addScreen() {
        if (!this.canAddScreen()) {
            return;
        }
        TransactionManager.getInstance().runTransaction(new Runnable(){

            @Override
            public void run() {
                if (LevelPanel.this.level.addScreen(LevelPanel.this.horizontalScreenNumber, LevelPanel.this.verticalScreenNumber)) {
                    LevelPanel.this.update();
                } else {
                    JOptionPane.showMessageDialog(LevelPanel.this, TextProvider.get("MessageCannotAddScreen"), TextProvider.get("TitleCannotAddScreen"), 0);
                }
            }
        });
    }

    public boolean canRemoveCurrentScreen() {
        return this.level.canRemoveScreen(this.horizontalScreenNumber, this.verticalScreenNumber);
    }

    public void removeCurrentScreen() {
        if (!this.canRemoveCurrentScreen()) {
            return;
        }
        TransactionManager.getInstance().runTransaction(new Runnable(){

            @Override
            public void run() {
                if (LevelPanel.this.level.removeScreen(LevelPanel.this.horizontalScreenNumber, LevelPanel.this.verticalScreenNumber) && !LevelPanel.this.canIncreaseHorizontalScreenNumber(LevelPanel.this.horizontalScreenNumber - 1) && !LevelPanel.this.canIncreaseVerticalScreenNumber(LevelPanel.this.verticalScreenNumber - 1)) {
                    LevelPanel.this.decreaseScreenNumber();
                }
            }
        });
        this.update();
    }

    public void resetScreenNumbers() {
        this.horizontalScreenNumber = this.level.getStartHorizontalScreenNumber() - 1;
        this.verticalScreenNumber = this.level.getStartVerticalScreenNumber();
        if (this.level.getScrollability() == 129) {
            --this.verticalScreenNumber;
        }
        this.update();
    }

    public void printLevelDescriptor() {
        System.out.println(this.level);
        System.out.println();
    }

    public void printPointers() {
        this.level.printPointers(this.horizontalScreenNumber, this.verticalScreenNumber);
    }

    public void printLevelData() {
        this.level.printLevelData();
    }

    public void printEntityData() {
        this.level.printEntityData(this.horizontalScreenNumber, this.verticalScreenNumber);
    }

    public void increaseHorizontalScreenNumber() {
        if (this.canIncreaseHorizontalScreenNumber(this.horizontalScreenNumber)) {
            if ((this.level.getScrollability() & 1) != 0 && this.verticalScreenNumber == this.level.getMaxVerticalScreenNumber()) {
                this.verticalScreenNumber = 0;
            }
            ++this.horizontalScreenNumber;
            this.update();
        }
    }

    private boolean canIncreaseHorizontalScreenNumber(int n) {
        if (n < 0) {
            return false;
        }
        if ((this.level.getScrollability() & 0x40) != 0 && this.verticalScreenNumber > 0) {
            return n < 3;
        }
        if ((this.level.getScrollability() & 0x20) != 0 && this.verticalScreenNumber > 0) {
            return n < 1;
        }
        if (this.level.getScrollability() == 128) {
            return this.level.isValidScreen(n + 1, this.verticalScreenNumber);
        }
        if (this.level.getScrollability() == 129) {
            return n < this.level.getMaxHorizontalScreenNumber() && (n != 0 || this.verticalScreenNumber == this.level.getMaxVerticalScreenNumber());
        }
        return (this.level.getScrollability() & 8) != 0 && n < this.level.getMaxHorizontalScreenNumber() || (this.level.getScrollability() & 4) != 0 && n < this.level.getStartHorizontalScreenNumber() - 1;
    }

    public boolean canDecreaseHorizontalScreenNumber(int n) {
        if (this.level instanceof BonusLevel) {
            return n >= this.level.getStartHorizontalScreenNumber();
        }
        return n > 0 && (this.level.getScrollability() != 128 || this.level.isValidScreen(n - 1, this.verticalScreenNumber));
    }

    public void decreaseHorizontalScreenNumber() {
        if (this.canDecreaseHorizontalScreenNumber(this.horizontalScreenNumber)) {
            --this.horizontalScreenNumber;
            if ((this.level.getScrollability() & 1) != 0 && this.horizontalScreenNumber == 0 && this.verticalScreenNumber == 0) {
                this.verticalScreenNumber = this.level.getMaxVerticalScreenNumber();
            }
            this.update();
        }
    }

    public void increaseVerticalScreenNumber() {
        if (this.canIncreaseVerticalScreenNumber(this.verticalScreenNumber)) {
            if ((this.level.getScrollability() & 0x40) != 0) {
                this.horizontalScreenNumber >>= 2;
            }
            if ((this.level.getScrollability() & 0x20) != 0) {
                this.horizontalScreenNumber = 0;
            }
            ++this.verticalScreenNumber;
            while (this.horizontalScreenNumber > 0 && !this.canIncreaseHorizontalScreenNumber(this.horizontalScreenNumber - 1)) {
                --this.horizontalScreenNumber;
            }
            this.update();
        } else if (!this.canDecreaseVerticalScreenNumber(this.verticalScreenNumber) && this.canIncreaseHorizontalScreenNumber(this.horizontalScreenNumber)) {
            this.increaseHorizontalScreenNumber();
        }
    }

    public void decreaseVerticalScreenNumber() {
        if (this.canDecreaseVerticalScreenNumber(this.verticalScreenNumber)) {
            --this.verticalScreenNumber;
            while (this.horizontalScreenNumber > 0 && !this.canIncreaseHorizontalScreenNumber(this.horizontalScreenNumber - 1)) {
                --this.horizontalScreenNumber;
            }
            this.update();
        } else if (!this.canIncreaseVerticalScreenNumber(this.verticalScreenNumber) && this.canDecreaseHorizontalScreenNumber(this.horizontalScreenNumber)) {
            this.decreaseHorizontalScreenNumber();
        }
    }

    private boolean canIncreaseVerticalScreenNumber(int n) {
        if (n < 0) {
            return false;
        }
        if (this.level.getScrollability() == 128) {
            return this.level.isValidScreen(this.horizontalScreenNumber, n + 1);
        }
        if (this.level.getScrollability() == 129 && this.horizontalScreenNumber > 0) {
            return false;
        }
        return (this.level.getScrollability() & 0xE1) != 0 && n < this.level.getMaxVerticalScreenNumber();
    }

    private boolean canDecreaseVerticalScreenNumber(int n) {
        return n > 0 && (this.level.getScrollability() != 128 || this.level.isValidScreen(this.horizontalScreenNumber, n - 1));
    }

    public void increaseScreenNumber() {
        if (this.canIncreaseHorizontalScreenNumber(this.horizontalScreenNumber)) {
            this.increaseHorizontalScreenNumber();
        } else if (this.canIncreaseVerticalScreenNumber(this.verticalScreenNumber)) {
            this.increaseVerticalScreenNumber();
            while (this.canDecreaseHorizontalScreenNumber(this.horizontalScreenNumber)) {
                this.decreaseHorizontalScreenNumber();
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void decreaseScreenNumber() {
        block5: {
            block6: {
                block4: {
                    if (!this.canDecreaseHorizontalScreenNumber(this.horizontalScreenNumber)) break block4;
                    this.decreaseHorizontalScreenNumber();
                    break block5;
                }
                if (!this.canDecreaseVerticalScreenNumber(this.verticalScreenNumber)) break block6;
                this.decreaseVerticalScreenNumber();
                while (this.canIncreaseHorizontalScreenNumber(this.horizontalScreenNumber)) {
                    this.increaseHorizontalScreenNumber();
                }
                break block5;
            }
            if ((this.level.getScrollability() & 128) == 0) break block5;
            var1_1 = this.horizontalScreenNumber;
            while (this.canIncreaseHorizontalScreenNumber(this.horizontalScreenNumber) && !this.canDecreaseVerticalScreenNumber(this.verticalScreenNumber)) {
                this.increaseHorizontalScreenNumber();
            }
            if (!this.canDecreaseVerticalScreenNumber(this.verticalScreenNumber)) ** GOTO lbl24
            this.decreaseVerticalScreenNumber();
            while (this.canIncreaseHorizontalScreenNumber(this.horizontalScreenNumber)) {
                this.increaseHorizontalScreenNumber();
            }
            break block5;
lbl-1000:
            // 1 sources

            {
                this.decreaseHorizontalScreenNumber();
lbl24:
                // 2 sources

                ** while (this.horizontalScreenNumber > var1_1)
            }
        }
    }

    public void setMode(int n) {
        this.mode = n;
        this.addHiddenTiles = false;
        this.editHiddenTiles = false;
        this.selectedTile = -1;
        this.selectedEntity = -1;
    }

    public int getMode() {
        return this.mode;
    }

    public void setShowTileAttributes(boolean bl) {
        this.showTileAttributes = bl;
        this.drawTiles();
        this.repaint();
    }

    private int toScreenX(int n) {
        return Math.round((float)(n - this.offsetX) / this.scale);
    }

    private int toScreenY(int n) {
        return Math.round((float)(n - this.offsetY) / this.scale) - 16;
    }

    public void setSelectedMetaTile(int n) {
        this.selectedMetaTile = n;
    }

    private void update() {
        this.layout = this.level.getLayout(this.horizontalScreenNumber, this.verticalScreenNumber);
        if (this.verticalScreenNumber > 0 && this.verticalScreenNumber < this.level.getMaxVerticalScreenNumber()) {
            this.level.getLayout(this.horizontalScreenNumber, this.verticalScreenNumber + 1);
        }
        this.drawTiles();
        this.selectedEntity = -1;
        this.updateEntities();
        this.updateScrollBars();
        this.repaint();
    }

    private void updateScrollBars() {
        this.horizontalScrollBar.setEnabled(this.canIncreaseHorizontalScreenNumber(this.horizontalScreenNumber) || this.canDecreaseHorizontalScreenNumber(this.horizontalScreenNumber));
        int n = this.horizontalScreenNumber;
        while (n > 0 && this.canDecreaseHorizontalScreenNumber(n)) {
            --n;
        }
        int n2 = this.horizontalScreenNumber;
        while (n2 < 256 && this.canIncreaseHorizontalScreenNumber(n2)) {
            ++n2;
        }
        this.horizontalScrollBar.setValues(this.horizontalScreenNumber, 1, n, n2 + 1);
        this.verticalScrollBar.setEnabled(this.canIncreaseVerticalScreenNumber(this.verticalScreenNumber) || this.canDecreaseVerticalScreenNumber(this.verticalScreenNumber));
        n = this.verticalScreenNumber;
        while (n > 0 && this.canDecreaseVerticalScreenNumber(n)) {
            --n;
        }
        n2 = this.verticalScreenNumber;
        while (n2 < 256 && this.canIncreaseVerticalScreenNumber(n2)) {
            ++n2;
        }
        this.verticalScrollBar.setValues(this.verticalScreenNumber, 1, n, n2 + 1);
    }

    private void drawTiles() {
        int[] nArray = this.tileset.getVRAM();
        int[][] nArray2 = this.metaTileset.getMetaTiles();
        Graphics2D graphics2D = this.screen.createGraphics();
        int n = 0;
        while (n < 12) {
            int n2 = 0;
            while (n2 < 16) {
                int[] nArray3 = nArray2[this.layout[n * 16 + n2]];
                Renderer.renderMetaTile(nArray, nArray3, n2 * 16, n * 16, this.showTileAttributes, this.colors, graphics2D);
                int n3 = this.level.getShopEntranceNameTablePos() / 64;
                n3 = this.level.getScrollability() == 129 ? (n3 += ((this.horizontalScreenNumber > 0 ? this.level.getMaxVerticalScreenNumber() : this.verticalScreenNumber) - this.level.getStartVerticalScreenNumber() + 1) * 4) : (n3 += (this.verticalScreenNumber - this.level.getStartVerticalScreenNumber()) * 4);
                if (n3 < 0) {
                    n3 += 28;
                }
                int n4 = 0;
                while (n4 < 4) {
                    Graphics2D graphics2D2;
                    if (this.showTileAttributes && nArray3[n4 * 2 + 1] >> 5 == 3 && nArray3[n4 * 2] >= RomManager.StaticAccess.readByte(15573) && n2 * 16 + n4 % 2 * 8 >= 24) {
                        graphics2D2 = this.screen.createGraphics();
                        graphics2D2.setColor(Color.YELLOW);
                        if (n * 16 + n4 / 2 * 8 >= n3 % 28 * 8 && n * 16 + n4 / 2 * 8 < n3 % 28 * 8 + 32) {
                            graphics2D2.drawLine(this.level.getShopEntranceHpos(), n * 16 + n4 / 2 * 8, this.level.getShopEntranceHpos(), n * 16 + n4 / 2 * 8 + 8);
                        }
                        graphics2D2.dispose();
                    } else if (this.showTileAttributes && nArray3[n4 * 2 + 1] >> 5 == 5 && nArray3[n4 * 2] > 63) {
                        graphics2D2 = this.screen.createGraphics();
                        graphics2D2.setColor(Color.GREEN);
                        if (n * 16 + n4 / 2 * 8 - 24 >= n3 * 8 && n * 16 + n4 / 2 * 8 - 24 < n3 * 8 + 16) {
                            graphics2D2.drawLine(this.level.getShopEntranceHpos(), n * 16 + n4 / 2 * 8, this.level.getShopEntranceHpos(), n * 16 + n4 / 2 * 8 + 8);
                        }
                        graphics2D2.dispose();
                    }
                    ++n4;
                }
                if (!this.metaTileset.isUsable(this.layout[n * 16 + n2], this.tileset)) {
                    Graphics2D graphics2D3 = this.screen.createGraphics();
                    graphics2D3.setColor(Color.RED);
                    graphics2D3.setStroke(new BasicStroke(2.0f));
                    graphics2D3.drawLine(n2 * 16 + 1, n * 16 + 1, n2 * 16 + 14, n * 16 + 14);
                    graphics2D3.dispose();
                }
                ++n2;
            }
            ++n;
        }
        graphics2D.dispose();
    }

    private void updateEntities() {
        this.spriteTileset.updateMemory();
        int[][] nArray = this.level.getSAT(this.horizontalScreenNumber, this.verticalScreenNumber);
        this.sat = nArray[0];
        this.hiddenTilesData = nArray[1];
        this.entities = new Entity[30];
        int n = 6;
        while (n < 64 && this.sat[n] != 208) {
            int n2;
            if (this.entities[this.level.getEntityIndex(n)] == null) {
                this.entities[this.level.getEntityIndex((int)n)] = new Entity(this.level.getEntityData(this.level.getEntityIndex(n)));
            }
            if ((n2 = this.sat[n] + 1) >= 240) {
                n2 -= 256;
            }
            int n3 = this.sat[0x80 | n << 1];
            if (n2 < this.entities[this.level.getEntityIndex((int)n)].top) {
                this.entities[this.level.getEntityIndex((int)n)].top = n2;
            }
            if (n2 + 8 > this.entities[this.level.getEntityIndex((int)n)].bottom) {
                this.entities[this.level.getEntityIndex((int)n)].bottom = n2 + 8;
            }
            if (n3 < this.entities[this.level.getEntityIndex((int)n)].left) {
                this.entities[this.level.getEntityIndex((int)n)].left = n3;
            }
            if (n3 + 8 > this.entities[this.level.getEntityIndex((int)n)].right) {
                this.entities[this.level.getEntityIndex((int)n)].right = n3 + 8;
            }
            ++n;
        }
        n = 1;
        while (n < this.entities.length) {
            if (this.entities[n] == null && this.level.isEntityValid(n)) {
                this.entities[n] = new Entity(this.level.getEntityData(n));
                this.entities[n].imageEmpty = true;
                this.entities[n].left = this.entities[n].hPos;
                this.entities[n].right = this.entities[n].hPos;
                this.entities[n].top = this.entities[n].vPos;
                this.entities[n].bottom = this.entities[n].vPos;
            }
            ++n;
        }
        this.drawEntities();
        this.drawHiddenTiles();
    }

    private void drawEntities() {
        Object object;
        int n;
        int n2;
        int[] nArray = this.spriteTileset.getVRAM();
        int n3 = 6;
        while (n3 < 64 && this.sat[n3] != 208) {
            n2 = this.sat[n3] + 1;
            if (n2 >= 240) {
                n2 -= 256;
            }
            n = this.sat[0x80 | n3 << 1];
            int n4 = this.sat[0x80 | n3 << 1 | 1];
            object = this.entities[this.level.getEntityIndex(n3)];
            if (((Entity)object).image == null) {
                int n5 = ((Entity)object).right - ((Entity)object).left;
                int n6 = ((Entity)object).bottom - ((Entity)object).top;
                ((Entity)object).image = new BufferedImage(n5, n6, 2);
                ((Entity)object).imageEmpty = true;
            }
            if (Renderer.renderSpriteCharacter(nArray, n4, n - ((Entity)object).left, n2 - ((Entity)object).top, this.colors, ((Entity)object).image)) {
                ((Entity)object).imageEmpty = false;
            }
            ++n3;
        }
        Entity[] entityArray = this.entities;
        n = this.entities.length;
        n2 = 0;
        while (n2 < n) {
            Entity entity = entityArray[n2];
            if (entity != null && entity.imageEmpty) {
                if (entity.right - entity.left <= 16 || entity.bottom - entity.top <= 14) {
                    if (entity.right - entity.left <= 16) {
                        entity.right = entity.left + 16;
                    }
                    if (entity.bottom - entity.top <= 14) {
                        entity.bottom = entity.top + 14;
                    }
                    entity.image = new BufferedImage(entity.right - entity.left, entity.bottom - entity.top, 2);
                }
                object = entity.image.createGraphics();
                ((Graphics)object).setColor(new Color(0.5f, 0.5f, 0.5f, 0.5f));
                ((Graphics)object).fillRect(0, 0, 16, 12);
                ((Graphics)object).setColor(Color.RED);
                ((Graphics2D)object).drawString(String.format("%02X", entity.type), 0, 10);
                ((Graphics)object).dispose();
            }
            ++n2;
        }
    }

    public boolean isEditHiddenTiles() {
        return this.editHiddenTiles;
    }

    public void setEditHiddenTiles(boolean bl, boolean bl2) {
        this.editHiddenTiles = bl;
        this.addHiddenTiles = bl2;
        this.drawHiddenTiles();
        this.repaint();
    }

    private void drawHiddenTiles() {
        if (this.hiddenTilesData.length > 0) {
            Graphics2D graphics2D = this.hiddenTiles.createGraphics();
            graphics2D.setComposite(AlphaComposite.Clear);
            graphics2D.fillRect(0, 0, this.hiddenTiles.getWidth(), this.hiddenTiles.getHeight());
            graphics2D.dispose();
            int[] nArray = this.tileset.getVRAM();
            int[][] nArray2 = this.metaTileset.getMetaTiles();
            Graphics2D graphics2D2 = this.hiddenTiles.createGraphics();
            int n = 0;
            while (n < this.hiddenTilesData.length) {
                int n2 = this.hiddenTilesData[n] / 32;
                n2 = this.level.getScrollability() == 129 ? (n2 += ((this.horizontalScreenNumber > 0 ? this.level.getMaxVerticalScreenNumber() : this.verticalScreenNumber) - this.level.getStartVerticalScreenNumber() + 1) * 2) : (n2 += (this.verticalScreenNumber - this.level.getStartVerticalScreenNumber()) * 2);
                if (n2 < 0) {
                    n2 += 14;
                }
                int n3 = this.hiddenTilesData[n] % 16;
                Renderer.renderMetaTile(nArray, nArray2[this.hiddenTilesData[n + 1]], n3 * 16, n2 % 14 * 16, false, this.editHiddenTiles ? this.colors : this.transparentColors, graphics2D2);
                n += 2;
            }
            graphics2D2.dispose();
        }
    }

    public void setAdditionalTransferHandler(TransferHandler transferHandler) {
        this.additionalTransferHandler = transferHandler;
    }

    protected final void fireActionPerformed() {
        for (ActionListener actionListener : this.listeners) {
            actionListener.actionPerformed(null);
        }
    }

    public final void addActionListener(ActionListener actionListener) {
        if (!this.listeners.contains(actionListener)) {
            this.listeners.add(actionListener);
        }
    }

    public final void removeActionListener(ActionListener actionListener) {
        this.listeners.remove(actionListener);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        int n;
        int n2;
        super.paintComponent(graphics);
        Graphics2D graphics2D = this.buffer.createGraphics();
        Composite composite = graphics2D.getComposite();
        graphics2D.setComposite(AlphaComposite.Clear);
        graphics2D.fillRect(0, 0, this.buffer.getWidth(), this.buffer.getHeight());
        graphics2D.setComposite(composite);
        graphics2D.drawImage((Image)this.screen, 0, 16, null);
        if (this.hiddenTilesData.length > 0) {
            graphics2D.drawImage((Image)this.hiddenTiles, 0, 16, null);
            if (this.editHiddenTiles) {
                int n3 = 0;
                while (n3 < this.hiddenTilesData.length) {
                    n2 = this.hiddenTilesData[n3] / 32;
                    n2 = this.level.getScrollability() == 129 ? (n2 += ((this.horizontalScreenNumber > 0 ? this.level.getMaxVerticalScreenNumber() : this.verticalScreenNumber) - this.level.getStartVerticalScreenNumber() + 1) * 2) : (n2 += (this.verticalScreenNumber - this.level.getStartVerticalScreenNumber()) * 2);
                    if (n2 < 0) {
                        n2 += 14;
                    }
                    n = this.hiddenTilesData[n3] % 16;
                    graphics2D.setColor(Color.PINK);
                    graphics2D.drawRect(n * 16, n2 % 14 * 16 + 16, 16, 16);
                    n3 += 2;
                }
            }
        }
        Entity[] entityArray = this.entities;
        n = this.entities.length;
        n2 = 0;
        while (n2 < n) {
            Entity entity = entityArray[n2];
            if (entity != null) {
                graphics2D.drawImage((Image)entity.image, entity.left, entity.top + 16 & 0xFF, null);
            }
            ++n2;
        }
        if (this.mode == 0) {
            if (this.selectedEntity >= 0 && this.entities[this.selectedEntity] != null) {
                int n4 = this.entities[this.selectedEntity].left;
                n2 = this.entities[this.selectedEntity].top + 16 & 0xFF;
                n = this.entities[this.selectedEntity].right;
                int n5 = this.entities[this.selectedEntity].bottom + 16 & 0xFF;
                graphics2D.setColor(Color.WHITE);
                graphics2D.drawRect(n4, n2, n - n4, n5 - n2);
            }
        } else if (this.mode == 1 && this.selectedTile >= 0) {
            graphics2D.setColor(Color.WHITE);
            graphics2D.drawRect(this.selectedTile % 16 * 16, this.selectedTile / 16 * 16 + 16, 16, 16);
        }
        int n6 = this.level.calcEntityIndex(this.horizontalScreenNumber, this.verticalScreenNumber);
        graphics2D.setColor(Color.BLUE);
        graphics2D.drawString(String.format("%02d", n6), 0, 13);
        graphics2D.dispose();
        Insets insets = this.getInsets();
        n = this.getWidth() - (insets.left + insets.right + this.verticalScrollBar.getWidth());
        int n7 = this.getHeight() - (insets.top + insets.bottom + this.horizontalScrollBar.getHeight());
        float f = (float)n / (float)this.buffer.getWidth();
        float f2 = (float)n7 / (float)this.buffer.getHeight();
        float f3 = Math.min(f, f2);
        if (this.isIntegerScaling()) {
            if (this.scale != (float)((int)this.scale) || f3 - this.scale < 0.0f || f3 - this.scale >= 1.0f) {
                this.scale = Math.max(1, (int)(this.scale + Math.max(-1.0f, Math.min(1.0f, (f3 - this.scale) * 1.0f))));
                this.setPreferredScale(this.scale);
            }
        } else if (Math.abs(f3 - this.scale) * (float)this.buffer.getWidth() > 2.0f && Math.abs(f3 - this.scale) * (float)this.buffer.getHeight() > 2.0f) {
            this.scale += (f3 - this.scale) * 0.5f;
            this.setPreferredScale(this.scale);
        }
        this.offsetX = Math.max(0, (int)(((float)n - (float)this.buffer.getWidth() * this.scale) / 2.0f)) + insets.left;
        this.offsetY = Math.max(0, (int)(((float)n7 - (float)this.buffer.getHeight() * this.scale) / 2.0f)) + insets.right;
        graphics.drawImage(this.buffer, this.offsetX, this.offsetY, (int)((float)this.buffer.getWidth() * this.scale), (int)((float)this.buffer.getHeight() * this.scale), null);
    }

    private class Entity {
        public final int type;
        public final int extraData;
        public final int hPos;
        public final int vPos;
        public int top = 256;
        public int bottom;
        public int left = 256;
        public int right;
        public boolean imageEmpty;
        public BufferedImage image;

        public Entity(int[] nArray) {
            this.type = nArray[0];
            this.hPos = nArray[2];
            int n = nArray[1];
            if (n >= 240) {
                n -= 256;
            }
            this.vPos = n;
            this.extraData = nArray[3];
        }

        public boolean contains(int n, int n2) {
            return n >= this.left && n < this.right && n2 >= this.top && n2 < this.bottom;
        }

        public String toString() {
            String string = LevelPanel.this.entityLabelProvider.getLabel(this.type, this.extraData);
            if (string == null) {
                return String.format("%02X%s", this.type, this.extraData > 0 ? "-" + String.format("%02X", this.extraData) : "");
            }
            return String.format("%s (%02X%s)", string, this.type, this.extraData > 0 ? "-" + String.format("%02X", this.extraData) : "");
        }
    }
}

