/*
 * Decompiled with CFR 0.152.
 */
package editors;

import changes.UndoRedoManager;
import common.ComponentWrapper;
import common.MenuItem;
import common.Properties;
import common.ScreenUtilities;
import data.Palette;
import data.Tiles;
import editors.TextProvider;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.KeyStroke;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import panels.PalettePanel;
import panels.TilePanel;
import panels.TilesPanel;

public class TileEditor
extends JDialog {
    private static TileEditor editor;
    private Tiles[] tiles;
    private Palette[] palettes;
    private final JComboBox<String> tilesSelection;
    private final JComboBox<String> paletteSelection;
    private final TilesPanel tilesPanel;
    private TilePanel[][] tilePanels;
    private final PalettePanel palette;
    private final JRadioButton palette0;
    private final JRadioButton palette1;
    private final JPanel tilePanelsPanel;
    private final JPanel north;

    private TileEditor(Tiles[] tilesArray, Palette[] paletteArray, int n, int[][] nArray, String[] stringArray, String[] stringArray2) {
        int n2;
        int n3;
        this.setTitle(TextProvider.get("TitleTile"));
        this.tiles = tilesArray;
        this.palettes = paletteArray;
        this.setLayout(new BorderLayout());
        this.tilesSelection = new JComboBox<String>(stringArray);
        this.paletteSelection = new JComboBox<String>(stringArray2);
        this.paletteSelection.setSelectedIndex(n);
        this.tilesPanel = new TilesPanel(tilesArray[0], paletteArray[n]);
        this.tilesPanel.setMatchParentWidth(true);
        this.tilePanels = new TilePanel[][]{{new TilePanel(this.tilesPanel.getSelectedTiles()[0][0], paletteArray[n])}};
        this.palette = new PalettePanel(paletteArray[n]);
        final JPanel jPanel = new JPanel();
        final JPanel jPanel2 = new JPanel(new GridLayout(1, 2));
        jPanel2.setVisible(!tilesArray[0].isSprite());
        this.palette0 = new JRadioButton(String.valueOf(TextProvider.get("Palette")) + " 0", true);
        this.palette1 = new JRadioButton(String.valueOf(TextProvider.get("Palette")) + " 1");
        JMenuBar jMenuBar = new JMenuBar();
        this.setJMenuBar(jMenuBar);
        jMenuBar.add(this.makeMenuEdit());
        this.tilePanels[0][0].setBorder(BorderFactory.createLineBorder(this.getBackground()));
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (TileEditor.this.tilesSelection.getSelectedIndex() < TileEditor.this.tiles.length && TileEditor.this.paletteSelection.getSelectedIndex() < TileEditor.this.palettes.length) {
                    Tiles tiles = TileEditor.this.tiles[TileEditor.this.tilesSelection.getSelectedIndex()];
                    TileEditor.this.tilesPanel.setTiles(tiles, TileEditor.this.palettes[TileEditor.this.paletteSelection.getSelectedIndex()]);
                    TileEditor.this.updateTilePanels();
                    TileEditor.this.palette.setPalette(TileEditor.this.palettes[TileEditor.this.paletteSelection.getSelectedIndex()]);
                    if (tiles.isSprite()) {
                        jPanel2.setVisible(false);
                        jPanel.setLayout(new FlowLayout());
                        TileEditor.this.palette.setRange(16, 16 + (1 << tiles.getBPP()));
                        TileEditor.this.tilesPanel.setPal(1);
                        int n = 0;
                        while (n < TileEditor.this.tilePanels.length) {
                            int n2 = 0;
                            while (n2 < TileEditor.this.tilePanels[n].length) {
                                if (TileEditor.this.tilePanels[n][n2] != null) {
                                    TileEditor.this.tilePanels[n][n2].setPal(1);
                                }
                                ++n2;
                            }
                            ++n;
                        }
                    } else {
                        jPanel.setLayout(new GridLayout(2, 1));
                        jPanel2.setVisible(true);
                        if (TileEditor.this.palette0.isSelected()) {
                            TileEditor.this.palette.setRange(0, 1 << tiles.getBPP());
                            TileEditor.this.tilesPanel.setPal(0);
                            int n = 0;
                            while (n < TileEditor.this.tilePanels.length) {
                                int n3 = 0;
                                while (n3 < TileEditor.this.tilePanels[n].length) {
                                    if (TileEditor.this.tilePanels[n][n3] != null) {
                                        TileEditor.this.tilePanels[n][n3].setPal(0);
                                    }
                                    ++n3;
                                }
                                ++n;
                            }
                        } else if (TileEditor.this.palette1.isSelected()) {
                            TileEditor.this.palette.setRange(16, 16 + (1 << tiles.getBPP()));
                            TileEditor.this.tilesPanel.setPal(1);
                            int n = 0;
                            while (n < TileEditor.this.tilePanels.length) {
                                int n4 = 0;
                                while (n4 < TileEditor.this.tilePanels[n].length) {
                                    if (TileEditor.this.tilePanels[n][n4] != null) {
                                        TileEditor.this.tilePanels[n][n4].setPal(1);
                                    }
                                    ++n4;
                                }
                                ++n;
                            }
                        }
                    }
                    TileEditor.this.palette.setSelectedColorIndex(0);
                    TileEditor.this.pack();
                }
            }
        };
        this.tilesPanel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TileEditor.this.updateTilePanels();
            }
        });
        int n4 = 0;
        while (n4 < this.tilePanels.length) {
            n3 = 0;
            while (n3 < this.tilePanels[n4].length) {
                n2 = n4;
                final int n5 = n3;
                this.tilePanels[n4][n3].addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (TileEditor.this.tilePanels[n2][n5].isPipette()) {
                            TileEditor.this.palette.setSelectedColorIndex(TileEditor.this.tilesPanel.getPixel(n2, n5, TileEditor.this.tilePanels[n2][n5].getSelectedPixel()));
                        } else {
                            TileEditor.this.tilesPanel.setPixel(n2, n5, TileEditor.this.tilePanels[n2][n5].getSelectedPixel(), TileEditor.this.palette.getSelectedColorIndex());
                        }
                    }
                });
                ++n3;
            }
            ++n4;
        }
        this.tilesSelection.addActionListener(actionListener);
        this.paletteSelection.addActionListener(actionListener);
        this.north = new JPanel(new GridLayout(2, 1));
        this.north.add(this.tilesSelection);
        this.north.add(this.paletteSelection);
        this.add((Component)this.north, "North");
        this.north.setVisible(tilesArray.length > 1);
        this.add((Component)this.tilesPanel, "Center");
        JPanel jPanel3 = new JPanel(new BorderLayout());
        this.add((Component)jPanel3, "South");
        this.tilePanelsPanel = new JPanel(new GridLayout(this.tilePanels.length, this.tilePanels[0].length));
        this.tilePanelsPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        n3 = 0;
        while (n3 < this.tilePanels.length) {
            n2 = 0;
            while (n2 < this.tilePanels[n3].length) {
                this.tilePanelsPanel.add(this.tilePanels[n3][n2]);
                ++n2;
            }
            ++n3;
        }
        jPanel3.add((Component)ComponentWrapper.wrapComponent(this.tilePanelsPanel), "North");
        JButton jButton = new JButton(TextProvider.get("FlipH"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TileEditor.this.tilesPanel.flipH();
            }
        });
        JButton jButton2 = new JButton(TextProvider.get("FlipV"));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TileEditor.this.tilesPanel.flipV();
            }
        });
        JPanel jPanel4 = new JPanel(new FlowLayout());
        jPanel4.add(jButton);
        jPanel4.add(jButton2);
        jPanel3.add((Component)jPanel, "Center");
        jPanel.add(jPanel4);
        jPanel.add(ComponentWrapper.wrapComponent(jPanel2));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.palette0);
        buttonGroup.add(this.palette1);
        jPanel2.add(this.palette0);
        jPanel2.add(this.palette1);
        this.palette0.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Tiles tiles = TileEditor.this.tiles[TileEditor.this.tilesSelection.getSelectedIndex()];
                TileEditor.this.palette.setRange(0, 1 << tiles.getBPP());
                TileEditor.this.tilesPanel.setPal(0);
                int n = 0;
                while (n < TileEditor.this.tilePanels.length) {
                    int n2 = 0;
                    while (n2 < TileEditor.this.tilePanels[n].length) {
                        if (TileEditor.this.tilePanels[n][n2] != null) {
                            TileEditor.this.tilePanels[n][n2].setPal(0);
                        }
                        ++n2;
                    }
                    ++n;
                }
            }
        });
        this.palette1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Tiles tiles = TileEditor.this.tiles[TileEditor.this.tilesSelection.getSelectedIndex()];
                TileEditor.this.palette.setRange(16, 16 + (1 << tiles.getBPP()));
                TileEditor.this.tilesPanel.setPal(1);
                int n = 0;
                while (n < TileEditor.this.tilePanels.length) {
                    int n2 = 0;
                    while (n2 < TileEditor.this.tilePanels[n].length) {
                        if (TileEditor.this.tilePanels[n][n2] != null) {
                            TileEditor.this.tilePanels[n][n2].setPal(1);
                        }
                        ++n2;
                    }
                    ++n;
                }
            }
        });
        if (tilesArray[0].isSprite()) {
            this.tilesPanel.setPal(1);
            this.tilePanels[0][0].setPal(1);
            this.palette.setRange(16, 16 + (1 << tilesArray[0].getBPP()));
        } else {
            jPanel.setLayout(new GridLayout(2, 1));
            this.palette.setRange(0, 1 << tilesArray[0].getBPP());
        }
        this.palette.setSelectedColorIndex(0);
        jPanel3.add((Component)ComponentWrapper.wrapComponent(this.palette), "South");
        this.tilesSelection.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                switch (keyEvent.getKeyCode()) {
                    case 80: {
                        System.out.println(String.valueOf(Integer.toHexString(TileEditor.this.tiles[TileEditor.this.tilesSelection.getSelectedIndex()].getSource())) + "-" + Integer.toHexString(TileEditor.this.tiles[TileEditor.this.tilesSelection.getSelectedIndex()].getSource() + TileEditor.this.tiles[TileEditor.this.tilesSelection.getSelectedIndex()].getSize() - 1));
                    }
                }
            }
        });
        this.tilesPanel.setSelectedTiles(nArray);
        this.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                if (mouseWheelEvent.getUnitsToScroll() < 0) {
                    if (mouseWheelEvent.isAltDown()) {
                        float f = Math.max(1, (int)(TileEditor.this.tilesPanel.getScale() + 1.5f));
                        TileEditor.this.tilesPanel.setPreferredScale(f);
                        TileEditor.this.tilesPanel.setMatchParentWidth(false);
                        TileEditor.this.pack();
                        TileEditor.this.tilesPanel.setMatchParentWidth(true);
                    }
                } else if (mouseWheelEvent.getUnitsToScroll() > 0 && mouseWheelEvent.isAltDown()) {
                    float f = Math.max(1, (int)(TileEditor.this.tilesPanel.getScale() - 0.5f));
                    TileEditor.this.tilesPanel.setPreferredScale(f);
                    TileEditor.this.tilesPanel.setMatchParentWidth(false);
                    TileEditor.this.pack();
                    TileEditor.this.tilesPanel.setMatchParentWidth(true);
                }
                mouseWheelEvent.consume();
            }
        });
    }

    private JMenu makeMenuEdit() {
        JMenu jMenu = new JMenu(TextProvider.get("MenuEdit"));
        jMenu.setMnemonic('e');
        final MenuItem menuItem = new MenuItem(TextProvider.get("MenuUndo"), 117);
        jMenu.add(menuItem);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UndoRedoManager.getInstance().undo(TileEditor.this.tiles[TileEditor.this.tilesSelection.getSelectedIndex()]);
            }
        });
        menuItem.setAccelerator(KeyStroke.getKeyStroke(90, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        final MenuItem menuItem2 = new MenuItem(TextProvider.get("MenuRedo"), 114);
        jMenu.add(menuItem2);
        menuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UndoRedoManager.getInstance().redo(TileEditor.this.tiles[TileEditor.this.tilesSelection.getSelectedIndex()]);
            }
        });
        menuItem2.setAccelerator(KeyStroke.getKeyStroke(89, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        jMenu.addSeparator();
        MenuItem menuItem3 = new MenuItem(TextProvider.get("CopyTile"), 99);
        jMenu.add(menuItem3);
        menuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TileEditor.this.tilesPanel.copyTilesToClipboard();
            }
        });
        menuItem3.setAccelerator(KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        menuItem3 = new MenuItem(TextProvider.get("CopyAllTiles"), 121);
        jMenu.add(menuItem3);
        menuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TileEditor.this.tilesPanel.copyToClipboard();
            }
        });
        menuItem3.setAccelerator(KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 0x40));
        final MenuItem menuItem4 = new MenuItem(TextProvider.get("PasteTile"), 112);
        jMenu.add(menuItem4);
        menuItem4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TileEditor.this.tilesPanel.pasteTileFromClipboard();
            }
        });
        menuItem4.setAccelerator(KeyStroke.getKeyStroke(86, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        final MenuItem menuItem5 = new MenuItem(TextProvider.get("PasteAllTiles"), 97);
        jMenu.add(menuItem5);
        menuItem5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TileEditor.this.tilesPanel.pasteFromClipboard();
            }
        });
        menuItem5.setAccelerator(KeyStroke.getKeyStroke(86, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 0x40));
        jMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent menuEvent) {
                menuItem.setEnabled(UndoRedoManager.getInstance().canUndo(TileEditor.this.tiles[TileEditor.this.tilesSelection.getSelectedIndex()]));
                menuItem2.setEnabled(UndoRedoManager.getInstance().canRedo(TileEditor.this.tiles[TileEditor.this.tilesSelection.getSelectedIndex()]));
                menuItem4.setEnabled(TileEditor.this.tilesPanel.canPasteFromClipboard());
                menuItem5.setEnabled(TileEditor.this.tilesPanel.canPasteFromClipboard());
            }

            @Override
            public void menuDeselected(MenuEvent menuEvent) {
                menuItem.setEnabled(true);
                menuItem2.setEnabled(true);
                menuItem4.setEnabled(true);
                menuItem5.setEnabled(true);
            }

            @Override
            public void menuCanceled(MenuEvent menuEvent) {
            }
        });
        return jMenu;
    }

    private void updateTilePanels() {
        int n;
        int n2;
        boolean bl = false;
        int[][][] nArray = this.tilesPanel.getSelectedTiles();
        this.tilePanelsPanel.setLayout(new GridLayout(nArray.length, nArray[0].length));
        if (this.tilePanels.length != nArray.length || this.tilePanels[0].length != nArray[0].length) {
            this.tilePanelsPanel.removeAll();
            bl = true;
            TilePanel[][] tilePanelArray = new TilePanel[nArray.length][nArray[0].length];
            n2 = 0;
            while (n2 < this.tilePanels.length && n2 < tilePanelArray.length) {
                n = 0;
                while (n < this.tilePanels[n2].length && n < tilePanelArray[n2].length) {
                    tilePanelArray[n2][n] = this.tilePanels[n2][n];
                    ++n;
                }
                ++n2;
            }
            this.tilePanels = tilePanelArray;
        }
        int n3 = 0;
        while (n3 < this.tilePanels.length) {
            n2 = 0;
            while (n2 < this.tilePanels[n3].length) {
                if (nArray[n3][n2] != null) {
                    if (this.tilePanels[n3][n2] == null) {
                        this.tilePanels[n3][n2] = new TilePanel(nArray[n3][n2], this.palettes[this.paletteSelection.getSelectedIndex()]);
                        this.tilePanels[n3][n2].setBorder(BorderFactory.createLineBorder(this.getBackground()));
                        n = n3;
                        final int n4 = n2;
                        this.tilePanels[n3][n2].addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent actionEvent) {
                                if (TileEditor.this.tilePanels[n][n4].isPipette()) {
                                    TileEditor.this.palette.setSelectedColorIndex(TileEditor.this.tilesPanel.getPixel(n, n4, TileEditor.this.tilePanels[n][n4].getSelectedPixel()));
                                } else {
                                    TileEditor.this.tilesPanel.setPixel(n, n4, TileEditor.this.tilePanels[n][n4].getSelectedPixel(), TileEditor.this.palette.getSelectedColorIndex());
                                }
                            }
                        });
                        if (this.tiles[this.tilesSelection.getSelectedIndex()].isSprite() || this.palette1.isSelected()) {
                            this.tilePanels[n3][n2].setPal(1);
                        } else if (this.palette0.isSelected()) {
                            this.tilePanels[n3][n2].setPal(0);
                        }
                    } else {
                        this.tilePanels[n3][n2].setTile(nArray[n3][n2], this.palettes[this.paletteSelection.getSelectedIndex()]);
                    }
                    if (n3 * this.tilePanels[n3].length + n2 < this.tilePanelsPanel.getComponentCount() && !(this.tilePanelsPanel.getComponent(n3 * this.tilePanels[n3].length + n2) instanceof TilePanel)) {
                        this.tilePanelsPanel.remove(n3 * this.tilePanels[n3].length + n2);
                        bl = true;
                    }
                    if (bl) {
                        this.tilePanelsPanel.add((Component)this.tilePanels[n3][n2], n3 * this.tilePanels[n3].length + n2);
                    }
                } else {
                    if (n3 * this.tilePanels[n3].length + n2 < this.tilePanelsPanel.getComponentCount() && !(this.tilePanelsPanel.getComponent(n3 * this.tilePanels[n3].length + n2) instanceof JLabel)) {
                        this.tilePanelsPanel.remove(n3 * this.tilePanels[n3].length + n2);
                        bl = true;
                    }
                    if (bl) {
                        this.tilePanelsPanel.add((Component)new JLabel(), n3 * this.tilePanels[n3].length + n2);
                    }
                }
                ++n2;
            }
            ++n3;
        }
        if (bl) {
            this.tilePanelsPanel.revalidate();
            this.tilePanelsPanel.repaint();
            this.pack();
        }
    }

    private void updateTilesNames(String[] stringArray) {
        this.tilesSelection.setModel(new JComboBox<String>(stringArray).getModel());
    }

    public static void open(JFrame jFrame, Tiles[] tilesArray, Palette[] paletteArray, int n, int[][] nArray, String[] stringArray, String[] stringArray2, Properties properties) {
        if (nArray != null) {
            boolean bl = true;
            int n2 = 0;
            while (n2 < nArray.length && bl) {
                int n3 = 0;
                while (n3 < nArray[n2].length && bl) {
                    if (nArray[n2][n3] >= 0) {
                        bl = false;
                    }
                    ++n3;
                }
                ++n2;
            }
            if (bl) {
                return;
            }
        }
        if (editor == null) {
            editor = new TileEditor(tilesArray, paletteArray, n, nArray, stringArray, stringArray2);
            try {
                editor.setLocation(properties.getInt("Window" + editor.getClass().getSimpleName() + "X"), properties.getInt("Window" + editor.getClass().getSimpleName() + "Y"));
            }
            catch (NumberFormatException numberFormatException) {
                editor.setLocationRelativeTo(jFrame);
            }
            try {
                editor.setSize(properties.getInt("Window" + editor.getClass().getSimpleName() + "Width"), properties.getInt("Window" + editor.getClass().getSimpleName() + "Height"));
            }
            catch (NumberFormatException numberFormatException) {
                editor.pack();
            }
        } else {
            TileEditor.editor.tiles = tilesArray;
            TileEditor.editor.palettes = paletteArray;
            editor.updateTilesNames(stringArray);
            TileEditor.editor.tilesSelection.setSelectedIndex(0);
            TileEditor.editor.paletteSelection.setSelectedIndex(n);
            TileEditor.editor.tilesPanel.setSelectedTiles(nArray);
            editor.updateTilePanels();
            TileEditor.editor.north.setVisible(tilesArray.length > 1);
            editor.pack();
        }
        if (ScreenUtilities.getScreen(editor) == null) {
            editor.setLocationRelativeTo(jFrame);
        }
        TileEditor.editor.tilesPanel.setIntegerScaling(Boolean.parseBoolean(properties.getProperty("IntegerScaling")));
        editor.setVisible(true);
    }

    public static void close() {
        if (editor != null) {
            editor.setVisible(false);
        }
    }

    public static void destroy() {
        if (editor != null) {
            editor.dispose();
        }
        editor = null;
    }

    public static void saveState(Properties properties) {
        if (editor != null) {
            properties.setProperty("Window" + editor.getClass().getSimpleName() + "Open", "" + editor.isVisible());
            properties.setProperty("Window" + editor.getClass().getSimpleName() + "X", "" + editor.getX());
            properties.setProperty("Window" + editor.getClass().getSimpleName() + "Y", "" + editor.getY());
            if (editor.isResizable()) {
                properties.setProperty("Window" + editor.getClass().getSimpleName() + "Width", "" + editor.getWidth());
                properties.setProperty("Window" + editor.getClass().getSimpleName() + "Height", "" + editor.getHeight());
            }
        }
    }
}

