/*
 * Decompiled with CFR 0.152.
 */
package editors;

import editors.TextProvider;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import rom.RomManager;
import widgets.IntegerTextField;

public class HitboxEditor
extends JDialog {
    private static HitboxEditor editor;
    private int prevSelection;
    private final IntegerTextField[] textFields = new IntegerTextField[4];

    private HitboxEditor(JFrame jFrame, List<?>[] listArray) {
        super(jFrame, TextProvider.get("TitleHitbox"), false);
        int n;
        int n2;
        int n3;
        final IntegerTextField[] integerTextFieldArray = this.textFields;
        String[] stringArray = new String[54];
        int n4 = 0;
        while (n4 < stringArray.length) {
            byte by = (byte)RomManager.StaticAccess.readByte(37328 + 4 * n4);
            n3 = RomManager.StaticAccess.readByte(37328 + 4 * n4 + 1);
            n2 = RomManager.StaticAccess.readByte(37328 + 4 * n4 + 2);
            n = RomManager.StaticAccess.readByte(37328 + 4 * n4 + 3);
            stringArray[n4] = String.valueOf(String.format("%02X: ", n4)) + TextProvider.get("Hitbox") + ": [" + by + ", " + n3 + ", " + n2 + ", " + n + "]";
            ++n4;
        }
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                HitboxEditor.this.saveChanges();
            }
        });
        final JComboBox<String> jComboBox = new JComboBox<String>(stringArray);
        jComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HitboxEditor.this.saveChanges();
                byte by = (byte)RomManager.StaticAccess.readByte(37328 + 4 * jComboBox.getSelectedIndex());
                int n = RomManager.StaticAccess.readByte(37328 + 4 * jComboBox.getSelectedIndex() + 1);
                byte by2 = (byte)RomManager.StaticAccess.readByte(37328 + 4 * jComboBox.getSelectedIndex() + 2);
                int n2 = RomManager.StaticAccess.readByte(37328 + 4 * jComboBox.getSelectedIndex() + 3);
                integerTextFieldArray[0].setValue(by);
                integerTextFieldArray[1].setValue(n);
                integerTextFieldArray[2].setValue(by2);
                integerTextFieldArray[3].setValue(n2);
                HitboxEditor.this.prevSelection = jComboBox.getSelectedIndex();
            }
        });
        jComboBox.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                switch (keyEvent.getKeyCode()) {
                    case 80: {
                        System.out.println(Integer.toHexString(37328 + 4 * jComboBox.getSelectedIndex()));
                    }
                }
            }
        });
        this.setLayout(new BorderLayout());
        this.add(jComboBox, "North");
        JPanel jPanel = new JPanel(new GridLayout(2, 4, 4, 4));
        n3 = 0;
        while (n3 < integerTextFieldArray.length) {
            integerTextFieldArray[n3] = new IntegerTextField(1, 0, (n3 & 1) == 0);
            ++n3;
        }
        jPanel.add(new JLabel("X:"));
        jPanel.add(integerTextFieldArray[0]);
        jPanel.add(new JLabel(String.valueOf(TextProvider.get("Width")) + ":"));
        jPanel.add(integerTextFieldArray[1]);
        jPanel.add(new JLabel("Y:"));
        jPanel.add(integerTextFieldArray[2]);
        jPanel.add(new JLabel(String.valueOf(TextProvider.get("Height")) + ":"));
        jPanel.add(integerTextFieldArray[3]);
        this.add((Component)jPanel, "Center");
        JTextArea jTextArea = new JTextArea(){

            @Override
            public Dimension getPreferredScrollableViewportSize() {
                return new Dimension(600, 400);
            }
        };
        jTextArea.setEditable(false);
        n2 = 0;
        while (n2 < listArray.length) {
            jTextArea.append(String.format("%02X: ", n2));
            if (listArray[n2] != null) {
                n = 1;
                for (Object e : (LinkedList)listArray[n2]) {
                    if (n == 0) {
                        jTextArea.append(", ");
                    }
                    jTextArea.append(e.toString());
                    n = 0;
                }
            }
            if (n2 < listArray.length - 1) {
                jTextArea.append("\n");
            }
            ++n2;
        }
        jTextArea.setCaretPosition(0);
        this.add((Component)new JScrollPane(jTextArea), "South");
        this.pack();
        this.setLocationRelativeTo(jFrame);
    }

    private void saveChanges() {
        RomManager.StaticAccess.writeByte(37328 + 4 * this.prevSelection, this.textFields[0].getValue());
        RomManager.StaticAccess.writeByte(37328 + 4 * this.prevSelection + 1, this.textFields[1].getValue());
        RomManager.StaticAccess.writeByte(37328 + 4 * this.prevSelection + 2, this.textFields[2].getValue());
        RomManager.StaticAccess.writeByte(37328 + 4 * this.prevSelection + 3, this.textFields[3].getValue());
    }

    public static void close() {
        if (editor != null) {
            editor.saveChanges();
            editor.setVisible(false);
            editor = null;
        }
    }

    public static void destroy() {
        if (editor != null) {
            editor.dispose();
        }
        editor = null;
    }

    public static void open(JFrame jFrame, List<?>[] listArray) {
        if (editor == null) {
            editor = new HitboxEditor(jFrame, listArray);
        }
        editor.setVisible(true);
    }
}

