/*
 * Decompiled with CFR 0.152.
 */
package data;

import changes.Changable;
import changes.Change;
import changes.ChangeListener;
import data.CompressedTiles;
import editor.Z80Factory;
import editormodels.GameEditorModelManager;
import editors.TextProvider;
import java.util.LinkedList;
import mastersystem.OutputListener;
import mastersystem.TMS9918A;
import mastersystem.Z80;
import rom.RomManager;
import transactions.TransactionManager;

public class Tiles
implements Changable {
    protected final int address;
    protected int source;
    protected final int destination;
    protected final int length;
    protected int end;
    protected final int color;
    protected final int bpp;
    protected final boolean sprite;
    private final LinkedList<ChangeListener> listeners = new LinkedList();
    protected static final int[] MIRRORED_BITS = new int[256];

    static {
        int n = 0;
        while (n < MIRRORED_BITS.length) {
            int n2 = n;
            int n3 = 8;
            while (n2 > 0) {
                int n4 = n;
                MIRRORED_BITS[n4] = MIRRORED_BITS[n4] << 1;
                int n5 = n;
                MIRRORED_BITS[n5] = MIRRORED_BITS[n5] | n2 & 1;
                n2 >>= 1;
                --n3;
            }
            int n6 = n++;
            MIRRORED_BITS[n6] = MIRRORED_BITS[n6] << n3;
        }
    }

    public Tiles(int n, int n2, int n3, int n4, boolean bl) {
        this(n, n2, n3, n4, 0, bl);
    }

    public Tiles(int n, int n2, int n3, int n4, int n5, boolean bl) {
        this(n, n2, n3, n4, n5, n5 > 0 ? 1 : (n > 0 ? 4 : (n < 0 ? 2 : 3)), bl);
    }

    public Tiles(int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        if (n >= 49152) {
            System.err.println("Invalid address: " + Integer.toHexString(n));
        }
        if (n4 < 0) {
            throw new IllegalArgumentException("Length must not be negative");
        }
        this.address = n;
        this.source = n2;
        if ((n3 & 0x4000) == 0) {
            System.err.println("Incorrect destination for tiles starting from " + Integer.toHexString(n2));
        }
        this.destination = 0x4000 | n3;
        this.length = n4;
        this.color = n5;
        this.bpp = n6;
        this.sprite = bl;
    }

    public void moveLeft(int n) {
        TransactionManager.getInstance().addTransactionObject(this, n);
        int n2 = 0;
        while (n2 < 8) {
            int n3 = this.source + n * 8 * this.bpp + n2 * this.bpp;
            int n4 = 0;
            while (n4 < this.bpp) {
                this.writeByte(n3 + n4, RomManager.StaticAccess.readByte(n3 + n4) << 1 & 0xFF);
                ++n4;
            }
            ++n2;
        }
    }

    public void moveLeft(int[][] nArray) {
        TransactionManager.getInstance().addTransactionObject(this, nArray[0][0]);
        int n = 0;
        while (n < nArray.length) {
            int n2 = 0;
            while (n2 < nArray[n].length) {
                if (nArray[n][n2] >= 0) {
                    int n3 = 0;
                    while (n3 < 8) {
                        int n4 = this.source + nArray[n][n2] * 8 * this.bpp + n3 * this.bpp;
                        int n5 = 0;
                        if (n2 < nArray[n].length - 1 && nArray[n][n2 + 1] >= 0) {
                            n5 = this.source + nArray[n][n2 + 1] * 8 * this.bpp + n3 * this.bpp;
                        }
                        int n6 = 0;
                        while (n6 < this.bpp) {
                            this.writeByte(n4 + n6, RomManager.StaticAccess.readByte(n4 + n6) << 1 & 0xFF);
                            if (n5 > 0) {
                                RomManager.StaticAccess.orByteWith(n4 + n6, RomManager.StaticAccess.readByte(n5 + n6) >> 7);
                            }
                            ++n6;
                        }
                        ++n3;
                    }
                }
                ++n2;
            }
            ++n;
        }
    }

    public void moveUp(int n) {
        TransactionManager.getInstance().addTransactionObject(this, n);
        int n2 = 0;
        while (n2 < 8) {
            int n3 = this.source + n * 8 * this.bpp + n2 * this.bpp;
            int n4 = this.source + n * 8 * this.bpp + (n2 + 1) * this.bpp;
            int n5 = 0;
            while (n5 < this.bpp) {
                this.writeByte(n3 + n5, n2 == 7 ? 0 : RomManager.StaticAccess.readByte(n4 + n5));
                ++n5;
            }
            ++n2;
        }
    }

    public void moveUp(int[][] nArray) {
        TransactionManager.getInstance().addTransactionObject(this, nArray[0][0]);
        int n = 0;
        while (n < nArray.length) {
            int n2 = 0;
            while (n2 < nArray[n].length) {
                if (nArray[n][n2] >= 0) {
                    int n3 = 0;
                    while (n3 < 8) {
                        int n4 = this.source + nArray[n][n2] * 8 * this.bpp + n3 * this.bpp;
                        int n5 = this.source + nArray[n][n2] * 8 * this.bpp + (n3 + 1) * this.bpp;
                        if (n3 == 7) {
                            n5 = n < nArray.length - 1 && nArray[n + 1][n2] >= 0 ? this.source + nArray[n + 1][n2] * 8 * this.bpp : 0;
                        }
                        int n6 = 0;
                        while (n6 < this.bpp) {
                            this.writeByte(n4 + n6, n5 > 0 ? RomManager.StaticAccess.readByte(n5 + n6) : 0);
                            ++n6;
                        }
                        ++n3;
                    }
                }
                ++n2;
            }
            ++n;
        }
    }

    public void moveRight(int n) {
        TransactionManager.getInstance().addTransactionObject(this, n);
        int n2 = 0;
        while (n2 < 8) {
            int n3 = this.source + n * 8 * this.bpp + n2 * this.bpp;
            int n4 = 0;
            while (n4 < this.bpp) {
                RomManager.StaticAccess.shiftByteRight(n3 + n4, 1);
                ++n4;
            }
            ++n2;
        }
    }

    public void moveRight(int[][] nArray) {
        TransactionManager.getInstance().addTransactionObject(this, nArray[0][0]);
        int n = 0;
        while (n < nArray.length) {
            int n2 = nArray[n].length - 1;
            while (n2 >= 0) {
                if (nArray[n][n2] >= 0) {
                    int n3 = 0;
                    while (n3 < 8) {
                        int n4 = this.source + nArray[n][n2] * 8 * this.bpp + n3 * this.bpp;
                        int n5 = 0;
                        if (n2 > 0 && nArray[n][n2 - 1] >= 0) {
                            n5 = this.source + nArray[n][n2 - 1] * 8 * this.bpp + n3 * this.bpp;
                        }
                        int n6 = 0;
                        while (n6 < this.bpp) {
                            RomManager.StaticAccess.shiftByteRight(n4 + n6, 1);
                            if (n5 > 0) {
                                RomManager.StaticAccess.orByteWith(n4 + n6, (RomManager.StaticAccess.readByte(n5 + n6) & 1) << 7);
                            }
                            ++n6;
                        }
                        ++n3;
                    }
                }
                --n2;
            }
            ++n;
        }
    }

    public void moveDown(int n) {
        TransactionManager.getInstance().addTransactionObject(this, n);
        int n2 = 7;
        while (n2 >= 0) {
            int n3 = this.source + n * 8 * this.bpp + n2 * this.bpp;
            int n4 = this.source + n * 8 * this.bpp + (n2 - 1) * this.bpp;
            int n5 = 0;
            while (n5 < this.bpp) {
                this.writeByte(n3 + n5, n2 == 0 ? 0 : RomManager.StaticAccess.readByte(n4 + n5));
                ++n5;
            }
            --n2;
        }
    }

    public void moveDown(int[][] nArray) {
        TransactionManager.getInstance().addTransactionObject(this, nArray[0][0]);
        int n = nArray.length - 1;
        while (n >= 0) {
            int n2 = 0;
            while (n2 < nArray[n].length) {
                if (nArray[n][n2] >= 0) {
                    int n3 = 7;
                    while (n3 >= 0) {
                        int n4 = this.source + nArray[n][n2] * 8 * this.bpp + n3 * this.bpp;
                        int n5 = this.source + nArray[n][n2] * 8 * this.bpp + (n3 - 1) * this.bpp;
                        if (n3 == 0) {
                            n5 = n > 0 && nArray[n - 1][n2] >= 0 ? this.source + nArray[n - 1][n2] * 8 * this.bpp + 7 * this.bpp : 0;
                        }
                        int n6 = 0;
                        while (n6 < this.bpp) {
                            this.writeByte(n4 + n6, n5 > 0 ? RomManager.StaticAccess.readByte(n5 + n6) : 0);
                            ++n6;
                        }
                        --n3;
                    }
                }
                ++n2;
            }
            --n;
        }
    }

    public void flipH(int n) {
        TransactionManager.getInstance().addTransactionObject(this, n);
        int n2 = 0;
        while (n2 < 8) {
            int n3 = this.source + n * 8 * this.bpp + n2 * this.bpp;
            int n4 = 0;
            while (n4 < this.bpp) {
                this.writeByte(n3 + n4, MIRRORED_BITS[RomManager.StaticAccess.readByte(n3 + n4)]);
                ++n4;
            }
            ++n2;
        }
    }

    public void flipH(int[][] nArray) {
        TransactionManager.getInstance().addTransactionObject(this, nArray[0][0]);
        int n = 0;
        while (n < nArray.length) {
            int n2 = 0;
            while (n2 < (nArray[n].length + 1) / 2) {
                if (nArray[n][n2] >= 0) {
                    int n3 = 0;
                    while (n3 < 8) {
                        int n4 = this.source + nArray[n][n2] * 8 * this.bpp + n3 * this.bpp;
                        int n5 = this.source + nArray[n][nArray[n].length - 1 - n2] * 8 * this.bpp + n3 * this.bpp;
                        if (nArray[n][nArray[n].length - 1 - n2] < 0) {
                            n5 = n4;
                        }
                        int n6 = 0;
                        while (n6 < this.bpp) {
                            int n7 = MIRRORED_BITS[RomManager.StaticAccess.readByte(n4 + n6)];
                            this.writeByte(n4 + n6, MIRRORED_BITS[RomManager.StaticAccess.readByte(n5 + n6)]);
                            this.writeByte(n5 + n6, n7);
                            ++n6;
                        }
                        ++n3;
                    }
                }
                ++n2;
            }
            ++n;
        }
    }

    public void flipV(int n) {
        TransactionManager.getInstance().addTransactionObject(this, n);
        int n2 = 0;
        while (n2 < 4) {
            int n3 = this.source + n * 8 * this.bpp + n2 * this.bpp;
            int n4 = this.source + n * 8 * this.bpp + (n2 ^ 7) * this.bpp;
            int n5 = 0;
            while (n5 < this.bpp) {
                int n6 = RomManager.StaticAccess.readByte(n3 + n5);
                this.writeByte(n3 + n5, RomManager.StaticAccess.readByte(n4 + n5));
                this.writeByte(n4 + n5, n6);
                ++n5;
            }
            ++n2;
        }
    }

    public void flipV(int[][] nArray) {
        TransactionManager.getInstance().addTransactionObject(this, nArray[0][0]);
        int n = 0;
        while (n < (nArray.length + 1) / 2) {
            int n2 = 0;
            while (n2 < nArray[n].length) {
                if (nArray[n][n2] >= 0) {
                    int n3 = 0;
                    while (n3 < 8) {
                        int n4 = this.source + nArray[n][n2] * 8 * this.bpp + n3 * this.bpp;
                        int n5 = this.source + nArray[nArray.length - 1 - n][n2] * 8 * this.bpp + (n3 ^ 7) * this.bpp;
                        if (nArray[nArray.length - 1 - n][n2] < 0) {
                            n5 = this.source + nArray[n][n2] * 8 * this.bpp + (n3 ^ 7) * this.bpp;
                        }
                        if (n4 > n5) break;
                        int n6 = 0;
                        while (n6 < this.bpp) {
                            int n7 = RomManager.StaticAccess.readByte(n4 + n6);
                            this.writeByte(n4 + n6, RomManager.StaticAccess.readByte(n5 + n6));
                            this.writeByte(n5 + n6, n7);
                            ++n6;
                        }
                        ++n3;
                    }
                }
                ++n2;
            }
            ++n;
        }
    }

    public int getPixel(int n, int n2) {
        int[] nArray = this.getVRAM();
        int n3 = this.getDestination() + n * 32 + n2 / 8 * 4;
        int n4 = 7 - n2 % 8;
        int n5 = 0;
        int n6 = 0;
        while (n6 < 4) {
            n5 |= (nArray[n3 + n6] >> n4 & 1) << n6;
            ++n6;
        }
        return n5;
    }

    public void setPixel(int n, int n2, int n3) {
        int n4 = this.source + n * 8 * this.bpp + n2 / 8 * this.bpp;
        int n5 = 7 - n2 % 8;
        int n6 = ~(1 << n5);
        boolean bl = false;
        int n7 = 0;
        while (n7 < this.bpp && !bl) {
            if (RomManager.StaticAccess.readByte(n4 + n7) != (RomManager.StaticAccess.readByte(n4 + n7) & n6 | (n3 >> n7 & 1) << n5)) {
                bl = true;
            }
            ++n7;
        }
        if (bl) {
            TransactionManager.getInstance().addTransactionObject(this, n);
            n7 = 0;
            while (n7 < this.bpp) {
                this.writeByte(n4 + n7, RomManager.StaticAccess.readByte(n4 + n7) & n6 | (n3 >> n7 & 1) << n5);
                ++n7;
            }
        }
    }

    public void setPixels(int[][] nArray) {
        int n = this.getLength() * this.bpp / 4;
        TransactionManager.getInstance().addTransactionObject(this, -1);
        int n2 = 0;
        while (n2 < nArray.length) {
            int n3 = 0;
            while (n3 < nArray[n2].length) {
                int n4 = this.source + n2 / 8 * nArray[n2].length * this.bpp + n3 / 8 * 8 * this.bpp + n2 % 8 * this.bpp;
                if (n4 - this.source >= n) break;
                int n5 = 7 - (n3 & 7);
                int n6 = ~(1 << n5);
                int n7 = 0;
                while (n7 < this.bpp) {
                    this.writeByte(n4 + n7, RomManager.StaticAccess.readByte(n4 + n7) & n6 | (nArray[n2][n3] >> n7 & 1) << n5);
                    ++n7;
                }
                ++n3;
            }
            ++n2;
        }
    }

    public void setPixels(int n, int[][] nArray) {
        TransactionManager.getInstance().addTransactionObject(this, n);
        int n2 = 0;
        while (n2 < nArray.length) {
            int n3 = this.source + n * 8 * this.bpp + n2 * this.bpp;
            int n4 = 0;
            while (n4 < nArray[n2].length) {
                int n5 = 7 - n4;
                int n6 = ~(1 << n5);
                int n7 = 0;
                while (n7 < this.bpp) {
                    this.writeByte(n3 + n7, RomManager.StaticAccess.readByte(n3 + n7) & n6 | (nArray[n2][n4] >> n7 & 1) << n5);
                    ++n7;
                }
                ++n4;
            }
            ++n2;
        }
    }

    public void setPixels(int[][] nArray, int[][][][] nArray2) {
        TransactionManager.getInstance().addTransactionObject(this, nArray[0][0]);
        int n = 0;
        while (n < nArray.length) {
            int n2 = 0;
            while (n2 < nArray[n].length) {
                if (nArray[n][n2] >= 0 && nArray2[n][n2] != null) {
                    int n3 = 0;
                    while (n3 < nArray2[n][n2].length) {
                        int n4 = this.source + nArray[n][n2] * 8 * this.bpp + n3 * this.bpp;
                        int n5 = 0;
                        while (n5 < nArray2[n][n2][n3].length) {
                            int n6 = 7 - n5;
                            int n7 = ~(1 << n6);
                            int n8 = 0;
                            while (n8 < this.bpp) {
                                this.writeByte(n4 + n8, RomManager.StaticAccess.readByte(n4 + n8) & n7 | (nArray2[n][n2][n3][n5] >> n8 & 1) << n6);
                                ++n8;
                            }
                            ++n5;
                        }
                        ++n3;
                    }
                }
                ++n2;
            }
            ++n;
        }
    }

    public int[] getTile(int n) {
        int[] nArray = new int[32];
        System.arraycopy(this.getVRAM(), this.getDestination() + n * 32, nArray, 0, nArray.length);
        return nArray;
    }

    public void moveTo(int n) {
        TransactionManager.getInstance().addTransactionObject(this, -1);
        RomManager.StaticAccess.copyBytes(this.source, n, this.length);
        this.source = n;
    }

    public boolean rewrite(int n, int n2) {
        if (n == this.source) {
            return false;
        }
        if (n2 != this.length) {
            throw new IllegalArgumentException("Length of Tiles cannot change! Is " + this.length + " bytes, desired " + n2 + " bytes.");
        }
        TransactionManager.getInstance().addTransactionObject(this, -1);
        int n3 = this.getSize();
        int[] nArray = RomManager.StaticAccess.readBytes(new int[n3], this.source);
        RomManager.StaticAccess.fill(this.source, this.source + n3, 255);
        int n4 = 0;
        while (n4 < n3) {
            if (RomManager.StaticAccess.readByte(n + n4) != 255) {
                throw new RuntimeException("rewrite: " + Integer.toHexString(n + n4) + " isn't free: " + Integer.toHexString(RomManager.StaticAccess.readByte(n + n4)) + " expected: ff");
            }
            ++n4;
        }
        RomManager.StaticAccess.writeBytes(nArray, n);
        this.source = n;
        return true;
    }

    public int getAddress() {
        return this.address;
    }

    public int getSource() {
        return this.source;
    }

    public int getDestination() {
        return this.destination & 0x3FFF;
    }

    public int getLength() {
        if (this.color > 0) {
            return this.length * 4;
        }
        return this.length;
    }

    public int getSize() {
        int n;
        if (this.end < this.getSource()) {
            this.getVRAM();
        }
        if ((n = this.end - this.getSource()) < 0) {
            throw new IllegalStateException("Size must not be negative.");
        }
        return n;
    }

    public int getBPP() {
        return this.bpp;
    }

    public boolean isSprite() {
        return this.sprite;
    }

    public boolean isValid() {
        return true;
    }

    public boolean isCompressed() {
        return false;
    }

    public boolean canAddTileToTileset() {
        return GameEditorModelManager.getGameDataModel().canAddTileToTileset(this);
    }

    public void addTile() {
        GameEditorModelManager.getGameDataModel().addTileToTileset(this);
    }

    public void removeTile() {
        GameEditorModelManager.getGameDataModel().removeTileFromTileset(this);
    }

    public CompressedTiles toCompressedTiles(int n) {
        CompressedTiles compressedTiles = new CompressedTiles(n, this.source, this.destination, this.bpp, this.sprite, null);
        for (ChangeListener changeListener : this.listeners) {
            compressedTiles.addChangeListener(changeListener);
        }
        this.listeners.clear();
        TransactionManager.getInstance().addTransactionObject(compressedTiles, -1);
        return compressedTiles;
    }

    public int[] getVRAM() {
        return this.getVRAM(new TMS9918A(262));
    }

    protected int[] getVRAM(final TMS9918A tMS9918A) {
        if (this.address > 0) {
            final int[] nArray = new int[65536];
            RomManager.StaticAccess.copyFromROM(0, nArray, 0, 32768);
            RomManager.StaticAccess.loadBank2(nArray, this.getSource() / 16384);
            final Z80 z80 = Z80Factory.create(nArray);
            int[] nArray2 = tMS9918A.getVRAM();
            z80.addOutputListener(new OutputListener(){

                @Override
                public void outputAvailable(int n, int n2, int n3) {
                    if (n == 65535) {
                        RomManager.StaticAccess.loadBank2(nArray, n2);
                    } else if (n >> 6 == 2) {
                        if (n2 < 0) {
                            z80.setInput(tMS9918A.readByte(n & 1, n3));
                        } else {
                            tMS9918A.processInput(n & 1, n2, n3);
                        }
                    }
                }
            });
            tMS9918A.processInput(1, this.destination & 0xFF, 0);
            tMS9918A.processInput(1, this.destination >> 8, 0);
            z80.setAF(this.color << 8);
            z80.setHL(this.getSource() < 32768 ? this.getSource() : 0x8000 | this.getSource() & 0x3FFF);
            z80.setDE(this.destination);
            z80.setBC(this.address == 48 ? this.length << 8 : this.length);
            z80.execute(this.address);
            this.end = (this.getSource() & 0xFFFFC000 | z80.getHL() - 1 & 0x3FFF) + 1;
            return nArray2;
        }
        int[] nArray = tMS9918A.getVRAM();
        int n = this.getSource();
        int n2 = this.destination & 0x3FFF;
        int n3 = 0;
        while (n3 < this.length) {
            nArray[n2++] = RomManager.StaticAccess.readByte(n++);
            nArray[n2++] = RomManager.StaticAccess.readByte(n++);
            nArray[n2++] = this.bpp >= 3 ? RomManager.StaticAccess.readByte(n++) : 0;
            nArray[n2++] = 0;
            n3 += 4;
        }
        this.end = n;
        return nArray;
    }

    protected int writeByte(int n, int n2) {
        if (n < this.getSource() || n >= this.getSource() + this.getSize()) {
            throw new IllegalArgumentException(String.valueOf(Integer.toHexString(n)) + " is outside of current tiles.");
        }
        n2 = RomManager.getInstance().writeByte(n, n2);
        if (!this.isValid()) {
            throw new IllegalStateException("Failed to write to " + Integer.toHexString(n) + " because the tiles starting from " + Integer.toHexString(this.getSource()) + " are invalid.");
        }
        return n2;
    }

    @Override
    public final String getChangeName() {
        return TextProvider.get("ChangeTiles");
    }

    @Override
    public final void fireChangeOccurred(Change change) {
        if (this instanceof CompressedTiles) {
            GameEditorModelManager.getGameDataModel().updateTilesSource((CompressedTiles)this);
        }
        for (ChangeListener changeListener : this.listeners) {
            changeListener.changeOccurred(change);
        }
    }

    @Override
    public final void addChangeListener(ChangeListener changeListener) {
        if (!this.listeners.contains(changeListener)) {
            this.listeners.addFirst(changeListener);
        }
    }

    @Override
    public final void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    public String toString() {
        if (this.end == 0) {
            this.getVRAM();
        }
        return String.valueOf(TextProvider.get("Tiles")) + "@" + Integer.toHexString(this.source).toUpperCase() + "-" + Integer.toHexString(this.end).toUpperCase();
    }
}

