/*
 * Decompiled with CFR 0.152.
 */
package data;

import changes.Changable;
import changes.Change;
import changes.ChangeListener;
import editor.Z80Factory;
import editors.TextProvider;
import java.util.LinkedList;
import mastersystem.OutputListener;
import mastersystem.TMS9918A;
import mastersystem.Z80;
import rom.RomManager;
import transactions.TransactionManager;

public class NameTable
implements Changable {
    protected int addressLoadNameTable;
    private final int address;
    private final boolean addressBankFixed;
    private int addressSource;
    private int addressDestination;
    private int addressDimension;
    private int addressBank;
    private int addressColumns;
    protected int end;
    private final LinkedList<ChangeListener> listeners = new LinkedList();

    public NameTable(int n, int n2) {
        this.addressBankFixed = false;
        this.address = n;
        this.addressLoadNameTable = n2;
        this.update();
    }

    public NameTable(int n, int n2, int n3) {
        this.address = n;
        this.addressBankFixed = true;
        this.addressBank = n2;
        this.addressLoadNameTable = n3;
        this.update();
    }

    public boolean isValid() {
        return true;
    }

    public void update() {
        int n = this.address;
        if (this.addressBankFixed) {
            while (RomManager.StaticAccess.readByte(n) != 205 && RomManager.StaticAccess.readByte(n) != 195 && RomManager.StaticAccess.readByte(n) != 201) {
                switch (RomManager.StaticAccess.readByte(n++)) {
                    case 1: {
                        this.addressDimension = n;
                        break;
                    }
                    case 17: {
                        this.addressDestination = n;
                        break;
                    }
                    case 33: {
                        this.addressSource = n;
                    }
                }
                n += 2;
            }
        } else {
            boolean bl = false;
            while (!bl) {
                switch (RomManager.StaticAccess.readByte(n++)) {
                    case 1: {
                        this.addressDimension = n;
                        n += 2;
                        break;
                    }
                    case 6: {
                        this.addressColumns = n++;
                        break;
                    }
                    case 17: {
                        this.addressDestination = n;
                        n += 2;
                        break;
                    }
                    case 33: {
                        this.addressSource = n;
                        n += 2;
                        break;
                    }
                    case 50: {
                        if (RomManager.StaticAccess.readWord(n) == 65535 && RomManager.StaticAccess.readByte(n - 3) == 62) {
                            this.addressBank = n - 2;
                        }
                        n += 2;
                        break;
                    }
                    case 195: 
                    case 205: {
                        int n2 = RomManager.StaticAccess.readWord(n);
                        if (n2 == 403 || n2 == 3649 || n2 == 9506) {
                            bl = true;
                            break;
                        }
                        this.addressDimension = 0;
                        this.addressColumns = 0;
                        this.addressDestination = 0;
                        this.addressSource = 0;
                        n += 2;
                    }
                }
            }
            if (this.addressBank == 0 || this.addressSource == 0 || this.addressDestination == 0) {
                System.err.println("Invalid nametable at " + Integer.toHexString(n).toUpperCase());
            }
        }
    }

    public int[] getVRAM() {
        final int[] nArray = new int[65536];
        RomManager.StaticAccess.copyFromROM(0, nArray, 0, 32768);
        RomManager.StaticAccess.loadBank2(nArray, this.getBank());
        final Z80 z80 = Z80Factory.create(nArray);
        final TMS9918A tMS9918A = new TMS9918A(262);
        int[] nArray2 = tMS9918A.getVRAM();
        z80.addOutputListener(new OutputListener(){

            @Override
            public void outputAvailable(int n, int n2, int n3) {
                if (n == 65535) {
                    RomManager.StaticAccess.loadBank2(nArray, n2);
                } else if (n >> 6 == 2) {
                    if (n2 < 0) {
                        z80.setInput(tMS9918A.readByte(n & 1, n3));
                    } else {
                        tMS9918A.processInput(n & 1, n2, n3);
                    }
                }
            }
        });
        tMS9918A.addOutputListener(new OutputListener(){

            @Override
            public void outputAvailable(int n, int n2, int n3) {
                if (n != 3) {
                    throw new IllegalStateException("Nametables should only write to VRAM");
                }
            }
        });
        int n = this.getColumns();
        int n2 = 0;
        while (n2 < n) {
            int n3 = (this.getDimension() & 0xFF) * (this.getDimension() >> 8);
            int n4 = this.getSource();
            if (n4 >= 32768) {
                n4 = 0x8000 | n4 & 0x3FFF;
            }
            z80.setHL(n4 + n2 * n3);
            z80.setDE(0x4000 | this.getDestination() + 2 * n2);
            z80.setBC(this.getDimension());
            z80.execute(this.addressLoadNameTable);
            ++n2;
        }
        if (this.end == 0) {
            this.end = (this.getSource() & 0xFC000 | z80.getHL() & 0x3FFF) - 1;
        }
        return nArray2;
    }

    private int getTileAddress(int n) {
        int n2 = (this.getDimension() & 0xFF) * (this.getDimension() >> 8);
        return this.getSource() + n / this.getColumns() * 2 + n % this.getColumns() * n2;
    }

    private int getFlagsAddress(int n) {
        return this.getTileAddress(n) + 1;
    }

    public int[] getTile(int n) {
        return new int[]{RomManager.StaticAccess.readByte(this.getTileAddress(n)), RomManager.StaticAccess.readByte(this.getFlagsAddress(n))};
    }

    public void setTile(int n, int n2) {
        if (((RomManager.StaticAccess.readByte(this.getFlagsAddress(n)) & 1) << 8 | RomManager.StaticAccess.readByte(this.getTileAddress(n))) != n2 && n2 >= 0 && n2 < 256) {
            TransactionManager.getInstance().addTransactionObject(this, n);
            this.writeByte(this.getTileAddress(n), n2 & 0xFF);
            this.writeByte(this.getFlagsAddress(n), RomManager.StaticAccess.readByte(this.getFlagsAddress(n)) & 1 | n2 >> 8 & 1);
        }
    }

    public void setTiles(int[][] nArray) {
        TransactionManager.getInstance().addTransactionObject(this, 0);
        int n = 0;
        while (n < nArray.length) {
            int n2 = 0;
            while (n2 < nArray[n].length) {
                this.writeByte(this.getTileAddress(n * this.getWidth() + n2), nArray[n][n2] & 0xFF);
                this.writeByte(this.getFlagsAddress(n * this.getWidth() + n2), RomManager.StaticAccess.readByte(this.getFlagsAddress(n * this.getWidth() + n2)) & 0xE0 | nArray[n][n2] >> 8);
                ++n2;
            }
            ++n;
        }
    }

    public void setFlags(int n, int n2) {
        if ((RomManager.StaticAccess.readByte(this.getFlagsAddress(n)) & 0xE0) != n2) {
            TransactionManager.getInstance().addTransactionObject(this, n);
            this.writeByte(this.getFlagsAddress(n), RomManager.StaticAccess.readByte(this.getFlagsAddress(n)) & 0xFFFFFF1F | n2);
        }
    }

    public void setPalette(int n, int n2) {
        if ((RomManager.StaticAccess.readByte(this.getFlagsAddress(n)) & 8) != n2 * 8) {
            TransactionManager.getInstance().addTransactionObject(this, n);
            this.writeByte(this.getFlagsAddress(n), RomManager.StaticAccess.readByte(this.getFlagsAddress(n)) & 0xFFFFFFF7 | n2 * 8);
        }
    }

    public void setPriority(int n, boolean bl) {
        int n2 = 0;
        if (bl) {
            n2 = 16;
        }
        if ((RomManager.StaticAccess.readByte(this.getFlagsAddress(n)) & 0x10) != n2) {
            TransactionManager.getInstance().addTransactionObject(this, n);
            this.writeByte(this.getFlagsAddress(n), RomManager.StaticAccess.readByte(this.getFlagsAddress(n)) & 0xFFFFFFEF | n2);
        }
    }

    public void flipH(int n) {
        TransactionManager.getInstance().addTransactionObject(this, n);
        RomManager.StaticAccess.flipBitInByte(this.getFlagsAddress(n), 1);
    }

    public void flipV(int n) {
        TransactionManager.getInstance().addTransactionObject(this, n);
        RomManager.StaticAccess.flipBitInByte(this.getFlagsAddress(n), 2);
    }

    public void startMoving() {
        TransactionManager.getInstance().addTransactionObject(this, -1);
    }

    public void moveTo(int n) {
        int n2 = this.getLength();
        int n3 = this.getSource();
        TransactionManager.getInstance().addTransactionObject(this, -1);
        int[] nArray = RomManager.StaticAccess.readBytes(new int[n2], n3);
        RomManager.StaticAccess.fill(n3, n3 + n2, 255);
        RomManager.StaticAccess.writeBytes(nArray, n);
        this.setSource(n);
    }

    public void setSource(int n) {
        TransactionManager.getInstance().addTransactionObject(this, -1);
        RomManager.getInstance().writeByte(this.addressSource, n & 0xFF);
        RomManager.getInstance().writeByte(this.addressSource + 1, 0x80 | n >> 8 & 0x3F);
        RomManager.getInstance().writeByte(this.addressBank, 0x80 | n / 16384);
    }

    public void setDestination(int n) {
        if (RomManager.StaticAccess.readByte(this.addressDestination) != (n & 0xFF) || RomManager.StaticAccess.readByte(this.addressDestination + 1) != (0x78 | n >> 8)) {
            TransactionManager.getInstance().addTransactionObject(this, -1);
            RomManager.getInstance().writeByte(this.addressDestination, n & 0xFF);
            RomManager.getInstance().writeByte(this.addressDestination + 1, 0x78 | n >> 8);
        }
    }

    public int getBank() {
        return RomManager.StaticAccess.readByte(this.addressBank) & 0x7F;
    }

    public int getSource() {
        int n = RomManager.StaticAccess.readWord(this.addressSource);
        if (n >= 32768) {
            n = RomManager.RESOLVE_ADDRESS(n, this.getBank());
        }
        return n;
    }

    public int getDestination() {
        return RomManager.StaticAccess.readWord(this.addressDestination) & 0x3FFF;
    }

    private int getDimension() {
        return RomManager.StaticAccess.readWord(this.addressDimension);
    }

    private int getColumns() {
        if (this.addressColumns == 0 || RomManager.StaticAccess.readByte(this.addressColumns) == 0) {
            return 1;
        }
        return RomManager.StaticAccess.readByte(this.addressColumns);
    }

    public void setWidth(int n) {
        if (this.getColumns() != 1) {
            throw new UnsupportedOperationException("Cannot change width of a multi-column nametable.");
        }
        if (n != this.getWidth()) {
            TransactionManager.getInstance().addTransactionObject(this, 0);
            RomManager.getInstance().writeByte(this.addressDimension, n << 1);
        }
    }

    public void setHeight(int n) {
        if (n != this.getHeight()) {
            TransactionManager.getInstance().addTransactionObject(this, 0);
            RomManager.getInstance().writeByte(this.addressDimension + 1, n);
        }
    }

    public int getWidth() {
        return this.getColumns() * ((this.getDimension() & 0xFF) >> 1);
    }

    public int getHeight() {
        return this.getDimension() >> 8 == 0 ? 256 : this.getDimension() >> 8;
    }

    public int getLength() {
        return this.getHeight() * this.getWidth() * 2;
    }

    public int getSize() {
        return this.getLength();
    }

    protected int writeByte(int n, int n2) {
        if (n < this.getSource() || n >= this.getSource() + this.getSize()) {
            throw new IllegalArgumentException(String.valueOf(Integer.toHexString(n)) + " is outside of current nametable.");
        }
        n2 = RomManager.getInstance().writeByte(n, n2);
        if (!this.isValid()) {
            throw new IllegalStateException("Failed to write to " + Integer.toHexString(n) + " because the nametable starting from " + Integer.toHexString(this.getSource()) + " are invalid.");
        }
        return n2;
    }

    @Override
    public final String getChangeName() {
        return TextProvider.get("ChangeNameTable");
    }

    @Override
    public final void fireChangeOccurred(Change change) {
        for (ChangeListener changeListener : this.listeners) {
            changeListener.changeOccurred(change);
        }
    }

    @Override
    public final void addChangeListener(ChangeListener changeListener) {
        if (!this.listeners.contains(changeListener)) {
            this.listeners.addFirst(changeListener);
        }
    }

    @Override
    public final void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    public String toString() {
        if (this.end == 0) {
            this.getVRAM();
        }
        return "NameTable@" + Integer.toHexString(this.getSource()).toUpperCase() + "-" + Integer.toHexString(this.end).toUpperCase();
    }
}

