/*
 * Decompiled with CFR 0.152.
 */
package data;

import changes.Changable;
import changes.Change;
import changes.ChangeListener;
import editors.TextProvider;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import rom.RomManager;
import transactions.TransactionManager;

public class Physics
implements Changable {
    private static final List<?> classes = Arrays.asList(AlexPhysics.class, HopperPhysics.class, RollingRockPhysics.class, MonsterBirdPhysics.class, SmallPoisonousFishPhysics.class, KillerFishPhysics.class, ScorpionAndFlamePhysics.class, ShockingWavesOfDestructionPhysics.class, MermanPhysics.class, VehicleMissilePhysics.class, BatPhysics.class, VinePhysics.class, FlyingFishPhysics.class, MonsterFrogPhysics.class, SeahorsePhysics.class);
    private final LinkedList<ChangeListener> listeners = new LinkedList();

    public boolean isValid(CharacterPhysics characterPhysics) {
        if (characterPhysics.getSize() == 2) {
            int n = RomManager.StaticAccess.readByte(characterPhysics.getAddress());
            return n == 1 || n == 17 || n == 33 || Physics.isSplitWord(characterPhysics);
        }
        if (characterPhysics instanceof CirclingFlamePhysics) {
            return RomManager.StaticAccess.readWord(characterPhysics.getAddress()) == 14045;
        }
        return RomManager.StaticAccess.readByte(characterPhysics.getAddress()) == 254 || RomManager.StaticAccess.readWord(characterPhysics.getAddress()) == 14045 && (RomManager.StaticAccess.readByte(characterPhysics.getAddress() + 2) == 27 || RomManager.StaticAccess.readByte(characterPhysics.getAddress() + 2) == 24);
    }

    private static boolean isSplitWord(CharacterPhysics characterPhysics) {
        if (characterPhysics.getSize() != 2) {
            return false;
        }
        return RomManager.StaticAccess.readWord(characterPhysics.getAddress()) == 14045 && RomManager.StaticAccess.readWord(characterPhysics.getAddress() + 4) == 14045;
    }

    public void setValue(CharacterPhysics characterPhysics, int n) {
        if (!this.isValid(characterPhysics)) {
            throw new IllegalArgumentException("Cannot set value");
        }
        TransactionManager.getInstance().addTransactionObject(this, Physics.getIndex(characterPhysics));
        if (characterPhysics.getSize() == 2) {
            if (Physics.isSplitWord(characterPhysics)) {
                if (RomManager.StaticAccess.readByte(characterPhysics.getAddress() + 2) == 16 || RomManager.StaticAccess.readByte(characterPhysics.getAddress() + 2) == 18) {
                    RomManager.StaticAccess.writeByte(characterPhysics.getAddress() + 3, n >> 8);
                    RomManager.StaticAccess.writeByte(characterPhysics.getAddress() + 7, n & 0xFF);
                } else {
                    RomManager.StaticAccess.writeByte(characterPhysics.getAddress() + 7, n >> 8);
                    RomManager.StaticAccess.writeByte(characterPhysics.getAddress() + 3, n & 0xFF);
                }
            } else {
                RomManager.StaticAccess.writeWord(characterPhysics.getAddress() + 1, n);
            }
        } else if (RomManager.StaticAccess.readByte(characterPhysics.getAddress()) == 254) {
            RomManager.StaticAccess.writeByte(characterPhysics.getAddress() + 1, n);
        } else {
            RomManager.StaticAccess.writeByte(characterPhysics.getAddress() + 3, n);
        }
    }

    private static int getIndex(CharacterPhysics characterPhysics) {
        return classes.indexOf(characterPhysics.getClass());
    }

    public int getValue(CharacterPhysics characterPhysics) {
        if (!this.isValid(characterPhysics)) {
            return 0;
        }
        if (characterPhysics.getSize() == 2) {
            if (Physics.isSplitWord(characterPhysics)) {
                if (RomManager.StaticAccess.readByte(characterPhysics.getAddress() + 2) == 16 || RomManager.StaticAccess.readByte(characterPhysics.getAddress() + 2) == 18) {
                    return RomManager.StaticAccess.readByte(characterPhysics.getAddress() + 3) << 8 | RomManager.StaticAccess.readByte(characterPhysics.getAddress() + 7);
                }
                return RomManager.StaticAccess.readByte(characterPhysics.getAddress() + 7) << 8 | RomManager.StaticAccess.readByte(characterPhysics.getAddress() + 3);
            }
            return RomManager.StaticAccess.readWord(characterPhysics.getAddress() + 1);
        }
        if (RomManager.StaticAccess.readByte(characterPhysics.getAddress()) == 254) {
            return RomManager.StaticAccess.readByte(characterPhysics.getAddress() + 1);
        }
        return RomManager.StaticAccess.readByte(characterPhysics.getAddress() + 3);
    }

    @Override
    public final String getChangeName() {
        return TextProvider.get("ChangePhysics");
    }

    @Override
    public final void fireChangeOccurred(Change change) {
        for (ChangeListener changeListener : this.listeners) {
            changeListener.changeOccurred(change);
        }
    }

    @Override
    public final void addChangeListener(ChangeListener changeListener) {
        if (!this.listeners.contains(changeListener)) {
            this.listeners.addFirst(changeListener);
        }
    }

    @Override
    public final void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    public static enum AlexPhysics implements CharacterPhysics
    {
        WALKING_LEFT_ACCELERATION(11219),
        WALKING_LEFT_MAX_VELOCITY(11222),
        WALKING_LEFT_DECELERATION(11250),
        WALKING_LEFT_OPPOSITE_ACCELERATION(11289),
        WALKING_RIGHT_ACCELERATION(11363),
        WALKING_RIGHT_MAX_VELOCITY(11366),
        WALKING_RIGHT_DECELERATION(11394),
        WALKING_RIGHT_OPPOSITE_ACCELERATION(11413),
        SQUAT_LEFT_MAX_VELOCITY(12042),
        SQUAT_LEFT_DECELERATION(11968),
        SQUAT_RIGHT_MAX_VELOCITY(12004),
        SQUAT_RIGHT_DECELERATION(12087),
        AIRBORNE_LEFT_ACCELERATION(11722),
        AIRBORNE_LEFT_MAX_VELOCITY(11725),
        AIRBORNE_LEFT_DECELERATION(11757),
        AIRBORNE_RIGHT_ACCELERATION(11829),
        AIRBORNE_RIGHT_MAX_VELOCITY(11832),
        AIRBORNE_RIGHT_DECELERATION(11866),
        JUMP_DURATION(11443, 1, false),
        GRAVITY(14955),
        SWIMMING_BUOYANCY(13728),
        SWIMMING_BUOYANCY_MAX_VELOCITY(13725),
        WATER_SURFACE_DECELERATION(13859),
        WATER_SURFACE_DECELERATION_FAST(13851),
        SWIMMING_UP_ACCELERATION(13737),
        SWIMMING_UP_MAX_VELOCITY(13734),
        SWIMMING_DOWN_ACCELERATION(13845),
        SWIMMING_DOWN_MAX_VELOCITY(13842),
        SWIMMING_LEFT_ACCELERATION(13942),
        SWIMMING_LEFT_MAX_VELOCITY(13945),
        SWIMMING_LEFT_OPPOSITE_ACCELERATION(13964),
        SWIMMING_LEFT_FAST_ACCELERATION(13951),
        SWIMMING_LEFT_FAST_MAX_VELOCITY(13954),
        SWIMMING_LEFT_FAST_OPPOSITE_ACCELERATION(13972),
        SWIMMING_RIGHT_ACCELERATION(14027),
        SWIMMING_RIGHT_MAX_VELOCITY(14030),
        SWIMMING_RIGHT_FAST_ACCELERATION(14036),
        SWIMMING_RIGHT_FAST_MAX_VELOCITY(14039),
        PETICOPTER_UP(14447),
        PETICOPTER_DOWN(14331),
        PETICOPTER_LEFT(14287),
        PETICOPTER_RIGHT(14217),
        BOAT_DECELERATION(12524),
        BOAT_MIN_VELOCITY(12527),
        BOAT_ACCELERATION(12512),
        BOAT_MAX_VELOCITY(12515),
        MOTORCYCLE_DECELERATION(12298),
        MOTORCYCLE_MIN_VELOCITY(12301),
        MOTORCYCLE_ACCELERATION(12286),
        MOTORCYCLE_MAX_VELOCITY(12289);

        private final int address;
        private final int size;
        private final boolean signed;

        private AlexPhysics(int n2) {
            this(n2, 2, true);
        }

        private AlexPhysics(int n2, int n3, boolean bl) {
            this.address = n2;
            this.size = n3;
            this.signed = bl;
        }

        @Override
        public int getAddress() {
            return this.address;
        }

        @Override
        public int getSize() {
            return this.size;
        }

        @Override
        public boolean isSigned() {
            return this.signed;
        }
    }

    public static enum BatPhysics implements CharacterPhysics
    {
        LEFT_VELOCITY(20253),
        RIGHT_VELOCITY(20283);

        private final int address;

        private BatPhysics(int n2) {
            this.address = n2;
        }

        @Override
        public int getAddress() {
            return this.address;
        }

        @Override
        public int getSize() {
            return 2;
        }

        @Override
        public boolean isSigned() {
            return true;
        }
    }

    public static interface CharacterPhysics {
        public int getAddress();

        public int getSize();

        public boolean isSigned();
    }

    public static enum CirclingFlamePhysics implements CharacterPhysics
    {
        RADIUS(23986, 1),
        VELOCITY(24048);

        private final int address;
        private final int size;

        private CirclingFlamePhysics(int n2) {
            this(n2, 2);
        }

        private CirclingFlamePhysics(int n2, int n3) {
            this.address = n2;
            this.size = n3;
        }

        @Override
        public int getAddress() {
            return this.address;
        }

        @Override
        public int getSize() {
            return this.size;
        }

        @Override
        public boolean isSigned() {
            return false;
        }
    }

    public static enum FlyingFishPhysics implements CharacterPhysics
    {
        JUMP_VELOCITY(24433),
        HORIZONTAL_VELOCITY(24425),
        GRAVITY1(24441, 1),
        GRAVITY2(24452, 1);

        private final int address;
        private final int size;

        private FlyingFishPhysics(int n2) {
            this(n2, 2);
        }

        private FlyingFishPhysics(int n2, int n3) {
            this.address = n2;
            this.size = n3;
        }

        @Override
        public int getAddress() {
            return this.address;
        }

        @Override
        public int getSize() {
            return this.size;
        }

        @Override
        public boolean isSigned() {
            return true;
        }
    }

    public static enum HopperPhysics implements CharacterPhysics
    {
        INITIAL_JUMP_VELOCITY(25478),
        JUMP_VELOCITY(25554),
        HORIZONTAL_VELOCITY(25470),
        GRAVITY(25568);

        private final int address;

        private HopperPhysics(int n2) {
            this.address = n2;
        }

        @Override
        public int getAddress() {
            return this.address;
        }

        @Override
        public int getSize() {
            return 2;
        }

        @Override
        public boolean isSigned() {
            return true;
        }
    }

    public static enum KillerFishPhysics implements CharacterPhysics
    {
        LEFT_VELOCITY(20874),
        RIGHT_VELOCITY(20905);

        private final int address;

        private KillerFishPhysics(int n2) {
            this.address = n2;
        }

        @Override
        public int getAddress() {
            return this.address;
        }

        @Override
        public int getSize() {
            return 2;
        }

        @Override
        public boolean isSigned() {
            return true;
        }
    }

    public static enum LightningCloudPhysics implements CharacterPhysics
    {
        HORIZONTAL_VELOCITY(24283);

        private final int address;

        private LightningCloudPhysics(int n2) {
            this.address = n2;
        }

        @Override
        public int getAddress() {
            return this.address;
        }

        @Override
        public int getSize() {
            return 2;
        }

        @Override
        public boolean isSigned() {
            return true;
        }
    }

    public static enum MermanPhysics implements CharacterPhysics
    {
        VERTICAL_VELOCITY(20042),
        DURATION(20068, 1, false);

        private final int address;
        private final int size;
        private final boolean signed;

        private MermanPhysics(int n2) {
            this(n2, 2, true);
        }

        private MermanPhysics(int n2, int n3, boolean bl) {
            this.address = n2;
            this.size = n3;
            this.signed = bl;
        }

        @Override
        public int getAddress() {
            return this.address;
        }

        @Override
        public int getSize() {
            return this.size;
        }

        @Override
        public boolean isSigned() {
            return this.signed;
        }
    }

    public static enum MonkeyPhysics implements CharacterPhysics
    {
        THROW_DURATION(21951);

        private final int address;

        private MonkeyPhysics(int n2) {
            this.address = n2;
        }

        @Override
        public int getAddress() {
            return this.address;
        }

        @Override
        public int getSize() {
            return 1;
        }

        @Override
        public boolean isSigned() {
            return false;
        }
    }

    public static enum MonsterBirdPhysics implements CharacterPhysics
    {
        LEFT_VELOCITY(20567),
        RIGHT_VELOCITY(20648);

        private final int address;

        private MonsterBirdPhysics(int n2) {
            this.address = n2;
        }

        @Override
        public int getAddress() {
            return this.address;
        }

        @Override
        public int getSize() {
            return 2;
        }

        @Override
        public boolean isSigned() {
            return true;
        }
    }

    public static enum MonsterFrogPhysics implements CharacterPhysics
    {
        JUMP_VELOCITY(22290),
        GRAVITY(22329);

        private final int address;

        private MonsterFrogPhysics(int n2) {
            this.address = n2;
        }

        @Override
        public int getAddress() {
            return this.address;
        }

        @Override
        public int getSize() {
            return 2;
        }

        @Override
        public boolean isSigned() {
            return true;
        }
    }

    public static enum OxPhysics implements CharacterPhysics
    {
        HORIZONTAL_VELOCITY(23645);

        private final int address;

        private OxPhysics(int n2) {
            this.address = n2;
        }

        @Override
        public int getAddress() {
            return this.address;
        }

        @Override
        public int getSize() {
            return 2;
        }

        @Override
        public boolean isSigned() {
            return true;
        }
    }

    public static enum RollingRockPhysics implements CharacterPhysics
    {
        LEFT_VELOCITY(25325),
        RIGHT_VELOCITY(25305),
        GRAVITY(25391);

        private final int address;

        private RollingRockPhysics(int n2) {
            this.address = n2;
        }

        @Override
        public int getAddress() {
            return this.address;
        }

        @Override
        public int getSize() {
            return 2;
        }

        @Override
        public boolean isSigned() {
            return true;
        }
    }

    public static enum ScorpionAndFlamePhysics implements CharacterPhysics
    {
        LEFT_VELOCITY(24215),
        RIGHT_VELOCITY(24152);

        private final int address;

        private ScorpionAndFlamePhysics(int n2) {
            this.address = n2;
        }

        @Override
        public int getAddress() {
            return this.address;
        }

        @Override
        public int getSize() {
            return 2;
        }

        @Override
        public boolean isSigned() {
            return true;
        }
    }

    public static enum SeahorsePhysics implements CharacterPhysics
    {
        LEFT_VELOCITY(22565),
        RIGHT_VELOCITY(22707);

        private final int address;

        private SeahorsePhysics(int n2) {
            this.address = n2;
        }

        @Override
        public int getAddress() {
            return this.address;
        }

        @Override
        public int getSize() {
            return 2;
        }

        @Override
        public boolean isSigned() {
            return true;
        }
    }

    public static enum ShockingWavesOfDestructionPhysics implements CharacterPhysics
    {
        LEFT_VELOCITY(18667),
        RIGHT_VELOCITY(18675);

        private final int address;

        private ShockingWavesOfDestructionPhysics(int n2) {
            this.address = n2;
        }

        @Override
        public int getAddress() {
            return this.address;
        }

        @Override
        public int getSize() {
            return 2;
        }

        @Override
        public boolean isSigned() {
            return true;
        }
    }

    public static enum SmallPoisonousFishPhysics implements CharacterPhysics
    {
        LEFT_VELOCITY(20737),
        RIGHT_VELOCITY(20772);

        private final int address;

        private SmallPoisonousFishPhysics(int n2) {
            this.address = n2;
        }

        @Override
        public int getAddress() {
            return this.address;
        }

        @Override
        public int getSize() {
            return 2;
        }

        @Override
        public boolean isSigned() {
            return true;
        }
    }

    public static enum VehicleMissilePhysics implements CharacterPhysics
    {
        LEFT_VELOCITY(17518),
        RIGHT_VELOCITY(17526);

        private final int address;

        private VehicleMissilePhysics(int n2) {
            this.address = n2;
        }

        @Override
        public int getAddress() {
            return this.address;
        }

        @Override
        public int getSize() {
            return 2;
        }

        @Override
        public boolean isSigned() {
            return true;
        }
    }

    public static enum VinePhysics implements CharacterPhysics
    {
        VERTICAL_VELOCITY(20494),
        DURATION(20512, 1, false);

        private final int address;
        private final int size;
        private final boolean signed;

        private VinePhysics(int n2) {
            this(n2, 2, true);
        }

        private VinePhysics(int n2, int n3, boolean bl) {
            this.address = n2;
            this.size = n3;
            this.signed = bl;
        }

        @Override
        public int getAddress() {
            return this.address;
        }

        @Override
        public int getSize() {
            return this.size;
        }

        @Override
        public boolean isSigned() {
            return this.signed;
        }
    }
}

