/*
 * Decompiled with CFR 0.152.
 */
package widgets;

import changes.Change;
import changes.ChangeListener;
import data.Palette;
import data.SpriteContainer;
import data.Tileset;
import java.awt.Color;
import java.awt.image.BufferedImage;
import mastersystem.Renderer;
import widgets.ScalableIcon;

public class SpriteIcon
extends ScalableIcon {
    private Color[] colors = new Color[32];
    private SpriteContainer sprite;
    private Palette palette;
    private Tileset tileset;
    private final ChangeListener paletteChangeListener = new ChangeListener(){

        @Override
        public void changeOccurred(Change change) {
            int n = change.getData(SpriteIcon.this.palette);
            if (n < 0) {
                int n2 = -n - 1;
                if (n2 >= 1) {
                    int n3 = 16;
                    while (n3 < 32) {
                        int n4 = SpriteIcon.this.palette.getColors()[n3];
                        int n5 = (n4 & 0x30) >> 4;
                        int n6 = (n4 & 0xC) >> 2;
                        int n7 = n4 & 3;
                        ((SpriteIcon)SpriteIcon.this).colors[n3] = new Color(n7 * 255 / 3, n6 * 255 / 3, n5 * 255 / 3);
                        ++n3;
                    }
                }
            } else if (n > 16) {
                int n8 = SpriteIcon.this.palette.getColors()[n];
                int n9 = (n8 & 0x30) >> 4;
                int n10 = (n8 & 0xC) >> 2;
                int n11 = n8 & 3;
                ((SpriteIcon)SpriteIcon.this).colors[n] = new Color(n11 * 255 / 3, n10 * 255 / 3, n9 * 255 / 3);
                SpriteIcon.this.update();
            }
        }
    };
    private final ChangeListener spriteChangeListener = new ChangeListener(){

        @Override
        public void changeOccurred(Change change) {
            SpriteIcon.this.update();
        }
    };
    private final ChangeListener tilesetChangeListener = new ChangeListener(){

        @Override
        public void changeOccurred(Change change) {
            SpriteIcon.this.update();
        }
    };

    public void setSprite(SpriteContainer spriteContainer, Palette palette, Tileset tileset) {
        if (this.palette != null && this.palette != palette) {
            this.palette.removeChangeListener(this.paletteChangeListener);
        }
        if (this.sprite != null && this.sprite != spriteContainer) {
            this.sprite.removeChangeListener(this.spriteChangeListener);
        }
        if (this.tileset != null && this.tileset != tileset) {
            this.tileset.removeChangeListener(this.tilesetChangeListener);
        }
        this.sprite = spriteContainer;
        this.palette = palette;
        this.tileset = tileset;
        int n = 0;
        int[] nArray = palette.getColors();
        int n2 = nArray.length;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = nArray[n3];
            int n5 = (n4 & 0x30) >> 4;
            int n6 = (n4 & 0xC) >> 2;
            int n7 = n4 & 3;
            this.colors[n++] = new Color(n7 * 255 / 3, n6 * 255 / 3, n5 * 255 / 3);
            ++n3;
        }
        palette.addChangeListener(this.paletteChangeListener);
        spriteContainer.addChangeListener(this.spriteChangeListener);
        tileset.addChangeListener(this.tilesetChangeListener);
        this.update();
    }

    @Override
    protected BufferedImage getBaseImage() {
        if (this.image == null && this.sprite != null) {
            this.update();
        }
        return super.getBaseImage();
    }

    @Override
    protected void update() {
        int n;
        int n2;
        int n3 = 256;
        int n4 = 0;
        int n5 = 256;
        int n6 = 0;
        int[] nArray = this.sprite.getVRAM(this.sprite.getSpriteCount() - 1, this.tileset);
        int[] nArray2 = this.sprite.getSAT(this.sprite.getSpriteCount() - 1);
        int n7 = 0;
        while (n7 < 64 && nArray2[n7] != 208) {
            n2 = nArray2[n7] + 1;
            if (n2 >= 240) {
                n2 -= 256;
            }
            n = nArray2[0x80 | n7 << 1];
            if (n2 < n3) {
                n3 = n2;
            }
            if (n2 + 8 > n4) {
                n4 = n2 + 8;
            }
            if (n < n5) {
                n5 = n;
            }
            if (n + 8 > n6) {
                n6 = n + 8;
            }
            ++n7;
        }
        this.image = new BufferedImage(n6 - n5, n4 - n3, 2);
        n7 = 0;
        while (n7 < 64 && nArray2[n7] != 208) {
            n2 = nArray2[n7] + 1;
            if (n2 >= 240) {
                n2 -= 256;
            }
            n = nArray2[0x80 | n7 << 1];
            int n8 = nArray2[0x80 | n7 << 1 | 1];
            Renderer.renderSpriteCharacter(nArray, n8, n - n5, n2 - n3, this.colors, this.image);
            ++n7;
        }
        super.update();
    }
}

