/*
 * Decompiled with CFR 0.152.
 */
package miracleworld.data;

import changes.Change;
import data.MetaTileset;
import data.Tileset;
import java.util.Arrays;
import miracleworld.MiracleWorldDataModel;
import miracleworld.MiracleWorldEditorModel;
import rom.RomManager;
import transactions.TransactionManager;

public class MiracleWorldMetaTileset
extends MetaTileset {
    private final int address;
    private final int addressLevelBank;
    private int bank;
    private boolean moving;

    public MiracleWorldMetaTileset(int n, int n2) {
        this.address = n;
        this.addressLevelBank = n2;
        this.updateBank();
    }

    private int getBank() {
        if (!this.moving) {
            this.updateBank();
        }
        return this.bank;
    }

    @Override
    public int getMetaTileWidth() {
        return 16;
    }

    @Override
    public int getMetaTileHeight() {
        return 16;
    }

    @Override
    public int getNumberOfMetaTiles() {
        return 256;
    }

    public boolean moveTo(int n) {
        if (this.moving || !MiracleWorldEditorModel.moveMetaTilesets()) {
            return false;
        }
        int n2 = RomManager.StaticAccess.readByte(n);
        int n3 = 0;
        while (n3 < MiracleWorldMetaTileset.getSize()) {
            if (RomManager.StaticAccess.readByte(n + n3) != n2) {
                throw new RuntimeException("moveMetaTileset: " + Integer.toHexString(n + n3) + " isn't free: " + Integer.toHexString(RomManager.StaticAccess.readByte(n + n3)) + " expected: " + Integer.toHexString(n2));
            }
            ++n3;
        }
        try {
            this.moving = true;
            n3 = n;
            int n4 = n + 512;
            int n5 = 0;
            while (n5 < 256) {
                int[] nArray = this.getMetaTile(n5);
                if (!this.isValid(n5)) {
                    Arrays.fill(nArray, 0);
                }
                RomManager.StaticAccess.writeWord(n3, 0x8000 | n4 & 0x3FFF);
                n3 += 2;
                RomManager.StaticAccess.writeBytes(nArray, n4);
                n4 += 8;
                ++n5;
            }
            if (this.getSource() != 81920 && this.getSource() != 82432) {
                this.clear();
            }
            this.setMetaTilesetAddress(0x8000 | n & 0x3FFF);
            return true;
        }
        finally {
            this.moving = false;
        }
    }

    private void clear() {
        int n = 0;
        while (n < 256) {
            int n2 = this.getMetaTileAddress(n);
            RomManager.StaticAccess.fill(n2, n2 + 8, 255);
            ++n;
        }
        n = this.getSource();
        RomManager.StaticAccess.fill(n, n + 512, 255);
    }

    private void setMetaTilesetAddress(int n) {
        if (RomManager.StaticAccess.readByte(this.address + 1) != n >> 8 || RomManager.StaticAccess.readByte(this.address) != (n & 0xFF)) {
            TransactionManager.getInstance().addTransactionObject(this, -1);
            RomManager.StaticAccess.writeWord(this.address, n);
        }
        this.updateBank();
    }

    public boolean isLevelBank() {
        return this.bank == RomManager.StaticAccess.readByte(this.addressLevelBank);
    }

    public void updateBank() {
        this.bank = MiracleWorldDataModel.hasMetaTilesetsPerLevel() ? RomManager.StaticAccess.readByte(this.addressLevelBank) : 133;
    }

    @Override
    public int getSource() {
        return RomManager.RESOLVE_ADDRESS(RomManager.StaticAccess.readWord(this.address), this.getBank());
    }

    public static int getSize() {
        return 2560;
    }

    @Override
    public int[][] getMetaTiles() {
        int[][] nArray = new int[this.getNumberOfMetaTiles()][this.getSizeOfMetaTile()];
        int n = 0;
        while (n < nArray.length) {
            if (this.isValid(n)) {
                RomManager.StaticAccess.readBytes(nArray[n], this.getMetaTileAddress(n));
            }
            ++n;
        }
        return nArray;
    }

    @Override
    public int[] getMetaTile(int n) {
        return RomManager.StaticAccess.readBytes(new int[this.getSizeOfMetaTile()], this.getMetaTileAddress(n));
    }

    @Override
    protected int getMetaTileAddress(int n) {
        return RomManager.RESOLVE_ADDRESS(RomManager.StaticAccess.readWord(this.getSource() + 2 * n), this.getBank());
    }

    @Override
    protected int getMetaTileSubTileAddress(int n, int n2) {
        return this.getMetaTileAddress(n) + 2 * n2;
    }

    @Override
    protected int getMetaTileSubTileFlagsAddress(int n, int n2) {
        return this.getMetaTileSubTileAddress(n, n2) + 1;
    }

    @Override
    public boolean isValid(int n) {
        int[] nArray = this.getMetaTile(n);
        int n2 = 0;
        while (n2 < nArray.length) {
            if (((nArray[n2 + 1] & 1) << 8 | nArray[n2]) >= 256) {
                return false;
            }
            if ((nArray[n2 + 1] & 0xE0) == 224 && nArray[n2] > 12) {
                return false;
            }
            n2 += 2;
        }
        return true;
    }

    @Override
    public boolean isUsable(int n, Tileset tileset) {
        int[] nArray = this.getMetaTile(n);
        int n2 = 0;
        while (n2 < nArray.length) {
            if (!tileset.contains((nArray[n2 + 1] & 1) << 8 | nArray[n2])) {
                return false;
            }
            if ((nArray[n2 + 1] & 0xE0) == 224 && nArray[n2] > 12) {
                return false;
            }
            n2 += 2;
        }
        return true;
    }

    public boolean isShopEntrance(int n) {
        int[] nArray = this.getMetaTile(n);
        int n2 = 0;
        while (n2 < nArray.length) {
            if (nArray[n2 + 1] >> 5 == 3 && nArray[n2] >= RomManager.StaticAccess.readByte(15573)) {
                return true;
            }
            n2 += 2;
        }
        return false;
    }

    public boolean isJarEntrance(int n) {
        int[] nArray = this.getMetaTile(n);
        int n2 = 0;
        while (n2 < nArray.length) {
            if (nArray[n2 + 1] >> 5 == 5 && nArray[n2] > 63) {
                return true;
            }
            n2 += 2;
        }
        return false;
    }

    @Override
    protected boolean ensureModifiable() {
        return MiracleWorldEditorModel.moveMetaTilesets();
    }

    @Override
    public final void fireChangeOccurred(Change change) {
        if (change.getData(this) == -1) {
            this.updateBank();
        }
        super.fireChangeOccurred(change);
    }
}

